#include "resource.hpp"

namespace Resource {
namespace GameBoy {
const unsigned char BootDMG0[256] = {
  49,254,255,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,119,62,252,224,
  71,33,4,1,229,17,203,0,26,19,190,32,107,35,125,254,52,32,245,6,25,120,134,35,5,32,251,134,32,90,209,33,
  16,128,26,205,169,0,205,170,0,19,123,254,52,32,243,62,24,33,47,153,14,12,50,61,40,9,13,32,249,17,236,255,
  25,24,241,103,62,100,87,224,66,62,145,224,64,4,30,2,205,188,0,14,19,36,124,30,131,254,98,40,6,30,193,254,
  100,32,6,123,226,12,62,135,226,240,66,144,224,66,21,32,221,5,32,105,22,32,24,214,62,145,224,64,30,20,205,188,
  0,240,71,238,255,224,71,24,243,79,6,4,197,203,17,23,193,203,17,23,5,32,245,34,35,34,35,201,14,12,240,68,
  254,144,32,250,13,32,247,29,32,242,201,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,
  137,0,14,220,204,110,230,221,221,217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,255,255,60,224,80,
};
const unsigned char BootDMG1[256] = {
  49,254,255,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,119,62,252,224,
  71,17,4,1,33,16,128,26,205,149,0,205,150,0,19,123,254,52,32,243,17,216,0,6,8,26,19,34,35,5,32,249,
  62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,103,62,100,87,224,66,62,145,224,64,4,
  30,2,14,12,240,68,254,144,32,250,13,32,247,29,32,242,14,19,36,124,30,131,254,98,40,6,30,193,254,100,32,6,
  123,226,12,62,135,226,240,66,144,224,66,21,32,210,5,32,79,22,32,24,203,79,6,4,197,203,17,23,193,203,17,23,
  5,32,245,34,35,34,35,201,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,
  220,204,110,230,221,221,217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,
  33,4,1,17,168,0,26,19,190,32,254,35,125,254,52,32,245,6,25,120,134,35,5,32,251,134,32,254,62,1,224,80,
};
const unsigned char BootMGB[256] = {
  49,254,255,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,119,62,252,224,
  71,17,4,1,33,16,128,26,205,149,0,205,150,0,19,123,254,52,32,243,17,216,0,6,8,26,19,34,35,5,32,249,
  62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,103,62,100,87,224,66,62,145,224,64,4,
  30,2,14,12,240,68,254,144,32,250,13,32,247,29,32,242,14,19,36,124,30,131,254,98,40,6,30,193,254,100,32,6,
  123,226,12,62,135,226,240,66,144,224,66,21,32,210,5,32,79,22,32,24,203,79,6,4,197,203,17,23,193,203,17,23,
  5,32,245,34,35,34,35,201,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,
  220,204,110,230,221,221,217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,
  33,4,1,17,168,0,26,19,190,32,254,35,125,254,52,32,245,6,25,120,134,35,5,32,251,134,32,254,62,255,224,80,
};
}
namespace GameBoyColor {
const unsigned char BootCGB0[2048] = {
  49,254,255,62,2,195,124,0,211,0,152,160,18,211,0,128,0,64,30,83,208,0,31,66,28,0,20,42,77,25,140,126,
  0,124,49,110,74,69,82,74,0,0,255,83,31,124,255,3,31,0,255,31,167,0,239,27,31,0,239,27,0,124,0,0,
  255,3,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,220,204,110,230,221,221,
  217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,88,67,224,112,62,252,
  224,71,205,117,2,205,0,2,38,208,205,3,2,33,0,254,14,160,175,34,13,32,252,17,4,1,33,16,128,76,26,226,
  12,205,187,3,205,188,3,19,123,254,52,32,241,17,114,0,6,8,26,19,34,35,5,32,249,205,229,3,62,1,224,79,
  62,145,224,64,33,178,152,6,78,14,68,205,134,2,175,224,79,14,128,33,66,0,6,24,242,12,190,32,254,35,5,32,
  247,33,52,1,6,25,120,134,44,5,32,251,134,32,254,205,17,3,24,2,0,0,205,208,5,175,224,112,62,17,224,80,
  33,0,128,175,34,203,108,40,251,201,42,18,19,13,32,250,201,229,33,15,255,203,134,203,70,40,252,225,201,17,0,255,
  33,3,208,14,15,62,48,18,62,32,18,26,47,161,203,55,71,62,16,18,26,47,161,176,79,126,169,230,240,71,42,169,
  161,176,50,71,121,119,62,48,18,201,62,128,224,104,224,106,14,107,42,226,5,32,251,74,9,67,14,105,42,226,5,32,
  251,201,197,213,229,33,0,216,6,1,22,63,30,64,205,74,2,225,209,193,201,62,128,224,38,224,17,62,243,224,18,224,
  37,62,119,224,36,201,205,17,2,205,98,2,121,254,56,32,20,229,175,224,79,33,167,153,62,56,34,60,254,63,32,250,
  62,1,224,79,225,197,229,33,67,1,203,126,204,137,5,225,193,205,17,2,121,214,48,210,251,2,121,254,1,202,251,2,
  125,254,209,40,33,197,6,3,14,1,22,3,126,230,248,177,34,21,32,248,12,121,254,6,32,240,17,17,0,25,5,32,
  231,17,161,255,25,193,4,120,30,131,254,98,40,6,30,193,254,100,32,7,123,224,19,62,135,224,20,250,2,208,254,0,
  40,10,61,234,2,208,121,254,1,202,134,2,13,194,134,2,201,14,38,205,63,3,205,17,2,205,98,2,13,32,244,205,
  17,2,62,1,224,79,205,51,3,205,54,3,175,224,79,205,51,3,201,33,8,0,17,81,255,14,5,205,10,2,201,197,
  213,229,33,64,216,14,32,126,230,31,254,31,40,1,60,87,42,7,7,7,230,7,71,58,7,7,7,230,24,176,254,31,
  40,1,60,15,15,15,71,230,224,178,34,120,230,3,95,126,15,15,230,31,254,31,40,1,60,7,7,179,34,13,32,199,
  225,209,193,201,14,0,26,230,240,203,73,40,2,203,55,71,35,126,176,34,26,230,15,203,73,32,2,203,55,71,35,126,
  176,34,19,203,65,40,13,213,17,248,255,203,73,40,3,17,8,0,25,209,12,121,254,24,32,204,201,71,213,22,4,88,
  203,16,23,203,19,23,21,32,246,209,34,35,34,35,201,62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,
  46,15,24,243,201,62,1,224,79,205,0,2,17,7,6,33,128,128,6,48,14,4,26,34,35,34,35,19,13,32,247,5,
  32,242,17,4,1,205,132,3,1,168,255,9,205,132,3,1,248,255,9,17,114,0,14,8,35,26,34,19,13,32,249,33,
  194,152,6,8,62,8,14,16,34,13,32,252,17,16,0,25,5,32,243,175,224,79,33,194,152,62,8,34,60,254,24,32,
  2,46,226,254,40,32,3,33,2,153,254,56,32,237,33,216,8,17,64,216,6,8,62,255,18,19,18,19,14,2,205,10,
  2,62,0,18,19,18,19,19,19,5,32,234,205,98,2,33,75,1,126,254,51,32,11,46,68,30,48,42,187,32,73,28,
  24,4,46,75,30,1,42,187,32,62,46,52,1,16,0,42,128,71,13,32,250,234,0,208,33,199,6,14,0,42,184,40,
  8,12,121,254,79,32,246,24,31,121,214,65,56,28,33,22,7,22,0,95,25,250,55,1,87,126,186,40,13,17,14,0,
  25,121,131,79,214,94,56,237,14,0,33,51,7,6,0,9,126,230,31,234,6,208,234,8,208,126,230,224,7,7,7,234,
  9,208,234,11,208,205,233,4,201,17,145,7,33,0,217,250,11,208,71,14,30,203,64,32,2,19,19,26,34,32,2,27,
  27,203,72,32,2,19,19,26,34,19,19,32,2,27,27,203,80,40,5,27,43,26,34,19,26,34,19,13,32,215,33,0,
  217,17,0,218,205,100,5,201,33,18,0,250,5,208,7,7,6,0,79,9,17,64,216,6,8,229,14,2,205,10,2,19,
  19,19,19,19,19,225,5,32,240,17,66,216,14,2,205,10,2,17,74,216,14,2,205,10,2,43,43,17,68,216,14,2,
  205,10,2,201,14,96,42,229,197,33,232,7,6,0,79,9,14,8,205,10,2,193,225,13,32,236,201,250,8,208,17,24,
  0,60,61,40,3,25,32,250,201,205,29,2,120,230,255,40,15,33,228,8,6,0,42,185,40,8,4,120,254,12,32,246,
  24,45,120,234,5,208,62,30,234,2,208,17,11,0,25,86,122,230,31,95,33,8,208,58,34,123,119,122,230,224,7,7,
  7,95,33,11,208,58,34,123,119,205,233,4,205,40,5,201,205,17,2,250,67,1,203,127,40,4,224,76,24,40,62,4,
  224,76,62,1,224,108,33,0,218,205,123,5,6,16,22,0,30,8,205,74,2,33,122,0,250,0,208,71,14,2,42,184,
  204,207,3,13,32,248,201,1,15,63,126,255,255,192,0,192,240,241,3,124,252,254,254,3,7,7,15,224,224,240,240,30,
  62,126,254,15,15,31,31,255,255,0,0,1,1,1,3,255,255,225,224,192,240,249,251,31,127,248,224,243,253,62,30,224,
  240,249,127,62,124,248,224,248,240,240,248,0,0,127,127,7,15,159,191,158,31,255,255,15,30,62,60,241,251,127,127,254,
  222,223,159,31,63,62,60,248,248,0,0,3,3,7,7,255,255,193,192,243,231,247,243,192,192,192,192,31,31,30,62,63,
  31,62,62,128,0,0,0,124,31,7,0,15,255,254,0,124,248,240,0,31,15,15,0,124,248,248,0,63,62,28,0,15,
  15,15,0,124,255,255,0,0,248,248,0,7,15,15,0,129,255,255,0,243,225,128,0,224,255,127,0,252,240,192,0,62,
  124,124,0,0,0,0,0,0,136,22,54,209,219,242,60,140,146,61,92,88,201,62,112,29,89,105,25,53,168,20,170,117,
  149,153,52,111,21,255,151,75,144,23,16,57,247,246,162,73,78,67,104,224,139,240,206,12,41,232,183,134,154,82,1,157,
  113,156,189,93,109,103,63,107,179,70,40,165,198,211,39,97,24,102,106,191,13,244,66,69,70,65,65,82,66,69,75,69,
  75,32,82,45,85,82,65,82,32,73,78,65,73,76,73,67,69,32,82,124,8,18,163,162,7,135,75,32,18,101,168,22,
  169,134,177,104,160,135,102,18,161,48,60,18,133,18,100,27,7,6,111,110,110,174,175,111,178,175,178,168,171,111,175,134,
  174,162,162,18,175,19,18,161,110,175,175,173,6,76,110,175,175,18,124,172,168,106,110,19,160,45,168,43,172,100,172,109,
  135,188,96,180,19,114,124,181,174,174,124,124,101,162,108,100,133,128,176,64,136,32,104,222,0,112,222,32,120,32,32,56,
  32,176,144,32,176,160,224,176,192,152,182,72,128,224,80,30,30,88,32,184,224,136,176,16,32,0,16,32,224,24,224,24,
  0,24,224,32,168,224,32,24,224,0,32,24,216,200,24,224,0,224,64,40,40,40,24,224,96,32,24,224,0,0,8,224,
  24,48,208,208,208,32,224,232,255,127,191,50,208,0,0,0,159,99,121,66,176,21,203,4,255,127,49,110,74,69,0,0,
  255,127,239,27,0,2,0,0,255,127,31,66,242,28,0,0,255,127,148,82,74,41,0,0,255,127,255,3,47,1,0,0,
  255,127,239,3,214,1,0,0,255,127,181,66,200,61,0,0,116,126,255,3,128,1,0,0,255,103,172,119,19,26,107,45,
  214,126,255,75,117,33,0,0,255,83,95,74,82,126,0,0,255,79,210,126,76,58,224,28,237,3,255,127,95,37,0,0,
  106,3,31,2,255,3,255,127,255,127,223,1,18,1,0,0,31,35,95,3,242,0,9,0,255,127,234,3,31,1,0,0,
  159,41,26,0,12,0,0,0,255,127,127,2,31,0,0,0,255,127,224,3,6,2,32,1,255,127,235,126,31,0,0,124,
  255,127,255,63,0,126,31,0,255,127,255,3,31,0,0,0,255,3,31,0,12,0,0,0,255,127,63,3,147,1,0,0,
  0,0,0,66,127,3,255,127,255,127,140,126,0,124,0,0,255,127,239,27,128,97,0,0,255,127,0,124,224,3,31,124,
  31,0,255,3,64,65,66,32,33,34,128,129,130,16,17,18,18,176,121,184,173,22,23,7,186,5,124,19,0,0,0,0,
};
const unsigned char BootCGB1[2048] = {
  49,254,255,62,2,195,124,0,211,0,152,160,18,211,0,128,0,64,30,83,208,0,31,66,28,0,20,42,77,25,140,126,
  0,124,49,110,74,69,82,74,0,0,255,83,31,124,255,3,31,0,255,31,167,0,239,27,31,0,239,27,0,124,0,0,
  255,3,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,220,204,110,230,221,221,
  217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,88,67,224,112,62,252,
  224,71,205,117,2,205,0,2,38,208,205,3,2,33,0,254,14,160,175,34,13,32,252,17,4,1,33,16,128,76,26,226,
  12,205,198,3,205,199,3,19,123,254,52,32,241,17,114,0,6,8,26,19,34,35,5,32,249,205,240,3,62,1,224,79,
  62,145,224,64,33,178,152,6,78,14,68,205,145,2,175,224,79,14,128,33,66,0,6,24,242,12,190,32,254,35,5,32,
  247,33,52,1,6,25,120,134,44,5,32,251,134,32,254,205,28,3,24,2,0,0,205,208,5,175,224,112,62,17,224,80,
  33,0,128,175,34,203,108,40,251,201,42,18,19,13,32,250,201,229,33,15,255,203,134,203,70,40,252,225,201,17,0,255,
  33,3,208,14,15,62,48,18,62,32,18,26,47,161,203,55,71,62,16,18,26,47,161,176,79,126,169,230,240,71,42,169,
  161,176,50,71,121,119,62,48,18,201,62,128,224,104,224,106,14,107,42,226,5,32,251,74,9,67,14,105,42,226,5,32,
  251,201,197,213,229,33,0,216,6,1,22,63,30,64,205,74,2,225,209,193,201,62,128,224,38,224,17,62,243,224,18,224,
  37,62,119,224,36,33,48,255,175,14,16,34,47,13,32,251,201,205,17,2,205,98,2,121,254,56,32,20,229,175,224,79,
  33,167,153,62,56,34,60,254,63,32,250,62,1,224,79,225,197,229,33,67,1,203,126,204,137,5,225,193,205,17,2,121,
  214,48,210,6,3,121,254,1,202,6,3,125,254,209,40,33,197,6,3,14,1,22,3,126,230,248,177,34,21,32,248,12,
  121,254,6,32,240,17,17,0,25,5,32,231,17,161,255,25,193,4,120,30,131,254,98,40,6,30,193,254,100,32,7,123,
  224,19,62,135,224,20,250,2,208,254,0,40,10,61,234,2,208,121,254,1,202,145,2,13,194,145,2,201,14,38,205,74,
  3,205,17,2,205,98,2,13,32,244,205,17,2,62,1,224,79,205,62,3,205,65,3,175,224,79,205,62,3,201,33,8,
  0,17,81,255,14,5,205,10,2,201,197,213,229,33,64,216,14,32,126,230,31,254,31,40,1,60,87,42,7,7,7,230,
  7,71,58,7,7,7,230,24,176,254,31,40,1,60,15,15,15,71,230,224,178,34,120,230,3,95,126,15,15,230,31,254,
  31,40,1,60,7,7,179,34,13,32,199,225,209,193,201,14,0,26,230,240,203,73,40,2,203,55,71,35,126,176,34,26,
  230,15,203,73,32,2,203,55,71,35,126,176,34,19,203,65,40,13,213,17,248,255,203,73,40,3,17,8,0,25,209,12,
  121,254,24,32,204,201,71,213,22,4,88,203,16,23,203,19,23,21,32,246,209,34,35,34,35,201,62,25,234,16,153,33,
  47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,201,62,1,224,79,205,0,2,17,7,6,33,128,128,14,192,26,
  34,35,34,35,19,13,32,247,17,4,1,205,143,3,1,168,255,9,205,143,3,1,248,255,9,17,114,0,14,8,35,26,
  34,19,13,32,249,33,194,152,6,8,62,8,14,16,34,13,32,252,17,16,0,25,5,32,243,175,224,79,33,194,152,62,
  8,34,60,254,24,32,2,46,226,254,40,32,3,33,2,153,254,56,32,237,33,216,8,17,64,216,6,8,62,255,18,19,
  18,19,14,2,205,10,2,62,0,18,19,18,19,19,19,5,32,234,205,98,2,33,75,1,126,254,51,32,11,46,68,30,
  48,42,187,32,73,28,24,4,46,75,30,1,42,187,32,62,46,52,1,16,0,42,128,71,13,32,250,234,0,208,33,199,
  6,14,0,42,184,40,8,12,121,254,79,32,246,24,31,121,214,65,56,28,33,22,7,22,0,95,25,250,55,1,87,126,
  186,40,13,17,14,0,25,121,131,79,214,94,56,237,14,0,33,51,7,6,0,9,126,230,31,234,8,208,126,230,224,7,
  7,7,234,11,208,205,233,4,201,17,145,7,33,0,217,250,11,208,71,14,30,203,64,32,2,19,19,26,34,32,2,27,
  27,203,72,32,2,19,19,26,34,19,19,32,2,27,27,203,80,40,5,27,43,26,34,19,26,34,19,13,32,215,33,0,
  217,17,0,218,205,100,5,201,33,18,0,250,5,208,7,7,6,0,79,9,17,64,216,6,8,229,14,2,205,10,2,19,
  19,19,19,19,19,225,5,32,240,17,66,216,14,2,205,10,2,17,74,216,14,2,205,10,2,43,43,17,68,216,14,2,
  205,10,2,201,14,96,42,229,197,33,232,7,6,0,79,9,14,8,205,10,2,193,225,13,32,236,201,250,8,208,17,24,
  0,60,61,40,3,25,32,250,201,205,29,2,120,230,255,40,15,33,228,8,6,0,42,185,40,8,4,120,254,12,32,246,
  24,45,120,234,5,208,62,30,234,2,208,17,11,0,25,86,122,230,31,95,33,8,208,58,34,123,119,122,230,224,7,7,
  7,95,33,11,208,58,34,123,119,205,233,4,205,40,5,201,205,17,2,250,67,1,203,127,40,4,224,76,24,40,62,4,
  224,76,62,1,224,108,33,0,218,205,123,5,6,16,22,0,30,8,205,74,2,33,122,0,250,0,208,71,14,2,42,184,
  204,218,3,13,32,248,201,1,15,63,126,255,255,192,0,192,240,241,3,124,252,254,254,3,7,7,15,224,224,240,240,30,
  62,126,254,15,15,31,31,255,255,0,0,1,1,1,3,255,255,225,224,192,240,249,251,31,127,248,224,243,253,62,30,224,
  240,249,127,62,124,248,224,248,240,240,248,0,0,127,127,7,15,159,191,158,31,255,255,15,30,62,60,241,251,127,127,254,
  222,223,159,31,63,62,60,248,248,0,0,3,3,7,7,255,255,193,192,243,231,247,243,192,192,192,192,31,31,30,62,63,
  31,62,62,128,0,0,0,124,31,7,0,15,255,254,0,124,248,240,0,31,15,15,0,124,248,248,0,63,62,28,0,15,
  15,15,0,124,255,255,0,0,248,248,0,7,15,15,0,129,255,255,0,243,225,128,0,224,255,127,0,252,240,192,0,62,
  124,124,0,0,0,0,0,0,136,22,54,209,219,242,60,140,146,61,92,88,201,62,112,29,89,105,25,53,168,20,170,117,
  149,153,52,111,21,255,151,75,144,23,16,57,247,246,162,73,78,67,104,224,139,240,206,12,41,232,183,134,154,82,1,157,
  113,156,189,93,109,103,63,107,179,70,40,165,198,211,39,97,24,102,106,191,13,244,66,69,70,65,65,82,66,69,75,69,
  75,32,82,45,85,82,65,82,32,73,78,65,73,76,73,67,69,32,82,124,8,18,163,162,7,135,75,32,18,101,168,22,
  169,134,177,104,160,135,102,18,161,48,60,18,133,18,100,27,7,6,111,110,110,174,175,111,178,175,178,168,171,111,175,134,
  174,162,162,18,175,19,18,161,110,175,175,173,6,76,110,175,175,18,124,172,168,106,110,19,160,45,168,43,172,100,172,109,
  135,188,96,180,19,114,124,181,174,174,124,124,101,162,108,100,133,128,176,64,136,32,104,222,0,112,222,32,120,32,32,56,
  32,176,144,32,176,160,224,176,192,152,182,72,128,224,80,30,30,88,32,184,224,136,176,16,32,0,16,32,224,24,224,24,
  0,24,224,32,168,224,32,24,224,0,32,24,216,200,24,224,0,224,64,40,40,40,24,224,96,32,24,224,0,0,8,224,
  24,48,208,208,208,32,224,232,255,127,191,50,208,0,0,0,159,99,121,66,176,21,203,4,255,127,49,110,74,69,0,0,
  255,127,239,27,0,2,0,0,255,127,31,66,242,28,0,0,255,127,148,82,74,41,0,0,255,127,255,3,47,1,0,0,
  255,127,239,3,214,1,0,0,255,127,181,66,200,61,0,0,116,126,255,3,128,1,0,0,255,103,172,119,19,26,107,45,
  214,126,255,75,117,33,0,0,255,83,95,74,82,126,0,0,255,79,210,126,76,58,224,28,237,3,255,127,95,37,0,0,
  106,3,31,2,255,3,255,127,255,127,223,1,18,1,0,0,31,35,95,3,242,0,9,0,255,127,234,3,31,1,0,0,
  159,41,26,0,12,0,0,0,255,127,127,2,31,0,0,0,255,127,224,3,6,2,32,1,255,127,235,126,31,0,0,124,
  255,127,255,63,0,126,31,0,255,127,255,3,31,0,0,0,255,3,31,0,12,0,0,0,255,127,63,3,147,1,0,0,
  0,0,0,66,127,3,255,127,255,127,140,126,0,124,0,0,255,127,239,27,128,97,0,0,255,127,0,124,224,3,31,124,
  31,0,255,3,64,65,66,32,33,34,128,129,130,16,17,18,18,176,121,184,173,22,23,7,186,5,124,19,0,0,0,0,
};
}
namespace MegaDrive {
const unsigned char TMSS[2048] = {
  0,255,255,0,0,0,2,2,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  83,69,71,65,32,71,69,78,69,83,73,83,32,32,32,32,40,67,41,83,69,71,65,32,49,57,57,48,46,77,65,89,
  71,69,78,69,83,73,83,32,79,83,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,71,69,78,69,83,73,83,32,79,83,32,32,32,32,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  79,83,32,48,48,48,48,48,48,48,48,45,48,48,91,116,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  0,0,0,0,0,0,7,255,0,255,0,0,0,255,255,255,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,85,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  96,254,75,250,0,106,76,221,31,224,16,41,239,1,2,0,0,15,103,8,35,124,83,69,71,65,47,0,48,20,112,0,
  44,64,78,102,114,23,26,29,56,133,218,71,81,201,255,248,40,188,64,0,0,128,54,128,56,20,8,4,0,1,102,248,
  40,188,129,4,143,2,40,188,192,0,0,0,118,31,38,128,81,203,255,252,40,188,64,0,0,16,120,19,38,128,81,204,
  255,252,122,3,23,93,0,17,81,205,255,250,96,60,0,0,128,0,0,0,63,255,0,0,1,0,0,160,0,0,0,161,
  17,0,0,161,18,0,0,192,0,0,0,192,0,4,4,20,48,60,7,108,0,0,0,0,255,0,129,55,0,1,1,0,
  0,255,255,0,0,128,159,191,223,255,65,248,192,0,67,250,0,22,76,217,124,240,48,60,0,63,48,217,81,200,255,252,
  78,184,192,0,96,254,32,83,69,71,69,148,0,3,0,0,0,247,83,69,71,65,0,161,64,0,0,161,65,1,0,192,
  0,4,0,192,0,0,0,161,0,1,8,211,0,0,190,184,1,0,103,34,184,184,1,0,102,8,12,56,0,65,1,4,
  103,20,8,147,0,0,16,22,2,0,0,15,103,6,36,188,0,0,0,0,78,117,8,147,0,0,78,185,0,0,7,140,
  40,188,76,32,0,0,42,153,81,206,255,252,78,185,0,0,7,156,56,188,129,68,48,60,0,60,97,32,56,188,129,4,
  16,22,2,0,0,15,103,6,36,188,0,0,0,0,8,211,0,0,112,0,32,64,46,88,32,88,78,208,50,60,149,206,
  81,201,255,254,81,200,255,246,78,117,0,1,14,238,14,232,1,17,17,0,17,0,1,16,17,0,1,16,17,0,1,16,
  17,17,17,16,17,0,1,16,17,0,1,16,0,0,0,0,17,17,17,0,17,0,1,16,17,0,1,16,17,17,17,0,
  17,0,1,16,17,0,1,16,17,17,17,0,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,0,0,0,
  17,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,17,17,0,17,0,1,16,17,0,1,16,17,0,1,16,
  17,0,1,16,17,0,1,16,17,17,17,0,0,0,0,0,17,17,17,16,17,0,0,0,17,0,0,0,17,17,17,0,
  17,0,0,0,17,0,0,0,17,17,17,16,0,0,0,0,17,17,17,16,17,0,0,0,17,0,0,0,17,17,17,0,
  17,0,0,0,17,0,0,0,17,0,0,0,0,0,0,0,17,17,17,16,17,0,1,16,17,0,0,0,17,0,17,16,
  17,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,17,17,17,16,
  17,0,1,16,17,0,1,16,17,0,1,16,0,0,0,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,
  0,17,16,0,0,17,16,0,0,17,16,0,0,0,0,0,0,0,1,16,0,0,1,16,0,0,1,16,0,0,1,16,
  0,0,1,16,1,16,1,16,1,17,17,16,0,0,0,0,17,0,1,16,17,0,17,0,17,17,16,0,17,17,16,0,
  17,0,17,0,17,0,1,16,17,0,1,16,0,0,0,0,1,16,0,0,1,16,0,0,1,16,0,0,1,16,0,0,
  1,16,0,0,1,16,0,0,1,17,17,16,0,0,0,0,17,0,1,16,17,16,17,16,17,17,17,16,17,1,1,16,
  17,0,1,16,17,0,1,16,17,0,1,16,0,0,0,0,17,0,1,16,17,16,1,16,17,17,1,16,17,1,17,16,
  17,0,17,16,17,0,1,16,17,0,1,16,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,0,1,16,
  17,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,17,17,16,
  17,0,0,0,17,0,0,0,17,0,0,0,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,0,1,16,
  17,0,17,16,17,0,17,16,17,17,17,16,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,17,17,0,
  17,0,1,16,17,0,1,16,17,0,1,16,0,0,0,0,17,17,17,16,17,0,1,16,17,0,0,0,17,17,17,16,
  0,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,17,17,16,0,17,16,0,0,17,16,0,0,17,16,0,
  0,17,16,0,0,17,16,0,0,17,16,0,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,17,0,1,16,
  17,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,17,0,1,16,
  1,16,17,0,0,17,16,0,0,1,0,0,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,17,1,1,16,
  17,17,17,16,17,16,17,16,17,0,1,16,0,0,0,0,17,0,1,16,17,0,1,16,17,16,17,16,1,17,17,0,
  17,16,17,16,17,0,1,16,17,0,1,16,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,1,16,17,0,
  0,17,16,0,0,17,16,0,0,17,16,0,0,0,0,0,17,17,17,16,0,0,17,16,0,1,17,0,0,17,16,0,
  1,17,0,0,17,16,0,0,17,17,17,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,16,0,0,1,16,0,0,0,0,0,0,2,34,34,0,34,0,2,32,34,0,0,0,2,34,34,0,
  0,0,2,32,34,0,2,32,2,34,34,0,0,0,0,0,2,34,34,32,34,0,0,0,34,0,0,0,34,34,34,0,
  34,0,0,0,34,0,0,0,2,34,34,32,0,0,0,0,2,34,34,0,34,0,2,32,34,0,0,0,34,0,34,32,
  34,0,2,32,34,0,2,32,2,34,34,32,0,0,0,0,0,2,32,0,0,34,34,0,0,34,34,0,2,32,2,32,
  2,32,2,32,34,0,0,34,34,2,34,34,0,0,0,0,32,32,32,112,114,111,100,117,99,101,100,32,98,121,32,111,
  114,255,32,117,110,100,101,114,32,108,105,99,101,110,115,101,32,102,114,111,109,255,115,101,103,97,44,101,110,116,101,114,
  112,114,105,115,101,115,32,108,116,100,123,0,48,25,40,188,192,2,0,0,58,153,81,200,255,252,78,117,40,133,114,0,
  18,25,107,8,102,2,78,117,58,129,96,242,6,133,1,0,0,0,96,232,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char SVP[2048] = {
  8,96,252,0,0,1,149,239,0,0,0,0,148,5,0,101,8,64,0,0,0,13,0,56,0,131,8,128,0,0,0,15,
  0,15,8,48,0,0,8,240,0,0,8,224,131,250,8,224,8,28,0,192,8,16,8,96,8,32,252,4,0,193,0,194,
  0,193,0,194,0,193,0,194,8,224,0,228,8,224,8,0,0,12,0,60,104,0,83,86,76,80,252,0,0,60,0,19,
  168,0,3,255,77,80,252,56,232,0,0,1,76,80,252,0,0,49,168,0,28,0,200,0,224,0,0,131,0,60,8,48,
  0,0,0,19,0,35,0,67,20,48,20,49,20,50,21,48,21,49,30,252,0,108,11,51,200,0,128,0,0,227,8,224,
  8,28,0,192,11,51,11,195,56,1,76,112,252,83,3,102,3,231,3,51,200,0,8,0,0,227,0,12,0,60,200,0,
  128,0,0,227,8,224,8,28,0,192,0,60,0,28,0,193,56,1,76,112,252,102,3,102,3,51,2,196,56,1,76,112,
  252,109,3,102,2,51,3,196,56,1,76,112,252,115,3,102,3,51,4,196,56,1,76,112,252,121,3,102,2,51,5,196,
  56,1,76,112,252,127,3,102,3,55,3,195,56,1,76,112,252,133,3,102,3,59,3,255,144,6,5,59,5,255,3,55,
  131,15,4,55,8,48,0,0,76,64,252,151,152,1,131,3,131,11,4,51,2,247,3,102,184,0,14,4,3,51,160,0,
  76,112,252,169,3,247,144,7,5,51,5,247,8,48,0,1,14,4,3,59,160,0,76,112,252,180,3,255,144,7,5,59,
  5,255,6,4,152,1,14,4,3,51,3,247,144,3,5,51,8,48,0,0,144,2,5,247,3,59,3,255,144,3,5,59,
  8,48,0,0,144,2,5,255,3,27,3,39,0,55,3,31,3,35,128,7,144,2,4,243,3,23,3,47,0,55,0,19,
  8,48,0,0,144,2,4,247,0,49,130,3,4,51,184,1,77,80,252,222,2,55,200,0,128,0,4,55,184,0,2,243,
  144,2,4,243,6,4,184,1,77,80,252,236,2,51,2,247,144,6,4,51,4,247,3,102,2,51,2,247,3,102,184,0,
  4,59,4,63,0,35,12,3,0,31,3,51,120,0,76,112,252,255,3,247,144,6,5,51,5,247,8,32,0,1,3,59,
  120,0,76,112,253,8,0,50,152,2,0,35,76,0,253,13,3,59,3,255,144,6,5,59,5,255,2,59,2,255,144,3,
  4,59,4,255,3,51,3,247,144,3,5,51,5,247,76,64,253,28,2,63,152,1,4,63,2,63,131,15,0,19,8,48,
  0,0,76,64,253,36,152,1,130,11,131,11,77,112,253,45,4,59,4,31,3,55,152,1,5,55,2,51,56,1,4,51,
  76,112,253,13,3,51,4,51,3,55,4,55,184,0,0,50,120,0,77,80,253,67,120,3,77,80,253,67,2,51,2,247,
  144,6,4,51,4,247,0,50,184,1,77,80,253,76,2,59,2,255,144,6,4,59,4,255,2,51,2,247,2,27,2,47,
  3,102,3,51,152,64,76,0,253,86,3,51,184,255,136,0,254,227,74,16,4,19,3,102,24,17,18,49,152,18,20,49,
  12,15,0,2,8,16,0,4,2,36,0,55,5,51,5,247,2,53,5,59,2,57,5,63,3,10,13,2,253,113,76,0,
  252,143,4,53,4,245,2,63,56,1,4,63,76,112,253,100,3,102,3,10,13,2,253,126,76,0,253,85,8,32,0,1,
  0,55,144,2,24,10,4,52,4,244,144,6,4,52,4,244,3,10,13,2,253,141,76,0,253,81,0,55,144,2,24,8,
  4,52,4,244,24,14,4,52,4,244,2,5,2,5,8,48,0,3,15,8,18,49,20,50,28,10,2,54,5,52,2,54,
  5,52,2,54,5,52,2,54,5,52,26,8,8,48,0,1,15,9,28,10,2,54,5,51,2,54,5,55,3,52,5,59,
  3,52,5,63,3,10,13,2,253,183,76,0,252,156,4,59,4,255,2,54,5,51,2,54,5,55,3,52,5,59,3,52,
  5,63,3,10,13,2,253,198,76,0,252,156,5,51,5,247,2,59,5,59,2,63,5,63,3,10,13,2,253,209,76,0,
  252,143,144,2,144,2,144,2,144,2,144,2,144,2,144,2,144,2,4,53,4,245,7,9,56,1,15,9,76,112,253,169,
  2,5,2,5,7,8,56,1,15,8,76,112,253,154,3,102,3,10,13,2,253,237,76,0,253,85,8,32,0,1,0,55,
  144,2,144,6,24,10,4,52,4,244,144,6,4,52,4,244,3,10,13,2,253,253,76,0,253,81,0,55,144,2,24,8,
  4,52,4,244,24,14,4,52,4,244,8,48,0,3,15,8,18,49,20,50,28,10,2,54,5,52,2,54,5,52,2,6,
  2,6,2,54,5,52,2,54,5,52,26,8,8,48,0,1,15,9,28,10,2,54,5,51,2,54,5,55,3,52,5,59,
  3,52,5,63,3,10,13,2,254,39,76,0,252,156,4,59,4,255,2,54,5,51,2,54,5,55,3,52,5,59,3,52,
  5,63,3,10,13,2,254,54,76,0,252,156,5,51,5,247,2,59,5,59,2,63,5,63,3,10,13,2,254,65,76,0,
  252,143,144,2,144,2,144,2,144,2,144,2,144,2,144,2,144,2,4,53,4,245,7,9,56,1,15,9,77,112,254,84,
  2,5,2,5,76,0,254,25,7,8,56,1,15,8,76,112,254,8,3,102,3,10,13,2,254,95,76,0,253,85,8,32,
  0,1,0,55,144,2,24,10,4,52,4,244,144,6,4,52,4,244,3,10,13,2,254,110,76,0,253,81,0,55,144,2,
  24,8,4,52,4,244,24,14,4,52,4,244,8,48,0,3,15,8,18,49,20,50,28,10,2,54,5,52,2,54,5,52,
  2,54,5,52,2,54,5,52,26,8,8,48,0,1,15,9,28,10,2,54,5,51,2,54,5,55,3,52,5,59,3,52,
  5,63,3,10,13,2,254,150,76,0,252,156,4,59,4,255,2,54,5,51,2,54,5,55,3,52,5,59,3,52,5,63,
  3,10,13,2,254,165,76,0,252,156,5,51,5,247,2,59,5,59,2,63,5,63,3,10,13,2,254,176,76,0,252,143,
  144,2,144,2,144,2,144,2,144,2,144,2,144,2,144,2,4,53,4,245,7,9,56,1,15,9,76,112,254,136,2,5,
  2,5,7,8,56,1,15,8,76,112,254,121,3,102,184,0,8,16,1,0,4,53,4,21,4,53,4,53,4,53,4,53,
  4,53,4,53,4,53,4,21,4,53,4,53,4,53,4,53,4,53,4,53,4,53,4,21,4,53,4,53,4,53,4,53,
  4,53,4,53,3,102,0,0,0,6,0,12,0,18,0,25,0,31,0,37,0,43,0,49,0,56,0,62,0,68,0,74,
  0,80,0,86,0,92,0,97,0,103,0,109,0,115,0,120,0,126,0,131,0,136,0,142,0,147,0,152,0,157,0,162,
  0,167,0,171,0,176,0,181,0,185,0,189,0,193,0,197,0,201,0,205,0,209,0,212,0,216,0,219,0,222,0,225,
  0,228,0,231,0,234,0,236,0,238,0,241,0,243,0,244,0,246,0,248,0,249,0,251,0,252,0,253,0,254,0,254,
  0,255,0,255,0,255,1,0,0,255,0,255,0,255,0,254,0,254,0,253,0,252,0,251,0,249,0,248,0,246,0,244,
  0,243,0,241,0,238,0,236,0,234,0,231,0,228,0,225,0,222,0,219,0,216,0,212,0,209,0,205,0,201,0,197,
  0,193,0,189,0,185,0,181,0,176,0,171,0,167,0,162,0,157,0,152,0,147,0,142,0,136,0,131,0,126,0,120,
  0,115,0,109,0,103,0,97,0,92,0,86,0,80,0,74,0,68,0,62,0,56,0,49,0,43,0,37,0,31,0,25,
  0,18,0,12,0,6,0,0,255,250,255,244,255,238,255,231,255,225,255,219,255,213,255,207,255,200,255,194,255,188,255,182,
  255,176,255,170,255,164,255,159,255,153,255,147,255,141,255,136,255,130,255,125,255,120,255,114,255,109,255,104,255,99,255,94,
  255,89,255,85,255,80,255,75,255,71,255,67,255,63,255,59,255,55,255,51,255,47,255,44,255,40,255,37,255,34,255,31,
  255,28,255,25,255,22,255,20,255,18,255,15,255,13,255,12,255,10,255,8,255,7,255,5,255,4,255,3,255,2,255,2,
  255,1,255,1,255,1,255,0,255,1,255,1,255,1,255,2,255,2,255,3,255,4,255,5,255,7,255,8,255,10,255,12,
  255,13,255,15,255,18,255,20,255,22,255,25,255,28,255,31,255,34,255,37,255,40,255,44,255,47,255,51,255,55,255,59,
  255,63,255,67,255,71,255,75,255,80,255,85,255,89,255,94,255,99,255,104,255,109,255,114,255,120,255,125,255,130,255,136,
  255,141,255,147,255,153,255,159,255,164,255,170,255,176,255,182,255,188,255,194,255,200,255,207,255,213,255,219,255,225,255,231,
  255,238,255,244,255,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,8,3,250,3,252,3,254,
};
}
namespace Mega32X {
const unsigned char Vector[256] = {
  0,0,0,0,0,136,2,0,0,136,2,6,0,136,2,12,0,136,2,18,0,136,2,24,0,136,2,30,0,136,2,36,
  0,136,2,42,0,136,2,48,0,136,2,54,0,136,2,60,0,136,2,66,0,136,2,72,0,136,2,78,0,136,2,84,
  0,136,2,90,0,136,2,96,0,136,2,102,0,136,2,108,0,136,2,114,0,136,2,120,0,136,2,126,0,136,2,132,
  0,136,2,138,0,136,2,144,0,136,2,150,0,136,2,156,0,136,2,162,0,136,2,168,0,136,2,174,0,136,2,180,
  0,136,2,186,0,136,2,192,0,136,2,198,0,136,2,204,0,136,2,210,0,136,2,216,0,136,2,222,0,136,2,228,
  0,136,2,234,0,136,2,240,0,136,2,246,0,136,2,252,0,136,3,2,0,136,3,8,0,136,3,14,0,136,3,20,
  8,249,0,0,0,161,81,7,18,128,8,185,0,0,0,161,81,7,78,117,72,231,1,64,8,249,0,0,0,161,81,7,
  67,249,0,161,48,241,126,7,18,152,210,252,0,2,81,207,255,248,8,185,0,0,0,161,81,7,76,223,2,128,78,117,
};
const unsigned char SH2BootM[2048] = {
  0,0,1,64,6,4,0,0,0,0,1,64,6,4,0,0,0,0,1,60,0,0,0,0,0,0,1,60,32,16,4,0,
  32,16,4,32,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,175,254,0,9,
  208,26,64,14,224,0,225,0,226,0,227,0,228,0,229,0,230,0,231,0,232,0,233,0,234,0,235,0,236,0,237,0,
  238,0,216,111,217,111,96,134,25,0,96,134,25,1,96,134,25,2,96,134,25,3,96,134,25,4,96,134,25,5,96,134,
  25,6,222,102,78,30,216,119,224,0,40,1,196,0,200,2,139,16,208,7,225,1,48,24,136,0,139,252,193,1,216,99,
  224,159,40,0,0,27,175,254,0,9,0,0,0,0,0,240,0,1,0,0,216,93,224,0,40,0,217,91,224,17,41,0,
  216,96,217,95,224,0,40,5,112,1,40,5,112,1,40,5,112,1,40,5,112,1,57,128,139,245,216,90,217,88,224,0,
  225,2,226,1,211,5,56,24,100,129,36,57,32,57,52,0,139,6,112,1,57,128,139,246,160,8,0,9,0,0,255,255,
  208,1,194,8,175,252,0,9,83,68,69,82,216,77,217,76,224,0,40,6,40,6,40,6,40,6,57,128,139,249,196,0,
  200,1,139,89,221,67,220,6,219,6,103,197,96,125,102,213,97,109,49,0,139,8,59,192,139,247,160,13,0,9,0,0,
  0,0,3,108,0,0,7,108,208,2,194,8,224,128,192,0,175,250,0,9,83,81,69,82,216,22,217,23,97,145,96,29,
  136,0,137,15,217,21,103,146,208,21,55,8,71,1,209,21,39,25,119,1,224,0,211,20,98,133,34,57,48,44,32,57,
  71,16,139,249,193,20,221,42,104,214,105,214,96,214,209,15,56,28,209,15,57,28,226,4,97,134,41,18,121,4,48,40,
  136,0,139,249,80,210,64,46,104,210,208,10,194,8,72,43,0,9,0,0,34,0,2,0,34,0,1,142,34,0,1,164,
  0,0,2,0,0,63,255,255,0,0,255,255,34,0,0,0,6,0,0,0,77,95,79,75,209,35,198,8,49,0,139,252,
  224,128,192,0,196,0,200,128,137,252,216,19,89,128,80,129,90,130,91,132,120,32,211,17,228,0,226,4,97,134,41,18,
  121,4,48,40,51,40,51,64,137,1,136,0,139,246,208,2,194,8,75,46,74,43,0,9,77,95,79,75,32,0,64,0,
  0,0,3,72,255,255,255,224,255,255,254,146,255,255,254,145,34,0,3,212,34,0,4,0,36,0,0,24,0,1,255,224,
  38,0,0,0,38,4,0,0,165,90,0,1,165,90,0,168,165,90,0,85,165,90,10,184,165,90,0,8,165,90,0,0,
  165,90,0,89,255,255,132,70,95,67,68,95,70,252,39,0,75,249,0,161,0,0,112,1,12,173,77,65,82,83,48,236,
  102,0,3,230,8,45,0,7,81,1,103,248,74,173,0,8,103,16,74,109,0,12,103,10,8,45,0,0,81,1,102,0,
  3,184,16,45,0,1,2,0,0,15,103,6,43,120,5,90,64,0,114,0,44,65,78,102,65,249,0,0,4,212,97,0,
  1,82,97,0,1,118,71,249,0,0,4,232,67,249,0,160,0,0,69,249,0,192,0,17,62,60,1,0,112,0,59,71,
  17,0,59,71,18,0,1,45,17,0,102,250,116,37,18,219,81,202,255,252,59,64,18,0,59,64,17,0,59,71,18,0,
  20,155,20,155,20,155,20,155,65,249,0,0,4,192,67,249,0,255,0,0,34,216,34,216,34,216,34,216,34,216,34,216,
  34,216,34,216,65,249,0,255,0,0,78,208,27,124,0,1,81,1,65,249,0,0,6,188,209,252,0,136,0,0,78,208,
  4,4,48,60,7,108,0,0,0,0,255,0,129,55,0,2,1,0,0,0,175,1,217,31,17,39,0,33,38,0,249,119,
  237,176,221,225,253,225,237,71,237,79,209,225,241,8,217,193,209,225,241,249,243,237,86,54,233,233,159,191,223,255,77,65,
  82,83,32,73,110,105,116,105,97,108,32,38,32,83,101,99,117,114,105,116,121,32,80,114,111,103,114,97,109,32,32,32,
  32,32,32,32,32,32,32,67,97,114,116,114,105,100,103,101,32,86,101,114,115,105,111,110,32,32,32,32,67,111,112,121,
  114,105,103,104,116,32,83,69,71,65,32,69,78,84,69,82,80,82,73,83,69,83,44,76,84,68,46,32,49,57,57,52,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  32,32,82,79,77,32,86,101,114,115,105,111,110,32,49,46,48,0,72,231,192,64,67,249,0,192,0,4,48,17,48,60,
  128,0,50,60,1,0,62,60,0,18,16,24,50,128,208,65,81,207,255,248,76,223,2,3,78,117,72,231,129,192,65,249,
  0,0,6,62,67,249,0,192,0,4,50,152,50,152,50,152,50,152,50,152,50,152,50,152,34,152,51,65,255,252,48,17,
  8,0,0,1,102,248,50,152,50,152,112,0,34,188,192,0,0,0,126,15,51,64,255,252,51,64,255,252,51,64,255,252,
  51,64,255,252,81,207,255,238,34,188,64,0,0,16,126,9,51,64,255,252,51,64,255,252,51,64,255,252,51,64,255,252,
  81,207,255,238,76,223,3,129,78,117,129,20,143,1,147,255,148,255,149,0,150,0,151,128,64,0,0,128,129,4,143,2,
  72,231,193,64,67,249,0,161,81,128,8,169,0,7,255,128,102,248,62,60,0,255,112,0,114,0,51,124,0,255,0,4,
  51,65,0,6,51,64,0,8,78,113,8,41,0,1,0,11,102,248,6,65,1,0,81,207,255,232,76,223,2,131,78,117,
  72,231,129,128,65,249,0,161,82,0,8,168,0,7,255,0,102,248,62,60,0,31,32,192,32,192,32,192,32,192,81,207,
  255,246,76,223,1,129,78,117,65,249,0,255,0,0,62,60,7,255,112,0,32,192,32,192,32,192,32,192,32,192,32,192,
  32,192,32,192,81,207,255,238,59,124,0,0,18,0,126,10,81,207,255,254,67,249,0,161,81,0,112,0,35,64,0,32,
  35,64,0,36,27,124,0,3,81,1,46,121,0,136,0,0,8,145,0,7,102,250,112,0,51,64,0,2,51,64,0,4,
  51,64,0,6,35,64,0,8,35,64,0,12,51,64,0,16,51,64,0,48,51,64,0,50,51,64,0,56,51,64,0,128,
  51,64,0,130,8,169,0,0,0,139,102,248,97,0,255,18,8,233,0,0,0,139,103,248,97,0,255,6,8,169,0,0,
  0,139,97,0,255,60,48,60,0,64,34,41,0,32,12,129,83,81,69,82,103,0,0,146,48,60,0,128,34,41,0,32,
  12,129,83,68,69,82,103,0,0,128,33,252,0,136,2,162,0,112,48,60,0,2,114,0,18,45,0,1,20,41,0,128,
  225,74,130,66,8,1,0,15,102,10,8,1,0,6,103,0,0,88,96,8,8,1,0,6,102,0,0,78,112,32,65,249,
  0,136,0,0,60,40,1,142,74,70,103,0,0,16,52,41,0,40,12,66,0,0,103,246,180,70,102,44,112,0,35,64,
  0,40,35,64,0,44,62,20,44,124,255,255,255,192,76,214,127,249,68,252,0,0,96,20,67,249,0,161,81,0,51,64,
  0,6,48,60,128,0,96,4,68,252,0,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char SH2BootS[1024] = {
  0,0,1,64,6,3,248,0,0,0,1,64,6,3,248,0,0,0,1,60,0,0,0,0,0,0,1,60,32,16,4,0,
  32,16,4,32,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,175,254,0,9,
  208,20,64,14,224,0,225,0,226,0,227,0,228,0,229,0,230,0,231,0,232,0,233,0,234,0,235,0,236,0,237,0,
  238,0,216,37,217,37,96,134,25,0,96,134,25,1,96,134,25,2,96,134,25,3,96,134,25,4,96,134,25,5,96,134,
  25,6,222,28,78,30,196,0,200,2,139,5,0,27,175,254,0,9,0,0,0,0,0,240,216,26,224,0,40,0,217,24,
  224,17,41,0,196,0,200,1,139,22,176,8,0,9,221,22,80,210,64,46,104,210,208,33,194,9,72,43,0,9,210,5,
  224,40,225,1,48,24,136,0,139,252,198,8,50,0,139,247,0,11,0,9,77,95,79,75,209,23,198,8,49,0,139,252,
  191,237,0,9,216,9,90,131,91,133,208,20,194,9,75,46,74,43,0,9,32,0,64,0,0,0,2,28,255,255,255,224,
  255,255,254,146,255,255,254,145,34,0,3,228,36,0,0,24,0,2,0,0,38,0,0,0,38,4,0,0,165,90,0,1,
  165,90,0,168,165,90,0,85,165,90,10,184,165,90,0,8,165,90,0,0,165,90,0,89,95,67,68,95,83,95,79,75,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
}
namespace MSX {
const unsigned char BIOS[32768] = {
  243,195,18,13,191,27,152,152,195,237,16,0,195,191,35,0,195,255,16,0,195,0,36,0,195,27,17,0,195,52,36,0,
  195,33,17,0,195,115,36,0,195,39,17,33,2,0,0,0,195,57,17,0,0,0,0,0,195,230,24,195,78,17,195,88,
  17,195,22,2,195,34,2,195,46,2,195,69,2,195,77,2,195,85,2,195,96,2,195,109,2,195,129,2,195,151,2,195,
  173,2,195,212,2,0,195,94,25,195,30,3,195,130,3,195,194,3,195,5,4,195,67,4,195,143,4,195,183,4,195,230,
  4,195,25,5,195,111,5,195,130,5,195,140,5,195,151,5,195,58,23,195,82,23,195,92,23,195,106,17,195,124,17,195,
  143,17,195,180,17,195,217,20,195,3,21,195,17,21,195,54,21,195,84,21,195,75,21,195,37,22,195,65,22,195,83,22,
  195,86,22,195,181,7,195,102,22,195,106,22,195,123,22,195,141,22,195,159,22,195,143,23,195,2,24,195,71,24,195,89,
  24,195,178,22,195,197,22,195,215,22,195,233,22,195,252,22,195,15,23,195,33,23,195,106,24,195,121,24,195,68,8,195,
  86,8,195,103,8,195,118,8,195,134,8,195,151,8,195,169,8,195,185,8,195,244,8,195,2,9,195,20,9,195,38,9,
  195,55,9,195,71,9,195,89,9,195,107,9,195,125,9,195,142,9,195,167,24,195,97,23,195,106,23,195,109,23,195,112,
  23,195,115,23,195,130,23,195,134,23,195,138,23,195,179,24,195,197,24,195,201,24,195,223,24,195,112,26,0,0,0,201,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  79,6,0,9,9,195,17,2,190,35,40,5,35,35,16,248,201,78,35,102,105,233,58,224,243,230,191,71,14,1,205,46,
  2,201,58,224,243,246,64,71,14,1,205,46,2,201,243,203,185,120,211,153,121,246,128,211,153,251,229,33,223,243,120,6,
  0,9,119,225,201,205,85,2,246,0,219,152,201,245,205,96,2,241,211,152,201,243,125,211,153,124,230,63,211,153,251,201,
  243,125,211,153,124,230,63,246,64,211,153,251,201,245,205,96,2,11,12,120,65,79,12,241,211,152,5,32,251,13,32,248,
  201,205,85,2,229,235,11,12,120,65,60,14,152,237,162,194,141,2,61,32,248,225,201,235,205,96,2,235,11,12,120,65,
  60,14,152,237,163,194,163,2,61,32,248,235,201,254,4,208,33,182,2,195,0,2,130,3,194,3,5,4,67,4,243,33,
  223,243,1,153,8,22,128,237,163,120,237,81,20,183,32,247,251,195,34,2,58,175,252,254,8,40,58,61,245,58,233,243,
  7,7,7,7,230,240,111,58,235,243,181,71,14,7,205,46,2,241,192,58,233,243,7,7,7,7,230,240,33,234,243,182,
  42,191,243,1,32,0,245,205,96,2,241,211,152,245,11,120,177,32,247,241,201,58,235,243,71,14,7,195,46,2,58,175,
  252,183,200,205,72,3,58,175,252,254,4,56,16,42,40,249,37,37,1,0,2,58,233,243,230,15,205,109,2,42,38,249,
  1,0,8,175,205,109,2,201,58,175,252,254,4,56,4,30,217,24,2,30,209,42,40,249,205,96,2,58,233,243,87,1,
  0,32,243,123,211,152,62,0,0,0,211,152,121,0,0,0,211,152,12,205,140,5,48,3,12,12,12,122,211,152,16,227,
  251,201,205,22,2,62,0,50,175,252,50,176,252,58,174,243,50,176,243,62,1,50,220,243,50,221,243,42,179,243,34,34,
  249,42,183,243,34,36,249,42,185,243,34,40,249,42,187,243,34,38,249,205,212,2,205,143,4,205,168,7,205,205,7,195,
  190,2,205,22,2,62,1,50,175,252,50,176,252,62,1,50,220,243,50,221,243,205,212,2,42,189,243,34,34,249,42,193,
  243,34,36,249,42,197,243,34,38,249,42,195,243,34,40,249,205,168,7,58,175,243,50,176,243,205,183,4,205,83,3,205,
  220,7,195,190,2,205,22,2,62,2,50,175,252,205,212,2,42,199,243,34,34,249,205,96,2,6,3,175,243,211,152,60,
  32,251,16,249,251,42,203,243,34,36,249,42,205,243,34,40,249,42,207,243,34,38,249,205,230,4,205,83,3,205,248,7,
  195,190,2,205,22,2,62,3,50,175,252,205,212,2,42,209,243,34,34,249,205,96,2,175,14,6,243,245,30,4,245,6,
  32,211,152,60,16,251,241,29,32,244,241,198,32,13,32,235,251,42,213,243,34,36,249,42,215,243,34,40,249,42,217,243,
  34,38,249,205,25,5,205,83,3,205,14,8,195,190,2,58,223,243,230,241,71,14,0,205,46,2,58,224,243,230,231,246,
  16,71,12,205,46,2,17,179,243,14,2,175,205,74,5,19,19,12,175,205,74,5,201,58,223,243,230,241,71,14,0,205,
  46,2,58,224,243,230,231,71,12,205,46,2,17,189,243,14,2,175,205,74,5,175,205,74,5,175,205,74,5,175,205,74,
  5,175,205,74,5,201,58,223,243,230,241,246,2,71,14,0,205,46,2,58,224,243,230,231,71,12,205,46,2,17,199,243,
  14,2,175,205,74,5,62,127,205,74,5,62,3,205,74,5,175,205,74,5,175,205,74,5,201,58,223,243,230,241,71,14,
  0,205,46,2,58,224,243,230,231,246,8,71,12,205,46,2,17,209,243,14,2,175,205,74,5,175,205,74,5,175,205,74,
  5,175,205,74,5,175,205,74,5,201,213,245,33,104,5,6,0,9,70,235,126,35,102,111,41,143,16,252,71,241,176,71,
  205,46,2,209,19,19,12,201,0,0,6,10,5,9,5,38,0,111,41,41,41,205,140,5,48,2,41,41,237,91,38,249,
  25,201,135,135,42,40,249,22,0,95,25,201,58,224,243,15,15,62,8,208,62,32,201,245,254,32,56,13,58,175,252,254,
  2,40,34,254,5,48,28,241,201,254,13,32,250,241,229,197,42,185,252,1,8,0,9,34,185,252,33,0,0,34,183,252,
  193,225,201,241,201,241,229,213,197,245,205,34,8,237,91,185,252,237,75,183,252,205,185,8,58,233,243,50,242,243,42,42,
  249,237,75,203,243,9,17,64,252,58,185,252,230,7,6,0,79,9,205,18,6,1,240,0,9,58,185,252,47,230,7,79,
  205,18,6,42,183,252,1,8,0,9,34,183,252,241,193,209,225,201,58,183,252,230,7,245,197,213,229,205,155,6,58,183,
  252,230,7,40,26,58,44,249,47,50,44,249,225,1,8,0,9,209,193,241,205,155,6,58,44,249,47,50,44,249,201,193,
  1,8,0,9,193,193,241,201,245,229,197,213,87,88,237,75,201,243,9,79,58,242,243,230,15,71,205,69,2,245,230,15,
  184,40,17,241,245,15,15,15,15,230,15,184,32,13,241,209,193,225,241,201,241,209,193,225,241,47,201,122,179,254,255,40,
  17,241,203,0,203,0,203,0,203,0,230,15,176,205,77,2,24,221,241,230,240,176,205,77,2,24,218,65,60,79,62,7,
  168,60,71,197,205,69,2,71,26,205,72,6,13,40,3,15,24,250,79,58,44,249,161,79,120,177,205,77,2,35,19,193,
  16,225,201,71,82,80,80,82,84,0,58,175,252,254,5,201,245,205,239,6,11,12,120,65,79,12,241,243,211,152,16,252,
  13,32,249,251,201,205,251,6,124,230,63,211,153,251,201,205,251,6,124,230,63,246,64,211,153,251,201,58,246,250,183,40,
  16,58,175,252,254,5,218,96,2,254,7,58,246,250,56,1,135,229,230,3,15,111,230,128,172,23,203,21,23,125,23,243,
  211,153,62,142,211,153,225,125,211,153,201,205,229,6,219,152,201,245,205,239,6,241,211,152,201,243,211,153,62,143,211,153,
  219,153,245,175,211,153,62,143,211,153,251,241,201,219,153,1,0,0,205,46,2,1,1,224,205,46,2,1,2,0,205,46,
  2,1,3,128,205,46,2,1,4,1,205,46,2,1,8,8,205,46,2,62,1,50,220,243,50,221,243,205,220,7,62,0,
  33,0,8,1,0,8,205,109,2,62,245,33,0,32,1,32,0,205,109,2,1,7,245,205,46,2,33,191,27,17,0,8,
  1,0,8,205,151,2,201,201,33,191,27,237,91,36,249,1,0,8,195,151,2,192,58,175,252,254,4,208,229,33,197,7,
  205,0,2,225,201,205,7,220,7,248,7,14,8,58,176,243,254,40,1,192,3,56,8,1,128,7,24,3,1,0,3,42,
  34,249,62,32,205,109,2,62,1,33,178,251,119,17,179,251,1,23,0,237,176,195,69,18,175,1,0,24,42,36,249,111,
  197,205,109,2,193,58,234,243,42,201,243,195,109,2,58,234,243,230,15,71,7,7,7,7,176,1,0,8,42,36,249,195,
  109,2,237,75,32,249,111,38,0,41,41,41,9,6,8,17,64,252,197,213,229,58,31,249,205,191,35,225,209,193,18,19,
  35,16,239,201,229,245,33,79,8,205,159,9,241,225,201,82,73,71,72,84,67,0,229,245,33,97,8,205,159,9,241,225,
  201,76,69,70,84,67,0,229,245,33,114,8,205,159,9,241,225,201,85,80,67,0,229,245,33,129,8,205,159,9,241,225,
  201,84,85,80,67,0,229,245,33,145,8,205,159,9,241,225,201,68,79,87,78,67,0,229,245,33,162,8,205,159,9,241,
  225,201,84,68,79,87,78,67,0,237,75,183,252,237,91,185,252,201,83,67,65,76,88,89,0,197,237,67,183,252,237,83,
  185,252,42,185,252,41,41,41,41,41,46,0,6,0,62,255,50,44,249,121,230,7,40,10,71,62,255,167,31,16,252,50,
  44,249,121,230,248,79,6,0,9,34,42,249,193,201,77,65,80,88,89,0,58,44,249,42,42,249,201,70,69,84,67,72,
  67,0,229,245,33,13,9,205,159,9,241,225,201,83,84,79,82,69,67,0,229,245,33,31,9,205,159,9,241,225,201,83,
  69,84,65,84,82,0,229,245,33,49,9,205,159,9,241,225,201,82,69,65,68,67,0,229,245,33,66,9,205,159,9,241,
  225,201,83,69,84,67,0,229,245,33,82,9,205,159,9,241,225,201,78,83,69,84,67,88,0,229,245,33,100,9,205,159,
  9,241,225,201,71,84,65,83,80,67,0,229,245,33,118,9,205,159,9,241,225,201,80,78,84,73,78,73,0,229,245,33,
  136,9,205,159,9,241,225,201,83,67,65,78,82,0,229,245,33,153,9,205,159,9,241,225,201,83,67,65,78,76,0,62,
  35,211,46,205,171,9,62,0,211,46,201,126,35,183,200,211,47,24,248,230,15,254,10,48,5,198,48,211,47,201,198,55,
  211,47,201,245,15,15,15,15,205,179,9,241,205,179,9,201,124,205,195,9,125,205,195,9,201,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,201,221,225,253,225,241,193,209,225,217,8,241,193,209,225,251,201,62,130,211,171,62,80,211,170,175,211,255,60,211,254,
  60,211,253,60,211,252,33,255,255,217,219,168,246,240,71,120,211,168,58,255,255,47,246,240,79,121,50,255,255,33,0,255,
  62,15,119,190,32,8,47,119,190,32,3,37,24,242,36,124,183,40,21,217,188,56,5,40,3,217,24,12,46,0,103,217,
  120,217,71,217,121,217,79,217,121,214,16,79,48,203,120,214,16,71,48,187,217,125,183,40,6,17,245,37,195,135,26,120,
  211,168,121,50,255,255,217,33,0,243,249,205,23,15,205,67,16,205,77,7,251,205,78,17,6,15,17,19,14,33,0,128,
  197,229,213,58,193,252,205,191,35,225,209,193,190,32,18,235,19,35,16,236,221,33,16,128,253,42,192,252,205,52,36,24,
  17,62,5,50,234,243,50,235,243,205,194,3,33,86,37,205,142,16,251,6,120,205,138,16,62,4,50,235,243,62,4,50,
  234,243,62,15,50,233,243,62,29,50,175,243,205,194,3,33,86,37,205,142,16,205,34,14,205,218,254,205,1,15,62,1,
  50,153,253,175,50,41,251,205,203,254,33,47,38,205,142,16,195,101,26,67,45,66,73,79,83,32,76,111,103,111,32,82,
  79,77,33,201,252,17,202,252,1,63,0,54,0,237,176,33,193,252,175,229,182,33,0,64,205,105,14,204,118,14,33,0,
  128,205,105,14,204,118,14,203,127,40,6,198,4,203,103,40,228,225,35,60,230,3,32,219,201,71,205,191,35,35,245,120,
  205,191,35,35,87,241,95,120,201,229,205,89,14,33,65,66,205,33,17,120,225,201,229,245,33,189,37,205,142,16,241,245,
  71,230,3,198,48,205,180,17,120,203,120,40,15,62,46,205,180,17,120,15,15,230,3,198,48,205,180,17,62,13,205,180,
  17,62,10,205,180,17,241,225,35,35,205,248,14,40,21,79,213,221,225,245,253,225,219,153,183,250,182,14,245,229,205,52,
  36,243,225,241,14,0,205,248,14,40,2,203,233,205,248,14,40,2,203,241,205,248,14,40,2,203,249,71,230,12,95,120,
  7,7,7,7,230,48,179,95,124,7,7,230,3,179,33,201,252,22,0,95,25,113,120,201,197,205,89,14,122,179,120,193,
  201,33,201,252,6,64,126,203,127,40,8,229,33,208,37,205,142,16,225,35,16,240,201,62,0,33,128,243,119,17,129,243,
  1,125,12,237,176,62,201,33,0,243,119,17,1,243,1,127,0,237,176,62,201,33,154,253,119,17,155,253,1,77,2,237,
  176,62,255,33,218,251,119,17,219,251,1,21,0,237,176,62,0,33,240,251,119,17,241,251,1,39,0,237,176,33,240,251,
  34,248,243,34,250,243,217,34,72,252,217,33,128,243,34,74,252,34,116,246,33,59,37,17,128,243,1,26,0,237,176,33,
  0,0,34,179,243,33,0,8,34,183,243,33,0,24,34,189,243,33,0,32,34,191,243,33,0,0,34,193,243,33,0,27,
  34,195,243,33,0,56,34,197,243,33,0,24,34,199,243,33,0,32,34,201,243,33,0,0,34,203,243,33,0,27,34,205,
  243,33,0,56,34,207,243,33,0,8,34,209,243,33,0,0,34,213,243,33,0,27,34,215,243,33,0,56,34,217,243,33,
  89,249,34,243,243,33,117,249,34,93,249,33,245,249,34,99,249,33,117,250,34,105,249,62,127,50,92,249,50,98,249,50,
  104,249,62,39,50,174,243,62,32,50,175,243,58,175,243,50,176,243,62,24,50,177,243,62,4,50,235,243,62,4,50,234,
  243,62,15,50,233,243,62,160,50,224,243,58,193,252,50,31,249,42,4,0,34,32,249,62,195,33,180,17,34,229,254,50,
  228,254,201,243,33,193,252,219,168,87,230,63,79,211,168,58,255,255,47,95,230,15,50,255,255,71,58,255,255,47,184,32,
  21,123,230,15,246,80,50,255,255,71,58,255,255,47,184,32,5,6,128,123,24,4,6,0,123,47,50,255,255,122,211,168,
  112,35,121,198,64,79,48,197,251,201,118,16,253,201,58,175,252,254,5,48,9,126,183,200,205,180,17,35,24,247,126,183,
  200,221,33,137,0,205,63,26,35,24,243,14,32,58,175,252,183,192,14,40,58,176,243,254,41,216,14,80,201,197,245,205,
  171,16,58,176,243,237,68,129,60,203,63,111,58,221,243,61,133,111,38,0,68,58,220,243,61,203,63,48,1,9,203,33,
  203,16,183,32,244,237,75,34,249,9,241,193,201,229,245,33,248,16,205,159,9,241,225,201,83,89,78,67,72,82,0,205,
  72,255,126,35,254,0,200,254,58,200,254,48,56,3,254,58,216,254,32,40,237,254,9,40,233,183,201,245,205,228,254,241,
  201,124,186,192,125,187,201,229,245,33,50,17,205,159,9,241,225,201,71,69,84,89,80,82,0,8,217,225,126,35,94,35,
  86,35,213,221,225,245,253,225,229,8,217,195,52,36,30,143,62,15,205,82,23,195,58,23,229,245,33,99,17,205,159,9,
  241,225,201,73,78,73,70,78,75,0,229,245,33,117,17,205,159,9,241,225,201,83,84,82,84,77,83,0,251,229,213,42,
  250,243,237,91,248,243,231,62,255,32,1,175,209,225,201,205,194,253,229,213,42,250,243,237,91,248,243,231,32,4,251,118,
  24,242,126,245,35,125,254,24,32,3,33,240,251,34,250,243,241,209,225,201,229,213,197,245,205,164,253,58,175,252,254,2,
  48,19,241,245,205,4,20,241,245,205,218,17,205,25,20,58,221,243,50,97,246,241,193,209,225,201,205,17,21,208,40,18,
  245,58,167,252,183,194,189,18,241,254,32,56,42,254,127,202,246,19,205,189,16,205,77,2,42,220,243,58,176,243,36,188,
  56,4,34,220,243,201,17,177,251,38,0,25,175,119,42,220,243,205,108,18,195,46,18,6,12,33,136,20,195,8,2,62,
  32,205,242,17,58,221,243,230,7,254,1,32,242,201,42,220,243,58,177,243,44,189,48,9,229,205,69,18,205,144,19,225,
  45,34,220,243,201,33,1,1,34,220,243,201,205,46,19,42,220,243,229,205,108,18,58,220,243,33,177,243,190,48,8,205,
  46,18,205,46,19,24,239,225,34,220,243,201,62,1,50,221,243,201,62,255,50,167,252,201,58,221,243,33,176,243,190,48,
  3,60,24,31,58,220,243,33,177,243,190,208,60,50,220,243,24,218,58,221,243,61,32,11,58,220,243,61,200,50,220,243,
  58,176,243,50,221,243,201,58,220,243,61,200,50,220,243,201,58,220,243,33,177,243,190,208,60,50,220,243,201,71,60,32,
  12,50,167,252,241,6,15,33,172,20,195,8,2,241,16,4,14,0,24,4,16,24,14,1,254,52,40,6,254,53,40,8,
  24,46,121,50,170,252,24,40,121,50,169,252,24,34,16,8,6,31,144,50,221,243,24,24,16,22,6,31,144,50,220,243,
  62,3,24,13,62,1,24,9,62,2,24,5,62,4,24,1,175,50,167,252,201,58,221,243,33,176,243,190,208,60,50,221,
  243,201,58,221,243,61,200,50,221,243,201,205,108,18,33,177,251,58,220,243,95,22,0,25,119,58,176,243,60,33,221,243,
  150,79,6,0,62,32,205,189,16,195,109,2,205,108,18,42,220,243,229,69,58,177,243,50,220,243,144,71,4,58,220,243,
  24,14,205,189,16,235,61,50,220,243,205,189,16,205,206,19,16,240,225,34,220,243,38,0,58,177,243,87,30,0,149,61,
  79,6,0,33,177,251,25,235,98,107,43,237,184,195,46,19,205,108,18,42,220,243,229,69,58,177,243,144,71,4,58,220,
  243,24,14,205,189,16,235,60,50,220,243,205,189,16,205,206,19,16,240,205,46,19,225,34,220,243,38,0,58,177,243,149,
  61,79,6,0,17,177,251,25,84,93,35,237,176,201,245,197,6,0,58,176,243,79,205,220,19,193,241,201,229,213,197,17,
  24,252,205,129,2,193,209,213,197,33,24,252,205,151,2,193,225,9,235,225,9,201,58,221,243,254,1,200,62,32,205,242,
  17,195,146,18,58,169,252,254,1,192,58,175,252,254,2,208,58,204,251,205,189,16,195,77,2,58,169,252,254,1,192,58,
  175,252,254,2,208,205,189,16,205,69,2,50,204,251,167,22,0,95,203,19,203,18,203,19,203,18,203,19,203,18,175,33,
  175,252,190,32,5,42,183,243,24,3,42,193,243,229,25,17,24,252,1,8,0,205,129,2,58,170,252,254,0,32,7,33,
  24,252,6,8,24,5,33,30,252,6,2,126,47,119,35,16,250,225,17,248,7,25,235,33,24,252,1,8,0,205,151,2,
  205,189,16,62,255,195,77,2,7,86,22,8,146,18,9,31,18,10,46,18,11,69,18,12,182,7,13,108,18,27,114,18,
  28,120,18,29,146,18,30,167,18,31,176,18,106,182,7,69,182,7,75,46,19,74,76,18,108,43,19,76,76,19,77,144,
  19,89,12,19,65,167,18,66,176,18,67,21,19,68,34,19,72,69,18,120,4,19,121,8,19,205,182,255,245,205,37,22,
  56,8,205,3,21,40,246,241,24,12,62,13,205,246,20,175,50,21,244,241,55,201,245,211,145,62,0,211,144,47,211,144,
  241,167,201,205,187,255,219,144,31,31,62,255,48,1,47,167,201,229,245,33,166,252,175,190,119,32,8,241,254,1,32,19,
  119,24,17,241,254,64,56,9,254,96,48,5,214,64,191,24,2,254,80,55,225,201,205,219,253,58,170,246,167,202,84,21,
  62,1,50,221,243,195,84,21,63,32,0,205,224,253,33,72,21,205,142,16,42,221,243,34,202,251,17,176,251,38,0,125,
  25,119,205,143,17,254,127,202,228,21,254,32,48,17,6,20,33,229,21,205,0,2,175,50,168,252,50,170,252,24,227,245,
  58,168,252,167,196,139,21,241,223,24,201,205,4,20,42,220,243,34,188,246,62,32,50,167,246,205,189,16,205,69,2,254,
  32,32,40,42,220,243,58,176,243,188,32,29,38,0,17,177,251,25,126,183,40,19,58,167,246,205,189,16,205,77,2,42,
  188,246,34,220,243,201,195,25,20,62,32,245,58,167,246,223,241,50,167,246,24,195,201,55,225,201,201,201,201,201,175,225,
  201,201,201,201,201,24,0,24,0,214,21,215,21,24,0,218,21,219,21,24,0,220,21,24,0,24,0,24,0,24,0,221,
  21,222,21,24,0,24,0,24,0,225,21,24,0,24,0,226,21,24,0,24,0,24,0,24,0,24,0,227,21,24,0,24,
  0,24,0,24,0,219,170,230,240,246,7,211,170,219,169,230,16,192,219,170,230,240,246,6,211,170,219,169,230,2,192,55,
  201,229,245,33,76,22,205,159,9,241,225,201,73,83,67,78,84,67,0,195,65,22,229,245,33,97,22,205,159,9,241,225,
  201,66,69,69,80,0,34,220,243,201,229,245,33,117,22,205,159,9,241,225,201,70,78,75,83,66,0,229,245,33,134,22,
  205,159,9,241,225,201,69,82,65,70,78,75,0,229,245,33,152,22,205,159,9,241,225,201,68,83,80,70,78,75,0,58,
  175,252,254,2,216,58,176,252,205,189,253,183,202,130,3,195,194,3,229,245,33,190,22,205,159,9,241,225,55,201,84,65,
  80,73,79,78,0,229,245,33,209,22,205,159,9,241,225,55,201,84,65,80,73,78,0,229,245,33,226,22,205,159,9,241,
  225,201,84,65,80,73,79,70,0,229,245,33,245,22,205,159,9,241,225,55,201,84,65,80,79,79,78,0,229,245,33,8,
  23,205,159,9,241,225,55,201,84,65,80,79,85,84,0,229,245,33,26,23,205,159,9,241,225,201,84,65,80,79,79,70,
  0,197,71,219,170,4,40,12,203,231,5,40,9,203,167,5,40,4,193,201,238,16,211,170,193,201,30,0,62,8,205,82,
  23,60,205,82,23,60,205,82,23,60,30,184,62,7,205,82,23,201,243,211,160,245,123,211,161,251,241,201,211,160,219,162,
  201,183,62,14,40,1,60,211,171,201,219,168,201,211,168,201,219,153,201,243,197,79,219,170,230,240,177,211,170,219,169,193,
  251,201,205,167,255,201,205,172,255,201,58,100,248,167,201,197,254,0,32,25,62,8,205,115,23,15,15,15,15,47,230,15,
  229,33,242,23,22,0,95,25,126,225,193,167,201,229,213,30,0,61,40,2,203,243,62,15,243,205,92,23,251,230,191,179,
  95,62,15,205,82,23,62,14,243,205,92,23,251,47,230,15,33,226,23,6,0,79,9,126,209,225,193,167,201,62,0,193,
  167,201,0,1,5,0,7,8,6,7,3,2,4,3,0,1,5,0,0,7,1,8,5,6,0,7,3,0,2,1,4,5,
  3,0,254,5,48,3,183,32,9,62,8,205,115,23,246,254,60,201,243,61,213,30,3,71,230,1,40,2,30,76,62,15,
  205,92,23,230,191,179,95,62,15,205,82,23,120,6,16,230,2,40,2,6,32,62,14,243,205,92,23,251,209,160,40,2,
  24,3,62,255,201,175,201,229,245,33,83,24,205,159,9,241,225,175,201,71,84,80,65,68,0,229,245,33,100,24,205,159,
  9,241,225,201,71,84,80,68,76,0,205,154,24,70,4,35,126,144,35,35,166,111,38,0,201,205,154,24,126,60,71,35,
  150,200,120,35,35,229,166,43,43,43,119,225,35,126,35,102,111,5,72,6,0,9,115,246,1,201,42,243,243,71,7,7,
  128,128,79,6,0,9,201,183,219,170,203,183,32,2,203,247,211,170,201,229,245,33,190,24,205,159,9,241,225,201,79,85,
  84,68,76,80,0,46,2,24,3,58,56,251,213,22,0,93,33,65,251,25,30,37,183,40,4,25,61,24,249,209,201,42,
  250,243,34,248,243,201,229,213,197,245,217,8,229,213,197,245,253,229,221,229,205,154,253,219,153,183,50,231,243,242,78,25,
  205,159,253,42,158,252,35,34,158,252,175,50,217,251,58,246,243,61,50,246,243,32,55,62,3,50,246,243,175,205,2,24,
  47,230,1,50,232,243,205,99,25,42,248,243,237,91,250,243,231,32,27,58,247,243,61,50,247,243,32,18,33,218,251,1,
  255,11,113,35,16,252,205,99,25,62,1,50,247,243,221,225,253,225,241,193,209,225,217,8,241,193,209,225,251,201,205,214,
  253,237,69,219,170,230,240,79,6,11,33,229,251,121,211,170,219,169,119,35,12,16,246,221,33,218,251,17,229,251,58,235,
  251,15,33,190,38,56,3,33,238,38,14,11,26,221,190,0,196,180,25,47,221,166,0,8,26,221,119,0,8,6,8,15,
  56,26,35,16,250,221,35,19,13,200,121,254,5,32,221,33,222,39,24,216,245,62,5,50,247,243,241,201,245,121,254,5,
  40,7,254,4,40,28,195,19,26,120,254,3,32,4,62,0,24,33,254,2,32,4,62,1,24,25,254,1,32,53,62,2,
  24,17,120,254,8,32,4,62,3,24,8,254,7,32,36,62,4,24,0,229,197,213,7,7,7,7,33,127,248,22,0,95,
  25,235,26,167,40,8,213,205,32,26,209,19,24,244,209,193,225,24,9,126,167,40,5,229,205,32,26,225,241,195,162,25,
  42,248,243,119,35,125,254,24,32,3,33,240,251,213,237,91,250,243,231,209,200,34,248,243,201,205,63,26,221,225,201,8,
  217,245,197,213,229,237,87,245,217,253,229,58,248,250,245,253,225,8,205,52,36,253,225,8,217,241,226,94,26,251,225,209,
  193,241,217,8,201,24,254,205,218,254,17,34,38,195,135,26,229,245,33,128,26,205,159,9,241,225,17,7,38,195,135,26,
  67,65,76,66,65,83,0,219,153,33,6,40,6,12,14,153,237,179,1,0,8,175,211,152,11,120,177,32,248,33,191,27,
  1,0,8,126,211,152,35,11,120,177,32,247,62,0,211,153,62,64,211,153,33,238,37,126,211,152,35,126,167,32,249,26,
  211,152,19,26,167,32,249,195,101,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,60,66,165,165,195,189,66,60,60,126,219,219,189,195,126,60,108,170,146,68,68,40,16,0,16,
  40,68,130,68,40,16,0,16,56,56,214,254,214,56,0,16,56,124,124,254,214,56,0,0,0,0,24,24,0,0,0,255,
  255,255,231,231,255,255,255,60,66,129,129,129,129,66,60,195,189,126,126,126,126,189,195,12,4,8,112,136,136,112,0,0,
  112,136,136,112,32,112,32,32,48,40,40,32,224,192,0,56,60,36,36,228,220,24,0,16,68,56,170,56,68,16,0,16,
  16,16,56,16,16,16,16,16,16,16,239,0,0,0,0,0,0,0,239,16,16,16,16,16,16,16,224,16,16,16,16,16,
  16,16,15,16,16,16,16,16,16,16,239,16,16,16,16,16,16,16,16,16,16,16,16,0,0,0,255,0,0,0,0,0,
  0,0,15,16,16,16,16,0,0,0,224,16,16,16,16,16,16,16,15,0,0,0,0,16,16,16,224,0,0,0,0,129,
  66,36,24,24,36,66,129,1,2,4,8,16,32,64,128,128,64,32,16,8,4,2,1,0,0,16,255,16,0,0,0,0,
  0,0,0,0,0,0,0,32,32,32,32,0,32,0,0,80,80,0,0,0,0,0,0,0,80,248,80,248,80,0,0,32,
  112,160,112,40,112,32,0,0,200,208,32,88,152,0,0,96,144,96,168,152,96,0,0,64,64,0,0,0,0,0,0,32,
  64,64,64,64,32,0,0,32,16,16,16,16,32,0,0,0,32,168,112,80,136,0,0,0,32,32,248,32,32,0,0,0,
  0,0,0,0,64,64,0,0,0,0,248,0,0,0,0,0,0,0,0,0,64,0,0,0,8,16,32,64,128,0,0,112,
  136,168,168,136,112,0,0,32,96,32,32,32,112,0,0,112,136,8,112,128,248,0,0,248,8,48,8,136,112,0,0,16,
  48,80,248,16,16,0,0,248,128,112,8,136,112,0,0,48,64,112,136,136,112,0,0,248,136,16,32,32,32,0,0,112,
  136,112,136,136,112,0,0,112,136,136,120,8,112,0,0,0,0,64,0,0,64,0,0,0,0,64,0,0,64,64,0,0,
  24,96,128,96,24,0,0,0,0,248,0,248,0,0,0,0,192,48,8,48,192,0,0,112,136,48,32,0,32,0,0,112,
  136,152,168,168,152,64,0,112,136,136,248,136,136,0,0,224,144,224,144,136,240,0,0,112,136,128,128,136,112,0,0,240,
  72,72,72,72,240,0,0,248,128,224,128,128,248,0,0,248,128,128,224,128,128,0,0,112,136,128,184,136,112,0,0,136,
  136,248,136,136,136,0,0,112,32,32,32,32,112,0,0,56,8,8,8,136,112,0,0,136,144,160,224,144,136,0,0,128,
  128,128,128,128,248,0,0,216,168,168,136,136,136,0,0,200,168,168,152,152,136,0,0,112,136,136,136,136,112,0,0,240,
  136,136,240,128,128,0,0,112,136,136,168,144,104,0,0,240,136,136,240,160,152,0,0,112,128,112,8,8,240,0,0,248,
  32,32,32,32,32,0,0,136,136,136,136,136,120,0,0,136,136,136,80,80,32,0,0,136,136,168,168,168,216,0,0,136,
  80,32,80,136,136,0,0,136,136,112,32,32,32,0,0,248,16,32,64,128,248,0,0,112,64,64,64,64,112,0,0,0,
  128,64,32,16,8,0,0,112,16,16,16,16,112,0,0,64,160,0,0,0,0,0,0,0,0,0,0,0,0,248,0,32,
  16,0,0,0,0,0,0,0,0,120,136,152,104,0,0,128,128,240,136,136,240,0,0,0,0,120,128,128,120,0,0,8,
  8,120,136,136,120,0,0,0,0,112,152,224,120,0,0,48,72,64,64,224,64,64,64,0,0,120,136,136,120,8,112,128,
  128,240,136,136,136,0,0,32,0,96,32,32,112,0,0,16,0,48,16,16,16,16,96,128,128,152,160,224,152,0,0,192,
  64,64,64,64,112,0,0,0,0,240,168,168,168,0,0,0,0,240,136,136,136,0,0,0,0,112,136,136,112,0,0,0,
  0,240,136,136,240,128,128,0,0,120,136,136,120,8,8,0,0,184,192,128,128,0,0,0,0,120,240,8,240,0,0,64,
  64,240,64,72,48,0,0,0,0,136,136,136,120,0,0,0,0,136,136,80,32,0,0,0,0,136,168,168,216,0,0,0,
  0,200,48,96,152,0,0,0,0,136,136,136,120,8,112,0,0,248,48,64,248,0,0,16,32,32,64,32,32,16,0,32,
  32,32,32,32,32,32,0,64,32,32,16,32,32,64,0,80,160,0,0,0,0,0,0,0,32,80,80,248,0,0,0,112,
  136,128,128,136,112,32,64,80,0,136,136,136,120,0,0,8,16,112,152,224,120,0,0,32,80,120,136,152,104,0,0,80,
  0,120,136,152,104,0,0,64,32,120,136,152,104,0,0,32,0,120,136,152,104,0,0,0,0,120,128,128,120,32,64,32,
  80,112,152,224,120,0,0,80,0,112,152,224,120,0,0,64,32,112,152,224,120,0,0,80,0,96,32,32,112,0,0,32,
  80,96,32,32,112,0,0,64,32,96,32,32,112,0,0,80,112,136,136,248,136,0,0,32,112,136,136,248,136,0,0,24,
  248,128,224,128,248,0,0,0,0,208,104,176,216,0,0,120,160,176,224,160,184,0,0,32,80,112,136,136,112,0,0,80,
  0,112,136,136,112,0,0,64,32,112,136,136,112,0,0,32,80,136,136,136,120,0,0,64,32,136,136,136,120,0,0,80,
  0,136,136,136,120,8,112,80,112,136,136,136,112,0,0,80,136,136,136,136,112,0,0,32,32,120,128,128,120,32,32,32,
  80,64,224,64,72,176,0,136,136,80,248,32,112,32,0,128,208,176,176,184,208,136,128,56,64,240,64,240,64,56,0,8,
  16,120,136,152,104,0,0,16,32,96,32,32,112,0,0,16,32,112,136,136,112,0,0,16,32,136,136,136,120,0,0,40,
  80,240,136,136,136,0,0,40,208,168,168,152,136,0,0,0,0,120,136,152,104,0,112,0,0,112,136,136,112,0,112,32,
  0,32,96,136,112,0,0,0,0,0,224,128,0,0,0,0,0,0,224,32,0,0,0,64,72,80,48,72,144,56,0,64,
  72,80,40,88,184,8,0,32,0,32,32,32,32,0,0,0,0,0,72,144,72,0,0,0,0,0,144,72,144,0,0,40,
  80,112,136,248,136,0,0,40,80,120,136,152,104,0,0,40,80,112,32,32,112,0,0,40,80,96,32,32,112,0,0,40,
  112,136,136,136,112,0,0,40,80,112,136,136,112,0,0,40,80,136,136,136,120,0,0,40,80,0,136,136,120,0,0,252,
  72,72,72,72,232,8,48,72,0,216,72,72,232,8,48,224,104,48,232,88,184,8,0,80,40,0,0,0,0,0,0,0,
  32,80,136,80,32,0,0,0,72,80,32,104,168,0,0,124,168,168,168,104,40,40,68,112,128,112,136,112,8,136,112,0,
  0,0,0,0,0,255,255,240,240,240,240,15,15,15,15,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,
  0,0,60,60,0,0,0,255,255,255,255,255,255,0,0,192,192,192,192,192,192,192,192,15,15,15,15,240,240,240,240,252,
  252,252,252,252,252,252,252,3,3,3,3,3,3,3,3,63,63,63,63,63,63,63,63,17,34,68,136,17,34,68,136,136,
  68,34,17,136,68,34,17,254,124,56,16,0,0,0,0,0,0,0,0,16,56,124,254,128,192,224,240,224,192,128,0,1,
  3,7,15,7,3,1,0,255,126,60,24,24,60,126,255,129,195,231,255,255,231,195,129,240,240,240,240,0,0,0,0,0,
  0,0,0,15,15,15,15,15,15,15,15,0,0,0,0,0,0,0,0,240,240,240,240,51,51,204,204,51,51,204,204,0,
  16,40,40,124,0,0,0,16,16,56,16,56,16,16,0,0,0,80,136,168,80,0,0,255,255,255,255,255,255,255,255,0,
  0,0,0,255,255,255,255,240,240,240,240,240,240,240,240,15,15,15,15,15,15,15,15,255,255,255,255,0,0,0,0,0,
  0,104,144,144,104,0,0,96,144,224,144,144,224,128,0,248,136,128,128,128,128,0,0,248,80,80,80,80,72,128,0,248,
  72,32,64,136,248,0,0,0,0,120,144,136,112,0,0,0,0,136,136,200,176,128,128,0,0,80,80,32,80,80,32,112,
  32,112,168,168,112,32,112,112,136,248,136,136,112,0,0,112,136,136,136,80,216,0,0,48,64,48,72,72,48,0,0,0,
  0,80,168,168,80,0,0,0,16,112,168,168,112,64,0,0,112,128,224,128,112,0,0,112,136,136,136,136,136,0,0,0,
  248,0,248,0,248,0,0,0,32,32,248,32,32,248,0,0,192,48,8,48,192,248,0,0,24,96,128,96,24,248,0,0,
  24,32,32,32,32,32,32,32,32,32,32,32,32,192,0,0,32,0,248,0,32,0,0,0,104,176,0,104,176,0,0,0,
  48,72,72,48,0,0,0,0,48,120,120,48,0,0,0,0,0,0,0,48,0,0,0,28,16,16,144,80,48,16,0,224,
  144,144,0,0,0,0,0,96,16,96,240,0,0,0,0,0,112,112,112,112,112,112,0,170,85,170,85,170,85,170,85,197,
  229,245,87,167,243,252,222,36,241,225,229,213,229,245,124,7,7,230,3,111,71,62,252,205,248,35,95,69,241,230,3,205,
  248,35,71,219,168,87,163,176,225,205,128,243,123,209,245,203,122,196,26,37,241,225,193,201,4,5,200,7,7,16,252,201,
  229,87,213,167,243,252,222,36,193,225,213,229,124,7,7,230,3,111,71,62,252,205,248,35,95,69,122,230,3,205,248,35,
  71,219,168,87,163,176,225,89,205,133,243,209,229,203,122,196,26,37,225,201,8,217,243,253,229,241,221,229,225,87,167,252,
  222,36,213,122,230,3,71,14,252,221,229,241,7,7,230,3,135,40,7,203,0,203,1,61,32,249,33,103,36,229,219,168,
  245,161,176,217,195,140,243,8,217,243,209,203,122,196,26,37,8,217,201,243,229,111,230,3,71,62,171,198,85,5,242,123,
  36,87,124,7,7,230,3,103,71,62,192,7,7,5,242,139,36,95,47,79,122,163,71,125,167,242,214,36,15,15,230,3,
  229,197,71,62,171,198,85,5,242,165,36,163,71,122,230,192,103,219,168,111,230,192,180,211,168,58,255,255,47,161,176,79,
  50,255,255,125,211,168,33,197,252,122,230,3,133,111,124,206,0,103,121,119,193,225,219,168,161,176,211,168,225,201,87,15,
  15,95,230,192,111,219,168,79,230,63,181,211,168,123,230,3,111,124,38,3,24,2,41,41,214,64,48,250,124,47,103,58,
  255,255,47,95,164,181,50,255,255,111,121,211,168,122,230,3,79,6,0,125,33,197,252,9,119,201,122,15,15,230,192,71,
  219,168,79,230,63,176,211,168,123,50,255,255,121,211,168,122,230,3,79,6,0,33,197,252,9,115,201,211,168,94,24,3,
  211,168,115,122,211,168,201,211,168,8,205,152,243,8,241,211,168,8,201,221,233,0,67,45,66,73,79,83,32,48,46,50,
  57,32,32,32,32,32,32,99,98,105,111,115,46,115,102,46,110,101,116,13,10,67,104,97,114,97,99,116,101,114,32,115,
  101,116,58,32,85,83,13,10,73,110,116,101,114,114,117,112,116,32,102,114,101,113,117,101,110,99,121,58,32,54,48,72,
  122,13,10,75,101,121,98,111,97,114,100,32,116,121,112,101,58,32,85,83,13,10,13,10,13,10,13,10,0,73,110,105,
  116,32,82,79,77,32,105,110,32,115,108,111,116,58,32,0,67,97,110,110,111,116,32,101,120,101,99,117,116,101,32,97,
  32,66,65,83,73,67,32,82,79,77,46,13,10,0,69,82,82,79,82,58,0,77,69,77,79,82,89,32,78,79,84,32,
  70,79,85,78,68,46,0,67,65,76,76,69,68,32,78,79,78,32,69,88,73,83,84,73,78,71,32,66,65,83,73,67,
  46,0,83,84,65,67,75,32,69,82,82,79,82,46,0,13,10,13,10,78,111,32,99,97,114,116,114,105,100,103,101,32,
  102,111,117,110,100,46,13,10,13,10,84,104,105,115,32,118,101,114,115,105,111,110,32,111,102,32,67,45,66,73,79,83,
  32,99,97,110,13,10,111,110,108,121,32,115,116,97,114,116,32,99,97,114,116,114,105,100,103,101,115,46,13,10,80,108,
  101,97,115,101,32,114,101,115,116,97,114,116,32,121,111,117,114,32,77,83,88,13,10,40,101,109,117,108,97,116,111,114,
  41,32,119,105,116,104,32,97,32,99,97,114,116,114,105,100,103,101,13,10,105,110,115,101,114,116,101,100,46,0,48,49,
  50,51,52,53,54,55,56,57,45,61,92,91,93,59,39,96,44,46,47,0,97,98,99,100,101,102,103,104,105,106,107,108,
  109,110,111,112,113,114,115,116,117,118,119,120,121,122,41,33,64,35,36,37,94,38,42,40,95,43,124,123,125,58,34,126,
  60,62,63,0,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,9,172,
  171,186,239,189,244,251,236,7,23,241,30,1,13,6,5,187,243,242,29,0,196,17,188,199,205,20,21,19,220,198,221,200,
  11,27,194,219,204,24,210,18,192,26,207,28,25,15,10,0,253,252,0,0,245,0,0,8,31,240,22,2,14,4,3,247,
  174,175,246,0,254,0,250,193,206,212,16,214,223,202,222,201,12,211,195,215,203,169,209,0,197,213,208,249,170,248,235,159,
  217,191,155,152,224,225,231,135,238,233,0,237,218,183,185,229,134,166,167,0,132,151,141,139,140,148,129,177,161,145,179,181,
  230,164,162,163,131,147,137,150,130,149,136,138,160,133,216,173,158,190,156,157,0,0,226,128,0,0,0,232,234,182,184,228,
  143,0,168,0,142,0,0,0,0,153,154,176,0,146,178,180,0,165,0,227,0,0,0,0,144,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,27,9,0,8,0,13,32,12,0,0,29,30,31,28,42,43,47,48,49,50,51,52,53,54,
  55,56,57,45,44,46,0,128,112,129,0,130,1,132,245,135,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,229,193,27,123,178,40,3,9,24,248,193,201,
  229,245,33,181,49,205,159,9,62,32,211,46,122,211,47,123,211,47,241,225,201,82,79,77,66,65,83,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,229,245,
  33,73,58,205,159,9,241,225,201,66,65,83,73,67,32,115,116,97,116,101,109,101,110,116,115,32,97,114,101,32,110,111,
  116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,142,16,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,245,33,34,125,205,159,9,241,
  225,201,117,110,107,110,111,119,110,64,55,68,49,55,0,57,125,221,33,137,1,205,63,26,201,221,33,133,1,195,63,26,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,245,33,31,126,205,159,9,241,225,201,117,
  110,107,110,111,119,110,64,55,69,49,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
}
namespace MSX2 {
const unsigned char BIOS[32768] = {
  243,195,18,13,191,27,152,152,195,146,17,0,195,210,35,0,195,164,17,0,195,19,36,0,195,192,17,0,195,71,36,0,
  195,198,17,0,195,134,36,0,195,204,17,33,2,1,0,0,195,222,17,0,0,0,0,0,195,154,25,195,243,17,195,253,
  17,195,22,2,195,34,2,195,46,2,195,81,2,195,87,2,195,95,2,195,113,2,195,133,2,195,164,2,195,195,2,195,
  226,2,195,235,2,0,195,18,26,195,53,3,195,148,3,195,157,3,195,166,3,195,175,3,195,184,3,195,16,4,195,63,
  4,195,114,4,195,200,4,195,219,4,195,229,4,195,240,4,195,238,23,195,6,24,195,16,24,195,15,18,195,33,18,195,
  52,18,195,89,18,195,141,21,195,183,21,195,197,21,195,234,21,195,8,22,195,255,21,195,217,22,195,245,22,195,7,23,
  195,10,23,195,41,7,195,26,23,195,30,23,195,47,23,195,65,23,195,83,23,195,67,24,195,182,24,195,251,24,195,13,
  25,195,102,23,195,121,23,195,139,23,195,157,23,195,176,23,195,195,23,195,213,23,195,30,25,195,45,25,195,80,8,195,
  98,8,195,115,8,195,130,8,195,146,8,195,163,8,195,181,8,195,197,8,195,0,9,195,14,9,195,32,9,195,50,9,
  195,67,9,195,83,9,195,101,9,195,119,9,195,137,9,195,154,9,195,91,25,195,21,24,195,30,24,195,33,24,195,36,
  24,195,39,24,195,54,24,195,58,24,195,62,24,195,103,25,195,121,25,195,125,25,195,147,25,195,36,27,195,237,26,195,
  243,26,195,222,16,195,44,6,195,59,27,195,50,6,195,71,6,195,81,6,195,141,6,195,147,6,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  79,6,0,9,9,195,17,2,190,35,40,5,35,35,16,248,201,78,35,102,105,233,58,224,243,230,191,71,14,1,205,46,
  2,201,58,224,243,246,64,71,14,1,205,46,2,201,243,203,185,120,211,153,121,246,128,211,153,251,229,33,223,243,121,254,
  8,56,7,254,24,48,8,33,223,255,120,6,0,9,119,225,201,205,95,2,219,152,201,245,205,113,2,241,211,152,201,243,
  175,211,153,62,142,211,153,125,211,153,124,230,63,211,153,251,201,243,175,211,153,62,142,211,153,125,211,153,124,230,63,246,
  64,211,153,251,201,245,58,175,252,254,5,48,5,205,113,2,24,3,205,81,6,11,12,120,65,79,12,241,211,152,16,252,
  13,32,249,201,58,175,252,254,4,48,5,205,95,2,24,3,205,71,6,229,235,11,12,120,65,60,14,152,237,178,61,32,
  251,225,201,235,58,175,252,254,4,48,5,205,113,2,24,3,205,81,6,235,11,12,120,65,60,14,152,237,179,61,32,251,
  235,201,221,229,221,33,209,0,195,237,26,58,175,252,254,8,40,58,61,245,58,233,243,7,7,7,7,230,240,111,58,235,
  243,181,71,14,7,205,46,2,241,192,58,233,243,7,7,7,7,230,240,33,234,243,182,42,191,243,1,32,0,245,205,113,
  2,241,211,152,245,11,120,177,32,247,241,201,58,235,243,71,14,7,195,46,2,58,175,252,183,200,205,95,3,58,175,252,
  254,4,56,16,42,40,249,37,37,1,0,2,58,233,243,230,15,205,50,6,42,38,249,1,0,8,175,205,50,6,201,58,
  175,252,254,4,56,4,30,217,24,2,30,209,42,40,249,205,81,6,58,233,243,87,1,0,32,243,123,211,152,62,0,211,
  152,121,211,152,12,205,229,4,48,3,12,12,12,122,211,152,16,232,251,201,221,229,221,33,213,0,195,237,26,221,229,221,
  33,217,0,195,237,26,221,229,221,33,221,0,195,237,26,221,229,221,33,225,0,195,237,26,58,176,243,254,41,48,40,58,
  223,243,230,241,71,14,0,205,46,2,58,224,243,230,231,246,16,71,12,205,46,2,17,179,243,14,2,175,205,163,4,19,
  19,12,175,205,163,4,201,58,223,243,230,241,246,4,71,14,0,205,46,2,58,224,243,230,231,246,16,71,12,205,46,2,
  17,34,249,14,2,62,3,205,163,4,12,175,205,163,4,201,58,223,243,230,241,71,14,0,205,46,2,58,224,243,230,231,
  71,12,205,46,2,17,189,243,14,2,175,205,163,4,175,205,163,4,175,205,163,4,175,205,163,4,175,205,163,4,201,58,
  223,243,230,241,246,2,71,14,0,205,46,2,58,224,243,230,231,71,12,205,46,2,17,199,243,14,2,175,205,163,4,62,
  127,205,163,4,62,3,205,163,4,175,205,163,4,175,205,163,4,201,58,223,243,230,241,71,14,0,205,46,2,58,224,243,
  230,231,246,8,71,12,205,46,2,17,209,243,14,2,175,205,163,4,175,205,163,4,175,205,163,4,175,205,163,4,175,205,
  163,4,201,213,245,33,193,4,6,0,9,70,235,126,35,102,111,41,143,16,252,71,241,176,71,205,46,2,209,19,19,12,
  201,0,0,6,10,5,9,5,38,0,111,41,41,41,205,229,4,48,2,41,41,237,91,38,249,25,201,135,135,42,40,249,
  22,0,95,25,201,58,224,243,15,15,62,8,208,62,32,201,245,254,32,56,13,58,175,252,254,2,40,43,254,5,48,28,
  241,201,254,13,32,250,241,229,197,42,185,252,1,8,0,9,34,185,252,33,0,0,34,183,252,193,225,201,241,221,229,221,
  33,137,0,195,237,26,201,241,229,213,197,245,205,46,8,237,91,185,252,237,75,183,252,205,197,8,58,233,243,50,242,243,
  42,42,249,237,75,203,243,9,17,64,252,58,185,252,230,7,6,0,79,9,205,116,5,1,240,0,9,58,185,252,47,230,
  7,79,205,116,5,42,183,252,1,8,0,9,34,183,252,241,193,209,225,201,58,183,252,230,7,245,197,213,229,205,253,5,
  58,183,252,230,7,40,26,58,44,249,47,50,44,249,225,1,8,0,9,209,193,241,205,253,5,58,44,249,47,50,44,249,
  201,193,1,8,0,9,193,193,241,201,245,229,197,213,87,88,237,75,201,243,9,79,58,242,243,230,15,71,205,81,2,245,
  230,15,184,40,17,241,245,15,15,15,15,230,15,184,32,13,241,209,193,225,241,201,241,209,193,225,241,47,201,122,179,254,
  255,40,17,241,203,0,203,0,203,0,203,0,230,15,176,205,87,2,24,221,241,230,240,176,205,87,2,24,218,65,60,79,
  62,7,168,60,71,197,205,81,2,71,26,205,170,5,13,40,3,15,24,250,79,58,44,249,161,79,120,177,205,87,2,35,
  19,193,16,225,201,71,82,80,80,82,84,0,58,175,252,254,5,201,245,205,81,6,11,12,120,65,79,12,241,243,211,152,
  16,252,13,32,249,251,201,205,93,6,124,230,63,211,153,251,201,205,93,6,124,230,63,246,64,211,153,251,201,58,246,250,
  183,40,16,58,175,252,254,5,218,113,2,254,7,58,246,250,56,1,135,229,230,3,15,111,230,128,172,23,203,21,23,125,
  23,243,211,153,62,142,211,153,225,125,211,153,201,205,71,6,219,152,201,245,205,81,6,241,211,152,201,243,211,153,62,143,
  211,153,219,153,245,175,211,153,62,143,211,153,251,241,201,219,153,1,0,0,205,46,2,1,1,224,205,46,2,1,2,0,
  205,46,2,1,3,128,205,46,2,1,4,1,205,46,2,1,8,8,205,46,2,62,1,50,220,243,50,221,243,205,90,7,
  62,0,33,0,8,1,0,8,205,133,2,62,245,33,0,32,1,32,0,205,133,2,1,7,245,205,46,2,33,191,27,17,
  0,8,1,0,8,205,195,2,201,1,20,0,205,46,2,1,21,59,205,46,2,1,22,5,205,46,2,201,33,191,27,237,
  91,36,249,1,0,8,195,195,2,192,58,175,252,254,9,208,229,33,57,7,205,0,2,225,201,75,7,90,7,118,7,140,
  7,118,7,160,7,176,7,195,7,211,7,58,176,243,254,40,1,192,3,56,8,1,128,7,24,3,1,0,3,42,34,249,
  62,32,205,133,2,62,1,33,178,251,119,17,179,251,1,23,0,237,176,195,234,18,175,1,0,24,42,36,249,111,197,205,
  133,2,193,58,234,243,42,201,243,195,133,2,58,234,243,230,15,71,7,7,7,7,176,1,0,8,42,36,249,195,133,2,
  58,234,243,230,15,71,7,7,7,7,176,33,0,1,24,41,58,234,243,230,3,71,7,7,176,7,7,7,7,176,33,0,
  2,24,22,58,234,243,230,15,71,7,7,7,7,176,33,0,2,24,6,58,234,243,33,0,1,245,205,37,8,241,14,44,
  205,27,8,14,40,205,21,8,33,212,0,14,42,205,21,8,33,0,0,14,36,205,21,8,58,246,250,103,46,0,14,38,
  205,21,8,62,0,14,45,205,27,8,62,192,14,46,205,27,8,205,37,8,201,125,205,27,8,12,124,243,211,153,121,246,
  128,211,153,251,201,62,2,205,155,6,31,56,248,201,237,75,32,249,111,38,0,41,41,41,9,6,8,17,64,252,197,213,
  229,58,31,249,205,210,35,225,209,193,18,19,35,16,239,201,229,245,33,91,8,205,171,9,241,225,201,82,73,71,72,84,
  67,0,229,245,33,109,8,205,171,9,241,225,201,76,69,70,84,67,0,229,245,33,126,8,205,171,9,241,225,201,85,80,
  67,0,229,245,33,141,8,205,171,9,241,225,201,84,85,80,67,0,229,245,33,157,8,205,171,9,241,225,201,68,79,87,
  78,67,0,229,245,33,174,8,205,171,9,241,225,201,84,68,79,87,78,67,0,237,75,183,252,237,91,185,252,201,83,67,
  65,76,88,89,0,197,237,67,183,252,237,83,185,252,42,185,252,41,41,41,41,41,46,0,6,0,62,255,50,44,249,121,
  230,7,40,10,71,62,255,167,31,16,252,50,44,249,121,230,248,79,6,0,9,34,42,249,193,201,77,65,80,88,89,0,
  58,44,249,42,42,249,201,70,69,84,67,72,67,0,229,245,33,25,9,205,171,9,241,225,201,83,84,79,82,69,67,0,
  229,245,33,43,9,205,171,9,241,225,201,83,69,84,65,84,82,0,229,245,33,61,9,205,171,9,241,225,201,82,69,65,
  68,67,0,229,245,33,78,9,205,171,9,241,225,201,83,69,84,67,0,229,245,33,94,9,205,171,9,241,225,201,78,83,
  69,84,67,88,0,229,245,33,112,9,205,171,9,241,225,201,71,84,65,83,80,67,0,229,245,33,130,9,205,171,9,241,
  225,201,80,78,84,73,78,73,0,229,245,33,148,9,205,171,9,241,225,201,83,67,65,78,82,0,229,245,33,165,9,205,
  171,9,241,225,201,83,67,65,78,76,0,62,35,211,46,205,183,9,62,0,211,46,201,126,35,183,200,211,47,24,248,230,
  15,254,10,48,5,198,48,211,47,201,198,55,211,47,201,245,15,15,15,15,205,191,9,241,205,191,9,201,124,205,207,9,
  125,205,207,9,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,201,221,225,253,225,241,193,209,225,217,8,241,193,209,225,251,201,62,130,211,171,62,80,211,170,175,211,255,60,211,254,
  60,211,253,60,211,252,33,255,255,217,219,168,246,240,71,120,211,168,58,255,255,47,246,240,79,121,50,255,255,33,0,255,
  62,15,119,190,32,8,47,119,190,32,3,37,24,242,36,124,183,40,21,217,188,56,5,40,3,217,24,12,46,0,103,217,
  120,217,71,217,121,217,79,217,121,214,16,79,48,203,120,214,16,71,48,187,217,125,183,40,6,17,10,38,195,76,27,120,
  211,168,121,50,255,255,217,33,0,243,249,205,83,15,205,151,16,205,222,16,205,175,6,251,205,243,17,6,15,17,79,14,
  33,0,128,197,229,213,58,193,252,205,210,35,225,209,193,190,32,18,235,19,35,16,236,221,33,16,128,253,42,192,252,205,
  71,36,24,17,62,5,50,234,243,50,235,243,205,157,3,33,105,37,205,51,17,243,62,4,211,153,62,142,211,153,175,211,
  153,246,64,211,153,62,118,211,152,175,211,153,33,252,250,211,153,219,152,254,118,40,4,203,206,24,2,203,214,175,211,153,
  62,142,211,153,251,6,120,205,47,17,205,191,35,62,4,50,235,243,62,4,50,234,243,62,15,50,233,243,62,29,50,175,
  243,205,157,3,221,33,65,1,205,243,26,33,105,37,205,51,17,205,94,14,205,218,254,205,61,15,62,1,50,153,253,175,
  50,41,251,205,203,254,33,68,38,205,51,17,195,25,27,67,45,66,73,79,83,32,76,111,103,111,32,82,79,77,33,201,
  252,17,202,252,1,63,0,54,0,237,176,33,193,252,175,229,182,33,0,64,205,165,14,204,178,14,33,0,128,205,165,14,
  204,178,14,203,127,40,6,198,4,203,103,40,228,225,35,60,230,3,32,219,201,71,205,210,35,35,245,120,205,210,35,35,
  87,241,95,120,201,229,205,149,14,33,65,66,205,198,17,120,225,201,229,245,33,210,37,205,51,17,241,245,71,230,3,198,
  48,205,89,18,120,203,120,40,15,62,46,205,89,18,120,15,15,230,3,198,48,205,89,18,62,13,205,89,18,62,10,205,
  89,18,241,225,35,35,205,52,15,40,21,79,213,221,225,245,253,225,219,153,183,250,242,14,245,229,205,71,36,243,225,241,
  14,0,205,52,15,40,2,203,233,205,52,15,40,2,203,241,205,52,15,40,2,203,249,71,230,12,95,120,7,7,7,7,
  230,48,179,95,124,7,7,230,3,179,33,201,252,22,0,95,25,113,120,201,197,205,149,14,122,179,120,193,201,33,201,252,
  6,64,126,203,127,40,8,229,33,229,37,205,51,17,225,35,16,240,201,62,0,33,128,243,119,17,129,243,1,125,12,237,
  176,62,201,33,0,243,119,17,1,243,1,127,0,237,176,62,201,33,154,253,119,17,155,253,1,77,2,237,176,62,255,33,
  218,251,119,17,219,251,1,21,0,237,176,62,0,33,240,251,119,17,241,251,1,39,0,237,176,62,0,33,231,255,119,17,
  232,255,1,15,0,237,176,62,8,50,231,255,62,0,50,232,255,33,240,251,34,248,243,34,250,243,217,34,72,252,217,33,
  128,243,34,74,252,34,116,246,33,78,37,17,128,243,1,26,0,237,176,33,0,0,34,179,243,33,0,8,34,183,243,33,
  0,24,34,189,243,33,0,32,34,191,243,33,0,0,34,193,243,33,0,27,34,195,243,33,0,56,34,197,243,33,0,24,
  34,199,243,33,0,32,34,201,243,33,0,0,34,203,243,33,0,27,34,205,243,33,0,56,34,207,243,33,0,8,34,209,
  243,33,0,0,34,213,243,33,0,27,34,215,243,33,0,56,34,217,243,33,89,249,34,243,243,33,117,249,34,93,249,33,
  245,249,34,99,249,33,117,250,34,105,249,62,127,50,92,249,50,98,249,50,104,249,62,39,50,174,243,62,32,50,175,243,
  58,175,243,50,176,243,62,24,50,177,243,62,4,50,235,243,62,4,50,234,243,62,15,50,233,243,62,160,50,224,243,58,
  193,252,50,31,249,42,4,0,34,32,249,62,195,33,89,18,34,229,254,50,228,254,201,243,33,193,252,219,168,87,230,63,
  79,211,168,58,255,255,47,95,230,15,50,255,255,71,58,255,255,47,184,32,21,123,230,15,246,80,50,255,255,71,58,255,
  255,47,184,32,5,6,128,123,24,4,6,0,123,47,50,255,255,122,211,168,112,35,121,198,64,79,48,197,251,201,1,0,
  4,33,193,252,197,229,121,182,203,127,32,5,205,13,17,24,3,205,0,17,225,193,216,35,12,16,233,175,50,248,250,201,
  6,4,197,205,13,17,193,216,198,4,16,246,201,79,50,248,250,33,0,0,205,38,17,254,67,32,6,35,205,38,17,254,
  68,121,55,200,183,201,121,197,229,205,210,35,225,193,201,118,16,253,201,58,175,252,254,5,48,9,126,183,200,205,89,18,
  35,24,247,126,183,200,221,33,137,0,205,243,26,35,24,243,14,32,58,175,252,183,192,14,40,58,176,243,254,41,216,14,
  80,201,197,245,205,80,17,58,176,243,237,68,129,60,203,63,111,58,221,243,61,133,111,38,0,68,58,220,243,61,203,63,
  48,1,9,203,33,203,16,183,32,244,237,75,34,249,9,241,193,201,229,245,33,157,17,205,171,9,241,225,201,83,89,78,
  67,72,82,0,205,72,255,126,35,254,0,200,254,58,200,254,48,56,3,254,58,216,254,32,40,237,254,9,40,233,183,201,
  245,205,228,254,241,201,124,186,192,125,187,201,229,245,33,215,17,205,171,9,241,225,201,71,69,84,89,80,82,0,8,217,
  225,126,35,94,35,86,35,213,221,225,245,253,225,229,8,217,195,71,36,30,143,62,15,205,6,24,195,238,23,229,245,33,
  8,18,205,171,9,241,225,201,73,78,73,70,78,75,0,229,245,33,26,18,205,171,9,241,225,201,83,84,82,84,77,83,
  0,251,229,213,42,250,243,237,91,248,243,231,62,255,32,1,175,209,225,201,205,194,253,229,213,42,250,243,237,91,248,243,
  231,32,4,251,118,24,242,126,245,35,125,254,24,32,3,33,240,251,34,250,243,241,209,225,201,229,213,197,245,205,164,253,
  58,175,252,254,2,48,19,241,245,205,184,20,241,245,205,127,18,205,205,20,58,221,243,50,97,246,241,193,209,225,201,205,
  197,21,208,40,18,245,58,167,252,183,194,98,19,241,254,32,56,42,254,127,202,170,20,205,98,17,205,87,2,42,220,243,
  58,176,243,36,188,56,4,34,220,243,201,17,177,251,38,0,25,175,119,42,220,243,205,17,19,195,211,18,6,12,33,60,
  21,195,8,2,62,32,205,151,18,58,221,243,230,7,254,1,32,242,201,42,220,243,58,177,243,44,189,48,9,229,205,234,
  18,205,53,20,225,45,34,220,243,201,33,1,1,34,220,243,201,205,211,19,42,220,243,229,205,17,19,58,220,243,33,177,
  243,190,48,8,205,211,18,205,211,19,24,239,225,34,220,243,201,62,1,50,221,243,201,62,255,50,167,252,201,58,221,243,
  33,176,243,190,48,3,60,24,31,58,220,243,33,177,243,190,208,60,50,220,243,24,218,58,221,243,61,32,11,58,220,243,
  61,200,50,220,243,58,176,243,50,221,243,201,58,220,243,61,200,50,220,243,201,58,220,243,33,177,243,190,208,60,50,220,
  243,201,71,60,32,12,50,167,252,241,6,15,33,96,21,195,8,2,241,16,4,14,0,24,4,16,24,14,1,254,52,40,
  6,254,53,40,8,24,46,121,50,170,252,24,40,121,50,169,252,24,34,16,8,6,31,144,50,221,243,24,24,16,22,6,
  31,144,50,220,243,62,3,24,13,62,1,24,9,62,2,24,5,62,4,24,1,175,50,167,252,201,58,221,243,33,176,243,
  190,208,60,50,221,243,201,58,221,243,61,200,50,221,243,201,205,17,19,33,177,251,58,220,243,95,22,0,25,119,58,176,
  243,60,33,221,243,150,79,6,0,62,32,205,98,17,195,133,2,205,17,19,42,220,243,229,69,58,177,243,50,220,243,144,
  71,4,58,220,243,24,14,205,98,17,235,61,50,220,243,205,98,17,205,115,20,16,240,225,34,220,243,38,0,58,177,243,
  87,30,0,149,61,79,6,0,33,177,251,25,235,98,107,43,237,184,195,211,19,205,17,19,42,220,243,229,69,58,177,243,
  144,71,4,58,220,243,24,14,205,98,17,235,60,50,220,243,205,98,17,205,115,20,16,240,205,211,19,225,34,220,243,38,
  0,58,177,243,149,61,79,6,0,17,177,251,25,84,93,35,237,176,201,245,197,6,0,58,176,243,79,254,41,56,11,14,
  40,205,144,20,58,176,243,214,40,79,205,144,20,193,241,201,229,213,197,17,24,252,205,164,2,193,209,213,197,33,24,252,
  205,195,2,193,225,9,235,225,9,201,58,221,243,254,1,200,62,32,205,151,18,195,55,19,58,169,252,254,1,192,58,175,
  252,254,2,208,58,204,251,205,98,17,195,87,2,58,169,252,254,1,192,58,175,252,254,2,208,205,98,17,205,81,2,50,
  204,251,167,22,0,95,203,19,203,18,203,19,203,18,203,19,203,18,175,33,175,252,190,32,5,42,183,243,24,3,42,193,
  243,229,25,17,24,252,1,8,0,205,164,2,58,170,252,254,0,32,7,33,24,252,6,8,24,5,33,30,252,6,2,126,
  47,119,35,16,250,225,17,248,7,25,235,33,24,252,1,8,0,205,195,2,205,98,17,62,255,195,87,2,7,10,23,8,
  55,19,9,196,18,10,211,18,11,234,18,12,42,7,13,17,19,27,23,19,28,29,19,29,55,19,30,76,19,31,85,19,
  106,42,7,69,42,7,75,211,19,74,241,18,108,208,19,76,241,19,77,53,20,89,177,19,65,76,19,66,85,19,67,186,
  19,68,199,19,72,234,18,120,169,19,121,173,19,205,182,255,245,205,217,22,56,8,205,183,21,40,246,241,24,12,62,13,
  205,170,21,175,50,21,244,241,55,201,245,211,145,62,0,211,144,47,211,144,241,167,201,205,187,255,219,144,31,31,62,255,
  48,1,47,167,201,229,245,33,166,252,175,190,119,32,8,241,254,1,32,19,119,24,17,241,254,64,56,9,254,96,48,5,
  214,64,191,24,2,254,80,55,225,201,205,219,253,58,170,246,167,202,8,22,62,1,50,221,243,195,8,22,63,32,0,205,
  224,253,33,252,21,205,51,17,42,221,243,34,202,251,17,176,251,38,0,125,25,119,205,52,18,254,127,202,152,22,254,32,
  48,17,6,20,33,153,22,205,0,2,175,50,168,252,50,170,252,24,227,245,58,168,252,167,196,63,22,241,223,24,201,205,
  184,20,42,220,243,34,188,246,62,32,50,167,246,205,98,17,205,81,2,254,32,32,40,42,220,243,58,176,243,188,32,29,
  38,0,17,177,251,25,126,183,40,19,58,167,246,205,98,17,205,87,2,42,188,246,34,220,243,201,195,205,20,62,32,245,
  58,167,246,223,241,50,167,246,24,195,201,55,225,201,201,201,201,201,175,225,201,201,201,201,201,24,0,24,0,138,22,139,
  22,24,0,142,22,143,22,24,0,144,22,24,0,24,0,24,0,24,0,145,22,146,22,24,0,24,0,24,0,149,22,24,
  0,24,0,150,22,24,0,24,0,24,0,24,0,24,0,151,22,24,0,24,0,24,0,24,0,219,170,230,240,246,7,211,
  170,219,169,230,16,192,219,170,230,240,246,6,211,170,219,169,230,2,192,55,201,229,245,33,0,23,205,171,9,241,225,201,
  73,83,67,78,84,67,0,195,245,22,229,245,33,21,23,205,171,9,241,225,201,66,69,69,80,0,34,220,243,201,229,245,
  33,41,23,205,171,9,241,225,201,70,78,75,83,66,0,229,245,33,58,23,205,171,9,241,225,201,69,82,65,70,78,75,
  0,229,245,33,76,23,205,171,9,241,225,201,68,83,80,70,78,75,0,58,175,252,254,2,216,58,176,252,205,189,253,183,
  202,148,3,195,157,3,229,245,33,114,23,205,171,9,241,225,55,201,84,65,80,73,79,78,0,229,245,33,133,23,205,171,
  9,241,225,55,201,84,65,80,73,78,0,229,245,33,150,23,205,171,9,241,225,201,84,65,80,73,79,70,0,229,245,33,
  169,23,205,171,9,241,225,55,201,84,65,80,79,79,78,0,229,245,33,188,23,205,171,9,241,225,55,201,84,65,80,79,
  85,84,0,229,245,33,206,23,205,171,9,241,225,201,84,65,80,79,79,70,0,197,71,219,170,4,40,12,203,231,5,40,
  9,203,167,5,40,4,193,201,238,16,211,170,193,201,30,0,62,8,205,6,24,60,205,6,24,60,205,6,24,60,30,184,
  62,7,205,6,24,201,243,211,160,245,123,211,161,251,241,201,211,160,219,162,201,183,62,14,40,1,60,211,171,201,219,168,
  201,211,168,201,219,153,201,243,197,79,219,170,230,240,177,211,170,219,169,193,251,201,205,167,255,201,205,172,255,201,58,100,
  248,167,201,197,254,0,32,25,62,8,205,39,24,15,15,15,15,47,230,15,229,33,166,24,22,0,95,25,126,225,193,167,
  201,229,213,30,0,61,40,2,203,243,62,15,243,205,16,24,251,230,191,179,95,62,15,205,6,24,62,14,243,205,16,24,
  251,47,230,15,33,150,24,6,0,79,9,126,209,225,193,167,201,62,0,193,167,201,0,1,5,0,7,8,6,7,3,2,
  4,3,0,1,5,0,0,7,1,8,5,6,0,7,3,0,2,1,4,5,3,0,254,5,48,3,183,32,9,62,8,205,
  39,24,246,254,60,201,243,61,213,30,3,71,230,1,40,2,30,76,62,15,205,16,24,230,191,179,95,62,15,205,6,24,
  120,6,16,230,2,40,2,6,32,62,14,243,205,16,24,251,209,160,40,2,24,3,62,255,201,175,201,229,245,33,7,25,
  205,171,9,241,225,175,201,71,84,80,65,68,0,229,245,33,24,25,205,171,9,241,225,201,71,84,80,68,76,0,205,78,
  25,70,4,35,126,144,35,35,166,111,38,0,201,205,78,25,126,60,71,35,150,200,120,35,35,229,166,43,43,43,119,225,
  35,126,35,102,111,5,72,6,0,9,115,246,1,201,42,243,243,71,7,7,128,128,79,6,0,9,201,183,219,170,203,183,
  32,2,203,247,211,170,201,229,245,33,114,25,205,171,9,241,225,201,79,85,84,68,76,80,0,46,2,24,3,58,56,251,
  213,22,0,93,33,65,251,25,30,37,183,40,4,25,61,24,249,209,201,42,250,243,34,248,243,201,229,213,197,245,217,8,
  229,213,197,245,253,229,221,229,205,154,253,219,153,183,50,231,243,242,2,26,205,159,253,42,158,252,35,34,158,252,175,50,
  217,251,58,246,243,61,50,246,243,32,55,62,3,50,246,243,175,205,182,24,47,230,1,50,232,243,205,23,26,42,248,243,
  237,91,250,243,231,32,27,58,247,243,61,50,247,243,32,18,33,218,251,1,255,11,113,35,16,252,205,23,26,62,1,50,
  247,243,221,225,253,225,241,193,209,225,217,8,241,193,209,225,251,201,205,214,253,237,69,219,170,230,240,79,6,11,33,229,
  251,121,211,170,219,169,119,35,12,16,246,221,33,218,251,17,229,251,58,235,251,15,33,211,38,56,3,33,3,39,14,11,
  26,221,190,0,196,104,26,47,221,166,0,8,26,221,119,0,8,6,8,15,56,26,35,16,250,221,35,19,13,200,121,254,
  5,32,221,33,243,39,24,216,245,62,5,50,247,243,241,201,245,121,254,5,40,7,254,4,40,28,195,199,26,120,254,3,
  32,4,62,0,24,33,254,2,32,4,62,1,24,25,254,1,32,53,62,2,24,17,120,254,8,32,4,62,3,24,8,254,
  7,32,36,62,4,24,0,229,197,213,7,7,7,7,33,127,248,22,0,95,25,235,26,167,40,8,213,205,212,26,209,19,
  24,244,209,193,225,24,9,126,167,40,5,229,205,212,26,225,241,195,86,26,42,248,243,119,35,125,254,24,32,3,33,240,
  251,213,237,91,250,243,231,209,200,34,248,243,201,205,243,26,221,225,201,8,217,245,197,213,229,237,87,245,217,253,229,58,
  248,250,245,253,225,8,205,71,36,253,225,8,217,241,226,18,27,251,225,209,193,241,217,8,201,24,254,205,218,254,17,55,
  38,195,76,27,229,245,33,52,27,205,171,9,241,225,17,28,38,195,76,27,67,65,76,66,65,83,0,237,91,220,243,213,
  34,220,243,205,211,19,209,237,83,220,243,201,219,153,33,27,40,6,12,14,153,237,179,1,0,8,175,211,152,11,120,177,
  32,248,33,191,27,1,0,8,126,211,152,35,11,120,177,32,247,62,0,211,153,62,64,211,153,33,3,38,126,211,152,35,
  126,167,32,249,26,211,152,19,26,167,32,249,195,25,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,60,66,165,165,195,189,66,60,60,126,219,219,189,195,126,60,108,170,146,68,68,40,16,0,16,
  40,68,130,68,40,16,0,16,56,56,214,254,214,56,0,16,56,124,124,254,214,56,0,0,0,0,24,24,0,0,0,255,
  255,255,231,231,255,255,255,60,66,129,129,129,129,66,60,195,189,126,126,126,126,189,195,12,4,8,112,136,136,112,0,0,
  112,136,136,112,32,112,32,32,48,40,40,32,224,192,0,56,60,36,36,228,220,24,0,16,68,56,170,56,68,16,0,16,
  16,16,56,16,16,16,16,16,16,16,239,0,0,0,0,0,0,0,239,16,16,16,16,16,16,16,224,16,16,16,16,16,
  16,16,15,16,16,16,16,16,16,16,239,16,16,16,16,16,16,16,16,16,16,16,16,0,0,0,255,0,0,0,0,0,
  0,0,15,16,16,16,16,0,0,0,224,16,16,16,16,16,16,16,15,0,0,0,0,16,16,16,224,0,0,0,0,129,
  66,36,24,24,36,66,129,1,2,4,8,16,32,64,128,128,64,32,16,8,4,2,1,0,0,16,255,16,0,0,0,0,
  0,0,0,0,0,0,0,32,32,32,32,0,32,0,0,80,80,0,0,0,0,0,0,0,80,248,80,248,80,0,0,32,
  112,160,112,40,112,32,0,0,200,208,32,88,152,0,0,96,144,96,168,152,96,0,0,64,64,0,0,0,0,0,0,32,
  64,64,64,64,32,0,0,32,16,16,16,16,32,0,0,0,32,168,112,80,136,0,0,0,32,32,248,32,32,0,0,0,
  0,0,0,0,64,64,0,0,0,0,248,0,0,0,0,0,0,0,0,0,64,0,0,0,8,16,32,64,128,0,0,112,
  136,168,168,136,112,0,0,32,96,32,32,32,112,0,0,112,136,8,112,128,248,0,0,248,8,48,8,136,112,0,0,16,
  48,80,248,16,16,0,0,248,128,112,8,136,112,0,0,48,64,112,136,136,112,0,0,248,136,16,32,32,32,0,0,112,
  136,112,136,136,112,0,0,112,136,136,120,8,112,0,0,0,0,64,0,0,64,0,0,0,0,64,0,0,64,64,0,0,
  24,96,128,96,24,0,0,0,0,248,0,248,0,0,0,0,192,48,8,48,192,0,0,112,136,48,32,0,32,0,0,112,
  136,152,168,168,152,64,0,112,136,136,248,136,136,0,0,224,144,224,144,136,240,0,0,112,136,128,128,136,112,0,0,240,
  72,72,72,72,240,0,0,248,128,224,128,128,248,0,0,248,128,128,224,128,128,0,0,112,136,128,184,136,112,0,0,136,
  136,248,136,136,136,0,0,112,32,32,32,32,112,0,0,56,8,8,8,136,112,0,0,136,144,160,224,144,136,0,0,128,
  128,128,128,128,248,0,0,216,168,168,136,136,136,0,0,200,168,168,152,152,136,0,0,112,136,136,136,136,112,0,0,240,
  136,136,240,128,128,0,0,112,136,136,168,144,104,0,0,240,136,136,240,160,152,0,0,112,128,112,8,8,240,0,0,248,
  32,32,32,32,32,0,0,136,136,136,136,136,120,0,0,136,136,136,80,80,32,0,0,136,136,168,168,168,216,0,0,136,
  80,32,80,136,136,0,0,136,136,112,32,32,32,0,0,248,16,32,64,128,248,0,0,112,64,64,64,64,112,0,0,0,
  128,64,32,16,8,0,0,112,16,16,16,16,112,0,0,64,160,0,0,0,0,0,0,0,0,0,0,0,0,248,0,32,
  16,0,0,0,0,0,0,0,0,120,136,152,104,0,0,128,128,240,136,136,240,0,0,0,0,120,128,128,120,0,0,8,
  8,120,136,136,120,0,0,0,0,112,152,224,120,0,0,48,72,64,64,224,64,64,64,0,0,120,136,136,120,8,112,128,
  128,240,136,136,136,0,0,32,0,96,32,32,112,0,0,16,0,48,16,16,16,16,96,128,128,152,160,224,152,0,0,192,
  64,64,64,64,112,0,0,0,0,240,168,168,168,0,0,0,0,240,136,136,136,0,0,0,0,112,136,136,112,0,0,0,
  0,240,136,136,240,128,128,0,0,120,136,136,120,8,8,0,0,184,192,128,128,0,0,0,0,120,240,8,240,0,0,64,
  64,240,64,72,48,0,0,0,0,136,136,136,120,0,0,0,0,136,136,80,32,0,0,0,0,136,168,168,216,0,0,0,
  0,200,48,96,152,0,0,0,0,136,136,136,120,8,112,0,0,248,48,64,248,0,0,16,32,32,64,32,32,16,0,32,
  32,32,32,32,32,32,0,64,32,32,16,32,32,64,0,80,160,0,0,0,0,0,0,0,32,80,80,248,0,0,0,112,
  136,128,128,136,112,32,64,80,0,136,136,136,120,0,0,8,16,112,152,224,120,0,0,32,80,120,136,152,104,0,0,80,
  0,120,136,152,104,0,0,64,32,120,136,152,104,0,0,32,0,120,136,152,104,0,0,0,0,120,128,128,120,32,64,32,
  80,112,152,224,120,0,0,80,0,112,152,224,120,0,0,64,32,112,152,224,120,0,0,80,0,96,32,32,112,0,0,32,
  80,96,32,32,112,0,0,64,32,96,32,32,112,0,0,80,112,136,136,248,136,0,0,32,112,136,136,248,136,0,0,24,
  248,128,224,128,248,0,0,0,0,208,104,176,216,0,0,120,160,176,224,160,184,0,0,32,80,112,136,136,112,0,0,80,
  0,112,136,136,112,0,0,64,32,112,136,136,112,0,0,32,80,136,136,136,120,0,0,64,32,136,136,136,120,0,0,80,
  0,136,136,136,120,8,112,80,112,136,136,136,112,0,0,80,136,136,136,136,112,0,0,32,32,120,128,128,120,32,32,32,
  80,64,224,64,72,176,0,136,136,80,248,32,112,32,0,128,208,176,176,184,208,136,128,56,64,240,64,240,64,56,0,8,
  16,120,136,152,104,0,0,16,32,96,32,32,112,0,0,16,32,112,136,136,112,0,0,16,32,136,136,136,120,0,0,40,
  80,240,136,136,136,0,0,40,208,168,168,152,136,0,0,0,0,120,136,152,104,0,112,0,0,112,136,136,112,0,112,32,
  0,32,96,136,112,0,0,0,0,0,224,128,0,0,0,0,0,0,224,32,0,0,0,64,72,80,48,72,144,56,0,64,
  72,80,40,88,184,8,0,32,0,32,32,32,32,0,0,0,0,0,72,144,72,0,0,0,0,0,144,72,144,0,0,40,
  80,112,136,248,136,0,0,40,80,120,136,152,104,0,0,40,80,112,32,32,112,0,0,40,80,96,32,32,112,0,0,40,
  112,136,136,136,112,0,0,40,80,112,136,136,112,0,0,40,80,136,136,136,120,0,0,40,80,0,136,136,120,0,0,252,
  72,72,72,72,232,8,48,72,0,216,72,72,232,8,48,224,104,48,232,88,184,8,0,80,40,0,0,0,0,0,0,0,
  32,80,136,80,32,0,0,0,72,80,32,104,168,0,0,124,168,168,168,104,40,40,68,112,128,112,136,112,8,136,112,0,
  0,0,0,0,0,255,255,240,240,240,240,15,15,15,15,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,
  0,0,60,60,0,0,0,255,255,255,255,255,255,0,0,192,192,192,192,192,192,192,192,15,15,15,15,240,240,240,240,252,
  252,252,252,252,252,252,252,3,3,3,3,3,3,3,3,63,63,63,63,63,63,63,63,17,34,68,136,17,34,68,136,136,
  68,34,17,136,68,34,17,254,124,56,16,0,0,0,0,0,0,0,0,16,56,124,254,128,192,224,240,224,192,128,0,1,
  3,7,15,7,3,1,0,255,126,60,24,24,60,126,255,129,195,231,255,255,231,195,129,240,240,240,240,0,0,0,0,0,
  0,0,0,15,15,15,15,15,15,15,15,0,0,0,0,0,0,0,0,240,240,240,240,51,51,204,204,51,51,204,204,0,
  16,40,40,124,0,0,0,16,16,56,16,56,16,16,0,0,0,80,136,168,80,0,0,255,255,255,255,255,255,255,255,0,
  0,0,0,255,255,255,255,240,240,240,240,240,240,240,240,15,15,15,15,15,15,15,15,255,255,255,255,0,0,0,0,0,
  0,104,144,144,104,0,0,96,144,224,144,144,224,128,0,248,136,128,128,128,128,0,0,248,80,80,80,80,72,128,0,248,
  72,32,64,136,248,0,0,0,0,120,144,136,112,0,0,0,0,136,136,200,176,128,128,0,0,80,80,32,80,80,32,112,
  32,112,168,168,112,32,112,112,136,248,136,136,112,0,0,112,136,136,136,80,216,0,0,48,64,48,72,72,48,0,0,0,
  0,80,168,168,80,0,0,0,16,112,168,168,112,64,0,0,112,128,224,128,112,0,0,112,136,136,136,136,136,0,0,0,
  248,0,248,0,248,0,0,0,32,32,248,32,32,248,0,0,192,48,8,48,192,248,0,0,24,96,128,96,24,248,0,0,
  24,32,32,32,32,32,32,32,32,32,32,32,32,192,0,0,32,0,248,0,32,0,0,0,104,176,0,104,176,0,0,0,
  48,72,72,48,0,0,0,0,48,120,120,48,0,0,0,0,0,0,0,48,0,0,0,28,16,16,144,80,48,16,0,224,
  144,144,0,0,0,0,0,96,16,96,240,0,0,0,0,0,112,112,112,112,112,112,0,170,85,170,85,170,85,170,85,175,
  211,153,246,64,211,153,1,0,64,175,211,152,11,120,177,32,248,201,197,229,245,87,167,243,252,241,36,241,225,229,213,229,
  245,124,7,7,230,3,111,71,62,252,205,11,36,95,69,241,230,3,205,11,36,71,219,168,87,163,176,225,205,128,243,123,
  209,245,203,122,196,45,37,241,225,193,201,4,5,200,7,7,16,252,201,229,87,213,167,243,252,241,36,193,225,213,229,124,
  7,7,230,3,111,71,62,252,205,11,36,95,69,122,230,3,205,11,36,71,219,168,87,163,176,225,89,205,133,243,209,229,
  203,122,196,45,37,225,201,8,217,243,253,229,241,221,229,225,87,167,252,241,36,213,122,230,3,71,14,252,221,229,241,7,
  7,230,3,135,40,7,203,0,203,1,61,32,249,33,122,36,229,219,168,245,161,176,217,195,140,243,8,217,243,209,203,122,
  196,45,37,8,217,201,243,229,111,230,3,71,62,171,198,85,5,242,142,36,87,124,7,7,230,3,103,71,62,192,7,7,
  5,242,158,36,95,47,79,122,163,71,125,167,242,233,36,15,15,230,3,229,197,71,62,171,198,85,5,242,184,36,163,71,
  122,230,192,103,219,168,111,230,192,180,211,168,58,255,255,47,161,176,79,50,255,255,125,211,168,33,197,252,122,230,3,133,
  111,124,206,0,103,121,119,193,225,219,168,161,176,211,168,225,201,87,15,15,95,230,192,111,219,168,79,230,63,181,211,168,
  123,230,3,111,124,38,3,24,2,41,41,214,64,48,250,124,47,103,58,255,255,47,95,164,181,50,255,255,111,121,211,168,
  122,230,3,79,6,0,125,33,197,252,9,119,201,122,15,15,230,192,71,219,168,79,230,63,176,211,168,123,50,255,255,121,
  211,168,122,230,3,79,6,0,33,197,252,9,115,201,211,168,94,24,3,211,168,115,122,211,168,201,211,168,8,205,152,243,
  8,241,211,168,8,201,221,233,0,67,45,66,73,79,83,32,48,46,50,57,32,32,32,32,32,32,99,98,105,111,115,46,
  115,102,46,110,101,116,13,10,67,104,97,114,97,99,116,101,114,32,115,101,116,58,32,85,83,13,10,68,101,102,97,117,
  108,116,32,105,110,116,101,114,114,117,112,116,32,102,114,101,113,46,58,32,54,48,72,122,75,101,121,98,111,97,114,100,
  32,116,121,112,101,58,32,85,83,13,10,13,10,13,10,13,10,0,73,110,105,116,32,82,79,77,32,105,110,32,115,108,
  111,116,58,32,0,67,97,110,110,111,116,32,101,120,101,99,117,116,101,32,97,32,66,65,83,73,67,32,82,79,77,46,
  13,10,0,69,82,82,79,82,58,0,77,69,77,79,82,89,32,78,79,84,32,70,79,85,78,68,46,0,67,65,76,76,
  69,68,32,78,79,78,32,69,88,73,83,84,73,78,71,32,66,65,83,73,67,46,0,83,84,65,67,75,32,69,82,82,
  79,82,46,0,13,10,13,10,78,111,32,99,97,114,116,114,105,100,103,101,32,102,111,117,110,100,46,13,10,13,10,84,
  104,105,115,32,118,101,114,115,105,111,110,32,111,102,32,67,45,66,73,79,83,32,99,97,110,13,10,111,110,108,121,32,
  115,116,97,114,116,32,99,97,114,116,114,105,100,103,101,115,46,13,10,80,108,101,97,115,101,32,114,101,115,116,97,114,
  116,32,121,111,117,114,32,77,83,88,13,10,40,101,109,117,108,97,116,111,114,41,32,119,105,116,104,32,97,32,99,97,
  114,116,114,105,100,103,101,13,10,105,110,115,101,114,116,101,100,46,0,48,49,50,51,52,53,54,55,56,57,45,61,92,
  91,93,59,39,96,44,46,47,0,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,
  120,121,122,41,33,64,35,36,37,94,38,42,40,95,43,124,123,125,58,34,126,60,62,63,0,65,66,67,68,69,70,71,
  72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,9,172,171,186,239,189,244,251,236,7,23,241,30,
  1,13,6,5,187,243,242,29,0,196,17,188,199,205,20,21,19,220,198,221,200,11,27,194,219,204,24,210,18,192,26,207,
  28,25,15,10,0,253,252,0,0,245,0,0,8,31,240,22,2,14,4,3,247,174,175,246,0,254,0,250,193,206,212,16,
  214,223,202,222,201,12,211,195,215,203,169,209,0,197,213,208,249,170,248,235,159,217,191,155,152,224,225,231,135,238,233,0,
  237,218,183,185,229,134,166,167,0,132,151,141,139,140,148,129,177,161,145,179,181,230,164,162,163,131,147,137,150,130,149,136,
  138,160,133,216,173,158,190,156,157,0,0,226,128,0,0,0,232,234,182,184,228,143,0,168,0,142,0,0,0,0,153,154,
  176,0,146,178,180,0,165,0,227,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,9,0,
  8,0,13,32,12,0,0,29,30,31,28,42,43,47,48,49,50,51,52,53,54,55,56,57,45,44,46,0,128,112,129,0,
  130,1,132,245,135,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,229,193,27,123,178,40,3,9,24,248,193,201,
  229,245,33,181,49,205,171,9,62,32,211,46,122,211,47,123,211,47,241,225,201,82,79,77,66,65,83,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,229,245,
  33,73,58,205,171,9,241,225,201,66,65,83,73,67,32,115,116,97,116,101,109,101,110,116,115,32,97,114,101,32,110,111,
  116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,51,17,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,245,33,34,125,205,171,9,241,
  225,201,117,110,107,110,111,119,110,64,55,68,49,55,0,57,125,221,33,137,1,205,243,26,201,221,33,133,1,195,243,26,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,245,33,31,126,205,171,9,241,225,201,117,
  110,107,110,111,119,110,64,55,69,49,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char Sub[16384] = {
  67,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,183,201,0,201,0,0,0,201,0,0,0,201,0,0,0,
  124,186,192,125,187,201,0,0,201,0,0,0,0,0,0,0,201,201,201,201,201,201,201,201,245,197,213,229,8,217,245,197,
  213,229,221,229,253,229,221,33,56,0,253,42,192,252,205,197,2,253,225,221,225,225,209,193,241,8,217,225,209,193,241,237,
  77,201,201,201,201,201,205,214,253,237,69,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
  201,201,201,201,201,251,195,242,14,251,195,4,15,251,195,252,13,251,195,115,15,251,195,121,14,251,195,103,14,251,195,138,
  14,251,195,133,15,251,195,151,13,251,195,151,15,251,195,169,13,251,195,234,13,251,195,217,13,251,195,201,13,251,195,186,
  13,251,195,208,14,251,195,225,14,251,195,169,15,251,195,11,16,251,195,179,4,251,195,197,5,251,195,22,6,251,195,96,
  6,251,195,165,6,251,195,248,6,251,195,80,7,251,195,127,7,251,195,178,7,251,195,102,5,251,195,8,8,251,195,27,
  8,251,195,37,8,251,195,117,13,251,195,202,9,251,195,196,9,251,195,28,5,251,195,110,12,251,195,77,16,201,201,201,
  201,201,201,201,201,201,201,201,201,201,201,201,201,251,195,255,3,251,195,210,9,201,201,201,201,201,201,201,201,251,195,97,
  16,251,195,188,16,251,195,216,16,251,195,239,16,251,195,5,17,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
  201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,251,195,124,
  17,251,195,140,17,251,195,158,17,251,195,176,17,201,201,201,201,251,195,3,18,251,195,28,18,251,195,146,18,251,195,242,
  18,251,195,3,19,251,195,20,19,251,195,37,19,251,195,54,19,201,201,201,201,251,195,72,19,201,201,201,201,251,195,79,
  19,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
  201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,251,195,97,19,251,195,126,19,201,201,201,
  79,6,0,9,9,195,17,2,190,35,40,5,35,35,16,248,201,78,35,102,105,233,62,35,211,46,205,34,2,62,0,211,
  46,201,126,35,183,200,211,47,24,248,230,15,254,10,48,5,198,48,211,47,201,198,55,211,47,201,245,15,15,15,15,205,
  42,2,241,205,42,2,201,124,205,58,2,125,205,58,2,201,197,229,245,87,167,243,252,111,3,241,225,229,213,229,245,124,
  7,7,230,3,111,71,62,252,205,137,2,95,69,241,230,3,205,137,2,71,219,168,87,163,176,225,205,128,243,123,209,245,
  203,122,196,171,3,241,225,193,201,4,5,200,7,7,16,252,201,229,87,213,167,243,252,111,3,193,225,213,229,124,7,7,
  230,3,111,71,62,252,205,137,2,95,69,122,230,3,205,137,2,71,219,168,87,163,176,225,89,205,133,243,209,229,203,122,
  196,171,3,225,201,8,217,243,253,229,241,221,229,225,87,167,252,111,3,213,122,230,3,71,14,252,221,229,241,7,7,230,
  3,135,40,7,203,0,203,1,61,32,249,33,248,2,229,219,168,245,161,176,217,195,140,243,8,217,243,209,203,122,196,171,
  3,8,217,201,243,229,111,230,3,71,62,171,198,85,5,242,12,3,87,124,7,7,230,3,103,71,62,192,7,7,5,242,
  28,3,95,47,79,122,163,71,125,167,242,103,3,15,15,230,3,229,197,71,62,171,198,85,5,242,54,3,163,71,122,230,
  192,103,219,168,111,230,192,180,211,168,58,255,255,47,161,176,79,50,255,255,125,211,168,33,197,252,122,230,3,133,111,124,
  206,0,103,121,119,193,225,219,168,161,176,211,168,225,201,87,15,15,95,230,192,111,219,168,79,230,63,181,211,168,123,230,
  3,111,124,38,3,24,2,41,41,214,64,48,250,124,47,103,58,255,255,47,95,164,181,50,255,255,111,121,211,168,122,230,
  3,79,6,0,125,33,197,252,9,119,201,122,15,15,230,192,71,219,168,79,230,63,176,211,168,123,50,255,255,121,211,168,
  122,230,3,79,6,0,33,197,252,9,115,201,211,168,94,24,3,211,168,115,122,211,168,201,211,168,8,205,152,243,8,241,
  211,168,8,201,221,233,0,58,224,243,230,191,71,14,1,205,255,3,201,58,224,243,246,64,71,14,1,205,255,3,201,243,
  203,185,120,211,153,121,246,128,211,153,251,229,33,223,243,121,254,8,56,7,254,24,48,8,33,223,255,120,6,0,9,119,
  225,201,205,48,4,219,152,201,245,205,66,4,241,211,152,201,243,175,211,153,62,142,211,153,125,211,153,124,230,63,211,153,
  251,201,243,175,211,153,62,142,211,153,125,211,153,124,230,63,246,64,211,153,251,201,245,58,175,252,254,5,48,5,205,66,
  4,24,3,205,136,9,11,12,120,65,79,12,241,211,152,16,252,13,32,249,201,58,175,252,254,4,48,5,205,48,4,24,
  3,205,126,9,229,235,11,12,120,65,60,14,152,237,178,61,32,251,225,201,235,58,175,252,254,4,48,5,205,66,4,24,
  3,205,136,9,235,11,12,120,65,60,14,152,237,179,61,32,251,235,201,254,9,208,33,188,4,195,0,2,197,5,22,6,
  96,6,165,6,115,10,253,10,91,11,183,11,19,12,33,232,255,58,175,252,254,5,48,4,203,190,24,2,203,254,175,50,
  236,255,175,50,246,255,243,33,223,243,1,153,8,22,128,237,163,120,237,81,20,183,32,247,62,8,211,153,62,145,211,153,
  33,231,255,1,155,7,237,179,35,35,35,62,18,211,153,62,145,211,153,1,155,6,237,179,251,195,243,3,58,175,252,254,
  8,40,58,61,245,58,233,243,7,7,7,7,230,240,111,58,235,243,181,71,14,7,205,255,3,241,192,58,233,243,7,7,
  7,7,230,240,33,234,243,182,42,191,243,1,32,0,245,205,66,4,241,211,152,245,11,120,177,32,247,241,201,58,235,243,
  71,14,7,195,255,3,58,175,252,183,200,205,144,5,58,175,252,254,4,56,16,42,40,249,37,37,1,0,2,58,233,243,
  230,15,205,105,9,42,38,249,1,0,8,175,205,105,9,201,58,175,252,254,4,56,4,30,217,24,2,30,209,42,40,249,
  205,136,9,58,233,243,87,1,0,32,243,123,211,152,62,0,211,152,121,211,152,12,205,37,8,48,3,12,12,12,122,211,
  152,16,232,251,201,205,231,3,62,0,50,175,252,50,176,252,175,50,245,250,50,246,250,58,174,243,50,176,243,62,1,50,
  220,243,50,221,243,42,179,243,34,34,249,42,183,243,58,176,243,254,41,56,3,33,0,16,34,36,249,42,185,243,34,40,
  249,42,187,243,34,38,249,205,28,5,205,248,6,205,92,10,205,143,12,195,206,4,205,231,3,62,1,50,175,252,50,176,
  252,62,1,50,220,243,50,221,243,205,28,5,42,189,243,34,34,249,42,193,243,34,36,249,42,197,243,34,38,249,42,195,
  243,34,40,249,205,92,10,58,175,243,50,176,243,175,50,245,250,50,246,250,205,80,7,205,155,5,205,158,12,195,206,4,
  205,231,3,62,2,50,175,252,205,28,5,42,199,243,34,34,249,205,66,4,6,3,175,243,211,152,60,32,251,16,249,251,
  42,203,243,34,36,249,42,205,243,34,40,249,42,207,243,34,38,249,175,50,245,250,50,246,250,205,127,7,205,155,5,205,
  189,12,195,206,4,205,231,3,62,3,50,175,252,205,28,5,42,209,243,34,34,249,205,66,4,175,14,6,243,245,30,4,
  245,6,32,211,152,60,16,251,241,29,32,244,241,198,32,13,32,235,251,42,213,243,34,36,249,42,215,243,34,40,249,42,
  217,243,34,38,249,175,50,245,250,50,246,250,205,178,7,205,155,5,205,211,12,195,206,4,58,176,243,254,41,48,40,58,
  223,243,230,241,71,14,0,205,255,3,58,224,243,230,231,246,16,71,12,205,255,3,17,179,243,14,2,175,205,227,7,19,
  19,12,175,205,227,7,201,58,223,243,230,241,246,4,71,14,0,205,255,3,58,224,243,230,231,246,16,71,12,205,255,3,
  17,34,249,14,2,62,3,205,227,7,12,175,205,227,7,201,58,223,243,230,241,71,14,0,205,255,3,58,224,243,230,231,
  71,12,205,255,3,17,189,243,14,2,175,205,227,7,175,205,227,7,175,205,227,7,175,205,227,7,175,205,227,7,201,58,
  223,243,230,241,246,2,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,17,199,243,14,2,175,205,227,7,62,
  127,205,227,7,62,3,205,227,7,175,205,227,7,175,205,227,7,201,58,223,243,230,241,71,14,0,205,255,3,58,224,243,
  230,231,246,8,71,12,205,255,3,17,209,243,14,2,175,205,227,7,175,205,227,7,175,205,227,7,175,205,227,7,175,205,
  227,7,201,213,245,33,1,8,6,0,9,70,235,126,35,102,111,41,143,16,252,71,241,176,71,205,255,3,209,19,19,12,
  201,0,0,6,10,5,9,5,38,0,111,41,41,41,205,37,8,48,2,41,41,237,91,38,249,25,201,135,135,42,40,249,
  22,0,95,25,201,58,224,243,15,15,62,8,208,62,32,201,245,254,32,56,13,58,175,252,254,2,40,34,254,5,48,28,
  241,201,254,13,32,250,241,229,197,42,185,252,1,8,0,9,34,185,252,33,0,0,34,183,252,193,225,201,241,201,241,229,
  213,197,245,205,117,13,237,91,185,252,237,75,183,252,205,12,14,58,233,243,50,242,243,42,42,249,237,75,203,243,9,17,
  64,252,58,185,252,230,7,6,0,79,9,205,171,8,1,240,0,9,58,185,252,47,230,7,79,205,171,8,42,183,252,1,
  8,0,9,34,183,252,241,193,209,225,201,58,183,252,230,7,245,197,213,229,205,52,9,58,183,252,230,7,40,26,58,44,
  249,47,50,44,249,225,1,8,0,9,209,193,241,205,52,9,58,44,249,47,50,44,249,201,193,1,8,0,9,193,193,241,
  201,245,229,197,213,87,88,237,75,201,243,9,79,58,242,243,230,15,71,205,34,4,245,230,15,184,40,17,241,245,15,15,
  15,15,230,15,184,32,13,241,209,193,225,241,201,241,209,193,225,241,47,201,122,179,254,255,40,17,241,203,0,203,0,203,
  0,203,0,230,15,176,205,40,4,24,221,241,230,240,176,205,40,4,24,218,65,60,79,62,7,168,60,71,197,205,34,4,
  71,26,205,225,8,13,40,3,15,24,250,79,58,44,249,161,79,120,177,205,40,4,35,19,193,16,225,201,71,82,80,80,
  82,84,0,58,175,252,254,5,201,245,205,136,9,11,12,120,65,79,12,241,243,211,152,16,252,13,32,249,251,201,205,148,
  9,124,230,63,211,153,251,201,205,148,9,124,230,63,246,64,211,153,251,201,58,246,250,183,40,16,58,175,252,254,5,218,
  66,4,254,7,58,246,250,56,1,135,229,230,3,15,111,230,128,172,23,203,21,23,125,23,243,211,153,62,142,211,153,225,
  125,211,153,201,205,126,9,219,152,201,245,205,136,9,241,211,152,201,243,211,153,62,143,211,153,219,153,245,175,211,153,62,
  143,211,153,251,241,201,219,153,1,0,0,205,255,3,1,1,224,205,255,3,1,2,0,205,255,3,1,3,128,205,255,3,
  1,4,1,205,255,3,1,8,8,205,255,3,62,1,50,220,243,50,221,243,205,158,12,62,0,33,0,8,1,0,8,205,
  86,4,62,245,33,0,32,1,32,0,205,86,4,1,7,245,205,255,3,33,191,27,17,0,8,1,0,8,253,42,192,252,
  221,33,92,0,205,197,2,251,201,1,20,0,205,255,3,1,21,59,205,255,3,1,22,5,205,255,3,201,33,191,27,237,
  91,36,249,1,0,8,253,42,192,252,221,33,92,0,205,197,2,251,201,205,231,3,62,4,50,175,252,205,28,5,42,199,
  243,34,34,249,205,66,4,6,3,175,243,211,152,60,32,251,16,249,251,42,203,243,34,36,249,42,205,243,34,40,249,42,
  207,243,34,38,249,58,223,243,230,241,246,4,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,1,14,0,205,
  255,3,17,199,243,14,2,175,205,227,7,62,127,205,227,7,62,3,205,227,7,17,251,10,62,3,205,227,7,17,207,243,
  175,205,227,7,33,233,255,54,0,35,54,0,205,155,5,1,14,0,205,255,3,205,189,12,195,206,4,0,30,205,231,3,
  62,5,50,175,252,205,28,5,58,223,243,230,241,246,6,71,14,0,205,255,3,58,224,243,230,231,246,32,71,12,205,255,
  3,33,0,0,34,34,249,33,0,120,34,38,249,33,0,118,34,40,249,175,50,245,250,50,246,250,1,2,31,205,255,3,
  1,5,239,205,255,3,1,11,0,205,255,3,1,6,15,205,255,3,205,151,5,205,231,12,195,206,4,205,231,3,62,6,
  50,175,252,205,28,5,58,223,243,230,241,246,8,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,33,0,0,
  34,34,249,33,0,120,34,38,249,33,0,118,34,40,249,175,50,245,250,50,246,250,1,2,31,205,255,3,1,5,239,205,
  255,3,1,11,0,205,255,3,1,6,15,205,255,3,205,151,5,205,247,12,195,206,4,205,231,3,62,7,50,175,252,205,
  28,5,58,223,243,230,241,246,10,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,33,0,0,34,34,249,33,
  0,240,34,38,249,33,0,250,34,40,249,175,50,245,250,50,246,250,1,2,31,205,255,3,1,5,247,205,255,3,1,11,
  1,205,255,3,1,6,30,205,255,3,205,151,5,205,10,13,195,206,4,205,231,3,62,8,50,175,252,205,28,5,58,223,
  243,246,14,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,33,0,0,34,34,249,33,0,240,34,38,249,33,
  0,250,34,40,249,175,50,245,250,50,246,250,1,2,31,205,255,3,1,5,247,205,255,3,1,11,1,205,255,3,1,6,
  30,205,255,3,205,151,5,205,26,13,195,206,4,192,58,175,252,254,9,208,229,33,125,12,205,0,2,225,201,143,12,158,
  12,189,12,211,12,189,12,231,12,247,12,10,13,26,13,58,176,243,254,40,1,192,3,56,8,1,128,7,24,3,1,0,
  3,42,34,249,62,32,205,86,4,33,1,1,34,220,243,125,33,178,251,119,17,179,251,1,23,0,237,176,201,175,1,0,
  24,42,36,249,111,197,205,86,4,193,58,234,243,42,201,243,195,86,4,58,234,243,230,15,71,7,7,7,7,176,1,0,
  8,42,36,249,195,86,4,58,234,243,230,15,71,7,7,7,7,176,33,0,1,24,41,58,234,243,230,3,71,7,7,176,
  7,7,7,7,176,33,0,2,24,22,58,234,243,230,15,71,7,7,7,7,176,33,0,2,24,6,58,234,243,33,0,1,
  245,205,108,13,241,14,44,205,98,13,14,40,205,92,13,33,212,0,14,42,205,92,13,33,0,0,14,36,205,92,13,58,
  246,250,103,46,0,14,38,205,92,13,62,0,14,45,205,98,13,62,192,14,46,205,98,13,205,108,13,201,125,205,98,13,
  12,124,243,211,153,121,246,128,211,153,251,201,62,2,205,210,9,31,56,248,201,237,75,32,249,111,38,0,41,41,41,9,
  6,8,17,64,252,197,213,229,58,31,249,205,80,2,225,209,193,18,19,35,16,239,201,229,245,33,162,13,205,22,2,241,
  225,201,82,73,71,72,84,67,0,229,245,33,180,13,205,22,2,241,225,201,76,69,70,84,67,0,229,245,33,197,13,205,
  22,2,241,225,201,85,80,67,0,229,245,33,212,13,205,22,2,241,225,201,84,85,80,67,0,229,245,33,228,13,205,22,
  2,241,225,201,68,79,87,78,67,0,229,245,33,245,13,205,22,2,241,225,201,84,68,79,87,78,67,0,237,75,183,252,
  237,91,185,252,201,83,67,65,76,88,89,0,197,237,67,183,252,237,83,185,252,42,185,252,41,41,41,41,41,46,0,6,
  0,62,255,50,44,249,121,230,7,40,10,71,62,255,167,31,16,252,50,44,249,121,230,248,79,6,0,9,34,42,249,193,
  201,77,65,80,88,89,0,58,44,249,42,42,249,201,70,69,84,67,72,67,0,229,245,33,96,14,205,22,2,241,225,201,
  83,84,79,82,69,67,0,229,245,33,114,14,205,22,2,241,225,201,83,69,84,65,84,82,0,229,245,33,132,14,205,22,
  2,241,225,201,82,69,65,68,67,0,229,245,33,149,14,205,22,2,241,225,201,83,69,84,67,0,229,245,33,165,14,205,
  22,2,241,225,201,78,83,69,84,67,88,0,229,245,33,183,14,205,22,2,241,225,201,71,84,65,83,80,67,0,229,245,
  33,201,14,205,22,2,241,225,201,80,78,84,73,78,73,0,229,245,33,219,14,205,22,2,241,225,201,83,67,65,78,82,
  0,229,245,33,236,14,205,22,2,241,225,201,83,67,65,78,76,0,229,245,33,253,14,205,22,2,241,225,201,68,79,71,
  82,80,72,0,197,213,229,205,117,13,58,233,243,50,242,243,42,183,252,34,102,245,1,8,0,9,34,183,252,58,246,250,
  42,185,252,103,34,104,245,237,67,106,245,237,67,108,245,33,64,252,203,6,58,242,243,56,3,58,234,243,50,110,245,205,
  194,17,58,2,251,230,15,246,176,237,121,62,172,211,153,62,145,211,153,251,6,8,14,7,33,64,252,203,6,58,242,243,
  56,3,58,234,243,211,155,13,32,241,35,14,8,16,236,225,209,193,201,229,245,33,126,15,205,22,2,241,225,201,77,65,
  80,88,89,67,0,229,245,33,144,15,205,22,2,241,225,201,84,82,73,71,72,84,0,229,245,33,162,15,205,22,2,241,
  225,201,84,82,73,71,72,84,0,58,246,250,87,213,237,67,102,245,237,83,104,245,42,179,252,167,237,66,34,106,245,33,
  0,0,34,108,245,175,50,111,245,58,242,243,50,110,245,205,253,15,42,181,252,58,246,250,103,34,104,245,205,253,15,209,
  237,83,104,245,62,1,50,111,245,58,181,252,147,50,106,245,205,253,15,42,179,252,34,102,245,205,253,15,201,205,194,17,
  58,2,251,230,15,246,112,237,121,251,201,42,181,252,231,48,1,235,167,237,82,35,34,108,245,58,246,250,87,237,83,104,
  245,197,209,42,179,252,231,48,1,235,167,237,82,35,34,106,245,237,83,102,245,175,50,111,245,58,242,243,50,110,245,205,
  194,17,58,2,251,230,15,246,128,237,121,251,201,229,245,33,90,16,205,22,2,241,225,195,110,12,67,76,82,84,88,84,
  0,229,213,197,42,34,249,203,4,203,4,58,245,250,15,15,15,132,246,31,71,14,2,205,255,3,58,175,252,254,7,32,
  19,58,229,243,230,31,71,58,245,250,15,15,15,176,71,14,6,205,255,3,58,245,250,79,58,175,252,254,7,32,2,203,
  33,175,42,40,249,41,143,177,111,62,3,180,71,14,5,205,255,3,69,14,11,205,255,3,193,209,225,201,229,205,39,17,
  205,136,9,1,16,0,205,255,3,6,32,33,92,17,126,211,152,35,211,154,16,248,225,201,229,205,39,17,205,126,9,225,
  1,16,0,205,255,3,6,32,219,152,211,154,16,250,201,229,245,205,39,17,241,135,79,6,0,9,205,126,9,219,152,71,
  219,152,79,225,201,245,197,229,205,39,17,122,135,79,6,0,9,205,136,9,225,66,14,16,205,255,3,193,241,211,154,211,
  152,123,211,154,211,152,201,58,175,252,183,204,62,17,60,33,72,17,135,133,111,124,206,0,103,126,35,102,111,201,103,58,
  176,243,254,40,124,208,61,201,0,4,0,15,32,32,128,27,32,32,128,27,128,118,128,118,128,250,128,250,0,0,0,0,
  17,6,51,7,23,1,39,3,81,1,39,6,113,1,115,3,97,6,100,6,17,4,101,2,85,5,119,7,229,245,33,135,
  17,205,22,2,241,225,201,66,69,69,80,0,229,245,33,151,17,205,22,2,241,225,201,80,82,79,77,80,84,0,229,245,
  33,169,17,205,22,2,241,225,201,83,68,70,83,67,82,0,229,245,33,187,17,205,22,2,241,225,201,83,69,84,83,67,
  82,0,62,2,205,210,9,31,56,248,243,62,32,211,153,62,145,211,153,1,155,14,33,98,245,237,179,201,120,177,55,200,
  122,179,55,200,229,33,0,1,58,175,252,230,6,254,6,58,175,252,32,1,36,183,237,66,225,216,229,33,212,0,183,237,
  82,225,201,237,75,106,245,237,91,108,245,205,220,17,216,205,194,17,126,230,15,246,144,237,121,251,183,201,42,98,245,78,
  35,70,35,237,67,106,245,94,35,86,35,237,83,108,245,205,220,17,216,254,8,17,4,1,40,10,254,6,17,1,4,40,
  3,17,2,2,78,175,67,203,17,23,203,17,23,16,248,50,110,245,66,5,197,229,205,194,17,126,230,15,246,176,237,121,
  62,172,211,153,62,145,211,153,251,225,193,62,2,205,210,9,203,71,200,203,127,40,244,120,167,40,18,197,175,67,203,17,
  23,203,17,23,16,248,211,155,121,193,79,16,238,35,78,66,24,217,42,102,245,237,75,106,245,237,91,108,245,113,35,112,
  35,115,35,114,35,205,220,17,216,254,8,17,1,1,40,10,254,6,17,2,4,40,3,17,4,2,229,205,194,17,126,230,
  15,62,160,237,121,251,225,66,14,0,62,2,205,210,9,203,127,32,4,203,71,32,243,197,62,7,205,210,9,67,203,1,
  16,252,177,193,79,16,227,113,35,62,2,205,210,9,31,56,214,201,229,245,33,253,18,205,22,2,241,225,201,66,76,84,
  86,68,0,229,245,33,14,19,205,22,2,241,225,201,66,76,84,68,86,0,229,245,33,31,19,205,22,2,241,225,201,66,
  76,84,77,68,0,229,245,33,48,19,205,22,2,241,225,201,66,76,84,68,77,0,229,245,33,65,19,205,22,2,241,225,
  201,78,69,87,80,65,68,0,205,179,4,205,188,16,201,229,245,33,90,19,205,22,2,241,225,201,75,78,74,80,82,84,
  0,197,62,13,211,180,121,15,15,15,15,230,3,71,219,181,176,193,211,181,121,230,15,211,180,219,181,230,15,201,197,71,
  197,62,13,211,180,121,15,15,15,15,230,3,71,219,181,176,193,211,181,121,230,15,211,180,120,230,15,211,181,193,201,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
}
namespace Nintendo64 {
const unsigned char PIFNTSC[1984] = {
  60,9,52,0,64,137,96,0,60,9,0,6,53,41,228,99,64,137,128,0,60,8,164,4,141,8,0,16,49,8,0,1,
  81,0,255,253,60,8,164,4,36,8,0,10,60,1,164,4,172,40,0,16,60,8,164,4,141,8,0,24,49,8,0,1,
  85,0,255,253,60,8,164,4,36,8,0,3,60,1,164,96,172,40,0,16,36,8,3,255,60,1,164,64,172,40,0,12,
  60,1,164,64,172,32,0,36,60,1,164,64,172,32,0,16,60,1,164,80,172,32,0,0,60,1,164,80,172,32,0,4,
  60,8,164,4,141,8,0,16,49,8,0,4,85,0,255,253,60,8,164,4,60,11,164,0,60,12,191,192,60,13,191,192,
  37,107,16,0,37,140,0,212,37,173,7,28,141,137,0,0,37,140,0,4,37,107,0,4,21,141,255,252,173,105,255,252,
  60,11,164,0,60,29,164,0,37,107,16,0,1,96,0,8,55,189,31,240,60,13,191,192,141,168,7,252,37,173,7,192,
  49,8,0,128,85,0,255,252,60,13,191,192,141,168,0,36,60,11,176,0,0,8,156,194,50,115,0,1,0,8,188,130,
  18,96,0,2,50,247,0,1,60,11,166,0,0,8,178,2,49,10,0,255,0,8,172,66,141,168,0,60,36,9,0,16,
  50,214,0,255,50,181,0,1,36,20,0,1,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,
  60,9,164,128,173,168,0,60,60,12,164,96,36,8,0,255,173,136,0,20,173,136,0,24,36,8,0,15,173,136,0,28,
  36,8,0,3,173,136,0,32,141,105,0,0,60,13,164,16,37,140,0,0,49,40,0,255,173,136,0,20,0,9,66,2,
  173,136,0,24,0,9,68,2,173,136,0,28,0,9,69,2,173,136,0,32,141,175,0,12,32,8,15,192,33,107,0,64,
  49,239,0,1,17,224,0,7,37,173,0,12,60,13,164,16,141,175,0,12,37,173,0,12,49,239,0,32,85,224,255,252,
  60,13,164,16,60,13,164,0,37,173,0,0,0,8,48,37,33,173,0,64,141,105,0,0,33,8,255,252,33,107,0,4,
  33,173,0,4,21,0,255,251,173,169,255,252,60,8,108,7,53,8,137,101,1,72,0,25,0,0,32,18,36,132,0,1,
  60,5,164,0,36,165,0,64,4,17,0,19,0,0,0,0,39,189,255,208,20,160,0,2,175,191,0,28,0,192,40,37,
  39,166,0,44,4,17,0,255,39,167,0,40,143,164,0,40,143,174,0,44,1,196,16,35,20,64,0,2,0,64,24,37,
  0,128,24,37,143,191,0,28,39,189,0,48,0,96,16,37,3,224,0,8,0,0,0,0,39,189,255,32,175,191,0,60,
  175,183,0,52,175,182,0,48,175,181,0,44,175,180,0,40,175,179,0,36,175,178,0,32,175,177,0,28,175,176,0,24,
  140,174,0,0,0,0,24,37,39,163,0,180,39,162,0,116,1,196,128,38,36,66,0,16,172,80,255,244,172,80,255,248,
  172,80,255,252,20,67,255,251,172,80,255,240,140,176,0,0,0,0,136,37,0,160,176,37,36,23,0,32,2,0,160,37,
  142,208,0,0,38,49,0,1,36,15,3,239,142,211,0,4,38,214,0,4,1,241,32,35,2,32,48,37,4,17,255,204,
  2,0,40,37,143,163,0,116,143,164,0,120,2,0,40,37,0,67,24,33,175,163,0,116,4,17,255,197,2,32,48,37,
  143,184,0,124,60,5,108,7,175,162,0,120,3,16,200,38,175,185,0,124,52,165,137,101,38,4,0,5,4,17,255,188,
  2,32,48,37,143,168,0,128,2,144,8,43,0,72,72,33,16,32,0,7,175,169,0,128,143,164,0,152,2,0,40,37,
  4,17,255,179,2,32,48,37,16,0,0,4,175,162,0,152,143,170,0,152,1,80,88,33,175,171,0,152,50,130,0,31,
  143,174,0,132,2,226,24,35,0,112,104,4,0,80,96,6,1,141,168,37,0,112,200,6,0,80,192,4,1,213,120,33,
  175,175,0,132,3,25,40,37,143,164,0,144,4,17,255,160,2,32,48,37,143,163,0,140,175,162,0,144,2,3,8,43,
  80,32,0,8,143,171,0,132,143,168,0,128,2,17,80,33,1,3,72,33,1,42,24,38,16,0,0,5,175,163,0,140,
  143,171,0,132,1,112,96,33,1,131,24,38,175,163,0,140,0,20,22,194,143,175,0,136,2,226,24,35,0,112,112,6,
  0,80,104,4,1,174,144,37,0,112,64,4,0,80,200,6,1,242,192,33,175,184,0,136,3,40,40,37,143,164,0,148,
  4,17,255,131,2,32,48,37,36,1,3,240,18,33,0,57,175,162,0,148,143,164,0,176,2,64,40,37,4,17,255,124,
  2,32,48,37,0,16,30,194,2,227,80,35,1,83,88,6,0,115,72,4,1,43,40,37,0,64,32,37,4,17,255,116,
  2,32,48,37,175,162,0,176,143,164,0,172,2,160,40,37,4,17,255,111,2,32,48,37,50,18,0,31,2,242,160,35,
  2,147,104,4,2,83,96,6,1,141,40,37,0,64,32,37,4,17,255,103,2,32,48,37,143,169,0,168,50,99,0,31,
  2,80,112,6,2,144,120,4,2,227,200,35,1,207,56,37,3,51,64,4,0,115,192,6,143,173,0,156,3,8,80,37,
  1,39,88,33,1,106,96,33,175,162,0,172,175,172,0,168,2,96,40,37,2,32,48,37,4,17,255,85,1,176,32,33,
  143,174,0,160,175,162,0,156,2,96,40,37,2,32,48,37,4,17,255,79,1,208,32,38,143,175,0,148,143,184,0,164,
  175,162,0,160,1,240,200,38,3,56,64,33,16,0,255,115,175,168,0,164,143,163,0,116,0,0,136,37,39,179,0,116,
  36,21,0,16,36,20,0,1,175,163,0,100,175,163,0,104,175,163,0,108,175,163,0,112,142,112,0,0,143,173,0,100,
  50,2,0,31,2,226,88,35,1,112,80,4,0,80,72,6,1,42,96,37,1,172,112,33,2,14,8,43,16,32,0,5,
  175,174,0,100,143,175,0,104,1,240,200,33,16,0,0,6,175,185,0,104,143,164,0,104,2,0,40,37,4,17,255,44,
  2,32,48,37,175,162,0,104,50,24,0,2,0,24,64,66,50,18,0,1,85,18,0,6,143,164,0,108,143,171,0,108,
  1,112,72,33,16,0,0,6,175,169,0,108,143,164,0,108,2,0,40,37,4,17,255,30,2,32,48,37,175,162,0,108,
  86,146,0,6,143,164,0,112,143,170,0,112,1,80,104,38,16,0,0,6,175,173,0,112,143,164,0,112,2,0,40,37,
  4,17,255,19,2,32,48,37,175,162,0,112,38,49,0,1,22,53,255,209,38,115,0,4,143,164,0,100,143,165,0,104,
  4,17,255,11,2,32,48,37,143,172,0,112,143,174,0,108,143,176,0,24,143,177,0,28,143,178,0,32,143,179,0,36,
  143,180,0,40,143,181,0,44,143,182,0,48,143,183,0,52,143,191,0,60,0,64,32,37,39,189,0,224,4,17,0,8,
  1,142,40,38,0,133,0,25,0,0,112,16,172,206,0,0,0,0,120,18,172,239,0,0,3,224,0,8,0,0,0,0,
  60,11,191,192,141,104,7,240,60,10,255,255,48,132,255,255,1,10,64,36,0,136,32,37,37,107,7,192,60,9,164,128,
  141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,173,100,0,48,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,141,104,0,60,
  36,9,0,32,173,101,0,52,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,
  173,104,0,60,32,9,0,16,33,41,255,255,85,32,255,255,33,41,255,255,141,104,0,60,49,10,0,128,80,10,255,250,
  32,9,0,16,36,10,0,64,1,10,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,
  173,104,0,60,60,11,164,0,37,107,0,0,33,107,0,64,1,96,0,8,0,0,0,0,0,0,0,0,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char PIFPAL[1984] = {
  60,9,52,0,64,137,96,0,60,9,0,6,53,41,228,99,64,137,128,0,60,8,164,4,141,8,0,16,49,8,0,1,
  81,0,255,253,60,8,164,4,36,8,0,10,60,1,164,4,172,40,0,16,60,8,164,4,141,8,0,24,49,8,0,1,
  85,0,255,253,60,8,164,4,36,8,0,3,60,1,164,96,172,40,0,16,36,8,3,255,60,1,164,64,172,40,0,12,
  60,1,164,64,172,32,0,36,60,1,164,64,172,32,0,16,60,1,164,80,172,32,0,0,60,1,164,80,172,32,0,4,
  60,8,164,4,141,8,0,16,49,8,0,4,85,0,255,253,60,8,164,4,60,11,164,0,60,12,191,192,60,13,191,192,
  37,107,16,0,37,140,0,212,37,173,7,32,141,137,0,0,37,140,0,4,37,107,0,4,21,141,255,252,173,105,255,252,
  60,11,164,0,60,29,164,0,37,107,16,0,1,96,0,8,55,189,31,240,60,13,191,192,141,168,7,252,37,173,7,192,
  49,8,0,128,85,0,255,252,60,13,191,192,141,168,0,36,60,11,176,0,0,8,188,130,0,8,156,194,50,247,0,1,
  50,115,0,1,18,96,0,2,54,247,0,6,60,11,166,0,0,8,178,2,49,10,0,255,0,8,172,66,141,168,0,60,
  36,9,0,16,50,214,0,255,50,181,0,1,36,20,0,0,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,
  85,32,255,253,60,9,164,128,173,168,0,60,60,12,164,96,36,8,0,255,173,136,0,20,173,136,0,24,36,8,0,15,
  173,136,0,28,36,8,0,3,173,136,0,32,141,105,0,0,60,13,164,16,37,140,0,0,49,40,0,255,173,136,0,20,
  0,9,66,2,173,136,0,24,0,9,68,2,173,136,0,28,0,9,69,2,173,136,0,32,141,175,0,12,32,8,15,192,
  33,107,0,64,49,239,0,1,17,224,0,7,37,173,0,12,60,13,164,16,141,175,0,12,37,173,0,12,49,239,0,32,
  85,224,255,252,60,13,164,16,60,13,164,0,37,173,0,0,0,8,48,37,33,173,0,64,141,105,0,0,33,8,255,252,
  33,107,0,4,33,173,0,4,21,0,255,251,173,169,255,252,60,8,108,7,53,8,137,101,1,72,0,25,0,0,32,18,
  36,132,0,1,60,5,164,0,36,165,0,64,4,17,0,19,0,0,0,0,39,189,255,208,20,160,0,2,175,191,0,28,
  0,192,40,37,39,166,0,44,4,17,0,255,39,167,0,40,143,164,0,40,143,174,0,44,1,196,16,35,20,64,0,2,
  0,64,24,37,0,128,24,37,143,191,0,28,39,189,0,48,0,96,16,37,3,224,0,8,0,0,0,0,39,189,255,32,
  175,191,0,60,175,183,0,52,175,182,0,48,175,181,0,44,175,180,0,40,175,179,0,36,175,178,0,32,175,177,0,28,
  175,176,0,24,140,174,0,0,0,0,24,37,39,163,0,180,39,162,0,116,1,196,128,38,36,66,0,16,172,80,255,244,
  172,80,255,248,172,80,255,252,20,67,255,251,172,80,255,240,140,176,0,0,0,0,136,37,0,160,176,37,36,23,0,32,
  2,0,160,37,142,208,0,0,38,49,0,1,36,15,3,239,142,211,0,4,38,214,0,4,1,241,32,35,2,32,48,37,
  4,17,255,204,2,0,40,37,143,163,0,116,143,164,0,120,2,0,40,37,0,67,24,33,175,163,0,116,4,17,255,197,
  2,32,48,37,143,184,0,124,60,5,108,7,175,162,0,120,3,16,200,38,175,185,0,124,52,165,137,101,38,4,0,5,
  4,17,255,188,2,32,48,37,143,168,0,128,2,144,8,43,0,72,72,33,16,32,0,7,175,169,0,128,143,164,0,152,
  2,0,40,37,4,17,255,179,2,32,48,37,16,0,0,4,175,162,0,152,143,170,0,152,1,80,88,33,175,171,0,152,
  50,130,0,31,143,174,0,132,2,226,24,35,0,112,104,4,0,80,96,6,1,141,168,37,0,112,200,6,0,80,192,4,
  1,213,120,33,175,175,0,132,3,25,40,37,143,164,0,144,4,17,255,160,2,32,48,37,143,163,0,140,175,162,0,144,
  2,3,8,43,80,32,0,8,143,171,0,132,143,168,0,128,2,17,80,33,1,3,72,33,1,42,24,38,16,0,0,5,
  175,163,0,140,143,171,0,132,1,112,96,33,1,131,24,38,175,163,0,140,0,20,22,194,143,175,0,136,2,226,24,35,
  0,112,112,6,0,80,104,4,1,174,144,37,0,112,64,4,0,80,200,6,1,242,192,33,175,184,0,136,3,40,40,37,
  143,164,0,148,4,17,255,131,2,32,48,37,36,1,3,240,18,33,0,57,175,162,0,148,143,164,0,176,2,64,40,37,
  4,17,255,124,2,32,48,37,0,16,30,194,2,227,80,35,1,83,88,6,0,115,72,4,1,43,40,37,0,64,32,37,
  4,17,255,116,2,32,48,37,175,162,0,176,143,164,0,172,2,160,40,37,4,17,255,111,2,32,48,37,50,18,0,31,
  2,242,160,35,2,147,104,4,2,83,96,6,1,141,40,37,0,64,32,37,4,17,255,103,2,32,48,37,143,169,0,168,
  50,99,0,31,2,80,112,6,2,144,120,4,2,227,200,35,1,207,56,37,3,51,64,4,0,115,192,6,143,173,0,156,
  3,8,80,37,1,39,88,33,1,106,96,33,175,162,0,172,175,172,0,168,2,96,40,37,2,32,48,37,4,17,255,85,
  1,176,32,33,143,174,0,160,175,162,0,156,2,96,40,37,2,32,48,37,4,17,255,79,1,208,32,38,143,175,0,148,
  143,184,0,164,175,162,0,160,1,240,200,38,3,56,64,33,16,0,255,115,175,168,0,164,143,163,0,116,0,0,136,37,
  39,179,0,116,36,21,0,16,36,20,0,1,175,163,0,100,175,163,0,104,175,163,0,108,175,163,0,112,142,112,0,0,
  143,173,0,100,50,2,0,31,2,226,88,35,1,112,80,4,0,80,72,6,1,42,96,37,1,172,112,33,2,14,8,43,
  16,32,0,5,175,174,0,100,143,175,0,104,1,240,200,33,16,0,0,6,175,185,0,104,143,164,0,104,2,0,40,37,
  4,17,255,44,2,32,48,37,175,162,0,104,50,24,0,2,0,24,64,66,50,18,0,1,85,18,0,6,143,164,0,108,
  143,171,0,108,1,112,72,33,16,0,0,6,175,169,0,108,143,164,0,108,2,0,40,37,4,17,255,30,2,32,48,37,
  175,162,0,108,86,146,0,6,143,164,0,112,143,170,0,112,1,80,104,38,16,0,0,6,175,173,0,112,143,164,0,112,
  2,0,40,37,4,17,255,19,2,32,48,37,175,162,0,112,38,49,0,1,22,53,255,209,38,115,0,4,143,164,0,100,
  143,165,0,104,4,17,255,11,2,32,48,37,143,172,0,112,143,174,0,108,143,176,0,24,143,177,0,28,143,178,0,32,
  143,179,0,36,143,180,0,40,143,181,0,44,143,182,0,48,143,183,0,52,143,191,0,60,0,64,32,37,39,189,0,224,
  4,17,0,8,1,142,40,38,0,133,0,25,0,0,112,16,172,206,0,0,0,0,120,18,172,239,0,0,3,224,0,8,
  0,0,0,0,60,11,191,192,141,104,7,240,60,10,255,255,48,132,255,255,1,10,64,36,0,136,32,37,37,107,7,192,
  60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,173,100,0,48,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,
  141,104,0,60,36,9,0,32,173,101,0,52,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,
  60,9,164,128,173,104,0,60,32,9,0,16,33,41,255,255,85,32,255,255,33,41,255,255,141,104,0,60,49,10,0,128,
  80,10,255,250,32,9,0,16,36,10,0,64,1,10,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,
  60,9,164,128,173,104,0,60,60,11,164,0,37,107,0,0,33,107,0,64,1,96,0,8,0,0,0,0,0,0,0,0,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
}
namespace SuperFamicom {
const unsigned char IPLROM[64] = {
  205,239,189,232,0,198,29,208,252,143,170,244,143,187,245,120,204,244,208,251,47,25,235,244,208,252,126,244,208,11,228,245,
  203,244,215,0,252,208,243,171,1,16,239,126,244,16,235,186,246,218,0,186,244,196,244,221,93,208,219,31,0,0,192,255,
};
const unsigned char Cx4[3072] = {
  255,255,255,0,0,128,0,0,64,170,170,42,0,0,32,153,153,25,85,85,21,36,73,18,0,0,16,227,56,14,204,204,
  12,232,162,11,170,170,10,157,216,9,146,36,9,136,136,8,0,0,8,135,135,7,113,28,7,161,188,6,102,102,6,97,
  24,6,116,209,5,178,144,5,85,85,5,184,30,5,78,236,4,161,189,4,73,146,4,238,105,4,68,68,4,8,33,4,
  0,0,4,248,224,3,195,195,3,58,168,3,56,142,3,159,117,3,80,94,3,52,72,3,51,51,3,56,31,3,48,12,
  3,11,250,2,186,232,2,45,216,2,89,200,2,49,185,2,170,170,2,188,156,2,92,143,2,130,130,2,39,118,2,67,
  106,2,208,94,2,200,83,2,36,73,2,224,62,2,247,52,2,99,43,2,34,34,2,46,25,2,132,16,2,32,8,2,
  0,0,2,31,248,1,124,240,1,19,233,1,225,225,1,230,218,1,29,212,1,133,205,1,28,199,1,224,192,1,207,186,
  1,232,180,1,40,175,1,142,169,1,26,164,1,200,158,1,153,153,1,139,148,1,156,143,1,203,138,1,24,134,1,129,
  129,1,5,125,1,164,120,1,93,116,1,46,112,1,22,108,1,22,104,1,44,100,1,88,96,1,152,92,1,237,88,1,
  85,85,1,208,81,1,94,78,1,253,74,1,174,71,1,111,68,1,65,65,1,34,62,1,19,59,1,19,56,1,33,53,
  1,62,50,1,104,47,1,159,44,1,228,41,1,53,39,1,146,36,1,251,33,1,112,31,1,240,28,1,123,26,1,17,
  24,1,177,21,1,92,19,1,17,17,1,207,14,1,151,12,1,104,10,1,66,8,1,36,6,1,16,4,1,4,2,1,
  0,0,1,3,254,0,15,252,0,35,250,0,62,248,0,96,246,0,137,244,0,185,242,0,240,240,0,46,239,0,115,237,
  0,189,235,0,14,234,0,101,232,0,194,230,0,37,229,0,142,227,0,252,225,0,112,224,0,233,222,0,103,221,0,235,
  219,0,116,218,0,1,217,0,148,215,0,43,214,0,199,212,0,104,211,0,13,210,0,182,208,0,100,207,0,22,206,0,
  204,204,0,135,203,0,69,202,0,7,201,0,206,199,0,152,198,0,101,197,0,55,196,0,12,195,0,228,193,0,192,192,
  0,160,191,0,130,190,0,105,189,0,82,188,0,62,187,0,46,186,0,33,185,0,23,184,0,15,183,0,11,182,0,9,
  181,0,11,180,0,15,179,0,22,178,0,31,177,0,44,176,0,58,175,0,76,174,0,96,173,0,118,172,0,143,171,0,
  170,170,0,200,169,0,232,168,0,10,168,0,47,167,0,85,166,0,126,165,0,169,164,0,215,163,0,6,163,0,55,162,
  0,107,161,0,160,160,0,216,159,0,17,159,0,76,158,0,137,157,0,200,156,0,9,156,0,76,155,0,144,154,0,215,
  153,0,31,153,0,104,152,0,180,151,0,1,151,0,79,150,0,160,149,0,242,148,0,69,148,0,154,147,0,241,146,0,
  73,146,0,162,145,0,253,144,0,90,144,0,184,143,0,23,143,0,120,142,0,218,141,0,61,141,0,162,140,0,8,140,
  0,112,139,0,216,138,0,66,138,0,174,137,0,26,137,0,136,136,0,247,135,0,103,135,0,217,134,0,75,134,0,191,
  133,0,52,133,0,169,132,0,33,132,0,153,131,0,18,131,0,140,130,0,8,130,0,132,129,0,2,129,0,128,128,0,
  0,0,0,0,0,16,158,160,22,122,182,27,0,0,32,239,198,35,28,49,39,255,84,42,60,65,45,0,0,48,176,152,
  50,229,16,53,245,108,55,86,176,57,212,221,59,189,247,61,0,0,64,61,248,65,219,225,67,12,190,69,222,141,71,58,
  82,73,241,11,75,185,187,76,56,98,78,0,0,80,149,149,81,112,35,83,254,169,84,162,41,86,183,162,87,144,21,89,
  121,130,90,186,233,91,148,75,93,67,168,94,0,0,96,254,82,97,112,161,98,131,235,99,96,49,101,50,115,102,29,177,
  103,68,235,104,202,33,106,205,84,107,108,132,108,194,176,109,235,217,110,0,0,112,24,35,113,74,67,114,173,96,115,84,
  123,116,84,147,117,191,168,118,168,187,119,31,204,120,52,218,121,249,229,122,122,239,123,200,246,124,239,251,125,253,254,126,
  0,0,128,1,255,128,15,252,129,52,247,130,123,240,131,238,231,132,152,221,133,130,209,134,182,195,135,61,180,136,31,163,
  137,102,144,138,25,124,139,65,102,140,228,78,141,11,54,142,188,27,143,0,0,144,219,226,144,86,196,145,117,164,146,65,
  131,147,189,96,148,241,60,149,226,23,150,150,241,150,17,202,151,89,161,152,115,119,153,100,76,154,49,32,155,222,242,155,
  112,196,156,235,148,157,84,100,158,175,50,159,0,0,160,74,204,160,146,151,161,220,97,162,42,43,163,130,243,163,230,186,
  164,90,129,165,225,70,166,126,11,167,53,207,167,9,146,168,253,83,169,19,21,170,80,213,170,180,148,171,69,83,172,3,
  17,173,242,205,173,21,138,174,110,69,175,0,0,176,204,185,176,214,114,177,32,43,178,172,226,178,124,153,179,147,79,180,
  243,4,181,157,185,181,149,109,182,220,32,183,117,211,183,96,133,184,160,54,185,56,231,185,40,151,186,115,70,187,26,245,
  187,32,163,188,134,80,189,78,253,189,121,169,190,9,85,191,0,0,192,95,170,192,40,84,193,92,253,193,253,165,194,13,
  78,195,140,245,195,125,156,196,225,66,197,184,232,197,5,142,198,201,50,199,6,215,199,187,122,200,235,29,201,152,192,201,
  193,98,202,105,4,203,145,165,203,58,70,204,100,230,204,18,134,205,68,37,206,252,195,206,58,98,207,0,0,208,78,157,
  208,38,58,209,137,214,209,119,114,210,243,13,211,252,168,211,148,67,212,188,221,212,116,119,213,190,16,214,155,169,214,11,
  66,215,15,218,215,169,113,216,216,8,217,159,159,217,254,53,218,245,203,218,133,97,219,176,246,219,118,139,220,216,31,221,
  215,179,221,115,71,222,173,218,222,134,109,223,0,0,224,25,146,224,212,35,225,48,181,225,48,70,226,210,214,226,25,103,
  227,4,247,227,148,134,228,203,21,229,168,164,229,45,51,230,90,193,230,47,79,231,173,220,231,214,105,232,169,246,232,38,
  131,233,80,15,234,38,155,234,168,38,235,217,177,235,183,60,236,67,199,236,127,81,237,106,219,237,6,101,238,82,238,238,
  80,119,239,0,0,240,97,136,240,118,16,241,62,152,241,186,31,242,234,166,242,207,45,243,105,180,243,185,58,244,192,192,
  244,125,70,245,242,203,245,30,81,246,2,214,246,159,90,247,245,222,247,5,99,248,206,230,248,82,106,249,144,237,249,138,
  112,250,63,243,250,177,117,251,223,247,251,202,121,252,114,251,252,216,124,253,251,253,253,222,126,254,127,255,254,223,127,255,
  0,0,0,58,36,3,85,72,6,50,108,9,178,143,12,183,178,15,32,213,18,208,246,21,166,23,25,133,55,28,78,86,
  31,225,115,34,32,144,37,237,170,40,40,196,43,179,219,46,112,241,49,64,5,53,4,23,56,159,38,59,242,51,62,224,
  62,65,73,71,68,16,77,71,24,80,74,67,80,77,114,77,80,137,71,83,105,62,86,247,49,89,20,34,92,164,14,95,
  138,247,97,169,220,100,229,189,103,32,155,106,64,116,109,39,73,112,186,25,115,221,229,117,116,173,120,101,112,123,147,46,
  126,228,231,128,60,156,131,130,75,134,154,245,136,107,154,139,217,57,142,204,211,144,42,104,147,217,246,149,191,127,152,197,
  2,155,209,127,157,202,246,159,153,103,162,36,210,164,85,54,167,20,148,169,73,235,171,221,59,174,186,133,176,201,200,178,
  243,4,181,34,58,183,65,104,185,58,143,187,249,174,189,103,199,191,112,216,193,0,226,195,3,228,197,101,222,199,18,209,
  201,247,187,203,2,159,205,31,122,207,61,77,209,72,24,211,49,219,212,228,149,214,82,72,216,105,242,217,26,148,219,83,
  45,221,5,190,222,33,70,224,151,197,225,89,60,227,89,170,228,135,15,230,215,107,231,59,191,232,166,9,234,11,75,235,
  94,131,236,147,178,237,157,216,238,115,245,239,8,9,241,82,19,242,71,20,243,221,11,244,10,250,244,198,222,245,7,186,
  246,197,139,247,247,83,248,151,18,249,157,199,249,1,115,250,190,20,251,205,172,251,39,59,252,201,191,252,171,58,253,203,
  171,253,35,19,254,175,112,254,109,196,254,87,14,255,109,78,255,171,132,255,15,177,255,151,211,255,67,236,255,16,251,255,
  0,0,0,249,162,0,246,69,1,248,232,1,1,140,2,20,47,3,52,210,3,100,117,4,165,24,5,251,187,5,104,95,
  6,239,2,7,146,166,7,84,74,8,56,238,8,64,146,9,110,54,10,199,218,10,76,127,11,1,36,12,231,200,12,2,
  110,13,85,19,14,227,184,14,174,94,15,185,4,16,8,171,16,158,81,17,125,248,17,169,159,18,37,71,19,244,238,19,
  25,151,20,153,63,21,117,232,21,178,145,22,83,59,23,92,229,23,209,143,24,180,58,25,10,230,25,216,145,26,32,62,
  27,231,234,27,49,152,28,2,70,29,95,244,29,76,163,30,206,82,31,234,2,32,163,179,32,0,101,33,5,23,34,184,
  201,34,30,125,35,60,49,36,24,230,36,185,155,37,36,82,38,95,9,39,113,193,39,97,122,40,54,52,41,246,238,41,
  170,170,42,89,103,43,10,37,44,199,227,44,152,163,45,133,100,46,153,38,47,220,233,47,89,174,48,27,116,49,44,59,
  50,152,3,51,107,205,51,177,152,52,120,101,53,206,51,54,193,3,55,96,213,55,187,168,56,228,125,57,236,84,58,230,
  45,59,230,8,60,1,230,60,77,197,61,227,166,62,220,138,63,82,113,64,98,90,65,44,70,66,208,52,67,113,38,68,
  55,27,69,74,19,70,214,14,71,12,14,72,32,17,73,76,24,74,205,35,75,234,51,76,236,72,77,39,99,78,249,130,
  79,201,168,80,10,213,81,63,8,83,252,66,84,234,133,85,204,209,86,130,39,88,21,136,89,188,244,90,237,110,92,108,
  248,93,105,147,95,163,66,97,165,9,99,30,237,100,129,243,102,23,38,105,34,147,107,165,82,110,124,147,113,180,206,117,
  0,0,0,36,3,0,72,6,0,109,9,0,147,12,0,186,15,0,226,18,0,11,22,0,54,25,0,99,28,0,147,31,
  0,196,34,0,249,37,0,48,41,0,107,44,0,169,47,0,235,50,0,50,54,0,124,57,0,203,60,0,31,64,0,121,
  67,0,216,70,0,61,74,0,168,77,0,25,81,0,146,84,0,17,88,0,153,91,0,40,95,0,192,98,0,96,102,0,
  9,106,0,188,109,0,122,113,0,65,117,0,20,121,0,242,124,0,220,128,0,210,132,0,213,136,0,230,140,0,5,145,
  0,51,149,0,112,153,0,190,157,0,28,162,0,139,166,0,13,171,0,162,175,0,75,180,0,9,185,0,220,189,0,198,
  194,0,200,199,0,227,204,0,24,210,0,103,215,0,211,220,0,93,226,0,6,232,0,207,237,0,187,243,0,202,249,0,
  0,0,1,92,6,1,226,12,1,148,19,1,115,26,1,131,33,1,198,40,1,62,48,1,239,55,1,220,63,1,8,72,
  1,119,80,1,45,89,1,45,98,1,125,107,1,34,117,1,33,127,1,128,137,1,68,148,1,118,159,1,28,171,1,62,
  183,1,231,195,1,31,209,1,241,222,1,105,237,1,149,252,1,131,12,2,68,29,2,233,46,2,134,65,2,51,85,2,
  9,106,2,37,128,2,167,151,2,181,176,2,120,203,2,35,232,2,236,6,3,21,40,3,235,75,3,198,114,3,16,157,
  3,71,203,3,2,254,3,247,53,4,5,116,4,63,185,4,255,6,5,249,94,5,93,195,5,9,55,6,207,189,6,230,
  92,7,151,27,8,109,4,9,54,39,10,198,156,11,129,142,13,233,70,16,255,90,20,113,38,27,72,188,40,181,123,81,
  255,255,255,16,251,255,67,236,255,151,211,255,15,177,255,171,132,255,109,78,255,87,14,255,109,196,254,175,112,254,35,19,
  254,203,171,253,171,58,253,201,191,252,39,59,252,205,172,251,190,20,251,1,115,250,157,199,249,151,18,249,247,83,248,197,
  139,247,7,186,246,198,222,245,10,250,244,221,11,244,71,20,243,82,19,242,8,9,241,115,245,239,157,216,238,147,178,237,
  94,131,236,11,75,235,166,9,234,59,191,232,215,107,231,135,15,230,89,170,228,89,60,227,151,197,225,33,70,224,5,190,
  222,83,45,221,26,148,219,105,242,217,82,72,216,228,149,214,49,219,212,72,24,211,61,77,209,31,122,207,2,159,205,247,
  187,203,18,209,201,101,222,199,3,228,197,0,226,195,112,216,193,103,199,191,249,174,189,58,143,187,65,104,185,34,58,183,
  243,4,181,201,200,178,186,133,176,221,59,174,73,235,171,20,148,169,85,54,167,36,210,164,153,103,162,202,246,159,209,127,
  157,197,2,155,191,127,152,217,246,149,42,104,147,204,211,144,217,57,142,107,154,139,154,245,136,130,75,134,60,156,131,228,
  231,128,147,46,126,101,112,123,116,173,120,221,229,117,186,25,115,39,73,112,64,116,109,32,155,106,229,189,103,169,220,100,
  138,247,97,164,14,95,20,34,92,247,49,89,105,62,86,137,71,83,114,77,80,67,80,77,24,80,74,16,77,71,73,71,
  68,224,62,65,242,51,62,159,38,59,4,23,56,64,5,53,112,241,49,179,219,46,40,196,43,237,170,40,32,144,37,225,
  115,34,78,86,31,133,55,28,166,23,25,208,246,21,32,213,18,183,178,15,178,143,12,50,108,9,85,72,6,58,36,3,
};
const unsigned char DSP1[8192] = {
  0,192,151,7,0,193,6,32,192,2,48,192,16,192,151,129,128,18,12,128,145,7,0,192,0,0,11,160,64,144,0,0,
  11,128,64,144,0,0,11,96,64,144,0,0,11,76,64,144,0,0,11,172,6,144,200,70,144,0,0,11,128,71,144,0,
  0,11,60,7,144,240,70,144,0,0,11,116,64,144,0,0,11,204,7,144,252,71,144,0,0,11,248,8,144,60,73,144,
  0,0,11,148,64,144,0,0,11,232,9,144,124,77,144,0,0,11,136,14,144,100,80,144,0,0,11,184,64,144,0,0,
  11,0,0,11,28,17,144,32,82,144,0,0,11,204,64,144,0,0,11,136,18,144,240,82,144,0,0,11,0,0,11,164,
  83,144,0,0,11,56,19,144,188,83,144,194,3,192,4,0,192,29,0,18,4,65,145,29,32,21,244,0,146,225,64,0,
  64,224,84,32,224,83,0,0,10,92,65,145,0,0,10,68,65,145,0,128,11,202,255,223,208,128,18,42,0,0,2,16,
  192,232,0,168,37,0,0,109,0,0,0,0,37,69,8,192,80,128,84,33,128,18,100,129,148,0,0,11,10,0,224,2,
  4,192,208,0,83,33,128,18,76,129,148,194,3,192,232,0,160,26,0,19,48,0,20,124,65,148,209,0,64,69,16,192,
  80,0,21,21,0,19,109,0,0,0,0,33,168,65,148,160,1,145,0,0,49,192,1,148,194,255,223,33,128,77,0,0,
  10,184,1,145,0,0,49,192,65,148,65,0,224,32,128,83,42,128,18,208,129,148,96,0,21,96,0,21,42,128,19,0,
  0,37,0,128,113,232,0,168,197,3,192,80,128,20,0,130,148,69,12,192,80,128,21,37,128,19,27,0,19,0,0,101,
  24,194,145,16,0,18,20,66,148,193,255,223,32,128,83,65,0,224,32,128,83,232,0,168,202,3,192,208,128,20,104,194,
  145,80,130,148,69,12,192,80,128,21,37,128,19,27,0,19,0,128,37,76,130,148,0,0,72,0,0,64,35,128,19,16,
  128,21,18,0,19,100,130,148,0,0,8,108,1,160,18,0,18,116,66,148,16,0,83,16,0,19,0,0,72,16,0,19,
  250,64,17,242,64,20,160,2,148,254,160,20,172,194,148,66,12,192,254,160,21,192,2,160,210,0,0,254,160,20,184,130,
  148,66,12,192,0,160,21,192,2,160,66,12,192,222,160,21,33,0,0,0,16,4,21,0,19,251,16,0,15,16,37,31,
  80,19,33,0,0,0,16,4,21,0,19,251,16,0,15,16,37,31,80,19,33,0,0,0,16,4,21,0,19,251,16,0,
  15,16,37,31,16,83,10,1,192,29,0,19,0,0,37,52,67,145,0,0,10,64,67,145,44,67,148,65,0,224,0,0,
  64,193,255,223,0,0,64,0,0,53,44,67,148,0,0,64,0,0,53,36,3,148,0,0,64,16,96,18,200,67,145,104,
  3,148,0,32,10,0,0,9,104,3,146,0,0,8,5,25,192,27,129,10,97,129,9,99,0,37,21,0,19,109,128,9,
  222,0,36,48,0,20,26,0,19,10,0,33,16,0,21,156,3,146,193,255,223,29,0,19,0,0,36,48,0,20,26,0,
  19,0,0,33,16,0,21,188,3,146,193,255,223,208,3,150,0,0,10,0,96,73,193,255,223,194,11,192,0,96,64,16,
  0,18,228,67,148,8,4,168,0,0,64,42,128,19,29,0,19,208,128,20,224,0,22,8,4,168,42,128,19,29,0,19,
  208,128,20,224,0,86,32,128,18,44,196,148,44,128,19,29,128,37,1,0,192,36,132,148,193,255,255,0,128,53,0,0,
  103,202,255,223,208,128,18,44,128,19,29,128,37,1,0,192,72,132,148,193,255,255,0,128,5,0,128,53,0,0,103,92,
  4,168,92,4,168,100,1,0,242,64,0,243,64,0,254,0,0,116,4,168,116,4,168,100,1,0,44,2,0,60,6,37,
  12,0,37,100,1,37,31,0,83,197,69,192,0,128,11,160,132,144,0,0,11,0,128,9,46,0,0,27,1,19,130,53,
  192,109,128,37,37,0,53,26,0,0,98,1,0,97,128,20,45,0,0,2,0,101,16,96,18,220,4,148,0,32,10,0,
  0,9,60,69,146,69,135,192,27,1,19,109,1,37,96,1,21,98,1,0,110,129,50,43,128,19,21,128,37,43,128,19,
  99,128,37,0,0,21,21,0,19,109,0,21,32,0,20,28,5,146,65,0,224,50,0,0,0,128,37,44,133,146,194,255,
  223,56,5,150,0,128,10,0,224,73,0,96,64,32,224,83,16,96,18,84,5,148,0,32,10,0,0,9,144,69,146,133,
  200,192,98,1,0,27,1,19,109,1,53,96,0,18,26,128,37,37,128,19,96,129,21,97,128,20,45,128,19,0,0,37,
  144,5,150,26,0,0,65,0,224,208,96,84,32,224,83,36,128,19,207,255,223,0,2,0,47,6,0,47,68,0,47,64,
  0,47,34,0,66,0,0,4,0,192,47,0,0,200,4,168,35,96,0,244,128,10,31,134,9,212,133,146,194,255,223,47,
  198,19,63,134,21,31,4,64,4,0,192,47,0,0,200,4,168,35,96,0,244,128,10,31,192,9,0,134,146,194,255,223,
  47,192,19,47,2,0,47,32,0,31,32,0,63,6,0,47,64,0,47,64,0,207,255,223,50,4,64,36,128,19,15,0,
  208,0,2,0,47,6,0,47,68,0,47,64,0,47,34,0,66,0,0,4,0,192,47,0,0,200,4,168,0,128,11,35,
  96,11,244,128,10,31,134,9,47,198,19,63,134,21,31,4,64,4,0,192,47,0,0,200,4,168,0,128,11,35,96,11,
  244,128,10,31,192,9,47,192,19,47,2,0,47,32,0,31,32,0,63,6,0,47,64,0,47,64,0,15,0,208,50,4,
  64,172,198,151,138,0,0,180,198,151,157,0,0,0,0,33,22,0,19,0,0,160,200,198,151,129,0,0,208,198,151,146,
  0,0,232,0,168,76,3,168,22,0,19,228,198,151,38,128,19,0,0,160,240,198,151,138,0,0,221,0,0,18,0,37,
  0,199,151,138,128,53,221,0,0,0,128,53,16,199,151,154,0,39,221,0,0,0,128,53,0,0,39,8,1,168,0,128,
  8,140,4,168,220,1,168,22,0,0,0,0,160,60,199,151,138,0,0,221,0,0,18,0,53,76,199,151,138,128,39,221,
  0,0,0,0,53,92,199,151,154,128,39,221,0,0,0,0,53,0,128,39,22,0,0,116,199,151,38,0,0,0,0,160,
  128,199,151,138,0,0,221,0,0,18,0,53,144,199,151,138,128,39,221,0,0,0,0,53,160,199,151,138,128,39,221,0,
  0,0,0,53,176,199,151,154,128,39,221,0,0,0,0,52,0,128,38,38,0,0,0,0,160,204,199,151,129,0,0,200,
  4,168,42,128,19,220,199,151,157,0,0,26,128,33,38,128,19,33,128,33,240,199,151,38,128,19,0,0,160,4,60,192,
  0,200,151,143,2,0,8,200,151,143,6,17,16,200,151,143,50,0,24,200,151,143,32,0,32,200,151,143,8,0,200,4,
  168,47,128,19,2,4,192,232,0,168,76,3,168,0,8,0,31,8,19,47,0,1,232,0,168,28,2,19,47,8,33,31,
  16,0,241,18,0,200,4,168,46,32,0,44,160,19,28,192,33,250,212,37,0,128,5,47,180,19,33,160,49,12,8,33,
  47,192,53,19,0,39,47,160,19,30,128,1,49,128,52,0,0,38,8,1,168,29,96,19,236,128,5,0,0,33,220,1,
  168,4,60,192,0,0,5,31,62,0,1,128,1,8,1,168,29,98,19,236,128,5,0,0,36,220,1,168,208,200,151,144,
  126,21,246,2,0,220,200,151,246,6,0,0,0,5,31,0,0,236,200,151,22,0,0,0,0,160,248,200,151,129,0,0,
  4,16,192,4,201,151,143,0,0,200,4,168,19,96,19,60,0,0,0,0,37,45,128,19,32,201,151,154,128,36,61,0,
  37,22,128,37,48,201,151,38,0,0,0,0,160,60,201,151,129,0,0,132,16,192,72,201,151,143,32,0,80,201,151,143,
  96,0,88,201,151,143,32,0,96,201,151,143,0,0,200,4,168,46,224,19,28,32,19,250,96,37,13,128,37,250,0,37,
  31,160,36,47,32,0,241,0,0,200,4,168,46,224,19,28,0,19,152,201,151,154,0,37,13,128,37,250,0,36,31,160,
  37,0,32,0,47,32,0,241,0,0,200,4,168,46,224,19,246,32,0,28,32,19,250,64,37,13,128,37,250,0,37,212,
  201,151,22,128,36,220,201,151,38,0,0,0,0,160,132,14,192,236,201,151,143,2,0,244,201,151,143,6,0,252,201,151,
  143,0,0,196,51,192,8,202,151,143,16,0,31,80,0,20,202,151,143,16,0,31,38,0,194,31,192,36,202,151,129,0,
  0,224,5,168,130,29,192,52,202,151,145,0,0,148,5,168,68,18,192,47,192,19,1,0,192,5,31,192,196,31,192,242,
  64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,68,29,192,44,2,0,
  60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,5,27,
  192,196,27,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,68,
  29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,0,37,84,1,37,
  31,0,19,5,23,192,196,23,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,
  37,31,0,19,68,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,
  0,37,84,1,37,31,0,19,2,0,192,197,202,192,196,51,192,243,64,0,254,0,0,132,14,192,60,16,1,13,0,37,
  27,0,36,223,144,33,47,176,19,27,0,19,223,144,33,47,194,19,60,16,1,13,0,37,27,0,36,223,144,33,47,176,
  19,27,0,19,223,144,33,47,198,19,60,16,1,13,0,37,27,0,36,223,144,33,47,176,19,27,0,19,223,144,33,47,
  208,19,241,0,0,228,0,168,4,19,192,31,16,19,47,128,19,66,253,255,1,128,196,0,0,5,232,0,168,76,3,168,
  220,1,168,19,0,19,154,0,17,125,0,0,33,128,36,58,128,20,0,0,36,44,140,148,145,0,0,2,0,192,56,12,
  160,42,128,19,0,128,33,0,128,13,4,16,192,47,0,0,200,4,168,4,18,192,31,48,0,47,128,19,232,0,168,76,
  3,168,132,18,192,31,16,19,47,240,19,133,202,192,251,1,0,97,129,33,45,128,19,100,1,37,29,0,19,250,216,33,
  45,192,19,0,128,36,47,0,0,4,16,192,252,0,0,98,1,33,27,1,19,0,128,37,45,128,19,100,129,33,44,128,
  19,100,1,1,250,0,37,29,0,0,100,128,33,47,128,19,232,0,168,76,3,168,196,18,192,31,16,19,47,128,19,68,
  50,192,241,0,0,66,252,255,232,0,168,76,3,168,4,50,192,26,0,0,241,0,0,232,0,168,29,0,19,0,0,36,
  220,1,168,19,0,0,132,38,192,241,26,0,228,0,168,132,18,192,28,16,19,0,0,33,0,128,5,220,1,168,4,3,
  192,246,72,0,48,205,151,54,64,0,68,50,192,28,0,19,0,0,33,196,27,192,28,2,19,250,0,33,132,46,192,0,
  64,5,88,205,151,22,0,0,31,34,19,0,0,36,0,64,5,108,205,151,22,0,0,31,0,0,0,0,160,68,2,192,
  128,205,151,159,0,0,132,17,192,31,0,19,68,2,192,66,0,192,252,128,21,47,88,33,0,0,5,194,1,192,232,0,
  168,76,3,168,4,19,192,28,16,19,0,128,5,46,0,33,19,0,0,220,1,168,196,15,192,31,2,0,31,0,0,196,
  18,192,49,0,0,28,16,19,2,0,33,0,128,5,220,1,168,132,15,192,31,2,0,31,0,19,132,17,192,244,0,0,
  72,46,150,196,15,192,252,64,0,252,34,33,22,0,19,252,192,33,24,206,151,38,128,19,252,0,33,36,206,151,22,0,
  19,0,128,33,48,206,151,38,0,0,56,206,151,144,128,19,144,205,145,4,0,160,196,15,192,252,64,0,252,34,37,22,
  0,19,252,192,37,71,0,192,96,206,151,38,128,19,252,0,37,22,0,19,0,128,37,38,0,0,7,0,192,144,128,19,
  144,205,145,4,0,160,4,47,192,77,0,192,144,206,151,138,0,0,223,16,33,31,18,19,160,206,151,138,0,0,223,16,
  33,31,22,19,176,206,151,154,0,0,223,16,33,31,20,0,242,16,0,241,80,0,0,144,4,0,0,6,8,1,168,132,
  29,192,0,0,11,31,144,9,47,0,0,4,11,192,241,16,0,242,64,0,0,144,4,0,0,6,8,1,168,68,29,192,
  0,0,11,31,144,9,47,0,0,4,7,192,241,16,0,242,64,0,0,144,4,0,0,6,8,1,168,4,29,192,0,0,
  11,31,144,9,47,0,0,1,0,192,132,61,192,124,2,168,132,61,192,241,0,0,196,60,192,31,64,0,31,64,0,31,
  0,19,132,29,192,197,28,192,242,64,0,243,64,0,254,0,0,4,31,192,44,2,0,60,6,37,12,0,37,84,1,37,
  31,0,19,196,30,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,132,30,192,44,2,0,60,6,37,12,0,
  37,84,1,37,31,0,19,68,28,192,0,16,4,242,0,0,28,2,168,132,51,192,0,144,5,0,0,7,216,15,146,113,
  0,0,8,1,168,76,3,168,68,28,192,31,16,0,47,0,0,132,51,192,241,0,0,228,0,168,68,28,192,28,16,19,
  0,0,33,19,128,5,46,0,0,2,2,192,0,128,21,220,1,168,68,28,192,31,32,19,60,16,0,2,0,33,0,128,
  5,220,1,168,132,28,192,31,32,19,60,16,0,2,0,33,0,128,5,220,1,168,22,0,0,132,28,192,80,208,151,246,
  64,0,88,208,151,246,0,0,0,0,160,100,208,151,141,0,0,10,32,192,4,2,192,116,208,151,157,0,53,31,40,19,
  250,8,53,31,88,19,0,0,37,0,0,5,2,2,192,232,0,168,76,3,168,4,19,192,28,16,19,0,0,37,19,128,
  5,46,0,0,220,1,168,132,18,192,60,16,0,19,0,19,2,0,37,0,128,5,220,1,168,68,2,192,29,0,19,250,
  64,0,61,0,37,250,0,0,30,0,0,68,46,192,241,130,37,35,0,0,242,0,0,196,31,192,60,64,0,12,34,37,
  60,64,37,22,0,19,12,128,36,0,128,37,16,209,151,38,128,19,0,0,160,130,203,192,16,128,20,37,128,19,100,0,
  0,44,209,151,130,0,0,67,128,11,47,64,0,60,209,151,129,64,0,47,34,0,47,38,0,76,209,151,143,122,0,63,
  0,0,200,4,168,244,0,0,44,192,19,29,128,37,47,160,19,108,209,151,145,128,37,47,126,0,200,4,168,244,0,0,
  44,192,19,250,162,37,47,192,19,250,128,37,47,192,19,29,128,37,47,162,19,250,196,37,47,164,19,0,32,0,250,196,
  37,47,160,19,241,128,37,47,122,0,200,4,168,244,0,0,28,64,19,250,32,37,31,64,19,0,0,36,31,66,19,250,
  6,0,250,6,36,31,2,19,44,4,37,31,4,19,18,0,37,31,36,19,250,166,21,0,0,37,250,70,21,31,166,37,
  47,192,19,1,0,192,250,166,21,0,0,36,250,70,21,31,166,36,47,0,0,4,0,160,130,203,192,16,128,20,37,128,
  19,44,210,151,129,0,0,100,0,0,28,64,0,60,210,151,131,0,0,60,192,37,72,210,151,158,0,0,12,130,37,250,
  160,37,38,128,19,60,160,37,28,134,37,250,192,37,104,210,151,38,128,19,60,192,37,12,128,37,0,128,37,124,210,151,
  38,0,0,0,0,160,130,203,192,16,128,20,37,128,19,148,210,151,129,0,0,100,0,0,28,2,0,164,210,151,131,0,
  0,60,134,37,176,210,151,158,0,0,12,192,37,250,134,37,38,128,19,60,130,37,28,192,37,250,130,37,208,210,151,38,
  128,19,60,134,37,12,128,37,0,128,37,228,210,151,38,0,0,0,0,160,130,203,192,32,0,21,21,0,19,100,0,0,
  0,211,151,140,64,0,18,0,53,0,128,39,16,211,151,140,64,0,0,0,53,0,128,39,32,211,151,156,0,0,0,0,
  53,0,128,39,38,0,0,0,0,160,66,85,213,193,63,192,20,128,10,47,0,8,64,19,148,193,63,192,80,211,151,20,
  128,10,46,128,3,120,147,145,2,0,8,84,19,148,0,128,10,60,211,148,6,0,192,0,0,160,1,0,196,0,0,18,
  64,0,17,14,64,196,19,128,11,0,0,21,136,147,144,1,0,248,48,0,17,22,0,0,0,0,160,2,0,193,21,0,
  9,172,211,151,102,128,8,168,147,145,0,0,160,188,211,151,6,64,192,0,0,160,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,0,2,0,4,0,8,0,16,0,32,0,64,0,128,0,0,1,0,2,0,4,0,8,0,16,0,32,
  0,64,255,127,0,64,0,32,0,16,0,8,0,4,0,2,0,1,128,0,64,0,32,0,1,0,8,0,4,0,2,0,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,128,229,255,0,1,255,127,2,127,8,126,18,125,31,124,48,123,69,122,93,121,120,120,151,119,186,118,
  223,117,7,117,51,116,97,115,147,114,199,113,254,112,56,112,117,111,180,110,246,109,58,109,129,108,202,107,22,107,100,106,
  180,105,7,105,91,104,178,103,11,103,102,102,196,101,35,101,132,100,231,99,76,99,179,98,28,98,134,97,242,96,96,96,
  208,95,65,95,181,94,41,94,159,93,23,93,145,92,12,92,136,91,6,91,133,90,6,90,136,89,11,89,144,88,22,88,
  157,87,38,87,176,86,59,86,200,85,85,85,228,84,116,84,5,84,152,83,43,83,191,82,85,82,236,81,131,81,28,81,
  182,80,80,80,236,79,137,79,38,79,197,78,100,78,5,78,166,77,72,77,236,76,144,76,52,76,218,75,129,75,40,75,
  208,74,121,74,35,74,205,73,121,73,37,73,209,72,127,72,45,72,220,71,140,71,60,71,237,70,159,70,81,70,4,70,
  184,69,108,69,33,69,215,68,141,68,68,68,252,67,180,67,109,67,38,67,224,66,154,66,85,66,17,66,205,65,137,65,
  70,65,4,65,194,64,129,64,64,64,255,63,247,65,225,67,189,69,141,71,81,73,11,75,187,76,97,78,255,79,148,81,
  34,83,169,84,40,86,162,87,20,89,129,90,233,91,74,93,167,94,255,95,82,97,160,98,234,99,48,101,114,102,176,103,
  234,104,32,106,83,107,131,108,175,109,217,110,255,111,34,113,66,114,95,115,122,116,146,117,167,118,186,119,203,120,217,121,
  229,122,238,123,245,124,250,125,254,126,255,127,32,0,64,0,0,0,36,3,71,6,106,9,139,12,171,15,200,18,226,21,
  248,24,11,28,25,31,35,34,40,37,38,40,31,43,17,46,251,48,222,51,186,54,140,57,86,60,23,63,206,65,122,68,
  28,71,180,73,63,76,191,78,51,81,155,83,245,85,66,88,130,90,180,92,215,94,236,96,242,98,232,100,207,102,166,104,
  109,106,36,108,202,109,95,111,226,112,85,114,181,115,4,117,65,118,108,119,132,120,138,121,125,122,93,123,41,124,227,124,
  138,125,29,126,157,126,9,127,98,127,167,127,216,127,246,127,255,127,246,127,216,127,167,127,98,127,9,127,157,126,29,126,
  138,125,227,124,41,124,93,123,125,122,138,121,132,120,108,119,65,118,4,117,181,115,85,114,226,112,95,111,202,109,36,108,
  109,106,166,104,207,102,232,100,242,98,236,96,215,94,180,92,130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,
  28,71,122,68,206,65,23,63,86,60,140,57,186,54,222,51,251,48,17,46,31,43,38,40,40,37,35,34,25,31,11,28,
  248,24,226,21,200,18,171,15,139,12,106,9,71,6,36,3,255,127,246,127,216,127,167,127,98,127,9,127,157,126,29,126,
  138,125,227,124,41,124,93,123,125,122,138,121,132,120,108,119,65,118,4,117,181,115,85,114,226,112,95,111,202,109,36,108,
  109,106,166,104,207,102,232,100,242,98,236,96,215,94,180,92,130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,
  28,71,122,68,206,65,23,63,86,60,140,57,186,54,222,51,251,48,17,46,31,43,38,40,40,37,35,34,25,31,11,28,
  248,24,226,21,200,18,171,15,139,12,106,9,71,6,36,3,0,0,220,252,185,249,150,246,117,243,85,240,56,237,30,234,
  8,231,245,227,231,224,221,221,216,218,218,215,225,212,239,209,5,207,34,204,70,201,116,198,170,195,233,192,50,190,134,187,
  228,184,76,182,193,179,65,177,205,174,101,172,11,170,190,167,126,165,76,163,41,161,20,159,14,157,24,155,49,153,90,151,
  147,149,220,147,54,146,161,144,30,143,171,141,75,140,252,138,191,137,148,136,124,135,118,134,131,133,163,132,215,131,29,131,
  118,130,227,129,99,129,247,128,158,128,89,128,40,128,10,128,136,100,128,0,255,3,24,1,2,0,128,0,0,64,215,63,
  175,63,134,63,93,63,52,63,12,63,227,62,186,62,145,62,104,62,64,62,23,62,238,61,197,61,156,61,116,61,75,61,
  34,61,249,60,208,60,167,60,127,60,86,60,45,60,4,60,219,59,178,59,137,59,96,59,55,59,14,59,229,58,188,58,
  147,58,105,58,64,58,23,58,238,57,197,57,156,57,114,57,73,57,32,57,246,56,205,56,164,56,122,56,81,56,39,56,
  254,55,212,55,170,55,129,55,87,55,45,55,4,55,218,54,176,54,134,54,92,54,50,54,9,54,223,53,180,53,138,53,
  96,53,54,53,12,53,225,52,183,52,141,52,98,52,56,52,13,52,227,51,184,51,141,51,99,51,56,51,13,51,226,50,
  183,50,140,50,97,50,54,50,11,50,223,49,180,49,136,49,93,49,49,49,6,49,218,48,174,48,131,48,87,48,43,48,
  255,47,210,47,166,47,122,47,77,47,33,47,244,46,200,46,155,46,110,46,65,46,20,46,231,45,186,45,141,45,96,45,
  50,45,5,45,215,44,169,44,123,44,77,44,31,44,241,43,195,43,148,43,102,43,55,43,9,43,218,42,171,42,124,42,
  76,42,29,42,237,41,190,41,142,41,94,41,46,41,254,40,206,40,157,40,109,40,60,40,11,40,218,39,169,39,119,39,
  70,39,20,39,226,38,176,38,126,38,76,38,25,38,231,37,180,37,129,37,77,37,26,37,230,36,178,36,126,36,74,36,
  21,36,225,35,172,35,118,35,65,35,11,35,214,34,159,34,105,34,50,34,252,33,196,33,141,33,85,33,29,33,229,32,
  173,32,116,32,59,32,1,32,199,31,141,31,83,31,24,31,221,30,161,30,102,30,41,30,237,29,176,29,114,29,53,29,
  246,28,184,28,121,28,57,28,249,27,184,27,119,27,54,27,244,26,177,26,110,26,42,26,230,25,161,25,92,25,21,25,
  206,24,135,24,63,24,245,23,172,23,97,23,21,23,201,22,124,22,46,22,223,21,142,21,61,21,235,20,151,20,66,20,
  236,19,149,19,60,19,226,18,134,18,40,18,201,17,103,17,4,17,158,16,54,16,204,15,95,15,239,14,123,14,4,14,
  137,13,10,13,134,12,253,11,109,11,214,10,54,10,141,9,215,8,17,8,54,7,62,6,25,5,154,3,0,0,255,127,
  0,1,128,0,31,2,200,0,206,0,72,0,38,10,122,39,206,0,136,100,172,20,1,0,249,0,252,0,255,0,252,0,
  249,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char DSP1B[8192] = {
  0,192,151,7,0,193,6,32,192,2,48,192,16,192,151,129,128,18,12,128,145,7,0,192,0,0,11,160,64,144,0,0,
  11,128,64,144,0,0,11,96,64,144,0,0,11,76,64,144,0,0,11,176,6,144,204,70,144,0,0,11,132,71,144,0,
  0,11,64,7,144,244,70,144,0,0,11,116,64,144,0,0,11,208,7,144,0,72,144,0,0,11,252,8,144,64,73,144,
  0,0,11,148,64,144,0,0,11,236,9,144,128,77,144,0,0,11,140,14,144,104,80,144,0,0,11,184,64,144,0,0,
  11,0,0,11,32,17,144,36,82,144,0,0,11,204,64,144,0,0,11,140,18,144,244,82,144,0,0,11,0,0,11,168,
  83,144,0,0,11,60,19,144,192,83,144,194,3,192,4,0,192,29,0,18,4,65,145,29,32,21,244,0,146,225,64,0,
  64,224,84,32,224,83,0,0,10,92,65,145,0,0,10,68,65,145,0,128,11,202,255,223,208,128,18,42,0,0,2,16,
  192,232,0,168,37,0,0,109,0,0,0,0,37,69,8,192,80,128,84,33,128,18,100,129,148,0,0,11,10,0,224,2,
  4,192,208,0,83,33,128,18,76,129,148,194,3,192,232,0,160,26,0,19,48,0,20,124,65,148,209,0,64,69,16,192,
  80,0,21,21,0,19,109,0,0,0,0,33,168,65,148,160,1,145,0,0,49,192,1,148,194,255,223,33,128,77,0,0,
  10,184,1,145,0,0,49,192,65,148,65,0,224,32,128,83,42,128,18,208,129,148,96,0,21,96,0,21,42,128,19,0,
  0,37,0,128,113,232,0,168,197,3,192,80,128,20,0,130,148,69,12,192,80,128,21,37,128,19,27,0,19,0,0,101,
  24,194,145,16,0,18,20,66,148,193,255,223,32,128,83,65,0,224,32,128,83,232,0,168,202,3,192,208,128,20,104,194,
  145,80,130,148,69,12,192,80,128,21,37,128,19,27,0,19,0,128,37,76,130,148,0,0,72,0,0,64,35,128,19,16,
  128,21,18,0,19,100,130,148,0,0,8,108,1,160,18,0,18,116,66,148,16,0,83,16,0,19,0,0,72,16,0,19,
  250,64,17,242,64,20,160,2,148,254,160,20,172,194,148,66,12,192,254,160,21,192,2,160,210,0,0,254,160,20,184,130,
  148,66,12,192,0,160,21,192,2,160,66,12,192,222,160,21,33,0,0,0,16,4,21,0,19,251,16,0,15,16,37,31,
  80,19,33,0,0,0,16,4,21,0,19,251,16,0,15,16,37,31,80,19,33,0,0,0,16,4,21,0,19,251,16,0,
  15,16,37,31,16,83,10,1,192,29,0,19,0,0,37,52,67,145,0,0,10,64,67,145,44,67,148,65,0,224,0,0,
  64,193,255,223,0,0,64,0,0,53,44,67,148,0,0,64,0,0,53,36,3,148,0,0,64,16,96,18,200,67,145,104,
  3,148,0,32,10,0,0,9,104,3,146,0,0,8,5,25,192,27,129,10,97,129,9,99,0,37,21,0,19,109,128,9,
  222,0,36,48,0,20,26,0,19,10,0,33,16,0,21,156,3,146,193,255,223,29,0,19,0,0,36,48,0,20,26,0,
  19,0,0,33,16,0,21,188,3,146,193,255,223,208,3,150,0,0,10,0,96,73,193,255,223,194,11,192,0,96,64,16,
  0,18,228,67,148,8,4,168,0,0,64,42,128,19,29,0,19,208,128,20,224,0,22,8,4,168,42,128,19,29,0,19,
  208,128,20,224,0,86,32,128,18,44,196,148,44,128,19,29,128,37,1,0,192,36,132,148,193,255,255,0,128,53,0,0,
  103,202,255,223,208,128,18,44,128,19,29,128,37,1,0,192,72,132,148,193,255,255,0,128,5,0,128,53,0,0,103,92,
  4,168,92,4,168,100,1,0,242,64,0,243,64,0,254,0,0,116,4,168,116,4,168,100,1,0,44,2,0,60,6,37,
  12,0,37,100,1,37,31,0,83,0,128,11,156,132,144,0,0,11,0,128,9,26,0,0,1,240,223,13,8,192,46,0,
  50,130,53,192,13,16,192,26,128,37,37,0,0,98,1,0,97,128,20,45,0,0,2,0,101,16,96,18,224,4,148,0,
  32,10,0,0,9,64,69,146,197,134,192,27,1,19,109,1,37,96,1,21,98,1,0,110,129,50,43,128,19,21,128,37,
  43,128,19,99,128,37,0,0,21,21,0,19,109,0,21,32,0,20,32,5,146,65,0,224,50,0,0,0,128,37,48,133,
  146,194,255,223,60,5,150,0,128,10,0,224,73,0,96,64,32,224,83,16,96,18,88,5,148,0,32,10,0,0,9,148,
  69,146,5,200,192,98,1,0,27,1,19,109,1,53,96,0,18,26,128,37,37,128,19,96,129,21,97,128,20,45,128,19,
  0,0,37,148,5,150,26,0,0,65,0,224,208,96,84,32,224,83,36,128,19,207,255,223,0,2,0,47,6,0,47,68,
  0,47,64,0,47,34,0,66,0,0,4,0,192,47,0,0,204,4,168,35,96,0,244,128,10,31,134,9,216,133,146,194,
  255,223,47,198,19,63,134,21,31,4,64,4,0,192,47,0,0,204,4,168,35,96,0,244,128,10,31,192,9,4,134,146,
  194,255,223,47,192,19,47,2,0,47,32,0,31,32,0,63,6,0,47,64,0,47,64,0,207,255,223,50,4,64,36,128,
  19,15,0,208,0,2,0,47,6,0,47,68,0,47,64,0,47,34,0,66,0,0,4,0,192,47,0,0,204,4,168,0,
  128,11,35,96,11,244,128,10,31,134,9,47,198,19,63,134,21,31,4,64,4,0,192,47,0,0,204,4,168,0,128,11,
  35,96,11,244,128,10,31,192,9,47,192,19,47,2,0,47,32,0,31,32,0,63,6,0,47,64,0,47,64,0,15,0,
  208,50,4,64,176,198,151,138,0,0,184,198,151,157,0,0,0,0,33,22,0,19,0,0,160,204,198,151,129,0,0,212,
  198,151,146,0,0,232,0,168,76,3,168,22,0,19,232,198,151,38,128,19,0,0,160,244,198,151,138,0,0,221,0,0,
  18,0,37,4,199,151,138,128,53,221,0,0,0,128,53,20,199,151,154,0,39,221,0,0,0,128,53,0,0,39,8,1,
  168,0,128,8,140,4,168,220,1,168,22,0,0,0,0,160,64,199,151,138,0,0,221,0,0,18,0,53,80,199,151,138,
  128,39,221,0,0,0,0,53,96,199,151,154,128,39,221,0,0,0,0,53,0,128,39,22,0,0,120,199,151,38,0,0,
  0,0,160,132,199,151,138,0,0,221,0,0,18,0,53,148,199,151,138,128,39,221,0,0,0,0,53,164,199,151,138,128,
  39,221,0,0,0,0,53,180,199,151,154,128,39,221,0,0,0,0,52,0,128,38,38,0,0,0,0,160,208,199,151,129,
  0,0,204,4,168,42,128,19,224,199,151,157,0,0,26,128,33,38,128,19,33,128,33,244,199,151,38,128,19,0,0,160,
  4,60,192,4,200,151,143,2,0,12,200,151,143,6,17,20,200,151,143,50,0,28,200,151,143,32,0,36,200,151,143,8,
  0,204,4,168,47,128,19,2,4,192,232,0,168,76,3,168,0,8,0,31,8,19,47,0,1,232,0,168,28,2,19,47,
  8,33,31,16,0,241,18,0,204,4,168,46,32,0,44,160,19,28,192,33,250,212,37,0,128,5,47,180,19,33,160,49,
  12,8,33,47,192,53,19,0,39,47,160,19,30,128,1,49,128,52,0,0,38,8,1,168,29,96,19,236,128,5,0,0,
  33,220,1,168,4,60,192,0,0,5,31,62,0,1,128,1,8,1,168,29,98,19,236,128,5,0,0,36,220,1,168,212,
  200,151,144,126,21,246,2,0,224,200,151,246,6,0,0,0,5,31,0,0,240,200,151,22,0,0,0,0,160,252,200,151,
  129,0,0,4,16,192,8,201,151,143,0,0,204,4,168,19,96,19,60,0,0,0,0,37,45,128,19,36,201,151,154,128,
  36,61,0,37,22,128,37,52,201,151,38,0,0,0,0,160,64,201,151,129,0,0,132,16,192,76,201,151,143,32,0,84,
  201,151,143,96,0,92,201,151,143,32,0,100,201,151,143,0,0,204,4,168,46,224,19,28,32,19,250,96,37,13,128,37,
  250,0,37,31,160,36,47,32,0,241,0,0,204,4,168,46,224,19,28,0,19,156,201,151,154,0,37,13,128,37,250,0,
  36,31,160,37,0,32,0,47,32,0,241,0,0,204,4,168,46,224,19,246,32,0,28,32,19,250,64,37,13,128,37,250,
  0,37,216,201,151,22,128,36,224,201,151,38,0,0,0,0,160,132,14,192,240,201,151,143,2,0,248,201,151,143,6,0,
  0,202,151,143,0,0,196,51,192,12,202,151,143,16,0,31,80,0,24,202,151,143,16,0,31,38,0,194,31,192,40,202,
  151,129,0,0,228,5,168,130,29,192,56,202,151,145,0,0,152,5,168,68,18,192,47,192,19,1,0,192,5,31,192,196,
  31,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,68,29,192,
  44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,
  19,5,27,192,196,27,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,
  0,19,68,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,0,37,
  84,1,37,31,0,19,5,23,192,196,23,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,
  37,84,1,37,31,0,19,68,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,
  6,37,12,0,37,84,1,37,31,0,19,2,0,192,69,202,192,196,51,192,243,64,0,254,0,0,132,14,192,60,16,1,
  13,0,37,27,0,36,223,144,33,47,176,19,27,0,19,223,144,33,47,194,19,60,16,1,13,0,37,27,0,36,223,144,
  33,47,176,19,27,0,19,223,144,33,47,198,19,60,16,1,13,0,37,27,0,36,223,144,33,47,176,19,27,0,19,223,
  144,33,47,208,19,241,0,0,228,0,168,4,19,192,31,16,19,47,128,19,66,253,255,1,128,196,0,0,5,232,0,168,
  76,3,168,220,1,168,19,0,19,154,0,17,125,0,0,33,128,36,58,128,20,0,0,36,48,140,148,145,0,0,2,0,
  192,60,12,160,42,128,19,0,128,33,0,128,13,4,16,192,47,0,0,204,4,168,4,18,192,31,48,0,47,128,19,232,
  0,168,76,3,168,132,18,192,31,16,19,47,240,19,5,202,192,251,1,0,97,129,33,45,128,19,100,1,37,29,0,19,
  250,216,33,45,192,19,0,128,36,47,0,0,4,16,192,252,0,0,98,1,33,27,1,19,0,128,37,45,128,19,100,129,
  33,44,128,19,100,1,1,250,0,37,29,0,0,100,128,33,47,128,19,232,0,168,76,3,168,196,18,192,31,16,19,47,
  128,19,68,50,192,241,0,0,66,252,255,232,0,168,76,3,168,4,50,192,26,0,0,241,0,0,232,0,168,29,0,19,
  0,0,36,220,1,168,19,0,0,132,38,192,241,26,0,228,0,168,132,18,192,28,16,19,0,0,33,0,128,5,220,1,
  168,4,3,192,246,72,0,52,205,151,54,64,0,68,50,192,28,0,19,0,0,33,196,27,192,28,2,19,250,0,33,132,
  46,192,0,64,5,92,205,151,22,0,0,31,34,19,0,0,36,0,64,5,112,205,151,22,0,0,31,0,0,0,0,160,
  68,2,192,132,205,151,159,0,0,132,17,192,31,0,19,68,2,192,66,0,192,252,128,21,47,88,33,0,0,5,194,1,
  192,232,0,168,76,3,168,4,19,192,28,16,19,0,128,5,46,0,33,19,0,0,220,1,168,196,15,192,31,2,0,31,
  0,0,196,18,192,49,0,0,28,16,19,2,0,33,0,128,5,220,1,168,132,15,192,31,2,0,31,0,19,132,17,192,
  244,0,0,76,46,150,196,15,192,252,64,0,252,34,33,22,0,19,252,192,33,28,206,151,38,128,19,252,0,33,40,206,
  151,22,0,19,0,128,33,52,206,151,38,0,0,60,206,151,144,128,19,148,205,145,4,0,160,196,15,192,252,64,0,252,
  34,37,22,0,19,252,192,37,71,0,192,100,206,151,38,128,19,252,0,37,22,0,19,0,128,37,38,0,0,7,0,192,
  144,128,19,148,205,145,4,0,160,4,47,192,77,0,192,148,206,151,138,0,0,223,16,33,31,18,19,164,206,151,138,0,
  0,223,16,33,31,22,19,180,206,151,154,0,0,223,16,33,31,20,0,242,16,0,241,80,0,0,144,4,0,0,6,8,
  1,168,132,29,192,0,0,11,31,144,9,47,0,0,4,11,192,241,16,0,242,64,0,0,144,4,0,0,6,8,1,168,
  68,29,192,0,0,11,31,144,9,47,0,0,4,7,192,241,16,0,242,64,0,0,144,4,0,0,6,8,1,168,4,29,
  192,0,0,11,31,144,9,47,0,0,1,0,192,132,61,192,124,2,168,132,61,192,241,0,0,196,60,192,31,64,0,31,
  64,0,31,0,19,132,29,192,197,28,192,242,64,0,243,64,0,254,0,0,4,31,192,44,2,0,60,6,37,12,0,37,
  84,1,37,31,0,19,196,30,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,132,30,192,44,2,0,60,6,
  37,12,0,37,84,1,37,31,0,19,68,28,192,0,16,4,242,0,0,28,2,168,132,51,192,0,144,5,0,0,7,220,
  15,146,113,0,0,8,1,168,76,3,168,68,28,192,31,16,0,47,0,0,132,51,192,241,0,0,228,0,168,68,28,192,
  28,16,19,0,0,33,19,128,5,46,0,0,2,2,192,0,128,21,220,1,168,68,28,192,31,32,19,60,16,0,2,0,
  33,0,128,5,220,1,168,132,28,192,31,32,19,60,16,0,2,0,33,0,128,5,220,1,168,22,0,0,132,28,192,84,
  208,151,246,64,0,92,208,151,246,0,0,0,0,160,104,208,151,141,0,0,10,32,192,4,2,192,120,208,151,157,0,53,
  31,40,19,250,8,53,31,88,19,0,0,37,0,0,5,2,2,192,232,0,168,76,3,168,4,19,192,28,16,19,0,0,
  37,19,128,5,46,0,0,220,1,168,132,18,192,60,16,0,19,0,19,2,0,37,0,128,5,220,1,168,68,2,192,29,
  0,19,250,64,0,61,0,37,250,0,0,30,0,0,68,46,192,241,130,37,35,0,0,242,0,0,196,31,192,60,64,0,
  12,34,37,60,64,37,22,0,19,12,128,36,0,128,37,20,209,151,38,128,19,0,0,160,2,203,192,16,128,20,37,128,
  19,100,0,0,48,209,151,130,0,0,67,128,11,47,64,0,64,209,151,129,64,0,47,34,0,47,38,0,80,209,151,143,
  122,0,63,0,0,204,4,168,244,0,0,44,192,19,29,128,37,47,160,19,112,209,151,145,128,37,47,126,0,204,4,168,
  244,0,0,44,192,19,250,162,37,47,192,19,250,128,37,47,192,19,29,128,37,47,162,19,250,196,37,47,164,19,0,32,
  0,250,196,37,47,160,19,241,128,37,47,122,0,204,4,168,244,0,0,28,64,19,250,32,37,31,64,19,0,0,36,31,
  66,19,250,6,0,250,6,36,31,2,19,44,4,37,31,4,19,18,0,37,31,36,19,250,166,21,0,0,37,250,70,21,
  31,166,37,47,192,19,1,0,192,250,166,21,0,0,36,250,70,21,31,166,36,47,0,0,4,0,160,2,203,192,16,128,
  20,37,128,19,48,210,151,129,0,0,100,0,0,28,64,0,64,210,151,131,0,0,60,192,37,76,210,151,158,0,0,12,
  130,37,250,160,37,38,128,19,60,160,37,28,134,37,250,192,37,108,210,151,38,128,19,60,192,37,12,128,37,0,128,37,
  128,210,151,38,0,0,0,0,160,2,203,192,16,128,20,37,128,19,152,210,151,129,0,0,100,0,0,28,2,0,168,210,
  151,131,0,0,60,134,37,180,210,151,158,0,0,12,192,37,250,134,37,38,128,19,60,130,37,28,192,37,250,130,37,212,
  210,151,38,128,19,60,134,37,12,128,37,0,128,37,232,210,151,38,0,0,0,0,160,2,203,192,32,0,21,21,0,19,
  100,0,0,4,211,151,140,64,0,18,0,53,0,128,39,20,211,151,140,64,0,0,0,53,0,128,39,36,211,151,156,0,
  0,0,0,53,0,128,39,38,0,0,0,0,160,66,85,213,193,63,192,20,128,10,47,0,8,68,19,148,193,63,192,84,
  211,151,20,128,10,46,128,3,124,147,145,2,0,8,88,19,148,0,128,10,64,211,148,6,0,192,0,0,160,1,0,196,
  0,0,18,64,0,17,14,64,196,19,128,11,0,0,21,140,147,144,1,0,248,48,0,17,22,0,0,0,0,160,2,0,
  193,21,0,9,176,211,151,102,128,8,172,147,145,0,0,160,192,211,151,70,64,192,0,0,160,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,0,2,0,4,0,8,0,16,0,32,0,64,0,128,0,0,1,0,2,0,4,0,8,0,16,0,32,
  0,64,255,127,0,64,0,32,0,16,0,8,0,4,0,2,0,1,128,0,64,0,32,0,1,0,8,0,4,0,2,0,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,128,229,255,0,1,255,127,2,127,8,126,18,125,31,124,48,123,69,122,93,121,120,120,151,119,186,118,
  223,117,7,117,51,116,97,115,147,114,199,113,254,112,56,112,117,111,180,110,246,109,58,109,129,108,202,107,22,107,100,106,
  180,105,7,105,91,104,178,103,11,103,102,102,196,101,35,101,132,100,231,99,76,99,179,98,28,98,134,97,242,96,96,96,
  208,95,65,95,181,94,41,94,159,93,23,93,145,92,12,92,136,91,6,91,133,90,6,90,136,89,11,89,144,88,22,88,
  157,87,38,87,176,86,59,86,200,85,85,85,228,84,116,84,5,84,152,83,43,83,191,82,85,82,236,81,131,81,28,81,
  182,80,80,80,236,79,137,79,38,79,197,78,100,78,5,78,166,77,72,77,236,76,144,76,52,76,218,75,129,75,40,75,
  208,74,121,74,35,74,205,73,121,73,37,73,209,72,127,72,45,72,220,71,140,71,60,71,237,70,159,70,81,70,4,70,
  184,69,108,69,33,69,215,68,141,68,68,68,252,67,180,67,109,67,38,67,224,66,154,66,85,66,17,66,205,65,137,65,
  70,65,4,65,194,64,129,64,64,64,255,63,247,65,225,67,189,69,141,71,81,73,11,75,187,76,97,78,255,79,148,81,
  34,83,169,84,40,86,162,87,20,89,129,90,233,91,74,93,167,94,255,95,82,97,160,98,234,99,48,101,114,102,176,103,
  234,104,32,106,83,107,131,108,175,109,217,110,255,111,34,113,66,114,95,115,122,116,146,117,167,118,186,119,203,120,217,121,
  229,122,238,123,245,124,250,125,254,126,255,127,0,0,36,3,71,6,106,9,139,12,171,15,200,18,226,21,248,24,11,28,
  25,31,35,34,40,37,38,40,31,43,17,46,251,48,222,51,186,54,140,57,86,60,23,63,206,65,122,68,28,71,180,73,
  63,76,191,78,51,81,155,83,245,85,66,88,130,90,180,92,215,94,236,96,242,98,232,100,207,102,166,104,109,106,36,108,
  202,109,95,111,226,112,85,114,181,115,4,117,65,118,108,119,132,120,138,121,125,122,93,123,41,124,227,124,138,125,29,126,
  157,126,9,127,98,127,167,127,216,127,246,127,255,127,246,127,216,127,167,127,98,127,9,127,157,126,29,126,138,125,227,124,
  41,124,93,123,125,122,138,121,132,120,108,119,65,118,4,117,181,115,85,114,226,112,95,111,202,109,36,108,109,106,166,104,
  207,102,232,100,242,98,236,96,215,94,180,92,130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,28,71,122,68,
  206,65,23,63,86,60,140,57,186,54,222,51,251,48,17,46,31,43,38,40,40,37,35,34,25,31,11,28,248,24,226,21,
  200,18,171,15,139,12,106,9,71,6,36,3,255,127,246,127,216,127,167,127,98,127,9,127,157,126,29,126,138,125,227,124,
  41,124,93,123,125,122,138,121,132,120,108,119,65,118,4,117,181,115,85,114,226,112,95,111,202,109,36,108,109,106,166,104,
  207,102,232,100,242,98,236,96,215,94,180,92,130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,28,71,122,68,
  206,65,23,63,86,60,140,57,186,54,222,51,251,48,17,46,31,43,38,40,40,37,35,34,25,31,11,28,248,24,226,21,
  200,18,171,15,139,12,106,9,71,6,36,3,0,0,220,252,185,249,150,246,117,243,85,240,56,237,30,234,8,231,245,227,
  231,224,221,221,216,218,218,215,225,212,239,209,5,207,34,204,70,201,116,198,170,195,233,192,50,190,134,187,228,184,76,182,
  193,179,65,177,205,174,101,172,11,170,190,167,126,165,76,163,41,161,20,159,14,157,24,155,49,153,90,151,147,149,220,147,
  54,146,161,144,30,143,171,141,75,140,252,138,191,137,148,136,124,135,118,134,131,133,163,132,215,131,29,131,118,130,227,129,
  99,129,247,128,158,128,89,128,40,128,10,128,136,100,128,0,255,3,22,1,2,0,128,0,0,64,215,63,175,63,134,63,
  93,63,52,63,12,63,227,62,186,62,145,62,104,62,64,62,23,62,238,61,197,61,156,61,116,61,75,61,34,61,249,60,
  208,60,167,60,127,60,86,60,45,60,4,60,219,59,178,59,137,59,96,59,55,59,14,59,229,58,188,58,147,58,105,58,
  64,58,23,58,238,57,197,57,156,57,114,57,73,57,32,57,246,56,205,56,164,56,122,56,81,56,39,56,254,55,212,55,
  170,55,129,55,87,55,45,55,4,55,218,54,176,54,134,54,92,54,50,54,9,54,223,53,180,53,138,53,96,53,54,53,
  12,53,225,52,183,52,141,52,98,52,56,52,13,52,227,51,184,51,141,51,99,51,56,51,13,51,226,50,183,50,140,50,
  97,50,54,50,11,50,223,49,180,49,136,49,93,49,49,49,6,49,218,48,174,48,131,48,87,48,43,48,255,47,210,47,
  166,47,122,47,77,47,33,47,244,46,200,46,155,46,110,46,65,46,20,46,231,45,186,45,141,45,96,45,50,45,5,45,
  215,44,169,44,123,44,77,44,31,44,241,43,195,43,148,43,102,43,55,43,9,43,218,42,171,42,124,42,76,42,29,42,
  237,41,190,41,142,41,94,41,46,41,254,40,206,40,157,40,109,40,60,40,11,40,218,39,169,39,119,39,70,39,20,39,
  226,38,176,38,126,38,76,38,25,38,231,37,180,37,129,37,77,37,26,37,230,36,178,36,126,36,74,36,21,36,225,35,
  172,35,118,35,65,35,11,35,214,34,159,34,105,34,50,34,252,33,196,33,141,33,85,33,29,33,229,32,173,32,116,32,
  59,32,1,32,199,31,141,31,83,31,24,31,221,30,161,30,102,30,41,30,237,29,176,29,114,29,53,29,246,28,184,28,
  121,28,57,28,249,27,184,27,119,27,54,27,244,26,177,26,110,26,42,26,230,25,161,25,92,25,21,25,206,24,135,24,
  63,24,245,23,172,23,97,23,21,23,201,22,124,22,46,22,223,21,142,21,61,21,235,20,151,20,66,20,236,19,149,19,
  60,19,226,18,134,18,40,18,201,17,103,17,4,17,158,16,54,16,204,15,95,15,239,14,123,14,4,14,137,13,10,13,
  134,12,253,11,109,11,214,10,54,10,141,9,215,8,17,8,54,7,62,6,25,5,154,3,0,0,255,127,0,1,128,0,
  29,2,200,0,206,0,72,0,38,10,122,39,206,0,136,100,172,20,1,0,249,0,252,0,255,0,252,0,249,0,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char DSP2[8192] = {
  7,0,193,197,255,192,22,0,19,12,192,151,130,0,0,20,128,11,68,192,144,0,128,11,108,192,144,0,128,11,140,192,
  144,97,128,11,60,192,144,12,1,168,4,0,160,72,16,168,4,0,160,0,128,11,164,192,144,0,128,11,196,192,144,97,
  128,11,100,192,144,192,1,168,4,0,160,224,17,168,4,0,160,0,128,11,220,192,144,97,128,11,132,192,144,160,2,168,
  4,0,160,40,17,168,4,0,160,97,128,11,156,192,144,120,9,168,4,0,160,152,20,168,4,0,160,0,128,11,244,192,
  144,97,128,11,188,192,144,88,9,168,4,0,160,152,18,168,4,0,160,97,128,11,212,192,144,220,9,168,4,0,160,100,
  24,168,4,0,160,97,128,11,236,192,144,196,14,168,4,0,160,136,23,168,4,0,160,97,128,11,4,193,144,116,15,168,
  4,0,160,68,27,168,4,0,160,74,224,223,13,64,192,194,0,192,24,193,151,128,0,18,21,0,49,96,128,19,21,0,
  19,111,130,13,0,0,37,52,193,151,128,0,18,21,0,49,96,128,19,21,0,19,111,134,13,0,0,37,80,193,151,128,
  0,18,21,0,49,96,128,19,21,0,19,111,130,13,0,0,37,108,193,151,144,0,18,21,0,49,96,128,19,21,0,19,
  111,6,13,38,2,3,0,128,15,0,0,13,0,6,3,0,0,13,0,2,3,156,193,151,38,0,13,0,6,3,168,193,
  151,22,0,15,176,193,151,22,0,0,184,193,151,16,0,83,77,224,223,10,64,192,195,0,192,4,2,192,208,193,151,128,
  0,18,128,8,168,111,14,37,224,193,151,128,0,18,128,8,168,111,46,37,208,33,150,4,2,192,49,0,0,0,2,3,
  0,0,13,0,6,3,0,0,13,0,2,3,0,0,13,50,38,3,22,0,15,0,130,3,0,128,13,0,134,3,40,194,
  151,22,128,13,49,130,3,0,128,13,0,166,3,60,194,151,38,128,15,164,8,168,40,98,150,76,194,151,22,128,13,49,
  130,3,0,128,13,0,128,3,4,18,192,100,194,151,38,128,15,164,8,168,112,194,151,22,128,13,49,130,3,0,128,13,
  0,166,3,100,34,150,136,194,151,38,128,15,144,194,151,38,128,19,152,194,151,0,0,64,160,194,151,128,0,18,74,224,
  223,13,64,192,18,0,19,35,0,37,196,1,192,188,194,151,128,0,18,128,8,168,111,14,37,228,2,150,208,194,151,128,
  0,18,128,8,168,111,78,37,188,2,160,228,194,151,128,0,18,21,0,49,111,136,8,21,0,19,111,10,37,40,196,145,
  0,195,151,128,0,18,21,0,49,111,8,0,21,0,19,111,0,37,4,2,192,28,195,151,128,0,18,128,8,168,111,14,
  37,68,67,150,48,195,151,128,0,18,128,8,168,111,46,37,28,3,160,68,195,151,128,0,18,21,0,49,111,136,8,21,
  0,19,111,10,37,40,196,145,96,195,151,128,0,18,21,0,49,111,8,0,21,0,19,111,0,37,196,33,192,124,195,151,
  128,0,18,128,8,168,111,14,37,164,3,150,144,195,151,128,0,18,128,8,168,111,78,37,124,3,160,164,195,151,128,0,
  18,21,0,49,111,136,8,21,0,19,111,10,37,40,196,145,192,195,151,128,0,18,21,0,49,111,8,0,21,0,19,111,
  0,37,4,34,192,220,195,151,128,0,18,128,8,168,111,14,37,32,128,19,240,195,151,128,0,18,21,0,49,111,8,0,
  21,0,19,111,10,37,40,68,150,12,196,151,128,0,18,21,0,49,111,8,0,21,0,19,111,46,37,220,3,160,40,196,
  151,144,0,18,21,0,49,111,136,13,21,0,19,111,0,37,196,1,192,33,130,3,0,128,13,0,134,3,0,128,13,0,
  130,3,0,128,13,0,198,3,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,116,196,151,38,128,19,0,128,13,
  0,2,3,0,0,13,0,70,3,140,196,151,22,0,15,0,130,3,0,128,13,0,134,3,0,128,13,164,196,151,22,0,
  19,0,0,13,0,130,3,0,128,13,0,198,3,220,4,150,192,196,151,38,128,15,0,2,3,0,0,13,0,6,3,0,
  0,13,116,4,160,220,196,151,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,0,2,3,248,196,151,38,0,13,
  0,0,3,32,128,19,196,17,192,12,197,151,22,0,15,0,128,13,0,130,3,0,128,13,0,134,3,0,128,13,40,197,
  151,22,0,19,0,0,13,0,130,3,0,128,13,0,198,3,84,5,150,68,197,151,38,128,15,216,8,168,40,5,160,84,
  197,151,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,0,2,3,112,197,151,38,0,13,50,0,3,0,128,8,
  104,200,145,4,2,192,42,128,19,140,197,151,22,0,15,0,128,13,0,130,3,0,128,13,0,134,3,0,128,13,168,197,
  151,22,0,19,0,0,13,0,130,3,0,128,13,0,166,3,212,69,150,196,197,151,38,128,15,24,9,168,168,5,160,212,
  197,151,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,0,2,3,240,197,151,38,0,13,0,0,3,4,18,192,
  32,128,19,0,128,13,8,198,151,22,0,15,0,130,3,0,128,13,0,134,3,0,128,13,32,198,151,22,0,19,0,0,
  13,0,130,3,0,128,13,0,166,3,76,70,150,60,198,151,38,128,15,24,9,168,32,6,160,76,198,151,38,128,15,0,
  2,3,0,0,13,0,6,3,0,0,13,0,2,3,104,198,151,38,0,13,210,0,3,0,128,8,104,200,145,196,33,192,
  42,128,19,132,198,151,22,0,15,0,128,13,0,130,3,0,128,13,0,134,3,0,128,13,160,198,151,22,0,19,0,0,
  13,0,130,3,0,128,13,0,198,3,204,6,150,188,198,151,38,128,15,216,8,168,160,6,160,204,198,151,38,128,15,0,
  2,3,0,0,13,0,6,3,0,0,13,0,2,3,232,198,151,38,0,13,0,0,3,196,49,192,32,128,19,0,128,13,
  0,199,151,22,0,15,0,130,3,0,128,13,0,134,3,0,128,13,24,199,151,22,0,19,0,0,13,0,130,3,0,128,
  13,0,198,3,68,7,150,52,199,151,38,128,15,216,8,168,24,7,160,68,199,151,38,128,15,0,2,3,0,0,13,0,
  6,3,0,0,13,0,2,3,96,199,151,38,0,13,210,0,3,0,128,8,104,200,145,4,34,192,42,128,19,124,199,151,
  22,0,15,0,128,13,0,130,3,0,128,13,0,134,3,0,128,13,152,199,151,22,0,19,0,0,13,0,130,3,0,128,
  13,0,166,3,196,71,150,180,199,151,38,128,15,24,9,168,152,7,160,196,199,151,38,128,15,0,2,3,0,0,13,0,
  6,3,0,0,13,0,2,3,224,199,151,38,0,13,0,0,3,4,50,192,32,128,19,0,128,13,248,199,151,22,0,15,
  0,130,3,0,128,13,0,134,3,0,128,13,16,200,151,22,0,19,0,0,13,0,130,3,0,128,13,0,166,3,60,72,
  150,44,200,151,38,128,15,24,9,168,16,8,160,60,200,151,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,0,
  2,3,88,200,151,38,128,19,0,0,13,0,0,3,104,200,151,22,0,15,112,200,151,22,0,19,120,200,151,0,0,64,
  21,0,49,111,8,0,21,0,19,111,10,37,144,200,151,128,0,18,21,0,49,111,8,0,21,0,83,0,2,3,0,0,
  13,0,6,3,176,200,151,38,0,13,50,2,3,0,0,13,0,38,3,196,200,151,22,0,15,0,130,3,0,128,13,0,
  134,67,0,2,3,0,0,13,0,6,3,0,0,13,232,200,151,38,128,19,0,128,13,0,2,3,0,0,13,0,70,3,
  0,201,151,22,0,15,0,130,3,0,128,13,0,134,3,0,128,77,0,2,3,0,0,13,0,6,3,0,0,13,40,201,
  151,38,128,19,0,128,13,0,2,3,0,0,13,0,38,3,64,201,151,22,0,15,0,130,3,0,128,13,0,134,3,0,
  128,77,133,255,192,97,1,0,96,201,151,144,0,18,0,0,15,27,0,19,0,0,37,30,0,83,120,201,151,128,0,18,
  69,254,192,31,32,0,98,0,0,193,63,192,144,201,151,144,0,18,31,32,0,0,0,19,16,128,18,172,201,145,98,0,
  0,47,1,0,96,0,18,188,73,145,97,0,0,0,0,1,18,64,10,0,192,2,0,0,2,32,0,17,22,0,0,212,
  201,151,32,128,83,220,201,151,128,0,18,18,0,0,19,0,0,188,78,145,5,255,192,244,201,151,143,20,8,15,52,0,
  104,74,145,244,41,150,0,2,0,12,202,151,143,20,8,15,52,0,104,74,145,12,42,150,0,6,0,36,202,151,143,28,
  8,15,60,0,104,74,145,36,42,150,0,2,0,60,202,151,143,28,8,15,60,0,104,74,145,60,42,150,0,14,0,84,
  202,151,143,20,8,15,52,0,104,74,145,84,42,150,100,129,8,44,205,145,112,202,151,143,30,21,0,0,3,31,62,19,
  0,128,8,44,205,145,112,106,150,140,202,151,143,30,21,0,0,3,31,56,19,0,128,8,184,204,145,164,202,151,143,26,
  21,0,0,3,31,58,19,0,128,8,184,204,145,164,106,150,192,202,151,143,26,21,0,0,3,31,56,19,0,128,8,68,
  204,145,216,202,151,143,22,21,0,0,3,31,54,19,0,128,8,68,204,145,216,106,150,244,202,151,143,22,21,0,0,3,
  31,40,19,0,128,8,208,203,145,12,203,151,143,10,21,0,0,3,31,42,19,0,128,8,208,203,145,12,107,150,40,203,
  151,143,10,21,0,0,3,31,40,19,0,128,8,92,203,145,64,203,151,143,14,21,0,0,3,31,46,19,0,128,8,92,
  203,145,64,107,150,92,203,151,7,0,201,159,14,21,0,0,3,31,0,0,193,3,192,98,0,2,0,128,2,132,75,145,
  193,3,192,140,203,145,98,0,0,32,0,17,31,20,10,0,0,2,31,84,0,112,43,150,193,3,192,98,0,2,0,128,
  2,180,75,145,193,3,192,188,203,145,98,0,0,32,0,17,31,20,10,0,0,2,31,82,0,228,11,160,208,203,151,159,
  10,21,7,0,201,0,0,3,31,0,19,193,3,192,98,0,2,0,128,2,248,75,145,193,3,192,0,204,145,98,0,0,
  32,0,17,31,28,10,0,0,2,31,92,0,228,43,150,193,3,192,98,0,2,0,128,2,40,76,145,193,3,192,48,204,
  145,98,0,0,32,0,17,31,28,10,0,0,2,31,94,0,88,12,160,68,204,151,159,22,21,7,0,201,0,0,3,31,
  0,19,193,3,192,98,0,2,0,128,2,108,76,145,193,3,192,116,204,145,98,0,0,32,0,17,31,28,10,0,0,2,
  31,92,0,88,44,150,193,3,192,98,0,2,0,128,2,156,76,145,193,3,192,164,204,145,98,0,0,32,0,17,31,28,
  10,0,0,2,31,82,0,204,12,160,184,204,151,159,26,21,7,0,201,0,0,3,31,0,19,193,3,192,98,0,2,0,
  128,2,224,76,145,193,3,192,232,204,145,98,0,0,32,0,17,31,20,10,0,0,2,31,84,0,204,44,150,193,3,192,
  98,0,2,0,128,2,16,77,145,193,3,192,24,205,145,98,0,0,32,0,17,31,20,10,0,0,2,31,86,0,64,13,
  160,44,205,151,159,30,21,7,0,201,0,0,3,31,0,19,193,3,192,98,0,2,0,128,2,84,77,145,193,3,192,92,
  205,145,98,0,0,32,0,17,31,20,10,0,0,2,31,84,0,64,45,150,193,3,192,98,0,2,0,128,2,132,77,145,
  193,3,192,140,205,145,98,0,0,32,0,17,31,20,10,0,0,2,31,10,0,241,30,0,50,20,2,0,42,1,7,0,
  193,22,128,8,180,206,145,241,30,0,0,20,2,0,42,1,192,205,151,22,128,8,180,206,145,180,109,150,241,30,0,0,
  20,2,0,44,1,220,205,151,22,128,8,180,206,145,241,26,0,0,20,2,0,46,1,244,205,151,22,128,8,180,206,145,
  232,109,150,241,26,0,0,20,2,0,44,1,16,206,151,22,128,8,180,206,145,241,22,0,0,28,2,0,42,1,40,206,
  151,22,128,8,180,206,145,28,110,150,241,22,0,0,28,2,0,52,1,68,206,151,22,128,8,180,206,145,241,10,0,0,
  28,2,0,54,1,92,206,151,22,128,8,180,206,145,80,110,150,241,10,0,0,28,2,0,52,1,120,206,151,22,128,8,
  180,206,145,241,14,0,0,20,2,0,58,1,144,206,151,22,128,8,180,206,145,132,110,150,241,14,0,0,20,2,0,0,
  1,172,206,151,22,128,8,180,206,151,0,0,64,7,0,209,0,0,64,10,224,223,13,64,192,204,206,151,128,0,18,108,
  79,145,0,0,8,32,128,19,0,128,37,4,79,145,232,206,151,128,128,18,47,0,0,66,0,8,0,128,9,36,128,33,
  232,14,145,4,207,151,144,128,18,10,2,194,45,128,19,65,128,53,0,128,15,0,0,8,92,79,148,20,0,0,38,128,
  19,253,0,8,0,128,53,0,128,15,92,79,148,20,0,0,64,207,151,38,128,19,253,0,8,0,128,53,20,128,15,92,
  79,148,64,15,160,92,207,151,38,0,0,100,207,151,0,0,64,7,76,196,16,0,83,7,0,193,120,207,151,128,0,18,
  31,0,0,193,63,192,136,207,151,128,0,18,0,0,15,0,0,1,31,32,0,193,63,192,160,207,151,128,0,18,31,0,
  0,193,63,192,176,207,151,128,0,18,0,0,15,0,0,1,31,66,0,193,63,192,200,207,151,128,0,18,31,0,0,193,
  63,192,216,207,151,128,0,18,0,0,15,0,2,1,240,34,5,194,63,192,240,207,151,128,128,18,47,0,0,194,63,192,
  0,208,151,144,128,18,0,128,15,0,130,1,240,128,7,22,0,0,0,0,15,28,208,151,22,0,0,44,144,146,7,0,
  209,44,208,151,38,0,0,0,128,15,56,208,151,38,0,0,64,208,151,0,0,64,7,0,193,76,208,151,128,0,18,31,
  0,0,193,63,192,194,63,192,96,208,151,128,0,18,0,0,15,0,0,1,31,32,0,193,63,192,120,208,151,128,0,18,
  31,0,0,193,63,192,136,208,151,128,0,18,0,0,15,0,0,1,31,64,0,241,2,0,160,208,151,128,128,18,47,0,
  0,194,63,192,176,208,151,128,128,18,0,128,15,0,128,1,32,32,20,194,63,192,200,208,151,128,128,18,47,0,0,194,
  63,192,216,208,151,144,128,18,0,128,15,0,128,1,47,2,0,242,2,0,22,0,0,240,128,6,0,0,15,252,208,151,
  22,0,0,12,145,146,7,0,209,12,209,151,38,0,0,0,128,15,24,209,151,38,0,0,32,209,151,0,0,64,207,255,
  223,44,209,151,128,0,18,3,0,196,194,63,192,60,209,151,128,128,18,0,128,15,16,128,17,193,63,192,80,209,151,128,
  0,18,42,0,0,194,63,192,96,209,151,144,128,18,0,128,15,16,128,17,45,128,19,33,128,49,0,128,11,176,209,144,
  38,128,15,132,209,151,38,0,0,0,0,33,0,0,11,240,0,2,152,209,151,22,0,15,160,209,151,22,0,0,168,209,
  151,0,0,64,38,128,15,180,209,151,38,0,0,0,0,33,0,0,11,48,0,17,200,209,151,22,0,15,208,209,151,22,
  0,0,216,209,151,0,0,64,207,255,223,228,209,151,128,0,18,3,0,196,194,63,192,244,209,151,128,128,18,0,128,15,
  16,128,17,193,63,192,8,210,151,128,0,18,42,0,0,194,63,192,24,210,151,144,128,18,0,128,15,16,128,17,45,128,
  19,33,128,49,0,128,11,104,210,144,38,128,15,60,210,151,38,0,0,0,0,33,0,0,11,240,0,2,80,210,151,22,
  0,15,88,210,151,22,0,0,96,210,151,0,0,64,38,128,15,108,210,151,38,0,0,0,0,33,0,0,11,48,0,17,
  128,210,151,22,0,15,136,210,151,22,0,0,144,210,151,0,0,64,7,0,193,3,0,192,160,210,151,128,0,18,63,32,
  0,63,32,0,31,0,0,193,63,192,184,210,151,128,0,18,0,0,15,0,0,1,31,32,0,193,63,192,208,210,151,128,
  0,18,31,0,0,74,0,192,205,255,255,193,63,192,232,210,151,128,0,18,0,0,15,0,0,1,31,32,0,194,63,192,
  0,211,151,128,128,18,63,32,0,63,32,0,47,0,0,194,63,192,24,211,151,128,128,18,0,128,15,0,128,1,47,32,
  0,193,63,192,48,211,151,128,0,18,31,0,0,68,211,145,67,0,192,193,63,192,72,211,151,144,0,18,7,0,201,0,
  0,15,0,0,1,31,0,0,48,0,17,112,19,145,7,0,209,0,0,64,132,4,192,15,0,192,196,4,192,207,7,192,
  132,0,192,241,32,0,242,64,12,31,160,12,47,32,0,241,32,0,242,64,12,31,160,12,47,32,0,0,32,4,0,128,
  6,188,147,144,4,0,192,241,32,0,208,19,160,4,1,192,31,32,0,47,96,0,65,0,192,0,32,1,32,128,19,242,
  64,12,31,160,12,47,34,0,241,0,0,0,0,9,31,32,0,0,66,4,132,83,148,241,32,0,242,64,12,31,160,12,
  47,32,0,241,32,0,242,64,12,31,160,12,47,32,0,0,32,4,0,128,6,56,212,144,4,1,192,31,32,0,47,96,
  0,65,0,192,0,0,1,31,0,0,4,0,192,246,0,0,7,0,193,241,32,0,242,32,15,76,212,151,22,0,0,84,
  212,151,38,0,0,4,1,192,241,160,15,100,212,151,38,0,0,242,0,0,112,212,151,22,0,15,120,212,151,22,0,0,
  128,212,151,38,128,15,136,212,151,38,0,0,144,212,151,0,0,64,7,0,193,3,0,192,160,212,151,128,0,18,63,32,
  0,63,32,0,31,0,0,193,63,192,184,212,151,128,0,18,0,0,15,0,0,1,31,32,0,193,63,192,208,212,151,128,
  0,18,31,0,0,74,0,192,205,255,255,193,63,192,232,212,151,128,0,18,0,0,15,0,0,1,31,32,0,194,63,192,
  0,213,151,128,128,18,63,32,0,63,32,0,47,0,0,194,63,192,24,213,151,128,128,18,0,128,15,0,128,1,47,32,
  0,193,63,192,48,213,151,128,0,18,31,0,0,68,213,145,67,0,192,193,63,192,72,213,151,144,0,18,7,0,201,0,
  0,15,0,0,1,31,0,0,48,0,17,112,21,145,7,0,209,0,0,64,3,0,192,196,0,192,1,0,224,0,0,2,
  172,21,148,67,0,224,241,64,0,242,32,0,0,0,10,0,128,10,0,128,9,164,149,144,0,0,9,31,64,0,47,0,
  0,196,1,192,1,0,224,0,0,2,232,21,148,48,0,19,19,0,0,241,64,0,242,32,0,0,0,10,0,128,10,0,
  128,9,224,149,144,0,0,9,31,64,0,47,0,0,132,0,192,241,32,0,242,64,12,31,160,12,47,66,0,15,0,192,
  196,4,192,143,7,192,132,0,192,241,32,0,242,64,12,31,160,12,47,32,0,241,32,0,242,64,12,31,160,12,47,32,
  0,0,32,4,0,128,6,68,150,148,4,0,192,241,32,0,88,22,160,4,1,192,31,32,0,47,96,0,65,0,192,0,
  32,1,32,128,19,242,64,12,31,160,12,47,34,0,241,0,0,0,0,9,31,32,0,0,66,4,12,86,148,241,32,0,
  242,64,12,31,160,12,47,32,0,241,32,0,242,64,12,31,160,12,47,32,0,0,32,4,0,128,6,192,214,148,4,1,
  192,31,32,0,47,96,0,65,0,192,0,0,1,31,0,0,49,0,0,0,0,50,244,86,145,68,0,192,241,64,0,242,
  32,0,0,0,10,0,128,10,0,128,9,236,150,144,0,0,9,31,64,0,47,0,0,49,0,0,208,0,18,40,87,145,
  68,1,192,241,64,0,242,32,0,0,0,10,0,128,10,0,128,9,32,151,144,0,0,9,31,64,0,47,0,0,4,0,
  192,246,0,0,7,0,193,241,32,0,242,32,15,60,215,151,22,0,0,68,215,151,38,0,0,4,1,192,241,160,15,84,
  215,151,38,0,0,242,0,0,96,215,151,22,0,15,104,215,151,22,0,0,112,215,151,38,128,15,120,215,151,38,0,0,
  128,215,151,0,0,64,7,0,192,0,128,11,160,215,144,0,128,11,84,216,144,192,23,160,0,128,11,184,215,144,52,24,
  160,172,215,151,7,0,193,0,0,64,7,0,193,0,0,64,66,85,213,193,63,192,20,128,10,47,0,8,200,23,148,193,
  63,192,216,215,151,20,128,10,46,128,3,4,152,145,2,0,8,220,23,148,0,128,10,196,215,148,6,0,192,252,215,151,
  172,23,160,1,0,196,0,0,18,64,0,17,14,64,196,19,128,11,0,0,21,20,152,144,1,0,248,48,0,17,22,0,
  0,44,216,151,172,23,160,2,0,193,1,0,192,21,0,9,64,216,151,102,128,8,60,152,145,76,216,151,172,23,160,84,
  216,151,6,64,192,92,216,151,172,23,160,10,224,223,13,64,192,108,216,151,128,0,18,0,0,15,19,0,15,0,0,9,
  0,0,11,18,0,33,136,216,151,128,32,18,0,0,9,31,64,11,31,0,19,0,2,33,0,128,8,164,216,151,128,0,
  18,31,0,0,65,128,8,0,0,9,20,0,33,164,152,145,192,216,151,144,0,18,7,0,209,31,0,19,50,0,0,4,
  1,192,31,64,0,31,64,0,31,32,0,220,26,168,132,0,192,31,32,0,242,0,0,31,32,0,241,0,0,0,128,12,
  0,0,12,0,128,12,0,0,12,0,128,12,0,0,12,0,128,12,0,0,12,0,128,12,0,0,12,0,128,12,0,0,
  12,31,32,19,47,32,0,31,32,0,31,32,0,15,4,192,0,32,0,15,30,192,4,0,192,242,0,0,4,30,192,31,
  0,0,65,128,8,0,0,9,20,0,19,84,153,145,13,2,194,68,0,192,241,0,0,0,0,8,31,0,0,160,90,145,
  4,2,192,243,0,0,52,0,0,250,0,0,132,0,192,241,32,0,0,0,3,176,89,145,1,192,255,0,0,50,0,0,
  15,180,25,160,209,0,0,196,0,192,2,32,192,0,128,3,232,217,145,26,0,0,1,60,192,208,0,18,68,2,192,243,
  0,0,52,0,0,194,3,192,0,128,2,8,26,160,26,0,0,193,3,192,208,0,18,68,2,192,243,0,0,52,0,0,
  2,60,192,0,128,2,32,0,17,31,0,0,196,0,192,1,32,192,0,0,3,31,0,0,52,26,145,68,2,192,241,0,
  0,0,0,9,31,0,0,196,1,192,241,64,0,242,64,0,35,0,0,0,64,5,0,160,7,0,32,0,47,32,0,31,
  0,0,48,128,20,52,218,145,0,128,11,4,2,192,241,0,0,32,0,21,31,0,0,108,153,144,132,0,192,1,32,192,
  0,0,3,31,0,0,108,25,145,4,2,192,241,0,0,0,0,9,31,0,0,108,25,160,4,0,192,241,0,0,4,30,
  192,246,0,0,7,0,193,0,32,8,212,90,145,188,218,151,246,0,0,66,0,8,0,128,9,36,0,0,188,26,145,212,
  218,151,0,0,64,131,4,192,241,0,0,0,0,12,31,0,0,4,27,144,16,32,19,241,0,0,0,0,13,0,0,11,
  31,64,19,0,64,0,241,128,12,0,0,12,31,64,0,32,128,17,0,32,4,48,91,144,31,32,0,65,0,192,0,0,
  1,31,64,0,49,0,0,0,0,8,19,32,0,224,26,145,0,64,64,7,0,193,0,0,64,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,
  1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,
  3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,
  1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,
  3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,
  1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,
  3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,
  1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,
  3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,
  1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,
  3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,
  1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,
  3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,
  1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,
  3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,
  1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  3,0,3,0,3,0,3,0,2,0,2,0,2,0,2,0,3,1,3,1,3,1,3,1,2,1,2,1,2,1,2,1,
  3,0,3,0,3,0,3,0,2,0,2,0,2,0,2,0,3,1,3,1,3,1,3,1,2,1,2,1,2,1,2,1,
  3,0,3,0,3,0,3,0,2,0,2,0,2,0,2,0,3,1,3,1,3,1,3,1,2,1,2,1,2,1,2,1,
  3,0,3,0,3,0,3,0,2,0,2,0,2,0,2,0,3,1,3,1,3,1,3,1,2,1,2,1,2,1,2,1,
  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,
  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,
  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,
  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,
  3,2,3,2,3,2,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,3,2,3,2,3,2,3,
  3,2,3,2,3,2,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,3,2,3,2,3,2,3,
  3,2,3,2,3,2,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,3,2,3,2,3,2,3,
  3,2,3,2,3,2,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,3,2,3,2,3,2,3,
  1,2,1,2,1,2,1,2,0,2,0,2,0,2,0,2,1,3,1,3,1,3,1,3,0,3,0,3,0,3,0,3,
  1,2,1,2,1,2,1,2,0,2,0,2,0,2,0,2,1,3,1,3,1,3,1,3,0,3,0,3,0,3,0,3,
  1,2,1,2,1,2,1,2,0,2,0,2,0,2,0,2,1,3,1,3,1,3,1,3,0,3,0,3,0,3,0,3,
  1,2,1,2,1,2,1,2,0,2,0,2,0,2,0,2,1,3,1,3,1,3,1,3,0,3,0,3,0,3,0,3,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  0,0,0,0,0,0,0,0,16,16,0,0,143,0,129,127,240,0,15,0,128,127,240,0,80,0,128,8,15,0,255,0,
};
const unsigned char DSP3[8192] = {
  0,192,151,4,0,192,7,0,193,6,32,192,2,48,192,20,192,151,129,128,18,16,128,145,7,0,192,18,0,11,28,72,
  144,184,72,145,0,0,11,124,70,144,0,0,11,148,73,144,0,0,11,84,65,144,0,0,11,220,71,144,80,0,160,0,
  0,11,208,64,144,0,0,11,236,64,144,66,85,213,193,63,192,20,128,10,47,0,8,108,0,148,193,63,192,124,192,151,
  20,128,10,46,128,3,164,128,145,2,0,8,128,0,148,0,128,10,104,192,148,6,0,192,0,0,160,1,0,196,0,0,
  18,64,0,17,14,64,196,19,128,11,0,0,21,180,128,144,1,0,248,48,0,17,22,0,0,0,0,160,2,0,193,1,
  0,192,21,0,9,220,192,151,102,128,8,216,128,145,0,0,160,236,192,151,6,192,192,0,0,160,32,128,19,69,0,0,
  68,3,192,16,0,19,47,32,0,31,2,0,241,192,17,242,32,12,31,2,0,56,1,144,7,0,208,22,2,0,40,193,
  151,79,0,192,146,2,0,7,0,192,241,194,12,47,2,12,242,32,0,31,192,8,47,34,0,16,129,148,84,0,64,0,
  0,11,0,68,144,6,32,192,132,7,192,15,0,224,104,193,151,129,32,0,13,16,192,10,56,192,224,0,21,30,0,0,
  128,193,151,159,0,0,66,0,192,252,0,168,0,0,8,204,65,145,168,1,148,2,2,192,252,0,168,212,1,160,0,0,
  8,184,1,145,248,0,168,200,1,160,194,0,192,252,0,168,0,0,9,0,0,9,0,0,9,0,0,9,48,0,21,19,
  128,17,212,0,15,242,0,11,0,128,12,47,128,17,226,0,12,0,128,11,8,194,144,36,0,0,226,0,0,31,128,9,
  45,0,0,44,2,160,36,0,15,226,0,1,31,128,9,193,3,192,45,0,18,44,2,145,209,0,0,0,0,9,26,0,
  0,0,128,20,136,129,145,194,3,192,224,128,18,96,66,145,1,4,192,32,0,20,212,0,0,242,0,0,0,128,12,0,
  0,8,80,2,145,47,0,0,4,0,192,248,0,168,0,0,9,30,0,21,16,0,21,19,2,19,31,2,0,130,0,192,
  252,0,168,2,4,192,31,130,21,37,0,0,98,0,0,49,160,5,47,2,8,19,0,0,124,2,145,10,56,192,205,63,
  192,2,0,0,196,7,192,243,0,0,252,0,168,20,0,0,242,2,0,252,0,168,0,0,5,69,6,192,18,0,0,96,
  1,18,96,1,21,21,128,11,1,8,192,32,0,21,4,195,144,20,128,11,241,128,11,0,128,11,208,128,21,36,0,15,
  24,3,160,20,128,11,241,128,11,0,128,11,208,128,21,36,0,0,224,0,18,98,0,0,0,128,2,80,195,145,130,0,
  224,16,128,21,38,0,0,52,195,151,248,0,168,2,2,192,16,0,21,16,0,21,16,128,21,252,0,168,22,0,0,49,
  0,0,2,0,8,19,0,0,96,195,151,184,2,145,4,0,160,108,195,151,129,0,0,242,0,11,0,128,12,47,32,0,
  242,0,11,0,128,12,47,32,0,242,0,11,0,128,12,47,32,0,242,0,11,0,128,12,47,32,0,242,0,11,0,128,
  12,47,32,0,242,0,11,0,128,12,47,32,0,242,0,11,0,128,12,47,32,0,242,0,11,0,128,12,47,96,64,212,
  195,151,242,32,11,0,128,12,224,128,18,46,0,0,242,32,11,0,128,12,224,128,18,0,128,15,0,128,17,38,0,64,
  0,0,11,108,68,144,205,63,192,12,196,151,131,0,0,7,0,193,6,0,192,108,3,168,108,3,168,108,3,168,108,3,
  168,108,3,168,108,3,168,108,3,168,56,196,151,129,0,0,7,0,192,216,3,168,212,3,168,212,3,168,212,3,168,84,
  196,151,49,0,0,0,0,8,19,96,0,20,4,145,0,0,160,6,32,192,132,7,192,15,0,224,120,196,151,129,32,0,
  13,16,192,10,56,192,224,0,21,30,0,0,144,196,151,159,0,0,66,0,192,252,0,168,0,0,8,220,68,145,184,4,
  148,2,2,192,252,0,168,228,4,160,0,0,8,200,4,145,248,0,168,216,4,160,194,0,192,252,0,168,0,0,9,0,
  0,9,0,0,9,0,0,9,48,0,21,19,128,17,212,0,15,242,0,11,0,128,12,47,128,17,226,0,12,0,128,11,
  24,197,144,36,0,0,226,0,0,31,128,9,45,0,0,60,5,160,36,0,15,226,0,1,31,128,9,193,3,192,45,0,
  18,60,5,145,209,0,0,0,0,9,26,0,0,0,128,20,152,132,145,194,3,192,224,128,18,112,69,145,1,4,192,32,
  0,20,212,0,0,242,0,0,0,128,12,0,0,8,96,5,145,47,0,0,4,0,192,248,0,168,0,0,9,30,0,21,
  16,0,21,19,2,19,31,2,0,130,0,192,252,0,168,2,4,192,31,130,21,37,0,0,98,0,0,49,160,5,47,2,
  8,19,0,0,140,5,145,10,56,192,205,63,192,2,0,0,196,7,192,243,0,0,252,0,168,20,0,0,242,2,0,252,
  0,168,0,0,5,69,6,192,18,0,0,96,1,18,96,1,21,21,128,11,1,8,192,32,0,21,20,198,144,20,128,11,
  241,128,11,0,128,11,208,128,21,36,0,15,40,6,160,20,128,11,241,128,11,0,128,11,208,128,21,36,0,0,224,0,
  18,98,0,0,0,128,2,96,198,145,130,0,224,16,128,21,38,0,0,68,198,151,248,0,168,194,1,192,16,0,21,16,
  0,21,16,128,21,252,0,168,22,0,0,49,0,0,2,0,8,19,0,0,112,198,151,200,5,145,4,0,160,0,0,11,
  192,78,144,7,0,192,196,30,192,140,198,151,138,0,0,241,16,0,31,48,0,241,16,0,31,48,0,241,16,0,31,48,
  0,241,16,0,31,48,0,180,198,151,141,0,0,188,198,151,129,0,0,18,0,12,208,6,144,4,0,160,193,62,192,0,
  128,11,16,128,21,36,0,0,35,0,0,244,0,0,7,0,192,236,198,151,129,16,0,208,0,20,31,0,0,30,0,0,
  44,71,148,5,7,192,96,1,20,84,71,144,241,0,0,96,1,20,40,71,144,241,0,0,96,1,20,31,0,0,80,7,
  160,197,7,192,96,1,21,84,71,144,241,0,0,96,1,21,80,71,144,241,0,0,96,1,21,31,0,0,7,0,208,84,
  199,151,129,0,0,224,32,20,31,0,0,120,71,148,2,72,192,32,0,20,136,71,144,132,7,160,2,16,192,32,0,21,
  136,71,144,7,0,208,162,64,0,241,128,12,38,0,0,148,199,151,172,135,148,22,0,0,160,199,151,6,0,224,188,6,
  160,6,0,0,15,32,0,180,199,151,246,80,0,188,199,151,6,0,224,196,199,151,143,32,0,65,0,0,52,0,9,31,
  0,0,188,6,160,7,0,192,196,30,192,2,32,192,47,32,0,236,199,151,129,128,21,0,0,12,232,7,144,4,0,160,
  197,43,192,29,0,19,98,1,33,0,128,50,96,0,18,32,0,17,0,0,79,0,0,11,188,77,144,69,43,192,4,0,
  192,66,0,0,48,200,151,129,128,17,96,129,21,96,129,18,96,0,21,96,128,21,21,0,0,99,0,0,37,0,0,110,
  0,0,88,200,151,129,0,0,58,0,11,31,32,0,0,8,168,31,32,0,112,200,151,145,0,0,10,0,11,31,64,0,
  0,8,168,0,32,5,22,0,0,58,0,0,241,64,0,0,8,168,31,64,0,10,0,0,241,32,0,0,8,168,0,0,
  4,172,200,151,22,0,0,0,0,160,184,200,151,129,128,17,0,0,11,26,0,0,200,200,151,145,0,0,0,0,11,29,
  0,19,18,0,49,0,0,12,22,128,33,228,200,151,0,128,12,38,0,0,0,0,160,20,0,0,244,0,9,63,0,64,
  99,1,0,100,0,0,21,0,0,244,0,0,241,32,0,78,16,12,144,73,144,253,64,0,250,0,0,2,0,192,52,0,
  0,244,0,0,241,0,0,0,0,12,124,73,144,209,16,0,0,32,4,76,9,148,0,0,10,96,0,20,104,9,144,225,
  0,0,0,0,4,100,9,148,0,0,10,96,0,20,0,144,12,65,0,0,0,0,9,20,0,19,48,9,160,4,0,0,
  65,0,0,47,0,9,20,0,19,16,9,160,0,0,64,0,0,11,240,73,144,7,0,208,193,62,192,195,255,255,244,8,
  168,244,8,168,244,8,168,244,8,168,197,9,192,129,10,192,0,9,168,69,9,192,129,10,192,0,9,168,197,8,192,129,
  10,192,0,9,168,69,8,192,65,10,192,0,9,168,7,0,192,4,0,160,0,0,11,160,74,144,193,9,192,205,255,199,
  0,202,151,144,0,20,21,0,0,100,1,0,241,16,0,254,0,20,36,10,145,6,0,192,0,0,160,100,0,0,243,0,
  0,5,10,192,16,0,19,52,0,17,96,0,21,19,0,19,242,32,0,32,128,17,28,202,148,240,0,17,52,74,145,224,
  128,18,38,0,0,10,0,0,96,202,151,210,0,0,96,128,20,42,0,11,124,74,144,148,74,145,100,10,160,212,0,0,
  226,0,0,0,128,2,38,0,0,140,202,151,100,10,160,22,0,0,152,202,151,52,10,160,206,255,255,205,30,192,168,202,
  151,129,128,17,0,0,11,224,0,21,20,0,0,243,0,0,192,202,151,141,0,0,200,202,151,154,0,0,52,0,0,241,
  0,0,226,16,12,40,75,144,20,11,148,209,160,4,240,138,148,0,128,10,0,0,4,252,10,148,0,0,10,32,0,21,
  18,0,0,0,0,20,20,11,144,46,80,0,69,0,0,49,0,0,0,0,9,0,0,9,19,0,0,208,10,160,1,0,
  0,84,0,12,60,75,148,193,255,199,0,0,2,22,0,0,64,203,151,6,0,0,0,0,160,4,61,192,79,0,192,4,
  60,192,111,33,0,111,0,0,196,60,192,79,236,192,4,61,192,138,2,192,242,32,0,253,96,0,0,160,5,241,160,53,
  37,0,0,13,0,194,194,3,192,96,0,21,152,11,148,0,0,5,26,128,18,37,0,0,1,51,192,98,0,37,20,0,
  0,209,128,2,84,141,145,0,0,11,3,229,192,5,230,192,204,11,144,67,227,192,69,228,192,196,61,192,47,32,0,63,
  32,0,31,32,0,20,0,0,97,1,0,98,1,2,84,77,145,10,1,192,29,0,19,67,128,2,100,0,49,31,64,0,
  47,34,15,31,192,15,47,64,0,132,62,192,143,1,192,196,60,192,138,2,192,245,32,0,97,33,0,98,65,5,29,224,
  5,0,160,5,241,32,0,0,160,53,95,64,0,37,0,0,96,0,21,69,230,192,80,12,148,0,0,5,30,0,11,92,
  12,144,133,228,192,10,1,192,100,1,0,243,0,0,20,0,0,97,1,0,50,0,2,16,77,145,29,0,0,97,129,53,
  45,0,2,168,204,144,16,128,20,172,140,144,0,1,0,242,1,0,96,129,18,224,128,17,47,0,0,16,13,160,194,255,
  255,100,1,0,96,129,20,16,205,144,0,64,5,16,77,144,19,0,4,16,13,144,13,0,194,194,3,192,10,128,18,78,
  0,0,37,0,0,1,51,192,98,0,37,20,0,0,49,128,2,16,141,145,4,0,0,31,2,15,31,0,0,196,61,192,
  31,0,0,132,62,192,79,1,192,20,12,160,132,62,192,241,0,0,0,0,8,31,0,0,20,12,145,196,61,192,0,32,
  1,84,77,145,245,32,0,241,0,0,98,1,0,100,0,0,243,0,0,20,0,0,0,128,2,48,128,17,47,0,0,68,
  61,192,242,64,0,241,128,20,0,0,9,31,160,9,96,139,145,0,0,64,132,61,192,31,0,0,197,226,192,76,11,168,
  69,226,192,76,11,168,197,225,192,76,11,168,69,225,192,76,11,168,197,224,192,76,11,168,69,224,192,76,11,168,241,32,
  0,242,64,9,31,128,20,120,141,145,0,0,64,0,0,11,252,77,144,196,62,192,193,63,192,250,64,0,19,0,0,212,
  205,151,130,0,18,31,32,21,0,128,15,48,160,18,45,0,0,47,0,53,0,0,11,22,0,0,0,0,160,0,0,11,
  84,64,144,7,0,193,195,63,192,194,236,192,196,62,192,49,0,0,24,206,151,128,0,18,16,128,21,16,128,21,37,0,
  0,250,64,0,49,0,0,7,0,192,56,206,151,130,0,18,31,160,15,48,160,18,96,0,18,47,32,11,97,1,0,96,
  129,23,45,128,4,104,142,144,226,0,0,116,14,160,116,142,148,0,128,5,0,128,5,45,128,15,132,62,192,0,32,5,
  19,0,4,160,78,144,148,14,148,0,0,5,0,0,5,19,128,17,38,0,0,168,14,160,49,128,17,38,0,0,168,206,
  151,16,0,21,0,0,53,0,0,11,22,0,0,0,0,160,0,0,11,64,83,144,196,62,192,193,63,192,19,0,0,212,
  206,151,130,0,18,31,160,15,48,160,18,47,0,0,4,0,160,132,60,192,245,0,0,195,63,192,49,0,0,2,0,18,
  196,62,192,250,64,0,132,62,192,31,160,15,48,160,18,96,0,18,47,32,11,97,1,0,96,128,23,45,128,4,52,143,
  144,226,0,0,64,15,160,64,143,148,0,128,5,0,128,5,45,64,0,47,128,15,132,62,192,0,32,5,19,0,4,108,
  79,144,100,15,148,0,0,5,0,0,5,19,192,17,112,15,160,49,192,17,31,0,21,46,0,53,0,0,11,19,0,64,
  196,60,192,245,0,0,196,62,192,250,64,0,241,32,0,96,32,18,242,32,11,97,1,0,96,128,23,45,128,4,180,143,
  144,226,0,0,192,15,160,192,143,148,0,128,5,0,128,5,45,64,0,47,0,0,132,62,192,0,32,5,18,64,4,236,
  15,144,47,0,0,32,128,21,0,128,53,0,128,11,35,0,64,252,15,148,0,32,0,0,0,5,0,64,5,31,0,0,
  16,0,21,0,0,53,0,0,11,19,0,64,13,0,194,60,16,148,193,3,192,58,0,18,21,0,0,1,51,192,0,0,
  37,20,0,0,97,0,0,0,0,1,31,0,64,193,3,192,58,0,18,21,0,0,1,51,192,0,0,37,20,0,0,97,
  0,0,0,0,10,0,0,2,31,0,64,138,2,192,132,63,192,66,44,192,0,160,5,253,0,0,0,128,53,37,0,0,
  132,61,192,242,32,0,96,128,21,47,0,0,132,63,192,1,0,192,0,0,1,168,16,145,236,14,168,172,16,160,128,15,
  168,7,0,192,54,0,0,180,208,151,6,0,192,7,0,193,4,62,192,63,64,0,242,0,0,35,128,11,208,208,151,129,
  0,0,47,0,15,16,209,144,16,16,168,196,61,192,244,0,0,193,63,192,2,62,254,244,208,151,144,0,18,0,0,15,
  8,17,148,47,0,64,32,0,17,31,0,64,16,16,168,196,61,192,244,0,0,193,63,192,32,209,151,144,0,18,18,0,
  15,52,17,148,0,0,64,0,128,1,47,0,64,2,243,192,132,61,192,16,128,21,37,0,0,111,0,0,2,58,192,16,
  128,21,36,0,0,254,0,0,132,60,192,194,236,192,16,128,21,16,128,21,47,32,9,0,0,9,194,236,192,16,128,21,
  16,128,21,47,128,19,4,61,192,0,128,1,196,63,192,47,0,0,176,209,145,0,128,9,0,128,9,47,0,0,236,14,
  168,236,14,168,132,63,192,15,0,192,100,16,168,132,63,192,241,32,0,242,64,9,31,128,9,33,160,4,184,145,145,31,
  0,0,68,61,192,0,0,4,176,17,145,0,0,64,132,63,192,1,0,192,0,0,1,0,18,145,236,14,168,4,18,160,
  128,15,168,7,0,192,138,2,192,132,63,192,66,44,192,54,0,0,0,160,5,253,0,0,0,128,53,37,0,0,132,61,
  192,242,32,0,96,128,21,0,128,11,36,0,0,242,0,0,64,210,151,193,7,192,7,0,193,84,210,144,0,128,15,0,
  128,11,0,128,11,0,128,11,16,128,18,32,0,20,112,18,145,194,255,255,38,0,0,116,210,151,0,0,64,2,243,192,
  132,61,192,16,128,21,37,0,0,111,0,0,2,58,192,16,128,21,36,0,0,254,0,0,68,62,192,47,0,0,132,60,
  192,194,236,192,16,128,21,16,128,21,47,32,9,0,0,9,194,236,192,16,128,21,16,128,21,47,128,19,4,61,192,0,
  128,1,196,63,192,47,0,0,132,63,192,15,0,192,232,17,168,132,63,192,241,32,0,242,64,9,31,128,9,33,160,4,
  232,146,145,31,0,0,68,61,192,0,0,4,224,18,145,68,62,192,244,0,0,15,0,64,195,63,192,49,0,0,40,211,
  151,146,0,18,4,61,192,31,160,15,48,128,18,47,0,64,0,0,11,216,86,144,32,19,168,1,0,192,60,17,168,65,
  0,192,60,17,168,129,0,192,60,17,168,193,0,192,60,17,168,1,1,192,60,17,168,65,1,192,60,17,168,7,0,192,
  198,255,255,132,211,151,132,60,192,15,102,192,4,61,192,1,0,192,0,0,1,184,83,145,68,61,192,242,0,0,31,128,
  8,33,0,0,112,13,168,28,20,160,130,226,192,131,1,192,10,1,192,37,128,17,97,128,8,0,0,11,20,0,0,5,
  230,192,97,129,8,0,1,2,29,1,0,248,83,145,241,1,0,96,0,18,0,0,49,31,0,0,49,0,0,0,0,8,
  19,0,0,196,19,145,68,61,192,242,0,9,31,128,8,33,0,0,112,13,168,7,0,208,6,0,192,32,19,168,1,0,
  192,124,18,168,65,0,192,124,18,168,129,0,192,124,18,168,193,0,192,124,18,168,1,1,192,124,18,168,65,1,192,124,
  18,168,7,0,192,198,255,255,0,0,160,68,61,192,241,64,0,0,0,9,31,0,0,4,60,192,111,33,0,111,0,0,
  196,60,192,79,236,192,4,61,192,138,2,192,242,32,0,253,96,0,0,160,5,241,160,53,37,0,0,13,0,194,194,3,
  192,96,0,21,184,20,148,0,0,5,26,128,18,37,0,0,1,51,192,98,0,37,20,0,0,209,128,2,116,150,145,0,
  0,11,3,229,192,5,230,192,236,20,144,67,227,192,69,228,192,196,61,192,47,32,0,63,32,0,31,32,0,20,0,0,
  97,1,0,98,1,2,116,86,145,10,1,192,29,0,19,67,128,2,100,0,49,31,64,0,47,34,15,31,192,15,47,64,
  0,132,62,192,143,1,192,196,60,192,138,2,192,245,32,0,97,33,0,98,65,5,29,224,5,0,160,5,241,32,0,0,
  160,53,95,64,0,37,0,0,96,0,21,69,230,192,112,21,148,0,0,5,30,0,11,124,21,144,133,228,192,10,1,192,
  100,1,0,243,0,0,20,0,0,97,1,0,50,0,2,48,86,145,29,0,0,97,129,53,45,0,2,200,213,144,16,128,
  20,204,149,144,0,1,0,242,1,0,96,129,18,224,128,17,47,0,0,48,22,160,194,255,255,100,1,0,96,129,20,48,
  214,144,0,64,5,48,86,144,19,0,4,48,22,144,13,0,194,194,3,192,10,128,18,78,0,0,37,0,0,1,51,192,
  98,0,37,20,0,0,49,128,2,48,150,145,4,0,0,31,2,15,31,0,0,196,61,192,31,0,0,132,62,192,79,1,
  192,52,21,160,132,62,192,241,0,0,0,0,8,31,0,0,52,21,145,196,61,192,0,32,1,116,86,145,245,32,0,241,
  0,0,98,1,0,100,0,0,243,0,0,20,0,0,0,128,2,48,128,17,47,0,0,4,61,192,241,0,0,0,0,8,
  31,32,0,128,20,145,0,0,64,132,61,192,31,0,0,69,224,192,100,20,168,197,224,192,100,20,168,69,225,192,100,20,
  168,197,225,192,100,20,168,69,226,192,100,20,168,197,226,192,100,20,168,241,32,0,242,64,9,31,128,20,148,150,145,0,
  0,64,0,0,11,184,87,144,32,19,168,1,0,192,60,17,168,65,0,192,60,17,168,129,0,192,60,17,168,193,0,192,
  60,17,168,1,1,192,60,17,168,65,1,192,60,17,168,7,0,192,198,255,255,28,215,151,132,60,192,15,102,192,4,61,
  192,1,0,192,0,0,1,80,87,145,68,61,192,242,0,0,31,128,8,33,0,0,140,22,168,28,20,160,130,226,192,131,
  1,192,10,1,192,37,128,17,97,128,8,0,0,11,20,0,0,5,230,192,97,129,8,0,1,2,29,1,0,144,87,145,
  241,1,0,96,0,18,0,0,49,31,0,0,49,0,0,0,0,8,19,0,0,92,23,145,68,61,192,242,0,9,31,128,
  8,33,0,0,140,22,168,28,20,160,196,62,192,250,0,0,4,58,192,195,63,192,193,63,192,204,215,151,142,0,0,2,
  0,18,16,0,21,0,128,15,48,128,18,45,0,0,0,0,53,0,0,11,22,0,0,244,215,151,15,32,0,15,32,0,
  15,32,0,15,32,0,15,32,0,15,0,0,4,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,128,0,64,0,32,0,16,0,8,0,4,0,2,0,1,128,0,64,0,32,0,16,0,8,0,4,0,2,0,1,0,
  2,0,4,0,8,0,16,0,32,0,64,0,128,0,0,1,0,0,15,0,0,4,0,2,64,1,0,4,0,2,64,0,
  125,0,126,0,126,0,123,0,124,0,125,0,123,0,124,0,2,0,32,0,48,0,0,0,13,0,25,0,38,0,50,0,
  62,0,74,0,86,0,98,0,109,0,121,0,132,0,142,0,152,0,162,0,172,0,181,0,190,0,198,0,206,0,213,0,
  220,0,226,0,231,0,236,0,241,0,245,0,248,0,251,0,253,0,255,0,0,1,0,1,0,1,255,0,253,0,251,0,
  248,0,245,0,241,0,237,0,231,0,226,0,220,0,213,0,206,0,198,0,190,0,181,0,172,0,162,0,153,0,142,0,
  132,0,121,0,110,0,98,0,86,0,74,0,62,0,50,0,38,0,25,0,13,0,0,0,243,255,231,255,219,255,206,255,
  194,255,182,255,170,255,158,255,147,255,135,255,125,255,114,255,104,255,94,255,84,255,75,255,66,255,58,255,50,255,43,255,
  37,255,30,255,25,255,20,255,15,255,11,255,8,255,5,255,3,255,1,255,0,255,0,255,0,255,1,255,3,255,5,255,
  8,255,11,255,15,255,19,255,24,255,30,255,36,255,43,255,50,255,58,255,66,255,75,255,84,255,93,255,103,255,114,255,
  124,255,135,255,146,255,158,255,169,255,181,255,194,255,206,255,218,255,231,255,243,255,43,0,127,0,32,0,255,0,0,255,
  190,255,0,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,193,255,1,0,2,0,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,255,3,0,4,0,5,0,71,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,255,6,0,7,0,8,0,
  9,0,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  208,255,10,0,11,0,12,0,13,0,14,0,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,215,255,15,0,16,0,17,0,18,0,19,0,20,0,83,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,21,0,22,0,23,0,24,0,25,0,26,0,27,0,
  89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,255,28,0,29,0,30,0,
  31,0,32,0,33,0,34,0,35,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  242,255,36,0,37,0,38,0,39,0,40,0,41,0,42,0,43,0,44,0,104,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,253,255,45,0,46,0,47,0,48,0,49,0,50,0,51,0,52,0,53,0,54,0,113,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,255,55,0,56,0,57,0,58,0,59,0,60,0,61,0,
  62,0,63,0,64,0,65,0,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,255,0,0,1,0,2,0,
  3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,
  226,255,12,0,13,0,14,0,15,0,16,0,17,0,18,0,19,0,20,0,21,0,22,0,23,0,24,0,80,0,0,0,
  0,0,0,0,0,0,0,0,241,255,25,0,26,0,27,0,28,0,29,0,30,0,31,0,32,0,33,0,34,0,35,0,
  36,0,37,0,38,0,93,0,0,0,0,0,0,0,0,0,203,255,39,0,40,0,41,0,42,0,43,0,44,0,45,0,
  46,0,47,0,48,0,49,0,50,0,51,0,52,0,53,0,107,0,0,0,0,0,0,0,220,255,0,0,1,0,2,0,
  3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,12,0,13,0,14,0,15,0,68,0,0,0,0,0,
  238,255,16,0,17,0,18,0,19,0,20,0,21,0,22,0,23,0,24,0,25,0,26,0,27,0,28,0,29,0,30,0,
  31,0,32,0,84,0,0,0,238,255,33,0,34,0,35,0,36,0,37,0,38,0,39,0,40,0,41,0,42,0,43,0,
  44,0,45,0,46,0,47,0,48,0,49,0,50,0,101,0,190,255,0,0,172,254,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,255,1,0,2,0,173,254,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  197,255,3,0,4,0,5,0,175,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,202,255,6,0,7,0,8,0,9,0,178,254,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,255,10,0,11,0,12,0,13,0,14,0,182,254,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,255,15,0,16,0,17,0,
  18,0,19,0,20,0,187,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  223,255,21,0,22,0,23,0,24,0,25,0,26,0,27,0,193,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,232,255,28,0,29,0,30,0,31,0,32,0,33,0,34,0,35,0,200,254,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,242,255,36,0,37,0,38,0,39,0,40,0,41,0,42,0,
  43,0,44,0,208,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,45,0,46,0,47,0,
  48,0,49,0,50,0,51,0,52,0,53,0,54,0,217,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  199,255,55,0,56,0,57,0,58,0,59,0,60,0,61,0,62,0,63,0,64,0,65,0,227,254,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,212,255,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,
  11,0,172,254,0,0,0,0,0,0,0,0,0,0,0,0,226,255,12,0,13,0,14,0,15,0,16,0,17,0,18,0,
  19,0,20,0,21,0,22,0,23,0,24,0,184,254,0,0,0,0,0,0,0,0,0,0,241,255,25,0,26,0,27,0,
  28,0,29,0,30,0,31,0,32,0,33,0,34,0,35,0,36,0,37,0,38,0,197,254,0,0,0,0,0,0,0,0,
  203,255,39,0,40,0,41,0,42,0,43,0,44,0,45,0,46,0,47,0,48,0,49,0,50,0,51,0,52,0,53,0,
  211,254,0,0,0,0,0,0,220,255,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,
  11,0,12,0,13,0,14,0,15,0,172,254,0,0,0,0,238,255,16,0,17,0,18,0,19,0,20,0,21,0,22,0,
  23,0,24,0,25,0,26,0,27,0,28,0,29,0,30,0,31,0,32,0,188,254,0,0,238,255,33,0,34,0,35,0,
  36,0,37,0,38,0,39,0,40,0,41,0,42,0,43,0,44,0,45,0,46,0,47,0,48,0,49,0,50,0,205,254,
  84,1,24,2,16,1,176,0,204,0,176,0,136,0,176,0,68,0,176,0,0,0,176,0,254,0,7,255,2,0,255,0,
  248,0,7,0,254,0,238,0,255,7,0,2,239,0,0,248,0,7,238,0,255,255,255,255,255,255,0,0,0,0,1,0,
  1,0,1,0,1,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,1,0,1,0,1,0,1,0,0,0,
  0,0,255,255,255,255,0,0,255,255,1,0,0,0,1,0,1,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,
  255,255,1,0,0,0,1,0,1,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,68,0,136,0,204,0,
  16,1,84,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char DSP4[8192] = {
  198,255,255,4,192,151,145,0,0,0,0,11,140,64,144,0,0,11,84,64,144,0,0,11,60,64,144,0,0,11,52,64,
  144,164,16,145,20,1,160,4,1,145,144,19,160,0,0,11,76,64,144,44,27,145,56,11,160,4,1,145,244,25,160,0,
  0,11,116,64,144,0,0,11,108,64,144,156,26,145,8,1,160,4,1,145,12,25,160,0,0,11,132,64,144,4,1,145,
  144,16,160,4,1,145,248,6,160,0,0,11,204,64,144,0,0,11,180,64,144,0,0,11,172,64,144,72,26,145,168,1,
  160,4,1,145,252,11,160,0,0,11,196,64,144,4,1,145,108,16,160,4,1,145,108,1,160,0,0,11,236,64,144,0,
  0,11,228,64,144,16,27,145,220,6,160,4,1,145,196,25,160,0,0,11,252,64,144,4,1,145,172,16,160,0,0,145,
  100,1,160,0,0,160,70,0,192,12,193,151,0,0,160,6,0,192,1,0,192,28,193,151,138,0,0,3,0,224,206,255,
  223,44,193,151,141,0,0,18,0,37,0,0,11,0,128,53,0,128,11,0,128,18,80,1,144,48,128,17,38,0,0,84,
  193,151,22,0,0,92,193,151,0,0,160,12,6,168,180,1,160,132,4,192,1,0,224,31,0,0,116,5,168,1,0,192,
  128,193,151,138,0,21,112,68,148,3,192,255,206,63,192,4,0,192,36,5,168,68,0,192,36,5,168,52,2,160,132,4,
  192,1,0,224,31,0,0,116,5,168,1,0,192,188,193,151,138,0,21,112,68,148,3,192,255,206,63,192,4,0,192,36,
  5,168,68,0,192,84,5,168,52,2,160,1,0,192,232,193,151,138,0,21,104,68,148,132,0,192,241,14,0,242,0,0,
  4,0,192,0,14,5,0,142,7,31,14,0,47,0,0,196,0,192,241,14,0,242,0,0,68,0,192,0,14,5,0,142,
  7,31,14,0,47,0,0,3,192,255,206,63,192,132,0,192,36,5,168,196,0,192,36,5,168,4,44,192,80,194,151,159,
  56,0,242,0,0,38,0,0,45,140,20,0,138,37,104,194,151,38,0,0,241,26,13,31,16,0,47,142,4,0,128,12,
  47,216,20,132,194,151,253,48,13,0,128,37,0,128,12,47,200,4,47,170,20,241,84,0,31,28,0,246,0,0,253,12,
  0,0,128,37,176,194,151,38,0,0,241,0,0,47,6,36,192,194,151,52,68,148,52,68,145,19,0,0,241,0,0,32,
  0,20,52,68,148,52,68,145,47,48,0,0,128,4,248,130,148,32,0,21,52,68,148,52,68,145,22,54,0,252,194,151,
  242,72,0,32,128,17,20,195,148,60,6,168,68,20,192,31,90,0,53,0,20,27,0,0,96,67,145,31,28,0,250,10,
  0,241,32,0,242,64,53,31,160,39,47,10,0,250,68,0,241,32,0,242,64,53,31,160,39,47,88,0,241,0,0,0,
  0,9,31,28,0,40,3,145,3,224,255,14,0,193,68,32,192,2,255,255,246,128,21,47,22,0,120,195,151,241,80,0,
  0,28,5,242,0,20,22,128,8,47,6,0,144,195,151,250,10,0,241,32,0,242,64,53,31,160,39,47,14,0,241,0,
  0,48,0,20,192,3,148,6,224,255,0,4,0,216,3,160,0,0,20,212,67,148,6,224,192,0,4,0,216,3,160,246,
  4,0,216,195,151,250,68,0,241,32,0,242,64,53,31,160,39,47,130,20,241,0,0,0,0,8,31,70,0,104,3,145,
  241,30,0,0,0,11,0,52,5,31,10,0,241,30,0,0,0,11,0,26,5,31,78,0,1,0,224,31,14,0,31,34,
  0,6,0,224,228,1,160,68,24,192,241,4,0,0,0,11,0,0,5,31,68,0,241,42,0,0,0,11,0,0,5,31,
  12,0,6,0,192,92,196,151,6,0,224,228,1,160,0,0,8,116,68,148,0,0,160,0,0,8,204,68,148,68,28,192,
  128,196,151,138,0,0,136,196,151,129,0,0,29,0,5,31,12,0,241,0,0,0,0,37,31,10,0,241,0,0,0,0,
  37,31,0,0,196,28,192,241,0,0,184,196,151,128,0,21,31,14,20,31,0,0,228,1,160,0,0,8,204,68,148,4,
  28,192,216,196,151,138,0,0,224,196,151,129,0,0,29,0,5,31,12,0,241,0,0,0,0,37,31,10,0,241,0,0,
  0,0,37,31,0,0,132,28,192,241,0,0,16,197,151,128,0,21,31,14,20,31,0,0,228,1,160,36,197,151,129,0,
  0,18,0,15,48,0,18,48,128,18,64,133,148,0,128,17,0,128,15,0,0,5,31,14,0,0,128,7,47,14,64,84,
  197,151,129,0,0,0,0,5,31,14,0,100,197,151,130,0,0,0,128,7,47,14,64,6,0,192,4,0,192,124,197,151,
  143,14,0,132,197,151,143,12,0,159,6,0,144,197,151,143,48,0,152,197,151,143,18,0,160,197,151,143,76,0,168,197,
  151,143,42,0,176,197,151,143,14,0,184,197,151,143,12,0,159,10,0,145,0,0,200,197,151,128,0,21,31,24,20,212,
  197,151,143,196,13,220,197,151,143,48,21,0,0,12,31,36,20,236,197,151,143,14,0,244,197,151,143,46,0,252,197,151,
  143,14,0,4,198,151,143,78,64,6,0,192,132,4,192,20,198,151,193,7,224,144,0,18,31,32,0,1,248,192,144,0,
  18,31,32,0,1,0,223,128,0,18,31,0,64,132,8,192,31,32,0,63,70,0,3,1,192,6,0,192,80,198,151,138,
  0,0,88,198,151,14,0,192,69,23,192,146,0,0,96,128,18,241,160,4,45,0,0,146,0,37,96,1,18,0,0,17,
  30,0,0,96,128,18,241,160,4,45,0,0,130,0,37,96,1,18,0,0,17,30,0,0,96,128,18,241,192,4,45,64,
  0,0,0,37,96,1,18,0,0,17,22,0,0,188,198,151,49,0,0,0,0,8,19,0,0,76,6,145,132,8,192,241,
  32,0,243,0,64,2,0,192,67,72,200,1,30,192,36,0,8,63,128,9,232,6,145,0,0,160,2,0,192,3,4,196,
  1,30,192,36,0,8,63,128,9,4,7,145,0,0,160,46,128,11,136,135,144,104,135,148,0,128,9,208,135,148,0,128,
  9,236,135,148,0,128,9,8,136,148,0,128,9,36,136,148,0,128,9,64,136,148,0,128,9,92,136,148,0,128,9,120,
  136,148,0,128,9,148,136,148,65,0,192,0,0,75,3,128,192,36,0,0,241,0,0,0,0,15,48,0,20,164,73,148,
  0,0,15,31,128,9,131,128,192,208,135,148,0,128,9,236,135,148,0,128,9,8,136,148,0,128,9,36,136,148,0,128,
  9,64,136,148,0,128,9,92,136,148,0,128,9,120,136,148,0,128,9,148,136,148,65,0,192,0,0,75,36,0,0,241,
  0,0,48,0,20,120,73,148,26,0,15,120,73,148,223,128,9,36,0,0,241,0,0,48,0,20,96,73,148,26,0,15,
  96,73,148,223,128,9,36,0,0,241,0,0,48,0,20,72,73,148,26,0,15,72,73,148,223,128,9,36,0,0,241,0,
  0,48,0,20,48,73,148,26,0,15,48,73,148,223,128,9,36,0,0,241,0,0,48,0,20,24,73,148,26,0,15,24,
  73,148,223,128,9,36,0,0,241,0,0,48,0,20,0,73,148,26,0,15,0,73,148,223,128,9,36,0,0,241,0,0,
  48,0,20,232,72,148,26,0,15,232,72,148,223,128,9,36,0,0,1,0,0,0,0,11,188,8,144,3,128,192,241,0,
  0,48,0,20,131,128,192,208,72,148,31,0,77,241,0,0,48,0,20,26,0,15,208,72,144,223,0,64,0,128,8,164,
  137,148,36,0,0,241,0,0,48,0,21,31,0,0,0,128,8,164,137,148,36,0,0,241,0,0,48,0,21,31,0,0,
  0,128,8,164,137,148,36,0,0,241,0,0,48,0,21,31,0,0,0,128,8,164,137,148,36,0,0,241,0,0,48,0,
  21,31,0,0,0,128,8,164,137,148,36,0,0,241,0,0,48,0,21,31,0,0,0,128,8,164,137,148,36,0,0,241,
  0,0,48,0,21,31,0,0,0,128,8,164,137,148,36,0,0,241,0,0,48,0,21,31,0,0,1,128,8,164,137,148,
  0,0,11,164,9,144,131,0,192,36,0,0,241,0,0,48,0,21,31,0,0,65,0,192,0,0,75,65,0,192,0,0,
  75,46,128,11,0,138,144,224,137,148,0,128,9,44,138,148,0,128,9,72,138,148,0,128,9,100,138,148,0,128,9,128,
  138,148,65,0,192,0,0,75,3,64,192,36,0,0,241,0,0,0,0,15,48,0,20,48,75,148,0,0,15,31,128,9,
  67,64,192,44,138,148,0,128,9,72,138,148,0,128,9,100,138,148,0,128,9,128,138,148,0,128,9,65,0,192,0,0,
  75,36,0,0,241,0,0,48,0,20,4,75,148,26,0,15,4,75,148,223,128,9,36,0,0,241,0,0,48,0,20,236,
  74,148,26,0,15,236,74,148,223,128,9,36,0,0,241,0,0,48,0,20,212,74,148,26,0,15,212,74,148,223,128,9,
  36,0,0,1,0,0,0,0,11,168,10,144,3,64,192,241,0,0,48,0,20,67,64,192,188,74,148,31,0,77,241,0,
  0,48,0,20,26,0,15,188,74,144,223,0,64,0,128,8,48,139,148,36,0,0,241,0,0,48,0,21,31,0,0,0,
  128,8,48,139,148,36,0,0,241,0,0,48,0,21,31,0,0,0,128,8,48,139,148,36,0,0,241,0,0,48,0,21,
  31,0,0,1,128,8,48,139,148,0,0,11,48,11,144,131,0,192,36,0,0,241,0,0,48,0,21,31,0,0,65,0,
  192,0,0,75,65,0,192,0,0,75,6,0,192,4,30,192,64,203,151,143,32,0,72,203,151,143,88,0,80,203,151,143,
  0,0,241,6,0,92,203,151,143,2,0,100,203,151,143,34,0,108,203,151,143,2,0,116,203,151,143,0,0,68,30,192,
  128,203,151,145,0,0,0,28,5,19,0,4,152,11,148,63,0,0,0,6,0,143,64,0,160,203,151,129,0,0,26,0,
  18,248,75,148,124,75,145,1,0,192,184,203,151,128,0,20,192,203,151,141,0,0,0,26,37,0,26,5,31,32,20,212,
  203,151,141,0,5,0,26,37,0,26,5,31,34,20,232,203,151,143,64,0,168,13,168,124,11,160,0,0,160,6,0,192,
  4,30,192,4,204,151,143,32,0,12,204,151,143,88,0,20,204,151,143,0,0,241,6,0,32,204,151,143,2,0,40,204,
  151,143,34,0,48,204,151,143,2,0,56,204,151,143,0,0,68,30,192,68,204,151,129,0,0,0,28,5,19,0,4,92,
  12,148,63,0,0,16,6,20,96,204,151,138,0,21,192,76,148,64,76,145,1,0,192,116,204,151,128,0,20,124,204,151,
  143,64,0,132,204,151,141,0,0,0,26,37,0,26,5,31,32,20,152,204,151,141,0,5,0,26,37,0,26,5,31,34,
  20,172,204,151,143,64,0,168,13,168,1,0,192,64,12,160,0,128,18,0,0,12,0,64,145,0,0,12,232,76,144,0,
  0,12,224,76,144,4,13,160,0,13,145,0,13,160,0,0,12,248,76,144,0,13,145,0,13,160,0,13,145,0,13,160,
  0,0,160,3,224,223,8,205,151,130,0,0,0,128,11,48,128,18,42,128,20,28,205,151,129,0,0,36,205,151,143,0,
  20,29,128,5,0,128,37,47,192,20,56,205,151,129,0,0,64,205,151,143,0,20,29,128,4,0,128,36,80,205,151,138,
  0,0,88,205,151,144,128,21,38,0,0,100,205,151,45,128,20,22,154,37,0,154,5,47,160,20,241,0,0,124,205,151,
  128,0,21,29,0,0,0,154,37,0,154,5,47,162,20,148,205,151,143,64,0,168,13,168,1,0,192,64,12,160,1,0,
  192,172,205,151,143,32,21,136,78,145,0,64,5,31,2,0,184,15,168,206,3,192,4,50,192,241,10,0,19,0,4,220,
  77,145,116,14,148,0,0,21,228,77,148,49,2,0,0,0,4,248,13,148,0,0,21,116,78,148,68,50,192,241,10,0,
  19,0,4,12,78,145,116,14,148,0,0,21,60,78,148,241,74,0,242,32,0,0,32,0,47,32,0,31,14,0,129,59,
  192,31,14,0,112,15,168,116,78,144,68,38,192,49,2,0,0,72,4,80,14,148,0,0,21,116,78,148,68,50,192,242,
  0,0,20,7,168,116,78,144,4,50,192,241,0,0,36,16,168,68,50,192,216,15,168,6,0,192,120,206,151,6,0,192,
  68,46,192,168,13,160,68,46,192,1,0,192,144,206,151,143,32,21,108,79,145,0,64,5,31,2,0,184,15,168,206,1,
  192,4,50,192,241,10,0,19,0,4,192,78,145,88,15,148,0,0,21,200,78,148,49,2,0,0,0,4,220,14,148,0,
  0,21,88,79,148,68,50,192,241,10,0,19,0,4,240,78,145,88,15,148,0,0,21,32,79,148,241,74,0,242,32,0,
  0,32,0,47,32,0,31,14,0,129,59,192,31,14,0,148,15,168,88,79,144,68,38,192,49,2,0,0,72,4,52,15,
  148,0,0,21,88,79,148,68,50,192,242,0,0,172,9,168,88,79,144,4,50,192,241,0,0,12,16,168,68,50,192,216,
  15,168,6,0,192,92,207,151,6,0,192,68,46,192,140,14,160,0,0,64,242,0,0,20,7,168,144,79,144,132,50,192,
  241,0,0,36,16,168,196,50,192,216,15,168,0,0,64,242,0,0,172,9,168,180,79,144,132,50,192,241,0,0,12,16,
  168,196,50,192,216,15,168,0,0,64,241,0,0,188,207,151,128,12,21,31,76,0,241,0,0,204,207,151,144,12,21,31,
  0,84,193,63,192,19,64,2,30,0,15,242,0,0,48,128,18,16,128,17,70,0,192,244,207,151,38,46,0,252,207,151,
  246,0,13,4,208,151,0,0,64,3,64,192,14,0,192,48,0,18,56,80,145,78,85,213,56,16,160,3,64,192,142,170,
  234,48,0,18,56,80,145,206,255,255,196,59,192,1,0,0,242,64,2,244,128,12,0,0,1,31,128,12,100,144,144,132,
  59,192,241,160,13,47,64,9,31,0,64,196,59,192,47,0,64,4,60,192,2,0,192,47,32,0,116,48,150,132,59,192,
  1,60,192,31,160,13,47,0,0,0,0,160,4,60,192,246,32,0,152,208,151,148,48,150,0,0,160,12,6,168,184,16,
  160,132,4,192,1,0,224,31,0,0,6,0,192,4,0,192,192,208,151,143,14,0,200,208,151,143,12,0,159,6,0,212,
  208,151,143,48,0,220,208,151,143,18,0,228,208,151,143,76,0,236,208,151,143,42,0,244,208,151,143,14,0,252,208,151,
  143,12,0,159,10,0,145,0,0,12,209,151,128,0,21,31,24,20,24,209,151,143,196,13,32,209,151,143,48,21,0,0,
  12,31,36,20,1,0,192,52,209,151,138,0,21,128,83,148,3,192,255,206,63,192,4,28,192,76,209,151,129,0,0,84,
  209,151,141,0,0,0,0,37,31,0,0,68,28,192,104,209,151,129,0,0,112,209,151,141,0,0,0,0,37,31,0,0,
  4,44,192,132,209,151,159,56,0,242,6,0,38,0,0,241,26,13,31,16,0,47,142,4,0,128,12,47,216,20,168,209,
  151,253,48,13,0,128,37,0,128,12,47,200,4,47,170,20,241,84,0,31,28,0,242,12,0,38,0,0,241,0,0,47,
  6,20,216,209,151,76,83,148,76,83,145,19,0,0,241,0,0,32,0,20,76,83,148,76,83,145,47,48,0,0,128,4,
  16,146,148,32,0,21,76,83,148,76,83,145,22,54,0,20,210,151,242,72,0,32,128,17,44,210,148,60,6,168,68,20,
  192,31,90,0,53,0,20,27,0,0,120,82,145,31,28,0,250,10,0,241,32,0,242,64,53,31,160,39,47,10,0,250,
  68,0,241,32,0,242,64,53,31,160,39,47,88,0,241,0,0,0,0,9,31,28,0,64,18,145,3,224,255,14,0,193,
  68,32,192,2,255,255,246,128,21,47,22,0,144,210,151,241,80,0,0,28,5,242,0,20,22,128,8,47,6,0,168,210,
  151,250,10,0,241,32,0,242,64,53,31,160,39,47,14,0,241,0,0,48,0,20,216,18,148,6,224,255,0,4,0,240,
  18,160,0,0,20,236,82,148,6,224,192,0,4,0,240,18,160,246,4,0,240,210,151,250,68,0,241,32,0,242,64,53,
  31,160,39,47,130,20,241,0,0,0,0,8,31,70,0,128,18,145,241,30,0,0,0,11,0,52,5,31,10,0,241,30,
  0,0,0,11,0,26,5,31,78,0,1,0,224,31,14,0,31,34,0,6,0,224,48,17,160,68,24,192,241,4,0,0,
  0,11,0,0,5,31,68,0,241,42,0,0,0,11,0,0,5,31,12,0,6,0,192,116,211,151,6,0,224,48,17,160,
  0,0,8,0,0,148,136,211,151,0,0,160,6,0,192,4,28,192,76,21,168,4,32,192,76,21,168,4,48,192,76,21,
  168,4,52,192,76,21,168,4,56,192,76,21,168,4,44,192,76,21,168,4,60,192,76,21,168,4,40,192,76,21,168,2,
  0,192,68,2,192,47,0,0,96,21,168,132,21,168,4,1,192,250,0,0,4,8,192,228,21,168,228,21,168,228,21,168,
  204,21,168,28,22,168,4,4,192,80,22,168,132,22,168,132,21,168,60,85,148,68,16,192,241,32,0,0,0,4,12,85,
  145,4,8,192,228,21,168,228,21,168,228,21,168,204,21,168,4,4,192,1,0,192,0,34,5,112,20,148,16,32,20,0,
  0,5,112,20,145,4,44,192,241,54,0,2,255,255,32,32,18,31,0,0,68,4,192,1,0,192,0,34,5,164,84,148,
  164,84,145,16,32,20,0,0,5,164,20,145,68,44,192,241,54,0,2,255,255,32,32,18,31,0,0,132,4,192,156,22,
  168,196,4,192,192,22,168,68,2,192,0,128,5,216,148,145,4,12,192,0,128,5,248,212,148,248,212,145,68,2,192,47,
  0,0,4,4,192,156,22,168,68,4,192,192,22,168,132,60,192,241,64,0,31,64,0,31,0,0,4,12,192,184,23,168,
  132,12,192,228,22,168,48,21,160,4,8,192,228,21,168,228,21,168,228,21,168,204,21,168,4,12,192,228,22,168,132,12,
  192,228,22,168,28,22,168,6,0,224,20,20,160,68,2,192,246,0,0,68,213,151,0,0,160,2,1,192,80,213,151,143,
  160,8,80,149,145,0,0,64,68,1,192,100,213,151,143,32,0,108,213,151,143,32,0,116,213,151,143,32,0,124,213,151,
  143,0,64,4,1,192,1,0,192,140,213,151,143,20,21,200,85,148,26,0,0,2,0,192,160,213,151,128,128,20,47,160,
  20,172,213,151,143,32,0,180,213,151,128,128,20,47,160,20,192,213,151,143,32,64,0,0,64,67,28,0,244,0,0,1,
  0,192,216,213,151,157,0,5,248,21,160,67,28,0,244,0,0,1,0,192,240,213,151,141,0,5,52,0,37,31,6,4,
  0,0,12,31,10,20,67,18,0,244,0,0,52,0,5,31,14,4,31,34,64,4,8,192,241,8,0,31,6,20,31,46,
  0,241,8,0,31,6,20,31,46,0,241,8,0,31,6,20,31,46,0,241,8,0,31,6,20,31,0,64,1,0,192,31,
  32,0,31,68,0,196,24,168,19,0,0,196,24,168,0,0,15,48,0,17,22,0,0,116,214,151,6,0,224,28,22,168,
  0,0,64,4,0,192,1,0,192,31,32,0,31,32,0,31,32,0,31,0,64,1,0,192,0,14,5,188,22,148,241,16,
  0,0,12,5,18,0,4,188,86,148,47,128,84,32,128,84,1,0,192,0,14,5,224,86,148,241,16,0,0,18,5,18,
  0,4,224,22,148,47,128,84,32,128,84,1,0,192,0,0,4,176,87,148,176,87,145,31,32,0,31,78,0,19,22,5,
  0,22,4,56,87,145,50,0,0,30,142,20,176,215,148,176,215,145,35,0,0,196,24,168,196,24,168,1,0,0,0,64,
  8,30,64,0,28,23,145,0,14,0,241,22,0,31,10,0,0,18,4,88,23,148,48,0,21,176,87,148,176,87,145,19,
  0,0,54,0,0,140,24,168,196,24,168,30,80,20,104,215,151,246,0,5,2,1,192,32,0,20,31,32,0,31,16,0,
  168,24,168,196,24,168,0,0,15,0,0,17,144,215,151,22,0,0,49,64,0,0,64,8,19,0,0,92,23,145,168,215,
  151,0,0,64,6,0,192,168,23,160,1,0,192,0,0,4,240,22,148,132,88,145,243,14,0,241,22,0,0,22,4,236,
  87,148,50,0,0,16,128,20,132,216,148,132,216,145,35,0,0,241,28,0,48,0,20,0,18,4,0,0,8,44,24,148,
  30,0,0,48,0,21,132,88,148,132,88,145,19,0,0,196,24,168,196,24,168,1,0,0,0,64,9,30,64,0,20,24,
  145,54,0,0,196,24,168,30,80,20,56,216,151,129,1,192,0,0,5,22,0,0,130,0,192,32,0,20,31,32,0,31,
  16,0,196,24,168,0,0,15,0,0,17,100,216,151,22,0,0,49,64,0,0,64,8,19,0,0,48,24,145,124,216,151,
  0,0,64,6,0,192,124,24,160,0,16,0,241,22,0,0,16,4,164,24,144,1,0,192,31,22,64,0,22,64,0,16,
  0,241,22,0,0,14,4,192,24,144,193,63,192,31,8,64,0,8,64,245,4,0,251,8,0,241,6,0,242,6,53,31,
  134,39,47,16,0,0,146,5,33,158,4,248,152,148,0,0,4,4,89,148,0,2,5,31,52,64,0,30,0,241,28,0,
  31,52,64,241,2,0,31,52,64,6,0,192,10,96,192,132,0,192,24,217,151,143,0,0,4,0,192,116,25,168,116,25,
  168,250,66,0,96,25,168,0,38,0,56,217,151,96,25,168,0,34,0,68,217,151,96,25,168,0,46,0,80,217,151,96,
  25,168,88,217,151,0,0,160,241,64,0,242,0,4,29,0,0,0,128,37,38,0,64,1,0,252,31,0,0,124,217,151,
  130,0,0,33,128,2,45,128,20,0,130,37,47,2,14,18,0,2,29,0,20,0,4,37,31,132,14,33,128,2,45,128,
  20,0,134,37,47,6,14,18,0,2,29,0,20,0,8,37,31,168,78,36,26,168,172,9,168,232,89,144,4,50,192,241,
  0,0,12,16,168,68,50,192,216,15,168,0,0,160,6,0,192,236,217,151,0,0,160,36,26,168,20,7,168,24,90,144,
  4,50,192,241,0,0,36,16,168,68,50,192,216,15,168,0,0,160,6,0,192,28,218,151,0,0,160,6,0,192,4,50,
  192,44,218,151,143,32,0,2,0,192,56,218,151,143,142,21,64,218,151,159,14,64,6,0,192,138,170,192,5,0,196,2,
  0,192,4,0,192,3,252,255,206,3,192,128,26,168,128,26,168,128,26,168,128,26,168,38,0,0,120,218,151,0,0,160,
  128,218,151,141,0,0,97,128,14,48,128,18,0,0,37,0,0,18,16,128,81,66,85,213,193,63,192,20,128,10,47,0,
  8,164,26,148,193,63,192,180,218,151,20,128,10,46,128,3,224,154,145,2,0,8,184,26,148,0,128,10,160,218,148,6,
  0,192,216,218,151,0,0,160,1,0,196,0,0,18,64,0,17,14,64,196,19,128,11,0,0,21,240,154,144,1,0,248,
  48,0,17,22,0,0,8,219,151,0,0,160,2,0,193,1,0,192,21,0,9,102,128,8,32,219,151,24,155,145,0,0,
  160,6,0,193,48,219,151,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,64,0,32,85,21,0,16,204,12,170,10,36,9,0,8,28,7,102,6,209,5,85,5,236,4,146,4,68,4,
  0,4,195,3,142,3,94,3,51,3,12,3,232,2,200,2,170,2,143,2,118,2,94,2,73,2,52,2,34,2,16,2,
  0,2,240,1,225,1,212,1,199,1,186,1,175,1,164,1,153,1,143,1,134,1,125,1,116,1,108,1,100,1,92,1,
  85,1,78,1,71,1,65,1,59,1,53,1,47,1,41,1,36,1,31,1,26,1,21,1,17,1,12,1,8,1,4,1,
  0,1,252,0,248,0,244,0,240,0,237,0,234,0,230,0,227,0,224,0,221,0,218,0,215,0,212,0,210,0,207,0,
  204,0,202,0,199,0,197,0,195,0,192,0,190,0,188,0,186,0,184,0,182,0,0,124,224,3,31,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char SGB1[256] = {
  49,254,255,62,48,224,0,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,
  119,62,252,224,71,33,95,192,14,8,175,50,13,32,252,17,79,1,62,251,14,6,245,6,0,26,27,50,128,71,13,32,
  248,50,241,50,14,14,214,2,254,239,32,234,17,4,1,33,16,128,26,205,211,0,205,212,0,19,123,254,52,32,243,17,
  230,0,6,8,26,19,34,35,5,32,249,62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,
  62,145,224,64,33,0,192,14,0,62,0,226,62,48,226,6,16,30,8,42,87,203,66,62,16,32,2,62,32,226,62,48,
  226,203,26,29,32,239,5,32,232,62,32,226,62,48,226,205,194,0,125,254,96,32,210,14,19,62,193,226,12,62,7,226,
  24,58,22,4,240,68,254,144,32,250,30,0,29,32,253,21,32,242,201,79,6,4,197,203,17,23,193,203,17,23,5,32,
  245,34,35,34,35,201,60,66,185,165,185,165,66,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,1,224,80,
};
const unsigned char SGB2[256] = {
  49,254,255,62,48,224,0,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,
  119,62,252,224,71,33,95,192,14,8,175,50,13,32,252,17,79,1,62,251,14,6,245,6,0,26,27,50,128,71,13,32,
  248,50,241,50,14,14,214,2,254,239,32,234,17,4,1,33,16,128,26,205,211,0,205,212,0,19,123,254,52,32,243,17,
  230,0,6,8,26,19,34,35,5,32,249,62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,
  62,145,224,64,33,0,192,14,0,62,0,226,62,48,226,6,16,30,8,42,87,203,66,62,16,32,2,62,32,226,62,48,
  226,203,26,29,32,239,5,32,232,62,32,226,62,48,226,205,194,0,125,254,96,32,210,14,19,62,193,226,12,62,7,226,
  24,58,22,4,240,68,254,144,32,250,30,0,29,32,253,21,32,242,201,79,6,4,197,203,17,23,193,203,17,23,5,32,
  245,34,35,34,35,201,60,66,185,165,185,165,66,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,255,224,80,
};
const unsigned char ST010[53248] = {
  54,0,0,4,192,151,4,4,192,241,0,0,0,0,2,12,0,148,0,0,11,60,64,144,0,0,11,80,64,144,0,0,
  11,56,69,144,0,0,11,228,68,144,104,0,160,0,0,11,92,0,144,0,0,11,116,4,144,120,0,160,0,0,11,212,
  5,144,124,1,160,0,0,11,204,6,144,168,1,160,4,4,192,1,0,192,31,0,0,8,0,160,4,0,192,241,0,0,
  0,0,15,206,63,192,0,0,18,31,32,0,192,4,168,31,32,0,47,0,0,132,0,192,254,0,0,194,73,192,197,43,
  192,3,44,192,11,1,0,16,0,19,36,0,37,31,128,8,49,0,0,11,1,8,19,0,0,180,0,145,68,0,192,254,
  0,0,194,117,192,197,43,192,3,44,192,11,1,0,16,0,19,36,0,37,31,128,8,49,0,0,11,1,8,19,0,0,
  232,0,145,68,0,192,241,0,0,0,0,10,0,0,9,30,0,0,194,161,192,197,43,192,3,44,192,11,1,0,16,0,
  19,36,0,37,31,128,8,49,0,0,11,1,8,19,0,0,40,1,145,132,0,192,254,0,0,194,205,192,197,43,192,3,
  44,192,11,1,0,16,0,19,36,0,37,31,128,8,49,0,0,11,1,8,19,0,0,92,1,145,104,0,160,4,0,192,
  253,32,0,250,0,0,4,2,192,16,0,19,0,0,53,31,32,0,16,0,19,0,0,37,31,0,0,104,0,160,4,24,
  192,241,0,0,196,24,192,0,0,4,4,26,192,31,0,0,68,24,192,242,0,0,68,25,192,0,128,4,68,26,192,47,
  0,0,4,0,192,31,32,0,47,0,0,212,6,168,132,25,192,0,0,4,196,25,192,31,0,0,3,192,255,48,0,18,
  36,66,145,16,2,148,3,96,255,20,2,160,3,160,192,132,25,192,241,0,0,48,0,21,31,0,0,196,25,192,241,0,
  0,16,0,18,60,2,148,0,0,10,0,0,9,0,0,11,0,0,11,0,0,11,0,0,11,30,0,0,3,64,192,48,
  0,20,120,66,144,132,26,192,241,0,0,0,0,20,112,2,144,1,0,192,31,0,0,172,2,160,132,26,192,241,0,0,
  196,26,192,0,0,5,144,2,144,193,255,255,19,0,0,4,27,192,0,0,4,164,66,144,243,0,0,132,26,192,63,0,
  0,132,25,192,241,0,0,0,0,15,195,63,192,48,0,18,192,4,168,0,0,11,0,0,11,0,0,11,0,0,11,0,
  0,11,0,128,11,0,128,11,0,128,11,0,128,11,0,128,11,46,0,0,26,0,0,132,26,192,241,0,0,0,0,15,
  195,63,192,48,0,18,29,0,0,16,0,19,0,0,53,32,128,19,0,128,37,4,0,192,31,32,0,47,0,0,10,0,
  0,16,0,19,0,0,53,32,128,19,0,128,37,132,0,192,31,32,0,47,0,0,132,24,192,241,32,0,242,0,0,4,
  0,192,0,32,4,0,128,6,206,255,199,0,128,18,132,24,192,31,32,0,47,0,0,4,25,192,241,32,0,242,0,0,
  132,0,192,0,32,4,0,128,6,206,255,199,0,128,18,4,25,192,31,32,0,47,0,0,68,27,192,241,0,0,16,0,
  18,188,3,148,3,2,192,14,32,192,196,3,160,3,32,192,14,2,192,4,26,192,241,0,0,16,0,18,220,3,148,0,
  0,10,0,0,9,48,32,20,112,4,144,241,0,0,16,0,18,248,3,148,0,0,10,0,0,9,0,32,20,112,4,144,
  196,27,192,241,0,0,4,24,192,31,0,0,4,28,192,241,0,0,16,0,18,64,4,148,195,255,195,48,0,18,68,24,
  192,31,0,0,193,255,255,68,27,192,31,0,0,92,4,160,195,255,195,48,0,18,68,24,192,31,0,0,1,0,192,68,
  27,192,31,0,0,132,27,192,241,0,0,3,2,192,48,0,17,31,0,0,104,0,160,132,0,192,250,64,0,253,64,0,
  16,0,19,0,0,53,32,128,19,253,128,37,19,0,0,46,0,0,16,0,19,0,0,53,32,128,19,0,128,37,4,2,
  192,31,32,0,47,32,0,63,32,0,15,0,0,104,0,160,18,0,0,3,44,192,48,0,21,21,0,0,97,0,0,3,
  60,192,48,128,21,37,0,0,98,0,64,132,0,192,241,0,0,0,0,15,206,63,192,0,0,18,192,4,168,68,0,192,
  26,0,0,253,0,0,19,0,19,42,0,37,46,128,19,0,192,37,10,0,0,253,0,0,58,0,37,0,128,36,4,2,
  192,31,32,0,47,0,0,104,0,160,4,0,192,241,0,0,0,0,2,80,5,148,0,0,10,0,0,9,31,32,0,241,
  0,0,0,0,2,104,5,148,0,0,10,0,0,9,31,64,0,0,0,4,132,69,144,243,32,0,254,64,0,15,32,0,
  63,0,0,1,0,192,2,0,192,4,0,192,10,94,207,253,0,0,0,128,53,0,32,37,138,93,198,253,0,0,0,128,
  53,0,0,39,0,128,12,0,0,12,14,0,224,3,0,192,0,128,21,48,0,23,4,2,192,31,32,0,104,0,160,132,
  4,192,242,0,0,241,0,0,0,128,8,14,8,192,0,128,21,37,0,0,4,0,192,31,0,0,142,0,192,0,0,20,
  104,64,144,241,0,0,14,4,192,0,0,20,104,0,144,3,8,192,2,16,192,52,0,0,241,32,0,44,38,150,0,2,
  0,254,64,0,56,102,150,0,2,0,0,0,20,148,6,144,254,32,0,76,38,150,0,2,0,241,64,0,88,102,150,0,
  2,0,31,32,0,100,38,150,0,2,0,15,0,0,36,0,0,254,32,0,120,38,150,0,2,0,241,64,0,132,102,150,
  0,2,0,31,32,0,144,38,150,0,2,0,15,0,0,49,128,9,0,0,9,19,0,0,80,0,20,28,70,144,81,0,
  0,0,0,8,21,0,0,4,0,192,241,0,0,0,0,8,31,0,0,20,6,145,104,0,160,212,6,168,104,0,160,68,
  0,192,243,0,0,196,0,192,63,0,0,4,0,192,1,0,224,0,32,2,19,0,3,14,0,224,0,0,18,0,0,11,
  14,0,208,0,0,18,48,32,17,31,96,0,241,0,0,0,0,2,36,7,148,0,0,10,0,0,9,31,32,0,241,0,
  0,0,0,2,60,7,148,0,0,10,0,0,9,31,96,0,241,32,0,0,96,4,128,71,144,241,32,0,242,96,0,3,
  8,192,30,0,0,48,0,20,1,0,0,180,71,144,0,0,11,0,128,11,88,135,145,88,135,144,66,0,192,88,7,160,
  241,32,0,242,96,0,3,8,192,46,0,0,48,128,20,2,0,0,180,199,144,0,128,11,0,0,11,140,7,145,140,7,
  144,65,0,192,140,7,160,31,32,0,47,96,0,0,0,2,240,7,145,132,0,192,1,0,208,0,0,2,20,72,145,14,
  0,224,196,0,192,241,0,0,0,0,19,0,0,18,4,2,192,31,0,64,132,0,192,1,0,208,0,0,2,20,72,145,
  4,0,192,243,32,0,254,64,0,15,32,0,63,0,0,4,0,192,241,0,0,0,0,14,0,0,12,14,248,255,0,0,
  18,14,124,192,0,32,21,0,0,5,21,0,0,97,32,0,0,0,1,14,0,224,0,0,19,4,2,192,31,0,64,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  128,3,37,3,218,2,156,2,104,2,59,2,21,2,243,1,213,1,187,1,163,1,142,1,123,1,106,1,90,1,75,1,
  62,1,50,1,38,1,28,1,18,1,9,1,0,1,248,0,240,0,233,0,227,0,220,0,214,0,209,0,203,0,198,0,
  193,0,189,0,184,0,180,0,176,0,172,0,168,0,165,0,162,0,158,0,155,0,152,0,149,0,147,0,144,0,141,0,
  139,0,136,0,134,0,132,0,130,0,128,0,126,0,124,0,122,0,120,0,118,0,116,0,115,0,113,0,111,0,110,0,
  108,0,107,0,105,0,104,0,103,0,101,0,100,0,99,0,98,0,96,0,95,0,94,0,93,0,92,0,91,0,90,0,
  89,0,88,0,87,0,86,0,85,0,84,0,83,0,82,0,81,0,81,0,80,0,79,0,78,0,77,0,77,0,76,0,
  75,0,75,0,74,0,73,0,72,0,72,0,71,0,71,0,70,0,69,0,69,0,68,0,68,0,67,0,66,0,66,0,
  65,0,65,0,64,0,64,0,63,0,63,0,62,0,62,0,61,0,61,0,60,0,60,0,59,0,59,0,58,0,58,0,
  58,0,57,0,57,0,56,0,56,0,56,0,55,0,55,0,54,0,54,0,54,0,53,0,53,0,53,0,52,0,52,0,
  52,0,51,0,51,0,51,0,50,0,50,0,50,0,49,0,49,0,49,0,48,0,48,0,48,0,48,0,47,0,47,0,
  47,0,46,0,46,0,46,0,46,0,45,0,45,0,45,0,45,0,44,0,44,0,44,0,44,0,43,0,43,0,43,0,
  0,0,36,3,72,6,106,9,140,12,171,15,200,18,226,21,249,24,11,28,26,31,35,34,40,37,38,40,31,43,17,46,
  251,48,223,51,186,54,140,57,86,60,23,63,206,65,122,68,28,71,180,73,63,76,191,78,51,81,155,83,245,85,66,88,
  130,90,179,92,215,94,235,96,241,98,232,100,207,102,166,104,109,106,35,108,201,109,94,111,226,112,84,114,181,115,4,117,
  65,118,107,119,132,120,137,121,124,122,92,123,41,124,227,124,137,125,29,126,156,126,9,127,97,127,166,127,216,127,245,127,
  255,127,245,127,216,127,166,127,97,127,9,127,156,126,29,126,137,125,227,124,41,124,92,123,124,122,137,121,132,120,107,119,
  65,118,4,117,181,115,84,114,226,112,94,111,201,109,35,108,109,106,166,104,207,102,232,100,241,98,235,96,215,94,179,92,
  130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,28,71,122,68,206,65,23,63,86,60,140,57,186,54,223,51,
  251,48,17,46,31,43,38,40,40,37,35,34,26,31,11,28,248,24,226,21,200,18,171,15,140,12,106,9,72,6,36,3,
  0,0,220,252,184,249,149,246,116,243,85,240,56,237,30,234,7,231,245,227,230,224,221,221,216,218,218,215,225,212,239,209,
  5,207,33,204,70,201,115,198,170,195,233,192,50,190,134,187,228,184,76,182,193,179,65,177,205,174,101,172,11,170,190,167,
  126,165,77,163,41,161,20,159,15,157,24,155,49,153,90,151,147,149,221,147,55,146,162,144,30,143,172,141,75,140,252,138,
  191,137,149,136,124,135,119,134,132,133,164,132,215,131,29,131,119,130,227,129,100,129,247,128,159,128,90,128,40,128,11,128,
  1,128,11,128,40,128,90,128,159,128,247,128,100,129,227,129,119,130,29,131,215,131,164,132,132,133,119,134,125,135,149,136,
  191,137,252,138,75,140,172,141,30,143,162,144,55,146,221,147,147,149,90,151,49,153,24,155,15,157,21,159,41,161,77,163,
  126,165,190,167,11,170,102,172,205,174,65,177,193,179,77,182,228,184,134,187,51,190,233,192,170,195,116,198,71,201,34,204,
  5,207,240,209,225,212,218,215,217,218,221,221,231,224,245,227,8,231,30,234,56,237,85,240,117,243,150,246,185,249,220,252,
  0,0,36,3,72,6,106,9,140,12,171,15,200,18,226,21,249,24,11,28,26,31,35,34,40,37,38,40,31,43,17,46,
  251,48,223,51,186,54,140,57,86,60,23,63,206,65,122,68,28,71,180,73,63,76,191,78,51,81,155,83,245,85,66,88,
  130,90,179,92,215,94,235,96,241,98,232,100,207,102,166,104,109,106,35,108,201,109,94,111,226,112,84,114,181,115,4,117,
  65,118,107,119,132,120,137,121,124,122,92,123,41,124,227,124,137,125,29,126,156,126,9,127,97,127,166,127,216,127,245,127,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,64,0,32,0,19,0,13,0,10,0,8,0,7,0,6,0,5,0,5,0,4,0,4,0,3,0,3,0,3,0,3,
  0,3,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,1,0,1,0,1,
  0,64,0,45,0,32,0,24,0,19,0,16,0,13,0,11,0,10,0,9,0,8,0,7,0,7,0,6,0,6,0,5,
  0,5,0,5,0,5,0,4,0,4,0,4,0,4,0,4,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,
  0,64,0,51,0,40,0,32,0,26,0,22,0,19,0,16,0,15,0,13,0,12,0,11,0,10,0,9,0,9,0,8,
  0,8,0,7,0,7,0,6,0,6,0,6,0,6,0,5,0,5,0,5,0,5,0,5,0,4,0,4,0,4,0,4,
  0,64,0,54,0,45,0,38,0,32,0,27,0,24,0,21,0,19,0,17,0,16,0,14,0,13,0,12,0,11,0,11,
  0,10,0,9,0,9,0,8,0,8,0,8,0,7,0,7,0,7,0,6,0,6,0,6,0,6,0,6,0,5,0,5,
  0,64,0,56,0,48,0,42,0,37,0,32,0,28,0,25,0,23,0,21,0,19,0,17,0,16,0,15,0,14,0,13,
  0,12,0,12,0,11,0,10,0,10,0,10,0,9,0,9,0,8,0,8,0,8,0,7,0,7,0,7,0,7,0,7,
  0,64,0,57,0,51,0,45,0,40,0,36,0,32,0,29,0,26,0,24,0,22,0,20,0,19,0,18,0,16,0,16,
  0,15,0,14,0,13,0,12,0,12,0,11,0,11,0,10,0,10,0,10,0,9,0,9,0,9,0,8,0,8,0,8,
  0,64,0,58,0,53,0,48,0,43,0,39,0,35,0,32,0,29,0,27,0,25,0,23,0,22,0,20,0,19,0,18,
  0,17,0,16,0,15,0,14,0,14,0,13,0,13,0,12,0,12,0,11,0,11,0,10,0,10,0,10,0,9,0,9,
  0,64,0,59,0,54,0,49,0,45,0,41,0,38,0,35,0,32,0,30,0,27,0,26,0,24,0,22,0,21,0,20,
  0,19,0,18,0,17,0,16,0,16,0,15,0,14,0,14,0,13,0,13,0,12,0,12,0,11,0,11,0,11,0,10,
  0,64,0,59,0,55,0,51,0,47,0,43,0,40,0,37,0,34,0,32,0,30,0,28,0,26,0,25,0,23,0,22,
  0,21,0,20,0,19,0,18,0,17,0,16,0,16,0,15,0,15,0,14,0,14,0,13,0,13,0,12,0,12,0,12,
  0,64,0,60,0,56,0,52,0,48,0,45,0,42,0,39,0,37,0,32,0,32,0,30,0,28,0,27,0,25,0,24,
  0,23,0,22,0,21,0,20,0,19,0,18,0,17,0,17,0,16,0,16,0,15,0,14,0,14,0,14,0,13,0,13,
  0,64,0,60,0,57,0,53,0,50,0,47,0,44,0,41,0,38,0,36,0,34,0,32,0,30,0,29,0,27,0,26,
  0,25,0,23,0,22,0,21,0,20,0,20,0,19,0,18,0,18,0,17,0,16,0,16,0,15,0,15,0,14,0,14,
  0,64,0,61,0,57,0,54,0,51,0,48,0,45,0,42,0,40,0,38,0,36,0,34,0,32,0,30,0,29,0,27,
  0,26,0,25,0,24,0,23,0,22,0,21,0,20,0,20,0,19,0,18,0,18,0,17,0,16,0,16,0,16,0,15,
  0,64,0,61,0,58,0,55,0,52,0,49,0,46,0,44,0,42,0,39,0,37,0,35,0,34,0,32,0,30,0,29,
  0,28,0,27,0,25,0,24,0,23,0,23,0,22,0,21,0,20,0,20,0,19,0,18,0,18,0,17,0,17,0,16,
  0,64,0,61,0,58,0,55,0,53,0,50,0,48,0,45,0,43,0,41,0,39,0,37,0,35,0,34,0,32,0,31,
  0,29,0,28,0,27,0,26,0,25,0,24,0,23,0,22,0,22,0,21,0,20,0,19,0,19,0,18,0,18,0,17,
  0,64,0,61,0,59,0,56,0,53,0,51,0,48,0,46,0,44,0,42,0,40,0,38,0,37,0,35,0,33,0,32,
  0,31,0,29,0,28,0,27,0,26,0,25,0,24,0,24,0,23,0,22,0,21,0,21,0,20,0,19,0,19,0,18,
  0,64,0,61,0,59,0,56,0,54,0,52,0,49,0,47,0,45,0,43,0,41,0,39,0,38,0,36,0,35,0,33,
  0,32,0,31,0,30,0,29,0,27,0,27,0,26,0,25,0,24,0,23,0,22,0,22,0,21,0,21,0,20,0,19,
  0,64,0,62,0,59,0,57,0,55,0,52,0,50,0,48,0,46,0,44,0,42,0,41,0,39,0,37,0,36,0,35,
  0,33,0,32,0,31,0,30,0,29,0,28,0,27,0,26,0,25,0,24,0,24,0,23,0,22,0,22,0,21,0,20,
  0,64,0,62,0,59,0,57,0,55,0,53,0,51,0,49,0,47,0,45,0,43,0,42,0,40,0,39,0,37,0,36,
  0,34,0,33,0,32,0,31,0,30,0,29,0,28,0,27,0,26,0,25,0,25,0,24,0,23,0,23,0,22,0,21,
  0,64,0,62,0,60,0,58,0,56,0,54,0,52,0,50,0,48,0,46,0,44,0,43,0,41,0,40,0,38,0,37,
  0,35,0,34,0,33,0,32,0,31,0,30,0,29,0,28,0,27,0,26,0,26,0,25,0,24,0,24,0,23,0,22,
  0,64,0,62,0,60,0,58,0,56,0,54,0,52,0,50,0,48,0,47,0,45,0,44,0,42,0,41,0,39,0,38,
  0,37,0,35,0,34,0,33,0,32,0,31,0,30,0,29,0,28,0,27,0,27,0,26,0,25,0,25,0,24,0,23,
  0,64,0,62,0,60,0,58,0,56,0,54,0,53,0,51,0,49,0,48,0,46,0,44,0,43,0,41,0,40,0,39,
  0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,29,0,28,0,28,0,27,0,26,0,26,0,25,0,24,
  0,64,0,62,0,60,0,58,0,57,0,55,0,53,0,51,0,50,0,48,0,47,0,45,0,44,0,42,0,41,0,40,
  0,38,0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,29,0,29,0,28,0,27,0,26,0,26,0,25,
  0,64,0,62,0,60,0,59,0,57,0,55,0,54,0,52,0,50,0,49,0,47,0,46,0,44,0,43,0,42,0,40,
  0,39,0,38,0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,30,0,29,0,28,0,27,0,27,0,26,
  0,64,0,62,0,61,0,59,0,57,0,56,0,54,0,52,0,51,0,49,0,48,0,46,0,45,0,44,0,42,0,41,
  0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,30,0,29,0,28,0,27,0,27,
  0,64,0,62,0,61,0,59,0,58,0,56,0,54,0,53,0,51,0,50,0,48,0,47,0,46,0,44,0,43,0,42,
  0,41,0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,30,0,29,0,28,0,28,
  0,64,0,62,0,61,0,59,0,58,0,56,0,55,0,53,0,52,0,50,0,49,0,48,0,46,0,45,0,44,0,43,
  0,42,0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,34,0,33,0,32,0,31,0,30,0,30,0,29,0,28,
  0,64,0,62,0,61,0,59,0,58,0,57,0,55,0,54,0,52,0,51,0,50,0,48,0,47,0,46,0,45,0,43,
  0,42,0,41,0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,34,0,33,0,32,0,31,0,31,0,30,0,29,
  0,64,0,63,0,61,0,60,0,58,0,57,0,55,0,54,0,53,0,51,0,50,0,49,0,48,0,46,0,45,0,44,
  0,43,0,42,0,41,0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,34,0,33,0,32,0,31,0,31,0,30,
  0,64,0,63,0,61,0,60,0,58,0,57,0,56,0,54,0,53,0,52,0,50,0,49,0,48,0,47,0,46,0,45,
  0,43,0,42,0,41,0,40,0,39,0,38,0,38,0,37,0,36,0,35,0,34,0,33,0,33,0,32,0,31,0,31,
  0,64,0,63,0,61,0,60,0,59,0,57,0,56,0,55,0,53,0,52,0,51,0,50,0,48,0,47,0,46,0,45,
  0,44,0,43,0,42,0,41,0,40,0,39,0,38,0,37,0,37,0,36,0,35,0,34,0,33,0,33,0,32,0,31,
  0,64,0,63,0,61,0,60,0,59,0,57,0,56,0,55,0,53,0,52,0,51,0,50,0,49,0,48,0,47,0,46,
  0,45,0,44,0,43,0,42,0,41,0,40,0,39,0,38,0,37,0,36,0,36,0,35,0,34,0,33,0,33,0,32,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char ST011[53248] = {
  6,0,192,7,0,241,8,192,151,7,0,193,145,0,0,2,4,192,32,0,20,52,64,144,145,0,0,2,60,192,32,0,
  20,80,0,144,0,0,160,68,37,192,159,0,0,129,86,192,144,0,21,21,0,0,104,0,0,0,0,128,0,0,8,184,
  65,145,0,0,8,56,66,145,0,0,8,228,66,145,0,0,160,0,0,160,4,3,168,0,0,160,164,3,168,0,0,160,
  248,5,168,96,11,168,112,12,168,128,13,168,52,15,168,184,16,168,168,30,168,20,31,168,196,31,168,173,9,168,125,19,
  168,253,20,168,101,28,168,170,3,168,20,31,168,196,31,168,173,9,168,58,8,168,0,32,168,72,58,168,17,55,168,197,
  57,168,118,32,168,178,47,168,146,62,168,86,10,168,168,4,168,0,0,160,118,25,168,78,26,168,0,0,160,94,29,168,
  78,26,168,0,0,160,39,1,168,0,0,160,163,2,168,0,0,160,0,0,160,35,7,168,0,0,160,0,0,160,135,11,
  168,0,0,160,251,18,168,0,0,160,0,0,160,63,43,168,0,0,160,224,3,168,248,5,168,96,11,168,112,12,168,128,
  13,168,52,15,168,184,16,168,168,30,168,20,31,168,196,31,168,173,9,168,125,19,168,253,20,168,101,28,168,170,3,168,
  20,31,168,196,31,168,173,9,168,58,8,168,0,32,168,72,58,168,17,55,168,197,57,168,118,32,168,178,47,168,146,62,
  168,86,10,168,216,5,168,0,0,160,1,0,192,10,192,255,194,63,192,20,128,18,35,128,15,208,128,19,48,128,17,47,
  0,9,2,0,194,16,128,20,192,129,145,1,0,192,194,63,192,20,128,18,35,128,15,208,128,19,48,128,17,0,128,4,
  32,130,145,0,0,9,2,0,194,16,128,20,232,129,145,6,0,192,24,194,151,0,0,160,198,63,192,36,194,151,7,0,
  192,22,0,0,48,194,151,0,0,160,6,0,192,1,0,192,10,192,255,194,63,192,20,128,18,35,128,15,208,128,19,48,
  128,17,0,128,4,180,130,145,0,0,9,2,0,194,16,128,20,68,130,145,1,0,192,2,0,194,195,255,255,20,0,9,
  63,128,8,124,130,145,1,0,192,20,0,9,194,255,255,0,128,4,204,130,145,2,0,194,16,128,20,140,130,145,6,0,
  192,172,194,151,0,0,160,70,0,192,184,194,151,7,0,192,22,0,0,196,194,151,0,0,160,134,0,192,208,194,151,7,
  0,192,22,0,0,220,194,151,0,0,160,7,0,192,1,0,192,2,0,194,21,0,9,102,128,8,248,194,151,124,130,145,
  0,0,160,65,5,192,2,32,192,6,0,192,7,0,233,20,0,9,24,195,151,143,128,8,20,131,145,1,0,192,2,5,
  192,3,224,255,20,0,9,63,128,8,48,131,145,1,224,255,4,5,192,31,0,0,132,7,192,31,0,0,4,10,192,31,
  0,0,132,12,192,31,0,0,4,15,192,31,0,0,132,17,192,31,0,0,4,20,192,31,0,0,132,22,192,31,0,0,
  4,25,192,31,0,0,129,27,192,66,5,192,3,224,255,20,0,9,63,128,8,148,131,145,0,0,64,7,0,192,6,0,
  192,172,195,151,129,0,0,180,195,151,130,0,0,7,0,193,20,0,9,246,128,8,7,0,233,20,0,9,208,195,151,246,
  128,8,204,131,145,0,0,64,65,5,192,69,27,192,20,0,0,242,0,0,32,128,18,44,196,148,4,196,145,2,24,192,
  0,128,3,35,0,0,84,0,0,242,0,0,32,128,18,32,196,145,2,24,192,0,128,3,63,0,0,20,0,0,47,0,
  0,0,1,9,66,16,192,16,128,20,232,131,145,20,0,0,242,0,0,32,128,18,88,196,145,2,24,192,0,128,3,47,
  0,0,65,34,192,69,36,192,194,1,192,20,0,0,250,0,0,84,1,0,253,0,0,223,0,0,20,0,8,239,128,8,
  100,132,145,196,36,192,129,32,192,0,0,4,4,37,192,130,32,192,0,128,4,31,0,0,196,36,192,47,0,64,67,0,
  192,68,38,192,241,0,0,48,0,20,192,4,144,1,0,192,31,0,0,132,38,192,241,0,0,48,0,20,216,4,144,1,
  0,192,31,0,0,196,38,192,241,0,0,48,0,20,240,4,144,1,0,192,31,0,0,1,0,192,196,37,192,250,0,0,
  141,0,192,2,0,192,0,128,53,0,128,11,32,0,21,68,38,192,250,0,0,13,4,192,2,0,192,0,128,53,0,128,
  11,32,0,21,132,38,192,250,0,0,13,252,255,2,0,192,0,128,53,0,128,11,32,0,21,196,38,192,250,0,0,13,
  4,192,2,0,192,0,128,53,0,128,11,32,0,21,68,39,192,0,0,5,4,38,192,250,0,0,77,85,193,2,0,192,
  0,128,37,32,0,21,19,0,0,4,39,192,250,0,0,13,0,240,2,0,192,0,128,37,32,0,21,132,37,192,31,0,
  0,49,0,0,4,39,192,250,0,0,141,255,255,2,0,192,0,128,53,0,128,11,32,0,21,196,37,192,31,0,0,0,
  0,64,168,4,168,2,0,192,132,37,192,0,128,4,47,128,20,196,37,192,0,128,4,47,0,64,129,181,193,184,10,168,
  12,11,168,12,11,168,12,11,168,12,11,168,12,11,168,12,11,168,12,11,168,184,10,168,129,176,193,66,5,192,3,0,
  192,20,0,9,63,128,8,44,134,145,1,204,193,66,5,192,3,0,192,20,0,9,63,128,8,68,134,145,196,36,192,254,
  0,0,10,0,192,66,171,193,0,128,21,36,128,20,2,97,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,20,
  208,0,21,26,0,0,130,171,193,0,128,21,36,128,20,2,97,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,
  20,208,0,21,26,0,0,194,171,193,0,128,21,36,128,20,2,97,192,243,128,21,37,0,0,97,0,0,31,0,0,48,
  0,20,208,0,21,26,0,0,77,6,192,1,0,192,0,0,53,0,0,11,0,0,10,0,0,9,4,38,192,31,0,0,
  10,0,192,194,173,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,20,208,0,
  21,26,0,0,2,174,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,20,208,
  0,21,26,0,0,66,174,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,20,
  208,0,21,26,0,0,66,176,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,
  20,208,0,21,26,0,0,194,176,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,0,0,48,
  0,20,208,0,21,26,0,0,194,178,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,0,0,
  48,0,20,208,0,21,26,0,0,2,179,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,0,
  0,48,0,20,208,0,21,26,0,0,66,179,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,
  0,0,48,0,20,208,0,21,26,0,0,13,10,192,1,0,192,0,0,53,0,0,11,0,0,10,0,0,9,4,38,192,
  0,0,5,31,0,0,4,37,192,254,0,0,10,0,192,194,181,193,0,128,21,36,128,20,2,97,192,243,128,21,37,0,
  0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,130,181,193,0,128,21,36,128,20,2,97,192,243,128,21,37,
  0,0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,66,181,193,0,128,21,36,128,20,2,97,192,243,128,21,
  37,0,0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,77,6,192,1,0,192,0,0,53,0,0,11,4,38,
  192,0,0,5,31,0,0,10,0,192,66,179,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,31,
  0,0,48,0,20,208,0,21,26,0,0,2,179,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,
  31,0,0,48,0,20,208,0,21,26,0,0,194,178,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,
  0,31,0,0,48,0,20,208,0,21,26,0,0,194,176,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,
  0,0,31,0,0,48,0,20,208,0,21,26,0,0,66,176,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,
  97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,66,174,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,
  0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,2,174,193,0,128,21,36,128,20,194,93,192,243,128,21,37,
  0,0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,194,173,193,0,128,21,36,128,20,194,93,192,243,128,21,
  37,0,0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,13,10,192,1,0,192,0,0,53,0,0,11,4,38,
  192,0,0,5,31,0,0,0,0,64,20,0,9,15,0,192,20,0,9,143,0,192,20,0,9,15,1,192,20,0,9,79,
  1,192,20,0,9,79,1,192,20,0,9,79,1,192,20,0,9,79,1,192,20,0,9,79,1,192,20,0,9,15,1,192,
  20,0,9,143,0,192,0,0,64,20,0,9,15,0,192,20,0,9,207,0,192,20,0,9,79,1,192,20,0,9,143,1,
  192,20,0,9,143,1,192,20,0,9,143,1,192,20,0,9,143,1,192,20,0,9,143,1,192,20,0,9,79,1,192,20,
  0,9,207,0,192,0,0,64,65,239,193,66,2,192,67,0,192,20,0,9,63,128,8,108,139,145,1,2,192,66,5,192,
  16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,194,7,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,
  145,66,10,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,194,12,192,16,128,21,36,128,20,2,16,192,0,
  128,4,100,204,145,66,15,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,194,17,192,16,128,21,36,128,20,
  2,16,192,0,128,4,100,204,145,66,20,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,194,22,192,16,128,
  21,36,128,20,2,16,192,0,128,4,100,204,145,66,25,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,66,
  239,193,16,128,21,36,128,20,15,0,192,0,0,8,124,11,148,0,0,64,129,241,193,66,2,192,67,0,192,20,0,9,
  63,128,8,124,140,145,1,2,192,66,5,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,194,7,192,16,128,
  21,36,128,20,2,8,192,0,128,4,116,205,145,66,10,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,194,
  12,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,66,15,192,16,128,21,36,128,20,2,8,192,0,128,4,
  116,205,145,194,17,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,66,20,192,16,128,21,36,128,20,2,8,
  192,0,128,4,116,205,145,194,22,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,66,25,192,16,128,21,36,
  128,20,2,8,192,0,128,4,116,205,145,130,241,193,16,128,21,36,128,20,15,0,192,0,0,8,140,12,148,0,0,64,
  1,105,192,194,32,192,3,0,192,20,0,9,63,128,8,140,141,145,129,39,192,194,32,192,3,0,192,20,0,9,63,128,
  8,164,141,145,196,36,192,241,0,0,16,0,18,52,78,145,67,253,255,14,13,192,13,8,192,56,14,168,172,14,168,195,
  253,255,14,13,192,13,24,192,56,14,168,195,255,255,14,14,192,13,32,192,56,14,168,67,0,192,14,14,192,13,32,192,
  56,14,168,67,2,192,14,13,192,13,24,192,56,14,168,131,2,192,14,14,192,13,16,192,56,14,168,195,2,192,14,13,
  192,13,8,192,56,14,168,0,0,64,196,36,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,68,206,145,2,
  16,192,0,128,2,168,206,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,104,206,145,2,63,192,0,128,2,
  0,128,20,168,142,145,2,105,192,16,128,21,36,128,20,239,0,0,130,39,192,208,128,21,36,128,20,239,0,0,0,0,
  64,131,253,255,14,14,192,196,36,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,192,206,145,2,16,192,0,
  128,2,48,207,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,228,206,145,2,9,192,0,128,4,16,207,145,
  2,63,192,0,128,2,0,128,20,48,143,145,2,105,192,16,128,21,36,128,20,15,16,192,130,39,192,208,128,21,36,128,
  20,15,16,192,0,0,64,4,37,192,241,0,0,16,0,18,184,79,145,195,2,192,14,21,192,13,8,192,188,15,168,48,
  16,168,67,2,192,14,21,192,13,24,192,188,15,168,67,0,192,14,22,192,13,32,192,188,15,168,195,255,255,14,22,192,
  13,32,192,188,15,168,195,253,255,14,21,192,13,24,192,188,15,168,131,253,255,14,22,192,13,16,192,188,15,168,67,253,
  255,14,21,192,13,8,192,188,15,168,0,0,64,4,37,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,200,
  207,145,2,8,192,0,128,2,44,208,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,236,207,145,2,63,192,
  0,128,2,0,128,20,44,144,145,2,105,192,16,128,21,36,128,20,239,0,0,130,39,192,208,128,21,36,128,20,239,0,
  0,0,0,64,131,2,192,14,14,192,4,37,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,68,208,145,2,
  8,192,0,128,2,180,208,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,104,208,145,2,17,192,0,128,4,
  148,208,145,2,63,192,0,128,2,0,128,20,180,144,145,2,105,192,16,128,21,36,128,20,15,16,192,130,39,192,208,128,
  21,36,128,20,15,16,192,0,0,64,65,72,192,194,32,192,3,0,192,20,0,9,63,128,8,196,144,145,193,12,193,194,
  32,192,3,0,192,20,0,9,63,128,8,220,144,145,129,45,193,194,32,192,3,0,192,20,0,9,63,128,8,244,144,145,
  65,5,192,20,0,0,2,0,192,0,128,5,116,209,145,116,209,148,30,0,0,2,105,192,16,128,21,36,128,20,242,0,
  0,0,128,11,0,128,11,0,128,11,0,128,11,0,128,11,67,108,192,48,128,21,37,0,0,106,0,0,20,0,0,130,
  15,192,0,128,2,0,128,11,67,100,192,48,128,21,37,0,0,104,0,0,0,0,128,0,0,9,130,27,192,16,128,20,
  4,145,145,0,0,64,48,0,21,66,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,130,45,193,16,128,
  21,36,128,20,242,0,0,208,128,17,47,0,0,20,0,0,2,0,192,0,128,5,136,209,145,2,15,192,0,128,4,12,
  146,145,48,0,21,66,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,130,45,193,16,128,21,36,128,20,
  242,0,0,208,128,17,47,0,0,1,0,64,48,0,21,66,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,
  0,194,12,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,20,0,0,2,0,192,0,128,5,16,210,145,2,
  23,192,0,128,4,148,146,145,48,0,21,66,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,194,12,193,
  16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,1,0,64,194,69,192,16,128,21,36,128,20,2,32,192,0,128,
  1,47,0,0,2,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,131,253,255,136,17,168,116,
  17,160,2,67,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,40,193,16,128,21,36,128,20,242,0,0,
  208,128,17,47,0,0,130,67,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,40,193,16,128,21,36,128,
  20,242,0,0,208,128,17,47,0,0,116,17,160,130,69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,
  42,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,128,20,2,32,192,0,128,1,
  47,0,0,2,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,20,2,32,
  192,0,128,1,47,0,0,66,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,
  128,20,2,32,192,0,128,1,47,0,0,194,47,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,75,192,
  16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,
  0,116,17,160,130,69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,42,193,16,128,21,36,128,20,242,
  0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,2,43,193,16,128,21,
  36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,43,
  193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,
  0,0,66,45,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,32,192,
  0,128,1,47,0,0,194,45,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,
  20,2,32,192,0,128,1,47,0,0,2,48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,194,
  69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,2,43,193,16,128,21,36,128,20,242,0,0,208,128,17,
  47,0,0,2,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,45,193,16,128,21,36,128,20,242,0,
  0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,45,193,16,128,21,36,
  128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,2,48,193,
  16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,67,253,255,136,17,168,195,253,255,136,17,168,67,2,192,136,17,
  168,195,2,192,136,17,168,116,17,160,130,69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,42,193,16,
  128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,
  66,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,128,20,2,32,192,0,128,
  1,47,0,0,194,47,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,75,192,16,128,21,36,128,20,2,
  32,192,0,128,1,47,0,0,66,48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,131,253,255,136,17,168,
  195,255,255,136,17,168,67,0,192,136,17,168,131,2,192,136,17,168,116,17,160,130,69,192,16,128,21,36,128,20,2,32,
  192,0,128,1,47,0,0,194,42,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,
  128,20,2,32,192,0,128,1,47,0,0,2,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,
  16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,
  0,2,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,45,193,16,128,21,36,128,20,242,0,0,208,
  128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,45,193,16,128,21,36,128,20,
  242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,47,193,16,128,
  21,36,128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,2,
  48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,75,192,16,128,21,36,128,20,2,32,192,0,128,1,
  47,0,0,66,48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,194,74,192,16,128,21,36,128,
  20,2,0,224,0,128,1,47,0,0,66,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,131,
  2,192,16,18,168,116,17,160,130,77,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,18,193,16,128,21,
  36,128,20,242,0,0,208,128,17,47,0,0,2,77,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,17,
  193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,2,75,192,16,128,21,36,128,20,2,0,224,0,
  128,1,47,0,0,130,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,20,
  2,0,224,0,128,1,47,0,0,66,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,
  21,36,128,20,2,0,224,0,128,1,47,0,0,2,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,
  70,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,10,193,16,128,21,36,128,20,242,0,0,208,128,17,
  47,0,0,130,69,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,10,193,16,128,21,36,128,20,242,0,
  0,208,128,17,47,0,0,116,17,160,2,75,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,15,193,16,
  128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,
  66,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,128,20,2,0,224,0,128,
  1,47,0,0,2,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,
  0,224,0,128,1,47,0,0,2,13,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,72,192,16,128,21,
  36,128,20,2,0,224,0,128,1,47,0,0,130,12,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,
  192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,66,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,
  0,0,116,17,160,194,74,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,66,15,193,16,128,21,36,128,20,
  242,0,0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,13,193,16,128,
  21,36,128,20,242,0,0,208,128,17,47,0,0,2,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,
  12,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,128,20,2,0,224,0,128,1,
  47,0,0,66,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,195,2,192,16,18,168,67,2,192,16,18,
  168,195,253,255,16,18,168,67,253,255,16,18,168,116,17,160,2,75,192,16,128,21,36,128,20,2,0,224,0,128,1,47,
  0,0,130,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,128,20,2,0,224,
  0,128,1,47,0,0,2,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,
  20,2,0,224,0,128,1,47,0,0,130,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,69,192,16,
  128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,
  131,2,192,16,18,168,67,0,192,16,18,168,195,255,255,16,18,168,131,253,255,16,18,168,116,17,160,2,75,192,16,128,
  21,36,128,20,2,0,224,0,128,1,47,0,0,130,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,
  74,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,66,15,193,16,128,21,36,128,20,242,0,0,208,128,17,
  47,0,0,130,74,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,15,193,16,128,21,36,128,20,242,0,
  0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,13,193,16,128,21,36,
  128,20,242,0,0,208,128,17,47,0,0,2,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,12,193,
  16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,
  0,130,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,128,20,2,0,224,0,
  128,1,47,0,0,66,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,69,192,16,128,21,36,128,20,
  2,0,224,0,128,1,47,0,0,2,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,193,143,
  193,194,32,192,3,0,192,20,0,9,63,128,8,180,158,145,65,5,192,20,0,0,2,0,192,0,128,5,0,223,145,0,
  223,148,131,7,192,48,128,18,0,128,11,131,109,192,48,128,21,37,0,0,194,143,193,16,128,21,36,128,20,111,0,0,
  0,0,9,130,27,192,16,128,20,196,158,145,0,0,64,68,209,193,15,0,192,132,209,193,15,0,192,78,5,192,4,0,
  0,1,0,192,0,0,5,168,95,145,168,95,148,2,16,192,10,0,192,0,128,2,80,159,145,74,0,192,221,0,0,66,
  209,193,208,128,21,36,128,20,250,0,0,194,143,193,0,128,21,36,128,20,241,0,0,194,143,193,208,128,21,36,128,20,
  0,0,4,80,95,144,66,209,193,0,128,21,36,128,20,223,0,0,66,209,193,224,128,21,36,128,20,15,0,0,1,0,
  0,0,0,9,30,0,0,130,27,192,16,128,20,40,159,145,0,0,64,1,105,192,194,32,192,3,30,222,20,0,9,63,
  128,8,208,159,145,65,78,193,194,32,192,3,0,192,20,0,9,63,128,8,232,159,145,68,209,193,241,0,0,194,143,193,
  16,128,21,36,128,20,250,0,0,130,39,192,16,128,21,36,128,20,242,0,0,35,128,11,0,128,11,0,128,11,0,128,
  11,0,128,11,141,165,192,224,128,21,37,0,0,109,0,0,30,0,0,20,0,0,130,7,192,0,128,2,48,128,17,0,
  128,11,131,113,192,48,128,21,37,0,0,104,0,0,0,0,128,66,209,193,32,0,21,20,0,20,0,0,5,252,31,145,
  0,0,64,128,0,21,2,105,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,66,78,
  193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,20,0,0,2,0,192,0,128,5,133,192,145,73,193,148,9,
  1,160,128,0,21,66,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,20,0,0,2,0,192,0,128,5,
  217,192,145,73,193,148,130,15,192,0,128,2,0,128,11,48,128,21,37,0,0,98,0,0,0,128,8,73,193,148,217,128,
  145,128,0,21,66,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,1,0,64,66,102,192,16,128,21,36,
  128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,130,75,193,16,128,21,36,128,20,66,0,192,0,128,5,
  47,0,64,130,102,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,194,75,193,16,128,
  21,36,128,20,66,0,192,0,128,5,47,0,64,194,102,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,
  128,17,47,0,0,2,76,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,194,104,192,16,128,21,36,128,20,
  194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,
  64,66,105,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,130,78,193,16,128,21,36,
  128,20,66,0,192,0,128,5,47,0,64,66,107,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,
  47,0,0,130,80,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,130,107,192,16,128,21,36,128,20,194,63,
  192,0,128,2,0,128,15,208,128,17,47,0,0,194,80,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,194,
  107,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,81,193,16,128,21,36,128,20,
  66,0,192,0,128,5,47,0,64,2,10,193,16,128,21,36,128,20,242,0,0,224,128,18,61,195,145,130,75,193,16,128,
  21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,66,10,193,16,128,21,36,128,20,242,0,0,224,128,18,113,
  195,145,194,75,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,130,10,193,16,128,21,36,128,20,
  242,0,0,224,128,18,165,195,145,2,76,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,130,12,
  193,16,128,21,36,128,20,242,0,0,224,128,18,217,195,145,2,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,
  0,64,0,0,64,2,13,193,16,128,21,36,128,20,242,0,0,224,128,18,13,196,145,130,78,193,16,128,21,36,128,20,
  66,0,192,0,128,5,47,0,64,0,0,64,2,15,193,16,128,21,36,128,20,242,0,0,224,128,18,65,196,145,130,80,
  193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,66,15,193,16,128,21,36,128,20,242,0,0,224,
  128,18,117,196,145,194,80,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,130,15,193,16,128,21,
  36,128,20,242,0,0,224,128,18,169,196,145,2,81,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,
  64,133,1,168,109,0,160,134,253,255,131,133,192,133,0,168,109,0,160,194,99,192,16,128,21,36,128,20,194,63,192,0,
  128,2,0,128,15,208,128,17,47,0,0,2,73,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,66,100,192,
  16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,130,73,193,16,128,21,36,128,20,66,0,
  192,0,128,5,47,0,0,109,0,160,77,1,168,213,2,168,133,1,168,189,1,168,101,2,168,109,0,160,77,1,168,133,
  1,168,157,2,168,189,1,168,245,1,168,45,2,168,109,0,160,133,1,168,157,2,168,245,1,168,45,2,168,70,253,255,
  131,145,192,133,0,168,198,2,192,131,149,192,133,0,168,198,253,255,131,145,192,133,0,168,70,2,192,131,149,192,133,0,
  168,109,0,160,77,1,168,213,2,168,189,1,168,101,2,168,134,253,255,131,133,192,133,0,168,134,2,192,131,137,192,133,
  0,168,198,255,255,131,157,192,133,0,168,70,0,192,131,157,192,133,0,168,109,0,160,130,75,193,16,128,21,36,128,20,
  66,0,192,0,128,5,47,0,0,194,75,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,2,76,193,16,128,
  21,36,128,20,66,0,192,0,128,5,47,0,0,2,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,130,
  78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,130,80,193,16,128,21,36,128,20,66,0,192,0,128,5,
  47,0,0,194,80,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,2,81,193,16,128,21,36,128,20,66,0,
  192,0,128,5,47,0,0,109,0,160,65,3,168,109,0,160,65,3,168,109,0,160,77,1,168,213,2,168,65,3,168,117,
  3,168,17,4,168,109,0,160,13,3,168,121,4,168,133,1,168,117,3,168,17,4,168,109,0,160,13,3,168,121,4,168,
  65,3,168,189,1,168,101,2,168,109,0,160,13,3,168,121,4,168,65,3,168,117,3,168,17,4,168,77,1,168,65,3,
  168,69,4,168,117,3,168,169,3,168,221,3,168,109,0,160,13,3,168,133,1,168,157,2,168,117,3,168,169,3,168,221,
  3,168,109,0,160,13,3,168,65,3,168,69,4,168,189,1,168,169,3,168,221,3,168,109,0,160,13,3,168,65,3,168,
  69,4,168,117,3,168,245,1,168,45,2,168,109,0,160,70,253,255,131,145,192,133,0,168,198,2,192,131,149,192,133,0,
  168,117,3,168,17,4,168,109,0,160,13,3,168,121,4,168,117,3,168,17,4,168,109,0,160,13,3,168,121,4,168,198,
  253,255,131,145,192,133,0,168,70,2,192,131,149,192,133,0,168,109,0,160,70,253,255,131,145,192,133,0,168,198,2,192,
  131,149,192,133,0,168,65,3,168,69,4,168,117,3,168,17,4,168,169,3,168,221,3,168,109,0,160,13,3,168,121,4,
  168,133,1,168,157,2,168,117,3,168,17,4,168,169,3,168,221,3,168,109,0,160,13,3,168,121,4,168,65,3,168,69,
  4,168,198,253,255,131,145,192,133,0,168,70,2,192,131,149,192,133,0,168,169,3,168,221,3,168,109,0,160,13,3,168,
  121,4,168,65,3,168,69,4,168,117,3,168,17,4,168,245,1,168,45,2,168,109,0,160,65,3,168,69,4,168,169,3,
  168,221,3,168,109,0,160,134,253,255,131,133,192,133,0,168,134,2,192,131,137,192,133,0,168,169,3,168,221,3,168,109,
  0,160,65,3,168,69,4,168,198,255,255,131,157,192,133,0,168,70,0,192,131,157,192,133,0,168,109,0,160,77,1,168,
  213,2,168,65,3,168,69,4,168,117,3,168,17,4,168,169,3,168,221,3,168,109,0,160,13,3,168,121,4,168,134,253,
  255,131,133,192,133,0,168,134,2,192,131,137,192,133,0,168,117,3,168,17,4,168,169,3,168,221,3,168,109,0,160,13,
  3,168,121,4,168,65,3,168,69,4,168,189,1,168,101,2,168,169,3,168,221,3,168,109,0,160,13,3,168,121,4,168,
  65,3,168,69,4,168,117,3,168,17,4,168,198,255,255,131,157,192,133,0,168,70,0,192,131,157,192,133,0,168,109,0,
  160,193,137,192,194,32,192,3,30,222,20,0,9,63,128,8,185,137,145,132,209,193,241,0,0,194,143,193,16,128,21,36,
  128,20,250,0,0,130,39,192,16,128,21,36,128,20,242,0,0,35,128,11,0,128,11,0,128,11,0,128,11,0,128,11,
  205,186,192,224,128,21,37,0,0,109,0,0,30,0,0,20,0,0,130,7,192,0,128,2,48,128,17,0,128,11,195,166,
  192,48,128,21,37,0,0,104,0,0,0,0,128,66,209,193,32,0,21,20,0,20,0,0,5,205,9,145,0,0,64,128,
  0,21,194,137,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,66,78,193,16,128,21,
  36,128,20,2,64,192,0,128,5,47,0,0,20,0,0,2,0,192,0,128,5,85,202,145,25,203,148,217,10,160,128,0,
  21,66,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,20,0,0,2,0,192,0,128,5,169,202,145,25,
  203,148,130,15,192,0,128,2,0,128,11,48,128,21,37,0,0,98,0,0,0,128,8,25,203,148,169,138,145,128,0,21,
  66,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,1,0,64,130,140,192,16,128,21,36,128,20,194,63,
  192,0,128,2,0,128,15,208,128,17,47,0,0,2,81,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,66,
  140,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,194,80,193,16,128,21,36,128,20,
  2,64,192,0,128,5,47,0,64,2,140,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,
  0,130,80,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,2,138,192,16,128,21,36,128,20,194,63,192,0,
  128,2,0,128,15,208,128,17,47,0,0,130,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,130,137,192,
  16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,78,193,16,128,21,36,128,20,2,64,
  192,0,128,5,47,0,64,130,135,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,
  76,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,66,135,192,16,128,21,36,128,20,194,63,192,0,128,2,
  0,128,15,208,128,17,47,0,0,194,75,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,2,135,192,16,128,
  21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,130,75,193,16,128,21,36,128,20,2,64,192,0,
  128,5,47,0,64,66,48,193,16,128,21,36,128,20,242,0,0,224,128,18,13,205,145,2,81,193,16,128,21,36,128,20,
  2,64,192,0,128,5,47,0,64,0,0,64,2,48,193,16,128,21,36,128,20,242,0,0,224,128,18,65,205,145,194,80,
  193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,194,47,193,16,128,21,36,128,20,242,0,0,224,
  128,18,117,205,145,130,80,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,194,45,193,16,128,21,
  36,128,20,242,0,0,224,128,18,169,205,145,130,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,
  64,66,45,193,16,128,21,36,128,20,242,0,0,224,128,18,221,205,145,2,78,193,16,128,21,36,128,20,2,64,192,0,
  128,5,47,0,64,0,0,64,66,43,193,16,128,21,36,128,20,242,0,0,224,128,18,17,206,145,2,76,193,16,128,21,
  36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,2,43,193,16,128,21,36,128,20,242,0,0,224,128,18,69,206,
  145,194,75,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,194,42,193,16,128,21,36,128,20,242,
  0,0,224,128,18,121,206,145,130,75,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,85,11,168,
  61,10,160,134,2,192,131,137,192,85,10,168,61,10,160,2,143,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,
  15,208,128,17,47,0,0,130,83,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,130,142,192,16,128,21,36,
  128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,83,193,16,128,21,36,128,20,2,64,192,0,128,5,
  47,0,0,61,10,160,29,11,168,165,12,168,85,11,168,141,11,168,53,12,168,61,10,160,29,11,168,85,11,168,109,12,
  168,141,11,168,197,11,168,253,11,168,61,10,160,85,11,168,109,12,168,197,11,168,253,11,168,198,2,192,131,149,192,85,
  10,168,70,253,255,131,145,192,85,10,168,70,2,192,131,149,192,85,10,168,198,253,255,131,145,192,85,10,168,61,10,160,
  29,11,168,165,12,168,141,11,168,53,12,168,134,2,192,131,137,192,85,10,168,134,253,255,131,133,192,85,10,168,70,0,
  192,131,157,192,85,10,168,198,255,255,131,157,192,85,10,168,61,10,160,2,81,193,16,128,21,36,128,20,2,64,192,0,
  128,5,47,0,0,194,80,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,130,80,193,16,128,21,36,128,20,
  2,64,192,0,128,5,47,0,0,130,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,2,78,193,16,128,
  21,36,128,20,2,64,192,0,128,5,47,0,0,2,76,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,194,
  75,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,130,75,193,16,128,21,36,128,20,2,64,192,0,128,5,
  47,0,0,61,10,160,17,13,168,61,10,160,17,13,168,61,10,160,29,11,168,165,12,168,17,13,168,69,13,168,225,13,
  168,61,10,160,221,12,168,73,14,168,85,11,168,69,13,168,225,13,168,61,10,160,221,12,168,73,14,168,17,13,168,141,
  11,168,53,12,168,61,10,160,221,12,168,73,14,168,17,13,168,69,13,168,225,13,168,29,11,168,17,13,168,21,14,168,
  69,13,168,121,13,168,173,13,168,61,10,160,221,12,168,85,11,168,109,12,168,69,13,168,121,13,168,173,13,168,61,10,
  160,221,12,168,17,13,168,21,14,168,141,11,168,121,13,168,173,13,168,61,10,160,221,12,168,17,13,168,21,14,168,69,
  13,168,197,11,168,253,11,168,61,10,160,198,2,192,131,149,192,85,10,168,70,253,255,131,145,192,85,10,168,69,13,168,
  225,13,168,61,10,160,221,12,168,73,14,168,69,13,168,225,13,168,61,10,160,221,12,168,73,14,168,70,2,192,131,149,
  192,85,10,168,198,253,255,131,145,192,85,10,168,61,10,160,198,2,192,131,149,192,85,10,168,70,253,255,131,145,192,85,
  10,168,17,13,168,21,14,168,69,13,168,225,13,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,85,11,168,
  109,12,168,69,13,168,225,13,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,17,13,168,21,14,168,70,2,
  192,131,149,192,85,10,168,198,253,255,131,145,192,85,10,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,17,
  13,168,21,14,168,69,13,168,225,13,168,197,11,168,253,11,168,61,10,160,17,13,168,21,14,168,121,13,168,173,13,168,
  61,10,160,134,2,192,131,137,192,85,10,168,134,253,255,131,133,192,85,10,168,121,13,168,173,13,168,61,10,160,17,13,
  168,21,14,168,70,0,192,131,157,192,85,10,168,198,255,255,131,157,192,85,10,168,61,10,160,29,11,168,165,12,168,17,
  13,168,21,14,168,69,13,168,225,13,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,134,2,192,131,137,192,
  85,10,168,134,253,255,131,133,192,85,10,168,69,13,168,225,13,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,
  168,17,13,168,21,14,168,141,11,168,53,12,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,17,13,168,21,
  14,168,69,13,168,225,13,168,70,0,192,131,157,192,85,10,168,198,255,255,131,157,192,85,10,168,61,10,160,65,5,192,
  20,0,0,2,0,192,0,128,5,233,212,148,30,0,0,2,105,192,16,128,21,36,128,20,194,63,192,0,128,2,42,128,
  3,0,128,15,132,244,193,47,0,0,194,137,192,16,128,21,36,128,20,194,63,192,0,128,2,45,128,3,0,128,15,196,
  244,193,47,0,0,66,78,193,16,128,21,36,128,20,194,63,192,0,128,2,38,128,3,0,128,15,35,0,0,20,0,0,
  241,0,0,0,0,15,0,0,12,130,0,12,0,128,12,38,0,0,50,0,12,0,128,12,35,0,0,129,0,0,32,0,
  20,93,84,144,133,84,145,65,255,255,48,0,21,85,20,144,209,0,0,196,244,193,0,0,4,26,0,0,201,20,144,10,
  0,192,201,20,160,65,255,255,128,0,21,125,20,144,225,0,0,132,244,193,0,0,4,29,0,0,201,20,144,13,0,192,
  201,20,160,209,0,0,196,244,193,0,0,4,26,0,0,157,20,144,10,0,192,225,0,0,132,244,193,0,0,4,29,0,
  0,181,20,144,13,0,192,65,255,255,208,0,21,201,84,144,10,0,192,13,0,192,1,0,0,2,236,192,16,128,21,36,
  128,20,226,0,0,0,128,15,208,128,17,47,0,0,0,0,9,130,27,192,16,128,20,129,147,145,0,0,64,129,170,192,
  194,32,192,3,0,192,20,0,9,63,128,8,9,149,145,68,209,193,241,0,0,30,0,0,130,170,192,16,128,21,36,128,
  20,250,0,0,194,143,193,16,128,21,36,128,20,253,0,0,130,39,192,16,128,21,36,128,20,243,0,0,20,0,0,130,
  7,192,0,128,2,48,128,17,0,128,11,3,188,192,48,128,21,37,0,0,104,0,0,0,0,128,130,170,192,16,128,21,
  36,128,20,223,0,0,66,209,193,32,0,21,20,0,20,0,0,5,29,21,145,0,0,64,32,0,21,20,0,0,2,0,
  192,0,128,5,29,214,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,20,0,0,2,16,192,0,
  128,2,29,150,145,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,16,128,21,36,128,20,2,192,255,0,128,2,
  0,128,15,48,128,21,224,128,20,29,214,144,130,0,192,208,128,21,42,0,0,1,0,64,32,0,21,20,0,0,2,0,
  192,0,128,5,77,214,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,1,0,64,173,22,160,130,
  176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,
  16,128,21,36,128,20,2,192,255,0,128,2,0,128,15,48,128,21,224,128,20,173,214,144,130,0,192,208,128,21,42,0,
  0,128,0,21,20,0,0,2,0,192,0,128,5,85,214,145,45,215,148,130,176,193,16,128,21,36,128,20,242,0,0,208,
  128,21,42,0,0,20,0,0,2,16,192,0,128,2,45,151,145,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,
  16,128,21,36,128,20,2,192,255,0,128,2,0,128,15,48,128,21,224,128,20,45,215,144,130,0,192,208,128,21,42,0,
  0,1,0,64,77,23,160,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,128,0,21,20,0,0,2,
  0,192,0,128,5,53,215,145,125,215,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,1,0,64,
  130,253,255,161,21,168,121,21,160,134,253,255,81,22,168,121,21,160,194,250,255,161,21,168,66,251,255,161,21,168,121,21,
  160,66,253,255,161,21,168,130,253,255,161,21,168,194,253,255,161,21,168,66,2,192,161,21,168,194,2,192,161,21,168,121,
  21,160,66,253,255,161,21,168,130,253,255,161,21,168,194,253,255,161,21,168,194,255,255,161,21,168,66,0,192,161,21,168,
  130,2,192,161,21,168,121,21,160,130,253,255,161,21,168,194,255,255,161,21,168,66,0,192,161,21,168,130,2,192,161,21,
  168,70,253,255,81,22,168,198,253,255,81,22,168,70,2,192,81,22,168,198,2,192,81,22,168,121,21,160,66,253,255,161,
  21,168,194,253,255,161,21,168,66,2,192,161,21,168,194,2,192,161,21,168,134,253,255,81,22,168,198,255,255,81,22,168,
  70,0,192,81,22,168,134,2,192,81,22,168,121,21,160,121,21,160,130,253,255,33,22,168,121,21,160,134,253,255,49,23,
  168,121,21,160,194,250,255,33,22,168,66,251,255,33,22,168,121,21,160,66,253,255,161,21,168,130,253,255,33,22,168,194,
  253,255,33,22,168,66,2,192,33,22,168,194,2,192,161,21,168,121,21,160,66,253,255,33,22,168,130,253,255,161,21,168,
  194,253,255,33,22,168,66,2,192,33,22,168,194,2,192,33,22,168,121,21,160,66,253,255,33,22,168,130,253,255,33,22,
  168,194,253,255,161,21,168,66,2,192,161,21,168,194,2,192,33,22,168,121,21,160,66,253,255,33,22,168,130,253,255,33,
  22,168,194,253,255,33,22,168,66,2,192,33,22,168,194,2,192,33,22,168,121,21,160,66,253,255,161,21,168,130,253,255,
  33,22,168,194,253,255,33,22,168,194,255,255,33,22,168,66,0,192,33,22,168,130,2,192,33,22,168,121,21,160,66,253,
  255,33,22,168,130,253,255,161,21,168,194,253,255,33,22,168,194,255,255,33,22,168,66,0,192,33,22,168,130,2,192,161,
  21,168,121,21,160,66,253,255,33,22,168,130,253,255,33,22,168,194,253,255,161,21,168,194,255,255,33,22,168,66,0,192,
  33,22,168,130,2,192,33,22,168,121,21,160,66,253,255,33,22,168,130,253,255,33,22,168,194,253,255,33,22,168,194,255,
  255,161,21,168,66,0,192,161,21,168,130,2,192,33,22,168,121,21,160,130,253,255,33,22,168,194,255,255,33,22,168,66,
  0,192,33,22,168,130,2,192,33,22,168,70,253,255,81,22,168,198,253,255,49,23,168,70,2,192,49,23,168,198,2,192,
  81,22,168,121,21,160,130,253,255,161,21,168,194,255,255,33,22,168,66,0,192,33,22,168,130,2,192,161,21,168,70,253,
  255,49,23,168,198,253,255,49,23,168,70,2,192,49,23,168,198,2,192,49,23,168,121,21,160,130,253,255,33,22,168,194,
  255,255,33,22,168,66,0,192,33,22,168,130,2,192,33,22,168,70,253,255,49,23,168,198,253,255,81,22,168,70,2,192,
  81,22,168,198,2,192,49,23,168,121,21,160,130,253,255,33,22,168,194,255,255,161,21,168,66,0,192,161,21,168,130,2,
  192,33,22,168,70,253,255,49,23,168,198,253,255,49,23,168,70,2,192,49,23,168,198,2,192,49,23,168,121,21,160,66,
  253,255,161,21,168,194,253,255,33,22,168,66,2,192,33,22,168,194,2,192,161,21,168,134,253,255,49,23,168,198,255,255,
  49,23,168,70,0,192,49,23,168,134,2,192,49,23,168,121,21,160,66,253,255,33,22,168,194,253,255,33,22,168,66,2,
  192,33,22,168,194,2,192,33,22,168,134,253,255,81,22,168,198,255,255,49,23,168,70,0,192,49,23,168,134,2,192,81,
  22,168,121,21,160,66,253,255,33,22,168,194,253,255,161,21,168,66,2,192,161,21,168,194,2,192,33,22,168,134,253,255,
  49,23,168,198,255,255,49,23,168,70,0,192,49,23,168,134,2,192,49,23,168,121,21,160,66,253,255,33,22,168,194,253,
  255,33,22,168,66,2,192,33,22,168,194,2,192,33,22,168,134,253,255,49,23,168,198,255,255,81,22,168,70,0,192,81,
  22,168,134,2,192,49,23,168,121,21,160,132,209,193,241,0,0,30,0,0,130,170,192,16,128,21,36,128,20,250,0,0,
  194,143,193,16,128,21,36,128,20,253,0,0,130,39,192,16,128,21,36,128,20,243,0,0,20,0,0,130,7,192,0,128,
  2,48,128,17,0,128,11,3,208,192,48,128,21,37,0,0,104,0,0,0,0,128,130,170,192,16,128,21,36,128,20,223,
  0,0,66,209,193,32,0,21,20,0,20,0,0,5,109,28,145,0,0,64,32,0,21,20,0,0,2,0,192,0,128,5,
  105,221,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,20,0,0,2,8,192,0,128,2,105,157,
  145,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,16,128,21,36,128,20,194,63,192,0,128,2,48,128,21,224,
  128,20,105,221,144,130,0,192,208,128,21,42,0,0,1,0,64,32,0,21,20,0,0,2,0,192,0,128,5,153,221,148,
  130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,1,0,64,245,29,160,130,176,193,16,128,21,36,128,
  20,242,0,0,208,128,21,42,0,0,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,16,128,21,36,128,20,194,
  63,192,0,128,2,48,128,21,224,128,20,245,221,144,130,0,192,208,128,21,42,0,0,128,0,21,20,0,0,2,0,192,
  0,128,5,161,221,145,113,222,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,20,0,0,2,8,
  192,0,128,2,113,158,145,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,16,128,21,36,128,20,194,63,192,0,
  128,2,48,128,21,224,128,20,113,222,144,130,0,192,208,128,21,42,0,0,1,0,64,145,30,160,130,176,193,16,128,21,
  36,128,20,242,0,0,208,128,21,42,0,0,128,0,21,20,0,0,2,0,192,0,128,5,121,222,145,193,222,148,130,176,
  193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,1,0,64,130,2,192,241,28,168,201,28,160,134,2,192,157,
  29,168,201,28,160,66,5,192,241,28,168,194,4,192,241,28,168,201,28,160,194,2,192,241,28,168,130,2,192,241,28,168,
  66,2,192,241,28,168,194,253,255,241,28,168,66,253,255,241,28,168,201,28,160,194,2,192,241,28,168,130,2,192,241,28,
  168,66,2,192,241,28,168,66,0,192,241,28,168,194,255,255,241,28,168,130,253,255,241,28,168,201,28,160,130,2,192,241,
  28,168,66,0,192,241,28,168,194,255,255,241,28,168,130,253,255,241,28,168,198,2,192,157,29,168,70,2,192,157,29,168,
  198,253,255,157,29,168,70,253,255,157,29,168,201,28,160,194,2,192,241,28,168,66,2,192,241,28,168,194,253,255,241,28,
  168,66,253,255,241,28,168,134,2,192,157,29,168,70,0,192,157,29,168,198,255,255,157,29,168,134,253,255,157,29,168,201,
  28,160,201,28,160,130,2,192,109,29,168,201,28,160,134,2,192,117,30,168,201,28,160,66,5,192,109,29,168,194,4,192,
  109,29,168,201,28,160,194,2,192,241,28,168,130,2,192,109,29,168,66,2,192,109,29,168,194,253,255,109,29,168,66,253,
  255,241,28,168,201,28,160,194,2,192,109,29,168,130,2,192,241,28,168,66,2,192,109,29,168,194,253,255,109,29,168,66,
  253,255,109,29,168,201,28,160,194,2,192,109,29,168,130,2,192,109,29,168,66,2,192,241,28,168,194,253,255,241,28,168,
  66,253,255,109,29,168,201,28,160,194,2,192,109,29,168,130,2,192,109,29,168,66,2,192,109,29,168,194,253,255,109,29,
  168,66,253,255,109,29,168,201,28,160,194,2,192,241,28,168,130,2,192,109,29,168,66,2,192,109,29,168,66,0,192,109,
  29,168,194,255,255,109,29,168,130,253,255,109,29,168,201,28,160,194,2,192,109,29,168,130,2,192,241,28,168,66,2,192,
  109,29,168,66,0,192,109,29,168,194,255,255,109,29,168,130,253,255,241,28,168,201,28,160,194,2,192,109,29,168,130,2,
  192,109,29,168,66,2,192,241,28,168,66,0,192,109,29,168,194,255,255,109,29,168,130,253,255,109,29,168,201,28,160,194,
  2,192,109,29,168,130,2,192,109,29,168,66,2,192,109,29,168,66,0,192,241,28,168,194,255,255,241,28,168,130,253,255,
  109,29,168,201,28,160,130,2,192,109,29,168,66,0,192,109,29,168,194,255,255,109,29,168,130,253,255,109,29,168,198,2,
  192,157,29,168,70,2,192,117,30,168,198,253,255,117,30,168,70,253,255,157,29,168,201,28,160,130,2,192,241,28,168,66,
  0,192,109,29,168,194,255,255,109,29,168,130,253,255,241,28,168,198,2,192,117,30,168,70,2,192,117,30,168,198,253,255,
  117,30,168,70,253,255,117,30,168,201,28,160,130,2,192,109,29,168,66,0,192,109,29,168,194,255,255,109,29,168,130,253,
  255,109,29,168,198,2,192,117,30,168,70,2,192,157,29,168,198,253,255,157,29,168,70,253,255,117,30,168,201,28,160,130,
  2,192,109,29,168,66,0,192,241,28,168,194,255,255,241,28,168,130,253,255,109,29,168,198,2,192,117,30,168,70,2,192,
  117,30,168,198,253,255,117,30,168,70,253,255,117,30,168,201,28,160,194,2,192,241,28,168,66,2,192,109,29,168,194,253,
  255,109,29,168,66,253,255,241,28,168,134,2,192,117,30,168,70,0,192,117,30,168,198,255,255,117,30,168,134,253,255,117,
  30,168,201,28,160,194,2,192,109,29,168,66,2,192,109,29,168,194,253,255,109,29,168,66,253,255,109,29,168,134,2,192,
  157,29,168,70,0,192,117,30,168,198,255,255,117,30,168,134,253,255,157,29,168,201,28,160,194,2,192,109,29,168,66,2,
  192,241,28,168,194,253,255,241,28,168,66,253,255,109,29,168,134,2,192,117,30,168,70,0,192,117,30,168,198,255,255,117,
  30,168,134,253,255,117,30,168,201,28,160,194,2,192,109,29,168,66,2,192,109,29,168,194,253,255,109,29,168,66,253,255,
  109,29,168,134,2,192,117,30,168,70,0,192,157,29,168,198,255,255,157,29,168,134,253,255,117,30,168,201,28,160,10,0,
  192,196,32,192,1,48,193,0,0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,
  0,0,96,128,20,196,245,193,47,0,0,196,34,192,1,48,193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,
  0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,196,247,193,47,0,0,4,33,192,1,53,193,0,0,5,21,0,
  0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,4,246,193,47,0,0,4,
  35,192,1,53,193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,
  96,128,20,4,248,193,47,0,0,68,33,192,129,54,193,0,0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,
  9,21,0,0,98,0,8,21,0,0,96,128,20,68,246,193,47,0,0,68,35,192,129,54,193,0,0,5,21,0,0,210,
  0,0,96,128,20,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,68,248,193,47,0,0,132,33,192,
  1,56,193,0,0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,
  20,132,246,193,47,0,0,132,35,192,1,56,193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,0,0,9,21,
  0,0,98,0,8,21,0,0,96,128,20,132,248,193,47,0,0,196,33,192,129,57,193,0,0,5,21,0,0,210,0,0,
  96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,196,246,193,47,0,0,196,35,192,129,57,
  193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,196,
  248,193,47,0,0,4,34,192,1,59,193,0,0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,
  98,0,8,21,0,0,96,128,20,4,247,193,47,0,0,4,36,192,1,59,193,0,0,5,21,0,0,210,0,0,96,128,
  20,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,4,249,193,47,0,0,68,34,192,1,60,193,0,
  0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,68,247,193,
  47,0,0,68,36,192,1,60,193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,0,0,9,21,0,0,98,0,
  8,21,0,0,96,128,20,68,249,193,47,0,0,209,0,0,16,0,21,16,0,21,16,0,21,26,0,0,132,247,193,15,
  0,192,132,249,193,15,0,192,78,5,192,4,0,0,2,0,192,0,128,5,22,200,145,22,200,148,130,7,192,0,128,2,
  0,128,11,35,0,0,2,44,193,48,128,21,37,128,20,96,128,21,62,135,145,130,170,192,0,128,21,36,128,20,2,228,
  192,240,128,21,37,128,20,97,0,0,106,7,160,130,170,192,0,128,21,36,128,20,2,228,192,240,128,21,37,128,20,97,
  0,0,16,0,21,16,0,21,96,0,21,0,0,11,2,36,193,48,128,21,37,128,20,96,0,21,29,0,0,0,0,11,
  0,0,11,0,0,11,2,40,193,48,128,21,37,128,20,96,0,21,130,3,192,48,128,18,0,128,11,35,0,0,4,0,
  0,2,8,192,0,128,2,234,135,145,194,247,193,48,128,21,36,0,0,0,0,5,194,143,193,0,128,21,36,128,20,31,
  0,0,209,0,0,224,0,21,26,0,0,22,8,160,194,245,193,48,128,21,36,0,0,0,0,5,194,143,193,0,128,21,
  36,128,20,31,0,0,209,0,0,224,0,20,26,0,0,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,230,6,
  145,196,37,192,223,0,0,0,0,64,78,5,192,4,0,0,2,0,192,0,128,5,58,202,148,2,105,192,0,128,21,36,
  128,20,2,192,255,241,128,18,32,0,19,0,128,15,26,0,0,22,0,0,132,244,193,47,0,0,194,137,192,0,128,21,
  36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,29,0,0,19,0,0,196,244,193,47,0,0,66,78,193,0,128,
  21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,4,245,193,31,0,0,68,245,193,47,0,0,4,0,0,241,
  0,0,0,0,15,0,0,12,4,245,193,242,0,12,0,128,12,47,0,0,68,245,193,242,0,12,0,128,12,47,0,0,
  4,245,193,241,0,0,32,0,20,86,73,144,150,73,145,68,245,193,65,255,255,0,0,5,58,9,144,209,0,0,196,244,
  193,0,0,4,26,0,0,62,9,144,10,0,192,129,0,0,48,0,20,22,0,0,2,10,144,6,0,192,2,10,160,4,
  245,193,65,255,255,0,0,5,122,9,144,225,0,0,132,244,193,0,0,4,29,0,0,126,9,144,13,0,192,49,0,0,
  128,0,20,19,0,0,2,10,144,3,0,192,2,10,160,209,0,0,196,244,193,0,0,4,26,0,0,174,9,144,10,0,
  192,225,0,0,132,244,193,0,0,4,29,0,0,198,9,144,13,0,192,65,255,255,208,0,21,218,73,144,10,0,192,13,
  0,192,129,0,0,224,0,20,22,0,0,238,9,144,6,0,192,49,0,0,208,0,20,19,0,0,2,10,144,3,0,192,
  226,0,0,209,128,15,32,0,17,2,236,192,0,128,21,36,128,20,31,0,0,49,0,0,0,0,15,128,0,17,194,12,
  193,0,128,21,36,128,20,31,0,0,1,0,0,0,0,9,30,0,0,130,27,192,0,128,20,62,136,145,0,0,64,196,
  252,193,15,0,192,4,253,193,15,0,192,196,36,192,254,0,0,10,1,192,2,111,193,0,128,21,36,128,20,2,192,255,
  0,128,2,142,138,145,138,3,192,68,253,193,223,0,0,66,253,255,0,128,21,36,128,20,0,128,5,118,203,148,66,108,
  193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,192,48,128,21,218,138,148,2,
  0,192,131,1,192,33,0,0,48,128,20,238,202,144,129,1,192,66,253,255,0,128,21,36,128,20,0,128,5,26,203,145,
  195,1,192,48,0,21,2,16,192,0,128,2,26,139,145,48,0,21,130,151,193,16,128,21,37,128,20,98,0,0,196,252,
  193,0,128,5,47,0,0,66,253,255,0,128,21,36,128,20,2,16,192,0,128,2,118,139,145,66,108,193,0,128,21,36,
  128,20,2,192,255,0,128,2,118,139,145,68,253,193,194,1,192,0,128,5,47,0,0,130,253,255,0,128,21,36,128,20,
  0,128,5,86,204,148,130,108,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,
  192,48,128,21,186,139,148,2,0,192,131,1,192,33,0,0,48,128,20,206,203,144,129,1,192,130,253,255,0,128,21,36,
  128,20,0,128,5,250,203,145,195,1,192,48,0,21,2,16,192,0,128,2,250,139,145,48,0,21,130,151,193,16,128,21,
  37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,130,253,255,0,128,21,36,128,20,2,16,192,0,128,2,86,140,
  145,130,108,193,0,128,21,36,128,20,2,192,255,0,128,2,86,140,145,68,253,193,194,1,192,0,128,5,47,0,0,194,
  253,255,0,128,21,36,128,20,0,128,5,54,205,148,194,108,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,
  0,128,15,16,128,20,195,0,192,48,128,21,154,140,148,2,0,192,131,1,192,33,0,0,48,128,20,174,204,144,129,1,
  192,194,253,255,0,128,21,36,128,20,0,128,5,218,204,145,195,1,192,48,0,21,2,16,192,0,128,2,218,140,145,48,
  0,21,130,151,193,16,128,21,37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,194,253,255,0,128,21,36,128,20,
  2,16,192,0,128,2,54,141,145,194,108,193,0,128,21,36,128,20,2,192,255,0,128,2,54,141,145,68,253,193,194,1,
  192,0,128,5,47,0,0,194,255,255,0,128,21,36,128,20,0,128,5,22,206,148,194,110,193,0,128,21,36,128,20,2,
  192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,192,48,128,21,122,141,148,2,0,192,131,1,192,33,0,0,
  48,128,20,142,205,144,129,1,192,194,255,255,0,128,21,36,128,20,0,128,5,186,205,145,195,1,192,48,0,21,2,16,
  192,0,128,2,186,141,145,48,0,21,194,156,193,16,128,21,37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,194,
  255,255,0,128,21,36,128,20,2,16,192,0,128,2,22,142,145,194,110,193,0,128,21,36,128,20,2,192,255,0,128,2,
  22,142,145,68,253,193,66,1,192,0,128,5,47,0,0,66,0,192,0,128,21,36,128,20,0,128,5,246,206,148,66,111,
  193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,192,48,128,21,90,142,148,2,
  0,192,131,1,192,33,0,0,48,128,20,110,206,144,129,1,192,66,0,192,0,128,21,36,128,20,0,128,5,154,206,145,
  195,1,192,48,0,21,2,16,192,0,128,2,154,142,145,48,0,21,194,156,193,16,128,21,37,128,20,98,0,0,196,252,
  193,0,128,5,47,0,0,66,0,192,0,128,21,36,128,20,2,16,192,0,128,2,246,142,145,66,111,193,0,128,21,36,
  128,20,2,192,255,0,128,2,246,142,145,68,253,193,66,1,192,0,128,5,47,0,0,66,2,192,0,128,21,36,128,20,
  0,128,5,214,207,148,66,113,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,
  192,48,128,21,58,143,148,2,0,192,131,1,192,33,0,0,48,128,20,78,207,144,129,1,192,66,2,192,0,128,21,36,
  128,20,0,128,5,122,207,145,195,1,192,48,0,21,2,16,192,0,128,2,122,143,145,48,0,21,2,162,193,16,128,21,
  37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,66,2,192,0,128,21,36,128,20,2,16,192,0,128,2,214,143,
  145,66,113,193,0,128,21,36,128,20,2,192,255,0,128,2,214,143,145,68,253,193,194,0,192,0,128,5,47,0,0,130,
  2,192,0,128,21,36,128,20,0,128,5,182,208,148,130,113,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,
  0,128,15,16,128,20,195,0,192,48,128,21,26,144,148,2,0,192,131,1,192,33,0,0,48,128,20,46,208,144,129,1,
  192,130,2,192,0,128,21,36,128,20,0,128,5,90,208,145,195,1,192,48,0,21,2,16,192,0,128,2,90,144,145,48,
  0,21,2,162,193,16,128,21,37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,130,2,192,0,128,21,36,128,20,
  2,16,192,0,128,2,182,144,145,130,113,193,0,128,21,36,128,20,2,192,255,0,128,2,182,144,145,68,253,193,194,0,
  192,0,128,5,47,0,0,194,2,192,0,128,21,36,128,20,0,128,5,150,209,148,194,113,193,0,128,21,36,128,20,2,
  192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,192,48,128,21,250,144,148,2,0,192,131,1,192,33,0,0,
  48,128,20,14,209,144,129,1,192,194,2,192,0,128,21,36,128,20,0,128,5,58,209,145,195,1,192,48,0,21,2,16,
  192,0,128,2,58,145,145,48,0,21,2,162,193,16,128,21,37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,194,
  2,192,0,128,21,36,128,20,2,16,192,0,128,2,150,145,145,194,113,193,0,128,21,36,128,20,2,192,255,0,128,2,
  150,145,145,68,253,193,194,0,192,0,128,5,47,0,0,4,37,192,254,0,0,13,1,192,2,111,193,0,128,21,36,128,
  20,194,63,192,0,128,2,190,145,145,141,3,192,132,253,193,239,0,0,194,2,192,0,128,21,36,128,20,0,128,5,166,
  210,148,194,113,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,
  10,18,148,1,0,192,131,1,192,18,0,0,48,128,20,30,210,144,129,1,192,194,2,192,0,128,21,36,128,20,0,128,
  5,74,210,145,195,1,192,48,0,21,2,8,192,0,128,2,74,146,145,48,0,21,130,151,193,16,128,21,37,128,20,98,
  0,0,4,253,193,0,128,5,47,0,0,194,2,192,0,128,21,36,128,20,2,8,192,0,128,2,166,146,145,194,113,193,
  0,128,21,36,128,20,194,63,192,0,128,2,166,146,145,132,253,193,194,1,192,0,128,5,47,0,0,130,2,192,0,128,
  21,36,128,20,0,128,5,134,211,148,130,113,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,
  0,20,195,0,192,48,0,21,234,18,148,1,0,192,131,1,192,18,0,0,48,128,20,254,210,144,129,1,192,130,2,192,
  0,128,21,36,128,20,0,128,5,42,211,145,195,1,192,48,0,21,2,8,192,0,128,2,42,147,145,48,0,21,130,151,
  193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,47,0,0,130,2,192,0,128,21,36,128,20,2,8,192,0,
  128,2,134,147,145,130,113,193,0,128,21,36,128,20,194,63,192,0,128,2,134,147,145,132,253,193,194,1,192,0,128,5,
  47,0,0,66,2,192,0,128,21,36,128,20,0,128,5,102,212,148,66,113,193,0,128,21,36,128,20,2,192,255,241,128,
  18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,202,19,148,1,0,192,131,1,192,18,0,0,48,128,20,222,
  211,144,129,1,192,66,2,192,0,128,21,36,128,20,0,128,5,10,212,145,195,1,192,48,0,21,2,8,192,0,128,2,
  10,148,145,48,0,21,130,151,193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,47,0,0,66,2,192,0,128,
  21,36,128,20,2,8,192,0,128,2,102,148,145,66,113,193,0,128,21,36,128,20,194,63,192,0,128,2,102,148,145,132,
  253,193,194,1,192,0,128,5,47,0,0,66,0,192,0,128,21,36,128,20,0,128,5,70,213,148,66,111,193,0,128,21,
  36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,170,20,148,1,0,192,131,1,
  192,18,0,0,48,128,20,190,212,144,129,1,192,66,0,192,0,128,21,36,128,20,0,128,5,234,212,145,195,1,192,48,
  0,21,2,8,192,0,128,2,234,148,145,48,0,21,194,156,193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,
  47,0,0,66,0,192,0,128,21,36,128,20,2,8,192,0,128,2,70,149,145,66,111,193,0,128,21,36,128,20,194,63,
  192,0,128,2,70,149,145,132,253,193,66,1,192,0,128,5,47,0,0,194,255,255,0,128,21,36,128,20,0,128,5,38,
  214,148,194,110,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,
  138,21,148,1,0,192,131,1,192,18,0,0,48,128,20,158,213,144,129,1,192,194,255,255,0,128,21,36,128,20,0,128,
  5,202,213,145,195,1,192,48,0,21,2,8,192,0,128,2,202,149,145,48,0,21,194,156,193,16,128,21,37,128,20,98,
  0,0,4,253,193,0,128,5,47,0,0,194,255,255,0,128,21,36,128,20,2,8,192,0,128,2,38,150,145,194,110,193,
  0,128,21,36,128,20,194,63,192,0,128,2,38,150,145,132,253,193,66,1,192,0,128,5,47,0,0,194,253,255,0,128,
  21,36,128,20,0,128,5,6,215,148,194,108,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,
  0,20,195,0,192,48,0,21,106,22,148,1,0,192,131,1,192,18,0,0,48,128,20,126,214,144,129,1,192,194,253,255,
  0,128,21,36,128,20,0,128,5,170,214,145,195,1,192,48,0,21,2,8,192,0,128,2,170,150,145,48,0,21,2,162,
  193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,47,0,0,194,253,255,0,128,21,36,128,20,2,8,192,0,
  128,2,6,151,145,194,108,193,0,128,21,36,128,20,194,63,192,0,128,2,6,151,145,132,253,193,194,0,192,0,128,5,
  47,0,0,130,253,255,0,128,21,36,128,20,0,128,5,230,215,148,130,108,193,0,128,21,36,128,20,2,192,255,241,128,
  18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,74,23,148,1,0,192,131,1,192,18,0,0,48,128,20,94,
  215,144,129,1,192,130,253,255,0,128,21,36,128,20,0,128,5,138,215,145,195,1,192,48,0,21,2,8,192,0,128,2,
  138,151,145,48,0,21,2,162,193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,47,0,0,130,253,255,0,128,
  21,36,128,20,2,8,192,0,128,2,230,151,145,130,108,193,0,128,21,36,128,20,194,63,192,0,128,2,230,151,145,132,
  253,193,194,0,192,0,128,5,47,0,0,66,253,255,0,128,21,36,128,20,0,128,5,198,216,148,66,108,193,0,128,21,
  36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,42,24,148,1,0,192,131,1,
  192,18,0,0,48,128,20,62,216,144,129,1,192,66,253,255,0,128,21,36,128,20,0,128,5,106,216,145,195,1,192,48,
  0,21,2,8,192,0,128,2,106,152,145,48,0,21,2,162,193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,
  47,0,0,66,253,255,0,128,21,36,128,20,2,8,192,0,128,2,198,152,145,66,108,193,0,128,21,36,128,20,194,63,
  192,0,128,2,198,152,145,132,253,193,194,0,192,0,128,5,47,0,0,4,253,193,241,0,0,16,0,21,16,0,21,16,
  0,21,26,0,0,132,253,193,241,0,0,18,0,0,3,4,192,48,128,20,250,216,144,1,4,192,2,0,192,16,128,21,
  37,128,20,109,0,0,1,0,192,0,0,37,68,39,192,31,0,0,196,252,193,241,0,0,16,0,21,16,0,21,16,0,
  21,26,0,0,68,253,193,241,0,0,18,0,0,3,4,192,48,128,20,78,217,144,1,4,192,2,0,192,16,128,21,37,
  128,20,109,0,0,68,39,192,241,0,0,0,0,36,68,39,192,31,0,0,0,0,64,132,37,192,15,0,192,196,37,192,
  15,0,192,10,0,192,4,37,192,241,0,0,16,0,18,74,90,145,65,72,192,194,32,192,3,0,192,20,0,9,63,128,
  8,166,153,145,65,5,192,20,0,0,2,16,192,0,128,2,242,217,145,2,0,224,30,128,17,38,0,0,130,7,192,0,
  128,2,0,128,11,67,167,193,48,128,21,37,0,0,104,0,0,0,0,128,0,0,9,130,27,192,16,128,20,182,153,145,
  4,37,192,241,0,0,66,72,192,16,128,21,36,128,20,193,63,192,0,0,2,54,90,145,132,37,192,31,0,0,210,0,
  0,0,128,9,42,0,0,130,0,192,208,128,20,74,154,145,132,37,192,207,255,255,0,0,64,197,104,192,193,32,192,84,
  1,0,242,0,0,0,128,15,47,0,8,86,26,145,0,0,64,48,0,21,66,72,192,16,128,21,36,128,20,143,0,0,
  20,0,0,242,0,0,32,128,18,162,218,145,2,15,192,0,128,4,246,218,145,1,0,64,48,0,21,66,72,192,16,128,
  21,36,128,20,2,0,224,0,128,1,47,0,0,20,0,0,242,0,0,32,128,18,162,218,145,2,15,192,0,128,4,18,
  155,145,210,0,0,0,128,9,42,0,0,132,37,192,15,0,0,196,37,192,63,0,0,48,0,21,66,72,192,16,128,21,
  36,128,20,2,0,224,0,128,1,47,0,0,1,0,64,194,69,192,16,128,21,36,128,20,143,0,0,242,25,160,131,253,
  255,110,26,168,242,25,160,2,67,192,16,128,21,36,128,20,143,0,0,130,67,192,16,128,21,36,128,20,143,0,0,242,
  25,160,130,69,192,16,128,21,36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,2,70,192,16,128,21,
  36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,2,75,192,16,128,21,36,128,20,143,0,0,242,25,
  160,130,69,192,16,128,21,36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,2,70,192,16,128,21,36,
  128,20,143,0,0,2,72,192,16,128,21,36,128,20,143,0,0,130,72,192,16,128,21,36,128,20,143,0,0,194,74,192,
  16,128,21,36,128,20,143,0,0,242,25,160,194,69,192,16,128,21,36,128,20,143,0,0,2,72,192,16,128,21,36,128,
  20,143,0,0,130,72,192,16,128,21,36,128,20,143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,67,253,255,110,
  26,168,195,253,255,110,26,168,67,2,192,110,26,168,195,2,192,110,26,168,242,25,160,130,69,192,16,128,21,36,128,20,
  143,0,0,2,70,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,2,75,192,16,128,
  21,36,128,20,143,0,0,131,253,255,110,26,168,195,255,255,110,26,168,67,0,192,110,26,168,131,2,192,110,26,168,242,
  25,160,130,69,192,16,128,21,36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,2,70,192,16,128,21,
  36,128,20,143,0,0,2,72,192,16,128,21,36,128,20,143,0,0,130,72,192,16,128,21,36,128,20,143,0,0,130,74,
  192,16,128,21,36,128,20,143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,2,75,192,16,128,21,36,128,20,143,
  0,0,242,25,160,132,37,192,15,0,192,196,37,192,15,0,192,10,0,192,196,36,192,241,0,0,16,0,18,50,94,145,
  65,72,192,194,32,192,3,0,192,20,0,9,63,128,8,142,157,145,65,5,192,20,0,0,2,8,192,0,128,2,218,221,
  145,2,0,224,30,128,17,38,0,0,130,7,192,0,128,2,0,128,11,3,171,193,48,128,21,37,0,0,104,0,0,0,
  0,128,0,0,9,130,27,192,16,128,20,158,157,145,196,36,192,241,0,0,66,72,192,16,128,21,36,128,20,193,63,192,
  0,0,2,30,94,145,132,37,192,31,0,0,210,0,0,0,128,9,42,0,0,130,0,192,208,128,20,50,158,145,132,37,
  192,207,255,255,0,0,64,48,0,21,66,72,192,16,128,21,36,128,20,143,0,0,20,0,0,242,0,0,32,128,18,106,
  222,145,2,23,192,0,128,4,190,222,145,1,0,64,48,0,21,66,72,192,16,128,21,36,128,20,2,0,224,0,128,1,
  47,0,0,20,0,0,242,0,0,32,128,18,106,222,145,2,23,192,0,128,4,218,158,145,210,0,0,0,128,9,42,0,
  0,132,37,192,15,0,0,196,37,192,63,0,0,48,0,21,66,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,
  0,0,1,0,64,194,74,192,16,128,21,36,128,20,143,0,0,218,29,160,131,2,192,54,30,168,218,29,160,130,77,192,
  16,128,21,36,128,20,143,0,0,2,77,192,16,128,21,36,128,20,143,0,0,218,29,160,2,75,192,16,128,21,36,128,
  20,143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,2,70,192,16,
  128,21,36,128,20,143,0,0,130,69,192,16,128,21,36,128,20,143,0,0,218,29,160,2,75,192,16,128,21,36,128,20,
  143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,130,72,192,16,128,
  21,36,128,20,143,0,0,2,72,192,16,128,21,36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,218,
  29,160,194,74,192,16,128,21,36,128,20,143,0,0,130,72,192,16,128,21,36,128,20,143,0,0,2,72,192,16,128,21,
  36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,195,2,192,54,30,168,67,2,192,54,30,168,195,253,
  255,54,30,168,67,253,255,54,30,168,218,29,160,2,75,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,
  128,20,143,0,0,2,70,192,16,128,21,36,128,20,143,0,0,130,69,192,16,128,21,36,128,20,143,0,0,131,2,192,
  54,30,168,67,0,192,54,30,168,195,255,255,54,30,168,131,253,255,54,30,168,218,29,160,2,75,192,16,128,21,36,128,
  20,143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,130,72,192,16,
  128,21,36,128,20,143,0,0,2,72,192,16,128,21,36,128,20,143,0,0,2,70,192,16,128,21,36,128,20,143,0,0,
  194,69,192,16,128,21,36,128,20,143,0,0,130,69,192,16,128,21,36,128,20,143,0,0,218,29,160,129,39,192,194,32,
  192,3,0,192,20,0,9,63,128,8,51,129,145,196,36,192,241,0,0,16,0,18,195,65,145,67,253,255,14,13,192,13,
  8,192,199,1,168,43,2,168,195,253,255,14,13,192,13,24,192,199,1,168,195,255,255,14,14,192,13,32,192,199,1,168,
  67,0,192,14,14,192,13,32,192,199,1,168,67,2,192,14,13,192,13,24,192,199,1,168,131,2,192,14,14,192,13,16,
  192,199,1,168,195,2,192,14,13,192,13,8,192,199,1,168,0,0,64,196,36,192,241,0,0,2,0,192,48,0,21,20,
  0,0,0,128,5,211,193,145,2,16,192,0,128,2,39,194,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,
  247,193,145,2,63,192,0,128,2,0,128,20,39,130,145,130,39,192,208,128,21,36,128,20,239,0,0,0,0,64,131,253,
  255,14,14,192,196,36,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,63,194,145,2,16,192,0,128,2,159,
  194,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,99,194,145,2,9,192,0,128,4,143,194,145,2,63,192,
  0,128,2,0,128,20,159,130,145,130,39,192,208,128,21,36,128,20,15,16,192,0,0,64,129,39,192,194,32,192,3,0,
  192,20,0,9,63,128,8,175,130,145,4,37,192,241,0,0,16,0,18,63,67,145,195,2,192,14,21,192,13,8,192,67,
  3,168,167,3,168,67,2,192,14,21,192,13,24,192,67,3,168,67,0,192,14,22,192,13,32,192,67,3,168,195,255,255,
  14,22,192,13,32,192,67,3,168,195,253,255,14,21,192,13,24,192,67,3,168,131,253,255,14,22,192,13,16,192,67,3,
  168,67,253,255,14,21,192,13,8,192,67,3,168,0,0,64,4,37,192,241,0,0,2,0,192,48,0,21,20,0,0,0,
  128,5,79,195,145,2,8,192,0,128,2,163,195,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,115,195,145,
  2,63,192,0,128,2,0,128,20,163,131,145,130,39,192,208,128,21,36,128,20,239,0,0,0,0,64,131,2,192,14,14,
  192,4,37,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,187,195,145,2,8,192,0,128,2,27,196,145,26,
  0,0,2,0,192,48,0,21,20,0,0,0,128,5,223,195,145,2,17,192,0,128,4,11,196,145,2,63,192,0,128,2,
  0,128,20,27,132,145,130,39,192,208,128,21,36,128,20,15,16,192,0,0,64,132,37,192,250,0,0,65,5,192,20,0,
  0,2,8,192,0,128,2,119,196,145,130,39,192,16,128,21,36,128,20,0,128,5,119,132,145,30,0,0,20,0,0,130,
  7,192,0,128,2,0,128,11,195,174,193,48,128,21,37,0,0,104,0,0,0,0,128,0,0,9,130,27,192,16,128,20,
  43,132,145,132,37,192,15,0,192,0,0,64,132,37,192,79,0,192,0,0,64,194,2,192,16,128,21,208,128,20,147,196,
  145,130,2,192,16,128,21,208,128,20,147,196,145,66,2,192,16,128,21,208,128,20,147,196,145,194,253,255,16,128,21,208,
  128,20,147,196,145,66,253,255,16,128,21,208,128,20,147,196,145,119,4,160,130,2,192,16,128,21,208,128,20,147,196,145,
  66,0,192,16,128,21,208,128,20,147,196,145,194,255,255,16,128,21,208,128,20,147,196,145,130,253,255,16,128,21,208,128,
  20,147,196,145,195,2,192,2,0,192,48,0,21,20,0,0,0,128,5,59,197,145,208,0,20,147,68,145,1,0,0,67,
  2,192,2,0,192,48,0,21,20,0,0,0,128,5,95,197,145,208,0,20,147,68,145,1,0,0,195,253,255,2,0,192,
  48,0,21,20,0,0,0,128,5,131,197,145,208,0,20,147,68,145,1,0,0,67,253,255,2,0,192,48,0,21,20,0,
  0,0,128,5,167,197,145,208,0,20,147,68,145,1,0,0,119,4,160,66,5,192,16,128,21,208,128,20,147,196,145,194,
  4,192,16,128,21,208,128,20,147,196,145,119,4,160,194,2,192,16,128,21,208,128,20,147,196,145,66,2,192,16,128,21,
  208,128,20,147,196,145,66,0,192,16,128,21,208,128,20,147,196,145,194,255,255,16,128,21,208,128,20,147,196,145,130,253,
  255,16,128,21,208,128,20,147,196,145,130,2,192,16,128,21,208,128,20,147,196,145,119,4,160,194,2,192,16,128,21,208,
  128,20,147,196,145,66,2,192,16,128,21,208,128,20,147,196,145,194,253,255,16,128,21,208,128,20,147,196,145,66,253,255,
  16,128,21,208,128,20,147,196,145,67,0,192,2,0,192,48,0,21,20,0,0,0,128,5,151,198,145,208,0,20,147,68,
  145,1,0,0,195,255,255,2,0,192,48,0,21,20,0,0,0,128,5,187,198,145,208,0,20,147,68,145,1,0,0,131,
  253,255,2,0,192,48,0,21,20,0,0,0,128,5,223,198,145,208,0,20,147,68,145,1,0,0,131,2,192,2,0,192,
  48,0,21,20,0,0,0,128,5,3,199,145,208,0,20,147,68,145,1,0,0,119,4,160,163,2,168,118,25,168,132,37,
  192,242,0,0,32,128,18,219,200,145,79,199,148,196,37,192,242,0,0,32,128,18,219,136,145,4,37,192,254,0,0,194,
  2,192,0,128,21,36,128,20,2,40,192,0,128,2,131,135,145,2,75,192,0,128,21,36,128,20,0,128,5,219,200,145,
  130,2,192,0,128,21,36,128,20,2,40,192,0,128,2,175,135,145,194,74,192,0,128,21,36,128,20,0,128,5,219,200,
  145,66,2,192,0,128,21,36,128,20,2,40,192,0,128,2,219,135,145,130,74,192,0,128,21,36,128,20,0,128,5,219,
  200,145,66,0,192,0,128,21,36,128,20,2,40,192,0,128,2,7,136,145,130,72,192,0,128,21,36,128,20,0,128,5,
  219,200,145,194,255,255,0,128,21,36,128,20,2,40,192,0,128,2,51,136,145,2,72,192,0,128,21,36,128,20,0,128,
  5,219,200,145,194,253,255,0,128,21,36,128,20,2,40,192,0,128,2,95,136,145,2,70,192,0,128,21,36,128,20,0,
  128,5,219,200,145,130,253,255,0,128,21,36,128,20,2,40,192,0,128,2,139,136,145,194,69,192,0,128,21,36,128,20,
  0,128,5,219,200,145,66,253,255,0,128,21,36,128,20,2,40,192,0,128,2,183,136,145,130,69,192,0,128,21,36,128,
  20,0,128,5,219,200,145,132,37,192,242,0,0,32,128,18,207,200,148,31,4,168,0,0,64,132,37,192,15,0,192,0,
  0,64,132,37,192,79,0,192,0,0,64,1,105,192,194,32,192,3,0,192,20,0,9,63,128,8,243,136,145,193,137,192,
  194,32,192,3,0,192,20,0,9,63,128,8,11,137,145,4,37,192,241,0,0,16,0,18,95,74,145,195,2,192,10,8,
  192,13,8,192,14,21,192,99,10,168,203,10,168,67,2,192,10,8,192,13,24,192,14,21,192,99,10,168,67,0,192,10,
  16,192,13,32,192,14,22,192,99,10,168,195,255,255,10,16,192,13,32,192,14,22,192,99,10,168,195,253,255,10,8,192,
  13,24,192,14,21,192,99,10,168,131,253,255,10,16,192,13,16,192,14,22,192,99,10,168,67,253,255,10,8,192,13,8,
  192,14,21,192,99,10,168,4,37,192,241,0,0,66,110,192,16,128,21,36,128,20,15,1,192,194,109,192,16,128,21,36,
  128,20,15,1,192,194,107,192,16,128,21,36,128,20,15,14,192,66,107,192,16,128,21,36,128,20,15,14,192,130,107,192,
  16,128,21,36,128,20,207,22,192,66,105,192,16,128,21,36,128,20,15,20,192,194,104,192,16,128,21,36,128,20,15,20,
  192,130,102,192,16,128,21,36,128,20,15,20,192,194,102,192,16,128,21,36,128,20,15,10,192,66,102,192,16,128,21,36,
  128,20,15,10,192,0,0,64,4,37,192,241,0,0,48,0,21,2,105,192,16,128,21,36,128,20,223,0,0,20,0,0,
  0,128,5,107,202,145,199,202,148,22,0,0,48,0,21,20,0,0,242,0,0,32,128,18,147,202,145,2,63,192,0,128,
  2,0,128,20,199,138,145,194,137,192,128,128,21,36,128,20,239,0,0,0,0,64,131,2,192,14,14,192,4,37,192,241,
  0,0,48,0,21,2,105,192,16,128,21,36,128,20,143,16,192,20,0,0,0,128,5,219,202,145,67,203,148,22,0,0,
  2,0,192,48,0,21,20,0,0,0,128,5,7,203,145,2,17,192,0,128,4,51,203,145,2,63,192,0,128,2,0,128,
  20,67,139,145,194,137,192,128,128,21,36,128,20,15,16,192,0,0,64,0,0,21,20,0,0,242,0,0,32,128,18,131,
  139,145,194,170,192,128,128,21,36,128,20,223,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,64,
  0,0,64,39,1,168,94,29,168,231,8,168,6,0,192,132,170,192,15,0,192,132,45,193,15,0,192,132,37,192,242,0,
  0,32,128,18,111,141,145,78,5,192,4,0,0,2,16,192,0,128,2,39,204,145,130,7,192,0,128,2,0,128,11,35,
  0,0,130,198,193,48,128,21,37,128,20,106,0,0,2,202,193,48,128,21,37,128,20,109,0,0,130,39,192,0,128,21,
  36,128,20,242,0,0,0,128,11,48,128,17,131,178,193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,
  9,30,0,0,130,27,192,16,128,20,187,139,145,4,37,192,254,0,0,4,33,192,242,0,0,32,128,18,99,204,145,74,
  0,192,129,2,192,71,11,168,68,33,192,242,0,0,32,128,18,135,204,145,138,0,192,65,5,192,71,11,168,193,4,192,
  71,11,168,132,33,192,242,0,0,32,128,18,195,204,145,202,0,192,193,2,192,71,11,168,129,2,192,71,11,168,65,2,
  192,71,11,168,193,253,255,71,11,168,65,253,255,71,11,168,196,33,192,242,0,0,32,128,18,7,205,145,10,1,192,193,
  2,192,71,11,168,129,2,192,71,11,168,65,2,192,71,11,168,65,0,192,71,11,168,193,255,255,71,11,168,129,253,255,
  71,11,168,4,34,192,242,0,0,32,128,18,59,205,145,74,1,192,193,2,192,71,11,168,65,2,192,71,11,168,193,253,
  255,71,11,168,65,253,255,71,11,168,68,34,192,242,0,0,32,128,18,111,205,145,138,1,192,129,2,192,71,11,168,65,
  0,192,71,11,168,193,255,255,71,11,168,129,253,255,71,11,168,132,37,192,143,0,0,0,0,64,194,170,192,128,128,21,
  36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,64,194,170,192,128,128,21,36,128,
  20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,64,2,105,192,16,
  128,21,36,128,20,242,0,0,208,128,82,2,105,192,16,128,21,36,128,20,242,0,0,224,128,82,2,105,192,16,128,21,
  36,128,20,242,0,0,208,128,18,123,141,145,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,251,205,145,0,0,
  64,0,0,21,20,0,0,2,48,192,0,128,2,107,142,145,231,13,168,251,205,145,130,12,192,16,128,20,99,142,144,130,
  12,192,0,128,20,251,205,144,163,13,168,251,13,160,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,155,142,145,
  231,13,168,155,206,145,130,12,192,16,128,20,163,141,144,251,13,160,0,0,64,0,0,21,20,0,0,2,48,192,0,128,
  2,199,142,145,231,13,168,251,205,145,130,12,192,16,128,20,163,141,144,0,0,64,1,0,0,215,14,160,251,13,168,48,
  0,21,20,0,0,242,0,0,32,128,18,211,206,145,2,48,192,0,128,2,251,205,145,0,0,64,1,0,0,35,15,160,
  130,12,192,16,128,20,31,207,144,231,13,168,35,207,145,163,13,168,35,15,160,251,13,168,48,0,21,20,0,0,242,0,
  0,32,128,18,3,207,145,2,48,192,0,128,2,87,143,145,130,12,192,16,128,20,251,205,144,231,13,168,163,141,145,0,
  0,64,1,0,0,130,12,192,0,128,20,175,207,144,123,15,160,231,13,168,123,207,145,163,13,168,48,0,21,20,0,0,
  242,0,0,32,128,18,111,207,145,2,48,192,0,128,2,207,143,145,231,13,168,163,141,145,0,0,64,211,13,168,123,141,
  145,48,0,21,20,0,0,242,0,0,32,128,18,167,207,145,2,48,192,0,128,2,251,205,145,0,0,64,129,253,255,111,
  14,168,39,12,160,131,253,255,1,0,0,3,16,160,130,12,192,16,128,20,3,208,144,231,13,168,3,208,145,163,13,168,
  48,0,21,20,0,0,242,0,0,32,128,18,235,207,145,2,48,192,0,128,2,63,144,145,130,12,192,16,128,20,59,208,
  144,231,13,168,59,208,145,163,13,168,251,13,168,39,12,160,193,250,255,159,14,168,65,251,255,159,14,168,39,12,160,65,
  253,255,47,14,168,193,2,192,47,14,168,129,253,255,47,14,168,193,253,255,47,14,168,65,2,192,47,14,168,39,12,160,
  65,253,255,23,14,168,129,2,192,23,14,168,129,253,255,23,14,168,193,253,255,23,14,168,193,255,255,23,14,168,65,0,
  192,23,14,168,39,12,160,67,253,255,251,14,168,195,2,192,91,15,168,195,253,255,251,14,168,67,2,192,91,15,168,39,
  12,160,129,253,255,23,14,168,193,255,255,23,14,168,65,0,192,23,14,168,129,2,192,23,14,168,67,253,255,203,14,168,
  195,2,192,203,14,168,195,253,255,203,14,168,67,2,192,203,14,168,39,12,160,131,253,255,251,14,168,131,2,192,91,15,
  168,195,255,255,91,15,168,67,0,192,91,15,168,39,12,160,65,253,255,23,14,168,193,253,255,23,14,168,65,2,192,23,
  14,168,193,2,192,23,14,168,131,253,255,203,14,168,131,2,192,203,14,168,195,255,255,203,14,168,67,0,192,203,14,168,
  39,12,160,65,253,255,47,14,168,193,2,192,47,14,168,39,12,160,129,253,255,47,14,168,39,12,160,65,253,255,23,14,
  168,39,12,160,129,253,255,23,14,168,129,2,192,23,14,168,39,12,160,193,253,255,23,14,168,39,12,160,67,253,255,251,
  14,168,195,2,192,91,15,168,39,12,160,67,253,255,203,14,168,195,2,192,203,14,168,39,12,160,129,253,255,23,14,168,
  129,2,192,23,14,168,39,12,160,193,255,255,23,14,168,65,0,192,23,14,168,39,12,160,131,253,255,251,14,168,131,2,
  192,91,15,168,39,12,160,65,253,255,23,14,168,193,2,192,23,14,168,39,12,160,131,253,255,203,14,168,131,2,192,203,
  14,168,39,12,160,193,253,255,23,14,168,65,2,192,23,14,168,39,12,160,0,0,21,20,0,0,242,0,0,32,128,18,
  175,146,145,194,170,192,128,128,21,36,128,20,223,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,
  64,0,0,64,1,0,0,227,18,160,194,170,192,128,128,21,36,128,20,223,0,0,194,45,193,128,128,21,36,128,20,130,
  0,0,31,128,9,38,0,0,48,0,21,20,0,0,242,0,0,32,128,18,187,210,145,0,0,64,96,11,168,39,1,168,
  94,29,168,231,8,168,6,0,192,132,170,192,15,0,192,132,45,193,15,0,192,132,37,192,242,0,0,32,128,18,115,149,
  145,78,5,192,4,0,0,2,16,192,0,128,2,187,211,145,194,137,192,0,128,21,36,128,20,242,0,0,68,244,193,47,
  0,0,4,0,0,130,7,192,0,128,2,0,128,11,35,0,0,130,198,193,48,128,21,37,128,20,106,0,0,2,202,193,
  48,128,21,37,128,20,109,0,0,130,39,192,0,128,21,36,128,20,242,0,0,0,128,11,48,128,17,131,205,193,48,128,
  21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,9,30,0,0,130,27,192,16,128,20,51,147,145,4,37,192,254,
  0,0,196,32,192,242,0,0,32,128,18,75,212,145,129,2,192,0,0,21,20,0,0,242,0,0,32,128,18,75,148,145,
  2,59,192,16,128,21,37,128,20,66,239,193,96,128,21,36,128,20,0,128,5,75,148,145,194,170,192,128,128,21,36,128,
  20,15,0,192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,4,33,192,242,0,0,32,128,18,103,
  212,145,74,0,192,131,2,192,179,18,168,68,33,192,242,0,0,32,128,18,139,212,145,138,0,192,65,5,192,115,18,168,
  193,4,192,115,18,168,132,33,192,242,0,0,32,128,18,199,212,145,202,0,192,193,2,192,115,18,168,129,2,192,115,18,
  168,65,2,192,115,18,168,193,253,255,115,18,168,65,253,255,115,18,168,196,33,192,242,0,0,32,128,18,11,213,145,10,
  1,192,193,2,192,115,18,168,129,2,192,115,18,168,65,2,192,115,18,168,65,0,192,115,18,168,193,255,255,115,18,168,
  129,253,255,115,18,168,4,34,192,242,0,0,32,128,18,63,213,145,74,1,192,195,2,192,179,18,168,67,2,192,179,18,
  168,195,253,255,179,18,168,67,253,255,179,18,168,68,34,192,242,0,0,32,128,18,115,213,145,138,1,192,131,2,192,179,
  18,168,67,0,192,179,18,168,195,255,255,179,18,168,131,253,255,179,18,168,132,37,192,143,0,0,0,0,64,194,170,192,
  128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,64,194,170,192,128,128,
  21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,64,2,
  105,192,16,128,21,36,128,20,242,0,0,208,128,82,2,105,192,16,128,21,36,128,20,242,0,0,224,128,82,2,105,192,
  16,128,21,36,128,20,242,0,0,208,128,18,127,149,145,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,79,150,
  145,215,21,168,127,149,145,68,244,193,242,0,0,32,128,18,79,214,145,48,128,20,127,149,145,0,0,64,0,0,21,20,
  0,0,2,48,192,0,128,2,199,150,145,68,244,193,242,0,0,32,128,18,127,214,145,48,128,20,167,150,145,235,21,168,
  255,213,145,130,12,192,16,128,20,159,150,144,130,12,192,0,128,20,255,213,144,167,21,168,255,21,160,130,12,192,16,128,
  20,191,150,144,130,12,192,0,128,20,127,213,144,167,21,168,127,21,160,0,0,64,0,0,21,20,0,0,2,48,192,0,
  128,2,47,151,145,68,244,193,242,0,0,32,128,18,247,214,145,48,128,20,19,151,145,235,21,168,47,215,145,130,12,192,
  16,128,20,255,213,144,167,21,168,255,21,160,130,12,192,16,128,20,127,213,144,167,21,168,130,7,192,16,128,20,127,213,
  144,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,139,151,145,68,244,193,242,0,0,32,128,18,111,151,145,235,
  21,168,255,213,145,130,12,192,16,128,20,167,149,144,0,0,64,130,12,192,16,128,20,127,213,144,167,21,168,2,10,192,
  16,128,20,127,213,144,0,0,64,1,0,0,68,244,193,242,0,0,32,128,18,211,151,145,171,23,160,255,21,168,48,0,
  21,20,0,0,242,0,0,32,128,18,167,215,145,2,48,192,0,128,2,255,213,145,0,0,64,127,21,168,48,0,21,20,
  0,0,242,0,0,32,128,18,207,215,145,2,48,192,0,128,2,127,213,145,0,0,64,1,0,0,68,244,193,242,0,0,
  32,128,18,123,152,145,43,24,160,130,12,192,16,128,20,39,216,144,235,21,168,43,216,145,167,21,168,255,21,168,48,0,
  21,20,0,0,242,0,0,32,128,18,15,216,145,2,48,192,0,128,2,175,152,145,130,12,192,16,128,20,255,213,144,235,
  21,168,175,216,145,167,21,168,255,21,160,130,12,192,16,128,20,119,216,144,167,21,168,127,21,168,48,0,21,20,0,0,
  242,0,0,32,128,18,103,216,145,2,48,192,0,128,2,175,152,145,130,12,192,16,128,20,127,213,144,167,21,168,127,21,
  160,0,0,64,1,0,0,130,12,192,16,128,20,75,217,144,68,244,193,242,0,0,32,128,18,39,153,145,231,24,160,235,
  21,168,231,216,145,255,21,168,167,21,168,48,0,21,20,0,0,242,0,0,32,128,18,215,216,145,2,48,192,0,128,2,
  175,153,145,235,21,168,175,217,145,215,21,168,167,213,145,167,21,168,127,21,160,167,21,168,127,21,168,48,0,21,20,0,
  0,242,0,0,32,128,18,31,217,145,2,48,192,0,128,2,23,217,145,0,0,64,68,244,193,242,0,0,32,128,18,143,
  153,145,103,25,160,215,21,168,127,149,145,48,0,21,20,0,0,242,0,0,32,128,18,95,217,145,2,48,192,0,128,2,
  255,213,145,0,0,64,127,21,168,48,0,21,20,0,0,242,0,0,32,128,18,139,217,145,2,48,192,0,128,2,127,213,
  145,0,0,64,1,0,0,68,244,193,242,0,0,32,128,18,239,217,145,2,16,192,0,128,4,75,154,145,0,0,64,130,
  12,192,16,128,20,239,217,144,235,21,168,239,217,145,167,21,168,48,0,21,20,0,0,242,0,0,32,128,18,215,217,145,
  2,48,192,0,128,2,135,154,145,130,12,192,16,128,20,255,213,144,235,21,168,255,213,145,167,21,168,255,21,160,130,12,
  192,16,128,20,71,218,144,167,21,168,130,7,192,16,128,20,135,154,144,127,21,168,48,0,21,20,0,0,242,0,0,32,
  128,18,43,218,145,2,48,192,0,128,2,135,154,145,130,12,192,16,128,20,127,213,144,167,21,168,130,7,192,16,128,20,
  127,213,144,0,0,64,1,0,0,48,0,21,20,0,0,2,48,192,0,128,2,187,154,145,66,72,192,16,128,21,36,128,
  20,0,128,5,187,154,145,127,21,168,1,0,0,48,0,20,20,0,0,2,48,192,0,128,2,235,154,145,66,72,192,16,
  128,21,36,128,20,0,128,5,235,154,145,127,21,168,0,0,64,129,253,255,3,16,192,203,22,168,187,19,160,131,253,255,
  179,25,168,187,19,160,193,250,255,51,23,168,65,251,255,51,23,168,187,19,160,65,253,255,3,8,192,83,22,168,193,2,
  192,3,8,192,83,22,168,129,253,255,3,16,192,83,22,168,193,253,255,3,24,192,83,22,168,65,2,192,3,24,192,83,
  22,168,187,19,160,65,253,255,3,8,192,27,22,168,129,2,192,3,16,192,27,22,168,129,253,255,3,16,192,27,22,168,
  193,253,255,3,24,192,27,22,168,193,255,255,3,32,192,27,22,168,65,0,192,3,32,192,27,22,168,187,19,160,67,253,
  255,247,23,168,195,2,192,179,24,168,195,253,255,247,23,168,67,2,192,179,24,168,187,19,160,129,253,255,3,16,192,27,
  22,168,193,255,255,3,32,192,27,22,168,65,0,192,3,32,192,27,22,168,129,2,192,3,16,192,27,22,168,67,253,255,
  143,23,168,195,2,192,143,23,168,195,253,255,143,23,168,67,2,192,143,23,168,187,19,160,131,253,255,247,23,168,131,2,
  192,179,24,168,195,255,255,179,24,168,67,0,192,179,24,168,187,19,160,65,253,255,3,8,192,27,22,168,193,253,255,3,
  24,192,27,22,168,65,2,192,3,24,192,27,22,168,193,2,192,3,8,192,27,22,168,131,253,255,143,23,168,131,2,192,
  143,23,168,195,255,255,143,23,168,67,0,192,143,23,168,187,19,160,68,244,193,242,0,0,32,128,18,187,211,145,68,244,
  193,2,8,192,0,128,4,195,220,145,195,2,192,139,26,168,68,244,193,2,16,192,0,128,4,219,220,145,131,2,192,139,
  26,168,68,244,193,2,24,192,0,128,4,243,220,145,67,2,192,139,26,168,68,244,193,2,32,192,0,128,4,11,221,145,
  67,0,192,139,26,168,187,19,160,65,253,255,3,8,192,83,22,168,193,2,192,3,8,192,83,22,168,187,19,160,129,253,
  255,3,16,192,83,22,168,187,19,160,65,253,255,3,8,192,27,22,168,187,19,160,129,253,255,3,16,192,27,22,168,129,
  2,192,3,16,192,27,22,168,187,19,160,193,253,255,3,24,192,27,22,168,187,19,160,67,253,255,247,23,168,195,2,192,
  179,24,168,187,19,160,67,253,255,143,23,168,195,2,192,143,23,168,187,19,160,129,253,255,3,16,192,27,22,168,129,2,
  192,3,16,192,27,22,168,187,19,160,193,255,255,3,32,192,27,22,168,65,0,192,3,32,192,27,22,168,187,19,160,131,
  253,255,247,23,168,131,2,192,179,24,168,187,19,160,65,253,255,3,8,192,27,22,168,193,2,192,3,8,192,27,22,168,
  187,19,160,131,253,255,143,23,168,131,2,192,143,23,168,187,19,160,193,253,255,3,24,192,27,22,168,65,2,192,3,24,
  192,27,22,168,187,19,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  129,170,192,194,32,192,3,30,222,20,0,9,63,128,8,12,128,145,65,203,192,194,32,192,3,30,222,20,0,9,63,128,
  8,36,128,145,1,111,193,194,32,192,3,0,192,20,0,9,63,128,8,60,128,145,68,209,193,254,0,0,130,39,192,0,
  128,21,36,128,20,0,128,5,152,128,145,194,143,193,0,128,21,36,128,20,250,0,0,4,0,0,130,7,192,0,128,2,
  0,128,11,3,61,193,48,128,21,37,0,0,104,0,0,0,0,128,66,209,193,0,128,21,36,128,20,254,128,21,80,128,
  145,68,34,192,2,0,192,0,128,5,24,193,145,138,21,192,78,5,192,4,0,0,1,0,192,0,0,5,0,1,145,129,
  21,192,194,12,193,0,128,21,36,128,20,2,192,255,0,128,2,0,128,15,32,0,20,0,1,144,1,0,0,36,58,168,
  1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,196,0,145,4,34,192,2,0,192,0,128,5,132,193,145,138,20,
  192,78,5,192,4,0,0,1,0,192,0,0,5,108,1,145,129,20,192,194,12,193,0,128,21,36,128,20,2,192,255,0,
  128,2,0,128,15,32,0,20,108,1,144,1,0,0,0,58,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,
  48,1,145,196,33,192,2,0,192,0,128,5,240,193,145,10,15,192,78,5,192,4,0,0,1,0,192,0,0,5,216,1,
  145,1,15,192,194,12,193,0,128,21,36,128,20,2,192,255,0,128,2,0,128,15,32,0,20,216,1,144,1,0,0,244,
  56,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,156,1,145,132,33,192,2,0,192,0,128,5,92,194,145,
  138,14,192,78,5,192,4,0,0,1,0,192,0,0,5,68,2,145,129,14,192,194,12,193,0,128,21,36,128,20,2,192,
  255,0,128,2,0,128,15,32,0,20,68,2,144,1,0,0,20,56,168,1,0,0,0,0,9,30,0,0,131,27,192,48,
  0,20,8,2,145,68,33,192,2,0,192,0,128,5,200,194,145,138,8,192,78,10,192,4,0,0,1,0,192,0,0,5,
  176,2,145,129,8,192,194,12,193,0,128,21,36,128,20,2,192,255,0,128,2,0,128,15,32,0,20,176,2,144,1,0,
  0,184,55,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,116,2,145,4,33,192,2,0,192,0,128,5,52,
  195,145,10,8,192,206,7,192,4,0,0,1,0,192,0,0,5,28,3,145,1,8,192,194,12,193,0,128,21,36,128,20,
  2,192,255,0,128,2,0,128,15,32,0,20,28,3,144,1,0,0,172,55,168,1,0,0,0,0,9,30,0,0,131,27,
  192,48,0,20,224,2,145,196,32,192,1,0,192,0,0,5,192,67,145,10,2,192,206,7,192,4,0,0,1,0,192,0,
  0,5,168,3,145,2,59,192,0,128,21,37,128,20,66,239,193,96,128,21,36,128,20,0,128,5,168,131,145,1,2,192,
  194,12,193,0,128,21,36,128,20,2,192,255,0,128,2,0,128,15,32,0,20,168,3,144,1,0,0,124,55,168,1,0,
  0,0,0,9,30,0,0,131,27,192,48,0,20,76,3,145,0,0,64,2,236,192,16,128,21,36,128,20,2,192,255,0,
  128,2,0,128,15,35,0,0,210,0,0,48,128,84,0,0,21,20,0,0,2,48,192,0,128,2,8,132,145,196,35,168,
  8,132,144,0,0,128,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,60,132,145,66,72,192,16,128,21,36,128,
  20,2,0,224,0,128,2,60,132,145,0,0,128,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,194,167,192,16,
  128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,130,108,193,16,128,21,36,128,20,79,0,192,2,168,192,
  16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,194,108,193,16,128,21,36,128,20,79,0,192,66,168,
  192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,194,110,193,16,128,21,36,128,20,79,0,192,66,
  170,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,66,111,193,16,128,21,36,128,20,79,0,192,
  194,170,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,66,113,193,16,128,21,36,128,20,79,0,
  192,194,172,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,130,113,193,16,128,21,36,128,20,79,
  0,192,2,173,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,194,113,193,16,128,21,36,128,20,
  79,0,192,66,173,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,194,105,193,16,128,21,36,128,
  20,79,0,192,66,165,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,66,106,193,16,128,21,36,
  128,20,79,0,192,194,165,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,29,0,0,128,0,21,
  2,111,193,16,128,21,36,128,20,79,0,192,130,170,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,
  0,194,12,193,16,128,21,36,128,20,2,192,255,0,128,2,0,128,15,35,0,0,210,0,0,48,128,20,100,134,144,20,
  0,0,2,56,192,0,128,2,252,197,145,225,0,64,29,0,0,128,0,21,2,111,193,16,128,21,36,128,20,79,0,192,
  66,203,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,12,193,16,128,21,36,128,20,2,192,
  255,0,128,2,0,128,15,35,0,0,210,0,0,48,128,20,212,134,144,20,0,0,2,56,192,0,128,2,108,198,145,225,
  0,64,129,253,255,136,1,201,232,35,168,152,32,160,1,0,0,131,253,255,48,0,21,20,0,0,2,56,192,0,128,2,
  236,198,145,2,8,192,0,128,2,28,199,145,196,35,168,28,135,144,32,48,168,152,32,160,193,250,255,200,2,201,232,35,
  168,65,251,255,200,2,201,232,35,168,152,32,160,65,253,255,136,3,201,232,35,168,129,253,255,136,3,201,232,35,168,193,
  253,255,136,3,201,232,35,168,65,2,192,136,3,201,232,35,168,193,2,192,136,3,201,232,35,168,152,32,160,65,253,255,
  8,5,201,232,35,168,129,253,255,72,6,201,232,35,168,193,253,255,72,7,201,232,35,168,193,255,255,136,8,201,232,35,
  168,65,0,192,136,9,201,232,35,168,129,2,192,136,10,201,232,35,168,152,32,160,1,0,0,220,39,160,196,35,168,220,
  135,144,192,48,168,67,253,255,48,0,21,20,0,0,2,56,192,0,128,2,208,199,145,2,8,192,0,128,2,12,200,145,
  196,35,168,12,136,144,184,48,168,1,0,0,32,40,160,196,35,168,32,136,144,224,48,168,195,253,255,48,0,21,20,0,
  0,2,56,192,0,128,2,20,200,145,2,8,192,0,128,2,80,200,145,196,35,168,80,136,144,216,48,168,1,0,0,100,
  40,160,196,35,168,100,136,144,0,49,168,67,2,192,48,0,21,20,0,0,2,56,192,0,128,2,88,200,145,2,8,192,
  0,128,2,148,200,145,196,35,168,148,136,144,248,48,168,1,0,0,168,40,160,196,35,168,168,136,144,32,49,168,195,2,
  192,48,0,21,20,0,0,2,56,192,0,128,2,156,200,145,2,8,192,0,128,2,216,200,145,196,35,168,216,136,144,24,
  49,168,152,32,160,193,243,193,66,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,108,193,0,128,21,
  36,128,20,243,0,0,20,0,0,63,0,9,194,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,110,
  193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,111,193,0,128,21,36,128,20,243,0,0,20,0,0,63,
  0,9,66,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,113,193,0,128,21,36,128,20,243,0,0,
  20,0,0,63,0,9,194,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,1,0,0,180,41,160,196,35,
  168,180,137,144,64,49,168,67,253,255,48,0,21,20,0,0,2,56,192,0,128,2,168,201,145,2,8,192,0,128,2,228,
  201,145,196,35,168,228,137,144,56,49,168,1,0,0,248,41,160,196,35,168,248,137,144,112,49,168,195,253,255,48,0,21,
  20,0,0,2,56,192,0,128,2,236,201,145,2,8,192,0,128,2,40,202,145,196,35,168,40,138,144,104,49,168,1,0,
  0,60,42,160,196,35,168,60,138,144,160,49,168,67,2,192,48,0,21,20,0,0,2,56,192,0,128,2,48,202,145,2,
  8,192,0,128,2,108,202,145,196,35,168,108,138,144,152,49,168,1,0,0,128,42,160,196,35,168,128,138,144,208,49,168,
  195,2,192,48,0,21,20,0,0,2,56,192,0,128,2,116,202,145,2,8,192,0,128,2,176,202,145,196,35,168,176,138,
  144,200,49,168,129,253,255,136,31,201,232,35,168,193,255,255,136,31,201,232,35,168,65,0,192,136,31,201,232,35,168,129,
  2,192,136,31,201,232,35,168,193,243,193,20,0,0,243,0,9,66,108,193,0,128,21,36,128,20,63,0,0,20,0,0,
  243,0,9,130,108,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,108,193,0,128,21,36,128,20,63,0,
  0,20,0,0,243,0,9,194,110,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,66,111,193,0,128,21,36,
  128,20,63,0,0,20,0,0,243,0,9,66,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,113,193,
  0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,113,193,0,128,21,36,128,20,63,0,0,152,32,160,1,0,
  0,188,43,160,196,35,168,188,139,144,52,50,168,131,253,255,48,0,21,20,0,0,2,56,192,0,128,2,176,203,145,2,
  8,192,0,128,2,236,203,145,196,35,168,236,139,144,44,50,168,1,0,0,0,44,160,196,35,168,0,140,144,84,50,168,
  195,255,255,48,0,21,20,0,0,2,56,192,0,128,2,244,203,145,2,8,192,0,128,2,48,204,145,196,35,168,48,140,
  144,76,50,168,1,0,0,68,44,160,196,35,168,68,140,144,116,50,168,67,0,192,48,0,21,20,0,0,2,56,192,0,
  128,2,56,204,145,2,8,192,0,128,2,116,204,145,196,35,168,116,140,144,108,50,168,1,0,0,136,44,160,196,35,168,
  136,140,144,148,50,168,131,2,192,48,0,21,20,0,0,2,56,192,0,128,2,124,204,145,2,8,192,0,128,2,184,204,
  145,196,35,168,184,140,144,140,50,168,152,32,160,193,243,193,66,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,
  0,9,130,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,108,193,0,128,21,36,128,20,243,0,0,
  20,0,0,63,0,9,194,110,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,111,193,0,128,21,36,128,
  20,243,0,0,20,0,0,63,0,9,66,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,113,193,0,
  128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,
  1,0,0,148,45,160,196,35,168,148,141,144,180,50,168,131,253,255,48,0,21,20,0,0,2,56,192,0,128,2,136,205,
  145,2,8,192,0,128,2,196,205,145,196,35,168,196,141,144,172,50,168,1,0,0,216,45,160,196,35,168,216,141,144,228,
  50,168,195,255,255,48,0,21,20,0,0,2,56,192,0,128,2,204,205,145,2,8,192,0,128,2,8,206,145,196,35,168,
  8,142,144,220,50,168,1,0,0,28,46,160,196,35,168,28,142,144,20,51,168,67,0,192,48,0,21,20,0,0,2,56,
  192,0,128,2,16,206,145,2,8,192,0,128,2,76,206,145,196,35,168,76,142,144,12,51,168,1,0,0,96,46,160,196,
  35,168,96,142,144,68,51,168,131,2,192,48,0,21,20,0,0,2,56,192,0,128,2,84,206,145,2,8,192,0,128,2,
  144,206,145,196,35,168,144,142,144,60,51,168,65,253,255,200,54,201,232,35,168,193,253,255,136,60,201,232,35,168,65,2,
  192,72,66,201,232,35,168,193,2,192,8,72,201,232,35,168,193,243,193,20,0,0,243,0,9,66,108,193,0,128,21,36,
  128,20,63,0,0,20,0,0,243,0,9,130,108,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,108,193,
  0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,110,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,
  9,66,111,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,66,113,193,0,128,21,36,128,20,63,0,0,20,
  0,0,243,0,9,130,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,113,193,0,128,21,36,128,20,
  63,0,0,152,32,160,65,253,255,200,77,201,12,36,168,129,253,255,8,84,201,12,36,168,193,253,255,72,88,201,12,36,
  168,193,255,255,136,94,201,12,36,168,65,0,192,200,98,201,12,36,168,65,2,192,8,103,201,12,36,168,129,2,192,72,
  109,201,12,36,168,193,2,192,136,113,201,12,36,168,152,32,160,2,111,193,0,128,21,36,128,20,79,0,192,130,170,192,
  0,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,108,36,168,0,0,64,134,253,255,248,37,168,0,0,
  64,160,37,168,204,37,168,0,0,64,64,36,168,108,36,168,152,36,168,28,37,168,116,37,168,0,0,64,64,36,168,108,
  36,168,152,36,168,196,36,168,0,0,64,64,36,168,108,36,168,72,37,168,0,0,64,64,36,168,108,36,168,152,36,168,
  240,36,168,0,0,64,64,36,168,196,36,168,72,37,168,0,0,64,152,36,168,240,36,168,72,37,168,0,0,64,196,36,
  168,240,36,168,72,37,168,0,0,64,70,253,255,248,37,168,236,47,168,198,253,255,248,37,168,70,2,192,248,37,168,0,
  0,64,198,253,255,248,37,168,236,47,168,70,253,255,248,37,168,198,2,192,248,37,168,0,0,64,70,2,192,248,37,168,
  236,47,168,70,253,255,248,37,168,198,2,192,248,37,168,0,0,64,198,2,192,248,37,168,236,47,168,198,253,255,248,37,
  168,70,2,192,248,37,168,0,0,64,70,253,255,248,37,168,236,47,168,108,36,168,196,36,168,240,36,168,72,37,168,198,
  253,255,248,37,168,70,2,192,248,37,168,0,0,64,198,253,255,248,37,168,236,47,168,108,36,168,196,36,168,240,36,168,
  72,37,168,70,253,255,248,37,168,198,2,192,248,37,168,0,0,64,70,2,192,248,37,168,236,47,168,108,36,168,196,36,
  168,240,36,168,72,37,168,70,253,255,248,37,168,198,2,192,248,37,168,0,0,64,198,2,192,248,37,168,236,47,168,108,
  36,168,196,36,168,240,36,168,72,37,168,198,253,255,248,37,168,70,2,192,248,37,168,0,0,64,108,36,168,196,36,168,
  240,36,168,72,37,168,70,253,255,248,37,168,198,253,255,248,37,168,70,2,192,248,37,168,198,2,192,248,37,168,0,0,
  64,134,253,255,248,37,168,236,47,168,198,255,255,248,37,168,70,0,192,248,37,168,0,0,64,198,255,255,248,37,168,236,
  47,168,134,253,255,248,37,168,134,2,192,248,37,168,0,0,64,70,0,192,248,37,168,236,47,168,134,253,255,248,37,168,
  134,2,192,248,37,168,0,0,64,134,2,192,248,37,168,236,47,168,198,255,255,248,37,168,70,0,192,248,37,168,0,0,
  64,134,253,255,248,37,168,236,47,168,64,36,168,152,36,168,28,37,168,116,37,168,198,255,255,248,37,168,70,0,192,248,
  37,168,0,0,64,198,255,255,248,37,168,236,47,168,64,36,168,152,36,168,28,37,168,116,37,168,134,253,255,248,37,168,
  134,2,192,248,37,168,0,0,64,70,0,192,248,37,168,236,47,168,64,36,168,152,36,168,28,37,168,116,37,168,134,253,
  255,248,37,168,134,2,192,248,37,168,0,0,64,134,2,192,248,37,168,236,47,168,64,36,168,152,36,168,28,37,168,116,
  37,168,198,255,255,248,37,168,70,0,192,248,37,168,0,0,64,64,36,168,116,37,168,130,253,255,0,128,21,36,128,20,
  0,128,5,140,211,145,152,36,168,194,255,255,0,128,21,36,128,20,0,128,5,164,211,145,28,37,168,134,253,255,248,37,
  168,198,255,255,248,37,168,70,0,192,248,37,168,134,2,192,248,37,168,0,0,64,152,36,168,28,37,168,130,253,255,0,
  128,21,36,128,20,0,128,5,232,211,145,64,36,168,66,0,192,0,128,21,36,128,20,0,128,5,0,212,145,116,37,168,
  134,253,255,248,37,168,198,255,255,248,37,168,70,0,192,248,37,168,134,2,192,248,37,168,0,0,64,152,36,168,28,37,
  168,130,2,192,0,128,21,36,128,20,0,128,5,68,212,145,116,37,168,194,255,255,0,128,21,36,128,20,0,128,5,92,
  212,145,64,36,168,134,253,255,248,37,168,198,255,255,248,37,168,70,0,192,248,37,168,134,2,192,248,37,168,0,0,64,
  64,36,168,116,37,168,130,2,192,0,128,21,36,128,20,0,128,5,160,212,145,28,37,168,66,0,192,0,128,21,36,128,
  20,0,128,5,184,212,145,152,36,168,134,253,255,248,37,168,198,255,255,248,37,168,70,0,192,248,37,168,134,2,192,248,
  37,168,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,130,108,193,16,128,21,36,128,20,79,0,192,194,108,193,
  16,128,21,36,128,20,79,0,192,194,110,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,0,
  192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,130,108,193,16,
  128,21,36,128,20,79,0,192,194,108,193,16,128,21,36,128,20,79,0,192,130,113,193,16,128,21,36,128,20,79,0,192,
  0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,130,108,193,16,128,21,36,128,20,79,0,192,194,108,193,16,128,
  21,36,128,20,79,0,192,194,110,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,0,192,194,
  113,193,16,128,21,36,128,20,79,0,192,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,194,110,193,16,128,21,
  36,128,20,79,0,192,66,111,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,0,192,0,0,
  64,194,108,193,16,128,21,36,128,20,79,0,192,194,110,193,16,128,21,36,128,20,79,0,192,66,111,193,16,128,21,36,
  128,20,79,0,192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,
  194,108,193,16,128,21,36,128,20,79,0,192,194,110,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,
  20,79,0,192,130,113,193,16,128,21,36,128,20,79,0,192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,130,
  108,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,0,192,130,113,193,16,128,21,36,128,20,
  79,0,192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,194,108,
  193,16,128,21,36,128,20,79,0,192,66,111,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,
  0,192,130,113,193,16,128,21,36,128,20,79,0,192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,130,108,193,
  16,128,21,36,128,20,79,0,192,194,200,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,0,0,
  64,134,253,255,104,38,168,0,0,64,194,105,193,16,128,21,36,128,20,79,0,192,2,198,192,16,128,21,36,128,20,2,
  192,255,0,128,2,208,128,17,47,0,0,66,106,193,16,128,21,36,128,20,79,0,192,130,198,192,16,128,21,36,128,20,
  2,192,255,0,128,2,208,128,17,47,0,0,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,130,200,192,16,128,
  21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,130,108,193,16,128,21,36,128,20,79,0,192,194,200,192,16,
  128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,108,193,16,128,21,36,128,20,79,0,192,2,201,192,
  16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,66,113,193,16,128,21,36,128,20,79,0,192,130,205,
  192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,113,193,16,128,21,36,128,20,79,0,192,2,
  206,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,0,0,64,66,108,193,16,128,21,36,128,20,
  79,0,192,130,200,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,130,108,193,16,128,21,36,128,
  20,79,0,192,194,200,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,108,193,16,128,21,36,
  128,20,79,0,192,2,201,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,110,193,16,128,21,
  36,128,20,79,0,192,2,203,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,66,111,193,16,128,
  21,36,128,20,79,0,192,130,203,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,130,113,193,16,
  128,21,36,128,20,79,0,192,194,205,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,0,0,64,
  70,253,255,104,38,168,198,253,255,104,38,168,70,2,192,104,38,168,198,2,192,104,38,168,0,0,64,134,253,255,104,38,
  168,198,255,255,104,38,168,70,0,192,104,38,168,134,2,192,104,38,168,0,0,64,132,209,193,254,0,0,130,39,192,0,
  128,21,36,128,20,0,128,5,152,154,145,194,143,193,0,128,21,36,128,20,250,0,0,4,0,0,130,7,192,0,128,2,
  0,128,11,3,65,193,48,128,21,37,0,0,104,0,0,0,0,128,66,209,193,0,128,21,36,128,20,254,128,21,80,154,
  145,68,36,192,2,0,192,0,128,5,20,219,145,138,21,192,78,5,192,4,0,0,1,0,192,0,0,5,252,26,145,129,
  21,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,252,26,144,1,0,0,237,54,168,1,0,0,
  0,0,9,30,0,0,131,27,192,48,0,20,196,26,145,4,36,192,2,0,192,0,128,5,124,219,145,138,20,192,78,5,
  192,4,0,0,1,0,192,0,0,5,100,27,145,129,20,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,
  0,20,100,27,144,1,0,0,201,54,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,44,27,145,196,35,192,
  2,0,192,0,128,5,228,219,145,10,15,192,78,5,192,4,0,0,1,0,192,0,0,5,204,27,145,1,15,192,194,12,
  193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,204,27,144,1,0,0,93,53,168,1,0,0,0,0,9,30,
  0,0,131,27,192,48,0,20,148,27,145,132,35,192,2,0,192,0,128,5,76,220,145,138,14,192,78,5,192,4,0,0,
  1,0,192,0,0,5,52,28,145,129,14,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,52,28,
  144,1,0,0,45,52,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,252,27,145,68,35,192,2,0,192,0,
  128,5,180,220,145,138,8,192,78,5,192,4,0,0,1,0,192,0,0,5,156,28,145,129,8,192,194,12,193,0,128,21,
  36,128,20,194,63,192,0,128,2,32,0,20,156,28,144,1,0,0,177,51,168,1,0,0,0,0,9,30,0,0,131,22,
  192,48,0,20,100,28,145,4,35,192,2,0,192,0,128,5,28,221,145,10,8,192,78,5,192,4,0,0,1,0,192,0,
  0,5,4,29,145,1,8,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,4,29,144,1,0,0,
  165,51,168,1,0,0,0,0,9,30,0,0,3,25,192,48,0,20,204,28,145,196,34,192,1,0,192,0,0,5,164,93,
  145,10,2,192,78,5,192,4,0,0,1,0,192,0,0,5,140,29,145,2,59,192,0,128,21,37,128,20,130,241,193,96,
  128,21,36,128,20,0,128,5,140,157,145,1,2,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,
  140,29,144,1,0,0,101,51,168,1,0,0,0,0,9,30,0,0,3,25,192,48,0,20,52,29,145,0,0,64,2,236,
  192,16,128,21,36,128,20,194,63,192,0,128,2,35,0,0,210,0,0,48,128,84,0,0,21,20,0,0,2,40,192,0,
  128,2,232,157,145,168,61,168,232,157,144,0,0,128,0,0,64,0,0,21,20,0,0,2,40,192,0,128,2,28,158,145,
  66,72,192,16,128,21,36,128,20,2,32,192,0,128,2,28,158,145,0,0,128,0,0,64,194,113,193,16,128,21,36,128,
  20,2,64,192,0,128,1,47,0,0,66,173,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,
  128,15,47,0,64,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,173,192,16,128,21,36,128,20,
  194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,66,113,193,16,128,21,36,128,20,2,64,192,0,128,
  1,47,0,0,194,172,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,66,
  111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,170,192,16,128,21,36,128,20,194,63,192,0,128,2,
  0,128,15,208,128,17,0,128,15,47,0,64,194,110,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,170,
  192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,194,108,193,16,128,21,36,
  128,20,2,64,192,0,128,1,47,0,0,66,168,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,
  0,128,15,47,0,64,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,168,192,16,128,21,36,128,
  20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,66,108,193,16,128,21,36,128,20,2,64,192,0,
  128,1,47,0,0,194,167,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,
  66,116,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,175,192,16,128,21,36,128,20,194,63,192,0,128,
  2,0,128,15,208,128,17,0,128,15,47,0,64,194,115,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,
  175,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,29,0,0,128,0,21,
  2,111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,170,192,16,128,21,36,128,20,194,63,192,0,128,
  2,0,128,15,208,128,17,0,128,15,47,0,0,194,12,193,16,128,21,36,128,20,194,63,192,0,128,2,35,0,0,210,
  0,0,48,128,20,241,128,144,20,0,0,2,56,192,0,128,2,125,192,145,225,0,64,29,0,0,128,0,21,2,111,193,
  16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,203,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,
  15,208,128,17,0,128,15,47,0,0,194,12,193,16,128,21,36,128,20,194,63,192,0,128,2,35,0,0,210,0,0,48,
  128,20,109,129,144,20,0,0,2,56,192,0,128,2,249,192,145,225,0,64,129,2,192,8,172,202,200,61,168,152,58,160,
  1,0,0,131,2,192,48,0,21,20,0,0,2,56,192,0,128,2,133,193,145,2,16,192,0,128,2,181,193,145,168,61,
  168,181,129,144,201,42,168,152,58,160,65,5,192,72,173,202,200,61,168,193,4,192,72,173,202,200,61,168,152,58,160,193,
  2,192,8,174,202,200,61,168,129,2,192,8,174,202,200,61,168,65,2,192,8,174,202,200,61,168,193,253,255,8,174,202,
  200,61,168,65,253,255,8,174,202,200,61,168,152,58,160,193,2,192,136,175,202,200,61,168,129,2,192,200,176,202,200,61,
  168,65,2,192,200,177,202,200,61,168,65,0,192,8,179,202,200,61,168,193,255,255,8,180,202,200,61,168,129,253,255,8,
  181,202,200,61,168,152,58,160,1,0,0,117,34,160,168,61,168,117,130,144,105,43,168,195,2,192,48,0,21,20,0,0,
  2,56,192,0,128,2,105,194,145,2,16,192,0,128,2,165,194,145,168,61,168,165,130,144,97,43,168,1,0,0,185,34,
  160,168,61,168,185,130,144,137,43,168,67,2,192,48,0,21,20,0,0,2,56,192,0,128,2,173,194,145,2,16,192,0,
  128,2,233,194,145,168,61,168,233,130,144,129,43,168,1,0,0,253,34,160,168,61,168,253,130,144,169,43,168,195,253,255,
  48,0,21,20,0,0,2,56,192,0,128,2,241,194,145,2,16,192,0,128,2,45,195,145,168,61,168,45,131,144,161,43,
  168,1,0,0,65,35,160,168,61,168,65,131,144,201,43,168,67,253,255,48,0,21,20,0,0,2,56,192,0,128,2,53,
  195,145,2,16,192,0,128,2,113,195,145,168,61,168,113,131,144,193,43,168,152,58,160,193,243,193,194,113,193,0,128,21,
  36,128,20,243,0,0,20,0,0,63,0,9,130,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,113,
  193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,111,193,0,128,21,36,128,20,243,0,0,20,0,0,63,
  0,9,194,110,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,108,193,0,128,21,36,128,20,243,0,0,
  20,0,0,63,0,9,130,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,108,193,0,128,21,36,128,
  20,243,0,0,20,0,0,63,0,9,1,0,0,77,36,160,168,61,168,77,132,144,233,43,168,195,2,192,48,0,21,20,
  0,0,2,56,192,0,128,2,65,196,145,2,16,192,0,128,2,125,196,145,168,61,168,125,132,144,225,43,168,1,0,0,
  145,36,160,168,61,168,145,132,144,25,44,168,67,2,192,48,0,21,20,0,0,2,56,192,0,128,2,133,196,145,2,16,
  192,0,128,2,193,196,145,168,61,168,193,132,144,17,44,168,1,0,0,213,36,160,168,61,168,213,132,144,73,44,168,195,
  253,255,48,0,21,20,0,0,2,56,192,0,128,2,201,196,145,2,16,192,0,128,2,5,197,145,168,61,168,5,133,144,
  65,44,168,1,0,0,25,37,160,168,61,168,25,133,144,121,44,168,67,253,255,48,0,21,20,0,0,2,56,192,0,128,
  2,13,197,145,2,16,192,0,128,2,73,197,145,168,61,168,73,133,144,113,44,168,129,2,192,8,202,202,200,61,168,65,
  0,192,8,202,202,200,61,168,193,255,255,8,202,202,200,61,168,129,253,255,8,202,202,200,61,168,193,243,193,20,0,0,
  243,0,9,194,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,113,193,0,128,21,36,128,20,63,0,
  0,20,0,0,243,0,9,66,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,66,111,193,0,128,21,36,
  128,20,63,0,0,20,0,0,243,0,9,194,110,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,108,193,
  0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,108,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,
  9,66,108,193,0,128,21,36,128,20,63,0,0,152,58,160,1,0,0,85,38,160,168,61,168,85,134,144,221,44,168,131,
  2,192,48,0,21,20,0,0,2,56,192,0,128,2,73,198,145,2,16,192,0,128,2,133,198,145,168,61,168,133,134,144,
  213,44,168,1,0,0,153,38,160,168,61,168,153,134,144,253,44,168,67,0,192,48,0,21,20,0,0,2,56,192,0,128,
  2,141,198,145,2,16,192,0,128,2,201,198,145,168,61,168,201,134,144,245,44,168,1,0,0,221,38,160,168,61,168,221,
  134,144,29,45,168,195,255,255,48,0,21,20,0,0,2,56,192,0,128,2,209,198,145,2,16,192,0,128,2,13,199,145,
  168,61,168,13,135,144,21,45,168,1,0,0,33,39,160,168,61,168,33,135,144,61,45,168,131,253,255,48,0,21,20,0,
  0,2,56,192,0,128,2,21,199,145,2,16,192,0,128,2,81,199,145,168,61,168,81,135,144,53,45,168,152,58,160,193,
  243,193,194,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,113,193,0,128,21,36,128,20,243,0,0,
  20,0,0,63,0,9,66,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,111,193,0,128,21,36,128,
  20,243,0,0,20,0,0,63,0,9,194,110,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,108,193,0,
  128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,
  66,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,1,0,0,45,40,160,168,61,168,45,136,144,93,45,
  168,131,2,192,48,0,21,20,0,0,2,56,192,0,128,2,33,200,145,2,16,192,0,128,2,93,200,145,168,61,168,93,
  136,144,85,45,168,1,0,0,113,40,160,168,61,168,113,136,144,141,45,168,67,0,192,48,0,21,20,0,0,2,56,192,
  0,128,2,101,200,145,2,16,192,0,128,2,161,200,145,168,61,168,161,136,144,133,45,168,1,0,0,181,40,160,168,61,
  168,181,136,144,189,45,168,195,255,255,48,0,21,20,0,0,2,56,192,0,128,2,169,200,145,2,16,192,0,128,2,229,
  200,145,168,61,168,229,136,144,181,45,168,1,0,0,249,40,160,168,61,168,249,136,144,237,45,168,131,253,255,48,0,21,
  20,0,0,2,56,192,0,128,2,237,200,145,2,16,192,0,128,2,41,201,145,168,61,168,41,137,144,229,45,168,193,2,
  192,72,225,202,200,61,168,65,2,192,8,231,202,200,61,168,193,253,255,200,236,202,200,61,168,65,253,255,136,242,202,200,
  61,168,193,243,193,20,0,0,243,0,9,194,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,113,193,
  0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,66,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,
  9,66,111,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,110,193,0,128,21,36,128,20,63,0,0,20,
  0,0,243,0,9,194,108,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,108,193,0,128,21,36,128,20,
  63,0,0,20,0,0,243,0,9,66,108,193,0,128,21,36,128,20,63,0,0,152,58,160,193,2,192,72,248,202,236,61,
  168,129,2,192,136,1,203,236,61,168,65,2,192,200,7,203,236,61,168,65,0,192,8,17,203,236,61,168,193,255,255,72,
  23,203,236,61,168,193,253,255,136,29,203,236,61,168,129,253,255,200,38,203,236,61,168,65,253,255,8,45,203,236,61,168,
  152,58,160,2,111,193,0,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,170,192,0,128,21,36,128,20,194,63,
  192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,92,62,168,0,0,64,134,2,192,121,32,168,0,0,64,1,
  32,168,61,32,168,0,0,64,32,62,168,92,62,168,152,62,168,76,63,168,196,63,168,0,0,64,32,62,168,92,62,168,
  152,62,168,212,62,168,0,0,64,32,62,168,92,62,168,136,63,168,0,0,64,32,62,168,92,62,168,152,62,168,16,63,
  168,0,0,64,32,62,168,212,62,168,136,63,168,0,0,64,152,62,168,16,63,168,136,63,168,0,0,64,212,62,168,16,
  63,168,136,63,168,0,0,64,198,2,192,121,32,168,133,42,168,70,2,192,121,32,168,198,253,255,121,32,168,0,0,64,
  70,2,192,121,32,168,133,42,168,198,2,192,121,32,168,70,253,255,121,32,168,0,0,64,198,253,255,121,32,168,133,42,
  168,198,2,192,121,32,168,70,253,255,121,32,168,0,0,64,70,253,255,121,32,168,133,42,168,70,2,192,121,32,168,198,
  253,255,121,32,168,0,0,64,198,2,192,121,32,168,133,42,168,92,62,168,212,62,168,16,63,168,136,63,168,70,2,192,
  121,32,168,198,253,255,121,32,168,0,0,64,70,2,192,121,32,168,133,42,168,92,62,168,212,62,168,16,63,168,136,63,
  168,198,2,192,121,32,168,70,253,255,121,32,168,0,0,64,198,253,255,121,32,168,133,42,168,92,62,168,212,62,168,16,
  63,168,136,63,168,198,2,192,121,32,168,70,253,255,121,32,168,0,0,64,70,253,255,121,32,168,133,42,168,92,62,168,
  212,62,168,16,63,168,136,63,168,70,2,192,121,32,168,198,253,255,121,32,168,0,0,64,92,62,168,212,62,168,16,63,
  168,136,63,168,198,2,192,121,32,168,70,2,192,121,32,168,198,253,255,121,32,168,70,253,255,121,32,168,0,0,64,134,
  2,192,121,32,168,133,42,168,70,0,192,121,32,168,198,255,255,121,32,168,0,0,64,70,0,192,121,32,168,133,42,168,
  134,2,192,121,32,168,134,253,255,121,32,168,0,0,64,198,255,255,121,32,168,133,42,168,134,2,192,121,32,168,134,253,
  255,121,32,168,0,0,64,134,253,255,121,32,168,133,42,168,70,0,192,121,32,168,198,255,255,121,32,168,0,0,64,134,
  2,192,121,32,168,133,42,168,32,62,168,152,62,168,76,63,168,196,63,168,70,0,192,121,32,168,198,255,255,121,32,168,
  0,0,64,70,0,192,121,32,168,133,42,168,32,62,168,152,62,168,76,63,168,196,63,168,134,2,192,121,32,168,134,253,
  255,121,32,168,0,0,64,198,255,255,121,32,168,133,42,168,32,62,168,152,62,168,76,63,168,196,63,168,134,2,192,121,
  32,168,134,253,255,121,32,168,0,0,64,134,253,255,121,32,168,133,42,168,32,62,168,152,62,168,76,63,168,196,63,168,
  70,0,192,121,32,168,198,255,255,121,32,168,0,0,64,32,62,168,196,63,168,130,2,192,0,128,21,36,128,20,0,128,
  5,53,206,145,152,62,168,66,0,192,0,128,21,36,128,20,0,128,5,77,206,145,76,63,168,134,2,192,121,32,168,70,
  0,192,121,32,168,198,255,255,121,32,168,134,253,255,121,32,168,0,0,64,152,62,168,76,63,168,130,2,192,0,128,21,
  36,128,20,0,128,5,145,206,145,32,62,168,194,255,255,0,128,21,36,128,20,0,128,5,169,206,145,196,63,168,134,2,
  192,121,32,168,70,0,192,121,32,168,198,255,255,121,32,168,134,253,255,121,32,168,0,0,64,152,62,168,76,63,168,130,
  253,255,0,128,21,36,128,20,0,128,5,237,206,145,196,63,168,66,0,192,0,128,21,36,128,20,0,128,5,5,207,145,
  32,62,168,134,2,192,121,32,168,70,0,192,121,32,168,198,255,255,121,32,168,134,253,255,121,32,168,0,0,64,32,62,
  168,196,63,168,130,253,255,0,128,21,36,128,20,0,128,5,73,207,145,76,63,168,194,255,255,0,128,21,36,128,20,0,
  128,5,97,207,145,152,62,168,134,2,192,121,32,168,70,0,192,121,32,168,198,255,255,121,32,168,134,253,255,121,32,168,
  0,0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,113,193,16,128,21,36,128,20,2,64,
  192,0,128,1,47,0,0,66,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,111,193,16,128,21,36,
  128,20,2,64,192,0,128,1,47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,
  16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,
  1,47,0,0,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,113,193,16,128,21,36,128,20,2,
  64,192,0,128,1,47,0,0,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,194,113,193,
  16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,
  0,66,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,111,193,16,128,21,36,128,20,2,64,192,0,
  128,1,47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,16,128,21,36,128,20,
  2,64,192,0,128,1,47,0,0,0,0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,111,
  193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,110,193,16,128,21,36,128,20,2,64,192,0,128,1,47,
  0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,66,113,193,16,128,21,36,128,20,
  2,64,192,0,128,1,47,0,0,66,111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,110,193,16,128,
  21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,
  0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,113,193,16,128,21,36,128,20,2,64,192,
  0,128,1,47,0,0,66,111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,108,193,16,128,21,36,128,
  20,2,64,192,0,128,1,47,0,0,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,16,
  128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,
  47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,108,193,16,128,21,36,128,20,2,64,
  192,0,128,1,47,0,0,66,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,194,113,193,16,
  128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,
  194,110,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,
  1,47,0,0,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,16,128,21,36,128,20,2,
  64,192,0,128,1,47,0,0,0,0,64,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,205,192,
  16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,0,0,64,134,2,192,245,32,
  168,0,0,64,66,116,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,208,192,16,128,21,36,128,20,194,
  63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,194,115,193,16,128,21,36,128,20,2,64,192,0,128,1,
  47,0,0,2,208,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,0,0,
  64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,206,192,16,128,21,36,128,20,194,63,192,0,
  128,2,0,128,15,208,128,17,0,128,15,47,0,0,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,
  194,205,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,66,113,193,16,128,
  21,36,128,20,2,64,192,0,128,1,47,0,0,130,205,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,
  128,17,0,128,15,47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,201,192,16,128,21,
  36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,66,108,193,16,128,21,36,128,20,2,64,
  192,0,128,1,47,0,0,130,200,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,
  0,0,0,0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,206,192,16,128,21,36,128,20,
  194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,130,113,193,16,128,21,36,128,20,2,64,192,0,128,
  1,47,0,0,194,205,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,66,
  113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,205,192,16,128,21,36,128,20,194,63,192,0,128,2,
  0,128,15,208,128,17,0,128,15,47,0,0,66,111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,203,
  192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,194,110,193,16,128,21,36,
  128,20,2,64,192,0,128,1,47,0,0,2,203,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,
  0,128,15,47,0,0,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,200,192,16,128,21,36,128,
  20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,0,0,64,198,2,192,245,32,168,70,2,192,245,
  32,168,198,253,255,245,32,168,70,253,255,245,32,168,0,0,64,134,2,192,245,32,168,70,0,192,245,32,168,198,255,255,
  245,32,168,134,253,255,245,32,168,0,0,64,78,5,192,4,0,0,2,0,192,0,128,5,169,217,148,130,170,192,0,128,
  21,36,128,20,193,63,192,0,0,2,66,203,192,0,128,21,36,128,20,194,63,192,0,128,2,26,0,0,32,0,20,93,
  87,144,42,0,0,2,105,192,0,128,21,36,128,20,194,63,192,209,128,2,32,0,20,133,23,144,221,0,0,42,0,0,
  161,55,160,45,0,0,2,192,255,0,128,2,209,128,15,32,0,20,161,87,144,42,0,0,4,244,193,239,0,0,132,244,
  193,223,0,0,130,170,192,0,128,21,36,128,20,1,192,255,0,0,2,0,0,15,66,203,192,0,128,21,36,128,20,2,
  192,255,0,128,2,0,128,15,26,0,0,32,0,20,241,87,144,42,0,0,194,137,192,0,128,21,36,128,20,194,63,192,
  209,128,2,32,0,20,25,24,144,221,0,0,42,0,0,53,56,160,45,0,0,2,192,255,0,128,2,209,128,15,32,0,
  20,53,88,144,42,0,0,68,244,193,239,0,0,196,244,193,223,0,0,66,78,193,0,128,21,36,128,20,241,0,0,2,
  111,193,0,128,21,36,128,20,0,0,5,31,0,0,2,192,255,16,128,18,32,0,19,22,128,15,35,0,0,4,0,0,
  241,0,0,0,0,15,16,0,21,130,0,12,0,128,12,38,0,0,50,0,12,0,128,12,35,0,0,130,0,0,48,128,
  20,253,216,144,65,217,145,66,255,255,48,128,21,213,152,144,4,244,193,241,0,0,196,244,193,0,0,4,217,24,144,1,
  0,192,68,244,193,242,0,0,0,128,15,32,0,17,130,45,193,0,128,21,36,128,20,31,0,0,169,57,160,66,255,255,
  128,128,21,29,153,144,68,244,193,241,0,0,132,244,193,0,0,4,33,25,144,1,0,192,0,0,15,4,244,193,0,0,
  1,130,45,193,0,128,21,36,128,20,31,0,0,169,57,160,65,255,255,128,0,21,97,89,144,130,45,193,0,128,21,36,
  128,20,15,0,192,169,57,160,4,244,193,241,0,0,196,244,193,0,0,4,121,25,144,1,0,192,68,244,193,242,0,0,
  132,244,193,0,128,4,145,153,144,2,0,192,0,128,15,32,0,17,130,45,193,0,128,21,36,128,20,31,0,0,1,0,
  0,0,0,9,30,0,0,130,27,192,0,128,20,21,151,145,0,0,64,78,5,192,4,0,0,1,0,192,0,0,5,90,
  64,148,130,176,193,0,128,21,36,128,20,241,0,0,0,0,14,3,60,192,48,0,18,4,244,193,31,0,0,2,236,192,
  0,128,21,36,128,20,193,63,192,242,0,18,26,128,19,0,128,15,32,0,20,33,92,145,131,22,192,209,0,0,48,0,
  20,217,27,144,33,0,0,48,0,20,241,27,144,209,0,0,16,0,18,105,91,145,32,128,18,161,219,145,3,69,193,48,
  0,21,21,0,0,106,0,0,68,244,193,223,0,0,48,128,21,37,0,0,109,0,0,132,244,193,239,0,0,1,0,192,
  0,0,52,130,0,192,0,128,38,3,128,255,48,0,18,32,0,17,0,0,15,0,0,11,19,0,0,68,244,193,242,0,
  0,132,244,193,0,128,4,13,219,144,42,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,
  0,18,66,0,192,0,128,34,0,128,15,0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,
  109,0,0,0,0,37,13,60,160,0,128,10,0,128,9,42,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,
  11,194,255,223,32,0,18,66,0,192,0,128,34,0,128,15,0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,
  0,21,21,0,20,109,0,0,0,0,37,249,59,160,3,69,193,48,128,21,37,0,0,106,0,0,4,244,193,253,0,0,
  1,0,192,0,0,53,0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,249,59,160,2,69,193,208,128,21,37,0,
  0,106,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,13,
  60,160,33,0,0,48,0,20,33,28,144,4,244,193,241,0,0,13,60,160,4,244,193,241,0,0,16,0,21,4,38,192,
  0,0,5,31,0,0,33,60,160,16,0,21,4,38,192,242,0,0,16,128,20,47,0,0,194,12,193,0,128,21,36,128,
  20,193,63,192,242,0,18,26,128,19,0,128,15,32,0,20,61,94,145,131,22,192,209,0,0,48,0,20,253,29,144,33,
  0,0,48,0,20,21,30,144,209,0,0,16,0,18,141,93,145,32,128,18,197,221,145,3,69,193,48,0,21,21,0,0,
  106,0,0,68,244,193,223,0,0,48,128,21,37,0,0,109,0,0,132,244,193,239,0,0,1,0,192,0,0,52,130,0,
  192,0,128,38,3,128,255,48,0,18,32,0,17,0,0,15,0,0,11,19,0,0,68,244,193,242,0,0,132,244,193,0,
  128,4,49,221,144,42,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,0,18,66,0,192,
  0,128,34,0,128,15,0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,109,0,0,0,0,
  37,45,62,160,0,128,10,0,128,9,42,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,
  0,18,66,0,192,0,128,34,0,128,15,0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,
  109,0,0,0,0,37,29,62,160,3,69,193,48,128,21,37,0,0,106,0,0,4,244,193,253,0,0,1,0,192,0,0,
  53,0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,29,62,160,2,69,193,208,128,21,37,0,0,106,0,0,4,
  244,193,253,0,0,1,0,192,0,0,53,0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,45,62,160,33,0,0,
  48,0,20,61,30,144,4,244,193,241,0,0,45,62,160,4,244,193,241,0,0,4,38,192,0,0,5,31,0,0,61,62,
  160,4,38,192,242,0,0,16,128,20,47,0,0,130,45,193,0,128,21,36,128,20,193,63,192,242,0,18,26,128,19,0,
  128,15,32,0,20,90,64,145,131,22,192,209,0,0,48,0,20,26,0,144,33,0,0,48,0,20,50,0,144,209,0,0,
  16,0,18,169,95,145,32,128,18,225,223,145,3,69,193,48,0,21,21,0,0,106,0,0,68,244,193,223,0,0,48,128,
  21,37,0,0,109,0,0,132,244,193,239,0,0,1,0,192,0,0,52,130,0,192,0,128,38,3,128,255,48,0,18,32,
  0,17,0,0,15,0,0,11,19,0,0,68,244,193,242,0,0,132,244,193,0,128,4,77,223,144,42,0,0,4,244,193,
  253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,0,18,66,0,192,0,128,34,0,128,15,0,128,11,0,128,
  15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,109,0,0,0,0,37,74,32,160,0,128,10,0,128,9,42,
  0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,0,18,66,0,192,0,128,34,0,128,15,
  0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,109,0,0,0,0,37,58,32,160,3,69,
  193,48,128,21,37,0,0,106,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,33,0,0,15,0,0,11,195,
  63,192,48,0,18,58,32,160,2,69,193,208,128,21,37,0,0,106,0,0,4,244,193,253,0,0,1,0,192,0,0,53,
  0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,74,32,160,33,0,0,48,0,20,90,0,144,4,244,193,241,0,
  0,74,32,160,4,244,193,241,0,0,4,38,192,0,0,5,31,0,0,90,32,160,4,38,192,242,0,0,16,128,20,47,
  0,0,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,201,25,145,0,0,64,129,176,193,130,6,192,3,0,192,
  20,0,9,63,128,8,130,128,145,78,5,192,4,0,0,2,8,192,0,128,2,218,192,145,130,39,192,0,128,21,36,128,
  20,243,0,0,4,0,0,130,7,192,0,128,2,48,128,17,0,128,11,131,91,193,48,128,21,37,0,0,104,0,0,0,
  0,128,1,0,0,0,0,9,30,0,0,130,27,192,16,128,20,146,128,145,196,179,193,250,0,0,4,180,193,253,0,0,
  209,0,0,68,177,193,0,0,4,34,65,145,225,0,0,132,177,193,0,0,4,102,2,145,209,0,0,132,178,193,0,0,
  4,66,65,145,225,0,0,196,178,193,0,0,4,102,2,145,4,181,193,250,0,0,68,181,193,253,0,0,209,0,0,68,
  177,193,0,0,4,114,65,145,225,0,0,132,177,193,0,0,4,146,1,145,209,0,0,132,178,193,0,0,4,214,65,145,
  225,0,0,196,178,193,0,0,4,214,65,145,196,179,193,223,0,0,4,180,193,239,0,0,132,180,193,241,0,0,68,179,
  193,31,0,0,196,180,193,241,0,0,132,179,193,31,0,0,132,181,193,241,0,0,68,180,193,31,0,0,102,34,160,68,
  182,193,250,0,0,132,182,193,253,0,0,209,0,0,68,177,193,0,0,4,6,66,145,225,0,0,132,177,193,0,0,4,
  38,2,145,209,0,0,132,178,193,0,0,4,102,66,145,225,0,0,196,178,193,0,0,4,102,66,145,196,179,193,223,0,
  0,4,180,193,239,0,0,196,181,193,241,0,0,68,179,193,31,0,0,4,182,193,241,0,0,132,179,193,31,0,0,196,
  182,193,241,0,0,68,180,193,31,0,0,1,105,192,194,32,192,3,0,192,20,0,9,63,128,8,114,130,145,68,177,193,
  241,0,0,16,0,18,178,67,145,2,105,192,16,128,21,36,128,20,79,0,192,196,177,193,242,0,0,32,128,18,218,194,
  145,42,0,0,208,0,21,20,0,0,2,0,192,0,128,5,218,130,145,2,105,192,16,128,21,36,128,20,79,0,192,178,
  34,160,132,178,193,241,0,0,16,0,18,178,67,145,2,105,192,16,128,21,36,128,20,130,0,192,0,128,1,47,0,0,
  4,179,193,242,0,0,32,128,18,70,195,145,42,0,0,208,0,21,20,0,0,2,0,192,0,128,5,70,131,145,2,105,
  192,16,128,21,36,128,20,130,0,192,0,128,1,47,0,0,22,35,160,196,179,193,241,0,0,16,0,18,178,67,145,2,
  105,192,16,128,21,36,128,20,2,1,192,0,128,1,47,0,0,68,180,193,242,0,0,32,128,18,178,195,145,42,0,0,
  208,0,21,20,0,0,2,0,192,0,128,5,178,131,145,2,105,192,16,128,21,36,128,20,2,1,192,0,128,1,47,0,
  0,130,35,160,0,0,64,194,143,193,16,128,21,36,128,20,253,0,0,194,143,193,0,128,21,36,128,20,250,0,0,6,
  0,192,196,244,193,239,0,0,2,226,255,224,128,21,194,196,144,210,0,0,128,128,21,42,0,0,226,0,0,128,128,21,
  45,0,0,196,244,193,242,0,0,128,128,21,47,0,0,68,245,193,143,0,0,214,0,0,2,236,192,16,128,21,36,128,
  20,194,63,192,0,128,2,68,244,193,47,0,0,130,45,193,16,128,21,36,128,20,194,63,192,0,128,2,132,244,193,47,
  0,0,68,244,193,0,128,4,118,196,144,68,244,193,242,0,0,132,244,193,47,0,0,210,0,0,68,244,193,0,128,4,
  42,0,0,154,196,144,226,0,0,208,128,20,45,0,0,26,197,148,130,0,0,132,244,193,0,128,4,38,0,0,194,196,
  144,196,244,193,242,0,0,128,128,20,196,244,193,47,0,0,196,181,193,242,0,0,224,128,20,26,133,144,132,180,193,242,
  0,0,224,128,20,30,197,144,68,182,193,15,0,0,132,182,193,31,0,0,196,181,193,239,0,0,4,245,193,242,0,0,
  196,182,193,47,0,0,68,245,193,242,0,0,4,182,193,47,0,0,0,0,64,68,179,193,242,0,0,224,128,20,186,197,
  144,132,180,193,242,0,0,196,181,193,47,0,0,196,180,193,242,0,0,4,182,193,47,0,0,4,181,193,242,0,0,68,
  182,193,47,0,0,68,181,193,242,0,0,132,182,193,47,0,0,132,181,193,242,0,0,196,182,193,47,0,0,4,181,193,
  15,0,0,68,181,193,31,0,0,132,180,193,239,0,0,4,245,193,242,0,0,132,181,193,47,0,0,68,245,193,242,0,
  0,196,180,193,47,0,0,0,0,64,4,178,193,242,0,0,224,128,20,166,198,144,132,180,193,242,0,0,196,181,193,47,
  0,0,196,180,193,242,0,0,4,182,193,47,0,0,4,181,193,242,0,0,68,182,193,47,0,0,68,181,193,242,0,0,
  132,182,193,47,0,0,132,181,193,242,0,0,196,182,193,47,0,0,68,179,193,242,0,0,132,180,193,47,0,0,132,179,
  193,242,0,0,196,180,193,47,0,0,196,179,193,242,0,0,4,181,193,47,0,0,4,180,193,242,0,0,68,181,193,47,
  0,0,68,180,193,242,0,0,132,181,193,47,0,0,196,179,193,15,0,0,4,180,193,31,0,0,68,179,193,239,0,0,
  4,245,193,242,0,0,68,180,193,47,0,0,68,245,193,242,0,0,132,179,193,47,0,0,0,0,64,196,176,193,242,0,
  0,224,128,20,226,199,144,132,180,193,242,0,0,196,181,193,47,0,0,196,180,193,242,0,0,4,182,193,47,0,0,4,
  181,193,242,0,0,68,182,193,47,0,0,68,181,193,242,0,0,132,182,193,47,0,0,132,181,193,242,0,0,196,182,193,
  47,0,0,68,179,193,242,0,0,132,180,193,47,0,0,132,179,193,242,0,0,196,180,193,47,0,0,196,179,193,242,0,
  0,4,181,193,47,0,0,4,180,193,242,0,0,68,181,193,47,0,0,68,180,193,242,0,0,132,181,193,47,0,0,4,
  178,193,242,0,0,68,179,193,47,0,0,68,178,193,242,0,0,132,179,193,47,0,0,132,178,193,242,0,0,196,179,193,
  47,0,0,196,178,193,242,0,0,4,180,193,47,0,0,4,179,193,242,0,0,68,180,193,47,0,0,132,178,193,15,0,
  0,196,178,193,31,0,0,4,178,193,239,0,0,4,245,193,242,0,0,4,179,193,47,0,0,68,245,193,242,0,0,68,
  178,193,47,0,0,0,0,64,196,244,193,242,0,0,32,128,18,2,200,148,4,245,193,242,0,0,32,128,18,10,200,145,
  196,244,193,15,0,192,196,244,193,242,0,0,132,176,193,47,0,0,132,180,193,242,0,0,196,181,193,47,0,0,196,180,
  193,242,0,0,4,182,193,47,0,0,4,181,193,242,0,0,68,182,193,47,0,0,68,181,193,242,0,0,132,182,193,47,
  0,0,132,181,193,242,0,0,196,182,193,47,0,0,68,179,193,242,0,0,132,180,193,47,0,0,132,179,193,242,0,0,
  196,180,193,47,0,0,196,179,193,242,0,0,4,181,193,47,0,0,4,180,193,242,0,0,68,181,193,47,0,0,68,180,
  193,242,0,0,132,181,193,47,0,0,4,178,193,242,0,0,68,179,193,47,0,0,68,178,193,242,0,0,132,179,193,47,
  0,0,132,178,193,242,0,0,196,179,193,47,0,0,196,178,193,242,0,0,4,180,193,47,0,0,4,179,193,242,0,0,
  68,180,193,47,0,0,196,176,193,242,0,0,4,178,193,47,0,0,4,177,193,242,0,0,68,178,193,47,0,0,68,177,
  193,242,0,0,132,178,193,47,0,0,132,177,193,242,0,0,196,178,193,47,0,0,196,177,193,242,0,0,4,179,193,47,
  0,0,68,177,193,15,0,0,132,177,193,31,0,0,196,176,193,239,0,0,4,245,193,242,0,0,196,177,193,47,0,0,
  68,245,193,242,0,0,4,177,193,47,0,0,0,0,64,2,20,192,0,128,20,178,201,144,2,20,192,16,128,20,178,201,
  144,182,35,160,194,143,193,16,128,21,36,128,20,253,0,0,194,143,193,0,128,21,36,128,20,250,0,0,196,243,193,246,
  0,0,218,35,160,2,20,192,0,128,20,246,201,144,2,20,192,16,128,20,22,138,144,13,0,192,194,143,193,0,128,21,
  36,128,20,250,0,0,196,243,193,246,0,0,218,35,160,0,0,64,0,0,21,4,245,193,15,0,192,20,0,0,2,16,
  192,0,128,2,58,202,145,182,35,168,0,0,64,0,0,21,4,245,193,15,0,192,20,0,0,2,40,192,0,128,2,110,
  138,145,2,16,192,0,128,2,106,202,145,150,41,160,222,41,160,0,0,64,4,245,193,15,0,192,1,0,0,162,42,160,
  66,78,193,16,128,21,36,128,20,194,63,192,0,128,2,162,202,145,4,245,193,63,0,0,48,0,21,20,0,0,242,0,
  0,32,128,18,130,202,145,2,16,192,0,128,2,198,202,145,182,35,168,0,0,64,4,245,193,15,0,192,1,0,0,254,
  42,160,222,41,168,66,78,193,16,128,21,36,128,20,194,63,192,0,128,2,254,202,145,4,245,193,63,0,0,48,0,21,
  20,0,0,242,0,0,32,128,18,218,202,145,2,16,192,0,128,2,34,203,145,150,41,160,0,0,64,196,243,193,143,4,
  192,129,2,192,62,42,168,218,32,160,196,243,193,207,2,192,131,2,192,202,42,168,218,32,160,196,243,193,143,2,192,65,
  5,192,62,42,168,196,243,193,143,2,192,193,4,192,62,42,168,218,32,160,196,243,193,15,0,192,193,2,192,62,42,168,
  196,243,193,15,0,192,129,2,192,62,42,168,196,243,193,15,0,192,65,2,192,62,42,168,196,243,193,15,0,192,193,253,
  255,62,42,168,196,243,193,15,0,192,65,253,255,62,42,168,218,32,160,193,2,192,26,42,168,129,2,192,26,42,168,65,
  2,192,26,42,168,65,0,192,26,42,168,193,255,255,26,42,168,129,253,255,26,42,168,218,32,160,196,243,193,15,3,192,
  195,2,192,202,42,168,196,243,193,15,3,192,67,2,192,202,42,168,196,243,193,15,3,192,195,253,255,202,42,168,196,243,
  193,15,3,192,67,253,255,202,42,168,218,32,160,195,2,192,114,42,168,67,2,192,114,42,168,195,253,255,114,42,168,67,
  253,255,114,42,168,129,2,192,26,42,168,65,0,192,26,42,168,193,255,255,26,42,168,129,253,255,26,42,168,218,32,160,
  196,243,193,15,3,192,131,2,192,202,42,168,196,243,193,15,3,192,67,0,192,202,42,168,196,243,193,15,3,192,195,255,
  255,202,42,168,196,243,193,15,3,192,131,253,255,202,42,168,218,32,160,131,2,192,114,42,168,67,0,192,114,42,168,195,
  255,255,114,42,168,131,253,255,114,42,168,193,2,192,26,42,168,65,2,192,26,42,168,193,253,255,26,42,168,65,253,255,
  26,42,168,218,32,160,2,75,192,0,128,21,36,128,20,2,32,192,0,128,2,42,141,145,193,2,192,26,42,168,194,74,
  192,0,128,21,36,128,20,2,32,192,0,128,2,74,141,145,129,2,192,26,42,168,130,74,192,0,128,21,36,128,20,2,
  32,192,0,128,2,106,141,145,65,2,192,26,42,168,130,72,192,0,128,21,36,128,20,2,32,192,0,128,2,138,141,145,
  65,0,192,26,42,168,2,72,192,0,128,21,36,128,20,2,32,192,0,128,2,170,141,145,193,255,255,26,42,168,2,70,
  192,0,128,21,36,128,20,2,32,192,0,128,2,202,141,145,193,253,255,26,42,168,194,69,192,0,128,21,36,128,20,2,
  32,192,0,128,2,234,141,145,129,253,255,26,42,168,130,69,192,0,128,21,36,128,20,2,32,192,0,128,2,10,142,145,
  65,253,255,26,42,168,218,32,160,196,243,193,15,0,192,193,2,192,62,42,168,196,243,193,15,0,192,65,253,255,62,42,
  168,218,32,160,196,243,193,15,0,192,129,2,192,62,42,168,218,32,160,196,243,193,15,0,192,65,2,192,62,42,168,196,
  243,193,15,0,192,193,253,255,62,42,168,218,32,160,193,2,192,26,42,168,218,32,160,129,2,192,26,42,168,129,253,255,
  26,42,168,218,32,160,65,2,192,26,42,168,218,32,160,65,0,192,26,42,168,193,255,255,26,42,168,218,32,160,196,243,
  193,15,3,192,195,2,192,202,42,168,196,243,193,15,3,192,67,253,255,202,42,168,218,32,160,196,243,193,15,3,192,67,
  2,192,202,42,168,196,243,193,15,3,192,195,253,255,202,42,168,218,32,160,195,2,192,114,42,168,67,253,255,114,42,168,
  218,32,160,67,2,192,114,42,168,195,253,255,114,42,168,218,32,160,196,243,193,15,3,192,131,2,192,202,42,168,196,243,
  193,15,3,192,131,253,255,202,42,168,218,32,160,196,243,193,15,3,192,67,0,192,202,42,168,196,243,193,15,3,192,195,
  255,255,202,42,168,218,32,160,193,2,192,26,42,168,65,253,255,26,42,168,218,32,160,131,2,192,114,42,168,131,253,255,
  114,42,168,218,32,160,65,2,192,26,42,168,193,253,255,26,42,168,218,32,160,67,0,192,114,42,168,195,255,255,114,42,
  168,218,32,160,1,183,193,2,6,192,3,0,192,20,0,9,63,128,8,190,143,145,132,176,193,241,0,0,18,0,0,4,
  178,193,0,128,4,230,143,144,241,0,0,196,176,193,242,0,0,16,128,20,4,183,193,47,0,0,78,5,192,4,0,0,
  2,16,192,0,128,2,70,208,145,130,39,192,0,128,21,36,128,20,243,0,0,4,0,0,130,7,192,0,128,2,48,128,
  17,0,128,11,131,111,193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,9,30,0,0,130,27,192,16,
  128,20,254,143,145,0,0,64,10,0,192,194,143,193,16,128,21,36,128,20,253,0,0,2,236,192,16,128,21,36,128,20,
  2,192,255,0,128,2,0,128,15,35,0,0,194,143,193,0,128,21,36,128,20,242,0,0,48,128,20,174,208,144,42,0,
  0,226,0,0,208,128,20,45,0,0,2,105,192,16,128,21,36,128,20,66,0,192,0,128,2,234,144,145,196,176,193,243,
  0,0,132,177,193,242,0,0,0,128,20,130,145,145,2,105,192,16,128,21,36,128,20,130,0,192,0,128,2,26,145,145,
  4,178,193,243,0,0,196,178,193,242,0,0,0,128,20,78,145,145,2,105,192,16,128,21,36,128,20,2,1,192,0,128,
  2,74,145,145,68,179,193,243,0,0,4,180,193,242,0,0,0,128,20,78,145,145,3,0,192,132,177,193,242,0,0,0,
  128,20,130,145,145,68,177,193,242,0,0,16,128,20,130,209,145,50,0,0,4,177,193,0,128,4,130,145,144,243,0,0,
  196,176,193,242,0,0,48,128,20,4,244,193,47,0,0,50,0,0,208,128,20,166,209,144,211,0,0,50,0,0,4,244,
  193,0,128,5,224,128,21,35,0,0,186,212,148,186,212,145,132,185,193,0,128,4,186,212,144,230,145,145,226,0,0,4,
  186,193,0,128,4,186,212,144,186,212,145,50,0,0,68,184,193,0,128,4,14,210,144,122,146,145,226,0,0,196,184,193,
  0,128,4,14,210,144,122,146,145,196,183,193,242,0,0,0,128,20,186,212,145,4,184,193,242,0,0,16,128,20,186,212,
  145,4,185,193,242,0,0,0,128,20,186,212,145,68,185,193,242,0,0,16,128,20,186,212,145,132,185,193,63,0,0,196,
  185,193,223,0,0,4,186,193,239,0,0,68,186,193,15,0,0,132,186,193,31,0,0,186,52,160,50,0,0,4,183,193,
  0,128,4,162,210,144,94,147,145,226,0,0,132,183,193,0,128,4,162,210,144,94,147,145,196,183,193,242,0,0,0,128,
  20,186,212,145,4,184,193,242,0,0,16,128,20,186,212,145,4,185,193,242,0,0,0,128,20,50,211,145,68,185,193,242,
  0,0,16,128,20,50,211,145,68,184,193,242,0,0,132,185,193,47,0,0,132,184,193,242,0,0,196,185,193,47,0,0,
  196,184,193,242,0,0,4,186,193,47,0,0,4,185,193,242,0,0,68,186,193,47,0,0,68,185,193,242,0,0,132,186,
  193,47,0,0,68,184,193,63,0,0,132,184,193,223,0,0,196,184,193,239,0,0,4,185,193,15,0,0,68,185,193,31,
  0,0,186,52,160,196,183,193,242,0,0,0,128,20,146,212,145,4,184,193,242,0,0,16,128,20,146,212,145,4,185,193,
  242,0,0,0,128,20,66,212,145,68,185,193,242,0,0,16,128,20,66,212,145,68,184,193,242,0,0,132,185,193,47,0,
  0,132,184,193,242,0,0,196,185,193,47,0,0,196,184,193,242,0,0,4,186,193,47,0,0,4,185,193,242,0,0,68,
  186,193,47,0,0,68,185,193,242,0,0,132,186,193,47,0,0,4,183,193,242,0,0,68,184,193,47,0,0,68,183,193,
  242,0,0,132,184,193,47,0,0,132,183,193,242,0,0,196,184,193,47,0,0,196,183,193,242,0,0,4,185,193,47,0,
  0,4,184,193,242,0,0,68,185,193,47,0,0,146,52,160,4,183,193,242,0,0,68,184,193,47,0,0,68,183,193,242,
  0,0,132,184,193,47,0,0,132,183,193,242,0,0,196,184,193,47,0,0,196,183,193,242,0,0,4,185,193,47,0,0,
  4,184,193,242,0,0,68,185,193,47,0,0,4,183,193,63,0,0,68,183,193,223,0,0,132,183,193,239,0,0,196,183,
  193,15,0,0,4,184,193,31,0,0,226,0,0,32,128,18,122,213,148,35,0,0,68,188,193,0,128,4,122,213,144,122,
  213,145,50,0,0,132,187,193,0,128,4,202,213,144,202,213,145,50,0,0,196,186,193,0,128,4,126,213,144,126,213,145,
  132,187,193,242,0,0,68,188,193,47,0,0,196,187,193,242,0,0,132,188,193,47,0,0,4,188,193,242,0,0,196,188,
  193,47,0,0,196,186,193,242,0,0,132,187,193,47,0,0,4,187,193,242,0,0,196,187,193,47,0,0,68,187,193,242,
  0,0,4,188,193,47,0,0,196,186,193,63,0,0,4,187,193,15,0,0,68,187,193,31,0,0,0,0,64,132,187,193,
  242,0,0,68,188,193,47,0,0,196,187,193,242,0,0,132,188,193,47,0,0,4,188,193,242,0,0,196,188,193,47,0,
  0,132,187,193,63,0,0,196,187,193,15,0,0,4,188,193,31,0,0,0,0,64,68,188,193,63,0,0,132,188,193,15,
  0,0,196,188,193,31,0,0,0,0,64,130,12,192,0,128,20,2,150,144,130,12,192,16,128,20,2,150,144,98,48,160,
  194,143,193,16,128,21,36,128,20,242,0,0,196,243,193,0,128,5,45,0,0,2,236,192,16,128,21,36,128,20,2,192,
  255,0,128,2,0,128,15,35,0,0,194,143,193,0,128,21,36,128,20,242,0,0,196,243,193,0,128,5,48,128,20,94,
  150,144,2,0,192,42,0,0,174,48,160,0,0,21,20,0,0,2,48,192,0,128,2,126,150,145,230,53,160,0,0,64,
  1,0,0,4,245,193,242,0,0,32,0,21,20,0,0,242,0,0,32,128,18,190,214,148,174,150,145,98,48,168,134,54,
  160,2,8,192,0,128,2,190,214,145,98,48,168,0,0,64,1,0,0,4,245,193,242,0,0,32,0,21,20,0,0,242,
  0,0,32,128,18,254,214,148,238,150,145,230,53,168,198,54,160,2,8,192,0,128,2,254,214,145,230,53,160,0,0,64,
  196,243,193,143,4,192,129,253,255,102,54,168,70,48,160,196,243,193,207,2,192,4,245,193,143,253,255,194,54,168,70,48,
  160,196,243,193,143,2,192,193,250,255,102,54,168,196,243,193,143,2,192,65,251,255,102,54,168,70,48,160,196,243,193,15,
  0,192,65,253,255,102,54,168,196,243,193,15,0,192,129,253,255,102,54,168,196,243,193,15,0,192,193,253,255,102,54,168,
  196,243,193,15,0,192,65,2,192,102,54,168,196,243,193,15,0,192,193,2,192,102,54,168,70,48,160,65,253,255,0,0,
  21,20,0,0,2,48,192,0,128,2,194,151,145,98,48,168,129,253,255,0,0,21,20,0,0,2,48,192,0,128,2,222,
  151,145,98,48,168,193,253,255,0,0,21,20,0,0,2,48,192,0,128,2,250,151,145,98,48,168,193,255,255,0,0,21,
  20,0,0,2,48,192,0,128,2,22,152,145,98,48,168,65,0,192,0,0,21,20,0,0,2,48,192,0,128,2,50,152,
  145,98,48,168,129,2,192,0,0,21,20,0,0,2,48,192,0,128,2,78,152,145,98,48,168,70,48,160,196,243,193,15,
  3,192,4,245,193,79,253,255,194,54,168,196,243,193,15,3,192,4,245,193,207,253,255,194,54,168,196,243,193,15,3,192,
  4,245,193,79,2,192,194,54,168,196,243,193,15,3,192,4,245,193,207,2,192,194,54,168,70,48,160,4,245,193,79,253,
  255,130,54,168,4,245,193,207,253,255,130,54,168,4,245,193,79,2,192,130,54,168,4,245,193,207,2,192,130,54,168,129,
  253,255,0,0,21,20,0,0,2,48,192,0,128,2,242,152,145,98,48,168,193,255,255,0,0,21,20,0,0,2,48,192,
  0,128,2,14,153,145,98,48,168,65,0,192,0,0,21,20,0,0,2,48,192,0,128,2,42,153,145,98,48,168,129,2,
  192,0,0,21,20,0,0,2,48,192,0,128,2,70,153,145,98,48,168,70,48,160,196,243,193,15,3,192,4,245,193,143,
  253,255,194,54,168,196,243,193,15,3,192,4,245,193,207,255,255,194,54,168,196,243,193,15,3,192,4,245,193,79,0,192,
  194,54,168,196,243,193,15,3,192,4,245,193,143,2,192,194,54,168,70,48,160,4,245,193,143,253,255,130,54,168,4,245,
  193,207,255,255,130,54,168,4,245,193,79,0,192,130,54,168,4,245,193,143,2,192,130,54,168,65,253,255,0,0,21,20,
  0,0,2,48,192,0,128,2,234,153,145,98,48,168,193,253,255,0,0,21,20,0,0,2,48,192,0,128,2,6,154,145,
  98,48,168,65,2,192,0,0,21,20,0,0,2,48,192,0,128,2,34,154,145,98,48,168,193,2,192,0,0,21,20,0,
  0,2,48,192,0,128,2,62,154,145,98,48,168,70,48,160,130,69,192,0,128,21,36,128,20,2,0,224,0,128,2,118,
  154,145,65,253,255,0,0,21,20,0,0,2,48,192,0,128,2,118,154,145,98,48,168,194,69,192,0,128,21,36,128,20,
  2,0,224,0,128,2,170,154,145,129,253,255,0,0,21,20,0,0,2,48,192,0,128,2,170,154,145,98,48,168,2,70,
  192,0,128,21,36,128,20,2,0,224,0,128,2,222,154,145,193,253,255,0,0,21,20,0,0,2,48,192,0,128,2,222,
  154,145,98,48,168,2,72,192,0,128,21,36,128,20,2,0,224,0,128,2,18,155,145,193,255,255,0,0,21,20,0,0,
  2,48,192,0,128,2,18,155,145,98,48,168,130,72,192,0,128,21,36,128,20,2,0,224,0,128,2,70,155,145,65,0,
  192,0,0,21,20,0,0,2,48,192,0,128,2,70,155,145,98,48,168,130,74,192,0,128,21,36,128,20,2,0,224,0,
  128,2,122,155,145,65,2,192,0,0,21,20,0,0,2,48,192,0,128,2,122,155,145,98,48,168,194,74,192,0,128,21,
  36,128,20,2,0,224,0,128,2,174,155,145,129,2,192,0,0,21,20,0,0,2,48,192,0,128,2,174,155,145,98,48,
  168,2,75,192,0,128,21,36,128,20,2,0,224,0,128,2,226,155,145,193,2,192,0,0,21,20,0,0,2,48,192,0,
  128,2,226,155,145,98,48,168,70,48,160,196,243,193,15,0,192,65,253,255,102,54,168,196,243,193,15,0,192,193,2,192,
  102,54,168,70,48,160,196,243,193,15,0,192,129,253,255,102,54,168,70,48,160,196,243,193,15,0,192,193,253,255,102,54,
  168,196,243,193,15,0,192,65,2,192,102,54,168,70,48,160,65,253,255,0,0,21,20,0,0,2,48,192,0,128,2,94,
  156,145,98,48,168,70,48,160,129,253,255,0,0,21,20,0,0,2,48,192,0,128,2,126,156,145,98,48,168,129,2,192,
  0,0,21,20,0,0,2,48,192,0,128,2,154,156,145,98,48,168,70,48,160,193,253,255,0,0,21,20,0,0,2,48,
  192,0,128,2,186,156,145,98,48,168,70,48,160,193,255,255,0,0,21,20,0,0,2,48,192,0,128,2,218,156,145,98,
  48,168,65,0,192,0,0,21,20,0,0,2,48,192,0,128,2,246,156,145,98,48,168,70,48,160,196,243,193,15,3,192,
  4,245,193,79,253,255,194,54,168,196,243,193,15,3,192,4,245,193,207,2,192,194,54,168,70,48,160,196,243,193,15,3,
  192,4,245,193,207,253,255,194,54,168,196,243,193,15,3,192,4,245,193,79,2,192,194,54,168,70,48,160,4,245,193,79,
  253,255,130,54,168,4,245,193,207,2,192,130,54,168,70,48,160,4,245,193,207,253,255,130,54,168,4,245,193,79,2,192,
  130,54,168,70,48,160,196,243,193,15,3,192,4,245,193,143,253,255,194,54,168,196,243,193,15,3,192,4,245,193,143,2,
  192,194,54,168,70,48,160,196,243,193,15,3,192,4,245,193,207,255,255,194,54,168,196,243,193,15,3,192,4,245,193,79,
  0,192,194,54,168,70,48,160,65,253,255,0,0,21,20,0,0,2,48,192,0,128,2,254,157,145,98,48,168,193,2,192,
  0,0,21,20,0,0,2,48,192,0,128,2,26,158,145,98,48,168,70,48,160,4,245,193,143,253,255,130,54,168,4,245,
  193,143,2,192,130,54,168,70,48,160,193,253,255,0,0,21,20,0,0,2,48,192,0,128,2,86,158,145,98,48,168,65,
  2,192,0,0,21,20,0,0,2,48,192,0,128,2,114,158,145,98,48,168,70,48,160,4,245,193,207,255,255,130,54,168,
  4,245,193,79,0,192,130,54,168,70,48,160,1,183,193,14,6,192,2,6,192,239,35,168,129,176,193,142,18,192,130,6,
  192,239,35,168,15,36,168,65,38,192,142,211,193,2,1,192,239,35,168,68,184,193,242,0,0,32,128,18,118,223,148,118,
  223,145,1,189,193,14,250,255,2,6,192,239,35,168,1,195,193,142,237,255,130,6,192,239,35,168,65,184,193,206,254,255,
  66,1,192,239,35,168,15,36,168,65,38,192,142,212,193,2,1,192,239,35,168,132,185,193,242,0,0,32,128,18,118,223,
  148,118,223,145,1,189,193,14,250,255,2,6,192,239,35,168,1,195,193,142,237,255,130,6,192,239,35,168,129,185,193,142,
  253,255,66,1,192,239,35,168,15,36,168,65,38,192,142,213,193,2,1,192,239,35,168,1,189,193,14,250,255,2,6,192,
  239,35,168,1,195,193,142,237,255,130,6,192,239,35,168,196,249,193,242,0,0,4,250,193,0,128,4,68,250,193,0,128,
  5,4,244,193,47,0,0,196,250,193,242,0,0,4,251,193,0,128,4,68,251,193,0,128,5,132,244,193,47,0,0,196,
  251,193,242,0,0,4,252,193,0,128,4,68,252,193,0,128,5,4,245,193,47,0,0,68,184,193,242,0,0,32,128,18,
  87,192,148,87,192,145,132,186,193,241,0,0,4,244,193,242,0,0,132,244,193,0,128,4,163,192,148,132,185,193,242,0,
  0,32,128,18,87,192,148,87,192,145,132,186,193,241,0,0,4,244,193,242,0,0,4,245,193,0,128,4,27,193,148,196,
  249,193,242,0,0,68,38,192,47,0,0,4,250,193,242,0,0,132,38,192,47,0,0,68,250,193,242,0,0,196,38,192,
  47,0,0,132,250,193,242,0,0,4,39,192,47,0,0,4,184,193,241,0,0,27,33,160,132,185,193,242,0,0,32,128,
  18,211,192,148,211,192,145,132,186,193,241,0,0,132,244,193,242,0,0,4,245,193,0,128,4,27,193,148,196,250,193,242,
  0,0,68,38,192,47,0,0,4,251,193,242,0,0,132,38,192,47,0,0,68,251,193,242,0,0,196,38,192,47,0,0,
  132,251,193,242,0,0,4,39,192,47,0,0,68,185,193,241,0,0,16,0,18,111,193,145,20,0,0,2,8,192,0,128,
  2,111,193,145,130,39,192,16,128,21,36,128,20,243,0,0,20,0,0,130,7,192,0,128,2,48,128,17,0,128,11,131,
  131,193,48,128,21,37,0,0,104,0,0,10,64,192,0,0,128,0,0,64,16,128,21,36,0,0,242,0,0,208,128,20,
  47,0,64,29,0,0,48,0,21,2,111,193,115,33,168,20,0,0,242,0,0,32,128,18,139,193,145,219,193,148,130,15,
  192,0,128,2,0,128,11,0,128,21,37,0,0,98,0,0,0,128,8,219,193,148,139,129,145,48,0,21,2,111,193,115,
  33,168,225,0,0,0,0,64,130,113,193,115,33,168,0,0,64,131,2,192,142,137,192,135,33,168,0,0,64,66,116,193,
  115,33,168,194,115,193,115,33,168,0,0,64,194,113,193,115,33,168,66,108,193,115,33,168,130,113,193,115,33,168,66,113,
  193,115,33,168,194,108,193,115,33,168,0,0,64,194,113,193,115,33,168,130,113,193,115,33,168,130,108,193,115,33,168,66,
  113,193,115,33,168,66,111,193,115,33,168,194,110,193,115,33,168,0,0,64,130,113,193,115,33,168,130,108,193,115,33,168,
  66,111,193,115,33,168,194,110,193,115,33,168,195,2,192,142,149,192,135,33,168,67,253,255,142,145,192,135,33,168,67,2,
  192,142,149,192,135,33,168,195,253,255,142,145,192,135,33,168,0,0,64,194,113,193,115,33,168,66,108,193,115,33,168,66,
  113,193,115,33,168,194,108,193,115,33,168,131,2,192,142,137,192,135,33,168,131,253,255,142,133,192,135,33,168,67,0,192,
  142,157,192,135,33,168,195,255,255,142,157,192,135,33,168,0,0,64,194,113,193,115,33,168,66,108,193,115,33,168,0,0,
  64,130,113,193,115,33,168,0,0,64,194,113,193,115,33,168,0,0,64,130,113,193,115,33,168,130,108,193,115,33,168,0,
  0,64,66,113,193,115,33,168,0,0,64,195,2,192,142,149,192,135,33,168,67,253,255,142,145,192,135,33,168,0,0,64,
  130,113,193,115,33,168,130,108,193,115,33,168,0,0,64,66,111,193,115,33,168,194,110,193,115,33,168,0,0,64,131,2,
  192,142,137,192,135,33,168,131,253,255,142,133,192,135,33,168,0,0,64,194,113,193,115,33,168,66,108,193,115,33,168,0,
  0,64,66,113,193,115,33,168,194,108,193,115,33,168,0,0,64,20,0,0,243,0,0,0,0,21,20,0,9,0,0,20,
  63,128,8,239,131,145,0,0,64,68,38,192,15,0,192,132,38,192,15,0,192,196,38,192,15,0,192,4,39,192,15,0,
  192,196,183,193,250,0,0,4,184,193,253,0,0,210,0,0,132,188,193,0,128,4,95,196,145,226,0,0,196,188,193,0,
  128,4,119,132,145,68,188,193,15,0,192,132,188,193,15,0,192,196,188,193,15,0,192,210,0,0,4,187,193,0,128,4,
  3,197,145,226,0,0,68,187,193,0,128,4,3,197,145,210,0,0,196,187,193,0,128,4,183,196,145,226,0,0,4,188,
  193,0,128,4,255,133,145,68,188,193,242,0,0,132,187,193,47,0,0,68,188,193,15,0,192,132,188,193,242,0,0,196,
  187,193,47,0,0,132,188,193,15,0,192,196,188,193,242,0,0,4,188,193,47,0,0,196,188,193,15,0,192,255,37,160,
  210,0,0,196,187,193,0,128,4,159,197,145,226,0,0,4,188,193,0,128,4,159,197,145,132,187,193,242,0,0,196,186,
  193,47,0,0,196,187,193,242,0,0,4,187,193,47,0,0,4,188,193,242,0,0,68,187,193,47,0,0,68,188,193,242,
  0,0,132,187,193,47,0,0,132,188,193,242,0,0,196,187,193,47,0,0,196,188,193,242,0,0,4,188,193,47,0,0,
  68,188,193,15,0,192,132,188,193,15,0,192,196,188,193,15,0,192,255,37,160,68,188,193,242,0,0,196,186,193,47,0,
  0,132,187,193,15,0,192,68,188,193,15,0,192,132,188,193,242,0,0,4,187,193,47,0,0,196,187,193,15,0,192,132,
  188,193,15,0,192,196,188,193,242,0,0,68,187,193,47,0,0,4,188,193,15,0,192,196,188,193,15,0,192,210,0,0,
  32,128,18,15,135,145,226,0,0,32,128,18,15,135,145,196,177,193,241,0,0,16,0,18,139,70,145,68,177,193,250,0,
  0,210,0,0,132,178,193,0,128,4,167,134,145,18,0,0,4,179,193,0,128,4,167,134,145,210,0,0,196,179,193,0,
  128,4,219,134,145,18,0,0,68,180,193,0,128,4,219,134,145,196,176,193,15,0,192,68,177,193,15,0,192,132,177,193,
  15,0,192,139,40,160,132,176,193,242,0,0,196,176,193,47,0,0,4,178,193,0,128,4,139,136,144,4,178,193,242,0,
  0,196,176,193,47,0,0,132,178,193,242,0,0,68,177,193,47,0,0,196,178,193,242,0,0,132,177,193,47,0,0,139,
  40,160,68,179,193,242,0,0,196,176,193,47,0,0,196,179,193,242,0,0,68,177,193,47,0,0,4,180,193,242,0,0,
  132,177,193,47,0,0,139,40,160,2,105,192,224,128,21,36,128,20,66,0,192,0,128,2,91,135,145,210,0,0,132,177,
  193,0,128,4,139,136,145,4,177,193,242,0,0,196,176,193,47,0,0,68,177,193,15,0,192,132,177,193,15,0,192,115,
  39,160,196,176,193,15,0,192,68,177,193,15,0,192,132,177,193,15,0,192,2,105,192,224,128,21,36,128,20,130,0,192,
  0,128,2,255,135,145,210,0,0,196,178,193,0,128,4,187,135,145,68,178,193,242,0,0,4,178,193,47,0,0,132,178,
  193,15,0,192,196,178,193,15,0,192,196,176,193,242,0,0,4,178,193,0,128,4,255,135,144,4,178,193,242,0,0,196,
  176,193,47,0,0,132,178,193,242,0,0,68,177,193,47,0,0,196,178,193,242,0,0,132,177,193,47,0,0,2,105,192,
  224,128,21,36,128,20,2,1,192,0,128,2,139,136,145,210,0,0,4,180,193,0,128,4,71,136,145,132,179,193,242,0,
  0,68,179,193,47,0,0,196,179,193,15,0,192,4,180,193,15,0,192,196,176,193,242,0,0,68,179,193,0,128,4,139,
  136,144,68,179,193,242,0,0,196,176,193,47,0,0,196,179,193,242,0,0,68,177,193,47,0,0,4,180,193,242,0,0,
  132,177,193,47,0,0,4,183,193,242,0,0,4,245,193,47,0,0,68,183,193,242,0,0,132,244,193,47,0,0,132,183,
  193,0,128,5,68,38,192,47,0,0,68,177,193,250,0,0,132,177,193,253,0,0,196,186,193,241,0,0,4,244,193,31,
  0,0,226,0,0,4,187,193,0,128,4,251,200,145,210,0,0,68,187,193,0,128,4,79,137,145,132,187,193,241,0,0,
  226,0,0,196,187,193,0,128,4,35,201,145,210,0,0,4,188,193,0,128,4,79,137,145,68,188,193,241,0,0,226,0,
  0,132,188,193,0,128,4,75,201,145,210,0,0,196,188,193,0,128,4,79,137,145,1,0,192,4,244,193,242,0,0,16,
  128,20,47,0,0,196,176,193,242,0,0,132,245,193,47,0,0,4,244,193,0,128,5,132,244,193,0,128,4,191,137,144,
  4,245,193,242,0,0,132,245,193,0,128,4,4,39,192,47,0,0,132,244,193,242,0,0,196,176,193,47,0,0,68,177,
  193,15,0,192,132,177,193,15,0,192,127,42,160,4,245,193,242,0,0,132,244,193,0,128,4,4,39,192,47,0,0,68,
  177,193,250,0,0,132,177,193,253,0,0,226,0,0,4,187,193,0,128,4,7,202,145,210,0,0,68,187,193,0,128,4,
  127,138,145,196,176,193,242,0,0,132,38,192,47,0,0,226,0,0,196,187,193,0,128,4,75,202,145,210,0,0,4,188,
  193,0,128,4,75,202,145,132,187,193,242,0,0,196,38,192,47,0,0,0,0,64,226,0,0,132,188,193,0,128,4,123,
  202,145,210,0,0,196,188,193,0,128,4,123,202,145,68,188,193,242,0,0,196,38,192,47,0,0,0,0,64,68,187,193,
  253,0,0,196,176,193,242,0,0,4,244,193,47,0,0,196,186,193,242,0,0,132,244,193,47,0,0,132,187,193,241,0,
  0,226,0,0,4,188,193,0,128,4,219,138,145,68,188,193,241,0,0,226,0,0,196,188,193,0,128,4,219,138,145,1,
  0,192,4,245,193,31,0,0,132,244,193,242,0,0,16,128,20,255,202,144,4,244,193,0,128,4,35,139,144,4,244,193,
  242,0,0,132,38,192,47,0,0,132,244,193,242,0,0,196,38,192,47,0,0,0,0,64,132,38,192,15,0,192,4,245,
  193,242,0,0,196,38,192,47,0,0,0,0,64,112,12,168,163,2,168,118,25,168,132,37,192,242,0,0,32,128,18,95,
  203,145,207,50,160,6,0,192,132,170,192,15,0,192,132,45,193,15,0,192,78,5,192,4,0,0,2,8,192,0,128,2,
  191,203,145,130,39,192,0,128,21,36,128,20,243,0,0,4,0,0,130,7,192,0,128,2,48,128,17,0,128,11,131,225,
  193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,9,30,0,0,130,27,192,16,128,20,119,139,145,179,
  61,168,132,37,192,143,0,0,0,0,64,194,170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,
  130,0,0,31,128,9,38,0,64,194,170,192,128,128,21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,
  21,36,128,20,2,32,192,16,128,21,47,0,64,0,0,21,20,0,0,2,40,192,0,128,2,231,203,145,0,0,64,0,
  0,21,20,0,0,2,40,192,0,128,2,127,140,145,2,20,192,16,128,20,231,139,144,15,44,168,231,43,160,0,0,64,
  0,0,21,20,0,0,2,40,192,0,128,2,171,140,145,2,20,192,0,128,20,231,139,144,15,44,168,231,43,160,0,0,
  64,0,0,21,20,0,0,2,40,192,0,128,2,211,140,145,2,20,192,16,128,20,231,139,144,15,44,160,0,0,64,0,
  0,21,20,0,0,2,40,192,0,128,2,7,141,145,2,20,192,16,128,20,231,139,144,15,44,168,130,22,192,16,128,20,
  231,139,144,0,0,64,1,0,0,23,45,160,231,43,168,48,0,21,20,0,0,242,0,0,32,128,18,19,205,145,2,40,
  192,0,128,2,231,203,145,0,0,64,1,0,0,91,45,160,2,20,192,16,128,20,87,141,144,15,44,168,91,45,160,231,
  43,168,48,0,21,20,0,0,242,0,0,32,128,18,67,205,145,2,40,192,0,128,2,139,141,145,2,20,192,16,128,20,
  231,139,144,15,44,160,0,0,64,1,0,0,2,20,192,16,128,20,207,205,144,167,45,160,231,43,168,48,0,21,20,0,
  0,242,0,0,32,128,18,163,205,145,2,40,192,0,128,2,231,203,145,0,0,64,15,44,168,48,0,21,20,0,0,242,
  0,0,32,128,18,203,205,145,2,40,192,0,128,2,15,204,145,0,0,64,1,0,0,27,46,160,2,20,192,16,128,20,
  23,142,144,15,44,168,130,22,192,16,128,20,27,206,144,231,43,168,48,0,21,20,0,0,242,0,0,32,128,18,251,205,
  145,2,40,192,0,128,2,87,142,145,2,20,192,16,128,20,231,139,144,15,44,168,130,22,192,16,128,20,231,139,144,0,
  0,64,129,2,192,175,44,168,191,43,160,131,2,192,243,45,168,191,43,160,65,5,192,215,44,168,193,4,192,215,44,168,
  191,43,160,193,2,192,87,44,168,129,2,192,87,44,168,65,2,192,87,44,168,193,253,255,131,44,168,65,253,255,131,44,
  168,191,43,160,193,2,192,63,44,168,129,2,192,63,44,168,65,2,192,63,44,168,65,0,192,63,44,168,193,255,255,63,
  44,168,129,253,255,63,44,168,191,43,160,195,2,192,59,45,168,67,2,192,59,45,168,195,253,255,143,45,168,67,253,255,
  143,45,168,191,43,160,195,2,192,11,45,168,67,2,192,11,45,168,195,253,255,11,45,168,67,253,255,11,45,168,129,2,
  192,63,44,168,65,0,192,63,44,168,193,255,255,63,44,168,129,253,255,63,44,168,191,43,160,131,2,192,59,45,168,67,
  0,192,143,45,168,195,255,255,143,45,168,131,253,255,143,45,168,191,43,160,131,2,192,11,45,168,67,0,192,11,45,168,
  195,255,255,11,45,168,131,253,255,11,45,168,193,2,192,63,44,168,65,2,192,63,44,168,193,253,255,63,44,168,65,253,
  255,63,44,168,191,43,160,193,2,192,0,0,21,20,0,0,2,40,192,0,128,2,231,143,145,66,72,192,16,128,21,36,
  128,20,0,128,5,231,143,145,231,43,168,129,2,192,0,0,21,20,0,0,2,40,192,0,128,2,23,144,145,66,72,192,
  16,128,21,36,128,20,0,128,5,23,144,145,231,43,168,65,2,192,0,0,21,20,0,0,2,40,192,0,128,2,71,144,
  145,66,72,192,16,128,21,36,128,20,0,128,5,71,144,145,231,43,168,65,0,192,0,0,21,20,0,0,2,40,192,0,
  128,2,119,144,145,66,72,192,16,128,21,36,128,20,0,128,5,119,144,145,231,43,168,193,255,255,0,0,21,20,0,0,
  2,40,192,0,128,2,167,144,145,66,72,192,16,128,21,36,128,20,0,128,5,167,144,145,231,43,168,193,253,255,0,0,
  21,20,0,0,2,40,192,0,128,2,215,144,145,66,72,192,16,128,21,36,128,20,0,128,5,215,144,145,231,43,168,129,
  253,255,0,0,21,20,0,0,2,40,192,0,128,2,7,145,145,66,72,192,16,128,21,36,128,20,0,128,5,7,145,145,
  231,43,168,65,253,255,0,0,21,20,0,0,2,40,192,0,128,2,55,145,145,66,72,192,16,128,21,36,128,20,0,128,
  5,55,145,145,231,43,168,191,43,160,193,2,192,87,44,168,65,253,255,131,44,168,191,43,160,129,2,192,87,44,168,191,
  43,160,65,2,192,87,44,168,193,253,255,131,44,168,191,43,160,193,2,192,63,44,168,191,43,160,129,2,192,63,44,168,
  129,253,255,63,44,168,191,43,160,65,2,192,63,44,168,191,43,160,65,0,192,63,44,168,193,255,255,63,44,168,191,43,
  160,195,2,192,59,45,168,67,253,255,143,45,168,191,43,160,67,2,192,59,45,168,195,253,255,143,45,168,191,43,160,195,
  2,192,11,45,168,67,253,255,11,45,168,191,43,160,129,2,192,63,44,168,129,253,255,63,44,168,191,43,160,67,2,192,
  11,45,168,195,253,255,11,45,168,191,43,160,65,0,192,63,44,168,193,255,255,63,44,168,191,43,160,131,2,192,59,45,
  168,131,253,255,143,45,168,191,43,160,67,0,192,143,45,168,195,255,255,143,45,168,191,43,160,193,2,192,63,44,168,65,
  253,255,63,44,168,191,43,160,131,2,192,11,45,168,131,253,255,11,45,168,191,43,160,65,2,192,63,44,168,193,253,255,
  63,44,168,191,43,160,67,0,192,11,45,168,195,255,255,11,45,168,191,43,160,0,0,21,20,0,0,2,40,192,0,128,
  2,203,146,145,66,72,192,16,128,21,36,128,20,0,128,5,203,146,145,87,54,160,0,0,64,6,0,192,132,170,192,15,
  0,192,132,45,193,15,0,192,4,37,192,254,0,0,193,2,192,159,50,168,129,2,192,159,50,168,65,2,192,159,50,168,
  65,0,192,159,50,168,193,255,255,159,50,168,193,253,255,159,50,168,129,253,255,159,50,168,65,253,255,159,50,168,132,37,
  192,241,0,0,16,0,18,191,83,148,66,72,192,16,128,21,36,128,20,15,128,192,196,37,192,242,0,0,32,128,18,203,
  147,145,78,5,192,4,0,0,2,8,192,0,128,2,167,211,145,130,39,192,0,128,21,36,128,20,0,128,5,167,147,145,
  4,0,0,130,7,192,0,128,2,0,128,11,131,245,193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,
  9,30,0,0,130,27,192,16,128,20,95,147,145,132,37,192,143,0,0,0,0,64,4,37,192,241,0,0,196,37,192,243,
  0,0,48,0,20,66,72,192,16,128,21,36,128,20,15,128,192,20,0,0,242,0,0,32,128,18,219,211,145,78,5,192,
  4,0,0,2,8,192,0,128,2,75,212,145,130,39,192,0,128,21,36,128,20,0,128,5,75,148,145,4,0,0,130,7,
  192,0,128,2,0,128,11,67,249,193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,9,30,0,0,130,
  27,192,16,128,20,3,148,145,4,37,192,241,0,0,196,37,192,243,0,0,55,54,160,2,25,192,16,128,20,87,213,144,
  130,22,192,16,128,20,199,212,144,68,35,192,242,0,0,32,128,18,199,212,145,194,170,192,128,128,21,36,128,20,143,0,
  192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,196,34,192,242,0,0,32,128,18,31,213,145,2,
  59,192,16,128,21,37,128,20,130,241,193,96,128,21,36,128,20,0,128,5,31,149,145,194,170,192,128,128,21,36,128,20,
  15,0,192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,4,35,192,242,0,0,32,128,18,87,213,
  145,194,170,192,128,128,21,36,128,20,79,0,192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,132,
  35,192,242,0,0,32,128,18,143,213,145,194,170,192,128,128,21,36,128,20,207,0,192,194,45,193,128,128,21,36,128,20,
  130,0,0,31,128,9,38,0,0,196,35,192,242,0,0,32,128,18,199,213,145,194,170,192,128,128,21,36,128,20,15,1,
  192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,4,36,192,242,0,0,32,128,18,255,213,145,194,
  170,192,128,128,21,36,128,20,79,1,192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,68,36,192,
  242,0,0,32,128,18,55,214,145,194,170,192,128,128,21,36,128,20,143,1,192,194,45,193,128,128,21,36,128,20,130,0,
  0,31,128,9,38,0,0,48,0,20,20,0,0,242,0,0,32,128,18,119,212,145,132,37,192,143,0,0,0,0,64,194,
  170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,64,194,170,192,
  128,128,21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,
  64,0,0,21,66,72,192,16,128,21,36,128,20,2,128,192,0,128,66,2,20,192,16,128,20,3,151,144,194,170,192,128,
  128,21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,0,
  194,170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,167,51,
  160,2,20,192,0,128,20,107,151,144,194,170,192,128,128,21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,
  128,21,36,128,20,2,32,192,16,128,21,47,0,0,194,170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,
  36,128,20,130,0,0,31,128,9,38,0,0,167,51,160,2,20,192,16,128,20,223,151,144,194,170,192,128,128,21,36,128,
  20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,0,2,25,192,16,
  128,20,167,211,144,194,170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,
  38,0,0,167,51,160,2,20,192,16,128,20,83,152,144,194,170,192,128,128,21,36,128,20,130,0,0,15,128,9,38,0,
  0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,0,130,22,192,16,128,20,167,211,144,194,170,192,128,
  128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,167,51,160,1,0,0,
  48,0,21,20,0,0,242,0,0,32,128,18,131,216,145,66,72,192,16,128,21,36,128,20,2,128,192,0,128,66,175,54,
  168,183,216,145,87,54,160,0,0,64,175,54,168,215,216,145,2,20,192,16,128,20,87,150,144,127,54,168,87,54,160,0,
  0,64,175,54,168,247,216,145,2,20,192,0,128,20,87,150,144,127,54,168,87,54,160,0,0,64,175,54,168,31,217,145,
  2,20,192,16,128,20,87,150,144,127,54,168,2,25,192,16,128,20,87,150,144,0,0,64,175,54,168,71,217,145,2,20,
  192,16,128,20,87,150,144,127,54,168,130,22,192,16,128,20,87,150,144,0,0,64,1,0,0,48,0,21,66,72,192,16,
  128,21,36,128,20,2,128,192,0,128,2,87,150,145,20,0,0,242,0,0,32,128,18,79,217,145,0,0,64,1,0,0,
  48,0,21,66,72,192,16,128,21,36,128,20,2,128,192,0,128,2,179,153,145,20,0,0,242,0,0,32,128,18,131,217,
  145,0,0,64,2,20,192,16,128,20,87,150,144,127,54,168,87,54,160,1,0,0,48,0,21,66,72,192,16,128,21,36,
  128,20,2,128,192,0,128,2,251,153,145,20,0,0,242,0,0,32,128,18,203,217,145,0,0,64,2,20,192,0,128,20,
  87,150,144,127,54,168,87,54,160,129,2,192,175,54,168,151,151,145,167,51,160,131,2,192,127,56,168,151,151,145,167,51,
  160,65,5,192,175,54,168,11,152,145,193,4,192,175,54,168,11,152,145,167,51,160,193,2,192,175,54,168,199,150,145,129,
  2,192,175,54,168,199,150,145,65,2,192,175,54,168,199,150,145,193,253,255,175,54,168,47,151,145,65,253,255,175,54,168,
  47,151,145,167,51,160,193,2,192,175,54,168,3,151,145,129,2,192,175,54,168,3,151,145,65,2,192,175,54,168,3,151,
  145,65,0,192,175,54,168,3,151,145,193,255,255,175,54,168,3,151,145,129,253,255,175,54,168,3,151,145,167,51,160,195,
  2,192,127,56,168,199,150,145,67,2,192,127,56,168,199,150,145,195,253,255,127,56,168,47,151,145,67,253,255,127,56,168,
  47,151,145,167,51,160,195,2,192,127,56,168,3,151,145,67,2,192,127,56,168,3,151,145,195,253,255,127,56,168,3,151,
  145,67,253,255,127,56,168,3,151,145,129,2,192,175,54,168,3,151,145,65,0,192,175,54,168,3,151,145,193,255,255,175,
  54,168,3,151,145,129,253,255,175,54,168,3,151,145,167,51,160,131,2,192,127,56,168,199,150,145,67,0,192,127,56,168,
  47,151,145,195,255,255,127,56,168,47,151,145,131,253,255,127,56,168,47,151,145,167,51,160,131,2,192,127,56,168,3,151,
  145,67,0,192,127,56,168,3,151,145,195,255,255,127,56,168,3,151,145,131,253,255,127,56,168,3,151,145,193,2,192,175,
  54,168,3,151,145,65,2,192,175,54,168,3,151,145,193,253,255,175,54,168,3,151,145,65,253,255,175,54,168,3,151,145,
  167,51,160,129,2,192,251,56,168,75,52,160,1,0,0,131,2,192,48,0,21,66,72,192,16,128,21,36,128,20,2,128,
  192,0,128,2,75,156,145,20,0,0,242,0,0,32,128,18,27,220,145,107,60,160,2,20,192,16,128,20,103,156,144,127,
  54,168,2,25,192,16,128,20,107,220,144,87,54,168,75,52,160,65,5,192,35,57,168,193,4,192,35,57,168,75,52,160,
  193,2,192,187,56,168,129,2,192,187,56,168,65,2,192,187,56,168,193,253,255,219,56,168,65,253,255,219,56,168,75,52,
  160,193,2,192,171,56,168,129,2,192,171,56,168,65,2,192,171,56,168,65,0,192,171,56,168,193,255,255,171,56,168,129,
  253,255,171,56,168,75,52,160,195,2,192,127,57,168,67,2,192,127,57,168,195,253,255,199,57,168,67,253,255,199,57,168,
  75,52,160,195,2,192,75,57,168,67,2,192,75,57,168,195,253,255,75,57,168,67,253,255,75,57,168,129,2,192,171,56,
  168,65,0,192,171,56,168,193,255,255,171,56,168,129,253,255,171,56,168,75,52,160,131,2,192,127,57,168,67,0,192,199,
  57,168,195,255,255,199,57,168,131,253,255,199,57,168,75,52,160,131,2,192,75,57,168,67,0,192,75,57,168,195,255,255,
  75,57,168,131,253,255,75,57,168,193,2,192,171,56,168,65,2,192,171,56,168,193,253,255,171,56,168,65,253,255,171,56,
  168,75,52,160,196,34,192,242,0,0,32,128,18,31,222,145,65,5,192,131,2,192,14,20,192,66,236,193,16,128,21,36,
  128,20,0,128,5,15,158,145,20,0,0,242,0,0,32,128,18,251,157,145,10,0,192,139,63,168,48,0,21,2,25,192,
  16,128,20,227,157,144,0,0,20,0,0,9,130,7,192,16,128,20,207,157,144,4,35,192,242,0,0,32,128,18,91,222,
  145,65,5,192,20,0,0,242,0,0,32,128,18,75,158,145,74,0,192,139,63,168,0,0,9,2,25,192,16,128,20,51,
  158,144,68,35,192,242,0,0,32,128,18,151,222,145,65,5,192,20,0,0,242,0,0,32,128,18,135,158,145,138,0,192,
  139,63,168,0,0,9,130,22,192,16,128,20,111,158,144,132,35,192,242,0,0,32,128,18,211,222,145,65,5,192,20,0,
  0,242,0,0,32,128,18,195,158,145,202,0,192,139,63,168,0,0,9,130,27,192,16,128,20,171,158,144,196,35,192,242,
  0,0,32,128,18,15,223,145,65,5,192,20,0,0,242,0,0,32,128,18,255,158,145,10,1,192,139,63,168,0,0,9,
  130,27,192,16,128,20,231,158,144,4,36,192,242,0,0,32,128,18,75,223,145,65,5,192,20,0,0,242,0,0,32,128,
  18,59,159,145,74,1,192,139,63,168,0,0,9,130,27,192,16,128,20,35,159,144,68,36,192,242,0,0,32,128,18,135,
  223,145,65,5,192,20,0,0,242,0,0,32,128,18,119,159,145,138,1,192,139,63,168,0,0,9,130,27,192,16,128,20,
  95,159,144,0,0,64,194,170,192,128,128,21,36,128,20,223,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,
  9,38,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,255,127,0,64,170,42,0,32,153,25,85,21,73,18,0,16,56,14,204,12,162,11,170,10,216,9,36,9,136,8,
  0,8,135,7,28,7,188,6,102,6,24,6,209,5,144,5,85,5,30,5,236,4,189,4,146,4,105,4,68,4,33,4,
  0,4,224,3,195,3,168,3,142,3,117,3,94,3,72,3,51,3,31,3,12,3,250,2,232,2,216,2,200,2,185,2,
  170,2,156,2,143,2,130,2,118,2,106,2,94,2,83,2,73,2,62,2,52,2,43,2,34,2,25,2,16,2,8,2,
  0,2,248,1,240,1,233,1,225,1,218,1,212,1,205,1,199,1,192,1,186,1,180,1,175,1,169,1,164,1,158,1,
  153,1,148,1,143,1,138,1,134,1,129,1,125,1,120,1,116,1,112,1,108,1,104,1,100,1,96,1,92,1,88,1,
  85,1,81,1,78,1,74,1,71,1,68,1,65,1,62,1,59,1,56,1,53,1,50,1,47,1,44,1,41,1,39,1,
  36,1,33,1,31,1,28,1,26,1,24,1,21,1,19,1,17,1,14,1,12,1,10,1,8,1,6,1,4,1,2,1,
  0,1,254,0,252,0,250,0,248,0,246,0,244,0,242,0,240,0,239,0,237,0,235,0,234,0,232,0,230,0,229,0,
  227,0,225,0,224,0,222,0,221,0,219,0,218,0,217,0,215,0,214,0,212,0,211,0,210,0,208,0,207,0,206,0,
  204,0,203,0,202,0,201,0,199,0,198,0,197,0,196,0,195,0,193,0,192,0,191,0,190,0,189,0,188,0,187,0,
  186,0,185,0,184,0,183,0,182,0,181,0,180,0,179,0,178,0,177,0,176,0,175,0,174,0,173,0,172,0,171,0,
  170,0,169,0,168,0,168,0,167,0,166,0,165,0,164,0,163,0,163,0,162,0,161,0,160,0,159,0,159,0,158,0,
  157,0,156,0,156,0,155,0,154,0,153,0,153,0,152,0,151,0,151,0,150,0,149,0,148,0,148,0,147,0,146,0,
  146,0,145,0,144,0,144,0,143,0,143,0,142,0,141,0,141,0,140,0,140,0,139,0,138,0,138,0,137,0,137,0,
  136,0,135,0,135,0,134,0,134,0,133,0,133,0,132,0,132,0,131,0,131,0,130,0,130,0,129,0,129,0,128,0,
  0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,
  5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,
  1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,
  7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,
  3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,
  0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,27,0,28,0,30,0,32,0,60,0,63,0,
  66,0,68,0,70,0,71,0,73,0,74,0,76,0,78,0,79,0,81,0,0,0,0,0,7,0,8,0,8,0,9,0,
  10,0,11,0,12,0,12,0,12,0,12,0,12,0,0,0,0,0,7,0,7,0,8,0,8,0,9,0,10,0,11,0,
  12,0,12,0,12,0,12,0,0,0,0,0,6,0,7,0,7,0,8,0,8,0,9,0,10,0,11,0,12,0,12,0,
  12,0,166,4,12,5,179,4,12,5,182,4,12,5,207,4,12,5,12,5,0,0,133,5,85,5,190,5,142,5,199,5,
  0,0,40,6,142,6,53,6,142,6,56,6,142,6,81,6,142,6,142,6,0,0,7,7,215,6,64,7,16,7,73,7,
  0,0,0,0,1,0,2,0,4,0,8,0,7,0,30,0,26,0,40,0,28,0,41,0,51,0,52,0,53,0,0,0,
  78,0,93,0,82,0,98,0,120,0,0,0,43,9,84,9,45,9,84,9,49,9,84,9,78,9,84,9,84,9,0,0,
  95,9,91,9,112,9,108,9,125,9,0,0,174,9,201,9,176,9,201,9,27,8,201,9,178,9,201,9,201,9,0,0,
  229,9,252,9,40,10,63,10,27,8,0,0,43,9,208,9,45,9,208,9,27,8,208,9,184,9,208,9,208,9,0,0,
  238,9,9,10,45,10,72,10,27,8,0,0,174,9,215,9,176,9,215,9,27,8,215,9,190,9,215,9,215,9,0,0,
  243,9,18,10,40,10,85,10,27,8,0,0,174,9,222,9,176,9,222,9,27,8,222,9,196,9,222,9,222,9,0,0,
  238,9,31,10,54,10,94,10,27,8,0,0,1,0,1,0,2,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,1,0,1,0,2,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,
  2,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
  2,0,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,
  2,0,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,0,0,1,0,2,0,4,0,8,0,159,11,200,11,161,11,200,11,165,11,
  200,11,194,11,200,11,200,11,0,0,211,11,207,11,228,11,224,11,241,11,0,0,34,12,61,12,36,12,61,12,143,10,
  61,12,38,12,61,12,61,12,0,0,89,12,112,12,156,12,179,12,143,10,0,0,159,11,68,12,161,11,68,12,143,10,
  68,12,44,12,68,12,68,12,0,0,98,12,125,12,161,12,188,12,143,10,0,0,34,12,75,12,36,12,75,12,143,10,
  75,12,50,12,75,12,75,12,0,0,103,12,134,12,156,12,201,12,143,10,0,0,34,12,82,12,36,12,82,12,143,10,
  82,12,56,12,82,12,82,12,0,0,98,12,147,12,170,12,210,12,143,10,0,0,0,0,1,0,2,0,4,0,8,0,
  224,13,246,13,227,13,246,13,230,13,246,13,235,13,246,13,246,13,0,0,11,14,3,14,28,14,20,14,37,14,0,0,
  38,14,93,14,41,14,93,14,44,14,93,14,49,14,93,14,93,14,0,0,153,14,145,14,221,14,213,14,37,14,0,0,
  224,13,106,14,227,13,106,14,44,14,106,14,60,14,106,14,106,14,0,0,170,14,162,14,238,14,230,14,37,14,0,0,
  38,14,119,14,41,14,119,14,44,14,119,14,71,14,119,14,119,14,0,0,187,14,179,14,255,14,247,14,37,14,0,0,
  38,14,132,14,41,14,132,14,44,14,132,14,82,14,132,14,132,14,0,0,204,14,196,14,16,15,8,15,37,14,0,0,
  177,15,199,15,180,15,199,15,183,15,199,15,188,15,199,15,199,15,0,0,220,15,212,15,237,15,229,15,246,15,0,0,
  247,15,46,16,250,15,46,16,253,15,46,16,2,16,46,16,46,16,0,0,106,16,98,16,174,16,166,16,246,15,0,0,
  177,15,59,16,180,15,59,16,253,15,59,16,13,16,59,16,59,16,0,0,123,16,115,16,191,16,183,16,246,15,0,0,
  247,15,72,16,250,15,72,16,253,15,72,16,24,16,72,16,72,16,0,0,140,16,132,16,208,16,200,16,246,15,0,0,
  247,15,85,16,250,15,85,16,253,15,85,16,35,16,85,16,85,16,0,0,157,16,149,16,225,16,217,16,246,15,0,0,
  0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,12,0,13,0,14,0,15,0,
  15,0,16,0,17,0,18,0,19,0,20,0,21,0,22,0,22,0,23,0,24,0,25,0,25,0,26,0,27,0,28,0,
  28,0,29,0,30,0,30,0,31,0,31,0,32,0,33,0,33,0,34,0,34,0,35,0,35,0,36,0,36,0,37,0,
  37,0,38,0,38,0,38,0,39,0,39,0,40,0,40,0,40,0,41,0,41,0,41,0,42,0,42,0,42,0,43,0,
  43,0,43,0,43,0,44,0,44,0,44,0,44,0,44,0,45,0,45,0,45,0,45,0,45,0,46,0,46,0,46,0,
  46,0,46,0,46,0,47,0,47,0,47,0,47,0,47,0,47,0,47,0,47,0,47,0,48,0,48,0,48,0,48,0,
  48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,
  49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,
  49,0,49,0,49,0,49,0,49,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  9,0,72,0,54,0,66,0,60,0,66,0,60,0,63,0,63,0,0,0,198,0,20,1,210,0,38,1,0,0,0,0,
  0,0,2,0,1,0,2,0,1,0,2,0,2,0,2,0,2,0,0,0,4,0,6,0,4,0,6,0,120,0,120,0,
  1,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,5,0,10,0,15,0,19,0,23,0,27,0,30,0,33,0,36,0,39,0,42,0,45,0,48,0,51,0,54,0,
  57,0,60,0,63,0,66,0,0,0,16,0,31,0,46,0,61,0,76,0,0,0,17,0,33,0,49,0,65,0,81,0,
  0,0,29,0,57,0,85,0,113,0,141,0,0,0,30,0,59,0,88,0,117,0,146,0,0,0,41,0,81,0,121,0,
  0,0,43,0,85,0,127,0,182,33,223,33,186,33,223,33,200,33,223,33,207,33,223,33,223,33,0,0,242,33,55,34,
  234,34,47,35,226,35,226,35,92,40,133,40,96,40,133,40,110,40,133,40,117,40,133,40,133,40,0,0,152,40,221,40,
  144,41,213,41,136,42,136,42,0,0,2,0,5,0,8,0,11,0,14,0,17,0,19,0,22,0,25,0,28,0,31,0,
  34,0,36,0,39,0,42,0,45,0,48,0,51,0,54,0,56,0,59,0,62,0,65,0,68,0,71,0,73,0,76,0,
  79,0,82,0,85,0,88,0,91,0,93,0,96,0,99,0,102,0,105,0,108,0,110,0,113,0,116,0,119,0,122,0,
  125,0,128,0,130,0,133,0,136,0,139,0,142,0,145,0,147,0,150,0,153,0,156,0,159,0,162,0,164,0,167,0,
  170,0,173,0,176,0,179,0,182,0,184,0,187,0,190,0,193,0,196,0,199,0,201,0,204,0,207,0,210,0,213,0,
  216,0,219,0,221,0,224,0,227,0,230,0,233,0,236,0,238,0,241,0,244,0,247,0,250,0,253,0,201,50,241,50,
  206,50,241,50,211,50,241,50,220,50,241,50,241,50,0,0,254,50,15,51,32,51,49,51,66,51,0,0,54,48,154,51,
  54,48,154,51,54,48,154,51,131,51,154,51,154,51,0,0,170,51,188,51,54,48,216,51,54,48,0,0,201,50,157,51,
  206,50,157,51,54,48,157,51,140,51,157,51,157,51,0,0,54,48,157,51,198,51,221,51,54,48,0,0,54,48,162,51,
  54,48,162,51,54,48,162,51,145,51,162,51,162,51,0,0,179,51,193,51,54,48,226,51,54,48,0,0,54,48,165,51,
  54,48,165,51,54,48,165,51,54,48,165,51,165,51,0,0,54,48,165,51,207,51,231,51,54,48,0,0,192,53,233,53,
  197,53,233,53,203,53,233,53,212,53,233,53,233,53,0,0,20,54,41,54,82,54,103,54,144,54,0,0,17,52,16,55,
  17,52,16,55,17,52,16,55,249,54,16,55,16,55,0,0,62,55,84,55,17,52,120,55,17,52,0,0,192,53,24,55,
  197,53,24,55,17,52,24,55,2,55,24,55,24,55,0,0,17,52,24,55,98,55,135,55,17,52,0,0,17,52,39,55,
  17,52,39,55,17,52,39,55,7,55,39,55,39,55,0,0,73,55,91,55,17,52,142,55,17,52,0,0,17,52,47,55,
  17,52,47,55,17,52,47,55,17,52,47,55,47,55,0,0,17,52,47,55,109,55,157,55,17,52,0,0,120,56,143,56,
  123,56,143,56,127,56,143,56,132,56,143,56,143,56,0,0,164,56,156,56,185,56,177,56,91,56,0,0,91,56,206,56,
  91,56,206,56,91,56,206,56,198,56,206,56,206,56,0,0,217,56,217,56,91,56,241,56,91,56,0,0,120,56,209,56,
  123,56,209,56,91,56,209,56,203,56,209,56,209,56,0,0,91,56,224,56,234,56,234,56,91,56,0,0,91,56,214,56,
  91,56,214,56,91,56,214,56,138,56,214,56,214,56,0,0,170,56,170,56,91,56,246,56,91,56,0,0,91,56,151,56,
  91,56,151,56,91,56,151,56,91,56,151,56,151,56,0,0,91,56,229,56,191,56,191,56,91,56,0,0,0,0,4,0,
  20,0,48,0,80,0,80,0,80,0,0,0,0,0,8,0,32,0,64,0,80,0,80,0,0,0,12,0,40,0,72,0,
  80,0,80,0,80,0,0,0,0,0,10,0,28,0,50,0,50,0,50,0,0,0,0,0,3,0,18,0,40,0,50,0,
  50,0,0,0,5,0,25,0,45,0,50,0,50,0,50,0,0,0,0,0,0,0,12,0,30,0,30,0,30,0,0,0,
  0,0,0,0,6,0,24,0,30,0,30,0,0,0,0,0,9,0,15,0,30,0,30,0,30,0,197,22,235,22,202,22,
  235,22,205,22,235,22,214,22,235,22,235,22,0,0,20,23,4,23,45,23,29,23,54,23,183,23,221,23,188,23,221,23,
  191,23,221,23,200,23,221,23,221,23,0,0,6,24,246,23,31,24,15,24,40,24,142,25,122,25,190,25,122,25,113,25,
  122,25,39,25,122,25,122,25,0,0,76,25,60,25,163,25,147,25,29,25,244,27,32,28,247,27,32,28,16,28,32,28,
  21,28,32,28,32,28,0,0,45,28,54,28,71,28,80,28,9,27,0,0,9,27,105,28,9,27,105,28,9,27,105,28,
  97,28,105,28,105,28,0,0,116,28,121,28,9,27,141,28,9,27,0,0,244,27,108,28,247,27,108,28,9,27,108,28,
  102,28,108,28,108,28,0,0,9,27,126,28,136,28,146,28,9,27,0,0,9,27,113,28,9,27,113,28,9,27,113,28,
  27,28,113,28,113,28,0,0,49,28,66,28,9,27,151,28,9,27,0,0,9,27,40,28,9,27,40,28,9,27,40,28,
  9,27,40,28,40,28,0,0,9,27,131,28,75,28,92,28,9,27,0,0,1,0,16,0,2,0,16,0,4,0,16,0,
  8,0,16,0,16,0,0,0,32,0,48,0,64,0,72,0,16,0,0,0,16,0,0,0,16,0,0,0,16,0,0,0,
  0,0,0,0,48,0,0,0,72,0,0,0,187,30,215,30,191,30,215,30,194,30,215,30,199,30,215,30,215,30,0,0,
  234,30,243,30,8,31,17,31,38,31,0,0,238,28,78,31,238,28,78,31,238,28,78,31,67,31,78,31,78,31,0,0,
  93,31,98,31,238,28,122,31,238,28,0,0,187,30,82,31,191,30,82,31,238,28,82,31,74,31,82,31,82,31,0,0,
  238,28,103,31,117,31,129,31,238,28,0,0,238,28,89,31,238,28,89,31,238,28,89,31,208,30,89,31,89,31,0,0,
  238,30,3,31,238,28,134,31,238,28,0,0,238,28,227,30,238,28,227,30,238,28,227,30,238,28,227,30,227,30,0,0,
  238,28,110,31,12,31,33,31,238,28,0,0,150,59,172,59,153,59,172,59,156,59,172,59,161,59,172,59,172,59,0,0,
  185,59,194,59,211,59,220,59,237,59,0,0,239,58,91,60,239,58,91,60,239,58,91,60,78,60,91,60,91,60,0,0,
  107,60,117,60,239,58,147,60,239,58,0,0,150,59,94,60,153,59,94,60,239,58,94,60,83,60,94,60,94,60,0,0,
  239,58,122,60,137,60,152,60,239,58,0,0,239,58,99,60,239,58,99,60,239,58,99,60,86,60,99,60,99,60,0,0,
  112,60,127,60,239,58,157,60,239,58,0,0,239,58,102,60,239,58,102,60,239,58,102,60,239,58,102,60,102,60,0,0,
  239,58,132,60,142,60,162,60,239,58,0,0,131,62,162,62,135,62,162,62,139,62,162,62,146,62,162,62,162,62,0,0,
  181,62,194,62,219,62,232,62,233,60,1,63,43,63,4,63,43,63,27,63,43,63,32,63,43,63,43,63,0,0,56,63,
  65,63,82,63,91,63,18,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char ST018[163840] = {
  42,0,0,234,13,0,0,234,16,0,0,234,19,0,0,234,22,0,0,234,25,0,0,234,28,0,0,234,31,0,0,234,
  76,0,0,234,60,0,0,234,4,5,82,72,31,113,13,19,224,142,242,236,64,244,1,0,165,35,138,189,0,81,0,0,
  1,64,45,233,52,0,0,235,56,248,159,21,1,64,189,232,1,64,45,233,48,0,0,235,44,248,159,21,1,64,189,232,
  1,64,45,233,44,0,0,235,32,248,159,21,1,64,189,232,1,64,45,233,40,0,0,235,20,248,159,21,1,64,189,232,
  1,64,45,233,36,0,0,235,8,248,159,21,1,64,189,232,1,64,45,233,32,0,0,235,252,247,159,21,1,64,189,232,
  1,64,45,233,28,0,0,235,240,247,159,21,1,64,189,232,177,161,160,227,2,32,160,227,0,32,10,229,211,16,160,227,
  1,240,41,225,216,215,159,229,12,0,0,235,18,0,0,235,208,247,159,21,28,0,0,235,253,255,255,234,0,67,45,233,
  163,128,160,227,129,145,160,227,0,128,9,229,189,128,160,227,4,128,137,229,107,128,160,227,8,128,137,229,0,131,189,232,
  0,67,45,233,0,128,160,227,129,145,160,227,0,128,9,229,4,128,137,229,8,128,137,229,0,131,189,232,136,7,159,229,
  0,0,16,229,32,0,16,227,14,240,160,225,32,67,111,112,121,114,105,103,104,116,32,40,99,41,32,49,57,57,52,32,
  82,65,72,68,79,77,72,79,85,83,69,32,6,88,45,233,224,192,160,227,16,0,0,234,0,64,45,233,238,255,255,235,
  0,64,189,232,68,247,159,21,68,7,159,229,2,0,208,229,1,0,16,226,3,0,0,26,1,1,160,227,32,0,208,229,
  8,0,16,227,2,0,0,26,40,7,159,229,0,0,80,229,14,240,160,225,6,88,45,233,228,192,160,227,1,177,160,227,
  32,0,219,229,8,0,16,227,16,0,0,10,63,0,0,235,32,0,219,229,8,0,16,227,12,0,0,10,59,0,0,235,
  16,0,219,229,57,0,0,235,236,22,159,229,1,16,143,224,0,32,81,229,0,0,82,225,9,0,0,10,255,0,82,227,
  4,16,129,18,249,255,255,26,238,0,160,227,67,0,0,235,228,0,92,227,193,255,255,27,184,6,159,229,0,0,80,229,
  6,152,189,232,0,16,17,229,255,12,17,227,8,0,0,10,2,9,17,227,4,0,0,26,228,0,160,227,0,0,92,225,
  1,0,0,26,53,0,0,235,240,255,255,234,224,0,160,227,47,0,0,235,33,24,160,225,1,240,143,224,241,0,164,3,
  242,0,24,4,243,0,136,4,244,0,168,4,245,0,180,4,246,0,232,4,160,128,116,1,161,128,120,1,162,128,128,1,
  163,128,144,1,164,128,176,1,165,128,204,1,168,82,232,1,169,65,244,1,170,78,64,2,171,196,80,2,172,207,92,2,
  173,77,104,2,174,72,120,2,175,79,128,2,176,85,164,2,177,83,236,2,178,69,4,3,179,107,28,3,180,46,36,3,
  181,107,88,3,182,46,96,3,183,32,156,3,255,0,82,72,64,16,160,227,1,16,81,226,253,255,255,26,14,240,160,225,
  9,64,45,233,1,48,160,225,32,0,219,229,3,0,0,224,2,0,80,225,251,255,255,26,244,255,255,235,32,0,219,229,
  3,0,0,224,2,0,80,225,246,255,255,26,239,255,255,235,9,128,189,232,0,64,45,233,119,255,255,235,0,64,189,232,
  6,64,45,233,1,16,160,227,0,32,160,227,235,255,255,235,0,0,203,229,229,255,255,235,6,128,189,232,6,64,45,233,
  8,16,160,227,8,32,160,227,228,255,255,235,16,0,219,229,222,255,255,235,6,128,189,232,3,64,45,233,246,255,255,235,
  1,0,80,225,1,0,189,232,238,0,160,19,235,255,255,235,238,0,80,227,2,128,189,232,0,64,45,233,238,255,255,235,
  1,0,45,233,1,0,160,225,228,255,255,235,1,128,189,232,0,64,45,233,0,16,81,226,0,128,189,8,1,16,65,226,
  244,255,255,235,0,0,66,229,1,32,130,226,248,255,255,234,0,64,45,233,0,16,81,226,0,128,189,8,0,0,82,229,
  1,32,130,226,227,255,255,235,0,128,189,8,1,16,65,226,247,255,255,234,61,255,255,234,4,0,160,227,0,0,0,234,
  5,0,160,227,1,16,160,227,218,255,255,235,135,255,255,234,232,36,159,229,4,16,160,227,228,255,255,235,4,32,66,226,
  0,32,18,229,128,16,160,227,232,255,255,235,127,255,255,234,5,16,160,227,93,0,0,235,1,0,160,225,4,16,210,229,
  0,32,160,225,225,255,255,235,120,255,255,234,5,16,160,227,86,0,0,235,1,0,160,225,4,16,210,229,0,32,160,225,
  210,255,255,235,113,255,255,234,0,0,160,227,1,16,160,227,1,0,0,234,1,0,160,227,1,16,160,227,4,0,45,233,
  108,36,159,229,0,224,160,227,0,224,130,229,4,224,130,229,0,224,160,227,2,224,130,229,4,0,189,232,231,2,0,235,
  76,36,159,229,0,0,130,229,8,16,130,229,1,177,160,227,16,0,203,229,141,255,255,235,224,192,160,227,91,255,255,234,
  60,36,159,229,97,16,160,227,184,255,255,235,87,255,255,234,32,36,159,229,1,16,160,227,250,255,255,234,12,0,160,225,
  150,255,255,235,81,255,255,234,4,36,159,229,2,16,160,227,182,255,255,235,77,255,255,234,2,0,160,227,222,255,255,234,
  236,35,159,229,0,0,146,229,1,0,128,226,0,0,128,224,232,35,159,229,0,0,130,229,2,16,160,227,171,255,255,235,
  66,255,255,234,200,35,159,229,0,16,146,229,8,32,146,229,1,16,129,226,1,16,129,224,255,16,17,226,59,255,255,10,
  0,0,82,229,1,32,130,226,138,255,255,235,55,255,255,10,1,16,81,226,0,0,82,229,3,32,130,226,133,255,255,235,
  50,255,255,10,1,16,81,226,243,255,255,234,14,0,0,235,1,32,210,229,255,32,2,226,255,16,1,226,0,0,160,227,
  189,255,255,234,8,0,0,235,1,32,210,229,255,32,2,226,255,16,1,226,1,0,160,227,183,255,255,234,4,0,160,227,
  15,0,0,234,5,0,160,227,13,0,0,234,2,16,160,227,2,64,45,233,68,35,159,229,0,0,160,227,0,0,2,229,
  4,32,130,226,121,255,255,235,2,0,189,232,1,32,66,224,0,16,18,229,0,128,189,232,6,0,160,227,0,0,0,234,
  7,0,160,227,8,35,159,229,0,224,160,227,4,224,130,229,1,224,160,227,2,224,194,229,144,2,0,235,1,177,160,227,
  248,34,159,229,0,0,130,229,1,16,160,227,111,255,255,235,54,255,255,235,224,192,160,227,4,255,255,234,3,0,160,227,
  149,255,255,234,0,192,160,227,216,50,159,229,3,48,143,224,212,82,159,229,5,80,143,224,4,32,147,229,204,146,159,229,
  99,0,0,235,0,32,147,229,2,0,80,225,1,192,140,19,10,82,160,227,12,32,147,229,180,146,159,229,92,0,0,235,
  8,32,147,229,2,0,80,225,2,192,140,19,66,0,0,235,160,146,159,229,91,0,0,235,156,146,159,229,89,0,0,235,
  5,96,160,225,4,192,140,19,144,146,159,229,88,0,0,235,4,32,160,227,13,0,0,234,0,192,160,227,54,0,0,235,
  124,146,159,229,82,0,0,235,1,192,140,19,5,96,160,17,5,0,0,26,108,146,159,229,81,0,0,235,104,146,159,229,
  79,0,0,235,2,192,140,19,5,96,160,17,3,32,160,227,12,0,160,225,48,0,0,235,2,0,28,224,3,0,0,10,
  6,0,160,225,44,0,0,235,32,4,160,225,42,0,0,235,0,128,160,227,129,145,160,227,0,128,9,229,4,128,137,229,
  8,128,137,229,121,254,255,234,2,40,160,227,0,80,160,227,0,0,85,229,32,0,0,235,1,80,133,226,1,32,82,226,
  250,255,255,26,241,255,255,234,2,41,160,227,10,82,160,227,246,255,255,234,244,81,159,229,5,80,143,224,240,33,159,229,
  200,145,159,229,34,0,0,235,19,0,0,235,32,4,160,225,17,0,0,235,32,4,160,225,15,0,0,235,32,4,160,225,
  13,0,0,235,225,255,255,234,10,82,160,227,196,33,159,229,156,145,159,229,22,0,0,235,242,255,255,234,163,128,160,227,
  129,145,160,227,0,128,9,229,189,128,160,227,4,128,137,229,107,128,160,227,8,128,137,229,14,240,160,225,14,176,160,225,
  129,65,160,227,0,16,20,229,1,0,17,227,251,255,255,26,206,254,255,235,0,16,20,229,1,0,17,227,247,255,255,26,
  202,254,255,235,1,17,160,227,0,0,65,229,199,254,255,235,11,240,160,225,3,32,194,227,0,0,160,227,4,112,160,227,
  4,160,160,227,11,0,0,234,76,49,159,229,76,1,159,229,4,0,0,234,3,42,160,227,0,48,160,227,1,112,160,227,
  2,0,0,234,0,48,224,227,1,42,160,227,4,112,160,227,14,82,160,227,1,160,160,227,36,177,159,229,11,176,143,224,
  9,176,139,224,15,128,160,225,11,240,160,225,7,80,133,224,10,32,82,224,250,255,255,26,14,240,160,225,0,48,5,229,
  8,240,160,225,0,64,21,229,4,0,83,225,8,240,160,1,14,240,160,225,0,48,69,229,1,48,131,226,8,240,160,225,
  0,64,85,229,4,0,83,225,14,240,160,17,1,48,131,226,255,48,3,226,8,240,160,225,0,48,5,229,0,48,131,224,
  8,240,160,225,0,64,21,229,4,0,83,225,14,240,160,17,0,48,131,224,8,240,160,225,0,64,21,229,4,0,128,224,
  8,240,160,225,0,64,213,229,1,144,213,229,9,68,132,225,2,144,213,229,9,72,132,225,3,144,213,229,9,76,132,225,
  4,0,128,224,8,240,160,225,4,0,0,96,8,0,0,96,12,0,0,96,16,0,0,96,20,0,0,96,24,0,0,96,
  28,0,0,96,0,64,0,224,0,0,0,96,32,0,0,64,32,0,0,96,100,4,0,224,104,4,0,224,104,0,0,0,
  112,4,0,224,0,4,0,224,60,250,255,255,4,250,255,255,88,8,0,0,100,8,0,0,56,8,0,0,68,8,0,0,
  20,8,0,0,32,8,0,0,252,7,0,0,4,8,0,0,0,249,255,255,0,0,2,0,0,128,0,0,120,86,52,18,
  31,31,31,0,28,248,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,234,21,0,0,234,4,224,45,229,84,193,159,229,84,177,159,229,208,15,12,229,212,31,12,229,200,47,12,229,
  255,251,255,235,11,0,0,27,0,0,0,234,4,224,45,229,0,0,160,227,232,15,12,229,228,15,12,229,220,15,12,229,
  204,223,12,229,80,0,0,235,204,223,28,229,0,144,160,227,232,159,12,229,4,240,157,228,4,240,31,229,128,0,0,96,
  8,209,159,229,8,193,159,229,8,177,159,229,8,81,159,229,8,97,159,229,97,144,160,227,1,0,213,228,1,0,198,228,
  1,144,89,226,251,255,255,26,1,0,160,227,5,16,160,227,0,32,160,227,208,15,12,229,212,31,12,229,200,47,12,229,
  225,255,255,235,254,255,255,234,208,15,28,229,4,0,80,227,14,240,160,33,4,224,45,229,5,0,0,235,1,0,80,227,
  4,240,157,20,0,0,160,227,180,16,159,229,0,0,1,229,220,255,255,234,4,224,45,229,0,0,160,227,207,251,255,235,
  4,240,157,228,156,0,159,229,200,31,28,229,1,0,208,231,1,16,129,226,1,25,193,227,200,31,12,229,1,0,0,226,
  14,240,160,225,0,0,0,0,66,0,0,0,0,0,0,0,0,74,66,80,60,0,0,0,0,0,80,0,0,44,0,0,
  0,0,0,80,64,64,0,48,64,0,0,0,76,76,0,0,0,0,0,0,0,0,0,0,90,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,68,0,84,0,92,0,0,0,0,12,3,3,0,0,0,0,0,1,0,0,
  1,0,0,0,0,0,0,0,232,20,0,224,144,216,1,0,0,64,0,224,232,20,0,224,144,216,1,0,4,17,0,0,
  0,4,0,224,216,38,0,224,0,0,0,160,4,224,45,229,99,0,0,235,208,15,28,229,1,0,16,227,160,0,0,27,
  109,2,0,235,208,15,28,229,254,0,0,226,0,0,80,227,7,0,0,10,2,0,80,227,33,0,0,10,4,0,80,227,
  47,0,0,10,6,0,80,227,55,0,0,10,0,0,160,227,4,240,157,228,165,4,0,235,40,1,159,229,176,15,12,229,
  176,111,28,229,110,84,0,235,172,111,12,229,176,95,28,229,0,0,160,227,16,17,159,229,6,0,85,225,14,0,0,10,
  4,0,149,228,4,17,159,229,6,0,85,225,10,0,0,10,1,0,160,227,232,15,12,229,7,0,160,227,180,15,12,229,
  224,11,0,235,232,16,159,229,0,0,80,227,2,0,0,26,2,0,160,227,232,15,12,229,65,7,0,235,34,0,0,235,
  4,240,157,228,137,4,0,235,200,0,159,229,176,15,12,229,1,0,160,227,232,15,12,229,248,11,0,235,184,16,159,229,
  3,0,45,233,0,0,17,229,0,0,80,227,2,0,0,10,21,0,0,235,4,0,129,228,249,255,255,234,3,0,189,232,
  4,240,157,228,148,0,159,229,176,15,12,229,176,111,28,229,67,84,0,235,172,111,12,229,176,95,28,229,6,0,85,225,
  0,0,160,227,1,0,160,19,4,240,157,228,168,127,28,229,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,
  0,0,160,227,1,0,160,19,4,240,157,228,0,0,80,227,11,0,0,10,127,48,160,227,0,32,3,224,32,52,3,224,
  128,0,0,226,208,79,28,229,1,0,20,227,2,0,0,10,8,0,82,227,130,32,98,34,130,48,99,226,0,4,130,225,
  3,4,128,225,14,240,160,225,216,38,0,224,224,177,255,255,48,117,0,0,34,78,0,0,216,38,0,224,216,38,0,224,
  216,38,0,224,4,224,45,229,0,0,160,227,248,10,12,229,168,15,12,229,164,15,12,229,244,10,12,229,64,20,159,229,
  160,31,12,229,8,0,1,229,4,0,1,229,128,11,12,229,124,11,12,229,120,11,12,229,116,11,12,229,112,11,12,229,
  108,11,12,229,28,84,159,229,12,96,160,225,131,144,160,227,36,6,6,229,24,4,6,229,12,2,6,229,4,16,149,228,
  4,16,134,228,1,144,89,226,248,255,255,26,84,80,160,227,244,99,159,229,9,144,160,227,9,128,160,227,1,0,214,228,
  5,0,204,231,0,0,80,227,2,0,0,10,64,0,45,233,163,2,0,235,64,0,189,232,4,80,133,226,1,128,88,226,
  245,255,255,26,4,80,133,226,1,144,89,226,241,255,255,26,184,83,159,229,16,144,160,227,1,0,214,228,1,0,197,228,
  1,144,89,226,251,255,255,26,84,80,160,227,9,144,160,227,9,128,160,227,5,0,220,231,92,0,80,227,168,95,12,5,
  60,0,80,227,164,95,12,5,4,80,133,226,1,128,88,226,247,255,255,26,4,80,133,226,1,144,89,226,243,255,255,26,
  4,240,157,228,84,80,160,227,109,111,160,227,9,144,160,227,5,48,140,224,6,64,140,224,0,0,83,229,0,16,84,229,
  96,0,16,227,96,0,32,18,96,0,17,227,96,16,33,18,0,0,68,229,0,16,67,229,36,6,19,229,36,22,20,229,
  96,8,160,225,97,24,160,225,36,22,3,229,36,6,4,229,24,4,19,229,24,20,20,229,96,8,160,225,97,24,160,225,
  24,20,3,229,24,4,4,229,6,0,85,225,6,0,0,10,4,80,133,226,4,96,70,226,1,144,89,226,227,255,255,26,
  4,80,133,226,4,96,70,226,223,255,255,234,196,15,28,229,188,31,28,229,196,31,12,229,188,15,12,229,192,15,28,229,
  184,31,28,229,192,31,12,229,184,15,12,229,168,15,28,229,164,31,28,229,130,15,96,226,130,31,97,226,168,31,12,229,
  164,15,12,229,127,11,92,229,107,27,92,229,127,27,76,229,107,11,76,229,126,11,92,229,108,27,92,229,126,27,76,229,
  108,11,76,229,125,11,92,229,109,27,92,229,125,27,76,229,109,11,76,229,124,11,92,229,110,27,92,229,124,27,76,229,
  110,11,76,229,123,11,92,229,111,27,92,229,123,27,76,229,111,11,76,229,122,11,92,229,112,27,92,229,122,27,76,229,
  112,11,76,229,121,11,92,229,113,27,92,229,121,27,76,229,113,11,76,229,120,11,92,229,114,27,92,229,120,27,76,229,
  114,11,76,229,119,11,92,229,115,27,92,229,119,27,76,229,115,11,76,229,14,240,160,225,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,80,37,0,224,120,21,0,0,0,4,0,224,36,5,0,224,4,224,45,229,32,0,45,233,180,15,28,229,
  1,0,64,226,180,15,12,229,160,15,28,229,4,48,128,228,160,15,12,229,127,15,160,227,35,99,0,224,3,81,16,224,
  0,0,160,227,1,0,160,3,156,15,76,229,32,0,85,227,33,0,0,58,72,0,45,233,153,1,0,235,12,1,0,235,
  72,0,189,232,5,64,220,231,0,0,160,227,5,0,204,231,128,48,3,226,35,51,132,225,6,80,160,225,5,0,220,231,
  0,0,80,227,9,0,0,10,24,0,45,233,140,1,0,235,255,0,0,235,24,0,189,232,5,0,220,231,28,0,0,226,
  32,161,140,224,196,15,90,229,1,0,128,226,196,15,74,229,5,0,220,231,5,48,204,231,92,0,84,227,168,95,12,5,
  0,68,132,225,16,0,45,233,125,1,0,235,222,0,0,235,16,0,189,232,32,0,189,232,4,240,157,228,37,161,140,224,
  196,15,90,229,1,0,64,226,196,15,74,229,64,80,133,227,6,80,204,231,6,80,160,225,113,1,0,235,210,0,0,235,
  32,0,189,232,4,240,157,228,4,224,45,229,32,0,45,233,180,15,28,229,1,0,64,226,180,15,12,229,160,15,28,229,
  4,48,128,228,160,15,12,229,127,15,160,227,35,99,0,224,3,81,16,224,0,0,160,227,1,0,160,3,156,15,76,229,
  32,0,85,227,33,0,0,58,72,0,45,233,92,1,0,235,207,0,0,235,72,0,189,232,5,64,220,231,0,0,160,227,
  5,0,204,231,128,48,3,226,35,51,132,225,6,80,160,225,5,0,220,231,0,0,80,227,9,0,0,10,24,0,45,233,
  79,1,0,235,194,0,0,235,24,0,189,232,5,0,220,231,28,0,0,226,32,161,140,224,188,15,90,229,1,0,128,226,
  188,15,74,229,5,0,220,231,5,48,204,231,60,0,84,227,164,95,12,5,0,68,132,225,16,0,45,233,64,1,0,235,
  170,0,0,235,16,0,189,232,32,0,189,232,4,240,157,228,37,161,140,224,188,15,90,229,1,0,64,226,188,15,74,229,
  32,80,133,227,6,80,204,231,6,80,160,225,52,1,0,235,158,0,0,235,32,0,189,232,4,240,157,228,4,224,45,229,
  32,0,45,233,180,15,28,229,1,0,128,226,180,15,12,229,160,15,28,229,4,0,64,226,160,15,12,229,127,15,160,227,
  35,99,0,224,3,81,16,224,32,0,85,227,27,0,0,58,32,0,45,233,6,80,160,225,24,0,45,233,32,1,0,235,
  147,0,0,235,24,0,189,232,36,4,176,225,5,0,204,231,9,0,0,10,24,0,45,233,25,1,0,235,131,0,0,235,
  24,0,189,232,36,4,160,225,28,0,0,226,32,161,140,224,196,15,90,229,1,0,64,226,196,15,74,229,32,0,189,232,
  255,0,4,226,5,0,204,231,92,0,80,227,168,95,12,5,11,1,0,235,108,0,0,235,32,0,189,232,4,240,157,228,
  37,161,140,224,196,15,90,229,1,0,128,226,196,15,74,229,6,80,160,225,2,1,0,235,117,0,0,235,0,0,160,227,
  5,0,204,231,32,0,189,232,4,240,157,228,4,224,45,229,32,0,45,233,180,15,28,229,1,0,128,226,180,15,12,229,
  160,15,28,229,4,0,64,226,160,15,12,229,127,15,160,227,35,99,0,224,3,81,16,224,32,0,85,227,27,0,0,58,
  32,0,45,233,6,80,160,225,24,0,45,233,236,0,0,235,95,0,0,235,24,0,189,232,36,4,176,225,5,0,204,231,
  9,0,0,10,24,0,45,233,229,0,0,235,70,0,0,235,24,0,189,232,36,4,160,225,28,0,0,226,32,161,140,224,
  188,15,90,229,1,0,64,226,188,15,74,229,32,0,189,232,255,0,4,226,5,0,204,231,60,0,80,227,164,95,12,5,
  215,0,0,235,65,0,0,235,32,0,189,232,4,240,157,228,37,161,140,224,188,15,90,229,1,0,128,226,188,15,74,229,
  6,80,160,225,206,0,0,235,65,0,0,235,0,0,160,227,5,0,204,231,32,0,189,232,4,240,157,228,0,48,160,227,
  156,63,76,229,180,15,28,229,1,0,64,226,180,15,12,229,160,15,28,229,4,48,128,228,160,15,12,229,14,240,160,225,
  180,15,28,229,1,0,128,226,180,15,12,229,160,15,28,229,4,0,64,226,160,15,12,229,14,240,160,225,4,224,45,229,
  0,0,160,227,104,11,12,229,100,11,12,229,204,82,159,229,131,144,160,227,12,2,133,229,4,0,133,228,1,144,89,226,
  251,255,255,26,4,0,160,227,148,15,12,229,136,13,12,229,84,80,160,227,9,144,160,227,9,128,160,227,5,0,220,231,
  0,0,80,227,6,0,0,27,4,80,133,226,1,128,88,226,249,255,255,26,4,80,133,226,1,144,89,226,245,255,255,26,
  4,240,157,228,64,0,16,227,8,0,0,10,152,31,28,229,152,95,12,229,1,160,140,224,140,93,10,229,5,160,140,224,
  152,31,10,229,0,0,160,227,140,13,10,229,16,0,0,234,148,31,28,229,148,95,12,229,1,160,140,224,140,93,10,229,
  5,160,140,224,152,31,10,229,4,0,160,227,140,13,10,229,7,0,0,234,5,160,140,224,152,31,26,229,140,45,26,229,
  2,160,140,224,152,31,10,229,1,160,140,224,140,45,10,229,255,255,255,234,14,240,160,225,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,
  5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,0,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,
  12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,18,0,0,0,
  19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,
  0,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,
  34,0,0,0,35,0,0,0,0,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,
  41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,0,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,
  48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,0,0,0,0,54,0,0,0,
  55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,
  0,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,
  70,0,0,0,71,0,0,0,0,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,
  77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  80,5,0,224,5,96,140,224,24,20,22,229,0,32,86,229,62,32,2,226,130,0,143,224,116,5,144,229,0,16,49,224,
  103,0,0,10,228,53,159,229,1,48,19,224,9,0,0,10,5,96,140,224,44,96,70,226,24,4,22,229,3,0,32,224,
  24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,90,0,0,10,180,53,159,229,1,48,19,224,
  9,0,0,10,5,96,140,224,44,96,134,226,24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,
  248,255,255,10,3,16,49,224,77,0,0,10,132,53,159,229,1,48,19,224,9,0,0,10,5,96,140,224,36,96,70,226,
  24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,64,0,0,10,
  84,53,159,229,1,48,19,224,9,0,0,10,5,96,140,224,36,96,134,226,24,4,22,229,3,0,32,224,24,4,6,229,
  0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,51,0,0,10,36,53,159,229,1,48,19,224,9,0,0,10,
  5,96,140,224,40,96,70,226,24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,
  3,16,49,224,38,0,0,10,244,52,159,229,1,48,19,224,9,0,0,10,5,96,140,224,40,96,134,226,24,4,22,229,
  3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,25,0,0,10,196,52,159,229,
  1,48,19,224,9,0,0,10,5,96,140,224,4,96,70,226,24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,
  0,0,80,227,248,255,255,10,3,16,49,224,12,0,0,10,148,52,159,229,1,48,19,224,9,0,0,10,5,96,140,224,
  4,96,134,226,24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,
  255,255,255,10,5,96,140,224,130,0,143,224,64,243,144,229,76,6,22,229,2,0,32,226,76,6,6,229,5,96,139,224,
  36,107,22,229,6,160,140,224,128,11,90,229,1,0,32,226,128,11,74,229,14,240,160,225,14,240,160,225,120,6,22,229,
  1,12,32,226,120,6,6,229,112,6,22,229,2,12,32,226,112,6,6,229,14,240,160,225,80,6,22,229,1,0,32,226,
  80,6,6,229,76,6,22,229,2,0,32,226,76,6,6,229,72,6,22,229,4,0,32,226,72,6,6,229,0,6,22,229,
  32,0,32,226,0,6,6,229,248,5,22,229,128,0,32,226,248,5,6,229,14,240,160,225,80,6,22,229,1,0,32,226,
  80,6,6,229,76,6,22,229,2,0,32,226,76,6,6,229,72,6,22,229,4,0,32,226,72,6,6,229,40,6,22,229,
  8,0,32,226,40,6,6,229,32,6,22,229,16,0,32,226,32,6,6,229,252,5,22,229,64,0,32,226,252,5,6,229,
  14,240,160,225,76,6,22,229,2,0,32,226,76,6,6,229,40,6,22,229,8,0,32,226,40,6,6,229,32,6,22,229,
  16,0,32,226,32,6,6,229,252,5,22,229,64,0,32,226,252,5,6,229,14,240,160,225,80,6,22,229,1,0,32,226,
  80,6,6,229,72,6,22,229,4,0,32,226,72,6,6,229,0,6,22,229,32,0,32,226,0,6,6,229,248,5,22,229,
  128,0,32,226,248,5,6,229,14,240,160,225,80,6,22,229,1,0,32,226,80,6,6,229,76,6,22,229,2,0,32,226,
  76,6,6,229,72,6,22,229,4,0,32,226,72,6,6,229,40,6,22,229,8,0,32,226,40,6,6,229,32,6,22,229,
  16,0,32,226,32,6,6,229,0,6,22,229,32,0,32,226,0,6,6,229,252,5,22,229,64,0,32,226,252,5,6,229,
  248,5,22,229,128,0,32,226,248,5,6,229,14,240,160,225,252,5,22,229,2,8,32,226,252,5,6,229,5,96,139,224,
  36,107,22,229,6,160,140,224,116,11,90,229,1,0,32,226,116,11,74,229,14,240,160,225,14,240,160,225,208,5,22,229,
  1,4,32,226,208,5,6,229,216,5,22,229,2,4,32,226,216,5,6,229,14,240,160,225,248,5,22,229,1,8,32,226,
  248,5,6,229,252,5,22,229,2,8,32,226,252,5,6,229,0,6,22,229,1,7,32,226,0,6,6,229,72,6,22,229,
  2,6,32,226,72,6,6,229,80,6,22,229,2,5,32,226,80,6,6,229,14,240,160,225,248,5,22,229,1,8,32,226,
  248,5,6,229,252,5,22,229,2,8,32,226,252,5,6,229,0,6,22,229,1,7,32,226,0,6,6,229,32,6,22,229,
  2,7,32,226,32,6,6,229,40,6,22,229,1,6,32,226,40,6,6,229,76,6,22,229,1,5,32,226,76,6,6,229,
  14,240,160,225,252,5,22,229,2,8,32,226,252,5,6,229,32,6,22,229,2,7,32,226,32,6,6,229,40,6,22,229,
  1,6,32,226,40,6,6,229,76,6,22,229,1,5,32,226,76,6,6,229,14,240,160,225,248,5,22,229,1,8,32,226,
  248,5,6,229,0,6,22,229,1,7,32,226,0,6,6,229,72,6,22,229,2,6,32,226,72,6,6,229,80,6,22,229,
  2,5,32,226,80,6,6,229,14,240,160,225,248,5,22,229,1,8,32,226,248,5,6,229,252,5,22,229,2,8,32,226,
  252,5,6,229,0,6,22,229,1,7,32,226,0,6,6,229,32,6,22,229,2,7,32,226,32,6,6,229,40,6,22,229,
  1,6,32,226,40,6,6,229,72,6,22,229,2,6,32,226,72,6,6,229,76,6,22,229,1,5,32,226,76,6,6,229,
  80,6,22,229,2,5,32,226,80,6,6,229,14,240,160,225,16,32,0,0,152,32,0,0,56,32,0,0,152,32,0,0,
  60,32,0,0,152,32,0,0,88,32,0,0,152,32,0,0,152,32,0,0,0,0,0,0,20,33,0,0,228,32,0,0,
  72,33,0,0,24,33,0,0,76,33,0,0,0,0,0,0,176,33,0,0,56,34,0,0,216,33,0,0,56,34,0,0,
  220,33,0,0,56,34,0,0,248,33,0,0,56,34,0,0,56,34,0,0,0,0,0,0,180,34,0,0,132,34,0,0,
  232,34,0,0,184,34,0,0,236,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,0,0,0,165,0,0,0,
  90,0,0,0,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,0,0,0,165,0,
  0,0,90,0,0,0,90,0,0,0,0,0,0,0,0,0,1,0,128,0,128,0,1,0,4,0,32,0,32,0,4,0,
  2,0,64,0,64,0,2,0,8,0,16,0,16,0,8,0,14,240,160,225,14,240,160,225,0,144,160,227,14,240,160,225,
  0,144,160,227,14,240,160,225,0,144,160,227,14,240,160,225,0,0,160,227,80,11,12,229,76,11,12,229,168,95,28,229,
  5,160,140,224,36,6,26,229,22,20,90,229,32,24,145,225,18,0,0,10,1,16,139,224,0,20,209,229,128,0,17,227,
  1,28,65,18,0,16,113,226,10,0,0,10,1,96,69,224,6,0,220,231,0,0,80,227,4,0,0,26,76,27,12,229,
  1,96,70,224,6,0,220,231,0,0,80,227,251,255,255,10,80,107,12,229,14,240,160,225,0,0,224,227,80,11,12,229,
  14,240,160,225,0,0,160,227,80,11,12,229,76,11,12,229,164,95,28,229,5,160,140,224,34,6,26,229,24,20,90,229,
  32,24,145,225,18,0,0,10,1,16,139,224,0,20,209,229,128,0,17,227,1,28,65,18,0,0,81,227,10,0,0,10,
  1,96,69,224,6,0,220,231,0,0,80,227,4,0,0,26,76,27,12,229,1,96,70,224,6,0,220,231,0,0,80,227,
  251,255,255,10,80,107,12,229,14,240,160,225,0,0,224,227,80,11,12,229,14,240,160,225,164,95,28,229,0,0,85,227,
  120,0,0,10,5,96,140,224,6,128,160,225,32,16,160,227,44,0,248,229,14,18,200,229,0,0,80,227,251,255,255,10,
  128,0,16,227,4,0,0,26,24,4,24,229,1,0,16,227,1,0,0,10,32,0,160,227,15,2,200,229,6,128,160,225,
  66,16,160,227,40,0,248,229,14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,
  2,0,16,227,1,0,0,10,64,0,160,227,15,2,200,229,6,128,160,225,32,16,160,227,36,0,248,229,14,18,200,229,
  0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,4,0,16,227,1,0,0,10,96,0,160,227,
  15,2,200,229,6,128,160,225,64,16,160,227,4,0,248,229,14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,
  4,0,0,26,24,4,24,229,8,0,16,227,1,0,0,10,128,0,160,227,15,2,200,229,6,128,160,225,64,16,160,227,
  4,0,120,229,14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,16,0,16,227,
  1,0,0,10,128,0,160,227,15,2,200,229,6,128,160,225,32,16,160,227,36,0,120,229,14,18,200,229,0,0,80,227,
  251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,32,0,16,227,1,0,0,10,96,0,160,227,15,2,200,229,
  6,128,160,225,64,16,160,227,40,0,120,229,14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,
  24,4,24,229,64,0,16,227,1,0,0,10,64,0,160,227,15,2,200,229,6,128,160,225,32,16,160,227,44,0,120,229,
  14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,128,0,16,227,1,0,0,10,
  32,0,160,227,15,2,200,229,4,16,160,227,98,18,198,229,90,18,198,229,91,16,160,227,54,18,198,229,56,16,160,227,
  58,18,198,229,50,18,198,229,80,16,160,227,18,18,198,229,10,18,198,229,40,16,160,227,234,17,198,229,226,17,198,229,
  80,16,160,227,230,17,198,229,14,240,160,225,30,0,0,226,128,0,143,224,0,240,144,229,12,42,0,0,12,42,0,0,
  12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,
  64,42,0,0,16,42,0,0,228,42,0,0,180,42,0,0,12,42,0,0,12,42,0,0,4,224,45,229,12,80,160,225,
  0,0,160,227,131,144,160,227,12,2,133,229,24,4,133,229,4,80,133,226,1,144,89,226,250,255,255,26,168,95,28,229,
  0,0,85,227,135,0,0,10,1,64,160,227,5,96,140,224,44,0,118,229,0,0,80,227,252,255,255,10,128,0,16,227,
  9,0,0,26,22,4,86,229,1,0,16,227,6,0,0,10,32,0,160,227,13,2,198,229,25,68,198,229,44,0,118,229,
  0,0,80,227,252,255,255,10,207,255,255,235,2,64,160,227,5,96,140,224,40,0,118,229,0,0,80,227,252,255,255,10,
  128,0,16,227,9,0,0,26,22,4,86,229,2,0,16,227,6,0,0,10,64,0,160,227,13,2,198,229,25,68,198,229,
  40,0,118,229,0,0,80,227,252,255,255,10,190,255,255,235,4,64,160,227,5,96,140,224,36,0,118,229,0,0,80,227,
  252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,4,0,16,227,6,0,0,10,96,0,160,227,13,2,198,229,
  25,68,198,229,36,0,118,229,0,0,80,227,252,255,255,10,173,255,255,235,8,64,160,227,5,96,140,224,4,0,118,229,
  0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,8,0,16,227,6,0,0,10,128,0,160,227,
  13,2,198,229,25,68,198,229,4,0,118,229,0,0,80,227,252,255,255,10,156,255,255,235,16,64,160,227,5,96,140,224,
  4,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,16,0,16,227,6,0,0,10,
  128,0,160,227,13,2,198,229,25,68,198,229,4,0,246,229,0,0,80,227,252,255,255,10,139,255,255,235,32,64,160,227,
  5,96,140,224,36,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,32,0,16,227,
  6,0,0,10,96,0,160,227,13,2,198,229,25,68,198,229,36,0,246,229,0,0,80,227,252,255,255,10,122,255,255,235,
  64,64,160,227,5,96,140,224,40,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,
  64,0,16,227,6,0,0,10,64,0,160,227,13,2,198,229,25,68,198,229,40,0,246,229,0,0,80,227,252,255,255,10,
  105,255,255,235,128,64,160,227,5,96,140,224,44,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,
  22,4,86,229,128,0,16,227,6,0,0,10,32,0,160,227,13,2,198,229,25,68,198,229,44,0,246,229,0,0,80,227,
  252,255,255,10,88,255,255,235,4,240,157,228,14,240,160,225,64,4,214,229,4,0,128,225,64,4,198,229,28,4,214,229,
  4,0,128,225,28,4,198,229,20,4,214,229,4,0,128,225,20,4,198,229,240,3,214,229,4,0,128,225,240,3,198,229,
  6,112,160,225,44,16,247,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,
  36,16,247,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,36,16,119,229,
  24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,44,16,119,229,24,4,215,229,
  4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,14,240,160,225,68,4,214,229,4,0,128,225,68,4,198,229,
  60,4,214,229,4,0,128,225,60,4,198,229,244,3,214,229,4,0,128,225,244,3,198,229,236,3,214,229,4,0,128,225,
  236,3,198,229,6,112,160,225,40,16,247,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,
  6,112,160,225,4,16,247,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,
  4,16,119,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,40,16,119,229,
  24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,14,240,160,225,30,0,0,226,128,0,143,224,
  0,240,144,229,248,45,0,0,248,45,0,0,248,45,0,0,248,45,0,0,248,45,0,0,248,45,0,0,248,45,0,0,
  248,45,0,0,248,45,0,0,248,45,0,0,44,46,0,0,252,45,0,0,208,46,0,0,160,46,0,0,248,45,0,0,
  248,45,0,0,4,224,45,229,12,80,160,225,0,0,160,227,131,144,160,227,12,2,133,229,24,4,133,229,4,80,133,226,
  1,144,89,226,250,255,255,26,164,95,28,229,0,0,85,227,135,0,0,10,1,64,160,227,5,96,140,224,44,0,246,229,
  0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,1,0,16,227,6,0,0,10,32,0,160,227,
  15,2,198,229,27,68,198,229,44,0,246,229,0,0,80,227,252,255,255,10,207,255,255,235,2,64,160,227,5,96,140,224,
  40,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,2,0,16,227,6,0,0,10,
  64,0,160,227,15,2,198,229,27,68,198,229,40,0,246,229,0,0,80,227,252,255,255,10,190,255,255,235,4,64,160,227,
  5,96,140,224,36,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,4,0,16,227,
  6,0,0,10,96,0,160,227,15,2,198,229,27,68,198,229,36,0,246,229,0,0,80,227,252,255,255,10,173,255,255,235,
  8,64,160,227,5,96,140,224,4,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,
  8,0,16,227,6,0,0,10,128,0,160,227,15,2,198,229,27,68,198,229,4,0,246,229,0,0,80,227,252,255,255,10,
  156,255,255,235,16,64,160,227,5,96,140,224,4,0,118,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,
  24,4,86,229,16,0,16,227,6,0,0,10,128,0,160,227,15,2,198,229,27,68,198,229,4,0,118,229,0,0,80,227,
  252,255,255,10,139,255,255,235,32,64,160,227,5,96,140,224,36,0,118,229,0,0,80,227,252,255,255,10,128,0,16,227,
  9,0,0,26,24,4,86,229,32,0,16,227,6,0,0,10,96,0,160,227,15,2,198,229,27,68,198,229,36,0,118,229,
  0,0,80,227,252,255,255,10,122,255,255,235,64,64,160,227,5,96,140,224,40,0,118,229,0,0,80,227,252,255,255,10,
  128,0,16,227,9,0,0,26,24,4,86,229,64,0,16,227,6,0,0,10,64,0,160,227,15,2,198,229,27,68,198,229,
  40,0,118,229,0,0,80,227,252,255,255,10,105,255,255,235,128,64,160,227,5,96,140,224,44,0,118,229,0,0,80,227,
  252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,128,0,16,227,6,0,0,10,32,0,160,227,15,2,198,229,
  27,68,198,229,44,0,118,229,0,0,80,227,252,255,255,10,88,255,255,235,4,240,157,228,14,240,160,225,66,4,214,229,
  4,0,128,225,66,4,198,229,30,4,214,229,4,0,128,225,30,4,198,229,22,4,214,229,4,0,128,225,22,4,198,229,
  242,3,214,229,4,0,128,225,242,3,198,229,6,112,160,225,44,16,247,229,26,4,215,229,4,0,128,225,26,4,199,229,
  0,0,81,227,249,255,255,10,6,112,160,225,36,16,247,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,
  249,255,255,10,6,112,160,225,36,16,119,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,249,255,255,10,
  6,112,160,225,44,16,119,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,249,255,255,10,14,240,160,225,
  70,4,214,229,4,0,128,225,70,4,198,229,62,4,214,229,4,0,128,225,62,4,198,229,246,3,214,229,4,0,128,225,
  246,3,198,229,238,3,214,229,4,0,128,225,238,3,198,229,6,112,160,225,40,16,247,229,26,4,215,229,4,0,128,225,
  26,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,4,16,247,229,26,4,215,229,4,0,128,225,26,4,199,229,
  0,0,81,227,249,255,255,10,6,112,160,225,4,16,119,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,
  249,255,255,10,6,112,160,225,40,16,119,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,249,255,255,10,
  14,240,160,225,4,224,45,229,40,219,12,229,230,18,0,235,0,0,160,227,228,15,12,229,212,31,28,229,1,0,139,224,
  92,9,80,229,128,0,16,227,1,12,64,18,56,11,12,229,180,15,12,229,1,0,139,224,81,9,80,229,0,1,160,225,
  52,11,12,229,1,0,139,224,70,9,80,229,0,1,160,225,48,11,12,229,1,0,139,224,59,9,80,229,0,1,160,225,
  44,11,12,229,176,111,28,229,253,76,0,235,172,111,12,229,180,2,0,235,176,95,28,229,172,111,28,229,6,0,85,225,
  5,0,0,10,238,1,0,235,176,95,28,229,0,0,21,229,228,15,12,229,180,0,159,229,224,15,12,229,176,111,28,229,
  239,76,0,235,172,111,12,229,229,1,0,235,176,95,28,229,0,0,21,229,228,15,12,229,144,0,159,229,224,15,12,229,
  21,2,0,235,176,95,28,229,172,111,28,229,6,0,85,225,25,0,0,10,0,0,21,229,228,15,12,229,104,0,159,229,
  224,15,12,229,4,80,133,226,6,0,85,225,18,0,0,10,56,11,28,229,1,0,80,227,1,0,160,195,180,15,12,229,
  104,25,27,229,108,41,27,229,72,27,12,229,68,43,12,229,23,0,0,235,60,91,28,229,0,0,85,227,6,0,0,10,
  211,3,0,235,180,15,28,229,1,0,128,226,180,15,12,229,56,27,28,229,1,0,80,225,240,255,255,218,40,219,28,229,
  228,15,28,229,224,31,28,229,4,240,157,228,48,117,0,0,49,117,0,0,228,15,28,229,0,0,80,227,14,240,160,1,
  4,224,45,229,10,248,255,235,2,0,80,227,242,255,255,10,4,240,157,228,4,224,45,229,72,27,28,229,68,43,28,229,
  176,63,28,229,172,79,28,229,30,0,45,233,176,79,12,229,180,15,28,229,0,0,139,224,45,9,80,229,240,3,0,235,
  30,0,189,232,72,27,12,229,68,43,12,229,176,63,12,229,172,79,12,229,0,0,80,227,3,0,0,10,228,15,12,229,
  100,0,159,229,224,15,12,229,219,255,255,234,0,0,160,227,60,11,12,229,176,95,28,229,172,15,28,229,0,0,85,225,
  15,0,0,10,0,48,21,229,220,63,12,229,119,0,0,235,72,27,28,229,1,0,80,225,7,0,0,218,72,11,12,229,
  224,15,12,229,60,91,12,229,0,48,21,229,228,63,12,229,68,27,28,229,1,0,80,225,1,0,0,170,4,80,133,226,
  236,255,255,234,72,11,28,229,4,240,157,228,34,78,0,0,4,224,45,229,180,15,28,229,0,0,80,227,5,0,0,186,
  3,16,160,227,195,3,0,235,0,0,80,227,1,0,0,10,108,9,27,229,4,240,157,228,72,27,28,229,68,43,28,229,
  6,0,45,233,8,128,160,227,178,252,255,235,0,0,89,227,28,0,0,10,255,0,9,226,8,0,64,226,180,31,28,229,
  1,0,80,225,23,0,0,186,73,72,160,225,255,12,9,226,1,12,80,227,4,0,0,26,6,0,189,232,72,27,12,229,
  68,43,12,229,4,0,160,225,4,240,157,228,2,12,80,227,6,0,0,26,72,11,28,229,0,0,84,225,245,255,255,218,
  68,11,28,229,0,0,84,225,68,75,12,181,5,0,0,234,68,11,28,229,0,0,84,225,238,255,255,170,72,11,28,229,
  0,0,84,225,72,75,12,197,7,0,0,235,6,0,189,232,72,27,12,229,68,43,12,229,1,0,45,233,8,128,160,227,
  100,3,0,235,1,0,189,232,4,240,157,228,180,15,28,229,0,0,80,227,78,0,0,218,4,224,45,229,176,111,28,229,
  79,76,0,235,172,111,12,229,176,95,28,229,5,0,86,225,16,0,0,10,120,1,0,235,176,95,28,229,172,15,28,229,
  0,0,85,225,9,0,0,10,15,0,0,235,72,27,28,229,1,0,80,225,3,0,0,218,72,11,12,229,68,27,28,229,
  1,0,80,225,1,0,0,170,4,80,133,226,242,255,255,234,72,11,28,229,4,240,157,228,156,15,92,229,0,0,80,227,
  192,14,159,229,0,0,96,18,4,240,157,228,4,224,45,229,175,2,0,235,1,0,213,229,127,0,0,226,64,27,28,229,
  0,1,81,225,1,0,0,10,8,0,0,235,4,240,157,228,180,31,28,229,1,16,129,226,180,31,12,229,3,0,0,235,
  180,31,28,229,1,16,65,226,180,31,12,229,4,240,157,228,4,224,45,229,0,48,21,229,29,249,255,235,72,27,28,229,
  68,43,28,229,176,111,28,229,172,127,28,229,246,0,45,233,176,127,12,229,58,248,255,235,7,250,255,235,72,27,28,229,
  68,43,28,229,0,16,97,226,0,32,98,226,72,43,12,229,68,27,12,229,133,255,255,235,1,0,45,233,48,248,255,235,
  253,249,255,235,1,0,189,232,0,0,96,226,246,0,189,232,72,27,12,229,68,43,12,229,176,111,12,229,172,127,12,229,
  1,0,45,233,0,48,21,229,123,249,255,235,1,0,189,232,4,240,157,228,4,224,45,229,110,3,0,235,49,0,0,26,
  1,0,160,227,62,3,0,235,0,0,80,227,76,0,0,26,180,15,28,229,1,0,112,227,15,0,0,218,3,0,160,227,
  66,3,0,235,0,0,80,227,38,0,0,26,176,111,28,229,243,75,0,235,172,111,12,229,176,95,28,229,5,0,86,225,
  65,0,0,10,167,1,0,235,229,0,0,235,52,27,28,229,94,1,0,235,65,0,0,235,4,240,157,228,180,15,28,229,
  1,0,112,227,15,0,0,218,1,0,160,227,47,3,0,235,0,0,80,227,36,0,0,26,176,111,28,229,224,75,0,235,
  172,111,12,229,176,95,28,229,5,0,86,225,46,0,0,10,148,1,0,235,210,0,0,235,48,27,28,229,75,1,0,235,
  46,0,0,235,4,240,157,228,176,111,28,229,212,75,0,235,172,111,12,229,176,95,28,229,5,0,86,225,34,0,0,10,
  110,0,0,235,4,240,157,228,180,15,28,229,1,0,112,227,13,0,0,218,176,111,28,229,201,75,0,235,172,111,12,229,
  176,95,28,229,5,0,86,225,23,0,0,10,3,0,160,227,36,11,12,229,108,1,0,235,185,0,0,235,52,27,28,229,
  50,1,0,235,76,0,0,235,4,240,157,228,176,111,28,229,187,75,0,235,172,111,12,229,176,95,28,229,5,0,86,225,
  9,0,0,10,1,0,160,227,36,11,12,229,94,1,0,235,171,0,0,235,48,27,28,229,36,1,0,235,62,0,0,235,
  4,240,157,228,160,12,159,229,4,240,157,228,156,15,92,229,0,0,80,227,148,12,159,229,0,0,96,18,4,240,157,228,
  4,224,45,229,176,95,28,229,172,15,28,229,0,0,85,225,9,0,0,10,108,255,255,235,72,27,28,229,1,0,80,225,
  3,0,0,218,72,11,12,229,68,27,28,229,1,0,80,225,39,0,0,170,4,80,133,226,242,255,255,234,118,249,255,235,
  72,27,28,229,68,43,28,229,176,63,28,229,172,79,28,229,30,0,45,233,176,79,12,229,32,16,65,226,32,32,66,226,
  72,27,12,229,68,43,12,229,173,247,255,235,122,249,255,235,72,27,28,229,68,43,28,229,0,16,97,226,0,32,98,226,
  72,43,12,229,68,27,12,229,129,255,255,235,1,0,45,233,163,247,255,235,112,249,255,235,1,0,189,232,0,0,96,226,
  30,0,189,232,72,27,12,229,68,43,12,229,176,63,12,229,172,79,12,229,1,0,45,233,96,249,255,235,1,0,189,232,
  32,0,128,226,72,27,28,229,1,0,80,225,0,0,0,218,72,11,12,229,72,11,28,229,4,240,157,228,4,224,45,229,
  176,95,28,229,172,15,28,229,0,0,85,225,9,0,0,10,53,255,255,235,72,27,28,229,1,0,80,225,3,0,0,218,
  72,11,12,229,68,27,28,229,1,0,80,225,1,0,0,170,4,80,133,226,242,255,255,234,72,11,28,229,4,240,157,228,
  4,224,45,229,0,0,160,227,104,6,12,229,108,6,12,229,236,10,12,229,180,15,28,229,3,0,112,227,129,2,0,203,
  42,1,0,235,176,95,28,229,172,111,28,229,6,0,85,225,1,0,0,26,116,2,0,235,4,240,157,228,108,6,28,229,
  8,0,80,227,3,0,0,58,104,118,28,229,7,0,220,231,0,0,80,227,104,6,12,5,32,17,0,235,72,27,28,229,
  1,0,80,225,3,0,0,218,72,11,12,229,68,27,28,229,1,0,80,225,16,0,0,170,57,0,0,235,44,27,28,229,
  178,0,0,235,176,95,28,229,172,15,28,229,0,0,85,225,9,0,0,10,4,255,255,235,72,27,28,229,1,0,80,225,
  3,0,0,218,72,11,12,229,68,27,28,229,1,0,80,225,1,0,0,170,4,80,133,226,242,255,255,234,72,11,28,229,
  4,240,157,228,4,224,45,229,154,2,0,235,1,0,0,26,77,2,0,235,4,240,157,228,176,111,28,229,40,75,0,235,
  172,111,12,229,176,95,28,229,5,0,86,225,23,0,0,10,176,95,28,229,172,15,28,229,0,0,85,225,17,0,0,10,
  0,48,21,229,26,248,255,235,48,0,45,233,79,2,0,235,48,0,189,232,1,0,45,233,0,48,21,229,142,248,255,235,
  1,0,189,232,72,27,28,229,1,0,80,225,3,0,0,218,72,11,12,229,68,27,28,229,1,0,80,225,1,0,0,170,
  4,80,133,226,234,255,255,234,72,11,28,229,4,240,157,228,156,15,92,229,0,0,80,227,20,10,159,229,0,0,96,18,
  4,240,157,228,176,95,28,229,172,111,28,229,6,0,85,225,14,240,160,1,180,15,28,229,3,0,112,227,14,240,160,209,
  4,224,45,229,73,1,0,235,32,0,45,233,0,48,21,229,247,247,255,235,72,27,28,229,68,43,28,229,176,111,28,229,
  172,127,28,229,246,0,45,233,176,127,12,229,20,247,255,235,225,248,255,235,188,25,159,229,188,41,159,229,72,27,12,229,
  68,43,12,229,190,255,255,235,1,0,45,233,12,247,255,235,217,248,255,235,1,0,189,232,0,0,96,226,246,0,189,232,
  72,27,12,229,68,43,12,229,176,111,12,229,172,127,12,229,1,0,45,233,0,48,21,229,87,248,255,235,1,0,189,232,
  1,0,45,233,46,246,255,235,2,0,189,232,1,0,128,224,4,0,133,229,8,80,149,229,0,0,85,227,218,255,255,26,
  0,1,189,232,176,15,28,229,0,64,72,224,36,65,160,225,83,4,0,235,42,1,0,235,4,240,157,228,176,95,28,229,
  172,111,28,229,6,0,85,225,14,240,160,1,4,224,45,229,56,2,0,235,14,0,0,26,72,27,28,229,68,43,28,229,
  176,63,28,229,172,79,28,229,30,0,45,233,176,79,12,229,1,16,160,227,10,2,0,235,30,0,189,232,72,27,12,229,
  68,43,12,229,176,63,12,229,172,79,12,229,0,0,80,227,0,0,0,10,95,0,0,235,176,95,28,229,172,111,28,229,
  6,0,85,225,4,240,157,4,173,255,255,235,180,15,28,229,0,0,80,227,2,0,0,202,48,16,160,227,35,0,0,235,
  4,240,157,228,50,30,160,227,32,0,0,235,180,15,28,229,1,0,80,227,8,0,0,202,2,0,224,227,40,48,160,227,
  150,79,160,227,41,0,0,235,0,0,224,227,12,48,160,227,150,79,160,227,37,0,0,235,4,240,157,228,180,15,28,229,
  2,0,80,227,8,0,0,202,2,0,224,227,64,48,160,227,150,79,160,227,29,0,0,235,0,0,224,227,16,48,160,227,
  150,79,160,227,25,0,0,235,4,240,157,228,0,0,224,227,32,48,160,227,50,78,160,227,20,0,0,235,1,0,160,227,
  12,48,160,227,150,79,160,227,16,0,0,235,4,240,157,228,180,15,28,229,3,0,112,227,14,240,160,209,176,15,28,229,
  0,16,129,224,172,15,28,229,1,0,80,225,14,240,160,209,4,224,45,229,176,15,28,229,1,0,45,233,176,31,12,229,
  156,0,0,235,1,0,189,232,176,15,12,229,4,240,157,228,4,224,45,229,176,95,28,229,172,111,28,229,6,0,85,225,
  27,0,0,10,72,27,28,229,68,43,28,229,180,111,28,229,94,0,45,233,180,15,12,229,188,0,0,235,32,0,45,233,
  184,23,159,229,184,39,159,229,72,27,12,229,68,43,12,229,53,254,255,235,4,0,133,229,8,80,149,229,0,0,85,227,
  246,255,255,26,0,1,189,232,176,15,28,229,0,64,72,224,36,65,160,225,226,3,0,235,94,0,189,232,72,27,12,229,
  68,43,12,229,180,111,12,229,4,0,149,229,4,64,64,224,187,0,0,235,4,240,157,228,4,224,45,229,1,16,160,227,
  170,1,0,235,36,11,12,229,4,224,157,228,4,224,45,229,176,95,28,229,5,96,160,225,172,15,28,229,0,0,85,225,
  6,0,0,10,64,0,45,233,53,1,0,235,64,0,189,232,0,0,80,227,4,0,149,228,4,0,134,4,245,255,255,234,
  172,111,12,229,4,240,157,228,176,95,28,229,172,111,28,229,6,0,85,225,14,240,160,1,4,224,45,229,85,16,0,235,
  187,0,0,235,176,95,28,229,5,96,160,225,169,0,0,235,6,0,0,26,189,0,0,235,4,0,0,26,96,0,45,233,
  198,0,0,235,96,0,189,232,2,0,80,227,1,0,0,58,0,0,21,229,4,0,134,228,4,80,133,226,172,15,28,229,
  0,0,85,225,240,255,255,26,172,111,12,229,4,240,157,228,180,15,28,229,3,0,112,227,70,0,0,218,176,95,28,229,
  172,111,28,229,6,0,85,225,14,240,160,1,4,224,45,229,159,0,0,235,5,96,160,225,142,0,0,235,53,0,0,26,
  1,0,213,229,127,0,0,226,104,22,28,229,0,1,81,225,5,0,0,26,108,22,28,229,8,0,81,227,45,0,0,42,
  0,0,85,229,1,0,80,225,42,0,0,10,108,22,28,229,8,0,81,227,3,0,0,58,0,0,85,229,127,0,0,226,
  0,1,81,225,35,0,0,10,64,0,45,233,58,0,0,235,64,0,189,232,31,0,0,26,0,0,85,229,8,0,80,227,
  23,0,0,58,0,0,85,229,127,0,0,226,0,1,220,231,64,0,80,227,18,0,0,10,84,0,80,227,16,0,0,10,
  86,0,80,227,14,0,0,10,88,0,80,227,12,0,0,10,90,0,80,227,10,0,0,10,64,0,45,233,0,48,21,229,
  243,246,255,235,105,1,0,235,1,0,45,233,0,48,21,229,105,247,255,235,1,0,189,232,64,0,189,232,0,0,80,227,
  6,0,0,10,96,0,45,233,124,0,0,235,96,0,189,232,3,0,80,227,1,0,0,58,0,0,21,229,4,0,134,228,
  4,80,133,226,172,15,28,229,0,0,85,225,193,255,255,26,172,111,12,229,4,240,157,228,176,95,28,229,172,111,28,229,
  6,0,85,225,14,240,160,1,4,224,45,229,88,0,0,235,5,96,160,225,71,0,0,235,1,0,0,10,0,0,21,229,
  4,0,134,228,4,80,133,226,172,15,28,229,0,0,85,225,247,255,255,26,172,111,12,229,4,240,157,228,4,224,45,229,
  236,10,28,229,0,0,80,227,22,0,0,10,0,48,21,229,199,246,255,235,236,122,28,229,7,128,140,224,36,6,24,229,
  24,20,24,229,1,0,128,225,32,24,160,225,1,8,32,224,0,0,139,224,0,0,208,229,1,16,139,224,0,16,209,229,
  1,0,64,224,1,0,45,233,0,48,21,229,50,247,255,235,1,0,189,232,232,26,28,229,1,0,80,225,1,0,0,218,
  1,0,176,227,4,240,157,228,0,0,176,227,4,240,157,228,176,95,28,229,172,111,28,229,6,112,160,225,7,0,85,225,
  3,0,0,10,4,48,149,228,12,48,134,228,4,96,6,229,249,255,255,234,0,0,160,227,4,0,6,229,172,111,12,229,
  14,240,160,225,176,111,28,229,0,48,21,229,4,48,134,228,8,80,149,229,0,0,85,227,250,255,255,26,172,111,12,229,
  14,240,160,225,176,111,28,229,4,0,149,229,4,0,80,225,6,0,0,186,0,0,21,229,4,0,134,228,8,80,149,229,
  0,0,85,227,1,0,0,10,1,48,83,226,245,255,255,26,172,111,12,229,14,240,160,225,1,0,213,229,127,0,0,226,
  64,27,28,229,0,1,81,225,7,0,0,10,10,0,64,226,0,1,81,225,2,0,0,26,0,0,85,229,0,0,80,227,
  1,0,0,10,0,0,176,227,14,240,160,225,1,0,176,227,14,240,160,225,160,15,28,229,3,0,80,229,127,0,0,226,
  0,1,160,225,130,15,96,226,64,11,12,229,14,240,160,225,0,0,21,229,0,1,160,225,32,20,160,225,127,15,0,226,
  127,31,1,226,0,0,140,224,10,2,16,229,1,16,140,224,10,18,17,229,1,0,16,224,1,0,176,19,14,240,160,225,
  4,224,45,229,0,112,85,229,8,0,87,227,13,0,0,58,32,0,45,233,127,80,7,226,5,81,160,225,234,7,0,235,
  32,0,189,232,1,112,213,229,127,112,7,226,7,1,220,231,32,0,16,227,3,0,0,10,7,129,140,224,37,6,216,229,
  2,0,64,226,37,6,200,229,0,48,21,229,88,246,255,235,181,0,0,235,176,0,45,233,0,96,21,229,6,97,160,225,
  38,84,160,225,127,95,5,226,127,111,6,226,212,4,0,235,176,0,189,232,184,0,0,235,1,0,45,233,0,48,21,229,
  197,246,255,235,0,112,85,229,8,0,87,227,13,0,0,58,32,0,45,233,127,80,7,226,5,81,160,225,178,7,0,235,
  32,0,189,232,1,112,213,229,127,112,7,226,7,1,220,231,32,0,16,227,3,0,0,10,7,129,140,224,37,6,216,229,
  2,0,128,226,37,6,200,229,1,0,189,232,0,112,85,229,8,0,87,227,27,0,0,58,127,112,7,226,7,129,140,224,
  24,68,88,229,0,0,84,227,12,0,0,10,4,64,139,224,0,68,212,229,0,0,84,227,7,0,0,10,128,0,20,227,
  1,76,68,18,4,128,136,224,0,16,88,229,0,0,81,227,251,255,255,10,32,0,17,227,0,0,0,10,1,0,128,226,
  0,112,85,229,127,112,7,226,7,113,160,225,204,0,87,227,4,0,0,42,7,128,140,224,40,16,216,229,64,0,81,227,
  0,0,0,26,1,0,128,226,1,112,213,229,127,112,7,226,7,17,220,231,0,0,81,227,0,0,0,10,1,0,128,226,
  4,240,157,228,4,224,45,229,0,48,21,229,16,246,255,235,48,0,45,233,133,0,0,235,0,0,160,227,14,0,0,26,
  72,27,28,229,68,43,28,229,176,63,28,229,172,79,28,229,30,0,45,233,176,79,12,229,36,11,28,229,83,0,0,235,
  30,0,189,232,72,27,12,229,68,43,12,229,176,63,12,229,172,79,12,229,0,0,80,227,1,0,160,19,48,0,189,232,
  1,0,45,233,0,48,21,229,115,246,255,235,1,0,189,232,4,240,157,228,0,16,21,229,176,111,28,229,6,0,85,225,
  2,0,0,10,4,0,21,229,4,0,5,228,250,255,255,234,0,16,5,229,14,240,160,225,4,224,45,229,180,63,28,229,
  3,0,115,227,2,48,224,179,8,48,131,226,0,152,131,224,72,27,28,229,1,0,80,225,5,0,0,218,68,43,28,229,
  2,0,80,225,5,0,0,170,1,156,137,226,24,249,255,235,4,240,157,228,2,156,137,226,21,249,255,235,4,240,157,228,
  3,156,137,226,18,249,255,235,4,240,157,228,4,224,45,229,10,128,160,227,15,249,255,235,0,0,89,227,2,0,0,10,
  73,8,160,225,4,240,157,228,4,224,45,229,16,252,255,235,165,14,0,235,1,0,45,233,0,152,160,225,1,144,137,226,
  10,128,160,227,2,249,255,235,1,0,189,232,4,240,157,228,4,224,45,229,234,244,255,235,183,246,255,235,234,255,255,235,
  1,0,45,233,230,244,255,235,179,246,255,235,1,0,189,232,0,0,96,226,4,240,157,228,4,224,45,229,19,0,0,235,
  0,0,0,234,4,224,45,229,180,31,28,229,2,0,45,233,180,15,12,229,81,0,0,235,2,0,189,232,180,31,12,229,
  4,240,157,228,4,224,45,229,8,0,0,235,0,0,0,234,4,224,45,229,180,31,28,229,2,0,45,233,180,15,12,229,
  77,0,0,235,2,0,189,232,180,31,12,229,4,240,157,228,180,15,28,229,0,0,128,224,0,0,160,67,1,0,128,224,
  9,0,80,227,9,0,160,195,14,240,160,225,0,16,85,229,8,0,81,227,5,0,0,58,127,16,1,226,1,161,140,224,
  2,112,218,229,0,16,160,227,2,16,202,229,14,240,160,225,1,112,139,224,100,121,87,229,14,240,160,225,0,16,85,229,
  8,0,81,227,2,0,0,58,127,16,1,226,1,161,140,224,2,112,202,229,14,240,160,225,168,31,28,229,1,16,140,224,
  36,6,17,229,22,20,81,229,32,8,145,225,14,240,160,225,164,31,28,229,1,16,140,224,34,6,17,229,24,20,81,229,
  32,8,145,225,14,240,160,225,224,177,255,255,32,78,0,0,224,177,255,255,224,177,255,255,224,177,255,255,32,78,0,0,
  224,177,255,255,32,78,0,0,4,224,45,229,180,159,28,229,1,0,160,227,180,15,12,229,30,0,160,227,181,15,76,229,
  0,2,45,233,69,0,0,235,0,2,189,232,0,0,80,227,7,0,0,26,180,15,28,229,2,0,128,226,180,15,12,229,
  9,0,80,225,245,255,255,218,180,159,12,229,0,0,160,227,4,240,157,228,180,159,12,229,4,0,160,225,4,240,157,228,
  4,224,45,229,30,0,160,227,181,15,76,229,51,0,0,235,0,0,80,227,4,0,160,17,4,240,157,228,4,224,45,229,
  127,244,255,235,76,246,255,235,244,255,255,235,1,0,45,233,123,244,255,235,72,246,255,235,1,0,189,232,4,240,157,228,
  4,224,45,229,1,0,160,227,180,15,12,229,30,0,160,227,181,15,76,229,33,0,0,235,0,0,80,227,8,0,0,26,
  180,15,28,229,2,0,128,226,180,15,12,229,15,0,80,227,247,255,255,218,0,0,160,227,32,87,159,229,0,0,5,229,
  4,240,157,228,180,15,28,229,1,0,45,233,0,0,0,234,18,0,0,235,176,95,28,229,4,64,133,228,176,95,12,229,
  0,0,84,227,10,0,0,10,4,48,160,225,56,245,255,235,87,0,0,235,176,95,28,229,4,64,133,228,176,95,12,229,
  0,0,84,227,2,0,0,10,4,48,160,225,109,245,255,235,238,255,255,234,1,0,189,232,180,15,12,229,4,240,157,228,
  180,15,28,229,1,0,80,227,154,0,0,218,4,224,45,229,103,251,255,235,0,0,160,227,32,11,12,229,176,111,28,229,
  197,75,0,235,172,111,12,229,176,95,28,229,6,0,85,225,61,0,0,10,159,1,0,235,172,15,28,229,0,0,85,225,
  52,0,0,42,0,48,21,229,25,245,255,235,176,31,28,229,172,47,28,229,32,59,28,229,62,0,45,233,176,47,12,229,
  51,0,0,235,62,0,189,232,176,31,12,229,172,47,12,229,32,27,28,229,1,48,131,225,32,59,12,229,3,0,45,233,
  0,48,21,229,132,245,255,235,3,0,189,232,0,0,80,227,17,0,0,26,0,0,81,227,13,0,0,26,4,0,149,229,
  128,0,128,227,0,16,21,229,1,0,80,225,8,0,0,26,127,0,0,226,0,1,220,231,64,0,80,227,3,0,0,10,
  84,0,80,227,1,0,0,10,88,0,80,227,0,0,0,26,4,80,133,226,4,80,133,226,214,255,255,234,1,0,45,233,
  172,95,12,229,116,1,0,235,172,95,28,229,1,0,189,232,1,0,45,233,0,144,21,229,180,31,28,229,0,20,129,225,
  9,152,129,225,6,128,160,227,33,248,255,235,1,0,189,232,0,64,21,229,4,240,157,228,32,155,28,229,180,15,92,229,
  9,152,128,225,6,128,160,227,25,248,255,235,0,0,160,227,4,240,157,228,180,15,28,229,0,0,80,227,142,0,0,218,
  4,224,45,229,0,0,160,227,32,11,12,229,176,111,28,229,89,92,0,235,172,111,12,229,176,95,28,229,6,0,85,225,
  9,0,0,26,156,15,92,229,0,0,80,227,2,0,0,26,3,0,160,227,0,64,160,227,4,240,157,228,1,0,160,227,
  32,11,12,229,0,0,160,227,4,240,157,228,0,16,160,227,4,48,160,227,0,64,160,227,3,0,0,234,172,15,28,229,
  0,0,85,225,49,0,0,42,4,16,21,229,24,0,45,233,0,48,21,229,127,0,3,226,8,0,80,227,10,0,0,42,
  127,0,1,226,8,0,80,227,2,0,0,42,33,4,160,225,35,4,80,225,12,0,0,10,183,0,0,235,10,0,0,10,
  45,1,0,235,24,0,189,232,235,255,255,234,0,48,21,229,142,0,0,235,4,0,0,10,152,0,0,235,2,0,0,10,
  4,80,133,226,24,0,189,232,227,255,255,234,0,48,21,229,228,244,255,235,176,31,28,229,172,47,28,229,54,0,45,233,
  176,47,12,229,117,255,255,235,54,0,189,232,176,31,12,229,172,47,12,229,1,0,45,233,0,48,21,229,74,245,255,235,
  1,0,189,232,24,0,189,232,0,0,80,227,5,0,0,10,3,0,80,225,1,0,0,42,0,48,160,225,0,64,21,229,
  4,80,133,226,204,255,255,234,0,0,160,227,4,240,157,228,3,0,160,225,4,240,157,228,4,224,45,229,0,0,160,227,
  32,11,12,229,176,111,28,229,59,75,0,235,172,111,12,229,176,95,28,229,6,0,85,225,53,0,0,10,172,15,28,229,
  0,0,85,225,45,0,0,42,0,48,21,229,128,244,255,235,176,31,28,229,172,47,28,229,32,59,28,229,62,0,45,233,
  176,47,12,229,44,0,0,235,62,0,189,232,176,31,12,229,172,47,12,229,32,27,28,229,1,48,131,225,32,59,12,229,
  3,0,45,233,0,48,21,229,235,244,255,235,3,0,189,232,0,0,80,227,15,0,0,26,4,0,149,229,128,0,128,227,
  0,16,21,229,1,0,80,225,8,0,0,26,127,0,0,226,0,1,220,231,64,0,80,227,3,0,0,10,84,0,80,227,
  1,0,0,10,88,0,80,227,0,0,0,26,4,80,133,226,4,80,133,226,216,255,255,234,1,0,45,233,0,144,21,229,
  180,31,28,229,0,20,129,225,9,152,129,225,6,128,160,227,143,247,255,235,1,0,189,232,0,64,21,229,4,240,157,228,
  32,155,28,229,180,15,28,229,9,152,128,225,6,128,160,227,135,247,255,235,0,0,160,227,4,240,157,228,4,224,45,229,
  0,0,160,227,32,11,12,229,11,1,0,235,36,0,0,10,76,11,28,229,0,0,80,227,14,0,0,26,156,15,92,229,
  0,0,80,227,6,0,0,26,196,15,28,229,192,31,28,229,1,0,144,225,1,0,160,227,2,0,160,19,0,64,160,227,
  4,240,157,228,1,0,160,227,32,11,12,229,0,0,160,227,0,64,160,227,4,240,157,228,176,111,28,229,203,91,0,235,
  172,111,12,229,176,95,28,229,172,15,28,229,0,0,85,225,236,255,255,42,0,0,85,229,127,0,0,226,8,0,80,227,
  3,0,0,42,44,0,0,235,5,0,0,10,162,0,0,235,244,255,255,234,17,0,0,235,1,0,0,10,4,80,133,226,
  240,255,255,234,0,0,160,227,0,64,160,227,4,240,157,228,127,12,3,226,32,3,220,231,0,0,80,227,3,0,0,26,
  127,0,3,226,7,1,220,231,60,0,80,227,1,0,0,26,0,0,176,227,14,240,160,225,1,0,176,227,14,240,160,225,
  4,224,45,229,0,48,21,229,78,244,255,235,176,31,28,229,172,47,28,229,54,0,45,233,176,47,12,229,180,31,28,229,
  2,16,129,226,180,31,12,229,43,0,0,235,180,31,28,229,2,16,65,226,180,31,12,229,54,0,189,232,176,31,12,229,
  172,47,12,229,1,0,45,233,0,48,21,229,174,244,255,235,1,0,189,232,0,0,160,227,4,240,157,228,4,224,45,229,
  181,15,92,229,0,0,80,227,25,0,0,218,0,48,21,229,255,48,195,227,7,48,131,227,50,244,255,235,176,31,28,229,
  172,47,28,229,54,0,45,233,176,47,12,229,180,31,28,229,2,16,129,226,180,31,12,229,15,0,0,235,180,31,28,229,
  2,16,65,226,180,31,12,229,54,0,189,232,176,31,12,229,172,47,12,229,1,0,45,233,0,48,21,229,255,48,195,227,
  7,48,131,227,144,244,255,235,1,0,189,232,0,0,176,227,4,240,157,228,1,0,176,227,4,240,157,228,4,224,45,229,
  0,0,160,227,32,11,12,229,0,64,21,229,16,0,45,233,176,111,28,229,120,74,0,235,172,111,12,229,16,0,189,232,
  36,68,160,225,176,95,28,229,5,96,160,225,172,15,28,229,0,0,85,225,3,0,0,10,4,48,149,228,35,4,84,225,
  4,48,134,4,248,255,255,234,172,111,12,229,4,1,220,231,32,1,160,225,7,0,0,226,24,11,12,229,176,95,28,229,
  172,15,28,229,0,0,85,225,57,0,0,42,0,48,21,229,191,243,255,235,24,27,28,229,1,160,140,224,196,15,90,229,
  1,0,64,226,196,15,74,229,189,15,92,229,1,0,128,226,189,15,76,229,24,11,28,229,176,31,28,229,172,47,28,229,
  32,59,28,229,63,0,45,233,176,47,12,229,208,254,255,235,63,0,189,232,24,11,12,229,176,31,12,229,172,47,12,229,
  32,27,28,229,1,48,131,225,32,59,12,229,24,27,28,229,1,160,140,224,196,15,90,229,1,0,128,226,196,15,74,229,
  189,15,92,229,1,0,64,226,189,15,76,229,3,0,45,233,0,48,21,229,24,244,255,235,3,0,189,232,0,0,80,227,
  17,0,0,26,0,0,81,227,13,0,0,26,4,0,149,229,128,0,128,227,0,16,21,229,1,0,80,225,8,0,0,26,
  127,112,0,226,7,1,220,231,64,0,80,227,3,0,0,10,84,0,80,227,1,0,0,10,88,0,80,227,0,0,0,26,
  4,80,133,226,4,80,133,226,196,255,255,234,1,0,176,227,4,240,157,228,0,0,176,227,4,240,157,228,0,64,21,229,
  7,64,196,227,4,0,181,229,7,0,192,227,4,0,80,225,251,255,255,10,14,240,160,225,14,240,160,225,14,240,160,225,
  216,38,0,224,17,0,84,227,38,0,0,218,4,224,45,229,164,0,160,225,0,64,68,224,1,0,45,233,248,255,255,235,
  16,0,189,232,32,0,45,233,245,255,255,235,64,0,189,232,188,112,159,229,4,0,149,229,4,16,150,229,1,0,80,225,
  8,0,0,186,8,80,135,229,4,16,150,229,5,112,160,225,8,80,149,229,0,0,85,227,12,0,0,10,4,0,149,229,
  1,0,80,225,248,255,255,170,8,96,135,229,4,16,149,229,6,112,160,225,8,96,150,229,0,0,86,227,6,0,0,10,
  4,0,150,229,1,0,80,225,248,255,255,170,236,255,255,234,8,96,135,229,12,91,28,229,4,240,157,228,8,80,135,229,
  12,91,28,229,4,240,157,228,0,0,160,227,12,11,12,229,4,16,152,229,60,96,159,229,6,112,160,225,8,96,150,229,
  0,0,86,227,2,0,0,10,4,0,150,229,1,0,80,225,248,255,255,202,8,16,160,225,8,128,152,229,8,16,135,229,
  8,96,129,229,1,64,84,226,240,255,255,26,12,91,28,229,14,240,160,225,212,9,0,224,212,9,0,224,4,224,45,229,
  164,95,28,229,0,0,85,227,95,0,0,10,5,112,140,224,34,6,23,229,24,68,87,229,32,8,148,225,90,0,0,10,
  128,0,20,227,6,0,0,26,44,0,215,229,160,0,16,227,3,0,0,26,246,5,23,229,236,19,87,229,32,8,145,225,
  81,0,0,10,64,0,20,227,6,0,0,26,40,0,215,229,160,0,16,227,3,0,0,26,250,5,23,229,240,19,87,229,
  32,8,145,225,72,0,0,10,32,0,20,227,6,0,0,26,36,0,215,229,160,0,16,227,3,0,0,26,254,5,23,229,
  244,19,87,229,32,8,145,225,63,0,0,10,16,0,20,227,6,0,0,26,4,0,215,229,160,0,16,227,3,0,0,26,
  30,6,23,229,20,20,87,229,32,8,145,225,54,0,0,10,8,0,20,227,6,0,0,26,4,0,87,229,160,0,16,227,
  3,0,0,26,38,6,23,229,28,20,87,229,32,8,145,225,45,0,0,10,4,0,20,227,6,0,0,26,36,0,87,229,
  160,0,16,227,3,0,0,26,70,6,23,229,60,20,87,229,32,8,145,225,36,0,0,10,2,0,20,227,6,0,0,26,
  40,0,87,229,160,0,16,227,3,0,0,26,74,6,23,229,64,20,87,229,32,8,145,225,27,0,0,10,1,0,20,227,
  6,0,0,26,44,0,87,229,160,0,16,227,3,0,0,26,78,6,23,229,68,20,87,229,32,8,145,225,18,0,0,10,
  71,246,255,235,80,107,28,229,1,0,118,227,12,0,0,10,6,160,140,224,36,6,26,229,22,20,90,229,32,8,129,225,
  5,160,140,224,34,22,26,229,24,36,90,229,33,24,130,225,1,0,208,225,2,0,0,10,225,247,255,235,4,0,0,235,
  1,0,0,26,1,0,176,227,4,240,157,228,0,0,176,227,4,240,157,228,80,107,28,229,6,160,140,224,36,6,26,229,
  22,20,90,229,32,72,129,225,164,95,28,229,5,160,140,224,34,6,26,229,24,20,90,229,32,8,129,225,0,64,212,225,
  99,0,0,10,1,12,20,227,3,0,0,10,6,0,140,224,187,1,208,229,0,0,80,227,95,0,0,10,2,12,20,227,
  3,0,0,10,6,0,140,224,195,1,208,229,0,0,80,227,89,0,0,10,1,0,20,227,8,0,0,10,6,112,160,225,
  44,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,78,0,0,10,
  2,0,20,227,8,0,0,10,6,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,
  15,2,208,229,0,0,80,227,67,0,0,10,4,0,20,227,8,0,0,10,6,112,160,225,36,112,71,226,7,0,220,231,
  0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,56,0,0,10,8,0,20,227,8,0,0,10,
  6,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,
  45,0,0,10,16,0,20,227,8,0,0,10,6,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,
  7,0,140,224,15,2,208,229,0,0,80,227,34,0,0,10,32,0,20,227,8,0,0,10,6,112,160,225,36,112,135,226,
  7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,23,0,0,10,64,0,20,227,
  8,0,0,10,6,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,
  0,0,80,227,12,0,0,10,128,0,20,227,8,0,0,10,6,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,
  251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,1,0,0,10,0,0,176,227,14,240,160,225,1,0,176,227,
  14,240,160,225,164,95,28,229,5,112,140,224,24,68,87,229,0,48,160,227,128,0,20,227,9,0,0,26,44,0,215,229,
  160,0,16,227,6,0,0,26,246,5,23,229,236,19,87,229,32,8,145,225,2,0,0,26,5,0,143,224,136,1,144,229,
  0,48,131,224,64,0,20,227,9,0,0,26,40,0,215,229,160,0,16,227,6,0,0,26,250,5,23,229,240,19,87,229,
  32,8,145,225,2,0,0,26,5,0,143,224,84,1,144,229,0,48,131,224,32,0,20,227,9,0,0,26,36,0,215,229,
  160,0,16,227,6,0,0,26,254,5,23,229,244,19,87,229,32,8,145,225,2,0,0,26,5,0,143,224,32,1,144,229,
  0,48,131,224,16,0,20,227,9,0,0,26,4,0,215,229,160,0,16,227,6,0,0,26,30,6,23,229,20,20,87,229,
  32,8,145,225,2,0,0,26,5,0,143,224,208,0,144,229,0,48,131,224,8,0,20,227,9,0,0,26,4,0,87,229,
  160,0,16,227,6,0,0,26,38,6,23,229,28,20,87,229,32,8,145,225,2,0,0,26,5,0,143,224,152,0,144,229,
  0,48,131,224,4,0,20,227,9,0,0,26,36,0,87,229,160,0,16,227,6,0,0,26,70,6,23,229,60,20,87,229,
  32,8,145,225,2,0,0,26,5,0,143,224,72,0,144,229,0,48,131,224,2,0,20,227,9,0,0,26,40,0,87,229,
  160,0,16,227,6,0,0,26,74,6,23,229,64,20,87,229,32,8,145,225,2,0,0,26,5,0,143,224,20,0,144,229,
  0,48,131,224,1,0,20,227,9,0,0,26,44,0,87,229,160,0,16,227,6,0,0,26,78,6,23,229,68,20,87,229,
  32,8,145,225,2,0,0,26,5,0,143,224,32,0,16,229,0,48,131,224,1,11,99,226,14,240,160,225,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,
  30,0,0,0,30,0,0,0,24,0,0,0,18,0,0,0,14,0,0,0,0,0,0,0,18,0,0,0,24,0,0,0,
  30,0,0,0,40,0,0,0,40,0,0,0,40,0,0,0,30,0,0,0,24,0,0,0,18,0,0,0,0,0,0,0,
  24,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,52,0,0,0,52,0,0,0,40,0,0,0,30,0,0,0,
  24,0,0,0,0,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,80,0,0,0,80,0,0,0,80,0,0,0,
  52,0,0,0,40,0,0,0,30,0,0,0,0,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,80,0,0,0,
  80,0,0,0,80,0,0,0,52,0,0,0,40,0,0,0,30,0,0,0,0,0,0,0,30,0,0,0,40,0,0,0,
  52,0,0,0,80,0,0,0,80,0,0,0,80,0,0,0,52,0,0,0,40,0,0,0,30,0,0,0,0,0,0,0,
  24,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,52,0,0,0,52,0,0,0,40,0,0,0,30,0,0,0,
  24,0,0,0,0,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,40,0,0,0,40,0,0,0,40,0,0,0,
  30,0,0,0,24,0,0,0,18,0,0,0,0,0,0,0,14,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,
  30,0,0,0,30,0,0,0,24,0,0,0,18,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,4,224,45,229,252,106,12,229,0,123,12,229,0,0,160,227,8,11,12,229,4,11,12,229,226,2,0,235,
  5,112,160,225,157,19,0,235,236,10,28,229,0,0,80,227,26,0,0,10,153,8,92,229,128,24,28,229,1,0,128,224,
  0,27,28,229,0,0,81,225,20,0,0,42,236,122,28,229,7,128,140,224,36,6,216,229,37,22,216,229,1,0,64,224,
  228,26,28,229,1,0,80,225,33,0,0,202,36,22,24,229,24,4,24,229,0,16,129,225,33,40,160,225,2,24,33,224,
  1,16,139,224,0,16,209,229,2,32,139,224,0,32,210,229,2,16,65,224,232,10,28,229,0,0,81,225,20,0,0,202,
  5,96,140,224,0,16,86,229,64,0,81,227,6,0,0,10,66,0,81,227,4,0,0,10,153,8,92,229,4,0,128,226,
  0,43,28,229,0,0,82,225,11,0,0,42,30,16,1,226,13,2,214,229,0,16,129,225,129,0,143,224,48,240,144,229,
  8,11,28,229,128,0,160,225,4,27,28,229,1,0,128,224,2,0,0,234,4,0,160,227,0,0,0,234,0,0,160,227,
  1,0,45,233,192,2,0,235,1,0,189,232,4,240,157,228,20,85,0,0,236,85,0,0,44,85,0,0,236,85,0,0,
  88,85,0,0,236,85,0,0,132,85,0,0,236,85,0,0,236,85,0,0,0,0,0,0,104,86,0,0,12,87,0,0,
  0,88,0,0,164,88,0,0,152,89,0,0,0,0,0,0,40,85,0,0,72,91,0,0,40,85,0,0,72,91,0,0,
  40,85,0,0,72,91,0,0,28,91,0,0,72,91,0,0,72,91,0,0,0,0,0,0,164,91,0,0,248,91,0,0,
  40,85,0,0,160,92,0,0,40,85,0,0,0,0,0,0,20,85,0,0,96,91,0,0,44,85,0,0,96,91,0,0,
  40,85,0,0,96,91,0,0,20,85,0,0,96,91,0,0,96,91,0,0,0,0,0,0,40,85,0,0,96,91,0,0,
  76,92,0,0,204,92,0,0,40,85,0,0,0,0,0,0,40,85,0,0,140,91,0,0,40,85,0,0,140,91,0,0,
  40,85,0,0,140,91,0,0,192,85,0,0,140,91,0,0,140,91,0,0,0,0,0,0,184,86,0,0,172,87,0,0,
  40,85,0,0,32,93,0,0,40,85,0,0,0,0,0,0,40,85,0,0,60,86,0,0,40,85,0,0,60,86,0,0,
  40,85,0,0,60,86,0,0,40,85,0,0,60,86,0,0,60,86,0,0,0,0,0,0,40,85,0,0,60,86,0,0,
  80,88,0,0,68,89,0,0,40,85,0,0,0,0,0,0,0,144,86,229,30,144,9,226,2,144,137,227,137,144,139,224,
  180,145,25,229,7,144,137,224,84,144,73,226,0,48,25,229,0,144,86,229,30,144,9,226,137,144,139,224,180,145,25,229,
  5,144,137,224,84,144,73,226,0,0,25,229,0,48,83,224,0,48,160,51,163,50,160,225,0,0,0,234,0,48,160,227,
  4,224,45,229,32,0,45,233,252,90,28,229,143,18,0,235,32,0,189,232,2,16,216,229,3,0,145,224,37,0,0,10,
  155,72,92,229,4,16,129,224,0,11,28,229,0,0,81,225,32,0,0,218,0,0,86,229,64,0,80,227,2,0,0,10,
  0,0,88,229,0,0,80,227,24,0,0,10,8,11,28,229,1,0,128,226,8,11,12,229,0,0,88,229,60,0,80,227,
  14,0,0,10,9,2,88,229,0,0,80,227,4,0,0,26,0,0,83,227,15,0,0,10,0,11,28,229,0,0,84,225,
  12,0,0,218,2,16,216,229,0,11,28,229,0,0,81,225,2,0,0,202,60,10,216,229,0,0,80,227,5,0,0,26,
  8,11,28,229,1,0,128,226,8,11,12,229,4,240,157,228,1,0,160,227,4,11,12,229,4,240,157,228,204,0,87,227,
  205,255,255,42,185,255,255,234,204,0,85,227,202,255,255,42,182,255,255,234,40,112,69,226,7,128,140,224,0,0,88,229,
  192,0,16,227,244,255,255,11,84,255,255,234,5,112,160,225,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,236,255,255,235,248,255,255,234,32,0,16,227,233,255,255,27,73,255,255,234,84,112,69,226,7,128,140,224,
  0,0,88,229,192,0,16,227,227,255,255,11,76,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,222,255,255,11,
  62,255,255,234,44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,216,255,255,11,44,112,133,226,7,128,140,224,
  0,0,88,229,192,0,16,227,214,255,255,11,40,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,206,255,255,11,
  36,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,201,255,255,11,36,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,199,255,255,11,36,255,255,234,44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,142,255,255,11,
  40,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,137,255,255,11,40,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,132,255,255,11,36,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,127,255,255,11,4,112,69,226,
  7,128,140,224,0,0,88,229,192,0,16,227,122,255,255,11,4,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,
  117,255,255,11,5,255,255,234,5,112,160,225,44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,
  157,255,255,235,248,255,255,234,32,0,16,227,154,255,255,27,5,112,160,225,44,112,135,226,7,128,140,224,0,0,88,229,
  0,0,80,227,1,0,0,26,150,255,255,235,248,255,255,234,32,0,16,227,147,255,255,27,5,112,160,225,36,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,137,255,255,235,248,255,255,234,32,0,16,227,134,255,255,27,
  5,112,160,225,36,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,130,255,255,235,248,255,255,234,
  32,0,16,227,127,255,255,27,220,254,255,234,40,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,70,255,255,11,
  4,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,65,255,255,11,4,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,60,255,255,11,40,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,55,255,255,11,5,112,160,225,
  44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,48,255,255,235,248,255,255,234,32,0,16,227,
  45,255,255,27,5,112,160,225,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,38,255,255,235,
  248,255,255,234,32,0,16,227,35,255,255,27,5,112,160,225,36,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,28,255,255,235,248,255,255,234,32,0,16,227,25,255,255,27,5,112,160,225,36,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,1,0,0,26,18,255,255,235,248,255,255,234,32,0,16,227,15,255,255,27,159,254,255,234,
  5,112,160,225,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,55,255,255,235,248,255,255,234,
  32,0,16,227,52,255,255,27,5,112,160,225,40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,
  48,255,255,235,248,255,255,234,32,0,16,227,45,255,255,27,5,112,160,225,4,112,71,226,7,128,140,224,0,0,88,229,
  0,0,80,227,1,0,0,26,35,255,255,235,248,255,255,234,32,0,16,227,32,255,255,27,5,112,160,225,4,112,135,226,
  7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,28,255,255,235,248,255,255,234,32,0,16,227,25,255,255,27,
  118,254,255,234,44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,224,254,255,11,36,112,69,226,7,128,140,224,
  0,0,88,229,192,0,16,227,219,254,255,11,36,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,214,254,255,11,
  44,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,209,254,255,11,5,112,160,225,40,112,71,226,7,128,140,224,
  0,0,88,229,0,0,80,227,1,0,0,26,202,254,255,235,248,255,255,234,32,0,16,227,199,254,255,27,5,112,160,225,
  40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,192,254,255,235,248,255,255,234,32,0,16,227,
  189,254,255,27,5,112,160,225,4,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,182,254,255,235,
  248,255,255,234,32,0,16,227,179,254,255,27,5,112,160,225,4,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,172,254,255,235,248,255,255,234,32,0,16,227,169,254,255,27,57,254,255,234,22,4,86,229,128,0,16,227,
  8,0,0,26,44,112,69,226,7,128,140,224,0,16,88,229,192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,
  32,24,145,225,156,254,255,11,22,4,86,229,64,0,16,227,8,0,0,26,40,112,69,226,7,128,140,224,0,16,88,229,
  192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,32,24,145,225,144,254,255,11,22,4,86,229,32,0,16,227,
  8,0,0,26,36,112,69,226,7,128,140,224,0,16,88,229,192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,
  32,24,145,225,132,254,255,11,22,4,86,229,16,0,16,227,8,0,0,26,4,112,69,226,7,128,140,224,0,16,88,229,
  192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,32,24,145,225,120,254,255,11,22,4,86,229,8,0,16,227,
  8,0,0,26,4,112,133,226,7,128,140,224,0,16,88,229,192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,
  32,24,145,225,108,254,255,11,22,4,86,229,4,0,16,227,8,0,0,26,36,112,133,226,7,128,140,224,0,16,88,229,
  192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,32,24,145,225,96,254,255,11,22,4,86,229,2,0,16,227,
  8,0,0,26,40,112,133,226,7,128,140,224,0,16,88,229,192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,
  32,24,145,225,84,254,255,11,22,4,86,229,1,0,16,227,8,0,0,26,44,112,133,226,7,128,140,224,0,16,88,229,
  192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,32,24,145,225,72,254,255,11,216,253,255,234,44,112,69,226,
  7,128,140,224,0,0,88,229,192,0,16,227,114,254,255,11,44,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,
  112,254,255,11,205,253,255,234,44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,55,254,255,11,199,253,255,234,
  40,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,49,254,255,11,40,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,44,254,255,11,188,253,255,234,36,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,38,254,255,11,
  182,253,255,234,5,112,160,225,44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,78,254,255,235,
  248,255,255,234,32,0,16,227,75,254,255,27,5,112,160,225,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,71,254,255,235,248,255,255,234,32,0,16,227,68,254,255,27,161,253,255,234,5,112,160,225,44,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,9,254,255,235,248,255,255,234,32,0,16,227,6,254,255,27,
  5,112,160,225,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,255,253,255,235,248,255,255,234,
  32,0,16,227,252,253,255,27,140,253,255,234,5,112,160,225,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,36,254,255,235,248,255,255,234,32,0,16,227,33,254,255,27,5,112,160,225,40,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,1,0,0,26,29,254,255,235,248,255,255,234,32,0,16,227,26,254,255,27,119,253,255,234,
  44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,225,253,255,11,44,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,220,253,255,11,108,253,255,234,5,112,160,225,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,212,253,255,235,248,255,255,234,32,0,16,227,209,253,255,27,5,112,160,225,40,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,1,0,0,26,202,253,255,235,248,255,255,234,32,0,16,227,199,253,255,27,87,253,255,234,
  36,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,193,253,255,11,36,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,188,253,255,11,76,253,255,234,5,96,140,224,0,0,86,229,0,0,80,227,18,0,0,10,32,0,16,227,
  8,0,0,26,30,0,0,226,13,18,214,229,1,0,128,225,128,0,143,224,148,240,144,229,36,6,214,229,2,0,128,226,
  36,6,198,229,14,240,160,225,30,0,0,226,15,18,214,229,1,0,128,225,128,0,143,224,176,241,144,229,37,6,214,229,
  2,0,128,226,37,6,198,229,14,240,160,225,5,96,140,224,0,0,86,229,0,0,80,227,18,0,0,10,32,0,16,227,
  8,0,0,26,30,0,0,226,13,18,214,229,1,0,128,225,128,0,143,224,180,242,144,229,36,6,214,229,2,0,64,226,
  36,6,198,229,14,240,160,225,30,0,0,226,15,18,214,229,1,0,128,225,128,0,143,224,208,243,144,229,37,6,214,229,
  2,0,64,226,37,6,198,229,14,240,160,225,12,99,0,0,204,99,0,0,28,99,0,0,204,99,0,0,112,99,0,0,
  204,99,0,0,140,99,0,0,204,99,0,0,204,99,0,0,0,0,0,0,72,100,0,0,24,100,0,0,188,101,0,0,
  140,101,0,0,160,104,0,0,0,0,0,0,24,99,0,0,28,103,0,0,24,99,0,0,28,103,0,0,24,99,0,0,
  28,103,0,0,0,103,0,0,28,103,0,0,28,103,0,0,0,0,0,0,88,103,0,0,88,103,0,0,24,99,0,0,
  0,103,0,0,24,99,0,0,0,0,0,0,12,99,0,0,44,103,0,0,28,99,0,0,44,103,0,0,24,99,0,0,
  44,103,0,0,12,99,0,0,44,103,0,0,44,103,0,0,0,0,0,0,24,99,0,0,44,103,0,0,252,103,0,0,
  252,103,0,0,24,99,0,0,0,0,0,0,24,99,0,0,72,103,0,0,24,99,0,0,72,103,0,0,24,99,0,0,
  72,103,0,0,176,99,0,0,72,103,0,0,72,103,0,0,0,0,0,0,232,100,0,0,232,100,0,0,24,99,0,0,
  176,99,0,0,24,99,0,0,0,0,0,0,24,99,0,0,252,99,0,0,24,99,0,0,252,99,0,0,24,99,0,0,
  252,99,0,0,24,99,0,0,252,99,0,0,252,99,0,0,0,0,0,0,24,99,0,0,252,99,0,0,92,102,0,0,
  92,102,0,0,24,99,0,0,0,0,0,0,4,105,0,0,196,105,0,0,20,105,0,0,196,105,0,0,104,105,0,0,
  196,105,0,0,132,105,0,0,196,105,0,0,196,105,0,0,0,0,0,0,64,106,0,0,16,106,0,0,180,107,0,0,
  132,107,0,0,152,110,0,0,0,0,0,0,16,105,0,0,20,109,0,0,16,105,0,0,20,109,0,0,16,105,0,0,
  20,109,0,0,248,108,0,0,20,109,0,0,20,109,0,0,0,0,0,0,80,109,0,0,80,109,0,0,16,105,0,0,
  248,108,0,0,16,105,0,0,0,0,0,0,4,105,0,0,36,109,0,0,20,105,0,0,36,109,0,0,16,105,0,0,
  36,109,0,0,4,105,0,0,36,109,0,0,36,109,0,0,0,0,0,0,16,105,0,0,36,109,0,0,244,109,0,0,
  244,109,0,0,16,105,0,0,0,0,0,0,16,105,0,0,64,109,0,0,16,105,0,0,64,109,0,0,16,105,0,0,
  64,109,0,0,168,105,0,0,64,109,0,0,64,109,0,0,0,0,0,0,224,106,0,0,224,106,0,0,16,105,0,0,
  168,105,0,0,16,105,0,0,0,0,0,0,16,105,0,0,244,105,0,0,16,105,0,0,244,105,0,0,16,105,0,0,
  244,105,0,0,16,105,0,0,244,105,0,0,244,105,0,0,0,0,0,0,16,105,0,0,244,105,0,0,84,108,0,0,
  84,108,0,0,16,105,0,0,0,0,0,0,252,110,0,0,188,111,0,0,12,111,0,0,188,111,0,0,96,111,0,0,
  188,111,0,0,124,111,0,0,188,111,0,0,188,111,0,0,0,0,0,0,56,112,0,0,8,112,0,0,172,113,0,0,
  124,113,0,0,144,116,0,0,0,0,0,0,8,111,0,0,12,115,0,0,8,111,0,0,12,115,0,0,8,111,0,0,
  12,115,0,0,240,114,0,0,12,115,0,0,12,115,0,0,0,0,0,0,72,115,0,0,72,115,0,0,8,111,0,0,
  240,114,0,0,8,111,0,0,0,0,0,0,252,110,0,0,28,115,0,0,12,111,0,0,28,115,0,0,8,111,0,0,
  28,115,0,0,252,110,0,0,28,115,0,0,28,115,0,0,0,0,0,0,8,111,0,0,28,115,0,0,236,115,0,0,
  236,115,0,0,8,111,0,0,0,0,0,0,8,111,0,0,56,115,0,0,8,111,0,0,56,115,0,0,8,111,0,0,
  56,115,0,0,160,111,0,0,56,115,0,0,56,115,0,0,0,0,0,0,216,112,0,0,216,112,0,0,8,111,0,0,
  160,111,0,0,8,111,0,0,0,0,0,0,8,111,0,0,236,111,0,0,8,111,0,0,236,111,0,0,8,111,0,0,
  236,111,0,0,8,111,0,0,236,111,0,0,236,111,0,0,0,0,0,0,8,111,0,0,236,111,0,0,76,114,0,0,
  76,114,0,0,8,111,0,0,0,0,0,0,244,116,0,0,180,117,0,0,4,117,0,0,180,117,0,0,88,117,0,0,
  180,117,0,0,116,117,0,0,180,117,0,0,180,117,0,0,0,0,0,0,48,118,0,0,0,118,0,0,164,119,0,0,
  116,119,0,0,136,122,0,0,0,0,0,0,0,117,0,0,4,121,0,0,0,117,0,0,4,121,0,0,0,117,0,0,
  4,121,0,0,232,120,0,0,4,121,0,0,4,121,0,0,0,0,0,0,64,121,0,0,64,121,0,0,0,117,0,0,
  232,120,0,0,0,117,0,0,0,0,0,0,244,116,0,0,20,121,0,0,4,117,0,0,20,121,0,0,0,117,0,0,
  20,121,0,0,244,116,0,0,20,121,0,0,20,121,0,0,0,0,0,0,0,117,0,0,20,121,0,0,228,121,0,0,
  228,121,0,0,0,117,0,0,0,0,0,0,0,117,0,0,48,121,0,0,0,117,0,0,48,121,0,0,0,117,0,0,
  48,121,0,0,152,117,0,0,48,121,0,0,48,121,0,0,0,0,0,0,208,118,0,0,208,118,0,0,0,117,0,0,
  152,117,0,0,0,117,0,0,0,0,0,0,0,117,0,0,228,117,0,0,0,117,0,0,228,117,0,0,0,117,0,0,
  228,117,0,0,0,117,0,0,228,117,0,0,228,117,0,0,0,0,0,0,0,117,0,0,228,117,0,0,68,120,0,0,
  68,120,0,0,0,117,0,0,0,0,0,0,252,5,214,229,3,0,128,226,252,5,198,229,150,254,255,234,5,112,160,225,
  40,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  252,5,216,229,3,0,128,226,252,5,200,229,129,254,255,234,208,5,214,229,3,0,128,226,208,5,198,229,216,5,214,229,
  3,0,128,226,216,5,198,229,122,254,255,234,248,5,214,229,3,0,128,226,248,5,198,229,80,6,214,229,3,0,128,226,
  80,6,198,229,252,5,214,229,3,0,128,226,252,5,198,229,0,6,214,229,3,0,128,226,0,6,198,229,72,6,214,229,
  3,0,128,226,72,6,198,229,106,254,255,234,248,5,214,229,3,0,128,226,248,5,198,229,252,5,214,229,3,0,128,226,
  252,5,198,229,76,6,214,229,3,0,128,226,76,6,198,229,0,6,214,229,3,0,128,226,0,6,198,229,32,6,214,229,
  3,0,128,226,32,6,198,229,40,6,214,229,3,0,128,226,40,6,198,229,87,254,255,234,252,5,214,229,3,0,128,226,
  252,5,198,229,76,6,214,229,3,0,128,226,76,6,198,229,32,6,214,229,3,0,128,226,32,6,198,229,40,6,214,229,
  3,0,128,226,40,6,198,229,5,112,160,225,44,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,248,5,216,229,3,0,128,226,248,5,200,229,5,112,160,225,44,112,135,226,
  7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,80,6,216,229,
  3,0,128,226,80,6,200,229,5,112,160,225,36,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,0,6,216,229,3,0,128,226,0,6,200,229,5,112,160,225,36,112,135,226,
  7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,72,6,216,229,
  3,0,128,226,72,6,200,229,250,253,255,234,248,5,214,229,3,0,128,226,248,5,198,229,80,6,214,229,3,0,128,226,
  80,6,198,229,0,6,214,229,3,0,128,226,0,6,198,229,72,6,214,229,3,0,128,226,72,6,198,229,5,112,160,225,
  40,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  252,5,216,229,3,0,128,226,252,5,200,229,5,112,160,225,40,112,135,226,7,128,140,224,36,6,216,229,3,0,128,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,76,6,216,229,3,0,128,226,76,6,200,229,5,112,160,225,
  4,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  32,6,216,229,3,0,128,226,32,6,200,229,5,112,160,225,4,112,135,226,7,128,140,224,36,6,216,229,3,0,128,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,40,6,216,229,3,0,128,226,40,6,200,229,157,253,255,234,
  248,5,214,229,3,0,128,226,248,5,198,229,80,6,214,229,3,0,128,226,80,6,198,229,150,253,255,234,248,5,214,229,
  3,0,128,226,248,5,198,229,146,253,255,234,252,5,214,229,3,0,128,226,252,5,198,229,76,6,214,229,3,0,128,226,
  76,6,198,229,139,253,255,234,0,6,214,229,3,0,128,226,0,6,198,229,135,253,255,234,5,112,160,225,44,112,71,226,
  7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,248,5,216,229,
  3,0,128,226,248,5,200,229,5,112,160,225,44,112,135,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,80,6,216,229,3,0,128,226,80,6,200,229,94,253,255,234,5,112,160,225,
  40,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  252,5,216,229,3,0,128,226,252,5,200,229,5,112,160,225,40,112,135,226,7,128,140,224,36,6,216,229,3,0,128,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,76,6,216,229,3,0,128,226,76,6,200,229,53,253,255,234,
  248,5,214,229,3,0,128,226,248,5,198,229,252,5,214,229,3,0,128,226,252,5,198,229,0,6,214,229,3,0,128,226,
  0,6,198,229,32,6,214,229,3,0,128,226,32,6,198,229,40,6,214,229,3,0,128,226,40,6,198,229,72,6,214,229,
  3,0,128,226,72,6,198,229,76,6,214,229,3,0,128,226,76,6,198,229,80,6,214,229,3,0,128,226,80,6,198,229,
  28,253,255,234,77,6,214,229,3,0,128,226,77,6,198,229,33,253,255,234,5,112,160,225,40,112,135,226,7,128,140,224,
  37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,77,6,216,229,3,0,128,226,
  77,6,200,229,12,253,255,234,121,6,214,229,3,0,128,226,121,6,198,229,113,6,214,229,3,0,128,226,113,6,198,229,
  5,253,255,234,81,6,214,229,3,0,128,226,81,6,198,229,249,5,214,229,3,0,128,226,249,5,198,229,77,6,214,229,
  3,0,128,226,77,6,198,229,73,6,214,229,3,0,128,226,73,6,198,229,1,6,214,229,3,0,128,226,1,6,198,229,
  245,252,255,234,81,6,214,229,3,0,128,226,81,6,198,229,77,6,214,229,3,0,128,226,77,6,198,229,253,5,214,229,
  3,0,128,226,253,5,198,229,73,6,214,229,3,0,128,226,73,6,198,229,41,6,214,229,3,0,128,226,41,6,198,229,
  33,6,214,229,3,0,128,226,33,6,198,229,226,252,255,234,77,6,214,229,3,0,128,226,77,6,198,229,253,5,214,229,
  3,0,128,226,253,5,198,229,41,6,214,229,3,0,128,226,41,6,198,229,33,6,214,229,3,0,128,226,33,6,198,229,
  5,112,160,225,44,112,135,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,81,6,216,229,3,0,128,226,81,6,200,229,5,112,160,225,44,112,71,226,7,128,140,224,37,6,216,229,
  3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,249,5,216,229,3,0,128,226,249,5,200,229,
  5,112,160,225,36,112,135,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,73,6,216,229,3,0,128,226,73,6,200,229,5,112,160,225,36,112,71,226,7,128,140,224,37,6,216,229,
  3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,1,6,216,229,3,0,128,226,1,6,200,229,
  133,252,255,234,81,6,214,229,3,0,128,226,81,6,198,229,249,5,214,229,3,0,128,226,249,5,198,229,73,6,214,229,
  3,0,128,226,73,6,198,229,1,6,214,229,3,0,128,226,1,6,198,229,5,112,160,225,40,112,135,226,7,128,140,224,
  37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,77,6,216,229,3,0,128,226,
  77,6,200,229,5,112,160,225,40,112,71,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,253,5,216,229,3,0,128,226,253,5,200,229,5,112,160,225,4,112,135,226,7,128,140,224,
  37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,41,6,216,229,3,0,128,226,
  41,6,200,229,5,112,160,225,4,112,71,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,33,6,216,229,3,0,128,226,33,6,200,229,40,252,255,234,81,6,214,229,3,0,128,226,
  81,6,198,229,249,5,214,229,3,0,128,226,249,5,198,229,33,252,255,234,81,6,214,229,3,0,128,226,81,6,198,229,
  29,252,255,234,77,6,214,229,3,0,128,226,77,6,198,229,253,5,214,229,3,0,128,226,253,5,198,229,22,252,255,234,
  73,6,214,229,3,0,128,226,73,6,198,229,18,252,255,234,5,112,160,225,44,112,135,226,7,128,140,224,37,6,216,229,
  3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,81,6,216,229,3,0,128,226,81,6,200,229,
  5,112,160,225,44,112,71,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,249,5,216,229,3,0,128,226,249,5,200,229,233,251,255,234,5,112,160,225,40,112,135,226,7,128,140,224,
  37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,77,6,216,229,3,0,128,226,
  77,6,200,229,5,112,160,225,40,112,71,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,253,5,216,229,3,0,128,226,253,5,200,229,192,251,255,234,81,6,214,229,3,0,128,226,
  81,6,198,229,77,6,214,229,3,0,128,226,77,6,198,229,73,6,214,229,3,0,128,226,73,6,198,229,41,6,214,229,
  3,0,128,226,41,6,198,229,33,6,214,229,3,0,128,226,33,6,198,229,1,6,214,229,3,0,128,226,1,6,198,229,
  253,5,214,229,3,0,128,226,253,5,198,229,249,5,214,229,3,0,128,226,249,5,198,229,167,251,255,234,252,5,214,229,
  3,0,64,226,252,5,198,229,178,251,255,234,5,112,160,225,40,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,252,5,216,229,3,0,64,226,252,5,200,229,157,251,255,234,
  208,5,214,229,3,0,64,226,208,5,198,229,216,5,214,229,3,0,64,226,216,5,198,229,150,251,255,234,248,5,214,229,
  3,0,64,226,248,5,198,229,80,6,214,229,3,0,64,226,80,6,198,229,252,5,214,229,3,0,64,226,252,5,198,229,
  0,6,214,229,3,0,64,226,0,6,198,229,72,6,214,229,3,0,64,226,72,6,198,229,134,251,255,234,248,5,214,229,
  3,0,64,226,248,5,198,229,252,5,214,229,3,0,64,226,252,5,198,229,76,6,214,229,3,0,64,226,76,6,198,229,
  0,6,214,229,3,0,64,226,0,6,198,229,32,6,214,229,3,0,64,226,32,6,198,229,40,6,214,229,3,0,64,226,
  40,6,198,229,115,251,255,234,252,5,214,229,3,0,64,226,252,5,198,229,76,6,214,229,3,0,64,226,76,6,198,229,
  32,6,214,229,3,0,64,226,32,6,198,229,40,6,214,229,3,0,64,226,40,6,198,229,5,112,160,225,44,112,71,226,
  7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,248,5,216,229,
  3,0,64,226,248,5,200,229,5,112,160,225,44,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,80,6,216,229,3,0,64,226,80,6,200,229,5,112,160,225,36,112,71,226,
  7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,0,6,216,229,
  3,0,64,226,0,6,200,229,5,112,160,225,36,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,72,6,216,229,3,0,64,226,72,6,200,229,22,251,255,234,248,5,214,229,
  3,0,64,226,248,5,198,229,80,6,214,229,3,0,64,226,80,6,198,229,0,6,214,229,3,0,64,226,0,6,198,229,
  72,6,214,229,3,0,64,226,72,6,198,229,5,112,160,225,40,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,252,5,216,229,3,0,64,226,252,5,200,229,5,112,160,225,
  40,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  76,6,216,229,3,0,64,226,76,6,200,229,5,112,160,225,4,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,32,6,216,229,3,0,64,226,32,6,200,229,5,112,160,225,
  4,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  40,6,216,229,3,0,64,226,40,6,200,229,185,250,255,234,248,5,214,229,3,0,64,226,248,5,198,229,80,6,214,229,
  3,0,64,226,80,6,198,229,178,250,255,234,248,5,214,229,3,0,64,226,248,5,198,229,174,250,255,234,252,5,214,229,
  3,0,64,226,252,5,198,229,76,6,214,229,3,0,64,226,76,6,198,229,167,250,255,234,0,6,214,229,3,0,64,226,
  0,6,198,229,163,250,255,234,5,112,160,225,44,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,248,5,216,229,3,0,64,226,248,5,200,229,5,112,160,225,44,112,135,226,
  7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,80,6,216,229,
  3,0,64,226,80,6,200,229,122,250,255,234,5,112,160,225,40,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,252,5,216,229,3,0,64,226,252,5,200,229,5,112,160,225,
  40,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  76,6,216,229,3,0,64,226,76,6,200,229,81,250,255,234,248,5,214,229,3,0,64,226,248,5,198,229,252,5,214,229,
  3,0,64,226,252,5,198,229,0,6,214,229,3,0,64,226,0,6,198,229,32,6,214,229,3,0,64,226,32,6,198,229,
  40,6,214,229,3,0,64,226,40,6,198,229,72,6,214,229,3,0,64,226,72,6,198,229,76,6,214,229,3,0,64,226,
  76,6,198,229,80,6,214,229,3,0,64,226,80,6,198,229,56,250,255,234,77,6,214,229,3,0,64,226,77,6,198,229,
  61,250,255,234,5,112,160,225,40,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,77,6,216,229,3,0,64,226,77,6,200,229,40,250,255,234,121,6,214,229,3,0,64,226,
  121,6,198,229,113,6,214,229,3,0,64,226,113,6,198,229,33,250,255,234,81,6,214,229,3,0,64,226,81,6,198,229,
  249,5,214,229,3,0,64,226,249,5,198,229,77,6,214,229,3,0,64,226,77,6,198,229,73,6,214,229,3,0,64,226,
  73,6,198,229,1,6,214,229,3,0,64,226,1,6,198,229,17,250,255,234,81,6,214,229,3,0,64,226,81,6,198,229,
  77,6,214,229,3,0,64,226,77,6,198,229,253,5,214,229,3,0,64,226,253,5,198,229,73,6,214,229,3,0,64,226,
  73,6,198,229,41,6,214,229,3,0,64,226,41,6,198,229,33,6,214,229,3,0,64,226,33,6,198,229,254,249,255,234,
  77,6,214,229,3,0,64,226,77,6,198,229,253,5,214,229,3,0,64,226,253,5,198,229,41,6,214,229,3,0,64,226,
  41,6,198,229,33,6,214,229,3,0,64,226,33,6,198,229,5,112,160,225,44,112,135,226,7,128,140,224,37,6,216,229,
  3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,81,6,216,229,3,0,64,226,81,6,200,229,
  5,112,160,225,44,112,71,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,249,5,216,229,3,0,64,226,249,5,200,229,5,112,160,225,36,112,135,226,7,128,140,224,37,6,216,229,
  3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,73,6,216,229,3,0,64,226,73,6,200,229,
  5,112,160,225,36,112,71,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,1,6,216,229,3,0,64,226,1,6,200,229,161,249,255,234,81,6,214,229,3,0,64,226,81,6,198,229,
  249,5,214,229,3,0,64,226,249,5,198,229,73,6,214,229,3,0,64,226,73,6,198,229,1,6,214,229,3,0,64,226,
  1,6,198,229,5,112,160,225,40,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,77,6,216,229,3,0,64,226,77,6,200,229,5,112,160,225,40,112,71,226,7,128,140,224,
  37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,253,5,216,229,3,0,64,226,
  253,5,200,229,5,112,160,225,4,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,41,6,216,229,3,0,64,226,41,6,200,229,5,112,160,225,4,112,71,226,7,128,140,224,
  37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,33,6,216,229,3,0,64,226,
  33,6,200,229,68,249,255,234,81,6,214,229,3,0,64,226,81,6,198,229,249,5,214,229,3,0,64,226,249,5,198,229,
  61,249,255,234,81,6,214,229,3,0,64,226,81,6,198,229,57,249,255,234,77,6,214,229,3,0,64,226,77,6,198,229,
  253,5,214,229,3,0,64,226,253,5,198,229,50,249,255,234,73,6,214,229,3,0,64,226,73,6,198,229,46,249,255,234,
  5,112,160,225,44,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,81,6,216,229,3,0,64,226,81,6,200,229,5,112,160,225,44,112,71,226,7,128,140,224,37,6,216,229,
  3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,249,5,216,229,3,0,64,226,249,5,200,229,
  5,249,255,234,5,112,160,225,40,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,77,6,216,229,3,0,64,226,77,6,200,229,5,112,160,225,40,112,71,226,7,128,140,224,
  37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,253,5,216,229,3,0,64,226,
  253,5,200,229,220,248,255,234,81,6,214,229,3,0,64,226,81,6,198,229,77,6,214,229,3,0,64,226,77,6,198,229,
  73,6,214,229,3,0,64,226,73,6,198,229,41,6,214,229,3,0,64,226,41,6,198,229,33,6,214,229,3,0,64,226,
  33,6,198,229,1,6,214,229,3,0,64,226,1,6,198,229,253,5,214,229,3,0,64,226,253,5,198,229,249,5,214,229,
  3,0,64,226,249,5,198,229,195,248,255,234,0,0,160,227,108,6,12,229,104,6,12,229,64,11,12,229,236,10,12,229,
  4,224,45,229,0,0,160,227,240,10,12,229,248,10,28,229,1,0,128,226,248,10,12,229,0,0,160,227,224,10,12,229,
  220,10,12,229,216,10,12,229,212,10,12,229,208,10,12,229,204,10,12,229,200,10,12,229,196,10,12,229,192,10,12,229,
  188,10,12,229,184,10,12,229,91,0,0,235,25,235,255,235,19,236,255,235,77,234,255,235,241,28,0,235,233,1,0,235,
  119,5,0,235,132,33,0,235,230,1,0,235,162,7,0,235,86,9,0,235,104,9,0,235,30,16,0,235,200,29,0,235,
  147,41,0,235,137,48,0,235,139,55,0,235,6,30,0,235,164,32,0,235,47,0,0,235,1,0,0,235,180,10,28,229,
  4,240,157,228,8,81,159,229,8,97,159,229,0,0,160,227,10,144,160,227,4,16,149,228,4,32,150,228,145,2,3,224,
  3,0,128,224,1,144,89,226,249,255,255,26,64,50,160,225,16,48,131,226,180,58,12,229,4,16,149,228,4,32,150,228,
  145,2,3,224,3,0,128,224,64,50,160,225,16,48,131,226,176,58,12,229,14,240,160,225,4,224,45,229,0,0,160,227,
  108,6,12,229,104,6,12,229,64,11,12,229,236,10,12,229,1,0,160,227,240,10,12,229,39,0,0,235,229,234,255,235,
  223,235,255,235,190,28,0,235,182,1,0,235,68,5,0,235,81,33,0,235,179,1,0,235,111,7,0,235,35,9,0,235,
  53,9,0,235,235,15,0,235,97,41,0,235,87,48,0,235,0,0,0,235,4,240,157,228,0,0,160,227,232,10,12,229,
  228,10,12,229,236,90,28,229,0,0,85,227,14,240,160,1,5,160,140,224,36,22,218,229,37,38,218,229,2,16,65,224,
  228,26,12,229,36,22,26,229,24,36,26,229,2,16,129,225,33,40,160,225,2,24,33,224,1,16,139,224,0,16,209,229,
  2,32,139,224,0,32,210,229,2,16,65,224,232,26,12,229,14,240,160,225,8,10,0,224,108,207,1,0,56,86,159,229,
  0,0,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,36,86,159,229,36,102,159,229,131,144,160,227,
  4,0,213,228,4,0,198,228,1,144,89,226,251,255,255,26,168,95,28,229,5,80,139,224,236,86,21,229,5,96,140,224,
  0,0,214,229,128,0,16,227,5,0,0,26,1,0,214,229,28,0,80,227,2,0,0,170,84,0,128,226,32,1,160,225,
  1,0,198,229,44,0,86,229,128,0,16,227,5,0,0,26,43,0,86,229,28,0,80,227,2,0,0,170,84,0,128,226,
  32,1,160,225,43,0,70,229,40,0,86,229,128,0,16,227,5,0,0,26,39,0,86,229,28,0,80,227,2,0,0,170,
  84,0,128,226,32,1,160,225,39,0,70,229,36,0,86,229,128,0,16,227,5,0,0,26,35,0,86,229,28,0,80,227,
  2,0,0,170,84,0,128,226,32,1,160,225,35,0,70,229,4,0,86,229,128,0,16,227,5,0,0,26,3,0,86,229,
  24,0,80,227,2,0,0,170,72,0,128,226,32,1,160,225,3,0,70,229,4,0,214,229,128,0,16,227,5,0,0,26,
  5,0,214,229,24,0,80,227,2,0,0,170,72,0,128,226,32,1,160,225,5,0,198,229,36,0,214,229,128,0,16,227,
  5,0,0,26,37,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,37,0,198,229,40,0,214,229,
  128,0,16,227,5,0,0,26,41,0,214,229,21,0,80,227,2,0,0,170,63,0,128,226,32,1,160,225,41,0,198,229,
  44,0,214,229,128,0,16,227,5,0,0,26,45,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,
  45,0,198,229,84,0,86,229,128,0,16,227,8,0,0,26,44,0,86,229,128,0,16,227,5,0,0,26,83,0,86,229,
  23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,83,0,70,229,80,0,86,229,128,0,16,227,8,0,0,26,
  40,0,86,229,128,0,16,227,5,0,0,26,79,0,86,229,23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,
  79,0,70,229,76,0,86,229,128,0,16,227,8,0,0,26,36,0,86,229,128,0,16,227,5,0,0,26,75,0,86,229,
  23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,75,0,70,229,48,0,86,229,128,0,16,227,8,0,0,26,
  44,0,86,229,128,0,16,227,5,0,0,26,47,0,86,229,22,0,80,227,2,0,0,170,66,0,128,226,32,1,160,225,
  47,0,70,229,32,0,86,229,128,0,16,227,8,0,0,26,36,0,86,229,128,0,16,227,5,0,0,26,31,0,86,229,
  22,0,80,227,2,0,0,170,66,0,128,226,32,1,160,225,31,0,70,229,88,0,86,229,128,0,16,227,8,0,0,26,
  44,0,86,229,128,0,16,227,5,0,0,26,87,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,
  87,0,70,229,72,0,86,229,128,0,16,227,8,0,0,26,36,0,86,229,128,0,16,227,5,0,0,26,71,0,86,229,
  20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,71,0,70,229,8,0,86,229,128,0,16,227,8,0,0,26,
  4,0,86,229,128,0,16,227,5,0,0,26,7,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,
  7,0,70,229,8,0,214,229,128,0,16,227,8,0,0,26,4,0,214,229,128,0,16,227,5,0,0,26,9,0,214,229,
  20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,9,0,198,229,164,95,28,229,5,80,139,224,236,86,21,229,
  5,96,140,224,0,0,214,229,128,0,16,227,5,0,0,26,1,0,214,229,28,0,80,227,2,0,0,170,84,0,128,226,
  32,1,160,225,1,0,198,229,44,0,214,229,128,0,16,227,5,0,0,26,45,0,214,229,28,0,80,227,2,0,0,170,
  84,0,128,226,32,1,160,225,45,0,198,229,40,0,214,229,128,0,16,227,5,0,0,26,41,0,214,229,28,0,80,227,
  2,0,0,170,84,0,128,226,32,1,160,225,41,0,198,229,36,0,214,229,128,0,16,227,5,0,0,26,37,0,214,229,
  28,0,80,227,2,0,0,170,84,0,128,226,32,1,160,225,37,0,198,229,4,0,214,229,128,0,16,227,5,0,0,26,
  5,0,214,229,24,0,80,227,2,0,0,170,72,0,128,226,32,1,160,225,5,0,198,229,4,0,86,229,128,0,16,227,
  5,0,0,26,3,0,86,229,24,0,80,227,2,0,0,170,72,0,128,226,32,1,160,225,3,0,70,229,36,0,86,229,
  128,0,16,227,5,0,0,26,35,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,35,0,70,229,
  40,0,86,229,128,0,16,227,5,0,0,26,39,0,86,229,21,0,80,227,2,0,0,170,63,0,128,226,32,1,160,225,
  39,0,70,229,44,0,86,229,128,0,16,227,5,0,0,26,43,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,
  32,1,160,225,43,0,70,229,84,0,214,229,128,0,16,227,8,0,0,26,44,0,214,229,128,0,16,227,5,0,0,26,
  85,0,214,229,23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,85,0,198,229,80,0,214,229,128,0,16,227,
  8,0,0,26,40,0,214,229,128,0,16,227,5,0,0,26,81,0,214,229,23,0,80,227,2,0,0,170,69,0,128,226,
  32,1,160,225,81,0,198,229,76,0,214,229,128,0,16,227,8,0,0,26,36,0,214,229,128,0,16,227,5,0,0,26,
  77,0,214,229,23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,77,0,198,229,48,0,214,229,128,0,16,227,
  8,0,0,26,44,0,214,229,128,0,16,227,5,0,0,26,49,0,214,229,22,0,80,227,2,0,0,170,66,0,128,226,
  32,1,160,225,49,0,198,229,32,0,214,229,128,0,16,227,8,0,0,26,36,0,214,229,128,0,16,227,5,0,0,26,
  33,0,214,229,22,0,80,227,2,0,0,170,66,0,128,226,32,1,160,225,33,0,198,229,88,0,214,229,128,0,16,227,
  8,0,0,26,44,0,214,229,128,0,16,227,5,0,0,26,89,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,
  32,1,160,225,89,0,198,229,72,0,214,229,128,0,16,227,8,0,0,26,36,0,214,229,128,0,16,227,5,0,0,26,
  73,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,73,0,198,229,8,0,214,229,128,0,16,227,
  8,0,0,26,4,0,214,229,128,0,16,227,5,0,0,26,9,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,
  32,1,160,225,9,0,198,229,8,0,86,229,128,0,16,227,8,0,0,26,4,0,86,229,128,0,16,227,5,0,0,26,
  7,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,7,0,70,229,14,240,160,225,220,18,0,224,
  152,207,1,0,233,20,0,224,0,0,160,227,172,10,12,229,168,10,12,229,152,95,28,229,5,0,140,224,2,0,208,229,
  0,96,160,227,6,112,160,225,6,96,140,224,172,106,22,229,6,16,140,224,2,16,209,229,1,0,80,225,248,255,255,58,
  7,160,140,224,172,90,10,229,5,160,140,224,172,106,10,229,5,80,140,224,152,95,21,229,84,0,85,227,237,255,255,42,
  148,95,28,229,5,0,140,224,2,0,208,229,4,96,160,227,6,112,160,225,6,96,140,224,172,106,22,229,6,16,140,224,
  2,16,209,229,1,0,80,225,248,255,255,58,7,160,140,224,172,90,10,229,5,160,140,224,172,106,10,229,5,80,140,224,
  152,95,21,229,84,0,85,227,237,255,255,42,14,240,160,225,36,6,216,229,3,0,128,226,36,6,200,229,72,12,152,229,
  255,0,16,227,32,8,160,1,0,8,132,224,72,12,136,229,14,240,160,225,24,4,216,229,3,0,16,225,2,0,0,10,
  36,6,216,229,3,0,128,226,36,6,200,229,14,240,160,225,74,76,200,229,36,4,160,225,75,12,200,229,36,6,216,229,
  3,0,128,226,36,6,200,229,14,240,160,225,6,128,160,225,9,128,136,224,36,6,216,229,3,0,128,226,36,6,200,229,
  72,12,152,229,255,0,16,227,32,8,160,1,0,8,132,224,72,12,136,229,0,16,88,229,0,0,81,227,243,255,255,10,
  128,0,17,227,32,0,0,26,11,0,0,234,9,128,136,224,74,76,200,229,36,4,160,225,75,12,200,229,36,6,216,229,
  3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,245,255,255,10,128,0,17,227,19,0,0,26,62,16,1,226,
  129,0,151,231,1,0,80,227,15,0,0,186,2,0,0,10,32,0,17,227,236,255,255,10,220,255,255,234,9,128,136,224,
  74,76,200,229,36,4,160,225,75,12,200,229,36,6,216,229,3,0,128,226,36,6,200,229,32,0,17,227,2,0,0,10,
  72,12,152,229,0,8,132,224,72,12,136,229,14,240,160,225,6,128,160,225,9,128,136,224,24,4,216,229,3,0,16,225,
  2,0,0,10,36,6,216,229,3,0,128,226,36,6,200,229,0,0,88,229,0,0,80,227,245,255,255,10,14,240,160,225,
  37,6,216,229,3,0,128,226,37,6,200,229,84,14,152,229,255,0,16,227,32,8,160,1,0,8,132,224,84,14,136,229,
  14,240,160,225,26,4,216,229,3,0,16,225,2,0,0,10,37,6,216,229,3,0,128,226,37,6,200,229,14,240,160,225,
  6,128,160,225,9,128,136,224,37,6,216,229,3,0,128,226,37,6,200,229,84,14,152,229,255,0,16,227,32,8,160,1,
  0,8,132,224,84,14,136,229,0,16,88,229,0,0,81,227,243,255,255,10,128,0,17,227,32,0,0,26,11,0,0,234,
  9,128,136,224,86,78,200,229,36,4,160,225,87,14,200,229,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,
  0,0,81,227,245,255,255,10,128,0,17,227,19,0,0,26,62,16,1,226,129,0,151,231,1,0,80,227,15,0,0,186,
  2,0,0,10,32,0,17,227,236,255,255,26,220,255,255,234,9,128,136,224,86,78,200,229,36,4,160,225,87,14,200,229,
  37,6,216,229,3,0,128,226,37,6,200,229,32,0,17,227,2,0,0,26,84,14,152,229,0,8,132,224,84,14,136,229,
  14,240,160,225,6,128,160,225,9,128,136,224,26,4,216,229,3,0,16,225,2,0,0,10,37,6,216,229,3,0,128,226,
  37,6,200,229,0,0,88,229,0,0,80,227,245,255,255,10,14,240,160,225,40,128,70,226,92,255,255,235,218,2,0,234,
  39,144,224,227,68,126,159,229,111,255,255,235,214,2,0,234,84,128,70,226,85,255,255,235,76,128,70,226,83,255,255,235,
  209,2,0,234,44,128,70,226,80,255,255,235,44,128,134,226,78,255,255,235,40,128,70,226,76,255,255,235,36,128,70,226,
  74,255,255,235,36,128,134,226,72,255,255,235,198,2,0,234,44,128,70,226,69,255,255,235,40,128,70,226,67,255,255,235,
  40,128,134,226,65,255,255,235,36,128,70,226,63,255,255,235,4,128,70,226,61,255,255,235,4,128,134,226,59,255,255,235,
  185,2,0,234,40,128,70,226,56,255,255,235,40,128,134,226,54,255,255,235,4,128,70,226,52,255,255,235,4,128,134,226,
  50,255,255,235,43,144,224,227,164,125,159,229,70,255,255,235,44,144,160,227,156,125,159,229,67,255,255,235,35,144,224,227,
  148,125,159,229,64,255,255,235,36,144,160,227,140,125,159,229,61,255,255,235,164,2,0,234,44,128,70,226,35,255,255,235,
  44,128,134,226,33,255,255,235,36,128,70,226,31,255,255,235,36,128,134,226,29,255,255,235,39,144,224,227,96,125,159,229,
  49,255,255,235,40,144,160,227,88,125,159,229,46,255,255,235,3,144,224,227,80,125,159,229,43,255,255,235,4,144,160,227,
  72,125,159,229,40,255,255,235,143,2,0,234,248,5,214,229,3,0,128,226,248,5,198,229,252,5,214,229,3,0,128,226,
  252,5,198,229,0,6,214,229,3,0,128,226,0,6,198,229,32,6,214,229,3,0,128,226,32,6,198,229,40,6,214,229,
  3,0,128,226,40,6,198,229,72,6,214,229,3,0,128,226,72,6,198,229,76,6,214,229,3,0,128,226,76,6,198,229,
  80,6,214,229,3,0,128,226,80,6,198,229,118,2,0,234,40,128,70,226,254,254,255,235,115,2,0,234,39,144,224,227,
  58,255,255,235,112,2,0,234,84,128,70,226,248,254,255,235,76,128,70,226,246,254,255,235,107,2,0,234,44,128,70,226,
  234,254,255,235,44,128,134,226,232,254,255,235,40,128,70,226,239,254,255,235,36,128,70,226,237,254,255,235,36,128,134,226,
  235,254,255,235,96,2,0,234,44,128,70,226,223,254,255,235,40,128,70,226,230,254,255,235,40,128,134,226,228,254,255,235,
  36,128,70,226,226,254,255,235,4,128,70,226,224,254,255,235,4,128,134,226,222,254,255,235,83,2,0,234,40,128,70,226,
  219,254,255,235,40,128,134,226,217,254,255,235,4,128,70,226,215,254,255,235,4,128,134,226,213,254,255,235,43,144,224,227,
  44,124,159,229,224,254,255,235,44,144,160,227,36,124,159,229,221,254,255,235,35,144,224,227,12,255,255,235,36,144,160,227,
  10,255,255,235,64,2,0,234,44,128,70,226,191,254,255,235,44,128,134,226,189,254,255,235,36,128,70,226,196,254,255,235,
  36,128,134,226,194,254,255,235,39,144,224,227,255,254,255,235,40,144,160,227,253,254,255,235,3,144,224,227,251,254,255,235,
  4,144,160,227,249,254,255,235,47,2,0,234,44,128,70,226,183,254,255,235,44,128,134,226,181,254,255,235,40,128,70,226,
  170,254,255,235,36,128,70,226,177,254,255,235,36,128,134,226,175,254,255,235,36,2,0,234,44,128,70,226,172,254,255,235,
  40,128,70,226,161,254,255,235,40,128,134,226,159,254,255,235,36,128,70,226,166,254,255,235,4,128,70,226,164,254,255,235,
  4,128,134,226,162,254,255,235,23,2,0,234,40,128,70,226,150,254,255,235,40,128,134,226,148,254,255,235,4,128,70,226,
  155,254,255,235,4,128,134,226,153,254,255,235,43,144,224,227,214,254,255,235,44,144,160,227,212,254,255,235,35,144,224,227,
  210,254,255,235,36,144,160,227,208,254,255,235,6,2,0,234,44,128,70,226,142,254,255,235,44,128,134,226,140,254,255,235,
  36,128,70,226,138,254,255,235,36,128,134,226,136,254,255,235,39,144,224,227,0,123,159,229,147,254,255,235,40,144,160,227,
  248,122,159,229,144,254,255,235,3,144,224,227,191,254,255,235,4,144,160,227,189,254,255,235,243,1,0,234,44,128,70,226,
  123,254,255,235,44,128,134,226,121,254,255,235,40,128,70,226,119,254,255,235,36,128,70,226,108,254,255,235,36,128,134,226,
  106,254,255,235,232,1,0,234,44,128,70,226,112,254,255,235,40,128,70,226,110,254,255,235,40,128,134,226,108,254,255,235,
  36,128,70,226,97,254,255,235,4,128,70,226,104,254,255,235,4,128,134,226,102,254,255,235,219,1,0,234,40,128,70,226,
  99,254,255,235,40,128,134,226,97,254,255,235,4,128,70,226,95,254,255,235,4,128,134,226,93,254,255,235,43,144,224,227,
  154,254,255,235,44,144,160,227,152,254,255,235,35,144,224,227,76,122,159,229,100,254,255,235,36,144,160,227,68,122,159,229,
  97,254,255,235,200,1,0,234,44,128,70,226,80,254,255,235,44,128,134,226,78,254,255,235,36,128,70,226,67,254,255,235,
  36,128,134,226,65,254,255,235,39,144,224,227,135,254,255,235,40,144,160,227,133,254,255,235,3,144,224,227,131,254,255,235,
  4,144,160,227,129,254,255,235,183,1,0,234,44,128,70,226,63,254,255,235,44,128,134,226,61,254,255,235,40,128,70,226,
  59,254,255,235,36,128,70,226,57,254,255,235,36,128,134,226,55,254,255,235,172,1,0,234,44,128,70,226,52,254,255,235,
  40,128,70,226,50,254,255,235,40,128,134,226,48,254,255,235,36,128,70,226,46,254,255,235,4,128,70,226,35,254,255,235,
  4,128,134,226,33,254,255,235,159,1,0,234,40,128,70,226,39,254,255,235,40,128,134,226,37,254,255,235,4,128,70,226,
  26,254,255,235,4,128,134,226,24,254,255,235,43,144,224,227,94,254,255,235,44,144,160,227,92,254,255,235,35,144,224,227,
  90,254,255,235,36,144,160,227,88,254,255,235,142,1,0,234,44,128,70,226,22,254,255,235,44,128,134,226,20,254,255,235,
  36,128,70,226,18,254,255,235,36,128,134,226,16,254,255,235,39,144,224,227,77,254,255,235,40,144,160,227,75,254,255,235,
  3,144,224,227,32,121,159,229,23,254,255,235,4,144,160,227,24,121,159,229,20,254,255,235,123,1,0,234,40,128,134,226,
  78,254,255,235,138,1,0,234,40,144,160,227,0,121,159,229,90,254,255,235,134,1,0,234,84,128,134,226,71,254,255,235,
  76,128,134,226,69,254,255,235,129,1,0,234,44,128,134,226,66,254,255,235,44,128,70,226,64,254,255,235,40,128,134,226,
  62,254,255,235,36,128,134,226,60,254,255,235,36,128,70,226,58,254,255,235,118,1,0,234,44,128,134,226,55,254,255,235,
  40,128,134,226,53,254,255,235,40,128,70,226,51,254,255,235,36,128,134,226,49,254,255,235,4,128,134,226,47,254,255,235,
  4,128,70,226,45,254,255,235,105,1,0,234,40,128,134,226,42,254,255,235,40,128,70,226,40,254,255,235,4,128,134,226,
  38,254,255,235,4,128,70,226,36,254,255,235,44,144,160,227,96,120,159,229,49,254,255,235,43,144,224,227,88,120,159,229,
  46,254,255,235,36,144,160,227,80,120,159,229,43,254,255,235,35,144,224,227,72,120,159,229,40,254,255,235,84,1,0,234,
  44,128,134,226,21,254,255,235,44,128,70,226,19,254,255,235,36,128,134,226,17,254,255,235,36,128,70,226,15,254,255,235,
  40,144,160,227,28,120,159,229,28,254,255,235,39,144,224,227,20,120,159,229,25,254,255,235,4,144,160,227,12,120,159,229,
  22,254,255,235,3,144,224,227,4,120,159,229,19,254,255,235,63,1,0,234,81,6,214,229,3,0,128,226,81,6,198,229,
  77,6,214,229,3,0,128,226,77,6,198,229,73,6,214,229,3,0,128,226,73,6,198,229,41,6,214,229,3,0,128,226,
  41,6,198,229,33,6,214,229,3,0,128,226,33,6,198,229,1,6,214,229,3,0,128,226,1,6,198,229,253,5,214,229,
  3,0,128,226,253,5,198,229,249,5,214,229,3,0,128,226,249,5,198,229,38,1,0,234,40,128,134,226,240,253,255,235,
  35,1,0,234,40,144,160,227,37,254,255,235,32,1,0,234,84,128,134,226,234,253,255,235,76,128,134,226,232,253,255,235,
  27,1,0,234,44,128,134,226,220,253,255,235,44,128,70,226,218,253,255,235,40,128,134,226,225,253,255,235,36,128,134,226,
  223,253,255,235,36,128,70,226,221,253,255,235,16,1,0,234,44,128,134,226,209,253,255,235,40,128,134,226,216,253,255,235,
  40,128,70,226,214,253,255,235,36,128,134,226,212,253,255,235,4,128,134,226,210,253,255,235,4,128,70,226,208,253,255,235,
  3,1,0,234,40,128,134,226,205,253,255,235,40,128,70,226,203,253,255,235,4,128,134,226,201,253,255,235,4,128,70,226,
  199,253,255,235,44,144,160,227,232,118,159,229,203,253,255,235,43,144,224,227,224,118,159,229,200,253,255,235,36,144,160,227,
  247,253,255,235,35,144,224,227,245,253,255,235,240,0,0,234,44,128,134,226,177,253,255,235,44,128,70,226,175,253,255,235,
  36,128,134,226,182,253,255,235,36,128,70,226,180,253,255,235,40,144,160,227,234,253,255,235,39,144,224,227,232,253,255,235,
  4,144,160,227,230,253,255,235,3,144,224,227,228,253,255,235,223,0,0,234,44,128,134,226,169,253,255,235,44,128,70,226,
  167,253,255,235,40,128,134,226,156,253,255,235,36,128,134,226,163,253,255,235,36,128,70,226,161,253,255,235,212,0,0,234,
  44,128,134,226,158,253,255,235,40,128,134,226,147,253,255,235,40,128,70,226,145,253,255,235,36,128,134,226,152,253,255,235,
  4,128,134,226,150,253,255,235,4,128,70,226,148,253,255,235,199,0,0,234,40,128,134,226,136,253,255,235,40,128,70,226,
  134,253,255,235,4,128,134,226,141,253,255,235,4,128,70,226,139,253,255,235,44,144,160,227,193,253,255,235,43,144,224,227,
  191,253,255,235,36,144,160,227,189,253,255,235,35,144,224,227,187,253,255,235,182,0,0,234,44,128,134,226,128,253,255,235,
  44,128,70,226,126,253,255,235,36,128,134,226,124,253,255,235,36,128,70,226,122,253,255,235,40,144,160,227,188,117,159,229,
  126,253,255,235,39,144,224,227,180,117,159,229,123,253,255,235,4,144,160,227,170,253,255,235,3,144,224,227,168,253,255,235,
  163,0,0,234,44,128,134,226,109,253,255,235,44,128,70,226,107,253,255,235,40,128,134,226,105,253,255,235,36,128,134,226,
  94,253,255,235,36,128,70,226,92,253,255,235,152,0,0,234,44,128,134,226,98,253,255,235,40,128,134,226,96,253,255,235,
  40,128,70,226,94,253,255,235,36,128,134,226,83,253,255,235,4,128,134,226,90,253,255,235,4,128,70,226,88,253,255,235,
  139,0,0,234,40,128,134,226,85,253,255,235,40,128,70,226,83,253,255,235,4,128,134,226,81,253,255,235,4,128,70,226,
  79,253,255,235,44,144,160,227,133,253,255,235,43,144,224,227,131,253,255,235,36,144,160,227,8,117,159,229,79,253,255,235,
  35,144,224,227,0,117,159,229,76,253,255,235,120,0,0,234,44,128,134,226,66,253,255,235,44,128,70,226,64,253,255,235,
  36,128,134,226,53,253,255,235,36,128,70,226,51,253,255,235,40,144,160,227,114,253,255,235,39,144,224,227,112,253,255,235,
  4,144,160,227,110,253,255,235,3,144,224,227,108,253,255,235,103,0,0,234,44,128,134,226,49,253,255,235,44,128,70,226,
  47,253,255,235,40,128,134,226,45,253,255,235,36,128,134,226,43,253,255,235,36,128,70,226,41,253,255,235,92,0,0,234,
  44,128,134,226,38,253,255,235,40,128,134,226,36,253,255,235,40,128,70,226,34,253,255,235,36,128,134,226,32,253,255,235,
  4,128,134,226,21,253,255,235,4,128,70,226,19,253,255,235,79,0,0,234,40,128,134,226,25,253,255,235,40,128,70,226,
  23,253,255,235,4,128,134,226,12,253,255,235,4,128,70,226,10,253,255,235,44,144,160,227,73,253,255,235,43,144,224,227,
  71,253,255,235,36,144,160,227,69,253,255,235,35,144,224,227,67,253,255,235,62,0,0,234,44,128,134,226,8,253,255,235,
  44,128,70,226,6,253,255,235,36,128,134,226,4,253,255,235,36,128,70,226,2,253,255,235,40,144,160,227,56,253,255,235,
  39,144,224,227,54,253,255,235,4,144,160,227,220,115,159,229,2,253,255,235,3,144,224,227,212,115,159,229,255,252,255,235,
  43,0,0,234,4,224,45,229,200,83,159,229,0,0,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,
  180,83,159,229,180,3,159,229,131,144,160,227,12,2,133,229,4,0,133,228,1,144,89,226,251,255,255,26,172,90,28,229,
  5,96,140,224,37,65,160,225,2,0,214,229,0,68,132,225,25,52,214,229,0,0,86,229,30,0,0,226,13,18,214,229,
  1,0,128,225,128,0,143,224,100,240,144,229,36,6,214,229,2,0,128,226,36,6,198,229,172,90,22,229,0,0,85,227,
  238,255,255,26,168,90,28,229,5,96,140,224,37,65,160,225,2,0,214,229,0,68,132,225,27,52,214,229,0,0,86,229,
  30,0,0,226,15,18,214,229,1,0,128,225,128,0,143,224,92,241,144,229,37,6,214,229,2,0,128,226,37,6,198,229,
  172,90,22,229,0,0,85,227,238,255,255,26,4,240,157,228,52,134,0,0,144,134,0,0,64,134,0,0,144,134,0,0,
  80,134,0,0,144,134,0,0,100,134,0,0,144,134,0,0,144,134,0,0,0,0,0,0,228,134,0,0,196,134,0,0,
  56,135,0,0,24,135,0,0,108,135,0,0,0,0,0,0,208,135,0,0,40,136,0,0,220,135,0,0,40,136,0,0,
  232,135,0,0,40,136,0,0,252,135,0,0,40,136,0,0,40,136,0,0,0,0,0,0,124,136,0,0,92,136,0,0,
  200,136,0,0,168,136,0,0,60,134,0,0,0,0,0,0,52,134,0,0,24,137,0,0,64,134,0,0,24,137,0,0,
  232,135,0,0,24,137,0,0,236,136,0,0,24,137,0,0,24,137,0,0,0,0,0,0,108,137,0,0,76,137,0,0,
  176,137,0,0,144,137,0,0,60,134,0,0,0,0,0,0,208,135,0,0,8,138,0,0,220,135,0,0,8,138,0,0,
  232,135,0,0,8,138,0,0,220,137,0,0,8,138,0,0,8,138,0,0,0,0,0,0,92,138,0,0,60,138,0,0,
  168,138,0,0,136,138,0,0,60,134,0,0,0,0,0,0,208,135,0,0,248,138,0,0,220,135,0,0,248,138,0,0,
  232,135,0,0,248,138,0,0,204,138,0,0,248,138,0,0,248,138,0,0,0,0,0,0,76,139,0,0,44,139,0,0,
  144,139,0,0,112,139,0,0,60,134,0,0,0,0,0,0,188,139,0,0,24,140,0,0,200,139,0,0,24,140,0,0,
  216,139,0,0,24,140,0,0,236,139,0,0,24,140,0,0,24,140,0,0,0,0,0,0,108,140,0,0,76,140,0,0,
  192,140,0,0,160,140,0,0,244,140,0,0,0,0,0,0,88,141,0,0,176,141,0,0,100,141,0,0,176,141,0,0,
  112,141,0,0,176,141,0,0,132,141,0,0,176,141,0,0,176,141,0,0,0,0,0,0,4,142,0,0,228,141,0,0,
  80,142,0,0,48,142,0,0,196,139,0,0,0,0,0,0,188,139,0,0,160,142,0,0,200,139,0,0,160,142,0,0,
  112,141,0,0,160,142,0,0,116,142,0,0,160,142,0,0,160,142,0,0,0,0,0,0,244,142,0,0,212,142,0,0,
  56,143,0,0,24,143,0,0,196,139,0,0,0,0,0,0,88,141,0,0,144,143,0,0,100,141,0,0,144,143,0,0,
  112,141,0,0,144,143,0,0,100,143,0,0,144,143,0,0,144,143,0,0,0,0,0,0,228,143,0,0,196,143,0,0,
  48,144,0,0,16,144,0,0,196,139,0,0,0,0,0,0,88,141,0,0,128,144,0,0,100,141,0,0,128,144,0,0,
  112,141,0,0,128,144,0,0,84,144,0,0,128,144,0,0,128,144,0,0,0,0,0,0,212,144,0,0,180,144,0,0,
  24,145,0,0,248,144,0,0,196,139,0,0,0,0,0,0,92,211,1,0,220,211,1,0,220,212,1,0,220,211,1,0,
  220,212,1,0,92,211,1,0,92,213,1,0,92,212,1,0,92,212,1,0,220,211,1,0,220,212,1,0,92,211,1,0,
  92,213,1,0,220,211,1,0,220,212,1,0,92,212,1,0,92,212,1,0,92,213,1,0,220,212,1,0,220,211,1,0,
  220,212,1,0,220,211,1,0,92,213,1,0,92,211,1,0,92,212,1,0,92,212,1,0,220,212,1,0,220,211,1,0,
  92,213,1,0,92,211,1,0,220,212,1,0,220,211,1,0,92,212,1,0,92,212,1,0,12,27,0,224,48,33,0,224,
  0,120,0,120,72,12,152,229,255,0,16,227,32,8,160,1,0,8,132,224,72,12,136,229,14,240,160,225,6,128,160,225,
  9,128,136,224,72,12,152,229,255,0,16,227,32,8,160,1,0,8,132,224,72,12,136,229,0,16,88,229,0,0,81,227,
  246,255,255,10,128,0,17,227,26,0,0,26,8,0,0,234,9,128,136,224,74,76,200,229,36,4,160,225,75,12,200,229,
  0,16,88,229,0,0,81,227,248,255,255,10,128,0,17,227,16,0,0,26,62,16,1,226,129,0,151,231,1,0,80,227,
  12,0,0,186,2,0,0,10,32,0,17,227,239,255,255,10,226,255,255,234,9,128,136,224,74,76,200,229,36,4,160,225,
  75,12,200,229,32,0,17,227,2,0,0,10,72,12,152,229,0,8,132,224,72,12,136,229,14,240,160,225,84,14,152,229,
  255,0,16,227,32,8,160,1,0,8,132,224,84,14,136,229,14,240,160,225,6,128,160,225,9,128,136,224,84,14,152,229,
  255,0,16,227,32,8,160,1,0,8,132,224,84,14,136,229,0,16,88,229,0,0,81,227,246,255,255,10,128,0,17,227,
  26,0,0,26,8,0,0,234,9,128,136,224,86,78,200,229,36,4,160,225,87,14,200,229,0,16,88,229,0,0,81,227,
  248,255,255,10,128,0,17,227,16,0,0,26,62,16,1,226,129,0,151,231,1,0,80,227,12,0,0,186,2,0,0,10,
  32,0,17,227,239,255,255,26,226,255,255,234,9,128,136,224,86,78,200,229,36,4,160,225,87,14,200,229,32,0,17,227,
  2,0,0,26,84,14,152,229,0,8,132,224,84,14,136,229,14,240,160,225,40,128,70,226,161,255,255,235,233,0,0,234,
  39,144,224,227,100,118,159,229,163,255,255,235,229,0,0,234,84,128,70,226,154,255,255,235,76,128,70,226,152,255,255,235,
  224,0,0,234,44,128,70,226,149,255,255,235,44,128,134,226,147,255,255,235,40,128,70,226,145,255,255,235,36,128,70,226,
  143,255,255,235,36,128,134,226,141,255,255,235,213,0,0,234,44,128,70,226,138,255,255,235,40,128,70,226,136,255,255,235,
  40,128,134,226,134,255,255,235,36,128,70,226,132,255,255,235,4,128,70,226,130,255,255,235,4,128,134,226,128,255,255,235,
  200,0,0,234,40,128,70,226,125,255,255,235,40,128,134,226,123,255,255,235,4,128,70,226,121,255,255,235,4,128,134,226,
  119,255,255,235,43,144,224,227,196,117,159,229,122,255,255,235,44,144,160,227,188,117,159,229,119,255,255,235,35,144,224,227,
  180,117,159,229,116,255,255,235,36,144,160,227,172,117,159,229,113,255,255,235,179,0,0,234,44,128,70,226,104,255,255,235,
  44,128,134,226,102,255,255,235,36,128,70,226,100,255,255,235,36,128,134,226,98,255,255,235,39,144,224,227,128,117,159,229,
  101,255,255,235,40,144,160,227,120,117,159,229,98,255,255,235,3,144,224,227,112,117,159,229,95,255,255,235,4,144,160,227,
  104,117,159,229,92,255,255,235,158,0,0,234,44,128,70,226,83,255,255,235,44,128,134,226,81,255,255,235,153,0,0,234,
  44,128,70,226,78,255,255,235,150,0,0,234,40,128,70,226,75,255,255,235,40,128,134,226,73,255,255,235,145,0,0,234,
  36,128,70,226,70,255,255,235,142,0,0,234,43,144,224,227,28,117,159,229,72,255,255,235,44,144,160,227,20,117,159,229,
  69,255,255,235,135,0,0,234,39,144,224,227,8,117,159,229,65,255,255,235,40,144,160,227,0,117,159,229,62,255,255,235,
  128,0,0,234,127,0,0,234,40,128,134,226,98,255,255,235,138,0,0,234,40,144,160,227,228,116,159,229,100,255,255,235,
  134,0,0,234,84,128,134,226,91,255,255,235,76,128,134,226,89,255,255,235,129,0,0,234,44,128,134,226,86,255,255,235,
  44,128,70,226,84,255,255,235,40,128,134,226,82,255,255,235,36,128,134,226,80,255,255,235,36,128,70,226,78,255,255,235,
  118,0,0,234,44,128,134,226,75,255,255,235,40,128,134,226,73,255,255,235,40,128,70,226,71,255,255,235,36,128,134,226,
  69,255,255,235,4,128,134,226,67,255,255,235,4,128,70,226,65,255,255,235,105,0,0,234,40,128,134,226,62,255,255,235,
  40,128,70,226,60,255,255,235,4,128,134,226,58,255,255,235,4,128,70,226,56,255,255,235,44,144,160,227,68,116,159,229,
  59,255,255,235,43,144,224,227,60,116,159,229,56,255,255,235,36,144,160,227,52,116,159,229,53,255,255,235,35,144,224,227,
  44,116,159,229,50,255,255,235,84,0,0,234,44,128,134,226,41,255,255,235,44,128,70,226,39,255,255,235,36,128,134,226,
  37,255,255,235,36,128,70,226,35,255,255,235,40,144,160,227,0,116,159,229,38,255,255,235,39,144,224,227,248,115,159,229,
  35,255,255,235,4,144,160,227,240,115,159,229,32,255,255,235,3,144,224,227,232,115,159,229,29,255,255,235,63,0,0,234,
  44,128,134,226,20,255,255,235,44,128,70,226,18,255,255,235,58,0,0,234,44,128,134,226,15,255,255,235,55,0,0,234,
  40,128,134,226,12,255,255,235,40,128,70,226,10,255,255,235,50,0,0,234,36,128,134,226,7,255,255,235,47,0,0,234,
  44,144,160,227,156,115,159,229,9,255,255,235,43,144,224,227,148,115,159,229,6,255,255,235,40,0,0,234,40,144,160,227,
  136,115,159,229,2,255,255,235,39,144,224,227,128,115,159,229,255,254,255,235,33,0,0,234,32,0,0,234,4,224,45,229,
  112,83,159,229,112,3,159,229,131,144,160,227,12,2,133,229,4,0,133,228,1,144,89,226,251,255,255,26,172,90,28,229,
  5,96,140,224,37,65,160,225,2,0,214,229,0,68,132,225,0,0,86,229,30,0,0,226,13,18,214,229,1,0,128,225,
  128,0,143,224,72,240,144,229,172,90,22,229,0,0,85,227,242,255,255,26,168,90,28,229,5,96,140,224,37,65,160,225,
  2,0,214,229,0,68,132,225,0,0,86,229,30,0,0,226,15,18,214,229,1,0,128,225,128,0,143,224,80,241,144,229,
  172,90,22,229,0,0,85,227,242,255,255,26,4,240,157,228,148,150,0,0,240,150,0,0,160,150,0,0,240,150,0,0,
  176,150,0,0,240,150,0,0,196,150,0,0,240,150,0,0,240,150,0,0,0,0,0,0,68,151,0,0,36,151,0,0,
  152,151,0,0,120,151,0,0,68,152,0,0,0,0,0,0,156,150,0,0,224,151,0,0,156,150,0,0,224,151,0,0,
  156,150,0,0,224,151,0,0,204,151,0,0,224,151,0,0,224,151,0,0,0,0,0,0,12,152,0,0,12,152,0,0,
  156,150,0,0,204,151,0,0,156,150,0,0,0,0,0,0,148,150,0,0,236,151,0,0,160,150,0,0,236,151,0,0,
  156,150,0,0,236,151,0,0,148,150,0,0,236,151,0,0,236,151,0,0,0,0,0,0,156,150,0,0,236,151,0,0,
  40,152,0,0,40,152,0,0,156,150,0,0,0,0,0,0,156,150,0,0,0,152,0,0,156,150,0,0,0,152,0,0,
  156,150,0,0,0,152,0,0,220,150,0,0,0,152,0,0,0,152,0,0,0,0,0,0,92,151,0,0,92,151,0,0,
  156,150,0,0,220,150,0,0,156,150,0,0,0,0,0,0,156,150,0,0,16,151,0,0,156,150,0,0,16,151,0,0,
  156,150,0,0,16,151,0,0,156,150,0,0,16,151,0,0,16,151,0,0,0,0,0,0,156,150,0,0,16,151,0,0,
  176,151,0,0,176,151,0,0,156,150,0,0,0,0,0,0,72,152,0,0,164,152,0,0,84,152,0,0,164,152,0,0,
  100,152,0,0,164,152,0,0,120,152,0,0,164,152,0,0,164,152,0,0,0,0,0,0,248,152,0,0,216,152,0,0,
  76,153,0,0,44,153,0,0,248,153,0,0,0,0,0,0,80,152,0,0,148,153,0,0,80,152,0,0,148,153,0,0,
  80,152,0,0,148,153,0,0,128,153,0,0,148,153,0,0,148,153,0,0,0,0,0,0,192,153,0,0,192,153,0,0,
  80,152,0,0,128,153,0,0,80,152,0,0,0,0,0,0,72,152,0,0,160,153,0,0,84,152,0,0,160,153,0,0,
  80,152,0,0,160,153,0,0,72,152,0,0,160,153,0,0,160,153,0,0,0,0,0,0,80,152,0,0,160,153,0,0,
  220,153,0,0,220,153,0,0,80,152,0,0,0,0,0,0,80,152,0,0,180,153,0,0,80,152,0,0,180,153,0,0,
  80,152,0,0,180,153,0,0,144,152,0,0,180,153,0,0,180,153,0,0,0,0,0,0,16,153,0,0,16,153,0,0,
  80,152,0,0,144,152,0,0,80,152,0,0,0,0,0,0,80,152,0,0,196,152,0,0,80,152,0,0,196,152,0,0,
  80,152,0,0,196,152,0,0,80,152,0,0,196,152,0,0,196,152,0,0,0,0,0,0,80,152,0,0,196,152,0,0,
  100,153,0,0,100,153,0,0,80,152,0,0,0,0,0,0,92,211,1,0,220,211,1,0,220,212,1,0,220,211,1,0,
  220,212,1,0,92,211,1,0,92,213,1,0,92,212,1,0,92,212,1,0,220,211,1,0,220,212,1,0,92,211,1,0,
  92,213,1,0,92,213,1,0,220,212,1,0,220,211,1,0,220,212,1,0,220,211,1,0,92,213,1,0,92,211,1,0,
  92,212,1,0,92,212,1,0,220,212,1,0,220,211,1,0,92,213,1,0,92,211,1,0,48,33,0,224,0,120,0,120,
  222,67,45,233,7,160,140,224,73,28,218,229,75,44,218,229,85,62,218,229,87,78,218,229,36,102,218,229,37,118,218,229,
  84,142,218,229,86,158,218,229,26,0,0,235,156,8,76,229,222,67,189,232,14,240,160,225,222,67,45,233,7,160,140,224,
  73,28,218,229,75,44,218,229,85,62,218,229,87,78,218,229,49,8,218,229,0,0,81,225,2,0,0,58,1,32,160,225,
  0,16,160,225,1,0,0,234,0,0,82,225,0,32,160,33,36,102,218,229,37,118,218,229,48,8,218,229,0,96,134,224,
  84,142,218,229,86,158,218,229,2,0,0,235,156,8,76,229,222,67,189,232,14,240,160,225,3,0,86,227,1,0,0,42,
  120,0,160,227,14,240,160,225,3,0,87,227,1,0,0,138,0,0,160,227,14,240,160,225,8,1,85,225,2,0,0,26,
  4,48,160,225,120,64,160,227,2,0,0,234,9,1,85,225,0,0,0,26,120,64,160,227,7,0,86,225,6,0,0,58,
  4,0,82,224,0,0,160,51,0,0,83,224,0,0,160,51,0,0,81,224,0,0,160,51,14,240,160,225,2,0,83,224,
  0,0,160,51,0,0,81,224,0,0,160,51,14,240,160,225,222,67,45,233,7,160,140,224,73,28,218,229,75,44,218,229,
  85,62,218,229,87,78,218,229,36,102,218,229,37,118,218,229,72,140,218,229,74,156,218,229,30,0,0,235,155,8,76,229,
  222,67,189,232,14,240,160,225,7,160,140,224,84,14,218,229,0,1,160,225,81,15,80,227,1,0,0,42,81,15,87,227,
  234,255,255,58,0,0,220,231,30,0,0,226,128,0,139,224,180,2,16,229,0,0,80,227,228,255,255,10,0,48,131,224,
  222,67,45,233,73,28,218,229,75,44,218,229,85,62,218,229,87,78,218,229,0,48,131,224,36,102,218,229,37,118,218,229,
  72,140,218,229,74,156,218,229,2,0,0,235,155,8,76,229,222,67,189,232,14,240,160,225,3,0,87,227,1,0,0,42,
  120,0,160,227,14,240,160,225,3,0,86,227,1,0,0,138,0,0,160,227,14,240,160,225,8,1,85,225,2,0,0,26,
  2,16,160,225,120,32,160,227,2,0,0,234,9,1,85,225,0,0,0,26,120,32,160,227,6,0,87,225,6,0,0,58,
  2,0,84,224,0,0,160,51,0,0,81,224,0,0,160,51,0,0,83,224,0,0,160,51,14,240,160,225,4,0,81,224,
  0,0,160,51,0,0,83,224,0,0,160,51,14,240,160,225,222,67,45,233,7,160,140,224,73,28,218,229,75,44,218,229,
  85,62,218,229,87,78,218,229,36,102,218,229,37,118,218,229,2,0,0,235,154,8,76,229,222,67,189,232,14,240,160,225,
  3,0,86,227,3,0,0,42,7,0,86,225,1,0,0,138,120,0,160,227,14,240,160,225,3,0,87,227,1,0,0,42,
  0,0,160,227,14,240,160,225,7,0,86,225,6,0,0,154,4,0,82,224,0,0,160,51,0,0,83,224,0,0,160,51,
  0,0,81,224,0,0,160,51,14,240,160,225,2,0,83,224,0,0,160,51,0,0,81,224,0,0,160,51,14,240,160,225,
  222,67,45,233,7,160,140,224,73,28,218,229,75,44,218,229,85,62,218,229,87,78,218,229,36,102,218,229,37,118,218,229,
  2,0,0,235,153,8,76,229,222,67,189,232,14,240,160,225,3,0,87,227,3,0,0,42,6,0,87,225,1,0,0,138,
  120,0,160,227,14,240,160,225,3,0,86,227,1,0,0,42,0,0,160,227,14,240,160,225,6,0,87,225,6,0,0,154,
  2,0,84,224,0,0,160,51,0,0,81,224,0,0,160,51,0,0,83,224,0,0,160,51,14,240,160,225,4,0,81,224,
  0,0,160,51,0,0,83,224,0,0,160,51,14,240,160,225,4,224,45,229,84,112,160,227,9,144,160,227,9,128,160,227,
  178,255,255,235,154,8,92,229,7,160,140,224,38,6,202,229,210,255,255,235,153,8,92,229,7,160,140,224,39,6,202,229,
  4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,4,240,157,228,4,224,45,229,
  204,82,159,229,30,11,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,172,90,28,229,5,160,140,224,
  13,2,218,229,0,0,80,227,6,0,0,26,2,64,218,229,4,68,160,225,3,64,132,226,0,0,90,229,30,0,0,226,
  128,0,143,224,148,242,144,229,5,80,140,224,172,90,21,229,0,0,85,227,240,255,255,26,190,15,92,229,0,0,80,227,
  18,0,0,10,84,112,160,227,9,144,160,227,5,74,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,
  4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,1,0,80,225,137,6,0,139,4,112,135,226,1,128,88,226,
  244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,191,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,
  9,144,160,227,70,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,
  39,6,208,229,36,20,160,225,1,0,80,225,109,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,
  1,144,89,226,240,255,255,26,192,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,13,75,160,227,
  3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,
  1,0,80,225,79,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,
  193,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,50,76,160,227,3,64,132,226,9,128,160,227,
  7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,1,0,80,225,50,6,0,139,
  4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,194,15,92,229,0,0,80,227,
  18,0,0,10,164,112,160,227,7,144,160,227,2,74,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,
  4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,1,0,80,225,24,6,0,139,4,112,135,226,1,128,88,226,
  244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,195,15,92,229,0,0,80,227,18,0,0,10,124,112,160,227,
  8,144,160,227,30,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,
  39,6,208,229,36,20,160,225,1,0,80,225,255,5,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,
  1,144,89,226,240,255,255,26,196,15,92,229,0,0,80,227,22,0,0,10,124,112,160,227,8,144,160,227,2,75,160,227,
  3,64,132,226,9,128,160,227,72,80,159,229,1,0,213,228,0,0,80,227,7,0,0,26,7,0,220,231,0,0,80,227,
  4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,1,0,80,225,226,5,0,139,4,112,135,226,1,128,88,226,
  241,255,255,26,4,112,135,226,1,144,89,226,236,255,255,26,4,240,157,228,24,29,0,224,105,9,0,224,60,164,0,0,
  80,166,0,0,120,164,0,0,80,166,0,0,192,164,0,0,80,166,0,0,52,165,0,0,80,166,0,0,80,166,0,0,
  0,0,0,0,164,167,0,0,104,169,0,0,148,172,0,0,88,174,0,0,132,177,0,0,132,177,0,0,40,112,69,226,
  7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,139,254,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,140,3,0,235,59,255,255,234,5,112,160,225,40,112,71,226,
  7,0,220,231,0,0,80,227,251,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,121,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,125,3,0,235,41,255,255,234,
  84,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,
  106,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,113,3,0,235,76,112,69,226,7,0,220,231,
  192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,92,254,255,235,36,4,160,225,
  155,24,92,229,1,0,80,225,0,0,0,42,99,3,0,235,12,255,255,234,44,112,69,226,7,0,220,231,192,0,16,227,
  9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,77,254,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,88,3,0,235,40,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,63,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  74,3,0,235,36,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,49,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,60,3,0,235,36,112,133,226,
  7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,35,254,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,46,3,0,235,44,112,133,226,7,0,220,231,192,0,16,227,
  9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,21,254,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,32,3,0,235,197,254,255,234,44,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,
  7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,6,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,
  0,0,0,42,24,3,0,235,40,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,
  3,0,80,227,4,0,0,58,248,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,16,3,0,235,
  36,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,
  234,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,7,3,0,235,4,112,69,226,7,0,220,231,
  192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,220,253,255,235,36,4,160,225,
  155,24,92,229,1,0,80,225,0,0,0,42,255,2,0,235,4,112,133,226,7,0,220,231,192,0,16,227,9,0,0,26,
  7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,206,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,
  0,0,0,42,246,2,0,235,40,112,133,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,
  3,0,80,227,4,0,0,58,192,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,237,2,0,235,
  112,254,255,234,44,112,69,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,179,253,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,232,2,0,235,44,112,71,226,7,0,220,231,0,0,80,227,
  241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,163,253,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,213,2,0,235,36,112,69,226,10,0,0,234,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,151,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  213,2,0,235,36,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,135,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  194,2,0,235,36,112,133,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,123,253,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,194,2,0,235,36,112,135,226,7,0,220,231,0,0,80,227,
  241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,107,253,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,175,2,0,235,44,112,133,226,10,0,0,234,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,95,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  175,2,0,235,44,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,79,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  156,2,0,235,255,253,255,234,5,160,140,224,4,8,154,229,1,0,45,233,8,8,154,229,1,0,45,233,12,8,154,229,
  1,0,45,233,44,8,154,229,1,0,45,233,52,8,154,229,1,0,45,233,84,8,154,229,1,0,45,233,88,8,154,229,
  1,0,45,233,92,8,154,229,1,0,45,233,44,112,69,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,49,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,138,2,0,235,44,112,71,226,
  7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,33,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,119,2,0,235,36,112,69,226,
  10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,21,253,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,124,2,0,235,36,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,
  9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,5,253,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,105,2,0,235,36,112,133,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,249,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,110,2,0,235,36,112,135,226,
  7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,233,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,91,2,0,235,44,112,133,226,
  10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,221,252,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,96,2,0,235,44,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,
  9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,205,252,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,77,2,0,235,40,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,191,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  77,2,0,235,4,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,177,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,63,2,0,235,4,112,133,226,
  7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,163,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,49,2,0,235,40,112,133,226,7,0,220,231,192,0,16,227,
  9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,149,252,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,35,2,0,235,5,160,140,224,1,0,189,232,92,8,138,229,1,0,189,232,88,8,138,229,
  1,0,189,232,84,8,138,229,1,0,189,232,52,8,138,229,1,0,189,232,44,8,138,229,1,0,189,232,12,8,138,229,
  1,0,189,232,8,8,138,229,1,0,189,232,4,8,138,229,52,253,255,234,40,112,69,226,10,0,0,234,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,119,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  19,2,0,235,40,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,103,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  0,2,0,235,4,112,69,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,91,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,0,2,0,235,4,112,71,226,7,0,220,231,0,0,80,227,
  241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,75,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,237,1,0,235,4,112,133,226,10,0,0,234,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,63,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  237,1,0,235,4,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,47,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  218,1,0,235,40,112,133,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,35,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,218,1,0,235,40,112,135,226,7,0,220,231,0,0,80,227,
  241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,19,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,199,1,0,235,195,252,255,234,5,160,140,224,4,8,154,229,
  1,0,45,233,8,8,154,229,1,0,45,233,12,8,154,229,1,0,45,233,44,8,154,229,1,0,45,233,52,8,154,229,
  1,0,45,233,84,8,154,229,1,0,45,233,88,8,154,229,1,0,45,233,92,8,154,229,1,0,45,233,40,112,69,226,
  10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,245,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,181,1,0,235,40,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,
  9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,229,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,162,1,0,235,4,112,69,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,217,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,167,1,0,235,4,112,71,226,
  7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,201,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,148,1,0,235,4,112,133,226,
  10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,189,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,153,1,0,235,4,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,
  9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,173,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,134,1,0,235,40,112,133,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,161,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,139,1,0,235,40,112,135,226,
  7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,145,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,120,1,0,235,44,112,69,226,
  7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,131,251,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,120,1,0,235,36,112,69,226,7,0,220,231,192,0,16,227,
  9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,117,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,126,1,0,235,36,112,133,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,103,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  133,1,0,235,44,112,133,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,89,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,140,1,0,235,5,160,140,224,
  1,0,189,232,92,8,138,229,1,0,189,232,88,8,138,229,1,0,189,232,84,8,138,229,1,0,189,232,52,8,138,229,
  1,0,189,232,44,8,138,229,1,0,189,232,12,8,138,229,1,0,189,232,8,8,138,229,1,0,189,232,4,8,138,229,
  248,251,255,234,44,112,69,226,7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,
  32,8,145,225,134,1,0,11,40,112,69,226,7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,
  22,20,90,229,32,8,145,225,133,1,0,11,36,112,69,226,7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,
  36,6,26,229,22,20,90,229,32,8,145,225,130,1,0,11,4,112,69,226,7,0,220,231,192,0,16,227,4,0,0,26,
  7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,129,1,0,11,4,112,133,226,7,0,220,231,192,0,16,227,
  4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,126,1,0,11,36,112,133,226,7,0,220,231,
  192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,123,1,0,11,40,112,133,226,
  7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,122,1,0,11,
  44,112,133,226,7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,
  119,1,0,11,175,251,255,234,7,160,140,224,8,72,138,229,14,240,160,225,4,224,45,229,143,1,0,235,4,240,157,228,
  7,160,140,224,220,71,138,229,228,71,138,229,14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,
  84,72,138,229,92,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,44,72,138,229,
  14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,88,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,
  8,72,138,229,12,72,138,229,52,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,44,72,138,229,88,72,138,229,
  14,240,160,225,7,160,140,224,12,72,138,229,52,72,138,229,88,72,138,229,14,240,160,225,7,160,140,224,44,72,138,229,
  52,72,138,229,88,72,138,229,14,240,160,225,4,224,45,229,75,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  48,72,138,229,114,1,0,235,179,1,0,235,4,240,157,228,4,224,45,229,110,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,48,72,138,229,61,1,0,235,214,1,0,235,4,240,157,228,4,224,45,229,167,1,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,48,72,138,229,52,1,0,235,205,1,0,235,4,240,157,228,4,224,45,229,202,1,0,235,
  4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,87,1,0,235,152,1,0,235,4,240,157,228,4,224,45,229,
  39,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,8,72,138,229,44,72,138,229,
  52,72,138,229,88,72,138,229,73,1,0,235,138,1,0,235,4,240,157,228,4,224,45,229,69,1,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,8,72,138,229,44,72,138,229,52,72,138,229,88,72,138,229,
  15,1,0,235,168,1,0,235,4,240,157,228,4,224,45,229,121,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  48,72,138,229,7,160,140,224,8,72,138,229,44,72,138,229,52,72,138,229,88,72,138,229,1,1,0,235,154,1,0,235,
  4,240,157,228,4,224,45,229,151,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,
  8,72,138,229,44,72,138,229,52,72,138,229,88,72,138,229,31,1,0,235,96,1,0,235,4,240,157,228,4,224,45,229,
  7,160,140,224,8,72,138,229,44,72,138,229,52,72,138,229,88,72,138,229,234,0,0,235,21,1,0,235,86,1,0,235,
  129,1,0,235,4,240,157,228,4,224,45,229,250,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,
  33,1,0,235,54,1,0,235,4,240,157,228,4,224,45,229,29,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  48,72,138,229,236,0,0,235,89,1,0,235,4,240,157,228,4,224,45,229,42,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,48,72,138,229,227,0,0,235,80,1,0,235,4,240,157,228,4,224,45,229,77,1,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,48,72,138,229,6,1,0,235,27,1,0,235,4,240,157,228,4,224,45,229,214,0,0,235,
  4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,4,72,138,229,12,72,138,229,84,72,138,229,
  92,72,138,229,248,0,0,235,13,1,0,235,4,240,157,228,4,224,45,229,244,0,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,48,72,138,229,7,160,140,224,4,72,138,229,12,72,138,229,84,72,138,229,92,72,138,229,190,0,0,235,
  43,1,0,235,4,240,157,228,4,224,45,229,252,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,
  7,160,140,224,4,72,138,229,12,72,138,229,84,72,138,229,92,72,138,229,176,0,0,235,29,1,0,235,4,240,157,228,
  4,224,45,229,26,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,4,72,138,229,
  12,72,138,229,84,72,138,229,92,72,138,229,206,0,0,235,227,0,0,235,4,240,157,228,7,160,140,224,4,72,138,229,
  92,72,138,229,5,0,140,224,40,0,80,229,0,0,80,227,0,0,0,10,12,72,138,229,5,0,140,224,4,0,80,229,
  0,0,80,227,1,0,0,10,7,160,140,224,84,72,138,229,4,224,45,229,144,0,0,235,187,0,0,235,208,0,0,235,
  251,0,0,235,4,240,157,228,7,160,140,224,12,72,138,229,84,72,138,229,5,0,140,224,40,0,80,229,0,0,80,227,
  1,0,0,10,7,160,140,224,4,72,138,229,5,0,140,224,4,0,208,229,0,0,80,227,1,0,0,10,7,160,140,224,
  92,72,138,229,4,224,45,229,123,0,0,235,166,0,0,235,187,0,0,235,230,0,0,235,4,240,157,228,7,160,140,224,
  12,72,138,229,84,72,138,229,5,0,140,224,40,0,208,229,0,0,80,227,1,0,0,10,7,160,140,224,92,72,138,229,
  5,0,140,224,4,0,80,229,0,0,80,227,1,0,0,10,7,160,140,224,4,72,138,229,4,224,45,229,102,0,0,235,
  145,0,0,235,166,0,0,235,209,0,0,235,4,240,157,228,7,160,140,224,4,72,138,229,92,72,138,229,5,0,140,224,
  40,0,208,229,0,0,80,227,1,0,0,10,7,160,140,224,84,72,138,229,5,0,140,224,4,0,208,229,0,0,80,227,
  1,0,0,10,7,160,140,224,12,72,138,229,4,224,45,229,81,0,0,235,124,0,0,235,145,0,0,235,188,0,0,235,
  4,240,157,228,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,44,72,138,229,84,72,138,229,92,72,138,229,
  14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,88,72,138,229,14,240,160,225,7,160,140,224,
  4,72,138,229,8,72,138,229,12,72,138,229,44,72,138,229,84,72,138,229,92,72,138,229,14,240,160,225,7,160,140,224,
  4,72,138,229,44,72,138,229,52,72,138,229,84,72,138,229,14,240,160,225,7,160,140,224,12,72,138,229,44,72,138,229,
  52,72,138,229,92,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,12,72,138,229,44,72,138,229,84,72,138,229,
  88,72,138,229,92,72,138,229,14,240,160,225,7,160,140,224,8,72,138,229,84,72,138,229,88,72,138,229,92,72,138,229,
  14,240,160,225,7,160,140,224,4,72,138,229,12,72,138,229,52,72,138,229,84,72,138,229,88,72,138,229,92,72,138,229,
  14,240,160,225,7,96,160,225,44,96,70,226,6,160,140,224,48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,
  12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,
  180,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,4,72,138,229,14,240,160,225,7,96,160,225,
  40,96,70,226,6,160,140,224,48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,
  0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,52,5,16,229,1,0,80,227,
  2,0,0,186,237,255,255,26,6,160,140,224,8,72,138,229,14,240,160,225,7,96,160,225,36,96,70,226,6,160,140,224,
  48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,
  128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,180,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,
  6,160,140,224,12,72,138,229,14,240,160,225,7,96,160,225,4,96,70,226,6,160,140,224,48,72,138,229,36,4,160,225,
  39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,
  62,0,0,226,128,0,139,224,52,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,44,72,138,229,
  14,240,160,225,7,96,160,225,4,96,134,226,6,160,140,224,48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,
  12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,
  52,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,52,72,138,229,14,240,160,225,7,96,160,225,
  36,96,134,226,6,160,140,224,48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,
  0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,180,3,16,229,1,0,80,227,
  2,0,0,186,237,255,255,26,6,160,140,224,84,72,138,229,14,240,160,225,7,96,160,225,40,96,134,226,6,160,140,224,
  48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,
  128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,52,3,16,229,1,0,80,227,2,0,0,186,237,255,255,26,
  6,160,140,224,88,72,138,229,14,240,160,225,7,96,160,225,44,96,134,226,6,160,140,224,48,72,138,229,36,4,160,225,
  39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,
  62,0,0,226,128,0,139,224,180,3,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,92,72,138,229,
  14,240,160,225,7,160,140,224,8,72,138,229,14,240,160,225,4,224,45,229,96,255,255,235,4,240,157,228,7,160,140,224,
  220,71,138,229,228,71,138,229,14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,84,72,138,229,
  92,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,44,72,138,229,52,72,138,229,
  88,72,138,229,14,240,160,225,4,224,45,229,52,255,255,235,95,255,255,235,160,255,255,235,203,255,255,235,4,240,157,228,
  4,224,45,229,112,255,255,235,133,255,255,235,176,255,255,235,65,255,255,235,4,240,157,228,4,224,45,229,204,82,159,229,
  30,11,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,168,90,28,229,5,160,140,224,15,2,218,229,
  0,0,80,227,6,0,0,26,2,64,218,229,4,68,160,225,3,64,132,226,0,0,90,229,30,0,0,226,128,0,143,224,
  148,242,144,229,5,80,140,224,172,90,21,229,0,0,85,227,240,255,255,26,182,15,92,229,0,0,80,227,18,0,0,10,
  84,112,160,227,9,144,160,227,5,74,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,
  7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,137,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,
  4,112,135,226,1,144,89,226,240,255,255,26,183,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,
  70,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,38,6,208,229,
  36,20,160,225,1,0,80,225,109,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,
  240,255,255,26,184,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,13,75,160,227,3,64,132,226,
  9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,
  79,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,185,15,92,229,
  0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,50,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,
  0,0,80,227,4,0,0,26,7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,50,6,0,139,4,112,135,226,
  1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,186,15,92,229,0,0,80,227,18,0,0,10,
  84,112,160,227,7,144,160,227,2,74,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,
  7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,24,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,
  4,112,135,226,1,144,89,226,240,255,255,26,187,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,8,144,160,227,
  30,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,38,6,208,229,
  36,20,160,225,1,0,80,225,255,5,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,
  240,255,255,26,188,15,92,229,0,0,80,227,22,0,0,10,84,112,160,227,8,144,160,227,2,75,160,227,3,64,132,226,
  9,128,160,227,72,80,159,229,1,0,213,228,0,0,80,227,7,0,0,26,7,0,220,231,0,0,80,227,4,0,0,26,
  7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,226,5,0,139,4,112,135,226,1,128,88,226,241,255,255,26,
  4,112,135,226,1,144,89,226,236,255,255,26,4,240,157,228,36,31,0,224,117,9,0,224,24,191,0,0,44,193,0,0,
  84,191,0,0,44,193,0,0,156,191,0,0,44,193,0,0,16,192,0,0,44,193,0,0,44,193,0,0,0,0,0,0,
  128,194,0,0,68,196,0,0,112,199,0,0,52,201,0,0,96,204,0,0,96,204,0,0,40,112,133,226,7,0,220,231,
  160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,144,247,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,140,3,0,235,59,255,255,234,5,112,160,225,40,112,135,226,7,0,220,231,
  0,0,80,227,251,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  126,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,125,3,0,235,41,255,255,234,84,112,133,226,
  7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,111,247,255,235,
  36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,113,3,0,235,76,112,133,226,7,0,220,231,160,0,16,227,
  9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,97,247,255,235,36,4,160,225,156,24,92,229,
  1,0,80,225,0,0,0,42,99,3,0,235,12,255,255,234,44,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,82,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,88,3,0,235,40,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,68,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,74,3,0,235,
  36,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  54,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,60,3,0,235,36,112,69,226,7,0,220,231,
  160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,40,247,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,46,3,0,235,44,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,26,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,32,3,0,235,197,254,255,234,44,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,
  36,6,208,229,3,0,80,227,4,0,0,58,11,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,
  24,3,0,235,40,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,
  4,0,0,58,253,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,16,3,0,235,36,112,133,226,
  7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,239,246,255,235,
  36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,7,3,0,235,4,112,133,226,7,0,220,231,160,0,16,227,
  9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,225,246,255,235,36,4,160,225,156,24,92,229,
  1,0,80,225,0,0,0,42,255,2,0,235,4,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,
  36,6,208,229,3,0,80,227,4,0,0,58,211,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,
  246,2,0,235,40,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,
  4,0,0,58,197,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,237,2,0,235,112,254,255,234,
  44,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,184,246,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,232,2,0,235,44,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,
  64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,168,246,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,213,2,0,235,36,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,156,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,213,2,0,235,
  36,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,140,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,194,2,0,235,
  36,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,128,246,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,194,2,0,235,36,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,
  64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,112,246,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,175,2,0,235,44,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,100,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,175,2,0,235,
  44,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,84,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,156,2,0,235,
  255,253,255,234,5,160,140,224,104,10,154,229,1,0,45,233,100,10,154,229,1,0,45,233,96,10,154,229,1,0,45,233,
  64,10,154,229,1,0,45,233,56,10,154,229,1,0,45,233,24,10,154,229,1,0,45,233,20,10,154,229,1,0,45,233,
  16,10,154,229,1,0,45,233,44,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  54,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,138,2,0,235,44,112,135,226,7,0,220,231,
  0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  38,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,119,2,0,235,36,112,133,226,10,0,0,234,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,26,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,124,2,0,235,36,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,10,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,105,2,0,235,36,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  254,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,110,2,0,235,36,112,71,226,7,0,220,231,
  0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  238,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,91,2,0,235,44,112,69,226,10,0,0,234,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,226,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,96,2,0,235,44,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,210,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,77,2,0,235,40,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,196,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,77,2,0,235,
  4,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  182,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,63,2,0,235,4,112,69,226,7,0,220,231,
  160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,168,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,49,2,0,235,40,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,154,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,35,2,0,235,5,160,140,224,1,0,189,232,16,10,138,229,1,0,189,232,20,10,138,229,1,0,189,232,
  24,10,138,229,1,0,189,232,56,10,138,229,1,0,189,232,64,10,138,229,1,0,189,232,96,10,138,229,1,0,189,232,
  100,10,138,229,1,0,189,232,104,10,138,229,52,253,255,234,40,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,124,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,19,2,0,235,
  40,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,108,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,0,2,0,235,
  4,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,96,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,0,2,0,235,4,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,
  64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,80,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,237,1,0,235,4,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,68,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,237,1,0,235,
  4,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,52,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,218,1,0,235,
  40,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,40,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,218,1,0,235,40,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,
  64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,24,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,199,1,0,235,195,252,255,234,5,160,140,224,104,10,154,229,1,0,45,233,
  100,10,154,229,1,0,45,233,96,10,154,229,1,0,45,233,64,10,154,229,1,0,45,233,56,10,154,229,1,0,45,233,
  24,10,154,229,1,0,45,233,20,10,154,229,1,0,45,233,16,10,154,229,1,0,45,233,40,112,133,226,10,0,0,234,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,250,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,181,1,0,235,40,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,234,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,162,1,0,235,4,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  222,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,167,1,0,235,4,112,135,226,7,0,220,231,
  0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  206,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,148,1,0,235,4,112,69,226,10,0,0,234,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,194,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,153,1,0,235,4,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,178,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,134,1,0,235,40,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  166,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,139,1,0,235,40,112,71,226,7,0,220,231,
  0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  150,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,120,1,0,235,44,112,133,226,7,0,220,231,
  160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,136,244,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,120,1,0,235,36,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,122,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,126,1,0,235,36,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,108,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,133,1,0,235,
  44,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  94,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,140,1,0,235,5,160,140,224,1,0,189,232,
  16,10,138,229,1,0,189,232,20,10,138,229,1,0,189,232,24,10,138,229,1,0,189,232,56,10,138,229,1,0,189,232,
  64,10,138,229,1,0,189,232,96,10,138,229,1,0,189,232,100,10,138,229,1,0,189,232,104,10,138,229,248,251,255,234,
  44,112,133,226,7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,
  134,1,0,11,40,112,133,226,7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,
  32,8,145,225,133,1,0,11,36,112,133,226,7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,
  24,20,90,229,32,8,145,225,130,1,0,11,4,112,133,226,7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,
  34,6,26,229,24,20,90,229,32,8,145,225,129,1,0,11,4,112,69,226,7,0,220,231,160,0,16,227,4,0,0,26,
  7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,126,1,0,11,36,112,69,226,7,0,220,231,160,0,16,227,
  4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,123,1,0,11,40,112,69,226,7,0,220,231,
  160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,122,1,0,11,44,112,69,226,
  7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,119,1,0,11,
  175,251,255,234,7,160,140,224,100,74,138,229,14,240,160,225,4,224,45,229,143,1,0,235,4,240,157,228,7,160,140,224,
  144,74,138,229,136,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,24,74,138,229,
  16,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,64,74,138,229,14,240,160,225,
  7,160,140,224,104,74,138,229,100,74,138,229,20,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,
  96,74,138,229,56,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,64,74,138,229,20,74,138,229,14,240,160,225,
  7,160,140,224,96,74,138,229,56,74,138,229,20,74,138,229,14,240,160,225,7,160,140,224,64,74,138,229,56,74,138,229,
  20,74,138,229,14,240,160,225,4,224,45,229,75,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,
  114,1,0,235,179,1,0,235,4,240,157,228,4,224,45,229,110,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  60,74,138,229,61,1,0,235,214,1,0,235,4,240,157,228,4,224,45,229,167,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,60,74,138,229,52,1,0,235,205,1,0,235,4,240,157,228,4,224,45,229,202,1,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,60,74,138,229,87,1,0,235,152,1,0,235,4,240,157,228,4,224,45,229,39,1,0,235,
  4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,100,74,138,229,64,74,138,229,56,74,138,229,
  20,74,138,229,73,1,0,235,138,1,0,235,4,240,157,228,4,224,45,229,69,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,60,74,138,229,7,160,140,224,100,74,138,229,64,74,138,229,56,74,138,229,20,74,138,229,15,1,0,235,
  168,1,0,235,4,240,157,228,4,224,45,229,121,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,
  7,160,140,224,100,74,138,229,64,74,138,229,56,74,138,229,20,74,138,229,1,1,0,235,154,1,0,235,4,240,157,228,
  4,224,45,229,151,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,100,74,138,229,
  64,74,138,229,56,74,138,229,20,74,138,229,31,1,0,235,96,1,0,235,4,240,157,228,7,160,140,224,100,74,138,229,
  64,74,138,229,56,74,138,229,20,74,138,229,4,224,45,229,234,0,0,235,21,1,0,235,86,1,0,235,129,1,0,235,
  4,240,157,228,4,224,45,229,250,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,33,1,0,235,
  54,1,0,235,4,240,157,228,4,224,45,229,29,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,
  236,0,0,235,89,1,0,235,4,240,157,228,4,224,45,229,42,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  60,74,138,229,227,0,0,235,80,1,0,235,4,240,157,228,4,224,45,229,77,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,60,74,138,229,6,1,0,235,27,1,0,235,4,240,157,228,4,224,45,229,214,0,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,104,74,138,229,96,74,138,229,24,74,138,229,16,74,138,229,
  248,0,0,235,13,1,0,235,4,240,157,228,4,224,45,229,244,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  60,74,138,229,7,160,140,224,104,74,138,229,96,74,138,229,24,74,138,229,16,74,138,229,190,0,0,235,43,1,0,235,
  4,240,157,228,4,224,45,229,252,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,
  104,74,138,229,96,74,138,229,24,74,138,229,16,74,138,229,176,0,0,235,29,1,0,235,4,240,157,228,4,224,45,229,
  26,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,104,74,138,229,96,74,138,229,
  24,74,138,229,16,74,138,229,206,0,0,235,227,0,0,235,4,240,157,228,7,160,140,224,104,74,138,229,16,74,138,229,
  5,0,140,224,40,0,208,229,0,0,80,227,0,0,0,10,96,74,138,229,5,0,140,224,4,0,208,229,0,0,80,227,
  1,0,0,10,7,160,140,224,24,74,138,229,4,224,45,229,144,0,0,235,187,0,0,235,208,0,0,235,251,0,0,235,
  4,240,157,228,7,160,140,224,96,74,138,229,24,74,138,229,5,0,140,224,40,0,208,229,0,0,80,227,1,0,0,10,
  7,160,140,224,104,74,138,229,5,0,140,224,4,0,80,229,0,0,80,227,1,0,0,10,7,160,140,224,16,74,138,229,
  4,224,45,229,123,0,0,235,166,0,0,235,187,0,0,235,230,0,0,235,4,240,157,228,7,160,140,224,96,74,138,229,
  24,74,138,229,5,0,140,224,40,0,80,229,0,0,80,227,1,0,0,10,7,160,140,224,16,74,138,229,5,0,140,224,
  4,0,208,229,0,0,80,227,1,0,0,10,7,160,140,224,104,74,138,229,4,224,45,229,102,0,0,235,145,0,0,235,
  166,0,0,235,209,0,0,235,4,240,157,228,7,160,140,224,104,74,138,229,16,74,138,229,5,0,140,224,40,0,80,229,
  0,0,80,227,1,0,0,10,7,160,140,224,24,74,138,229,5,0,140,224,4,0,80,229,0,0,80,227,1,0,0,10,
  7,160,140,224,96,74,138,229,4,224,45,229,81,0,0,235,124,0,0,235,145,0,0,235,188,0,0,235,4,240,157,228,
  7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,64,74,138,229,24,74,138,229,16,74,138,229,14,240,160,225,
  7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,20,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,
  100,74,138,229,96,74,138,229,64,74,138,229,24,74,138,229,16,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,
  64,74,138,229,56,74,138,229,24,74,138,229,14,240,160,225,7,160,140,224,96,74,138,229,64,74,138,229,56,74,138,229,
  16,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,96,74,138,229,64,74,138,229,24,74,138,229,20,74,138,229,
  16,74,138,229,14,240,160,225,7,160,140,224,100,74,138,229,24,74,138,229,20,74,138,229,16,74,138,229,14,240,160,225,
  7,160,140,224,104,74,138,229,96,74,138,229,56,74,138,229,24,74,138,229,20,74,138,229,16,74,138,229,14,240,160,225,
  7,96,160,225,44,96,134,226,6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,
  0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,180,3,16,229,
  1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,104,74,138,229,14,240,160,225,7,96,160,225,40,96,134,226,
  6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,
  245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,52,3,16,229,1,0,80,227,2,0,0,186,
  237,255,255,26,6,160,140,224,100,74,138,229,14,240,160,225,7,96,160,225,36,96,134,226,6,160,140,224,60,74,138,229,
  36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,
  7,0,0,26,62,0,0,226,128,0,139,224,180,3,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,
  96,74,138,229,14,240,160,225,7,96,160,225,4,96,134,226,6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,
  1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,
  128,0,139,224,52,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,64,74,138,229,14,240,160,225,
  7,96,160,225,4,96,70,226,6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,
  0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,52,4,16,229,
  1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,56,74,138,229,14,240,160,225,7,96,160,225,36,96,70,226,
  6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,
  245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,180,4,16,229,1,0,80,227,2,0,0,186,
  237,255,255,26,6,160,140,224,24,74,138,229,14,240,160,225,7,96,160,225,40,96,70,226,6,160,140,224,60,74,138,229,
  36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,
  7,0,0,26,62,0,0,226,128,0,139,224,52,5,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,
  20,74,138,229,14,240,160,225,7,96,160,225,44,96,70,226,6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,
  1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,
  128,0,139,224,180,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,16,74,138,229,14,240,160,225,
  7,160,140,224,100,74,138,229,14,240,160,225,4,224,45,229,96,255,255,235,4,240,157,228,7,160,140,224,144,74,138,229,
  136,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,24,74,138,229,16,74,138,229,
  14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,64,74,138,229,56,74,138,229,20,74,138,229,
  14,240,160,225,4,224,45,229,52,255,255,235,95,255,255,235,160,255,255,235,203,255,255,235,4,240,157,228,4,224,45,229,
  112,255,255,235,133,255,255,235,176,255,255,235,65,255,255,235,4,240,157,228,40,0,86,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,120,48,131,226,39,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,27,6,0,234,
  0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,
  40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,
  64,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,4,6,0,234,84,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,75,48,131,226,83,16,86,229,15,0,160,227,144,1,10,224,
  10,64,132,224,76,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,75,48,131,226,75,16,86,229,
  15,0,160,227,144,1,10,224,10,64,132,224,239,5,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,105,48,131,226,43,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,44,0,214,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,
  40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,21,0,160,227,
  144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,
  35,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,105,48,131,226,37,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,188,5,0,234,36,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,35,16,86,229,16,0,160,227,144,1,10,224,
  10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,37,16,214,229,
  16,0,160,227,144,1,10,224,10,64,132,224,167,5,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,120,48,131,226,43,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,39,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,
  40,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,41,16,214,229,24,0,160,227,
  144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,
  35,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,120,48,131,226,3,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,4,0,214,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,5,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,
  106,5,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,
  21,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,
  105,48,131,226,39,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,36,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,35,16,86,229,21,0,160,227,144,1,10,224,
  10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,3,16,86,229,
  21,0,160,227,144,1,10,224,10,64,132,224,4,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,
  105,48,131,226,5,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,45,5,0,234,4,0,86,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,3,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,
  4,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,5,16,214,229,16,0,160,227,
  144,1,10,224,10,64,132,224,24,5,0,234,40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,
  80,48,131,226,39,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,80,48,131,226,41,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,4,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,3,16,86,229,16,0,160,227,144,1,10,224,
  10,64,132,224,4,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,5,16,214,229,
  16,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,
  1,0,215,229,0,16,129,224,50,48,131,226,44,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,
  4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,
  10,64,132,224,0,16,160,227,44,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,
  35,48,131,226,44,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,
  10,16,129,224,64,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,
  36,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,36,112,71,226,
  0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,
  0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,36,112,134,226,0,0,87,229,
  0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,36,112,135,226,0,0,87,229,0,0,80,227,
  248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,35,48,131,226,
  7,0,160,227,144,1,10,224,10,64,132,224,151,4,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,80,48,131,226,43,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,44,0,214,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,45,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,
  36,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,35,16,86,229,16,0,160,227,
  144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,
  37,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,
  6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,
  128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,
  144,1,10,224,10,64,132,224,0,16,160,227,40,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,40,48,131,226,40,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,40,48,131,226,8,0,160,227,144,1,10,224,10,64,132,224,
  0,16,160,227,4,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,
  4,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,
  64,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,4,112,134,226,
  0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,4,112,135,226,0,0,87,229,
  0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,
  35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,22,4,0,234,44,0,86,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,44,0,214,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,1,4,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,
  43,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,44,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,80,48,131,226,45,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,236,3,0,234,40,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,21,0,160,227,144,1,10,224,
  10,64,132,224,225,3,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,
  43,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,214,3,0,234,44,0,86,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,203,3,0,234,
  40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,39,16,86,229,24,0,160,227,
  144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,
  41,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,182,3,0,234,40,0,86,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,161,3,0,234,40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,
  39,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,80,48,131,226,41,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,140,3,0,234,36,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,35,16,86,229,24,0,160,227,144,1,10,224,
  10,64,132,224,129,3,0,234,36,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,
  35,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,118,3,0,234,0,16,160,227,44,112,70,226,0,0,87,229,
  0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,44,112,71,226,0,0,87,229,0,0,80,227,
  248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,50,48,131,226,
  10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,
  1,0,215,229,0,16,129,224,35,48,131,226,44,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,
  4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,
  10,64,132,224,73,3,0,234,0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,50,48,131,226,40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,
  0,16,160,227,40,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,40,48,131,226,
  40,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,
  64,0,16,227,0,0,0,26,40,48,131,226,8,0,160,227,144,1,10,224,10,64,132,224,28,3,0,234,40,0,214,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,41,16,214,229,24,0,160,227,144,1,10,224,
  10,64,132,224,45,3,0,234,0,16,160,227,40,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,50,48,131,226,40,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,
  22,3,0,234,84,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,75,48,131,226,85,16,214,229,
  15,0,160,227,144,1,10,224,10,64,132,224,76,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  75,48,131,226,77,16,214,229,15,0,160,227,144,1,10,224,10,64,132,224,1,3,0,234,44,0,214,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,
  44,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,21,0,160,227,
  144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,
  41,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,105,48,131,226,37,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,35,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,
  206,2,0,234,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,37,16,214,229,
  16,0,160,227,144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  80,48,131,226,35,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,185,2,0,234,44,0,214,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,45,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,
  40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,41,16,214,229,24,0,160,227,
  144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,
  39,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,120,48,131,226,37,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,4,0,214,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,5,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,
  4,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,3,16,86,229,24,0,160,227,
  144,1,10,224,10,64,132,224,124,2,0,234,44,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,
  32,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,21,0,160,227,144,1,10,224,
  10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,37,16,214,229,
  21,0,160,227,144,1,10,224,10,64,132,224,4,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  105,48,131,226,5,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,
  32,0,16,227,0,0,0,26,105,48,131,226,3,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,63,2,0,234,
  4,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,5,16,214,229,16,0,160,227,
  144,1,10,224,10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,
  3,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,42,2,0,234,40,0,214,229,128,0,16,227,6,0,0,26,
  32,0,16,227,0,0,0,26,80,48,131,226,41,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,39,16,86,229,16,0,160,227,144,1,10,224,
  10,64,132,224,4,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,5,16,214,229,
  16,0,160,227,144,1,10,224,10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  80,48,131,226,3,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,134,226,0,0,87,229,
  0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,44,112,135,226,0,0,87,229,0,0,80,227,
  248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,50,48,131,226,
  10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,
  1,0,215,229,0,16,129,224,35,48,131,226,44,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,
  4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,
  10,64,132,224,0,16,160,227,36,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,
  50,48,131,226,36,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,
  10,16,129,224,32,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,
  36,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,36,112,71,226,
  0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,
  0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,169,1,0,234,44,0,214,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,45,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,
  44,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,43,16,86,229,16,0,160,227,
  144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,
  37,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,80,48,131,226,35,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,40,112,134,226,
  0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,40,112,135,226,0,0,87,229,
  0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,
  50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,
  6,0,0,26,1,0,215,229,0,16,129,224,40,48,131,226,40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,
  128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,40,48,131,226,8,0,160,227,
  144,1,10,224,10,64,132,224,0,16,160,227,4,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,35,48,131,226,4,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,
  0,16,160,227,4,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,
  4,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,
  32,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,40,1,0,234,44,0,214,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,44,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,
  21,0,160,227,144,1,10,224,10,64,132,224,19,1,0,234,44,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,80,48,131,226,45,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,44,0,86,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,43,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,
  254,0,0,234,40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,
  21,0,160,227,144,1,10,224,10,64,132,224,243,0,0,234,44,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,120,48,131,226,45,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,232,0,0,234,44,0,214,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,221,0,0,234,40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,
  41,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,120,48,131,226,39,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,200,0,0,234,40,0,214,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,40,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,
  21,0,160,227,144,1,10,224,10,64,132,224,179,0,0,234,40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,80,48,131,226,41,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,39,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,
  158,0,0,234,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,37,16,214,229,
  24,0,160,227,144,1,10,224,10,64,132,224,147,0,0,234,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,105,48,131,226,37,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,136,0,0,234,0,16,160,227,
  44,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,44,112,135,226,
  0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,
  0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,70,226,0,0,87,229,
  0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,44,112,71,226,0,0,87,229,0,0,80,227,
  248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,35,48,131,226,
  7,0,160,227,144,1,10,224,10,64,132,224,91,0,0,234,0,16,160,227,40,112,134,226,0,0,87,229,0,0,80,227,
  6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,40,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,
  128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,
  144,1,10,224,10,64,132,224,0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,40,48,131,226,40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,40,48,131,226,8,0,160,227,144,1,10,224,10,64,132,224,
  46,0,0,234,116,83,159,229,0,0,160,227,131,144,160,227,4,0,197,228,1,144,89,226,252,255,255,26,152,95,28,229,
  5,96,140,224,0,16,86,229,30,16,1,226,129,32,139,224,0,48,160,227,1,0,214,229,52,162,18,229,144,10,4,224,
  13,2,214,229,0,16,129,225,129,0,143,224,176,240,144,229,164,48,131,224,163,49,160,225,180,113,18,229,84,0,69,226,
  0,0,151,231,0,48,131,224,244,1,18,229,0,0,83,225,0,48,160,33,116,2,18,229,163,50,128,224,2,48,198,229,
  152,95,22,229,84,0,85,227,228,255,255,42,148,95,28,229,5,96,140,224,0,16,86,229,30,16,1,226,129,32,139,224,
  0,48,160,227,1,0,214,229,52,162,18,229,144,10,4,224,15,2,214,229,0,16,129,225,129,0,143,224,128,241,144,229,
  164,48,131,224,163,49,160,225,180,113,18,229,109,15,101,226,0,0,151,231,0,48,131,224,244,1,18,229,0,0,83,225,
  0,48,160,33,116,2,18,229,163,50,128,224,2,48,198,229,152,95,22,229,84,0,85,227,228,255,255,42,14,240,160,225,
  212,214,0,0,208,216,0,0,0,215,0,0,196,217,0,0,92,215,0,0,196,217,0,0,176,215,0,0,196,217,0,0,
  196,217,0,0,0,0,0,0,172,219,0,0,12,219,0,0,176,221,0,0,16,221,0,0,252,214,0,0,0,0,0,0,
  252,214,0,0,232,223,0,0,252,214,0,0,20,224,0,0,252,214,0,0,20,224,0,0,20,223,0,0,20,224,0,0,
  20,224,0,0,0,0,0,0,148,225,0,0,148,225,0,0,252,214,0,0,104,223,0,0,252,214,0,0,0,0,0,0,
  212,214,0,0,64,224,0,0,0,215,0,0,148,224,0,0,252,214,0,0,148,224,0,0,188,223,0,0,148,224,0,0,
  148,224,0,0,0,0,0,0,252,214,0,0,232,224,0,0,72,226,0,0,72,226,0,0,252,214,0,0,0,0,0,0,
  252,214,0,0,60,225,0,0,252,214,0,0,104,225,0,0,252,214,0,0,104,225,0,0,40,216,0,0,104,225,0,0,
  104,225,0,0,0,0,0,0,92,220,0,0,92,220,0,0,252,214,0,0,124,216,0,0,252,214,0,0,0,0,0,0,
  252,214,0,0,112,217,0,0,252,214,0,0,100,218,0,0,252,214,0,0,100,218,0,0,252,214,0,0,100,218,0,0,
  100,218,0,0,0,0,0,0,252,214,0,0,184,218,0,0,96,222,0,0,96,222,0,0,252,214,0,0,0,0,0,0,
  252,226,0,0,248,228,0,0,40,227,0,0,236,229,0,0,132,227,0,0,236,229,0,0,216,227,0,0,236,229,0,0,
  236,229,0,0,0,0,0,0,212,231,0,0,52,231,0,0,216,233,0,0,56,233,0,0,36,227,0,0,0,0,0,0,
  36,227,0,0,16,236,0,0,36,227,0,0,60,236,0,0,36,227,0,0,60,236,0,0,60,235,0,0,60,236,0,0,
  60,236,0,0,0,0,0,0,188,237,0,0,188,237,0,0,36,227,0,0,144,235,0,0,36,227,0,0,0,0,0,0,
  252,226,0,0,104,236,0,0,40,227,0,0,188,236,0,0,36,227,0,0,188,236,0,0,228,235,0,0,188,236,0,0,
  188,236,0,0,0,0,0,0,36,227,0,0,16,237,0,0,112,238,0,0,112,238,0,0,36,227,0,0,0,0,0,0,
  36,227,0,0,100,237,0,0,36,227,0,0,144,237,0,0,36,227,0,0,144,237,0,0,80,228,0,0,144,237,0,0,
  144,237,0,0,0,0,0,0,132,232,0,0,132,232,0,0,36,227,0,0,164,228,0,0,36,227,0,0,0,0,0,0,
  36,227,0,0,152,229,0,0,36,227,0,0,140,230,0,0,36,227,0,0,140,230,0,0,36,227,0,0,140,230,0,0,
  140,230,0,0,0,0,0,0,36,227,0,0,224,230,0,0,136,234,0,0,136,234,0,0,36,227,0,0,0,0,0,0,
  234,20,0,224,4,224,45,229,220,122,28,229,84,80,160,227,9,144,160,227,9,128,160,227,0,3,45,233,5,160,140,224,
  38,54,218,229,39,70,218,229,104,0,83,227,104,48,160,35,104,0,84,227,104,64,160,35,36,6,218,229,37,22,218,229,
  1,0,80,225,1,0,0,10,10,64,132,34,10,48,131,50,1,16,218,229,145,4,0,224,32,114,135,224,145,3,0,224,
  32,114,71,224,128,4,45,233,36,102,218,229,37,118,218,229,60,26,218,229,1,112,135,224,73,28,218,229,75,44,218,229,
  85,62,218,229,87,78,218,229,80,235,255,235,128,4,189,232,104,0,80,227,104,0,160,35,1,16,218,229,144,1,2,224,
  162,114,135,224,128,4,45,233,36,102,218,229,37,118,218,229,48,24,218,229,1,96,134,224,73,28,218,229,75,44,218,229,
  85,62,218,229,87,78,218,229,28,235,255,235,128,4,189,232,104,0,80,227,104,0,160,35,1,16,218,229,144,1,2,224,
  162,114,71,224,0,3,189,232,4,80,133,226,1,128,88,226,200,255,255,26,4,80,133,226,1,144,89,226,196,255,255,26,
  71,114,160,225,220,122,12,229,4,240,157,228,4,224,45,229,168,95,28,229,124,218,255,235,0,0,160,227,5,0,204,231,
  168,111,28,229,6,80,160,225,64,0,0,235,152,8,12,229,16,144,160,227,44,80,70,226,60,0,0,235,40,80,70,226,
  58,0,0,235,36,80,70,226,56,0,0,235,4,80,70,226,54,0,0,235,4,80,134,226,52,0,0,235,36,80,134,226,
  50,0,0,235,40,80,134,226,48,0,0,235,44,80,134,226,46,0,0,235,168,95,28,229,92,0,160,227,5,0,204,231,
  73,218,255,235,3,24,160,227,152,40,28,229,130,32,137,224,96,2,0,235,0,0,96,226,216,10,12,229,164,95,28,229,
  89,218,255,235,0,0,160,227,5,0,204,231,164,111,28,229,6,80,160,225,58,1,0,235,152,8,12,229,16,144,160,227,
  44,80,70,226,54,1,0,235,40,80,70,226,52,1,0,235,36,80,70,226,50,1,0,235,4,80,70,226,48,1,0,235,
  4,80,134,226,46,1,0,235,36,80,134,226,44,1,0,235,40,80,134,226,42,1,0,235,44,80,134,226,40,1,0,235,
  164,95,28,229,60,0,160,227,5,0,204,231,38,218,255,235,3,24,160,227,152,40,28,229,130,32,137,224,61,2,0,235,
  216,26,28,229,0,16,129,224,216,26,12,229,4,240,157,228,4,224,45,229,5,160,140,224,0,0,90,229,192,0,16,227,
  21,1,0,26,36,6,26,229,22,20,90,229,32,8,145,225,17,1,0,26,0,112,160,227,8,128,160,227,60,10,218,229,
  0,0,80,227,4,128,136,2,44,64,90,229,128,0,20,227,28,0,0,26,248,21,218,229,249,37,218,229,68,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  176,8,208,229,0,112,135,224,16,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,136,8,208,229,0,112,135,224,64,0,20,227,3,0,0,26,80,6,26,229,66,20,90,229,
  32,8,145,225,6,128,136,2,40,64,90,229,128,0,20,227,28,0,0,26,252,21,218,229,253,37,218,229,64,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  48,8,208,229,0,112,135,224,20,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,8,8,208,229,0,112,135,224,64,0,20,227,3,0,0,26,76,6,26,229,62,20,90,229,
  32,8,145,225,6,128,136,2,36,64,90,229,128,0,20,227,28,0,0,26,0,22,218,229,1,38,218,229,60,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  176,7,208,229,0,112,135,224,24,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,136,7,208,229,0,112,135,224,64,0,20,227,3,0,0,26,72,6,26,229,58,20,90,229,
  32,8,145,225,6,128,136,2,4,64,90,229,128,0,20,227,28,0,0,26,32,22,218,229,33,38,218,229,28,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  61,7,208,229,0,112,135,224,56,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,21,7,208,229,0,112,135,224,64,0,20,227,3,0,0,26,40,6,26,229,26,20,90,229,
  32,8,145,225,5,128,136,2,4,64,218,229,128,0,20,227,28,0,0,26,40,22,218,229,41,38,218,229,20,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  189,6,208,229,0,112,135,224,64,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,149,6,208,229,0,112,135,224,64,0,20,227,3,0,0,26,32,6,26,229,18,20,90,229,
  32,8,145,225,5,128,136,2,36,64,218,229,128,0,20,227,28,0,0,26,72,22,218,229,73,38,218,229,244,3,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  74,6,208,229,0,112,135,224,96,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,34,6,208,229,0,112,135,224,64,0,20,227,3,0,0,26,0,6,26,229,242,19,90,229,
  32,8,145,225,3,128,136,2,40,64,218,229,128,0,20,227,28,0,0,26,76,22,218,229,77,38,218,229,240,3,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  202,5,208,229,0,112,135,224,100,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,162,5,208,229,0,112,135,224,64,0,20,227,3,0,0,26,252,5,26,229,238,19,90,229,
  32,8,145,225,3,128,136,2,44,64,218,229,128,0,20,227,28,0,0,26,80,22,218,229,81,38,218,229,236,3,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  74,5,208,229,0,112,135,224,104,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,34,5,208,229,0,112,135,224,64,0,20,227,3,0,0,26,248,5,26,229,234,19,90,229,
  32,8,145,225,3,128,136,2,167,112,160,225,20,0,88,227,20,128,160,35,20,0,160,227,144,7,1,224,8,32,160,225,
  36,1,0,235,128,32,128,226,1,24,160,227,33,1,0,235,0,0,89,225,0,144,160,49,4,240,157,228,16,0,160,227,
  4,240,157,228,4,224,45,229,5,160,140,224,0,0,90,229,160,0,16,227,21,1,0,26,34,6,26,229,24,20,90,229,
  32,8,145,225,17,1,0,26,0,112,160,227,8,128,160,227,48,8,218,229,0,0,80,227,4,128,136,2,44,64,218,229,
  128,0,20,227,28,0,0,26,80,22,218,229,81,38,218,229,234,3,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,60,4,208,229,0,112,135,224,92,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,20,4,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,246,5,26,229,236,19,90,229,32,8,145,225,6,128,136,2,40,64,218,229,
  128,0,20,227,28,0,0,26,76,22,218,229,77,38,218,229,238,3,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,188,3,208,229,0,112,135,224,88,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,148,3,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,250,5,26,229,240,19,90,229,32,8,145,225,6,128,136,2,36,64,218,229,
  128,0,20,227,28,0,0,26,72,22,218,229,73,38,218,229,242,3,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,60,3,208,229,0,112,135,224,84,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,20,3,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,254,5,26,229,244,19,90,229,32,8,145,225,6,128,136,2,4,64,218,229,
  128,0,20,227,28,0,0,26,40,22,218,229,41,38,218,229,18,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,201,2,208,229,0,112,135,224,52,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,161,2,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,30,6,26,229,20,20,90,229,32,8,145,225,5,128,136,2,4,64,90,229,
  128,0,20,227,28,0,0,26,32,22,218,229,33,38,218,229,26,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,73,2,208,229,0,112,135,224,44,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,33,2,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,38,6,26,229,28,20,90,229,32,8,145,225,5,128,136,2,36,64,90,229,
  128,0,20,227,28,0,0,26,0,22,218,229,1,38,218,229,58,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,214,1,208,229,0,112,135,224,12,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,174,1,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,70,6,26,229,60,20,90,229,32,8,145,225,3,128,136,2,40,64,90,229,
  128,0,20,227,28,0,0,26,252,21,218,229,253,37,218,229,62,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,86,1,208,229,0,112,135,224,8,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,46,1,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,74,6,26,229,64,20,90,229,32,8,145,225,3,128,136,2,44,64,90,229,
  128,0,20,227,28,0,0,26,248,21,218,229,249,37,218,229,66,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,214,0,208,229,0,112,135,224,4,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,174,0,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,78,6,26,229,68,20,90,229,32,8,145,225,3,128,136,2,167,112,160,225,
  20,0,88,227,20,128,160,35,20,0,160,227,144,7,1,224,8,32,160,225,7,0,0,235,128,32,128,226,1,24,160,227,
  4,0,0,235,0,0,89,225,0,144,160,49,4,240,157,228,16,0,160,227,4,240,157,228,1,48,160,227,2,0,81,225,
  2,0,0,58,130,32,160,225,131,48,160,225,250,255,255,234,0,0,160,227,2,0,81,225,1,0,0,58,2,16,65,224,
  3,0,128,224,162,32,160,225,163,48,176,225,248,255,255,26,14,240,160,225,0,0,0,60,60,75,180,180,225,225,225,225,
  225,0,0,0,40,40,50,120,120,150,150,150,150,150,0,0,0,20,20,25,60,60,75,75,75,75,75,0,0,0,0,0,
  0,30,30,37,90,90,112,112,4,224,45,229,168,111,28,229,6,80,160,225,45,0,0,235,128,144,160,225,0,128,160,227,
  44,80,70,226,38,0,0,235,40,80,70,226,36,0,0,235,36,80,70,226,34,0,0,235,4,80,70,226,32,0,0,235,
  4,80,134,226,30,0,0,235,36,80,134,226,28,0,0,235,40,80,134,226,26,0,0,235,44,80,134,226,24,0,0,235,
  8,144,137,224,164,111,28,229,6,80,160,225,40,0,0,235,128,144,73,224,0,128,160,227,44,80,70,226,33,0,0,235,
  40,80,70,226,31,0,0,235,36,80,70,226,29,0,0,235,4,80,70,226,27,0,0,235,4,80,134,226,25,0,0,235,
  36,80,134,226,23,0,0,235,40,80,134,226,21,0,0,235,44,80,134,226,19,0,0,235,8,144,73,224,208,154,12,229,
  4,240,157,228,5,0,220,231,192,0,16,227,11,0,0,26,5,160,140,224,36,6,26,229,22,20,90,229,32,8,129,225,
  60,26,218,229,1,0,144,225,4,0,0,26,5,0,143,224,92,0,144,229,0,0,88,225,0,128,160,49,14,240,160,225,
  0,0,160,227,14,240,160,225,5,0,220,231,160,0,16,227,12,0,0,26,5,160,140,224,34,6,26,229,24,20,90,229,
  32,8,129,225,48,24,218,229,1,0,144,225,5,0,0,26,130,15,101,226,0,0,143,224,20,0,144,229,0,0,88,225,
  0,128,160,49,14,240,160,225,0,0,160,227,14,240,160,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,
  244,1,0,0,244,1,0,0,0,0,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,
  244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,0,0,0,0,244,1,0,0,244,1,0,0,244,1,0,0,
  244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,0,0,0,0,44,1,0,0,
  44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,
  0,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,
  200,0,0,0,200,0,0,0,0,0,0,0,22,0,0,0,22,0,0,0,22,0,0,0,4,0,0,0,4,0,0,0,
  4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,4,0,0,0,22,0,0,0,14,0,0,0,
  4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,4,0,0,0,
  28,0,0,0,14,0,0,0,10,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,
  0,0,0,0,4,0,0,0,4,0,0,0,16,0,0,0,12,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,
  4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,224,45,229,
  152,81,159,229,0,0,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,0,16,160,227,196,15,92,229,
  0,1,139,224,116,1,16,229,0,16,129,224,188,15,92,229,0,1,139,224,116,1,16,229,0,16,65,224,195,15,92,229,
  0,1,139,224,40,1,16,229,0,16,129,224,187,15,92,229,0,1,139,224,40,1,16,229,0,16,65,224,194,15,92,229,
  0,1,139,224,20,1,16,229,0,16,129,224,186,15,92,229,0,1,139,224,20,1,16,229,0,16,65,224,193,15,92,229,
  0,1,139,224,0,1,16,229,0,16,129,224,185,15,92,229,0,1,139,224,0,1,16,229,0,16,65,224,192,15,92,229,
  0,1,139,224,236,0,16,229,0,16,129,224,184,15,92,229,0,1,139,224,236,0,16,229,0,16,65,224,191,15,92,229,
  0,1,139,224,216,0,16,229,0,16,129,224,183,15,92,229,0,1,139,224,216,0,16,229,0,16,65,224,190,15,92,229,
  0,1,139,224,204,0,16,229,0,16,129,224,182,15,92,229,0,1,139,224,204,0,16,229,0,16,65,224,129,2,160,225,
  224,10,12,229,152,95,28,229,37,0,0,235,140,8,28,229,0,49,131,224,136,8,28,229,0,0,80,227,1,0,0,26,
  1,0,160,227,9,2,70,229,224,10,28,229,3,0,128,224,224,10,12,229,24,52,134,229,192,0,20,229,163,50,128,224,
  2,48,198,229,152,95,22,229,84,0,85,227,237,255,255,42,148,95,28,229,56,0,0,235,140,8,28,229,0,49,131,224,
  136,8,28,229,0,0,80,227,1,0,0,26,1,0,160,227,9,2,70,229,224,10,28,229,3,0,64,224,224,10,12,229,
  24,52,134,229,192,0,20,229,163,50,128,224,2,48,198,229,152,95,22,229,84,0,85,227,237,255,255,42,4,240,157,228,
  0,25,0,224,4,224,45,229,0,0,160,227,148,8,12,229,144,8,12,229,140,8,12,229,136,8,12,229,5,96,140,224,
  0,16,86,229,30,16,1,226,129,64,139,224,1,48,214,229,128,0,20,229,144,3,3,224,13,2,214,229,0,16,129,225,
  129,0,143,224,236,240,144,229,180,17,20,229,84,0,69,226,0,0,145,231,35,50,128,224,0,0,86,229,92,0,80,227,
  12,0,0,10,136,8,28,229,0,0,80,227,2,0,0,26,64,16,20,229,0,0,81,227,51,49,67,16,148,8,28,229,
  0,48,131,224,244,1,20,229,0,0,83,225,0,48,160,193,0,0,83,227,0,48,160,179,4,240,157,228,4,224,45,229,
  0,0,160,227,148,8,12,229,144,8,12,229,140,8,12,229,136,8,12,229,5,96,140,224,0,16,86,229,30,16,1,226,
  129,64,139,224,1,48,214,229,128,0,20,229,144,3,3,224,15,2,214,229,0,16,129,225,129,0,143,224,148,241,144,229,
  180,17,20,229,109,15,101,226,0,0,145,231,35,50,128,224,0,0,86,229,60,0,80,227,12,0,0,10,136,8,28,229,
  0,0,80,227,2,0,0,26,64,16,20,229,0,0,81,227,51,49,67,16,148,8,28,229,0,48,131,224,244,1,20,229,
  0,0,83,225,0,48,160,193,0,0,83,227,0,48,160,179,4,240,157,228,36,9,1,0,60,11,1,0,84,9,1,0,
  72,12,1,0,164,9,1,0,72,12,1,0,0,10,1,0,72,12,1,0,72,12,1,0,0,0,0,0,96,14,1,0,
  176,13,1,0,68,16,1,0,148,15,1,0,120,17,1,0,0,0,0,0,80,9,1,0,112,18,1,0,80,9,1,0,
  160,18,1,0,80,9,1,0,160,18,1,0,136,17,1,0,160,18,1,0,160,18,1,0,0,0,0,0,68,20,1,0,
  68,20,1,0,80,9,1,0,228,17,1,0,80,9,1,0,0,0,0,0,36,9,1,0,208,18,1,0,84,9,1,0,
  44,19,1,0,80,9,1,0,44,19,1,0,64,18,1,0,44,19,1,0,44,19,1,0,0,0,0,0,80,9,1,0,
  136,19,1,0,224,20,1,0,224,20,1,0,80,9,1,0,0,0,0,0,80,9,1,0,228,19,1,0,80,9,1,0,
  20,20,1,0,80,9,1,0,20,20,1,0,132,10,1,0,20,20,1,0,20,20,1,0,0,0,0,0,248,14,1,0,
  248,14,1,0,80,9,1,0,224,10,1,0,80,9,1,0,0,0,0,0,80,9,1,0,236,11,1,0,80,9,1,0,
  248,12,1,0,80,9,1,0,248,12,1,0,80,9,1,0,248,12,1,0,248,12,1,0,0,0,0,0,80,9,1,0,
  84,13,1,0,220,16,1,0,220,16,1,0,80,9,1,0,0,0,0,0,124,21,1,0,148,23,1,0,172,21,1,0,
  160,24,1,0,252,21,1,0,160,24,1,0,88,22,1,0,160,24,1,0,160,24,1,0,0,0,0,0,184,26,1,0,
  8,26,1,0,156,28,1,0,236,27,1,0,208,29,1,0,0,0,0,0,168,21,1,0,200,30,1,0,168,21,1,0,
  248,30,1,0,168,21,1,0,248,30,1,0,224,29,1,0,248,30,1,0,248,30,1,0,0,0,0,0,156,32,1,0,
  156,32,1,0,168,21,1,0,60,30,1,0,168,21,1,0,0,0,0,0,124,21,1,0,40,31,1,0,172,21,1,0,
  132,31,1,0,168,21,1,0,132,31,1,0,152,30,1,0,132,31,1,0,132,31,1,0,0,0,0,0,168,21,1,0,
  224,31,1,0,56,33,1,0,56,33,1,0,168,21,1,0,0,0,0,0,168,21,1,0,60,32,1,0,168,21,1,0,
  108,32,1,0,168,21,1,0,108,32,1,0,220,22,1,0,108,32,1,0,108,32,1,0,0,0,0,0,80,27,1,0,
  80,27,1,0,168,21,1,0,56,23,1,0,168,21,1,0,0,0,0,0,168,21,1,0,68,24,1,0,168,21,1,0,
  80,25,1,0,168,21,1,0,80,25,1,0,168,21,1,0,80,25,1,0,80,25,1,0,0,0,0,0,168,21,1,0,
  172,25,1,0,52,29,1,0,52,29,1,0,168,21,1,0,0,0,0,0,0,0,88,229,32,0,16,227,26,0,0,10,
  28,0,0,226,128,16,139,224,192,16,17,229,192,32,20,229,1,0,82,225,1,32,160,177,129,16,114,224,2,0,0,74,
  148,8,28,229,1,0,128,224,148,8,12,229,2,16,216,229,2,32,214,229,153,8,92,229,0,32,82,224,0,32,160,51,
  2,16,81,224,8,0,0,218,144,8,28,229,1,0,80,225,2,0,0,170,144,24,12,229,140,8,12,229,14,240,160,225,
  140,8,28,229,1,0,80,225,140,24,12,181,14,240,160,225,0,0,88,229,64,0,16,227,26,0,0,10,28,0,0,226,
  128,16,139,224,192,16,17,229,192,32,20,229,1,0,82,225,1,32,160,177,129,16,114,224,2,0,0,74,148,8,28,229,
  1,0,128,224,148,8,12,229,2,16,216,229,2,32,214,229,154,8,92,229,0,32,82,224,0,32,160,51,2,16,81,224,
  8,0,0,218,144,8,28,229,1,0,80,225,2,0,0,170,144,24,12,229,140,8,12,229,14,240,160,225,140,8,28,229,
  1,0,80,225,140,24,12,181,14,240,160,225,4,224,45,229,174,229,255,235,25,230,255,235,0,32,160,227,2,16,214,229,
  4,16,65,226,155,8,92,229,1,0,80,225,13,0,0,58,0,0,88,229,64,0,16,227,10,0,0,26,40,32,130,226,
  136,8,28,229,1,0,128,226,136,8,12,229,153,24,92,229,155,8,92,229,0,16,65,224,5,0,81,227,6,0,0,186,
  24,32,130,226,4,0,0,234,153,24,92,229,155,8,92,229,0,16,65,224,5,0,81,227,48,32,130,162,153,8,92,229,
  0,0,80,227,1,0,0,10,128,32,130,226,5,0,0,234,72,12,216,229,0,1,85,225,2,0,0,26,120,32,130,226,
  2,0,214,229,0,32,66,224,1,16,216,229,145,2,0,224,160,147,137,224,4,240,157,228,4,224,45,229,63,229,255,235,
  202,229,255,235,0,32,160,227,2,16,214,229,4,16,65,226,156,8,92,229,1,0,80,225,13,0,0,58,0,0,88,229,
  32,0,16,227,10,0,0,26,40,32,130,226,136,8,28,229,1,0,128,226,136,8,12,229,154,24,92,229,156,8,92,229,
  0,16,65,224,5,0,81,227,6,0,0,186,24,32,130,226,4,0,0,234,154,24,92,229,156,8,92,229,0,16,65,224,
  5,0,81,227,48,32,130,162,154,8,92,229,0,0,80,227,1,0,0,10,128,32,130,226,5,0,0,234,84,14,216,229,
  0,1,85,225,2,0,0,26,120,32,130,226,2,0,214,229,0,32,66,224,1,16,216,229,145,2,0,224,160,147,137,224,
  4,240,157,228,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,162,255,255,235,
  99,255,255,235,24,0,160,227,153,0,1,224,1,48,131,224,132,254,255,234,0,144,160,227,40,112,69,226,7,128,140,224,
  0,0,88,229,0,0,80,227,5,0,0,26,150,255,255,235,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  249,255,255,10,128,0,16,227,1,0,0,26,142,255,255,235,79,255,255,235,10,0,160,227,153,0,1,224,1,48,131,224,
  112,254,255,234,84,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,84,112,69,226,7,128,140,224,130,255,255,235,
  67,255,255,235,15,0,160,227,153,0,1,224,1,48,131,224,76,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  76,112,69,226,7,128,140,224,119,255,255,235,56,255,255,235,15,0,160,227,153,0,1,224,1,48,131,224,89,254,255,234,
  44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,107,255,255,235,44,255,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,
  7,128,140,224,96,255,255,235,33,255,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,85,255,255,235,22,255,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,74,255,255,235,
  11,255,255,235,21,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,
  36,112,133,226,7,128,140,224,63,255,255,235,0,255,255,235,21,0,160,227,153,0,1,224,1,48,131,224,33,254,255,234,
  36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,51,255,255,235,244,254,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,
  7,128,140,224,40,255,255,235,233,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,10,254,255,234,44,0,86,229,
  128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,28,255,255,235,221,254,255,235,24,0,160,227,
  153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,
  17,255,255,235,210,254,255,235,24,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,133,226,7,128,140,224,6,255,255,235,199,254,255,235,24,0,160,227,153,0,1,224,1,48,131,224,
  36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,251,254,255,235,188,254,255,235,
  24,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,69,226,
  7,128,140,224,240,254,255,235,177,254,255,235,24,0,160,227,153,0,1,224,1,48,131,224,4,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,229,254,255,235,166,254,255,235,24,0,160,227,153,0,1,224,
  1,48,131,224,199,253,255,234,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,
  217,254,255,235,154,254,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,69,226,7,128,140,224,206,254,255,235,143,254,255,235,21,0,160,227,153,0,1,224,1,48,131,224,
  40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,195,254,255,235,132,254,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,
  7,128,140,224,184,254,255,235,121,254,255,235,21,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,4,112,69,226,7,128,140,224,173,254,255,235,110,254,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,162,254,255,235,
  99,254,255,235,21,0,160,227,153,0,1,224,1,48,131,224,132,253,255,234,4,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,4,112,69,226,7,128,140,224,150,254,255,235,87,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,139,254,255,235,76,254,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,109,253,255,234,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  40,112,69,226,7,128,140,224,127,254,255,235,64,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,116,254,255,235,53,254,255,235,16,0,160,227,
  153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,69,226,7,128,140,224,
  105,254,255,235,42,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,4,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,4,112,133,226,7,128,140,224,94,254,255,235,31,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  0,144,160,227,44,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,83,254,255,235,44,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,75,254,255,235,12,254,255,235,
  10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,44,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,
  5,0,0,26,64,254,255,235,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,
  1,0,0,26,56,254,255,235,249,253,255,235,7,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,36,112,69,226,
  7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,45,254,255,235,36,112,71,226,7,128,140,224,0,0,88,229,
  0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,37,254,255,235,230,253,255,235,10,0,160,227,153,0,1,224,
  1,48,131,224,0,144,160,227,36,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,26,254,255,235,
  36,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,18,254,255,235,
  211,253,255,235,7,0,160,227,153,0,1,224,1,48,131,224,244,252,255,234,44,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,44,112,69,226,7,128,140,224,6,254,255,235,199,253,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,251,253,255,235,188,253,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,
  7,128,140,224,240,253,255,235,177,253,255,235,16,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,229,253,255,235,166,253,255,235,16,0,160,227,153,0,1,224,
  1,48,131,224,0,144,160,227,40,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,218,253,255,235,
  40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,210,253,255,235,
  147,253,255,235,10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,40,112,133,226,7,128,140,224,0,0,88,229,
  0,0,80,227,5,0,0,26,199,253,255,235,40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,
  128,0,16,227,1,0,0,26,191,253,255,235,128,253,255,235,8,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,
  4,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,180,253,255,235,4,112,71,226,7,128,140,224,
  0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,172,253,255,235,109,253,255,235,7,0,160,227,
  153,0,1,224,1,48,131,224,0,144,160,227,4,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,
  161,253,255,235,4,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,
  153,253,255,235,90,253,255,235,7,0,160,227,153,0,1,224,1,48,131,224,123,252,255,234,136,8,28,229,1,0,128,226,
  136,8,12,229,119,252,255,234,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,
  137,253,255,235,74,253,255,235,21,0,160,227,153,0,1,224,1,48,131,224,44,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,44,112,133,226,7,128,140,224,126,253,255,235,63,253,255,235,21,0,160,227,153,0,1,224,1,48,131,224,
  96,252,255,234,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,114,253,255,235,
  51,253,255,235,16,0,160,227,153,0,1,224,1,48,131,224,44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,
  44,112,133,226,7,128,140,224,103,253,255,235,40,253,255,235,16,0,160,227,153,0,1,224,1,48,131,224,73,252,255,234,
  40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,91,253,255,235,28,253,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,61,252,255,234,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  44,112,69,226,7,128,140,224,79,253,255,235,16,253,255,235,24,0,160,227,153,0,1,224,1,48,131,224,49,252,255,234,
  44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,67,253,255,235,4,253,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,37,252,255,234,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  40,112,69,226,7,128,140,224,55,253,255,235,248,252,255,235,24,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,44,253,255,235,237,252,255,235,24,0,160,227,
  153,0,1,224,1,48,131,224,14,252,255,234,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,
  7,128,140,224,32,253,255,235,225,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,21,253,255,235,214,252,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,247,251,255,234,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,
  9,253,255,235,202,252,255,235,16,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,133,226,7,128,140,224,254,252,255,235,191,252,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  224,251,255,234,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,242,252,255,235,
  179,252,255,235,24,0,160,227,153,0,1,224,1,48,131,224,212,251,255,234,36,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,36,112,69,226,7,128,140,224,230,252,255,235,167,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,
  200,251,255,234,0,144,160,227,44,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,218,252,255,235,
  44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,210,252,255,235,
  147,252,255,235,10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,44,112,133,226,7,128,140,224,0,0,88,229,
  0,0,80,227,5,0,0,26,199,252,255,235,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,
  128,0,16,227,1,0,0,26,191,252,255,235,128,252,255,235,7,0,160,227,153,0,1,224,1,48,131,224,161,251,255,234,
  0,144,160,227,40,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,179,252,255,235,40,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,171,252,255,235,108,252,255,235,
  10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,40,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,
  5,0,0,26,160,252,255,235,40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,
  1,0,0,26,152,252,255,235,89,252,255,235,8,0,160,227,153,0,1,224,1,48,131,224,122,251,255,234,40,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,183,252,255,235,108,252,255,235,24,0,160,227,
  153,0,1,224,1,48,131,224,148,251,255,234,0,144,160,227,40,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,
  5,0,0,26,171,252,255,235,40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,
  1,0,0,26,163,252,255,235,88,252,255,235,10,0,160,227,153,0,1,224,1,48,131,224,128,251,255,234,84,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,84,112,133,226,7,128,140,224,151,252,255,235,76,252,255,235,15,0,160,227,
  153,0,1,224,1,48,131,224,76,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,76,112,133,226,7,128,140,224,
  140,252,255,235,65,252,255,235,15,0,160,227,153,0,1,224,1,48,131,224,105,251,255,234,44,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,128,252,255,235,53,252,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,117,252,255,235,
  42,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,
  40,112,133,226,7,128,140,224,106,252,255,235,31,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,95,252,255,235,20,252,255,235,21,0,160,227,
  153,0,1,224,1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,
  84,252,255,235,9,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,49,251,255,234,36,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,72,252,255,235,253,251,255,235,16,0,160,227,153,0,1,224,
  1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,61,252,255,235,
  242,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,26,251,255,234,44,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,44,112,133,226,7,128,140,224,49,252,255,235,230,251,255,235,24,0,160,227,153,0,1,224,1,48,131,224,
  40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,38,252,255,235,219,251,255,235,
  24,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,
  7,128,140,224,27,252,255,235,208,251,255,235,24,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,16,252,255,235,197,251,255,235,24,0,160,227,153,0,1,224,
  1,48,131,224,4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,5,252,255,235,
  186,251,255,235,24,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  4,112,69,226,7,128,140,224,250,251,255,235,175,251,255,235,24,0,160,227,153,0,1,224,1,48,131,224,215,250,255,234,
  44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,238,251,255,235,163,251,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,
  7,128,140,224,227,251,255,235,152,251,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,216,251,255,235,141,251,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,205,251,255,235,
  130,251,255,235,21,0,160,227,153,0,1,224,1,48,131,224,4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,
  4,112,133,226,7,128,140,224,194,251,255,235,119,251,255,235,21,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,
  128,0,16,227,7,0,0,26,0,144,160,227,4,112,69,226,7,128,140,224,183,251,255,235,108,251,255,235,21,0,160,227,
  153,0,1,224,1,48,131,224,148,250,255,234,4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,
  7,128,140,224,171,251,255,235,96,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,4,112,69,226,7,128,140,224,160,251,255,235,85,251,255,235,16,0,160,227,153,0,1,224,
  1,48,131,224,125,250,255,234,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,
  148,251,255,235,73,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,69,226,7,128,140,224,137,251,255,235,62,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,126,251,255,235,51,251,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,69,226,
  7,128,140,224,115,251,255,235,40,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,44,112,133,226,
  7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,104,251,255,235,44,112,135,226,7,128,140,224,0,0,88,229,
  0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,96,251,255,235,21,251,255,235,10,0,160,227,153,0,1,224,
  1,48,131,224,0,144,160,227,44,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,85,251,255,235,
  44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,77,251,255,235,
  2,251,255,235,7,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,36,112,133,226,7,128,140,224,0,0,88,229,
  0,0,80,227,5,0,0,26,66,251,255,235,36,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,
  128,0,16,227,1,0,0,26,58,251,255,235,239,250,255,235,10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,
  36,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,47,251,255,235,36,112,71,226,7,128,140,224,
  0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,39,251,255,235,220,250,255,235,7,0,160,227,
  153,0,1,224,1,48,131,224,4,250,255,234,44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,
  7,128,140,224,27,251,255,235,208,250,255,235,16,0,160,227,153,0,1,224,1,48,131,224,44,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,16,251,255,235,197,250,255,235,16,0,160,227,153,0,1,224,
  1,48,131,224,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,5,251,255,235,
  186,250,255,235,16,0,160,227,153,0,1,224,1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  36,112,69,226,7,128,140,224,250,250,255,235,175,250,255,235,16,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,
  40,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,239,250,255,235,40,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,231,250,255,235,156,250,255,235,10,0,160,227,
  153,0,1,224,1,48,131,224,0,144,160,227,40,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,
  220,250,255,235,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,
  212,250,255,235,137,250,255,235,8,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,4,112,133,226,7,128,140,224,
  0,0,88,229,0,0,80,227,5,0,0,26,201,250,255,235,4,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,
  249,255,255,10,128,0,16,227,1,0,0,26,193,250,255,235,118,250,255,235,7,0,160,227,153,0,1,224,1,48,131,224,
  0,144,160,227,4,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,182,250,255,235,4,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,174,250,255,235,99,250,255,235,
  7,0,160,227,153,0,1,224,1,48,131,224,139,249,255,234,136,8,28,229,1,0,128,226,136,8,12,229,135,249,255,234,
  44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,158,250,255,235,83,250,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,
  7,128,140,224,147,250,255,235,72,250,255,235,21,0,160,227,153,0,1,224,1,48,131,224,112,249,255,234,44,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,135,250,255,235,60,250,255,235,16,0,160,227,
  153,0,1,224,1,48,131,224,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,
  124,250,255,235,49,250,255,235,16,0,160,227,153,0,1,224,1,48,131,224,89,249,255,234,40,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,112,250,255,235,37,250,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,77,249,255,234,44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,
  100,250,255,235,25,250,255,235,24,0,160,227,153,0,1,224,1,48,131,224,65,249,255,234,44,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,88,250,255,235,13,250,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,53,249,255,234,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,
  76,250,255,235,1,250,255,235,24,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,69,226,7,128,140,224,65,250,255,235,246,249,255,235,24,0,160,227,153,0,1,224,1,48,131,224,
  30,249,255,234,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,53,250,255,235,
  234,249,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  40,112,69,226,7,128,140,224,42,250,255,235,223,249,255,235,21,0,160,227,153,0,1,224,1,48,131,224,7,249,255,234,
  40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,30,250,255,235,211,249,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,
  7,128,140,224,19,250,255,235,200,249,255,235,16,0,160,227,153,0,1,224,1,48,131,224,240,248,255,234,36,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,7,250,255,235,188,249,255,235,24,0,160,227,
  153,0,1,224,1,48,131,224,228,248,255,234,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,
  7,128,140,224,251,249,255,235,176,249,255,235,21,0,160,227,153,0,1,224,1,48,131,224,216,248,255,234,0,144,160,227,
  44,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,239,249,255,235,44,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,231,249,255,235,156,249,255,235,10,0,160,227,
  153,0,1,224,1,48,131,224,0,144,160,227,44,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,
  220,249,255,235,44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,
  212,249,255,235,137,249,255,235,7,0,160,227,153,0,1,224,1,48,131,224,177,248,255,234,0,144,160,227,40,112,133,226,
  7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,200,249,255,235,40,112,135,226,7,128,140,224,0,0,88,229,
  0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,192,249,255,235,117,249,255,235,10,0,160,227,153,0,1,224,
  1,48,131,224,0,144,160,227,40,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,181,249,255,235,
  40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,173,249,255,235,
  98,249,255,235,8,0,160,227,153,0,1,224,1,48,131,224,138,248,255,234,4,224,45,229,0,82,159,229,0,0,160,227,
  60,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,0,0,160,227,156,6,12,229,148,95,28,229,84,0,85,227,
  8,0,0,58,5,96,140,224,0,0,86,229,30,0,0,226,15,18,214,229,1,0,128,225,113,0,0,235,152,95,22,229,
  84,0,85,227,246,255,255,42,192,0,0,235,124,24,28,229,120,40,28,229,104,56,28,229,100,72,28,229,84,88,28,229,
  80,104,28,229,1,0,85,225,1,0,0,10,2,0,86,225,40,0,0,26,3,0,85,225,1,0,0,10,4,0,86,225,
  36,0,0,26,64,88,28,229,60,104,28,229,1,0,85,225,1,0,0,10,2,0,86,225,3,0,0,26,3,0,85,225,
  10,0,0,10,4,0,86,225,8,0,0,10,68,8,28,229,88,8,12,229,56,8,28,229,76,8,12,229,52,8,28,229,
  72,8,12,229,84,88,12,229,80,104,12,229,17,0,0,234,44,88,28,229,40,104,28,229,1,0,85,225,1,0,0,10,
  2,0,86,225,3,0,0,26,3,0,85,225,9,0,0,10,4,0,86,225,7,0,0,10,48,8,28,229,88,8,12,229,
  36,8,28,229,76,8,12,229,32,8,28,229,72,8,12,229,84,88,12,229,80,104,12,229,124,88,28,229,0,0,85,227,
  53,0,0,10,8,0,85,227,11,0,0,58,1,16,160,227,5,96,140,224,12,18,70,229,112,72,28,229,0,0,84,227,
  5,0,0,10,4,96,134,224,0,0,86,229,0,0,80,227,1,0,0,26,12,18,70,229,249,255,255,234,104,88,28,229,
  0,0,85,227,36,0,0,10,8,0,85,227,14,0,0,58,5,96,140,224,12,2,86,229,2,0,128,227,12,2,70,229,
  92,72,28,229,0,0,84,227,7,0,0,10,4,96,134,224,0,0,86,229,0,0,80,227,3,0,0,26,12,2,86,229,
  2,0,128,227,12,2,70,229,247,255,255,234,84,88,28,229,0,0,85,227,16,0,0,10,8,0,85,227,14,0,0,58,
  5,96,140,224,12,2,86,229,4,0,128,227,12,2,70,229,72,72,28,229,0,0,84,227,7,0,0,10,4,96,134,224,
  0,0,86,229,0,0,80,227,3,0,0,26,12,2,86,229,4,0,128,227,12,2,70,229,247,255,255,234,4,240,157,228,
  100,12,0,224,4,224,45,229,128,0,143,224,0,240,144,229,112,49,1,0,192,50,1,0,148,49,1,0,192,50,1,0,
  216,49,1,0,192,50,1,0,28,50,1,0,192,50,1,0,192,50,1,0,0,0,0,0,132,51,1,0,136,52,1,0,
  252,53,1,0,0,55,1,0,116,56,1,0,0,0,0,0,144,49,1,0,156,58,1,0,144,49,1,0,156,58,1,0,
  144,49,1,0,156,58,1,0,88,58,1,0,156,58,1,0,156,58,1,0,0,0,0,0,40,59,1,0,172,59,1,0,
  144,49,1,0,172,60,1,0,144,49,1,0,0,0,0,0,112,49,1,0,192,58,1,0,148,49,1,0,192,58,1,0,
  144,49,1,0,192,58,1,0,112,49,1,0,192,58,1,0,192,58,1,0,0,0,0,0,144,49,1,0,192,58,1,0,
  40,60,1,0,240,60,1,0,144,49,1,0,0,0,0,0,144,49,1,0,4,59,1,0,144,49,1,0,4,59,1,0,
  144,49,1,0,4,59,1,0,124,50,1,0,4,59,1,0,4,59,1,0,0,0,0,0,4,52,1,0,128,53,1,0,
  144,49,1,0,108,61,1,0,144,49,1,0,0,0,0,0,144,49,1,0,64,51,1,0,144,49,1,0,64,51,1,0,
  144,49,1,0,64,51,1,0,144,49,1,0,64,51,1,0,64,51,1,0,0,0,0,0,144,49,1,0,64,51,1,0,
  124,54,1,0,248,55,1,0,144,49,1,0,0,0,0,0,4,224,45,229,0,0,160,227,152,6,12,229,148,6,12,229,
  144,6,12,229,168,95,28,229,5,96,140,224,0,0,70,229,2,16,214,229,24,36,150,229,6,0,45,233,2,0,198,229,
  24,4,134,229,186,15,92,229,0,0,80,227,43,0,0,10,2,0,160,227,156,6,12,229,168,95,28,229,5,96,140,224,
  84,0,86,229,0,0,80,227,15,0,0,26,210,5,214,229,120,0,80,227,12,0,0,58,84,80,69,226,5,96,140,224,
  40,0,160,227,0,0,70,229,32,0,160,227,2,0,198,229,2,12,160,227,24,4,134,229,205,1,0,235,0,0,160,227,
  0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,76,0,86,229,0,0,80,227,15,0,0,26,
  218,5,214,229,120,0,80,227,12,0,0,58,76,80,69,226,5,96,140,224,40,0,160,227,0,0,70,229,32,0,160,227,
  2,0,198,229,2,12,160,227,24,4,134,229,184,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  185,15,92,229,0,0,80,227,106,0,0,10,3,0,160,227,156,6,12,229,168,95,28,229,5,96,140,224,40,0,86,229,
  0,0,80,227,15,0,0,26,254,5,214,229,120,0,80,227,12,0,0,58,40,80,69,226,5,96,140,224,44,0,160,227,
  0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,160,1,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,44,0,86,229,0,0,80,227,15,0,0,26,250,5,214,229,
  120,0,80,227,12,0,0,58,44,80,69,226,5,96,140,224,44,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,
  50,14,160,227,24,4,134,229,139,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,
  5,96,140,224,36,0,86,229,0,0,80,227,15,0,0,26,2,6,214,229,120,0,80,227,12,0,0,58,36,80,69,226,
  5,96,140,224,44,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,118,1,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,36,0,214,229,0,0,80,227,
  15,0,0,26,74,6,214,229,120,0,80,227,12,0,0,58,36,80,133,226,5,96,140,224,44,0,160,227,0,0,70,229,
  50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,97,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,168,95,28,229,5,96,140,224,44,0,214,229,0,0,80,227,15,0,0,26,82,6,214,229,120,0,80,227,
  12,0,0,58,44,80,133,226,5,96,140,224,44,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,
  24,4,134,229,76,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,184,15,92,229,0,0,80,227,
  127,0,0,10,4,0,160,227,156,6,12,229,168,95,28,229,5,96,140,224,40,0,86,229,0,0,80,227,15,0,0,26,
  254,5,214,229,120,0,80,227,12,0,0,58,40,80,69,226,5,96,140,224,48,0,160,227,0,0,70,229,52,0,160,227,
  2,0,198,229,13,13,160,227,24,4,134,229,52,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  168,95,28,229,5,96,140,224,44,0,86,229,0,0,80,227,15,0,0,26,250,5,214,229,120,0,80,227,12,0,0,58,
  44,80,69,226,5,96,140,224,48,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,
  31,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,36,0,86,229,
  0,0,80,227,15,0,0,26,2,6,214,229,120,0,80,227,12,0,0,58,36,80,69,226,5,96,140,224,48,0,160,227,
  0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,10,1,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,4,0,86,229,0,0,80,227,15,0,0,26,34,6,214,229,
  120,0,80,227,12,0,0,58,4,80,69,226,5,96,140,224,48,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,
  13,13,160,227,24,4,134,229,245,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,
  5,96,140,224,4,0,214,229,0,0,80,227,15,0,0,26,42,6,214,229,120,0,80,227,12,0,0,58,4,80,133,226,
  5,96,140,224,48,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,224,0,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,40,0,214,229,0,0,80,227,
  15,0,0,26,78,6,214,229,120,0,80,227,12,0,0,58,40,80,133,226,5,96,140,224,48,0,160,227,0,0,70,229,
  52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,203,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,183,15,92,229,0,0,80,227,85,0,0,10,5,0,160,227,156,6,12,229,168,95,28,229,14,0,0,234,
  5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,52,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,
  70,14,160,227,24,4,134,229,183,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,44,80,69,226,
  5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,14,0,0,234,5,96,140,224,38,6,214,229,120,0,80,227,
  10,0,0,58,52,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,162,0,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,36,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,
  168,95,28,229,14,0,0,234,5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,52,0,160,227,0,0,70,229,
  70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,141,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,36,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,14,0,0,234,5,96,140,224,
  38,6,214,229,120,0,80,227,10,0,0,58,52,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,70,14,160,227,
  24,4,134,229,120,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,44,80,133,226,5,0,220,231,
  0,0,80,227,236,255,255,10,182,15,92,229,0,0,80,227,85,0,0,10,6,0,160,227,156,6,12,229,168,95,28,229,
  14,0,0,234,5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,56,0,160,227,0,0,70,229,80,0,160,227,
  2,0,198,229,5,12,160,227,24,4,134,229,96,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  40,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,14,0,0,234,5,96,140,224,38,6,214,229,
  120,0,80,227,10,0,0,58,56,0,160,227,0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,
  75,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,4,80,69,226,5,0,220,231,0,0,80,227,
  236,255,255,10,168,95,28,229,14,0,0,234,5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,56,0,160,227,
  0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,54,0,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,4,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,14,0,0,234,
  5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,56,0,160,227,0,0,70,229,80,0,160,227,2,0,198,229,
  5,12,160,227,24,4,134,229,33,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,40,80,133,226,
  5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,5,96,140,224,92,0,160,227,0,0,70,229,6,0,189,232,
  2,16,198,229,24,36,134,229,152,38,28,229,0,0,82,227,6,0,0,10,148,86,28,229,144,118,28,229,0,0,160,227,
  160,6,12,229,164,6,12,229,0,64,160,227,97,0,0,235,4,240,157,228,4,224,45,229,54,1,0,234,4,224,45,229,
  69,1,0,234,4,224,45,229,108,1,0,234,4,224,45,229,155,1,0,234,4,224,45,229,55,2,0,234,4,224,45,229,
  224,1,45,233,7,80,160,225,31,204,255,235,224,1,189,232,0,16,86,229,0,32,88,229,6,0,45,233,2,16,129,227,
  10,0,0,234,4,224,45,229,0,0,88,229,0,0,80,227,85,0,0,10,224,1,45,233,7,80,160,225,18,204,255,235,
  224,1,189,232,0,16,86,229,0,32,88,229,6,0,45,233,0,16,72,229,0,0,160,227,0,0,70,229,2,16,216,229,
  2,0,214,229,2,0,200,229,226,1,45,233,7,80,160,225,137,245,255,235,140,8,28,229,128,49,131,224,226,1,189,232,
  2,16,200,229,6,0,189,232,0,16,70,229,0,32,72,229,24,4,150,229,0,48,67,224,195,50,160,225,232,1,45,233,
  7,80,160,225,224,203,255,235,232,1,189,232,2,16,214,229,2,32,216,229,2,64,160,225,0,0,160,227,164,6,12,229,
  120,0,82,227,24,0,0,42,3,16,129,224,3,32,130,224,0,0,82,227,44,0,0,218,0,0,83,227,0,48,160,179,
  164,54,12,229,221,219,255,235,1,48,160,225,156,8,92,229,0,16,81,224,0,16,160,51,48,8,216,229,0,0,80,227,
  4,0,0,10,227,219,255,235,156,8,92,229,0,48,83,224,0,48,160,51,0,0,0,234,1,48,160,225,2,64,160,225,
  1,32,82,224,24,0,0,74,3,64,68,224,156,6,28,229,0,0,80,227,7,0,0,10,152,6,28,229,2,0,80,225,
  3,0,0,42,152,38,12,229,156,22,28,229,148,22,12,229,144,86,12,229,4,240,157,228,48,8,28,229,2,0,80,225,
  9,0,0,42,68,8,28,229,2,0,80,225,7,0,0,58,48,40,12,229,44,88,12,229,40,120,12,229,164,6,28,229,
  36,8,12,229,160,6,28,229,32,8,12,229,4,240,157,228,88,8,28,229,2,0,80,225,17,0,0,58,68,8,28,229,
  48,8,12,229,68,40,12,229,64,8,28,229,44,8,12,229,64,88,12,229,60,8,28,229,40,8,12,229,60,120,12,229,
  56,8,28,229,36,8,12,229,164,6,28,229,56,8,12,229,52,8,28,229,32,8,12,229,160,6,28,229,52,8,12,229,
  4,240,157,228,108,8,28,229,2,0,80,225,27,0,0,58,68,8,28,229,48,8,12,229,88,8,28,229,68,8,12,229,
  88,40,12,229,64,8,28,229,44,8,12,229,84,8,28,229,64,8,12,229,84,88,12,229,60,8,28,229,40,8,12,229,
  80,8,28,229,60,8,12,229,80,120,12,229,56,8,28,229,36,8,12,229,76,8,28,229,56,8,12,229,164,6,28,229,
  76,8,12,229,52,8,28,229,32,8,12,229,72,8,28,229,52,8,12,229,160,6,28,229,72,8,12,229,4,240,157,228,
  128,8,28,229,2,0,80,225,37,0,0,58,68,8,28,229,48,8,12,229,88,8,28,229,68,8,12,229,108,8,28,229,
  88,8,12,229,108,40,12,229,64,8,28,229,44,8,12,229,84,8,28,229,64,8,12,229,104,8,28,229,84,8,12,229,
  104,88,12,229,60,8,28,229,40,8,12,229,80,8,28,229,60,8,12,229,100,8,28,229,80,8,12,229,100,120,12,229,
  56,8,28,229,36,8,12,229,76,8,28,229,56,8,12,229,96,8,28,229,76,8,12,229,164,6,28,229,96,8,12,229,
  52,8,28,229,32,8,12,229,72,8,28,229,52,8,12,229,92,8,28,229,72,8,12,229,160,6,28,229,92,8,12,229,
  4,240,157,228,0,0,84,227,2,0,0,186,160,6,28,229,0,0,80,227,0,0,0,10,0,64,160,227,132,72,12,229,
  68,8,28,229,48,8,12,229,88,8,28,229,68,8,12,229,108,8,28,229,88,8,12,229,128,8,28,229,108,8,12,229,
  128,40,12,229,64,8,28,229,44,8,12,229,84,8,28,229,64,8,12,229,104,8,28,229,84,8,12,229,124,8,28,229,
  104,8,12,229,124,88,12,229,60,8,28,229,40,8,12,229,80,8,28,229,60,8,12,229,100,8,28,229,80,8,12,229,
  120,8,28,229,100,8,12,229,120,120,12,229,56,8,28,229,36,8,12,229,76,8,28,229,56,8,12,229,96,8,28,229,
  76,8,12,229,116,8,28,229,96,8,12,229,164,6,28,229,116,8,12,229,52,8,28,229,32,8,12,229,72,8,28,229,
  52,8,12,229,92,8,28,229,72,8,12,229,112,8,28,229,92,8,12,229,160,6,28,229,112,8,12,229,4,240,157,228,
  81,15,87,227,14,255,255,58,3,255,255,234,81,15,85,227,11,255,255,58,0,255,255,234,160,6,28,229,0,0,80,227,
  17,0,0,26,36,6,216,229,3,0,80,227,14,0,0,186,12,0,0,202,196,31,28,229,192,47,28,229,255,0,193,227,
  1,0,144,225,7,0,0,26,255,0,17,227,6,0,0,10,7,0,139,224,36,11,16,229,0,0,140,224,128,11,80,229,
  0,0,80,227,0,0,0,26,160,70,12,229,14,240,160,225,40,0,214,229,160,0,16,227,4,0,0,26,0,0,160,227,
  160,6,12,229,40,112,133,226,7,128,140,224,219,255,255,235,4,240,157,228,0,0,160,227,160,6,12,229,40,112,133,226,
  4,0,0,234,7,128,140,224,212,255,255,235,40,64,160,227,216,255,255,235,40,112,135,226,7,0,220,231,0,0,80,227,
  247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,202,255,255,235,4,240,157,228,84,0,214,229,160,0,16,227,
  4,0,0,26,0,0,160,227,160,6,12,229,84,112,133,226,7,128,140,224,193,255,255,235,76,0,214,229,160,0,16,227,
  4,0,0,26,0,0,160,227,160,6,12,229,76,112,133,226,7,128,140,224,185,255,255,235,4,240,157,228,44,0,214,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,176,255,255,235,44,0,86,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,44,112,69,226,7,128,140,224,171,255,255,235,40,0,214,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,40,112,133,226,7,128,140,224,160,255,255,235,36,0,214,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,36,112,133,226,7,128,140,224,152,255,255,235,36,0,86,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,36,112,69,226,7,128,140,224,147,255,255,235,4,240,157,228,
  44,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,152,254,255,235,
  40,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,133,226,7,128,140,224,144,254,255,235,
  40,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,69,226,7,128,140,224,136,254,255,235,
  36,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,36,112,133,226,7,128,140,224,128,254,255,235,
  4,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,4,112,133,226,7,128,140,224,120,254,255,235,
  4,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,4,112,69,226,7,128,140,224,112,254,255,235,
  4,240,157,228,0,0,160,227,160,6,12,229,44,112,133,226,4,0,0,234,7,128,140,224,88,255,255,235,44,64,160,227,
  92,255,255,235,44,112,135,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  78,255,255,235,0,0,160,227,160,6,12,229,44,112,69,226,4,0,0,234,7,128,140,224,75,255,255,235,43,64,224,227,
  76,255,255,235,44,112,71,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  65,255,255,235,0,0,160,227,160,6,12,229,36,112,133,226,4,0,0,234,7,128,140,224,56,255,255,235,36,64,160,227,
  60,255,255,235,36,112,135,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  46,255,255,235,0,0,160,227,160,6,12,229,36,112,69,226,4,0,0,234,7,128,140,224,43,255,255,235,35,64,224,227,
  44,255,255,235,36,112,71,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  33,255,255,235,4,240,157,228,40,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,133,226,
  7,128,140,224,38,254,255,235,4,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,4,112,133,226,
  7,128,140,224,30,254,255,235,4,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,4,112,69,226,
  7,128,140,224,22,254,255,235,40,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,69,226,
  7,128,140,224,14,254,255,235,0,0,160,227,160,6,12,229,44,112,133,226,3,0,0,234,7,128,140,224,44,64,160,227,
  252,254,255,235,44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  255,253,255,235,0,0,160,227,160,6,12,229,44,112,69,226,3,0,0,234,7,128,140,224,43,64,224,227,237,254,255,235,
  44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,240,253,255,235,
  0,0,160,227,160,6,12,229,36,112,133,226,3,0,0,234,7,128,140,224,36,64,160,227,222,254,255,235,36,112,135,226,
  7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,225,253,255,235,0,0,160,227,
  160,6,12,229,36,112,69,226,3,0,0,234,7,128,140,224,35,64,224,227,207,254,255,235,36,112,71,226,7,0,220,231,
  0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,210,253,255,235,4,240,157,228,0,0,160,227,
  160,6,12,229,40,112,133,226,4,0,0,234,7,128,140,224,186,254,255,235,40,64,160,227,190,254,255,235,40,112,135,226,
  7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,176,254,255,235,0,0,160,227,
  160,6,12,229,40,112,69,226,4,0,0,234,7,128,140,224,173,254,255,235,39,64,224,227,174,254,255,235,40,112,71,226,
  7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,163,254,255,235,0,0,160,227,
  160,6,12,229,4,112,133,226,4,0,0,234,7,128,140,224,154,254,255,235,4,64,160,227,158,254,255,235,4,112,135,226,
  7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,144,254,255,235,0,0,160,227,
  160,6,12,229,4,112,69,226,4,0,0,234,7,128,140,224,141,254,255,235,3,64,224,227,142,254,255,235,4,112,71,226,
  7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,131,254,255,235,4,240,157,228,
  44,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,136,253,255,235,
  36,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,36,112,133,226,7,128,140,224,128,253,255,235,
  36,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,36,112,69,226,7,128,140,224,120,253,255,235,
  44,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,44,112,69,226,7,128,140,224,112,253,255,235,
  0,0,160,227,160,6,12,229,40,112,133,226,3,0,0,234,7,128,140,224,40,64,160,227,94,254,255,235,40,112,135,226,
  7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,97,253,255,235,0,0,160,227,
  160,6,12,229,40,112,69,226,3,0,0,234,7,128,140,224,39,64,224,227,79,254,255,235,40,112,71,226,7,0,220,231,
  0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,82,253,255,235,0,0,160,227,160,6,12,229,
  4,112,133,226,3,0,0,234,7,128,140,224,4,64,160,227,64,254,255,235,4,112,135,226,7,0,220,231,0,0,80,227,
  248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,67,253,255,235,0,0,160,227,160,6,12,229,4,112,69,226,
  3,0,0,234,7,128,140,224,3,64,224,227,49,254,255,235,4,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  64,0,16,227,1,0,0,10,7,128,140,224,52,253,255,235,4,240,157,228,24,4,86,229,128,0,16,227,11,0,0,26,
  44,0,214,229,64,0,16,227,8,0,0,10,246,5,22,229,236,19,86,229,32,8,145,225,4,0,0,26,0,0,160,227,
  160,6,12,229,44,112,133,226,7,128,140,224,36,253,255,235,24,4,86,229,64,0,16,227,11,0,0,26,40,0,214,229,
  64,0,16,227,8,0,0,10,250,5,22,229,240,19,86,229,32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,
  40,112,133,226,7,128,140,224,21,253,255,235,24,4,86,229,32,0,16,227,11,0,0,26,36,0,214,229,64,0,16,227,
  8,0,0,10,254,5,22,229,244,19,86,229,32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,36,112,133,226,
  7,128,140,224,6,253,255,235,24,4,86,229,16,0,16,227,11,0,0,26,4,0,214,229,64,0,16,227,8,0,0,10,
  30,6,22,229,20,20,86,229,32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,4,112,133,226,7,128,140,224,
  247,252,255,235,24,4,86,229,8,0,16,227,11,0,0,26,4,0,86,229,64,0,16,227,8,0,0,10,38,6,22,229,
  28,20,86,229,32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,4,112,69,226,7,128,140,224,232,252,255,235,
  24,4,86,229,4,0,16,227,11,0,0,26,36,0,86,229,64,0,16,227,8,0,0,10,70,6,22,229,60,20,86,229,
  32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,36,112,69,226,7,128,140,224,217,252,255,235,24,4,86,229,
  2,0,16,227,11,0,0,26,40,0,86,229,64,0,16,227,8,0,0,10,74,6,22,229,64,20,86,229,32,8,145,225,
  4,0,0,26,0,0,160,227,160,6,12,229,40,112,69,226,7,128,140,224,202,252,255,235,24,4,86,229,1,0,16,227,
  11,0,0,26,44,0,86,229,64,0,16,227,8,0,0,10,78,6,22,229,68,20,86,229,32,8,145,225,4,0,0,26,
  0,0,160,227,160,6,12,229,44,112,69,226,7,128,140,224,187,252,255,235,4,240,157,228,44,0,214,229,160,0,16,227,
  4,0,0,26,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,161,253,255,235,44,0,86,229,160,0,16,227,
  4,0,0,26,0,0,160,227,160,6,12,229,44,112,69,226,7,128,140,224,156,253,255,235,4,240,157,228,44,0,214,229,
  64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,161,252,255,235,4,240,157,228,
  40,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,133,226,7,128,140,224,152,252,255,235,
  40,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,69,226,7,128,140,224,144,252,255,235,
  4,240,157,228,36,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,36,112,133,226,7,128,140,224,
  135,252,255,235,4,240,157,228,0,0,160,227,160,6,12,229,44,112,133,226,4,0,0,234,7,128,140,224,111,253,255,235,
  44,64,160,227,115,253,255,235,44,112,135,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,101,253,255,235,0,0,160,227,160,6,12,229,44,112,69,226,4,0,0,234,7,128,140,224,98,253,255,235,
  43,64,224,227,99,253,255,235,44,112,71,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,88,253,255,235,4,240,157,228,0,0,160,227,160,6,12,229,44,112,133,226,3,0,0,234,7,128,140,224,
  44,64,160,227,83,253,255,235,44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,86,252,255,235,0,0,160,227,160,6,12,229,44,112,69,226,3,0,0,234,7,128,140,224,43,64,224,227,
  68,253,255,235,44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  71,252,255,235,4,240,157,228,0,0,160,227,160,6,12,229,40,112,133,226,4,0,0,234,7,128,140,224,47,253,255,235,
  40,64,160,227,51,253,255,235,40,112,135,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,37,253,255,235,0,0,160,227,160,6,12,229,40,112,69,226,4,0,0,234,7,128,140,224,34,253,255,235,
  39,64,224,227,35,253,255,235,40,112,71,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,24,253,255,235,4,240,157,228,44,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,
  44,112,133,226,7,128,140,224,29,252,255,235,44,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,
  44,112,69,226,7,128,140,224,21,252,255,235,4,240,157,228,0,0,160,227,160,6,12,229,40,112,133,226,3,0,0,234,
  7,128,140,224,40,64,160,227,2,253,255,235,40,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,
  1,0,0,10,7,128,140,224,5,252,255,235,0,0,160,227,160,6,12,229,40,112,69,226,3,0,0,234,7,128,140,224,
  39,64,224,227,243,252,255,235,40,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,246,251,255,235,4,240,157,228,36,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,
  36,112,133,226,7,128,140,224,237,251,255,235,36,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,
  36,112,69,226,7,128,140,224,229,251,255,235,4,240,157,228,4,224,45,229,240,10,28,229,0,0,80,227,4,0,0,10,
  128,8,28,229,132,8,12,229,120,8,28,229,236,10,12,229,69,0,0,234,120,8,28,229,236,26,28,229,0,0,81,225,
  65,0,0,10,236,10,12,229,112,72,28,229,0,0,84,227,32,0,0,10,124,88,28,229,104,8,28,229,5,0,80,225,
  10,0,0,26,92,8,28,229,4,0,80,225,7,0,0,26,84,8,28,229,5,0,80,225,15,0,0,26,72,8,28,229,
  4,0,80,225,12,0,0,26,0,16,160,227,42,0,0,234,120,120,28,229,108,24,28,229,100,8,28,229,7,0,80,225,
  37,0,0,26,88,24,28,229,80,8,28,229,7,0,80,225,33,0,0,26,0,16,160,227,31,0,0,234,120,120,28,229,
  88,24,28,229,80,8,28,229,7,0,80,225,26,0,0,26,0,16,160,227,24,0,0,234,124,8,28,229,8,0,80,227,
  9,0,0,42,108,24,28,229,104,8,28,229,8,0,80,227,17,0,0,42,88,24,28,229,84,8,28,229,8,0,80,227,
  13,0,0,42,0,16,160,227,11,0,0,234,132,24,28,229,120,120,28,229,108,40,28,229,100,8,28,229,7,0,80,225,
  3,0,0,26,88,40,28,229,80,8,28,229,7,0,80,225,1,0,0,10,2,0,81,225,2,16,160,49,128,72,28,229,
  1,64,68,224,1,64,84,226,28,72,12,85,0,0,160,227,140,6,12,229,1,0,160,227,0,4,128,224,0,8,128,224,
  112,6,12,229,152,95,28,229,84,0,85,227,11,0,0,58,112,6,28,229,224,0,160,225,112,6,12,229,5,96,140,224,
  0,0,86,229,30,0,0,226,13,18,214,229,1,0,128,225,28,0,0,235,152,95,22,229,84,0,85,227,243,255,255,42,
  107,0,0,235,28,8,28,229,0,0,80,227,4,0,0,10,12,24,28,229,8,40,28,229,2,16,145,225,1,0,128,2,
  28,8,12,5,4,8,28,229,0,0,80,227,4,0,0,10,244,23,28,229,240,39,28,229,2,16,145,225,1,0,128,2,
  4,8,12,5,236,7,28,229,0,0,80,227,4,0,0,10,220,23,28,229,216,39,28,229,2,16,145,225,1,0,128,2,
  236,7,12,5,4,240,157,228,4,224,45,229,128,0,143,224,0,240,144,229,24,79,1,0,60,80,1,0,56,79,1,0,
  60,80,1,0,112,79,1,0,60,80,1,0,172,79,1,0,60,80,1,0,60,80,1,0,0,0,0,0,232,80,1,0,
  188,81,1,0,0,83,1,0,212,83,1,0,24,85,1,0,0,0,0,0,52,79,1,0,24,87,1,0,52,79,1,0,
  24,87,1,0,52,79,1,0,24,87,1,0,220,86,1,0,24,87,1,0,24,87,1,0,0,0,0,0,148,87,1,0,
  0,88,1,0,52,79,1,0,216,88,1,0,52,79,1,0,0,0,0,0,24,79,1,0,56,87,1,0,56,79,1,0,
  56,87,1,0,52,79,1,0,56,87,1,0,24,79,1,0,56,87,1,0,56,87,1,0,0,0,0,0,52,79,1,0,
  56,87,1,0,108,88,1,0,20,89,1,0,52,79,1,0,0,0,0,0,52,79,1,0,116,87,1,0,52,79,1,0,
  116,87,1,0,52,79,1,0,116,87,1,0,0,80,1,0,116,87,1,0,116,87,1,0,0,0,0,0,80,81,1,0,
  148,82,1,0,52,79,1,0,128,89,1,0,52,79,1,0,0,0,0,0,52,79,1,0,172,80,1,0,52,79,1,0,
  172,80,1,0,52,79,1,0,172,80,1,0,52,79,1,0,172,80,1,0,172,80,1,0,0,0,0,0,52,79,1,0,
  172,80,1,0,104,83,1,0,172,84,1,0,52,79,1,0,0,0,0,0,0,0,160,227,136,6,12,229,132,6,12,229,
  128,6,12,229,124,6,12,229,120,6,12,229,116,6,12,229,164,95,28,229,5,96,140,224,0,0,70,229,2,16,214,229,
  24,36,150,229,6,0,45,233,2,0,198,229,24,4,134,229,194,15,92,229,0,0,80,227,43,0,0,10,2,0,160,227,
  140,6,12,229,164,95,28,229,5,96,140,224,84,0,214,229,0,0,80,227,15,0,0,26,123,6,214,229,120,0,80,227,
  12,0,0,58,84,80,133,226,5,96,140,224,72,0,160,227,0,0,70,229,32,0,160,227,2,0,198,229,2,12,160,227,
  24,4,134,229,205,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,
  76,0,214,229,0,0,80,227,15,0,0,26,115,6,214,229,120,0,80,227,12,0,0,58,76,80,133,226,5,96,140,224,
  72,0,160,227,0,0,70,229,32,0,160,227,2,0,198,229,2,12,160,227,24,4,134,229,184,1,0,235,0,0,160,227,
  0,0,70,229,2,0,198,229,24,4,134,229,193,15,92,229,0,0,80,227,106,0,0,10,3,0,160,227,140,6,12,229,
  164,95,28,229,5,96,140,224,40,0,214,229,0,0,80,227,15,0,0,26,79,6,214,229,120,0,80,227,12,0,0,58,
  40,80,133,226,5,96,140,224,76,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,
  160,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,44,0,214,229,
  0,0,80,227,15,0,0,26,83,6,214,229,120,0,80,227,12,0,0,58,44,80,133,226,5,96,140,224,76,0,160,227,
  0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,139,1,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,36,0,214,229,0,0,80,227,15,0,0,26,75,6,214,229,
  120,0,80,227,12,0,0,58,36,80,133,226,5,96,140,224,76,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,
  50,14,160,227,24,4,134,229,118,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,
  5,96,140,224,36,0,86,229,0,0,80,227,15,0,0,26,3,6,214,229,120,0,80,227,12,0,0,58,36,80,69,226,
  5,96,140,224,76,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,97,1,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,44,0,86,229,0,0,80,227,
  15,0,0,26,251,5,214,229,120,0,80,227,12,0,0,58,44,80,69,226,5,96,140,224,76,0,160,227,0,0,70,229,
  50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,76,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,192,15,92,229,0,0,80,227,127,0,0,10,4,0,160,227,140,6,12,229,164,95,28,229,5,96,140,224,
  40,0,214,229,0,0,80,227,15,0,0,26,79,6,214,229,120,0,80,227,12,0,0,58,40,80,133,226,5,96,140,224,
  80,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,52,1,0,235,0,0,160,227,
  0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,44,0,214,229,0,0,80,227,15,0,0,26,
  83,6,214,229,120,0,80,227,12,0,0,58,44,80,133,226,5,96,140,224,80,0,160,227,0,0,70,229,52,0,160,227,
  2,0,198,229,13,13,160,227,24,4,134,229,31,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  164,95,28,229,5,96,140,224,36,0,214,229,0,0,80,227,15,0,0,26,75,6,214,229,120,0,80,227,12,0,0,58,
  36,80,133,226,5,96,140,224,80,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,
  10,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,4,0,214,229,
  0,0,80,227,15,0,0,26,43,6,214,229,120,0,80,227,12,0,0,58,4,80,133,226,5,96,140,224,80,0,160,227,
  0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,245,0,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,4,0,86,229,0,0,80,227,15,0,0,26,35,6,214,229,
  120,0,80,227,12,0,0,58,4,80,69,226,5,96,140,224,80,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,
  13,13,160,227,24,4,134,229,224,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,
  5,96,140,224,40,0,86,229,0,0,80,227,15,0,0,26,255,5,214,229,120,0,80,227,12,0,0,58,40,80,69,226,
  5,96,140,224,80,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,203,0,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,191,15,92,229,0,0,80,227,85,0,0,10,5,0,160,227,
  140,6,12,229,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,84,0,160,227,
  0,0,70,229,70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,183,0,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,44,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,14,0,0,234,
  5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,84,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,
  70,14,160,227,24,4,134,229,162,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,36,80,133,226,
  5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,
  10,0,0,58,84,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,141,0,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,36,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,
  164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,84,0,160,227,0,0,70,229,
  70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,120,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,44,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,190,15,92,229,0,0,80,227,85,0,0,10,
  6,0,160,227,140,6,12,229,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,
  88,0,160,227,0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,96,0,0,235,0,0,160,227,
  0,0,70,229,2,0,198,229,24,4,134,229,40,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,
  14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,88,0,160,227,0,0,70,229,80,0,160,227,
  2,0,198,229,5,12,160,227,24,4,134,229,75,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  4,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,
  120,0,80,227,10,0,0,58,88,0,160,227,0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,
  54,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,4,80,69,226,5,0,220,231,0,0,80,227,
  236,255,255,10,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,88,0,160,227,
  0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,33,0,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,40,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,5,96,140,224,
  60,0,160,227,0,0,70,229,6,0,189,232,2,16,198,229,24,36,134,229,136,38,28,229,0,0,82,227,6,0,0,10,
  136,22,28,229,132,150,28,229,128,38,28,229,124,70,28,229,120,86,28,229,116,118,28,229,158,0,0,235,14,240,160,225,
  4,224,45,229,169,1,0,234,4,224,45,229,182,1,0,234,4,224,45,229,216,1,0,234,4,224,45,229,1,2,0,234,
  4,224,45,229,133,2,0,234,4,224,45,229,224,1,45,233,128,0,45,233,44,197,255,235,32,0,189,232,42,197,255,235,
  224,1,189,232,0,16,86,229,0,32,88,229,6,0,45,233,2,16,129,227,15,0,0,234,4,224,45,229,0,0,160,227,
  144,8,12,229,2,48,214,229,2,64,216,229,0,0,84,227,42,0,0,10,224,1,45,233,128,0,45,233,26,197,255,235,
  32,0,189,232,24,197,255,235,224,1,189,232,0,16,86,229,0,32,88,229,6,0,45,233,0,16,72,229,0,0,160,227,
  0,0,70,229,2,16,216,229,2,0,214,229,2,0,200,229,226,3,45,233,7,80,160,225,243,196,255,235,104,238,255,235,
  8,0,45,233,8,197,255,235,8,0,189,232,140,8,28,229,128,49,131,224,226,3,189,232,2,16,200,229,6,0,189,232,
  0,16,70,229,0,32,72,229,24,4,150,229,0,48,67,224,195,50,160,225,232,1,45,233,32,0,45,233,7,80,160,225,
  225,196,255,235,32,0,189,232,223,196,255,235,232,1,189,232,2,64,216,229,3,64,132,224,2,0,214,229,0,48,131,224,
  0,0,84,227,2,0,0,218,240,10,28,229,0,0,80,227,68,65,132,16,51,213,255,235,155,8,92,229,0,48,83,224,
  0,48,160,51,144,8,28,229,0,64,132,224,0,48,131,224,3,32,160,225,2,64,68,224,128,56,28,229,3,16,160,225,
  12,2,88,229,1,0,16,227,5,0,0,26,120,8,28,229,0,0,85,225,2,0,0,10,0,0,84,227,24,0,0,202,
  4,240,157,228,108,56,28,229,12,2,88,229,2,0,16,227,2,0,0,26,100,8,28,229,0,0,85,225,7,0,0,26,
  88,56,28,229,12,2,88,229,4,0,16,227,2,0,0,26,80,8,28,229,0,0,85,225,0,0,0,26,0,48,160,227,
  120,8,28,229,0,0,85,225,5,0,0,26,124,8,28,229,0,0,87,225,2,0,0,10,116,8,28,229,0,0,83,225,
  0,48,160,49,3,16,65,224,2,0,83,225,2,48,160,33,240,10,28,229,0,0,80,227,12,0,0,10,140,6,28,229,
  0,0,80,227,4,240,157,20,3,16,129,224,4,16,129,224,3,0,81,227,4,240,157,212,112,6,92,229,10,2,70,229,
  10,18,88,229,0,16,129,225,10,18,72,229,4,240,157,228,140,6,28,229,0,0,80,227,14,0,0,10,3,16,129,224,
  4,16,129,224,0,0,81,227,4,240,157,212,136,6,28,229,0,0,81,225,4,240,157,212,136,22,12,229,132,150,12,229,
  128,38,12,229,124,70,12,229,140,6,28,229,120,6,12,229,116,86,12,229,4,240,157,228,104,6,28,229,0,0,80,227,
  3,0,0,26,108,6,28,229,0,0,85,225,4,240,157,4,8,0,0,234,108,6,28,229,8,0,80,227,2,0,0,42,
  108,6,28,229,0,0,85,225,2,0,0,26,104,6,28,229,0,0,87,225,4,240,157,4,64,11,28,229,0,0,87,225,
  4,240,157,4,80,11,28,229,0,0,80,227,10,0,0,10,0,0,87,225,8,0,0,10,168,15,28,229,0,0,85,225,
  5,0,0,10,76,11,28,229,0,0,80,227,116,0,0,10,12,2,88,229,1,0,16,227,113,0,0,10,3,16,129,224,
  4,16,129,224,0,0,81,227,109,0,0,218,236,7,28,229,0,0,81,225,106,0,0,58,2,0,0,26,224,7,28,229,
  0,0,84,225,102,0,0,218,4,8,28,229,0,0,81,225,3,0,0,58,9,0,0,26,248,7,28,229,0,0,84,225,
  6,0,0,202,236,23,12,229,232,151,12,229,228,39,12,229,224,71,12,229,220,87,12,229,216,119,12,229,88,0,0,234,
  28,8,28,229,0,0,81,225,3,0,0,58,28,0,0,26,16,8,28,229,0,0,84,225,25,0,0,202,4,8,28,229,
  236,7,12,229,4,24,12,229,0,8,28,229,232,7,12,229,0,152,12,229,252,7,28,229,228,7,12,229,252,39,12,229,
  248,7,28,229,224,7,12,229,248,71,12,229,244,7,28,229,220,7,12,229,244,87,12,229,240,7,28,229,216,7,12,229,
  240,119,12,229,62,0,0,234,4,24,12,229,0,152,12,229,252,39,12,229,248,71,12,229,244,87,12,229,240,119,12,229,
  55,0,0,234,4,8,28,229,236,7,12,229,28,8,28,229,4,8,12,229,28,24,12,229,0,8,28,229,232,7,12,229,
  24,8,28,229,0,8,12,229,24,152,12,229,252,7,28,229,228,7,12,229,20,8,28,229,252,7,12,229,20,40,12,229,
  248,7,28,229,224,7,12,229,16,8,28,229,248,7,12,229,16,72,12,229,244,7,28,229,220,7,12,229,12,8,28,229,
  244,7,12,229,12,88,12,229,240,7,28,229,216,7,12,229,8,8,28,229,240,7,12,229,8,120,12,229,24,0,0,234,
  28,24,12,229,24,152,12,229,20,40,12,229,16,72,12,229,12,88,12,229,8,120,12,229,17,0,0,234,28,8,28,229,
  4,8,12,229,28,24,12,229,24,8,28,229,0,8,12,229,24,152,12,229,20,8,28,229,252,7,12,229,20,40,12,229,
  16,8,28,229,248,7,12,229,16,72,12,229,12,8,28,229,244,7,12,229,12,88,12,229,8,8,28,229,240,7,12,229,
  8,120,12,229,164,7,28,229,0,0,84,225,4,240,157,212,176,7,28,229,0,0,84,225,84,0,0,218,188,7,28,229,
  0,0,84,225,71,0,0,218,200,7,28,229,0,0,84,225,52,0,0,218,212,7,28,229,0,0,84,225,27,0,0,218,
  176,7,28,229,164,7,12,229,188,7,28,229,176,7,12,229,200,7,28,229,188,7,12,229,212,7,28,229,200,7,12,229,
  212,71,12,229,172,7,28,229,160,7,12,229,184,7,28,229,172,7,12,229,196,7,28,229,184,7,12,229,208,7,28,229,
  196,7,12,229,208,87,12,229,168,7,28,229,156,7,12,229,180,7,28,229,168,7,12,229,192,7,28,229,180,7,12,229,
  204,7,28,229,192,7,12,229,204,119,12,229,4,240,157,228,176,7,28,229,164,7,12,229,188,7,28,229,176,7,12,229,
  200,7,28,229,188,7,12,229,200,71,12,229,172,7,28,229,160,7,12,229,184,7,28,229,172,7,12,229,196,7,28,229,
  184,7,12,229,196,87,12,229,168,7,28,229,156,7,12,229,180,7,28,229,168,7,12,229,192,7,28,229,180,7,12,229,
  192,119,12,229,4,240,157,228,176,7,28,229,164,7,12,229,188,7,28,229,176,7,12,229,188,71,12,229,172,7,28,229,
  160,7,12,229,184,7,28,229,172,7,12,229,184,87,12,229,168,7,28,229,156,7,12,229,180,7,28,229,168,7,12,229,
  180,119,12,229,4,240,157,228,176,7,28,229,164,7,12,229,176,71,12,229,172,7,28,229,160,7,12,229,172,87,12,229,
  168,7,28,229,156,7,12,229,168,119,12,229,4,240,157,228,164,71,12,229,160,87,12,229,156,119,12,229,4,240,157,228,
  204,0,87,227,131,254,255,42,118,254,255,234,204,0,85,227,128,254,255,42,115,254,255,234,0,144,160,227,40,0,86,229,
  192,0,16,227,2,0,0,26,40,112,69,226,7,128,140,224,242,255,255,235,4,240,157,228,0,144,160,227,5,112,160,225,
  40,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,233,255,255,235,248,255,255,234,32,0,16,227,
  1,0,0,10,7,128,140,224,228,255,255,235,4,240,157,228,0,144,160,227,84,0,86,229,192,0,16,227,2,0,0,26,
  84,112,69,226,7,128,140,224,220,255,255,235,0,144,160,227,76,0,86,229,192,0,16,227,2,0,0,26,76,112,69,226,
  7,128,140,224,213,255,255,235,4,240,157,228,1,144,160,227,44,0,86,229,192,0,16,227,2,0,0,26,44,112,69,226,
  7,128,140,224,205,255,255,235,1,144,160,227,44,0,214,229,192,0,16,227,2,0,0,26,44,112,133,226,7,128,140,224,
  201,255,255,235,0,144,160,227,40,0,86,229,192,0,16,227,2,0,0,26,40,112,69,226,7,128,140,224,191,255,255,235,
  1,144,160,227,36,0,86,229,192,0,16,227,2,0,0,26,36,112,69,226,7,128,140,224,184,255,255,235,1,144,160,227,
  36,0,214,229,192,0,16,227,2,0,0,26,36,112,133,226,7,128,140,224,180,255,255,235,4,240,157,228,0,144,160,227,
  44,0,86,229,192,0,16,227,2,0,0,26,44,112,69,226,7,128,140,224,47,254,255,235,1,144,160,227,40,0,214,229,
  192,0,16,227,2,0,0,26,40,112,133,226,7,128,140,224,40,254,255,235,1,144,160,227,40,0,86,229,192,0,16,227,
  2,0,0,26,40,112,69,226,7,128,140,224,33,254,255,235,0,144,160,227,36,0,86,229,192,0,16,227,2,0,0,26,
  36,112,69,226,7,128,140,224,26,254,255,235,1,144,160,227,4,0,86,229,192,0,16,227,2,0,0,26,4,112,69,226,
  7,128,140,224,19,254,255,235,1,144,160,227,4,0,214,229,192,0,16,227,2,0,0,26,4,112,133,226,7,128,140,224,
  12,254,255,235,4,240,157,228,1,144,160,227,5,112,160,225,44,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,125,255,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,120,255,255,235,1,144,160,227,
  5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,115,255,255,235,248,255,255,234,
  32,0,16,227,1,0,0,10,7,128,140,224,110,255,255,235,1,144,160,227,5,112,160,225,36,112,71,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,128,140,224,99,255,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,
  94,255,255,235,1,144,160,227,5,112,160,225,36,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,
  89,255,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,84,255,255,235,4,240,157,228,1,144,160,227,
  40,0,86,229,192,0,16,227,2,0,0,26,40,112,69,226,7,128,140,224,207,253,255,235,1,144,160,227,4,0,86,229,
  192,0,16,227,2,0,0,26,4,112,69,226,7,128,140,224,200,253,255,235,1,144,160,227,4,0,214,229,192,0,16,227,
  2,0,0,26,4,112,133,226,7,128,140,224,193,253,255,235,1,144,160,227,40,0,214,229,192,0,16,227,2,0,0,26,
  40,112,133,226,7,128,140,224,186,253,255,235,1,144,160,227,5,112,160,225,44,112,71,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,128,140,224,178,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,173,253,255,235,
  1,144,160,227,5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,165,253,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,160,253,255,235,1,144,160,227,5,112,160,225,36,112,71,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,152,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,147,253,255,235,1,144,160,227,5,112,160,225,36,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,139,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,134,253,255,235,4,240,157,228,
  1,144,160,227,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,247,254,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,242,254,255,235,1,144,160,227,5,112,160,225,40,112,135,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,237,254,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,232,254,255,235,1,144,160,227,5,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,221,254,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,216,254,255,235,1,144,160,227,
  5,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,211,254,255,235,248,255,255,234,
  32,0,16,227,1,0,0,10,7,128,140,224,206,254,255,235,4,240,157,228,1,144,160,227,44,0,86,229,192,0,16,227,
  2,0,0,26,44,112,69,226,7,128,140,224,73,253,255,235,1,144,160,227,36,0,86,229,192,0,16,227,2,0,0,26,
  36,112,69,226,7,128,140,224,66,253,255,235,1,144,160,227,36,0,214,229,192,0,16,227,2,0,0,26,36,112,133,226,
  7,128,140,224,59,253,255,235,1,144,160,227,44,0,214,229,192,0,16,227,2,0,0,26,44,112,133,226,7,128,140,224,
  52,253,255,235,1,144,160,227,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,
  44,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,39,253,255,235,1,144,160,227,5,112,160,225,
  40,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,31,253,255,235,248,255,255,234,32,0,16,227,
  1,0,0,10,7,128,140,224,26,253,255,235,1,144,160,227,5,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,128,140,224,18,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,13,253,255,235,
  1,144,160,227,5,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,5,253,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,0,253,255,235,4,240,157,228,1,144,160,227,22,4,86,229,
  128,0,16,227,9,0,0,26,44,0,86,229,192,0,16,227,6,0,0,26,80,6,22,229,66,20,86,229,32,8,145,225,
  2,0,0,26,44,112,69,226,7,128,140,224,241,252,255,235,1,144,160,227,22,4,86,229,64,0,16,227,9,0,0,26,
  40,0,86,229,192,0,16,227,6,0,0,26,76,6,22,229,62,20,86,229,32,8,145,225,2,0,0,26,40,112,69,226,
  7,128,140,224,227,252,255,235,1,144,160,227,22,4,86,229,32,0,16,227,9,0,0,26,36,0,86,229,192,0,16,227,
  6,0,0,26,72,6,22,229,58,20,86,229,32,8,145,225,2,0,0,26,36,112,69,226,7,128,140,224,213,252,255,235,
  1,144,160,227,22,4,86,229,16,0,16,227,9,0,0,26,4,0,86,229,192,0,16,227,6,0,0,26,40,6,22,229,
  26,20,86,229,32,8,145,225,2,0,0,26,4,112,69,226,7,128,140,224,199,252,255,235,1,144,160,227,22,4,86,229,
  8,0,16,227,9,0,0,26,4,0,214,229,192,0,16,227,6,0,0,26,32,6,22,229,18,20,86,229,32,8,145,225,
  2,0,0,26,4,112,133,226,7,128,140,224,185,252,255,235,1,144,160,227,22,4,86,229,4,0,16,227,9,0,0,26,
  36,0,214,229,192,0,16,227,6,0,0,26,0,6,22,229,242,19,86,229,32,8,145,225,2,0,0,26,36,112,133,226,
  7,128,140,224,171,252,255,235,1,144,160,227,22,4,86,229,2,0,16,227,9,0,0,26,40,0,214,229,192,0,16,227,
  6,0,0,26,252,5,22,229,238,19,86,229,32,8,145,225,2,0,0,26,40,112,133,226,7,128,140,224,157,252,255,235,
  1,144,160,227,22,4,86,229,1,0,16,227,9,0,0,26,44,0,214,229,192,0,16,227,6,0,0,26,248,5,22,229,
  234,19,86,229,32,8,145,225,2,0,0,26,44,112,133,226,7,128,140,224,143,252,255,235,4,240,157,228,1,144,160,227,
  44,0,86,229,192,0,16,227,2,0,0,26,44,112,69,226,7,128,140,224,1,254,255,235,1,144,160,227,44,0,214,229,
  192,0,16,227,2,0,0,26,44,112,133,226,7,128,140,224,253,253,255,235,4,240,157,228,0,144,160,227,44,0,86,229,
  192,0,16,227,2,0,0,26,44,112,69,226,7,128,140,224,120,252,255,235,4,240,157,228,1,144,160,227,40,0,86,229,
  192,0,16,227,2,0,0,26,40,112,69,226,7,128,140,224,112,252,255,235,1,144,160,227,40,0,214,229,192,0,16,227,
  2,0,0,26,40,112,133,226,7,128,140,224,105,252,255,235,4,240,157,228,0,144,160,227,36,0,86,229,192,0,16,227,
  2,0,0,26,36,112,69,226,7,128,140,224,97,252,255,235,4,240,157,228,1,144,160,227,5,112,160,225,44,112,71,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,210,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,205,253,255,235,1,144,160,227,5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,200,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,195,253,255,235,4,240,157,228,
  1,144,160,227,5,112,160,225,44,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,61,252,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,56,252,255,235,1,144,160,227,5,112,160,225,44,112,135,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,48,252,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,43,252,255,235,4,240,157,228,1,144,160,227,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,128,140,224,156,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,151,253,255,235,
  1,144,160,227,5,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,146,253,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,141,253,255,235,4,240,157,228,1,144,160,227,44,0,86,229,
  192,0,16,227,2,0,0,26,44,112,69,226,7,128,140,224,8,252,255,235,1,144,160,227,44,0,214,229,192,0,16,227,
  2,0,0,26,44,112,133,226,7,128,140,224,1,252,255,235,4,240,157,228,1,144,160,227,5,112,160,225,40,112,71,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,248,251,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,243,251,255,235,1,144,160,227,5,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,235,251,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,230,251,255,235,4,240,157,228,
  1,144,160,227,36,0,86,229,192,0,16,227,2,0,0,26,36,112,69,226,7,128,140,224,222,251,255,235,1,144,160,227,
  36,0,214,229,192,0,16,227,2,0,0,26,36,112,133,226,7,128,140,224,215,251,255,235,4,240,157,228,4,224,45,229,
  0,0,160,227,108,6,12,229,104,6,12,229,140,82,159,229,140,98,159,229,60,144,160,227,4,0,149,228,4,0,134,228,
  1,144,89,226,251,255,255,26,164,0,0,235,204,26,28,229,200,42,28,229,196,58,28,229,192,74,28,229,184,90,28,229,
  100,22,12,229,96,38,12,229,92,54,12,229,88,70,12,229,84,86,12,229,4,8,28,229,0,0,80,227,62,0,0,218,
  64,82,159,229,64,98,159,229,60,144,160,227,4,0,149,228,4,0,134,228,1,144,89,226,251,255,255,26,4,24,28,229,
  0,40,28,229,252,55,28,229,248,71,28,229,244,87,28,229,240,103,28,229,28,24,12,229,24,40,12,229,20,56,12,229,
  16,72,12,229,12,88,12,229,8,104,12,229,131,0,0,235,204,26,28,229,200,42,28,229,196,58,28,229,192,74,28,229,
  184,90,28,229,80,22,12,229,76,38,12,229,72,54,12,229,68,70,12,229,64,86,12,229,236,7,28,229,0,0,80,227,
  29,0,0,218,196,81,159,229,196,97,159,229,60,144,160,227,4,0,149,228,4,0,134,228,1,144,89,226,251,255,255,26,
  236,23,28,229,232,39,28,229,228,55,28,229,224,71,28,229,220,87,28,229,216,103,28,229,28,24,12,229,24,40,12,229,
  20,56,12,229,16,72,12,229,12,88,12,229,8,104,12,229,98,0,0,235,204,26,28,229,200,42,28,229,196,58,28,229,
  192,74,28,229,184,90,28,229,60,22,12,229,56,38,12,229,52,54,12,229,48,70,12,229,44,86,12,229,84,81,159,229,
  84,97,159,229,60,144,160,227,4,0,149,228,4,0,134,228,1,144,89,226,251,255,255,26,100,22,28,229,96,6,28,229,
  0,16,65,224,92,6,28,229,0,16,129,224,88,6,28,229,0,16,65,224,80,38,28,229,76,6,28,229,0,32,66,224,
  72,6,28,229,0,32,130,224,68,6,28,229,0,32,66,224,60,54,28,229,56,6,28,229,0,48,67,224,52,6,28,229,
  0,48,131,224,48,6,28,229,0,48,67,224,4,8,28,229,0,0,80,227,6,0,0,218,2,0,81,225,22,0,0,186,
  236,7,28,229,0,0,80,227,1,0,0,218,3,0,81,225,37,0,0,186,100,22,28,229,96,38,28,229,92,54,28,229,
  88,70,28,229,84,86,28,229,204,26,12,229,200,42,12,229,196,58,12,229,192,74,12,229,184,90,12,229,28,8,28,229,
  2,0,80,227,4,240,157,212,12,8,28,229,108,6,12,229,8,8,28,229,104,6,12,229,4,240,157,228,236,7,28,229,
  0,0,80,227,1,0,0,218,3,0,82,225,14,0,0,186,80,22,28,229,76,38,28,229,72,54,28,229,68,70,28,229,
  64,86,28,229,204,26,12,229,200,42,12,229,196,58,12,229,192,74,12,229,184,90,12,229,244,7,28,229,108,6,12,229,
  240,7,28,229,104,6,12,229,4,240,157,228,220,7,28,229,108,6,12,229,216,7,28,229,104,6,12,229,4,240,157,228,
  100,12,0,224,84,13,0,224,84,13,0,224,100,12,0,224,84,13,0,224,100,12,0,224,84,13,0,224,100,12,0,224,
  0,112,160,227,204,122,12,229,200,122,12,229,196,122,12,229,192,122,12,229,184,122,12,229,12,88,28,229,8,104,28,229,
  208,7,28,229,5,0,80,225,2,0,0,10,204,7,28,229,6,0,80,225,2,0,0,26,212,119,12,229,208,119,12,229,
  204,119,12,229,196,7,28,229,5,0,80,225,2,0,0,10,192,7,28,229,6,0,80,225,2,0,0,26,200,119,12,229,
  196,119,12,229,192,119,12,229,184,7,28,229,5,0,80,225,2,0,0,10,180,7,28,229,6,0,80,225,2,0,0,26,
  188,119,12,229,184,119,12,229,180,119,12,229,172,7,28,229,5,0,80,225,2,0,0,10,168,7,28,229,6,0,80,225,
  2,0,0,26,176,119,12,229,172,119,12,229,168,119,12,229,160,7,28,229,5,0,80,225,2,0,0,10,156,7,28,229,
  6,0,80,225,2,0,0,26,164,119,12,229,160,119,12,229,156,119,12,229,68,86,159,229,5,96,160,225,5,144,160,227,
  3,128,160,227,0,0,21,229,0,0,80,227,7,0,0,10,0,0,21,229,4,0,134,228,4,0,149,229,4,0,134,228,
  8,0,149,229,4,0,134,228,1,128,88,226,2,0,0,10,12,80,133,226,1,144,89,226,241,255,255,26,12,88,28,229,
  8,104,28,229,6,0,149,225,45,0,0,26,28,8,28,229,0,0,80,227,42,0,0,10,112,8,28,229,0,0,80,227,
  15,0,0,26,132,8,28,229,128,8,12,229,120,40,28,229,100,8,28,229,2,0,80,225,2,0,0,26,108,120,12,229,
  104,120,12,229,100,120,12,229,80,8,28,229,2,0,80,225,80,0,0,26,88,120,12,229,84,120,12,229,80,120,12,229,
  76,0,0,234,128,120,12,229,124,120,12,229,120,120,12,229,124,56,28,229,112,72,28,229,104,8,28,229,3,0,80,225,
  5,0,0,26,92,8,28,229,4,0,80,225,2,0,0,26,108,120,12,229,104,120,12,229,100,120,12,229,84,8,28,229,
  3,0,80,225,59,0,0,26,72,8,28,229,4,0,80,225,56,0,0,26,88,120,12,229,84,120,12,229,80,120,12,229,
  52,0,0,234,5,160,140,224,36,54,218,229,37,70,218,229,24,8,28,229,0,0,80,227,1,48,131,18,6,32,140,224,
  12,34,82,229,1,0,18,227,9,0,0,26,120,8,28,229,5,0,80,225,9,0,0,26,4,0,83,225,0,0,160,227,
  116,8,28,53,128,8,12,229,124,120,12,229,120,120,12,229,2,0,0,234,128,120,12,229,124,120,12,229,120,120,12,229,
  2,0,18,227,9,0,0,26,100,8,28,229,5,0,80,225,9,0,0,26,4,0,83,225,0,0,160,227,96,8,28,53,
  108,8,12,229,104,120,12,229,100,120,12,229,2,0,0,234,108,120,12,229,104,120,12,229,100,120,12,229,4,0,18,227,
  9,0,0,26,80,8,28,229,5,0,80,225,9,0,0,26,4,0,83,225,0,0,160,227,76,8,28,53,88,8,12,229,
  84,120,12,229,80,120,12,229,2,0,0,234,88,120,12,229,84,120,12,229,80,120,12,229,128,8,28,229,108,40,28,229,
  2,0,80,225,9,0,0,170,128,40,12,229,108,8,12,229,124,8,28,229,104,40,28,229,124,40,12,229,104,8,12,229,
  120,8,28,229,100,40,28,229,120,40,12,229,100,8,12,229,108,8,28,229,88,40,28,229,2,0,80,225,9,0,0,170,
  108,40,12,229,88,8,12,229,104,8,28,229,84,40,28,229,104,40,12,229,84,8,12,229,100,8,28,229,80,40,28,229,
  100,40,12,229,80,8,12,229,128,8,28,229,108,40,28,229,2,0,80,225,9,0,0,170,128,40,12,229,108,8,12,229,
  124,8,28,229,104,40,28,229,124,40,12,229,104,8,12,229,120,8,28,229,100,40,28,229,120,40,12,229,100,8,12,229,
  16,8,28,229,20,40,28,229,28,56,28,229,2,0,128,224,1,0,80,227,1,0,0,42,1,0,83,227,1,0,160,51,
  204,10,12,229,124,88,28,229,120,104,28,229,212,71,28,229,208,7,28,229,6,0,80,225,2,0,0,10,204,7,28,229,
  5,0,80,225,14,0,0,26,200,71,28,229,196,7,28,229,6,0,80,225,2,0,0,10,192,7,28,229,5,0,80,225,
  7,0,0,26,188,71,28,229,184,7,28,229,6,0,80,225,2,0,0,10,180,7,28,229,5,0,80,225,0,0,0,26,
  0,64,160,227,212,7,28,229,4,0,64,224,128,72,28,229,4,0,128,224,2,0,80,225,17,0,0,170,4,48,67,224,
  184,58,12,229,108,8,28,229,104,88,28,229,100,104,28,229,88,8,12,229,84,88,12,229,80,104,12,229,128,8,28,229,
  124,88,28,229,120,104,28,229,108,8,12,229,104,88,12,229,100,104,12,229,128,40,12,229,124,120,12,229,120,120,12,229,
  85,0,0,234,2,48,67,224,184,58,12,229,124,88,28,229,120,104,28,229,104,8,28,229,5,0,80,225,2,0,0,10,
  100,8,28,229,6,0,80,225,2,0,0,26,108,120,12,229,104,120,12,229,100,120,12,229,84,8,28,229,5,0,80,225,
  2,0,0,10,80,8,28,229,6,0,80,225,2,0,0,26,88,120,12,229,84,120,12,229,80,120,12,229,108,8,28,229,
  0,0,80,227,8,0,0,26,88,8,28,229,108,8,12,229,84,8,28,229,104,8,12,229,80,8,28,229,100,8,12,229,
  88,120,12,229,84,120,12,229,80,120,12,229,108,8,28,229,2,0,80,225,8,0,0,42,108,8,28,229,88,8,12,229,
  104,8,28,229,84,8,12,229,100,8,28,229,80,8,12,229,108,40,12,229,104,120,12,229,100,120,12,229,208,7,28,229,
  6,0,80,225,2,0,0,10,204,7,28,229,5,0,80,225,33,0,0,26,128,8,28,229,1,0,80,227,1,0,160,51,
  200,10,12,229,196,7,28,229,6,0,80,225,9,0,0,10,192,7,28,229,5,0,80,225,6,0,0,10,200,7,28,229,
  196,87,28,229,192,103,28,229,212,7,12,229,208,87,12,229,204,103,12,229,67,0,0,234,184,7,28,229,6,0,80,225,
  9,0,0,10,180,7,28,229,5,0,80,225,6,0,0,10,188,7,28,229,184,87,28,229,180,103,28,229,212,7,12,229,
  208,87,12,229,204,103,12,229,54,0,0,234,212,119,12,229,208,119,12,229,204,119,12,229,50,0,0,234,128,8,28,229,
  1,0,80,227,1,0,160,227,128,8,12,181,204,103,28,229,6,160,140,224,60,10,218,229,0,0,80,227,5,0,0,26,
  9,2,90,229,0,0,80,227,2,0,0,10,128,8,28,229,200,10,12,229,35,0,0,234,200,39,28,229,196,87,28,229,
  192,103,28,229,204,7,28,229,6,0,80,225,8,0,0,26,188,39,28,229,184,87,28,229,180,103,28,229,204,7,28,229,
  6,0,80,225,2,0,0,26,0,32,160,227,0,80,160,227,0,96,160,227,212,71,28,229,2,64,68,224,128,8,28,229,
  0,0,84,225,232,255,255,218,200,122,12,229,212,39,12,229,208,87,12,229,204,103,12,229,108,40,28,229,104,88,28,229,
  100,104,28,229,88,40,12,229,84,88,12,229,80,104,12,229,128,40,28,229,124,88,28,229,120,104,28,229,108,40,12,229,
  104,88,12,229,100,104,12,229,212,23,28,229,108,40,28,229,88,56,28,229,208,87,28,229,204,103,28,229,1,0,81,227,
  1,16,160,211,1,0,82,227,1,32,160,211,1,0,83,227,1,48,160,211,104,8,28,229,6,0,80,225,2,0,0,10,
  100,8,28,229,5,0,80,225,10,0,0,26,196,26,12,229,1,0,160,227,192,10,12,229,84,8,28,229,6,0,80,225,
  14,240,160,1,80,8,28,229,5,0,80,225,14,240,160,1,192,58,12,229,14,240,160,225,3,64,160,225,84,8,28,229,
  6,0,80,225,2,0,0,10,80,8,28,229,5,0,80,225,0,0,0,26,1,64,160,227,2,64,68,224,0,64,100,226,
  1,0,84,225,2,0,0,202,196,26,12,229,192,42,12,229,14,240,160,225,196,122,12,229,192,58,12,229,14,240,160,225,
  20,13,0,224,4,224,45,229,64,0,45,233,61,171,255,235,0,177,255,235,53,176,255,235,64,0,189,232,80,11,28,229,
  0,0,80,227,1,0,0,10,4,224,157,228,102,16,0,234,152,95,28,229,84,0,85,227,9,0,0,58,5,128,140,224,
  0,0,88,229,30,0,0,226,13,18,216,229,1,0,128,225,128,0,143,224,228,252,144,229,152,95,24,229,84,0,85,227,
  245,255,255,42,78,25,0,235,4,240,157,228,40,0,88,229,192,0,16,227,5,0,0,26,40,112,69,226,204,0,87,227,
  7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,240,255,255,234,40,112,69,226,11,0,0,234,204,0,87,227,
  5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,7,3,160,225,
  37,1,128,224,4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,240,255,255,10,32,0,16,227,10,0,0,10,
  204,0,87,227,5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,
  7,3,160,225,37,1,128,224,4,0,134,228,209,255,255,234,84,0,88,229,192,0,16,227,11,0,0,26,84,112,69,226,
  204,0,87,227,5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,
  7,3,160,225,37,1,128,224,4,0,134,228,76,0,88,229,192,0,16,227,11,0,0,26,76,112,69,226,204,0,87,227,
  5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,7,3,160,225,
  37,1,128,224,4,0,134,228,178,255,255,234,44,0,88,229,192,0,16,227,9,0,0,26,44,112,69,226,204,0,87,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,
  44,0,216,229,192,0,16,227,9,0,0,26,44,112,133,226,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,40,0,88,229,192,0,16,227,9,0,0,26,
  40,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,
  37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,9,0,0,26,36,112,69,226,204,0,87,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,
  192,0,16,227,9,0,0,26,36,112,133,226,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,112,255,255,234,44,0,88,229,192,0,16,227,3,0,0,26,
  44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,88,229,192,0,16,227,3,0,0,26,40,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,40,0,216,229,192,0,16,227,3,0,0,26,40,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,
  4,0,134,228,4,0,88,229,192,0,16,227,3,0,0,26,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  4,0,216,229,192,0,16,227,3,0,0,26,4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,69,255,255,234,
  44,112,69,226,5,0,0,234,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,44,112,71,226,
  7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,
  128,0,128,50,4,0,134,228,44,112,133,226,5,0,0,234,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,
  4,0,134,228,44,112,135,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,
  7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,36,112,69,226,5,0,0,234,204,0,87,227,7,3,160,225,
  37,1,128,224,128,0,128,50,4,0,134,228,36,112,71,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,
  4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,36,112,133,226,5,0,0,234,
  204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,36,112,135,226,7,0,220,231,0,0,80,227,
  246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,
  252,254,255,234,40,0,88,229,192,0,16,227,3,0,0,26,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  40,0,216,229,192,0,16,227,3,0,0,26,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,88,229,
  192,0,16,227,3,0,0,26,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,216,229,192,0,16,227,
  3,0,0,26,4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,44,112,69,226,3,0,0,234,7,3,160,225,
  37,1,128,224,4,0,134,228,44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,44,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,36,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,36,112,71,226,7,0,220,231,
  0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,36,112,133,226,
  3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,36,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,
  32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,167,254,255,234,40,112,69,226,5,0,0,234,
  204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,
  246,255,255,10,32,0,16,227,4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,
  40,112,133,226,5,0,0,234,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,40,112,135,226,
  7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,7,3,160,225,37,1,128,224,
  128,0,128,50,4,0,134,228,4,112,69,226,5,0,0,234,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,
  4,0,134,228,4,112,71,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,87,227,
  7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,4,112,133,226,5,0,0,234,204,0,85,227,7,3,160,225,
  37,1,128,224,128,0,128,50,4,0,134,228,4,112,135,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,
  4,0,0,10,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,94,254,255,234,44,0,88,229,
  192,0,16,227,3,0,0,26,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,
  3,0,0,26,44,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,3,0,0,26,
  36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,192,0,16,227,3,0,0,26,36,112,133,226,
  7,3,160,225,37,1,128,224,4,0,134,228,40,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  40,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,40,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,40,112,135,226,7,0,220,231,
  0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,4,112,69,226,
  3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,4,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,4,112,133,226,3,0,0,234,7,3,160,225,
  37,1,128,224,4,0,134,228,4,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,9,254,255,234,44,0,88,229,192,0,16,227,7,0,0,26,80,6,24,229,
  66,20,88,229,32,8,145,225,3,0,0,26,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,88,229,
  192,0,16,227,7,0,0,26,76,6,24,229,62,20,88,229,32,8,145,225,3,0,0,26,40,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,7,0,0,26,72,6,24,229,58,20,88,229,32,8,145,225,
  3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,88,229,192,0,16,227,7,0,0,26,
  40,6,24,229,26,20,88,229,32,8,145,225,3,0,0,26,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  4,0,216,229,192,0,16,227,7,0,0,26,32,6,24,229,18,20,88,229,32,8,145,225,3,0,0,26,4,112,133,226,
  7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,192,0,16,227,7,0,0,26,0,6,24,229,242,19,88,229,
  32,8,145,225,3,0,0,26,36,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,216,229,192,0,16,227,
  7,0,0,26,252,5,24,229,238,19,88,229,32,8,145,225,3,0,0,26,40,112,133,226,7,3,160,225,37,1,128,224,
  4,0,134,228,44,0,216,229,192,0,16,227,7,0,0,26,248,5,24,229,234,19,88,229,32,8,145,225,3,0,0,26,
  44,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,176,253,255,234,44,0,88,229,192,0,16,227,9,0,0,26,
  44,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,
  37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,9,0,0,26,44,112,133,226,204,0,85,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,149,253,255,234,
  40,0,88,229,192,0,16,227,9,0,0,26,40,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,135,253,255,234,44,0,88,229,192,0,16,227,
  3,0,0,26,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,127,253,255,234,40,0,88,229,192,0,16,227,
  3,0,0,26,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,216,229,192,0,16,227,3,0,0,26,
  40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,112,253,255,234,36,0,88,229,192,0,16,227,3,0,0,26,
  36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,104,253,255,234,44,112,69,226,5,0,0,234,204,0,87,227,
  7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,44,112,71,226,7,0,220,231,0,0,80,227,246,255,255,10,
  32,0,16,227,4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,44,112,133,226,
  5,0,0,234,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,44,112,135,226,7,0,220,231,
  0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,
  4,0,134,228,67,253,255,234,44,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,44,112,71,226,
  7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  44,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,44,112,135,226,7,0,220,231,0,0,80,227,
  248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,38,253,255,234,40,112,69,226,
  5,0,0,234,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,40,112,71,226,7,0,220,231,
  0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,
  4,0,134,228,40,112,133,226,5,0,0,234,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,
  40,112,135,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,7,3,160,225,
  37,1,128,224,128,0,128,50,4,0,134,228,1,253,255,234,44,0,88,229,192,0,16,227,3,0,0,26,44,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,3,0,0,26,44,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,242,252,255,234,40,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  40,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,40,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,40,112,135,226,7,0,220,231,
  0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,213,252,255,234,
  36,0,88,229,192,0,16,227,3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,
  192,0,16,227,3,0,0,26,36,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,198,252,255,234,12,100,1,0,
  52,102,1,0,52,100,1,0,52,102,1,0,176,100,1,0,52,102,1,0,44,101,1,0,52,102,1,0,52,102,1,0,
  0,0,0,0,224,102,1,0,4,104,1,0,88,105,1,0,124,106,1,0,208,107,1,0,0,0,0,0,248,99,1,0,
  216,109,1,0,248,99,1,0,216,109,1,0,248,99,1,0,216,109,1,0,52,109,1,0,216,109,1,0,216,109,1,0,
  0,0,0,0,84,110,1,0,232,110,1,0,248,99,1,0,240,111,1,0,248,99,1,0,0,0,0,0,12,100,1,0,
  248,109,1,0,52,100,1,0,248,109,1,0,248,99,1,0,248,109,1,0,160,109,1,0,248,109,1,0,248,109,1,0,
  0,0,0,0,248,99,1,0,248,109,1,0,92,111,1,0,44,112,1,0,248,99,1,0,0,0,0,0,248,99,1,0,
  52,110,1,0,248,99,1,0,52,110,1,0,248,99,1,0,52,110,1,0,200,101,1,0,52,110,1,0,52,110,1,0,
  0,0,0,0,112,103,1,0,228,104,1,0,248,99,1,0,160,112,1,0,248,99,1,0,0,0,0,0,248,99,1,0,
  164,102,1,0,248,99,1,0,164,102,1,0,248,99,1,0,164,102,1,0,248,99,1,0,164,102,1,0,164,102,1,0,
  0,0,0,0,248,99,1,0,164,102,1,0,232,105,1,0,92,107,1,0,248,99,1,0,0,0,0,0,4,224,45,229,
  64,0,45,233,159,167,255,235,98,173,255,235,209,172,255,235,150,172,255,235,64,0,189,232,80,11,28,229,0,0,80,227,
  1,0,0,10,4,224,157,228,172,12,0,234,164,95,28,229,16,0,0,235,157,1,0,235,4,240,157,228,4,224,45,229,
  64,0,45,233,83,173,255,235,194,172,255,235,135,172,255,235,64,0,189,232,80,11,28,229,0,0,80,227,1,0,0,10,
  4,224,157,228,157,12,0,234,164,95,28,229,208,0,0,235,142,1,0,235,4,240,157,228,194,15,92,229,0,0,80,227,
  13,0,0,10,84,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,2,0,128,227,4,0,134,228,
  76,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,2,0,128,227,4,0,134,228,196,15,92,229,
  0,0,80,227,12,0,0,10,5,0,139,224,36,11,16,229,0,0,140,224,128,11,80,229,0,0,80,227,6,0,0,26,
  40,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,0,0,128,227,4,0,134,228,193,15,92,229,
  0,0,80,227,34,0,0,10,40,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,
  4,0,134,228,44,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,
  36,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,36,112,69,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,44,112,69,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,192,15,92,229,0,0,80,227,41,0,0,10,
  40,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,44,112,133,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,36,112,133,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,4,112,133,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,4,112,69,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,3,160,225,4,0,128,227,4,0,134,228,40,112,69,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,
  4,0,128,227,4,0,134,228,190,15,92,229,0,0,80,227,35,0,0,10,40,112,133,226,3,0,0,234,7,3,160,225,
  6,0,128,227,4,0,134,228,40,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,4,112,133,226,3,0,0,234,
  7,3,160,225,6,0,128,227,4,0,134,228,4,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,4,112,69,226,
  3,0,0,234,7,3,160,225,6,0,128,227,4,0,134,228,4,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  40,112,69,226,3,0,0,234,7,3,160,225,6,0,128,227,4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,
  248,255,255,10,191,15,92,229,0,0,80,227,35,0,0,10,44,112,133,226,3,0,0,234,7,3,160,225,5,0,128,227,
  4,0,134,228,44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,36,112,133,226,3,0,0,234,7,3,160,225,
  5,0,128,227,4,0,134,228,36,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,36,112,69,226,3,0,0,234,
  7,3,160,225,5,0,128,227,4,0,134,228,36,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,44,112,69,226,
  3,0,0,234,7,3,160,225,5,0,128,227,4,0,134,228,44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  195,15,92,229,0,0,80,227,8,0,0,10,40,112,133,226,3,0,0,234,7,3,160,225,1,0,128,227,4,0,134,228,
  40,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,14,240,160,225,194,15,92,229,0,0,80,227,13,0,0,10,
  84,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,2,0,128,227,4,0,134,228,76,112,133,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,2,0,128,227,4,0,134,228,193,15,92,229,0,0,80,227,
  34,0,0,10,40,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,
  44,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,36,112,133,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,36,112,69,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,44,112,69,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,192,15,92,229,0,0,80,227,41,0,0,10,40,112,133,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,44,112,133,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,36,112,133,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,4,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,3,160,225,4,0,128,227,4,0,134,228,4,112,69,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,
  4,0,128,227,4,0,134,228,40,112,69,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,
  4,0,134,228,190,15,92,229,0,0,80,227,35,0,0,10,40,112,133,226,3,0,0,234,7,3,160,225,6,0,128,227,
  4,0,134,228,40,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,4,112,133,226,3,0,0,234,7,3,160,225,
  6,0,128,227,4,0,134,228,4,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,4,112,69,226,3,0,0,234,
  7,3,160,225,6,0,128,227,4,0,134,228,4,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,40,112,69,226,
  3,0,0,234,7,3,160,225,6,0,128,227,4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  191,15,92,229,0,0,80,227,35,0,0,10,44,112,133,226,3,0,0,234,7,3,160,225,5,0,128,227,4,0,134,228,
  44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,36,112,133,226,3,0,0,234,7,3,160,225,5,0,128,227,
  4,0,134,228,36,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,36,112,69,226,3,0,0,234,7,3,160,225,
  5,0,128,227,4,0,134,228,36,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,44,112,69,226,3,0,0,234,
  7,3,160,225,5,0,128,227,4,0,134,228,44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,195,15,92,229,
  0,0,80,227,8,0,0,10,40,112,133,226,3,0,0,234,7,3,160,225,1,0,128,227,4,0,134,228,40,112,135,226,
  7,0,220,231,0,0,80,227,248,255,255,10,14,240,160,225,152,95,28,229,84,0,85,227,16,0,0,58,5,128,140,224,
  15,2,216,229,160,2,143,224,184,66,208,229,0,0,88,229,30,0,0,226,13,18,216,229,1,0,128,225,0,0,84,227,
  1,0,0,26,128,0,143,224,24,240,144,229,128,0,143,224,80,241,144,229,152,95,24,229,84,0,85,227,238,255,255,42,
  14,240,160,225,172,123,1,0,128,126,1,0,248,123,1,0,128,126,1,0,128,124,1,0,128,126,1,0,20,125,1,0,
  128,126,1,0,128,126,1,0,0,0,0,0,116,127,1,0,120,130,1,0,124,132,1,0,128,135,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,100,138,1,0,20,121,1,0,100,138,1,0,20,121,1,0,100,138,1,0,132,137,1,0,
  100,138,1,0,100,138,1,0,0,0,0,0,16,139,1,0,148,140,1,0,20,121,1,0,116,143,1,0,20,121,1,0,
  0,0,0,0,172,123,1,0,144,138,1,0,248,123,1,0,144,138,1,0,20,121,1,0,144,138,1,0,24,138,1,0,
  144,138,1,0,144,138,1,0,0,0,0,0,20,121,1,0,72,141,1,0,240,141,1,0,200,143,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,228,138,1,0,20,121,1,0,228,138,1,0,20,121,1,0,228,138,1,0,236,125,1,0,
  228,138,1,0,228,138,1,0,0,0,0,0,244,128,1,0,200,131,1,0,20,121,1,0,124,144,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,32,127,1,0,20,121,1,0,32,127,1,0,20,121,1,0,32,127,1,0,20,121,1,0,
  32,127,1,0,32,127,1,0,0,0,0,0,20,121,1,0,156,141,1,0,252,133,1,0,208,136,1,0,20,121,1,0,
  0,0,0,0,208,144,1,0,104,148,1,0,72,145,1,0,104,148,1,0,204,145,1,0,104,148,1,0,72,146,1,0,
  104,148,1,0,104,148,1,0,0,0,0,0,140,149,1,0,136,151,1,0,44,153,1,0,40,155,1,0,204,156,1,0,
  0,0,0,0,20,121,1,0,188,159,1,0,20,121,1,0,188,159,1,0,20,121,1,0,188,159,1,0,112,158,1,0,
  188,159,1,0,188,159,1,0,0,0,0,0,136,160,1,0,136,161,1,0,20,121,1,0,196,163,1,0,20,121,1,0,
  0,0,0,0,208,144,1,0,240,159,1,0,72,145,1,0,240,159,1,0,20,121,1,0,240,159,1,0,76,159,1,0,
  240,159,1,0,240,159,1,0,0,0,0,0,20,121,1,0,252,161,1,0,196,162,1,0,40,164,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,84,160,1,0,20,121,1,0,84,160,1,0,20,121,1,0,84,160,1,0,140,147,1,0,
  84,160,1,0,84,160,1,0,0,0,0,0,136,150,1,0,184,152,1,0,20,121,1,0,156,164,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,40,149,1,0,20,121,1,0,40,149,1,0,20,121,1,0,40,149,1,0,20,121,1,0,
  40,149,1,0,40,149,1,0,0,0,0,0,20,121,1,0,96,162,1,0,40,154,1,0,88,156,1,0,20,121,1,0,
  0,0,0,0,0,14,13,11,7,0,0,0,40,0,88,229,192,0,16,227,14,0,0,26,230,17,216,229,16,0,17,227,
  11,0,0,10,40,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  1,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,70,255,255,234,5,112,160,225,40,112,71,226,
  7,0,220,231,0,0,80,227,10,0,0,26,7,16,140,224,14,18,209,229,16,0,17,227,247,255,255,10,204,0,87,227,
  245,255,255,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,240,255,255,234,32,0,16,227,14,0,0,10,
  7,16,140,224,14,18,209,229,16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,2,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,36,255,255,234,
  84,0,88,229,192,0,16,227,14,0,0,26,84,112,69,226,186,17,216,229,16,0,17,227,5,0,0,10,204,0,87,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,4,0,17,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,76,0,88,229,192,0,16,227,14,0,0,26,76,112,69,226,194,17,216,229,16,0,17,227,
  5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,4,0,17,227,
  2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,255,254,255,234,44,0,88,229,192,0,16,227,14,0,0,26,
  44,112,69,226,226,17,216,229,16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,
  192,0,16,227,14,0,0,26,44,112,133,226,58,18,216,229,16,0,17,227,5,0,0,10,204,0,85,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,40,0,88,229,192,0,16,227,14,0,0,26,40,112,69,226,230,17,216,229,16,0,17,227,5,0,0,10,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,14,0,0,26,36,112,69,226,234,17,216,229,
  16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,192,0,16,227,14,0,0,26,
  36,112,133,226,50,18,216,229,16,0,17,227,5,0,0,10,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,164,254,255,234,
  226,1,216,229,16,0,16,227,6,0,0,10,44,0,88,229,192,0,16,227,3,0,0,26,44,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,230,1,216,229,16,0,16,227,6,0,0,10,40,0,88,229,192,0,16,227,3,0,0,26,
  40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,54,2,216,229,16,0,16,227,6,0,0,10,40,0,216,229,
  192,0,16,227,3,0,0,26,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,234,1,216,229,16,0,16,227,
  6,0,0,10,36,0,88,229,192,0,16,227,3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  10,2,216,229,16,0,16,227,6,0,0,10,4,0,88,229,192,0,16,227,3,0,0,26,4,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,18,2,216,229,16,0,16,227,6,0,0,10,4,0,216,229,192,0,16,227,3,0,0,26,
  4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,103,254,255,234,5,112,160,225,44,112,71,226,7,0,220,231,
  0,0,80,227,15,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,204,0,87,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,239,255,255,10,7,3,160,225,37,1,128,224,
  4,0,134,228,235,255,255,234,32,0,16,227,14,0,0,10,7,16,140,224,14,18,209,229,56,0,17,227,10,0,0,10,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,204,0,85,227,33,0,0,42,44,112,135,226,7,0,220,231,
  0,0,80,227,13,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,32,0,17,227,241,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,237,255,255,234,
  32,0,16,227,34,0,0,10,7,16,140,224,14,18,209,229,56,0,17,227,30,0,0,10,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,32,0,17,227,24,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,20,0,0,234,
  44,112,135,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,32,0,17,227,247,255,255,10,
  7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,
  32,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,36,112,71,226,7,0,220,231,
  0,0,80,227,15,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,204,0,87,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,239,255,255,10,7,3,160,225,37,1,128,224,
  4,0,134,228,235,255,255,234,32,0,16,227,14,0,0,10,7,16,140,224,14,18,209,229,56,0,17,227,10,0,0,10,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,204,0,85,227,33,0,0,42,36,112,135,226,7,0,220,231,
  0,0,80,227,13,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,32